% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{getAdjacencyBiogrid}
\alias{getAdjacencyBiogrid}
\title{Get a matrix of interactions of genes from biogrid}
\usage{
getAdjacencyBiogrid(tmp.biogrid, names.genes = NULL)
}
\arguments{
\item{tmp.biogrid}{Biogrid table}

\item{names.genes}{List of genes to filter from output. Default: consider all genes}
}
\value{
A matrix with 1 for genes that interacts, 0 for no interaction.
}
\description{
Using biogrid database, it will create a matrix of gene interactions.
If columns A and row B has value 1, it means the gene A and gene B interacts.
}
\examples{
names.genes.de <- c("PLCB1","MCL1","PRDX4","TTF2","TACC3", "PARP4","LSM1")
tmp.biogrid <- data.frame("Official.Symbol.Interactor.A" = names.genes.de,
                          "Official.Symbol.Interactor.B" = rev(names.genes.de))
net.biogrid.de <- getAdjacencyBiogrid(tmp.biogrid, names.genes.de)
\dontrun{
  file <- paste0("http://thebiogrid.org/downloads/archives/",
                 "Release\%20Archive/BIOGRID-3.4.133/BIOGRID-ALL-3.4.133.tab2.zip")
  downloader::download(file,basename(file))
  unzip(basename(file),junkpaths =TRUE)
  tmp.biogrid <- read.csv(gsub("zip","txt",basename(file)),
                          header=TRUE, sep="\t", stringsAsFactors=FALSE)
  names.genes.de <- c("PLCB1","MCL1","PRDX4","TTF2","TACC3", "PARP4","LSM1")
  net.biogrid.de <- getAdjacencyBiogrid(tmp.biogrid, names.genes.de)
}
}
