#!/usr/bin/env python3
# Copyright 2015 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""Tests for java_google_api_keys.py.

This test suite contains various tests for the C++ -> Java Google API Keys
generator.
"""

import unittest

import java_google_api_keys


class TestJavaGoogleAPIKeys(unittest.TestCase):
  def testOutput(self):
    definition = {'E1': 'abc', 'E2': 'defgh'}
    output = java_google_api_keys.GenerateOutput(definition)
    expected = """
// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by
//     %s
// From
//     google_api_keys/google_api_keys.h

package org.chromium.chrome;

public class GoogleAPIKeys {
  public static final String E1 = "abc";
  public static final String E2 = "defgh";
}
"""
    self.assertEqual(expected % java_google_api_keys.GetScriptName(), output)


if __name__ == '__main__':
  unittest.main()
