#ifndef __QAD_IMAGE_H__
#define __QAD_IMAGE_H__

#include <stdint.h>

#include "backend.h"

// BMP file header structure(pragma to ensure struct's memory layout matches
// file format)
#pragma pack(push, 1)
struct BMPHeader {
  uint16_t type;
  uint32_t size;
  uint16_t reserved1;
  uint16_t reserved2;
  uint32_t offset;
  uint32_t header_size;
  int32_t width;
  int32_t height;
  uint16_t planes;
  uint16_t bpp;
  uint32_t compression;
  uint32_t image_size;
  int32_t x_resolution;
  int32_t y_resolution;
  uint32_t colors;
  uint32_t important_colors;
};
#pragma pack(pop)

int encode_bmp(unsigned char *data, int width, int height, int stride,
               qad_screen_buffer_t *screen_buffer);

void write_png(void *ptr, int width, int height, int pitch, int bpp, int rgb,
               qad_screen_buffer_t *screen_buffer);

#endif
