# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Association(TrackedResource):
    """Association Subresource of Traffic Controller.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar association_type: Association Type. "subnets"
    :vartype association_type: str or ~azure.mgmt.servicenetworking.models.AssociationType
    :ivar subnet: Association Subnet.
    :vartype subnet: ~azure.mgmt.servicenetworking.models.AssociationSubnet
    :ivar provisioning_state: Provisioning State of Traffic Controller Association Resource. Known
     values are: "Provisioning", "Updating", "Deleting", "Accepted", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.servicenetworking.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "association_type": {"key": "properties.associationType", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "AssociationSubnet"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        association_type: Optional[Union[str, "_models.AssociationType"]] = None,
        subnet: Optional["_models.AssociationSubnet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword association_type: Association Type. "subnets"
        :paramtype association_type: str or ~azure.mgmt.servicenetworking.models.AssociationType
        :keyword subnet: Association Subnet.
        :paramtype subnet: ~azure.mgmt.servicenetworking.models.AssociationSubnet
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.association_type = association_type
        self.subnet = subnet
        self.provisioning_state = None


class AssociationListResult(_serialization.Model):
    """The response of a Association list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Association items on this page. Required.
    :vartype value: list[~azure.mgmt.servicenetworking.models.Association]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Association]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Association"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Association items on this page. Required.
        :paramtype value: list[~azure.mgmt.servicenetworking.models.Association]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssociationSubnet(_serialization.Model):
    """Association Subnet.

    All required parameters must be populated in order to send to server.

    :ivar id: Association ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Association ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class AssociationSubnetUpdate(_serialization.Model):
    """Association Subnet.

    :ivar id: Association ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Association ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class AssociationUpdate(_serialization.Model):
    """The type used for update operations of the Association.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar association_type: Association Type. "subnets"
    :vartype association_type: str or ~azure.mgmt.servicenetworking.models.AssociationType
    :ivar subnet: Association Subnet.
    :vartype subnet: ~azure.mgmt.servicenetworking.models.AssociationSubnetUpdate
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "association_type": {"key": "properties.associationType", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "AssociationSubnetUpdate"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        association_type: Optional[Union[str, "_models.AssociationType"]] = None,
        subnet: Optional["_models.AssociationSubnetUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword association_type: Association Type. "subnets"
        :paramtype association_type: str or ~azure.mgmt.servicenetworking.models.AssociationType
        :keyword subnet: Association Subnet.
        :paramtype subnet: ~azure.mgmt.servicenetworking.models.AssociationSubnetUpdate
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.association_type = association_type
        self.subnet = subnet


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.servicenetworking.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.servicenetworking.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.servicenetworking.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.servicenetworking.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Frontend(TrackedResource):
    """Frontend Sub Resource of Traffic Controller.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar fqdn: The Fully Qualified Domain Name of the DNS record associated to a Traffic
     Controller frontend.
    :vartype fqdn: str
    :ivar provisioning_state: Provisioning State of Traffic Controller Frontend Resource. Known
     values are: "Provisioning", "Updating", "Deleting", "Accepted", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.servicenetworking.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "fqdn": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.fqdn = None
        self.provisioning_state = None


class FrontendListResult(_serialization.Model):
    """The response of a Frontend list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Frontend items on this page. Required.
    :vartype value: list[~azure.mgmt.servicenetworking.models.Frontend]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Frontend]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Frontend"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Frontend items on this page. Required.
        :paramtype value: list[~azure.mgmt.servicenetworking.models.Frontend]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FrontendUpdate(_serialization.Model):
    """The type used for update operations of the Frontend.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.servicenetworking.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.servicenetworking.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.servicenetworking.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.servicenetworking.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.servicenetworking.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ResourceId(_serialization.Model):
    """Resource ID definition used by parent to reference child resources.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID of child resource. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of child resource. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SecurityPolicy(TrackedResource):
    """SecurityPolicy Subresource of Traffic Controller.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar policy_type: Type of the Traffic Controller Security Policy. "waf"
    :vartype policy_type: str or ~azure.mgmt.servicenetworking.models.PolicyType
    :ivar waf_policy: Web Application Firewall Policy of the Traffic Controller Security Policy.
    :vartype waf_policy: ~azure.mgmt.servicenetworking.models.WafPolicy
    :ivar provisioning_state: Provisioning State of Traffic Controller SecurityPolicy Resource.
     Known values are: "Provisioning", "Updating", "Deleting", "Accepted", "Succeeded", "Failed",
     and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.servicenetworking.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "policy_type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "waf_policy": {"key": "properties.wafPolicy", "type": "WafPolicy"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        waf_policy: Optional["_models.WafPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword waf_policy: Web Application Firewall Policy of the Traffic Controller Security Policy.
        :paramtype waf_policy: ~azure.mgmt.servicenetworking.models.WafPolicy
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.policy_type = None
        self.waf_policy = waf_policy
        self.provisioning_state = None


class SecurityPolicyConfigurations(_serialization.Model):
    """SecurityPolicyConfigurations Subresource of Traffic Controller.

    :ivar waf_security_policy: Contains reference to a WAF-type security policy that is applied at
     the Traffic Controller level.
    :vartype waf_security_policy: ~azure.mgmt.servicenetworking.models.WafSecurityPolicy
    """

    _attribute_map = {
        "waf_security_policy": {"key": "wafSecurityPolicy", "type": "WafSecurityPolicy"},
    }

    def __init__(self, *, waf_security_policy: Optional["_models.WafSecurityPolicy"] = None, **kwargs: Any) -> None:
        """
        :keyword waf_security_policy: Contains reference to a WAF-type security policy that is applied
         at the Traffic Controller level.
        :paramtype waf_security_policy: ~azure.mgmt.servicenetworking.models.WafSecurityPolicy
        """
        super().__init__(**kwargs)
        self.waf_security_policy = waf_security_policy


class SecurityPolicyConfigurationsUpdate(_serialization.Model):
    """SecurityPolicyConfigurations Subresource of Traffic Controller.

    :ivar waf_security_policy: Contains reference to a WAF-type security policy that is applied at
     the Traffic Controller level.
    :vartype waf_security_policy: ~azure.mgmt.servicenetworking.models.WafSecurityPolicyUpdate
    """

    _attribute_map = {
        "waf_security_policy": {"key": "wafSecurityPolicy", "type": "WafSecurityPolicyUpdate"},
    }

    def __init__(
        self, *, waf_security_policy: Optional["_models.WafSecurityPolicyUpdate"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword waf_security_policy: Contains reference to a WAF-type security policy that is applied
         at the Traffic Controller level.
        :paramtype waf_security_policy: ~azure.mgmt.servicenetworking.models.WafSecurityPolicyUpdate
        """
        super().__init__(**kwargs)
        self.waf_security_policy = waf_security_policy


class SecurityPolicyListResult(_serialization.Model):
    """The response of a SecurityPolicy list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The SecurityPolicy items on this page. Required.
    :vartype value: list[~azure.mgmt.servicenetworking.models.SecurityPolicy]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SecurityPolicy"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The SecurityPolicy items on this page. Required.
        :paramtype value: list[~azure.mgmt.servicenetworking.models.SecurityPolicy]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SecurityPolicyUpdate(_serialization.Model):
    """The type used for update operations of the SecurityPolicy.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar waf_policy: Web Application Firewall Policy of the Traffic Controller Security Policy.
    :vartype waf_policy: ~azure.mgmt.servicenetworking.models.WafPolicyUpdate
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "waf_policy": {"key": "properties.wafPolicy", "type": "WafPolicyUpdate"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        waf_policy: Optional["_models.WafPolicyUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword waf_policy: Web Application Firewall Policy of the Traffic Controller Security Policy.
        :paramtype waf_policy: ~azure.mgmt.servicenetworking.models.WafPolicyUpdate
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.waf_policy = waf_policy


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.servicenetworking.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.servicenetworking.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.servicenetworking.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.servicenetworking.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TrafficController(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Concrete tracked resource types can be created by aliasing this type using a specific property
    type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicenetworking.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar configuration_endpoints: Configuration Endpoints.
    :vartype configuration_endpoints: list[str]
    :ivar frontends: Frontends References List.
    :vartype frontends: list[~azure.mgmt.servicenetworking.models.ResourceId]
    :ivar associations: Associations References List.
    :vartype associations: list[~azure.mgmt.servicenetworking.models.ResourceId]
    :ivar security_policies: Security Policies References List.
    :vartype security_policies: list[~azure.mgmt.servicenetworking.models.ResourceId]
    :ivar security_policy_configurations: Security Policy Configuration.
    :vartype security_policy_configurations:
     ~azure.mgmt.servicenetworking.models.SecurityPolicyConfigurations
    :ivar provisioning_state: The status of the last operation. Known values are: "Provisioning",
     "Updating", "Deleting", "Accepted", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.servicenetworking.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "configuration_endpoints": {"readonly": True},
        "frontends": {"readonly": True},
        "associations": {"readonly": True},
        "security_policies": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "configuration_endpoints": {"key": "properties.configurationEndpoints", "type": "[str]"},
        "frontends": {"key": "properties.frontends", "type": "[ResourceId]"},
        "associations": {"key": "properties.associations", "type": "[ResourceId]"},
        "security_policies": {"key": "properties.securityPolicies", "type": "[ResourceId]"},
        "security_policy_configurations": {
            "key": "properties.securityPolicyConfigurations",
            "type": "SecurityPolicyConfigurations",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        security_policy_configurations: Optional["_models.SecurityPolicyConfigurations"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword security_policy_configurations: Security Policy Configuration.
        :paramtype security_policy_configurations:
         ~azure.mgmt.servicenetworking.models.SecurityPolicyConfigurations
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.configuration_endpoints = None
        self.frontends = None
        self.associations = None
        self.security_policies = None
        self.security_policy_configurations = security_policy_configurations
        self.provisioning_state = None


class TrafficControllerListResult(_serialization.Model):
    """The response of a TrafficController list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The TrafficController items on this page. Required.
    :vartype value: list[~azure.mgmt.servicenetworking.models.TrafficController]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TrafficController]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.TrafficController"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The TrafficController items on this page. Required.
        :paramtype value: list[~azure.mgmt.servicenetworking.models.TrafficController]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TrafficControllerUpdate(_serialization.Model):
    """The type used for update operations of the TrafficController.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar security_policy_configurations: Security Policy Configuration.
    :vartype security_policy_configurations:
     ~azure.mgmt.servicenetworking.models.SecurityPolicyConfigurationsUpdate
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "security_policy_configurations": {
            "key": "properties.securityPolicyConfigurations",
            "type": "SecurityPolicyConfigurationsUpdate",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        security_policy_configurations: Optional["_models.SecurityPolicyConfigurationsUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword security_policy_configurations: Security Policy Configuration.
        :paramtype security_policy_configurations:
         ~azure.mgmt.servicenetworking.models.SecurityPolicyConfigurationsUpdate
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.security_policy_configurations = security_policy_configurations


class WafPolicy(_serialization.Model):
    """Web Application Firewall Policy.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID of the WAF. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the WAF. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class WafPolicyUpdate(_serialization.Model):
    """Web Application Firewall Policy.

    :ivar id: Resource ID of the WAF.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the WAF.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class WafSecurityPolicy(_serialization.Model):
    """Web Application Firewall Security Policy.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID of the Waf Security Policy. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the Waf Security Policy. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class WafSecurityPolicyUpdate(_serialization.Model):
    """Web Application Firewall Security Policy.

    :ivar id: Resource ID of the Waf Security Policy.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the Waf Security Policy.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
