# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.aio import ApplicationClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApplicationJitRequestsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApplicationClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.jit_requests.get(
            resource_group_name=resource_group.name,
            jit_request_name="str",
            api_version="2019-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.jit_requests.begin_create_or_update(
                resource_group_name=resource_group.name,
                jit_request_name="str",
                parameters={
                    "applicationResourceId": "str",
                    "createdBy": {"applicationId": "str", "oid": "str", "puid": "str"},
                    "id": "str",
                    "jitAuthorizationPolicies": [{"principalId": "str", "roleDefinitionId": "str"}],
                    "jitRequestState": "str",
                    "jitSchedulingPolicy": {
                        "duration": "1 day, 0:00:00",
                        "startTime": "2020-02-20 00:00:00",
                        "type": "str",
                    },
                    "location": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "publisherTenantId": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                    "updatedBy": {"applicationId": "str", "oid": "str", "puid": "str"},
                },
                api_version="2019-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_update(self, resource_group):
        response = await self.client.jit_requests.update(
            resource_group_name=resource_group.name,
            jit_request_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2019-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete(self, resource_group):
        response = await self.client.jit_requests.delete(
            resource_group_name=resource_group.name,
            jit_request_name="str",
            api_version="2019-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_subscription(self, resource_group):
        response = await self.client.jit_requests.list_by_subscription(
            api_version="2019-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = await self.client.jit_requests.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2019-07-01",
        )

        # please add some check logic here by yourself
        # ...
