# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp.aio import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementAccountsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_subscription(self, resource_group):
        response = self.client.accounts.list_by_subscription(
            api_version="2024-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.accounts.list(
            resource_group_name=resource_group.name,
            api_version="2024-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.accounts.get(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.accounts.begin_create_or_update(
                resource_group_name=resource_group.name,
                account_name="str",
                body={
                    "location": "str",
                    "activeDirectories": [
                        {
                            "activeDirectoryId": "str",
                            "adName": "str",
                            "administrators": ["str"],
                            "aesEncryption": bool,
                            "allowLocalNfsUsersWithLdap": bool,
                            "backupOperators": ["str"],
                            "dns": "str",
                            "domain": "str",
                            "encryptDCConnections": bool,
                            "kdcIP": "str",
                            "ldapOverTLS": bool,
                            "ldapSearchScope": {"groupDN": "str", "groupMembershipFilter": "str", "userDN": "str"},
                            "ldapSigning": bool,
                            "organizationalUnit": "CN=Computers",
                            "password": "str",
                            "preferredServersForLdapClient": "str",
                            "securityOperators": ["str"],
                            "serverRootCACertificate": "str",
                            "site": "str",
                            "smbServerName": "str",
                            "status": "str",
                            "statusDetails": "str",
                            "username": "str",
                        }
                    ],
                    "disableShowmount": bool,
                    "encryption": {
                        "identity": {"federatedClientId": "str", "principalId": "str", "userAssignedIdentity": "str"},
                        "keySource": "Microsoft.NetApp",
                        "keyVaultProperties": {
                            "keyName": "str",
                            "keyVaultUri": "str",
                            "keyVaultId": "str",
                            "keyVaultResourceId": "str",
                            "status": "str",
                        },
                    },
                    "etag": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "isMultiAdEnabled": bool,
                    "name": "str",
                    "nfsV4IDDomain": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.accounts.begin_delete(
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.accounts.begin_update(
                resource_group_name=resource_group.name,
                account_name="str",
                body={
                    "activeDirectories": [
                        {
                            "activeDirectoryId": "str",
                            "adName": "str",
                            "administrators": ["str"],
                            "aesEncryption": bool,
                            "allowLocalNfsUsersWithLdap": bool,
                            "backupOperators": ["str"],
                            "dns": "str",
                            "domain": "str",
                            "encryptDCConnections": bool,
                            "kdcIP": "str",
                            "ldapOverTLS": bool,
                            "ldapSearchScope": {"groupDN": "str", "groupMembershipFilter": "str", "userDN": "str"},
                            "ldapSigning": bool,
                            "organizationalUnit": "CN=Computers",
                            "password": "str",
                            "preferredServersForLdapClient": "str",
                            "securityOperators": ["str"],
                            "serverRootCACertificate": "str",
                            "site": "str",
                            "smbServerName": "str",
                            "status": "str",
                            "statusDetails": "str",
                            "username": "str",
                        }
                    ],
                    "disableShowmount": bool,
                    "encryption": {
                        "identity": {"federatedClientId": "str", "principalId": "str", "userAssignedIdentity": "str"},
                        "keySource": "Microsoft.NetApp",
                        "keyVaultProperties": {
                            "keyName": "str",
                            "keyVaultUri": "str",
                            "keyVaultId": "str",
                            "keyVaultResourceId": "str",
                            "status": "str",
                        },
                    },
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "isMultiAdEnabled": bool,
                    "location": "str",
                    "name": "str",
                    "nfsV4IDDomain": "str",
                    "provisioningState": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_renew_credentials(self, resource_group):
        response = await (
            await self.client.accounts.begin_renew_credentials(
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_transition_to_cmk(self, resource_group):
        response = await (
            await self.client.accounts.begin_transition_to_cmk(
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_get_change_key_vault_information(self, resource_group):
        response = await (
            await self.client.accounts.begin_get_change_key_vault_information(
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_change_key_vault(self, resource_group):
        response = await (
            await self.client.accounts.begin_change_key_vault(
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
