# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventhub import EventHubManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventHubManagementConsumerGroupsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventHubManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update(self, resource_group):
        response = self.client.consumer_groups.create_or_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            consumer_group_name="str",
            parameters={
                "location": "str",
                "createdAt": "2020-02-20 00:00:00",
                "eventHubPath": "str",
                "name": "str",
                "type": "str",
                "updatedAt": "2020-02-20 00:00:00",
                "userMetadata": "str",
            },
            api_version="2015-08-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.consumer_groups.delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            consumer_group_name="str",
            api_version="2015-08-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.consumer_groups.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            consumer_group_name="str",
            api_version="2015-08-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_all(self, resource_group):
        response = self.client.consumer_groups.list_all(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            api_version="2015-08-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
