# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Literal, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccessKeys(_serialization.Model):
    """Namespace/EventHub Connection String.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_connection_string: Primary connection string of the created namespace
     AuthorizationRule.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: Secondary connection string of the created namespace
     AuthorizationRule.
    :vartype secondary_connection_string: str
    :ivar alias_primary_connection_string: Primary connection string of the alias if GEO DR is
     enabled.
    :vartype alias_primary_connection_string: str
    :ivar alias_secondary_connection_string: Secondary  connection string of the alias if GEO DR is
     enabled.
    :vartype alias_secondary_connection_string: str
    :ivar primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype primary_key: str
    :ivar secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype secondary_key: str
    :ivar key_name: A string that describes the AuthorizationRule.
    :vartype key_name: str
    """

    _validation = {
        "primary_connection_string": {"readonly": True},
        "secondary_connection_string": {"readonly": True},
        "alias_primary_connection_string": {"readonly": True},
        "alias_secondary_connection_string": {"readonly": True},
        "primary_key": {"readonly": True},
        "secondary_key": {"readonly": True},
        "key_name": {"readonly": True},
    }

    _attribute_map = {
        "primary_connection_string": {"key": "primaryConnectionString", "type": "str"},
        "secondary_connection_string": {"key": "secondaryConnectionString", "type": "str"},
        "alias_primary_connection_string": {"key": "aliasPrimaryConnectionString", "type": "str"},
        "alias_secondary_connection_string": {"key": "aliasSecondaryConnectionString", "type": "str"},
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.primary_connection_string = None
        self.secondary_connection_string = None
        self.alias_primary_connection_string = None
        self.alias_secondary_connection_string = None
        self.primary_key = None
        self.secondary_key = None
        self.key_name = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ArmDisasterRecovery(Resource):
    """Single item in List or Get Alias(Disaster Recovery configuration) operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the Alias(Disaster Recovery configuration) -
     possible values 'Accepted' or 'Succeeded' or 'Failed'. Known values are: "Accepted",
     "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.ProvisioningStateDR
    :ivar partner_namespace: ARM Id of the Primary/Secondary eventhub namespace name, which is part
     of GEO DR pairing.
    :vartype partner_namespace: str
    :ivar alternate_name: Alternate name specified when alias and namespace names are same.
    :vartype alternate_name: str
    :ivar role: role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating'
     or 'Secondary'. Known values are: "Primary", "PrimaryNotReplicating", and "Secondary".
    :vartype role: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.RoleDisasterRecovery
    :ivar pending_replication_operations_count: Number of entities pending to be replicated.
    :vartype pending_replication_operations_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "role": {"readonly": True},
        "pending_replication_operations_count": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "partner_namespace": {"key": "properties.partnerNamespace", "type": "str"},
        "alternate_name": {"key": "properties.alternateName", "type": "str"},
        "role": {"key": "properties.role", "type": "str"},
        "pending_replication_operations_count": {"key": "properties.pendingReplicationOperationsCount", "type": "int"},
    }

    def __init__(
        self, *, partner_namespace: Optional[str] = None, alternate_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword partner_namespace: ARM Id of the Primary/Secondary eventhub namespace name, which is
         part of GEO DR pairing.
        :paramtype partner_namespace: str
        :keyword alternate_name: Alternate name specified when alias and namespace names are same.
        :paramtype alternate_name: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.partner_namespace = partner_namespace
        self.alternate_name = alternate_name
        self.role = None
        self.pending_replication_operations_count = None


class ArmDisasterRecoveryListResult(_serialization.Model):
    """The result of the List Alias(Disaster Recovery configuration) operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Alias(Disaster Recovery configurations).
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.ArmDisasterRecovery]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Alias(Disaster Recovery configuration).
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ArmDisasterRecovery]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ArmDisasterRecovery"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of Alias(Disaster Recovery configurations).
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.ArmDisasterRecovery]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AuthorizationRule(Resource):
    """Single item in a List or Get AuthorizationRule operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar rights: The rights associated with the rule.
    :vartype rights: list[str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.AccessRights]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "rights": {"key": "properties.rights", "type": "[str]"},
    }

    def __init__(self, *, rights: Optional[List[Union[str, "_models.AccessRights"]]] = None, **kwargs: Any) -> None:
        """
        :keyword rights: The rights associated with the rule.
        :paramtype rights: list[str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.AccessRights]
        """
        super().__init__(**kwargs)
        self.rights = rights


class AuthorizationRuleListResult(_serialization.Model):
    """The response from the List namespace operation.

    :ivar value: Result of the List Authorization Rules operation.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.AuthorizationRule]
    :ivar next_link: Link to the next set of results. Not empty if Value contains an incomplete
     list of Authorization Rules.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AuthorizationRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AuthorizationRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Authorization Rules operation.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.AuthorizationRule]
        :keyword next_link: Link to the next set of results. Not empty if Value contains an incomplete
         list of Authorization Rules.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvailableCluster(_serialization.Model):
    """Pre-provisioned and readily available Event Hubs Cluster count per region.

    :ivar location: Location fo the Available Cluster.
    :vartype location: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: Location fo the Available Cluster.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location


class AvailableClustersList(_serialization.Model):
    """The response of the List Available Clusters operation.

    :ivar value: The count of readily available and pre-provisioned Event Hubs Clusters per region.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.AvailableCluster]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailableCluster]"},
    }

    def __init__(self, *, value: Optional[List["_models.AvailableCluster"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The count of readily available and pre-provisioned Event Hubs Clusters per
         region.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.AvailableCluster]
        """
        super().__init__(**kwargs)
        self.value = value


class CaptureDescription(_serialization.Model):
    """Properties to configure capture description for eventhub.

    :ivar enabled: A value that indicates whether capture description is enabled.
    :vartype enabled: bool
    :ivar encoding: Enumerates the possible values for the encoding format of capture description.
     Note: 'AvroDeflate' will be deprecated in New API Version. Known values are: "Avro" and
     "AvroDeflate".
    :vartype encoding: str or
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.EncodingCaptureDescription
    :ivar interval_in_seconds: The time window allows you to set the frequency with which the
     capture to Azure Blobs will happen, value should between 60 to 900 seconds.
    :vartype interval_in_seconds: int
    :ivar size_limit_in_bytes: The size window defines the amount of data built up in your Event
     Hub before an capture operation, value should be between 10485760 to 524288000 bytes.
    :vartype size_limit_in_bytes: int
    :ivar destination: Properties of Destination where capture will be stored. (Storage Account,
     Blob Names).
    :vartype destination: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Destination
    :ivar skip_empty_archives: A value that indicates whether to Skip Empty Archives.
    :vartype skip_empty_archives: bool
    """

    _validation = {
        "interval_in_seconds": {"maximum": 900, "minimum": 60},
        "size_limit_in_bytes": {"maximum": 524288000, "minimum": 10485760},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "encoding": {"key": "encoding", "type": "str"},
        "interval_in_seconds": {"key": "intervalInSeconds", "type": "int"},
        "size_limit_in_bytes": {"key": "sizeLimitInBytes", "type": "int"},
        "destination": {"key": "destination", "type": "Destination"},
        "skip_empty_archives": {"key": "skipEmptyArchives", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        encoding: Optional[Union[str, "_models.EncodingCaptureDescription"]] = None,
        interval_in_seconds: Optional[int] = None,
        size_limit_in_bytes: Optional[int] = None,
        destination: Optional["_models.Destination"] = None,
        skip_empty_archives: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: A value that indicates whether capture description is enabled.
        :paramtype enabled: bool
        :keyword encoding: Enumerates the possible values for the encoding format of capture
         description. Note: 'AvroDeflate' will be deprecated in New API Version. Known values are:
         "Avro" and "AvroDeflate".
        :paramtype encoding: str or
         ~azure.mgmt.eventhub.v2018_01_01_preview.models.EncodingCaptureDescription
        :keyword interval_in_seconds: The time window allows you to set the frequency with which the
         capture to Azure Blobs will happen, value should between 60 to 900 seconds.
        :paramtype interval_in_seconds: int
        :keyword size_limit_in_bytes: The size window defines the amount of data built up in your Event
         Hub before an capture operation, value should be between 10485760 to 524288000 bytes.
        :paramtype size_limit_in_bytes: int
        :keyword destination: Properties of Destination where capture will be stored. (Storage Account,
         Blob Names).
        :paramtype destination: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Destination
        :keyword skip_empty_archives: A value that indicates whether to Skip Empty Archives.
        :paramtype skip_empty_archives: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.encoding = encoding
        self.interval_in_seconds = interval_in_seconds
        self.size_limit_in_bytes = size_limit_in_bytes
        self.destination = destination
        self.skip_empty_archives = skip_empty_archives


class CheckNameAvailabilityParameter(_serialization.Model):
    """Parameter supplied to check Namespace name availability operation.

    All required parameters must be populated in order to send to server.

    :ivar name: Name to check the namespace name availability. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Name to check the namespace name availability. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResult(_serialization.Model):
    """The Result of the CheckNameAvailability operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: The detailed info regarding the reason associated with the Namespace.
    :vartype message: str
    :ivar name_available: Value indicating Namespace is availability, true if the Namespace is
     available; otherwise, false.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability of a Namespace. Known values are: "None",
     "InvalidName", "SubscriptionIsDisabled", "NameInUse", "NameInLockdown", and
     "TooManyNamespaceInCurrentSubscription".
    :vartype reason: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.UnavailableReason
    """

    _validation = {
        "message": {"readonly": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.UnavailableReason"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Value indicating Namespace is availability, true if the Namespace is
         available; otherwise, false.
        :paramtype name_available: bool
        :keyword reason: The reason for unavailability of a Namespace. Known values are: "None",
         "InvalidName", "SubscriptionIsDisabled", "NameInUse", "NameInLockdown", and
         "TooManyNamespaceInCurrentSubscription".
        :paramtype reason: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.UnavailableReason
        """
        super().__init__(**kwargs)
        self.message = None
        self.name_available = name_available
        self.reason = reason


class TrackedResource(Resource):
    """Definition of resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class Cluster(TrackedResource):
    """Single Event Hubs Cluster resource in List or Get operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Properties of the cluster SKU.
    :vartype sku: ~azure.mgmt.eventhub.v2018_01_01_preview.models.ClusterSku
    :ivar created_at: The UTC time when the Event Hubs Cluster was created.
    :vartype created_at: str
    :ivar updated_at: The UTC time when the Event Hubs Cluster was last updated.
    :vartype updated_at: str
    :ivar metric_id: The metric ID of the cluster resource. Provided by the service and not
     modifiable by the user.
    :vartype metric_id: str
    :ivar status: Status of the Cluster resource.
    :vartype status: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "metric_id": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ClusterSku"},
        "created_at": {"key": "properties.createdAt", "type": "str"},
        "updated_at": {"key": "properties.updatedAt", "type": "str"},
        "metric_id": {"key": "properties.metricId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ClusterSku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Properties of the cluster SKU.
        :paramtype sku: ~azure.mgmt.eventhub.v2018_01_01_preview.models.ClusterSku
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.created_at = None
        self.updated_at = None
        self.metric_id = None
        self.status = None


class ClusterListResult(_serialization.Model):
    """The response of the List Event Hubs Clusters operation.

    :ivar value: The Event Hubs Clusters present in the List Event Hubs operation results.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.Cluster]
    :ivar next_link: Link to the next set of results. Empty unless the value parameter contains an
     incomplete list of Event Hubs Clusters.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Cluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Cluster"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The Event Hubs Clusters present in the List Event Hubs operation results.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.Cluster]
        :keyword next_link: Link to the next set of results. Empty unless the value parameter contains
         an incomplete list of Event Hubs Clusters.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ClusterQuotaConfigurationProperties(_serialization.Model):
    """Contains all settings for the cluster.

    :ivar settings: All possible Cluster settings - a collection of key/value paired settings which
     apply to quotas and configurations imposed on the cluster.
    :vartype settings: dict[str, str]
    """

    _attribute_map = {
        "settings": {"key": "settings", "type": "{str}"},
    }

    def __init__(self, *, settings: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword settings: All possible Cluster settings - a collection of key/value paired settings
         which apply to quotas and configurations imposed on the cluster.
        :paramtype settings: dict[str, str]
        """
        super().__init__(**kwargs)
        self.settings = settings


class ClusterSku(_serialization.Model):
    """SKU parameters particular to a cluster instance.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of this SKU. Required. "Dedicated"
    :vartype name: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.ClusterSkuName
    :ivar capacity: The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
        "capacity": {"minimum": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Union[str, "_models.ClusterSkuName"], capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of this SKU. Required. "Dedicated"
        :paramtype name: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.ClusterSkuName
        :keyword capacity: The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class ConnectionState(_serialization.Model):
    """ConnectionState information.

    :ivar status: Status of the connection. Known values are: "Pending", "Approved", "Rejected",
     and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateLinkConnectionStatus
    :ivar description: Description of the connection state.
    :vartype description: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateLinkConnectionStatus"]] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the connection. Known values are: "Pending", "Approved", "Rejected",
         and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateLinkConnectionStatus
        :keyword description: Description of the connection state.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description


class ConsumerGroup(Resource):
    """Single item in List or Get Consumer group operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar created_at: Exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar user_metadata: User Metadata is a placeholder to store user-defined string data with
     maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and
     their contact information also user-defined configuration settings can be stored.
    :vartype user_metadata: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "user_metadata": {"key": "properties.userMetadata", "type": "str"},
    }

    def __init__(self, *, user_metadata: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword user_metadata: User Metadata is a placeholder to store user-defined string data with
         maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and
         their contact information also user-defined configuration settings can be stored.
        :paramtype user_metadata: str
        """
        super().__init__(**kwargs)
        self.created_at = None
        self.updated_at = None
        self.user_metadata = user_metadata


class ConsumerGroupListResult(_serialization.Model):
    """The result to the List Consumer Group operation.

    :ivar value: Result of the List Consumer Group operation.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.ConsumerGroup]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Consumer Group.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConsumerGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ConsumerGroup"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Consumer Group operation.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.ConsumerGroup]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of Consumer Group.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Destination(_serialization.Model):
    """Capture storage details for capture description.

    :ivar name: Name for capture destination.
    :vartype name: str
    :ivar storage_account_resource_id: Resource id of the storage account to be used to create the
     blobs.
    :vartype storage_account_resource_id: str
    :ivar blob_container: Blob container Name.
    :vartype blob_container: str
    :ivar archive_name_format: Blob naming convention for archive, e.g.
     {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all
     the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order.
    :vartype archive_name_format: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "storage_account_resource_id": {"key": "properties.storageAccountResourceId", "type": "str"},
        "blob_container": {"key": "properties.blobContainer", "type": "str"},
        "archive_name_format": {"key": "properties.archiveNameFormat", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        storage_account_resource_id: Optional[str] = None,
        blob_container: Optional[str] = None,
        archive_name_format: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name for capture destination.
        :paramtype name: str
        :keyword storage_account_resource_id: Resource id of the storage account to be used to create
         the blobs.
        :paramtype storage_account_resource_id: str
        :keyword blob_container: Blob container Name.
        :paramtype blob_container: str
        :keyword archive_name_format: Blob naming convention for archive, e.g.
         {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all
         the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order.
        :paramtype archive_name_format: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.storage_account_resource_id = storage_account_resource_id
        self.blob_container = blob_container
        self.archive_name_format = archive_name_format


class EHNamespace(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Single Namespace item in List or Get Operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Properties of sku resource.
    :vartype sku: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Sku
    :ivar identity: Properties of BYOK Identity description.
    :vartype identity: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Identity
    :ivar provisioning_state: Provisioning state of the Namespace.
    :vartype provisioning_state: str
    :ivar status: Status of the Namespace.
    :vartype status: str
    :ivar created_at: The time the Namespace was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The time the Namespace was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
    :vartype service_bus_endpoint: str
    :ivar cluster_arm_id: Cluster ARM ID of the Namespace.
    :vartype cluster_arm_id: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    :ivar is_auto_inflate_enabled: Value that indicates whether AutoInflate is enabled for eventhub
     namespace.
    :vartype is_auto_inflate_enabled: bool
    :ivar maximum_throughput_units: Upper limit of throughput units when AutoInflate is enabled,
     value should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled = true).
    :vartype maximum_throughput_units: int
    :ivar kafka_enabled: Value that indicates whether Kafka is enabled for eventhub namespace.
    :vartype kafka_enabled: bool
    :ivar zone_redundant: Enabling this property creates a Standard Event Hubs Namespace in regions
     supported availability zones.
    :vartype zone_redundant: bool
    :ivar encryption: Properties of BYOK Encryption description.
    :vartype encryption: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Encryption
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "service_bus_endpoint": {"readonly": True},
        "metric_id": {"readonly": True},
        "maximum_throughput_units": {"maximum": 20, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "service_bus_endpoint": {"key": "properties.serviceBusEndpoint", "type": "str"},
        "cluster_arm_id": {"key": "properties.clusterArmId", "type": "str"},
        "metric_id": {"key": "properties.metricId", "type": "str"},
        "is_auto_inflate_enabled": {"key": "properties.isAutoInflateEnabled", "type": "bool"},
        "maximum_throughput_units": {"key": "properties.maximumThroughputUnits", "type": "int"},
        "kafka_enabled": {"key": "properties.kafkaEnabled", "type": "bool"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        cluster_arm_id: Optional[str] = None,
        is_auto_inflate_enabled: Optional[bool] = None,
        maximum_throughput_units: Optional[int] = None,
        kafka_enabled: Optional[bool] = None,
        zone_redundant: Optional[bool] = None,
        encryption: Optional["_models.Encryption"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Properties of sku resource.
        :paramtype sku: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Sku
        :keyword identity: Properties of BYOK Identity description.
        :paramtype identity: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Identity
        :keyword cluster_arm_id: Cluster ARM ID of the Namespace.
        :paramtype cluster_arm_id: str
        :keyword is_auto_inflate_enabled: Value that indicates whether AutoInflate is enabled for
         eventhub namespace.
        :paramtype is_auto_inflate_enabled: bool
        :keyword maximum_throughput_units: Upper limit of throughput units when AutoInflate is enabled,
         value should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled = true).
        :paramtype maximum_throughput_units: int
        :keyword kafka_enabled: Value that indicates whether Kafka is enabled for eventhub namespace.
        :paramtype kafka_enabled: bool
        :keyword zone_redundant: Enabling this property creates a Standard Event Hubs Namespace in
         regions supported availability zones.
        :paramtype zone_redundant: bool
        :keyword encryption: Properties of BYOK Encryption description.
        :paramtype encryption: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Encryption
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.provisioning_state = None
        self.status = None
        self.created_at = None
        self.updated_at = None
        self.service_bus_endpoint = None
        self.cluster_arm_id = cluster_arm_id
        self.metric_id = None
        self.is_auto_inflate_enabled = is_auto_inflate_enabled
        self.maximum_throughput_units = maximum_throughput_units
        self.kafka_enabled = kafka_enabled
        self.zone_redundant = zone_redundant
        self.encryption = encryption


class EHNamespaceIdContainer(_serialization.Model):
    """The full ARM ID of an Event Hubs Namespace.

    :ivar id: id parameter.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: id parameter.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class EHNamespaceIdListResult(_serialization.Model):
    """The response of the List Namespace IDs operation.

    :ivar value: Result of the List Namespace IDs operation.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.EHNamespaceIdContainer]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EHNamespaceIdContainer]"},
    }

    def __init__(self, *, value: Optional[List["_models.EHNamespaceIdContainer"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Result of the List Namespace IDs operation.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.EHNamespaceIdContainer]
        """
        super().__init__(**kwargs)
        self.value = value


class EHNamespaceListResult(_serialization.Model):
    """The response of the List Namespace operation.

    :ivar value: Result of the List Namespace operation.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.EHNamespace]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of namespaces.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EHNamespace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.EHNamespace"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Namespace operation.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.EHNamespace]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of namespaces.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Encryption(_serialization.Model):
    """Properties to configure Encryption.

    :ivar key_vault_properties: Properties of KeyVault.
    :vartype key_vault_properties:
     list[~azure.mgmt.eventhub.v2018_01_01_preview.models.KeyVaultProperties]
    :ivar key_source: Enumerates the possible value of keySource for Encryption. Default value is
     "Microsoft.KeyVault".
    :vartype key_source: str
    """

    _attribute_map = {
        "key_vault_properties": {"key": "keyVaultProperties", "type": "[KeyVaultProperties]"},
        "key_source": {"key": "keySource", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_vault_properties: Optional[List["_models.KeyVaultProperties"]] = None,
        key_source: Literal["Microsoft.KeyVault"] = "Microsoft.KeyVault",
        **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_properties: Properties of KeyVault.
        :paramtype key_vault_properties:
         list[~azure.mgmt.eventhub.v2018_01_01_preview.models.KeyVaultProperties]
        :keyword key_source: Enumerates the possible value of keySource for Encryption. Default value
         is "Microsoft.KeyVault".
        :paramtype key_source: str
        """
        super().__init__(**kwargs)
        self.key_vault_properties = key_vault_properties
        self.key_source = key_source


class ErrorResponse(_serialization.Model):
    """Error response indicates Event Hub service is not able to process the incoming request. The
    reason is provided in the error message.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class Eventhub(Resource):
    """Single item in List or Get Event Hub operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar partition_ids: Current number of shards on the Event Hub.
    :vartype partition_ids: list[str]
    :ivar created_at: Exact time the Event Hub was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar message_retention_in_days: Number of days to retain the events for this Event Hub, value
     should be 1 to 7 days.
    :vartype message_retention_in_days: int
    :ivar partition_count: Number of partitions created for the Event Hub, allowed values are from
     1 to 32 partitions.
    :vartype partition_count: int
    :ivar status: Enumerates the possible values for the status of the Event Hub. Known values are:
     "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating", "Deleting",
     "Renaming", and "Unknown".
    :vartype status: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.EntityStatus
    :ivar capture_description: Properties of capture description.
    :vartype capture_description:
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.CaptureDescription
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "partition_ids": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "message_retention_in_days": {"minimum": 1},
        "partition_count": {"minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "partition_ids": {"key": "properties.partitionIds", "type": "[str]"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "message_retention_in_days": {"key": "properties.messageRetentionInDays", "type": "int"},
        "partition_count": {"key": "properties.partitionCount", "type": "int"},
        "status": {"key": "properties.status", "type": "str"},
        "capture_description": {"key": "properties.captureDescription", "type": "CaptureDescription"},
    }

    def __init__(
        self,
        *,
        message_retention_in_days: Optional[int] = None,
        partition_count: Optional[int] = None,
        status: Optional[Union[str, "_models.EntityStatus"]] = None,
        capture_description: Optional["_models.CaptureDescription"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword message_retention_in_days: Number of days to retain the events for this Event Hub,
         value should be 1 to 7 days.
        :paramtype message_retention_in_days: int
        :keyword partition_count: Number of partitions created for the Event Hub, allowed values are
         from 1 to 32 partitions.
        :paramtype partition_count: int
        :keyword status: Enumerates the possible values for the status of the Event Hub. Known values
         are: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
         "Deleting", "Renaming", and "Unknown".
        :paramtype status: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.EntityStatus
        :keyword capture_description: Properties of capture description.
        :paramtype capture_description:
         ~azure.mgmt.eventhub.v2018_01_01_preview.models.CaptureDescription
        """
        super().__init__(**kwargs)
        self.partition_ids = None
        self.created_at = None
        self.updated_at = None
        self.message_retention_in_days = message_retention_in_days
        self.partition_count = partition_count
        self.status = status
        self.capture_description = capture_description


class EventHubListResult(_serialization.Model):
    """The result of the List EventHubs operation.

    :ivar value: Result of the List EventHubs operation.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.Eventhub]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of EventHubs.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Eventhub]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Eventhub"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List EventHubs operation.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.Eventhub]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of EventHubs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Identity(_serialization.Model):
    """Properties to configure Identity for Bring your Own Keys.

    :ivar principal_id: ObjectId from the KeyVault.
    :vartype principal_id: str
    :ivar tenant_id: TenantId from the KeyVault.
    :vartype tenant_id: str
    :ivar type: Enumerates the possible value Identity type, which currently supports only
     'SystemAssigned'. Default value is "SystemAssigned".
    :vartype type: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        type: Literal["SystemAssigned"] = "SystemAssigned",
        **kwargs: Any
    ) -> None:
        """
        :keyword principal_id: ObjectId from the KeyVault.
        :paramtype principal_id: str
        :keyword tenant_id: TenantId from the KeyVault.
        :paramtype tenant_id: str
        :keyword type: Enumerates the possible value Identity type, which currently supports only
         'SystemAssigned'. Default value is "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.type = type


class IpFilterRule(Resource):
    """Single item in a List or Get IpFilterRules operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar ip_mask: IP Mask.
    :vartype ip_mask: str
    :ivar action: The IP Filter Action. Known values are: "Accept" and "Reject".
    :vartype action: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.IPAction
    :ivar filter_name: IP Filter name.
    :vartype filter_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "ip_mask": {"key": "properties.ipMask", "type": "str"},
        "action": {"key": "properties.action", "type": "str"},
        "filter_name": {"key": "properties.filterName", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_mask: Optional[str] = None,
        action: Optional[Union[str, "_models.IPAction"]] = None,
        filter_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_mask: IP Mask.
        :paramtype ip_mask: str
        :keyword action: The IP Filter Action. Known values are: "Accept" and "Reject".
        :paramtype action: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.IPAction
        :keyword filter_name: IP Filter name.
        :paramtype filter_name: str
        """
        super().__init__(**kwargs)
        self.ip_mask = ip_mask
        self.action = action
        self.filter_name = filter_name


class IpFilterRuleListResult(_serialization.Model):
    """The response from the List namespace operation.

    :ivar value: Result of the List IpFilter Rules operation.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.IpFilterRule]
    :ivar next_link: Link to the next set of results. Not empty if Value contains an incomplete
     list of IpFilter Rules.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IpFilterRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.IpFilterRule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List IpFilter Rules operation.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.IpFilterRule]
        :keyword next_link: Link to the next set of results. Not empty if Value contains an incomplete
         list of IpFilter Rules.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class KeyVaultProperties(_serialization.Model):
    """Properties to configure keyVault Properties.

    :ivar key_name: Name of the Key from KeyVault.
    :vartype key_name: str
    :ivar key_vault_uri: Uri of KeyVault.
    :vartype key_vault_uri: str
    :ivar key_version: Key Version.
    :vartype key_version: str
    """

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        key_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_name: Name of the Key from KeyVault.
        :paramtype key_name: str
        :keyword key_vault_uri: Uri of KeyVault.
        :paramtype key_vault_uri: str
        :keyword key_version: Key Version.
        :paramtype key_version: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.key_vault_uri = key_vault_uri
        self.key_version = key_version


class MessagingRegions(TrackedResource):
    """Messaging Region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of Messaging Region.
    :vartype properties: ~azure.mgmt.eventhub.v2018_01_01_preview.models.MessagingRegionsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "MessagingRegionsProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.MessagingRegionsProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of Messaging Region.
        :paramtype properties:
         ~azure.mgmt.eventhub.v2018_01_01_preview.models.MessagingRegionsProperties
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class MessagingRegionsListResult(_serialization.Model):
    """The response of the List MessagingRegions operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Result of the List MessagingRegions type.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.MessagingRegions]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of MessagingRegions.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MessagingRegions]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.MessagingRegions"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Result of the List MessagingRegions type.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.MessagingRegions]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class MessagingRegionsProperties(_serialization.Model):
    """Properties of Messaging Region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Region code.
    :vartype code: str
    :ivar full_name: Full name of the region.
    :vartype full_name: str
    """

    _validation = {
        "code": {"readonly": True},
        "full_name": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "full_name": {"key": "fullName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.full_name = None


class NetworkRuleSet(Resource):
    """Description of topic resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar trusted_service_access_enabled: Value that indicates whether Trusted Service Access is
     Enabled or not.
    :vartype trusted_service_access_enabled: bool
    :ivar default_action: Default Action for Network Rule Set. Known values are: "Allow" and
     "Deny".
    :vartype default_action: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.DefaultAction
    :ivar virtual_network_rules: List VirtualNetwork Rules.
    :vartype virtual_network_rules:
     list[~azure.mgmt.eventhub.v2018_01_01_preview.models.NWRuleSetVirtualNetworkRules]
    :ivar ip_rules: List of IpRules.
    :vartype ip_rules: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.NWRuleSetIpRules]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "trusted_service_access_enabled": {"key": "properties.trustedServiceAccessEnabled", "type": "bool"},
        "default_action": {"key": "properties.defaultAction", "type": "str"},
        "virtual_network_rules": {"key": "properties.virtualNetworkRules", "type": "[NWRuleSetVirtualNetworkRules]"},
        "ip_rules": {"key": "properties.ipRules", "type": "[NWRuleSetIpRules]"},
    }

    def __init__(
        self,
        *,
        trusted_service_access_enabled: Optional[bool] = None,
        default_action: Optional[Union[str, "_models.DefaultAction"]] = None,
        virtual_network_rules: Optional[List["_models.NWRuleSetVirtualNetworkRules"]] = None,
        ip_rules: Optional[List["_models.NWRuleSetIpRules"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword trusted_service_access_enabled: Value that indicates whether Trusted Service Access is
         Enabled or not.
        :paramtype trusted_service_access_enabled: bool
        :keyword default_action: Default Action for Network Rule Set. Known values are: "Allow" and
         "Deny".
        :paramtype default_action: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.DefaultAction
        :keyword virtual_network_rules: List VirtualNetwork Rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.eventhub.v2018_01_01_preview.models.NWRuleSetVirtualNetworkRules]
        :keyword ip_rules: List of IpRules.
        :paramtype ip_rules: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.NWRuleSetIpRules]
        """
        super().__init__(**kwargs)
        self.trusted_service_access_enabled = trusted_service_access_enabled
        self.default_action = default_action
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules


class NWRuleSetIpRules(_serialization.Model):
    """The response from the List namespace operation.

    :ivar ip_mask: IP Mask.
    :vartype ip_mask: str
    :ivar action: The IP Filter Action. "Allow"
    :vartype action: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.NetworkRuleIPAction
    """

    _attribute_map = {
        "ip_mask": {"key": "ipMask", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_mask: Optional[str] = None,
        action: Optional[Union[str, "_models.NetworkRuleIPAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_mask: IP Mask.
        :paramtype ip_mask: str
        :keyword action: The IP Filter Action. "Allow"
        :paramtype action: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.NetworkRuleIPAction
        """
        super().__init__(**kwargs)
        self.ip_mask = ip_mask
        self.action = action


class NWRuleSetVirtualNetworkRules(_serialization.Model):
    """The response from the List namespace operation.

    :ivar subnet: Subnet properties.
    :vartype subnet: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Subnet
    :ivar ignore_missing_vnet_service_endpoint: Value that indicates whether to ignore missing Vnet
     Service Endpoint.
    :vartype ignore_missing_vnet_service_endpoint: bool
    """

    _attribute_map = {
        "subnet": {"key": "subnet", "type": "Subnet"},
        "ignore_missing_vnet_service_endpoint": {"key": "ignoreMissingVnetServiceEndpoint", "type": "bool"},
    }

    def __init__(
        self,
        *,
        subnet: Optional["_models.Subnet"] = None,
        ignore_missing_vnet_service_endpoint: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet: Subnet properties.
        :paramtype subnet: ~azure.mgmt.eventhub.v2018_01_01_preview.models.Subnet
        :keyword ignore_missing_vnet_service_endpoint: Value that indicates whether to ignore missing
         Vnet Service Endpoint.
        :paramtype ignore_missing_vnet_service_endpoint: bool
        """
        super().__init__(**kwargs)
        self.subnet = subnet
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint


class Operation(_serialization.Model):
    """A Event Hub REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.eventhub.v2018_01_01_preview.models.OperationDisplay
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.eventhub.v2018_01_01_preview.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.EventHub.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Invoice, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationListResult(_serialization.Model):
    """Result of the request to list Event Hub operations. It contains a list of operations and a URL
    link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Event Hub operations supported by the Microsoft.EventHub resource
     provider.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpoint(_serialization.Model):
    """PrivateEndpoint information.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM identifier for Private Endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(Resource):
    """Properties of the PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar private_endpoint: The Private Endpoint resource for this Connection.
    :vartype private_endpoint: ~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Details about the state of the connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.ConnectionState
    :ivar provisioning_state: Provisioning state of the Private Endpoint Connection. Known values
     are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventhub.v2018_01_01_preview.models.EndPointProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "ConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.ConnectionState"] = None,
        provisioning_state: Optional[Union[str, "_models.EndPointProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The Private Endpoint resource for this Connection.
        :paramtype private_endpoint: ~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Details about the state of the connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.eventhub.v2018_01_01_preview.models.ConnectionState
        :keyword provisioning_state: Provisioning state of the Private Endpoint Connection. Known
         values are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
        :paramtype provisioning_state: str or
         ~azure.mgmt.eventhub.v2018_01_01_preview.models.EndPointProvisioningState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(_serialization.Model):
    """Result of the list of all private endpoint connections operation.

    :ivar value: A collection of private endpoint connection resources.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateEndpointConnection]
    :ivar next_link: A link for the next page of private endpoint connection resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of private endpoint connection resources.
        :paramtype value:
         list[~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateEndpointConnection]
        :keyword next_link: A link for the next page of private endpoint connection resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(_serialization.Model):
    """Information of the private link resource.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified identifier of the resource.
        :paramtype id: str
        :keyword name: Name of the resource.
        :paramtype name: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword group_id: The private link resource group id.
        :paramtype group_id: str
        :keyword required_members: The private link resource required member names.
        :paramtype required_members: list[str]
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class PrivateLinkResourcesListResult(_serialization.Model):
    """Result of the List private link resources operation.

    :ivar value: A collection of private link resources.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateLinkResource]
    :ivar next_link: A link for the next page of private link resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of private link resources.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.PrivateLinkResource]
        :keyword next_link: A link for the next page of private link resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RegenerateAccessKeyParameters(_serialization.Model):
    """Parameters supplied to the Regenerate Authorization Rule operation, specifies which key needs
    to be reset.

    All required parameters must be populated in order to send to server.

    :ivar key_type: The access key to regenerate. Required. Known values are: "PrimaryKey" and
     "SecondaryKey".
    :vartype key_type: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.KeyType
    :ivar key: Optional, if the key value provided, is set for KeyType or autogenerated Key value
     set for keyType.
    :vartype key: str
    """

    _validation = {
        "key_type": {"required": True},
    }

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, *, key_type: Union[str, "_models.KeyType"], key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key_type: The access key to regenerate. Required. Known values are: "PrimaryKey" and
         "SecondaryKey".
        :paramtype key_type: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.KeyType
        :keyword key: Optional, if the key value provided, is set for KeyType or autogenerated Key
         value set for keyType.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.key_type = key_type
        self.key = key


class Sku(_serialization.Model):
    """SKU parameters supplied to the create namespace operation.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of this SKU. Required. Known values are: "Basic" and "Standard".
    :vartype name: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.SkuName
    :ivar tier: The billing tier of this particular SKU. Known values are: "Basic" and "Standard".
    :vartype tier: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.SkuTier
    :ivar capacity: The Event Hubs throughput units, value should be 0 to 20 throughput units.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
        "capacity": {"minimum": 0},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of this SKU. Required. Known values are: "Basic" and "Standard".
        :paramtype name: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.SkuName
        :keyword tier: The billing tier of this particular SKU. Known values are: "Basic" and
         "Standard".
        :paramtype tier: str or ~azure.mgmt.eventhub.v2018_01_01_preview.models.SkuTier
        :keyword capacity: The Event Hubs throughput units, value should be 0 to 20 throughput units.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class Subnet(_serialization.Model):
    """Properties supplied for Subnet.

    :ivar id: Resource ID of Virtual Network Subnet.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of Virtual Network Subnet.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class VirtualNetworkRule(Resource):
    """Single item in a List or Get VirtualNetworkRules operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar virtual_network_subnet_id: ARM ID of Virtual Network Subnet.
    :vartype virtual_network_subnet_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "virtual_network_subnet_id": {"key": "properties.virtualNetworkSubnetId", "type": "str"},
    }

    def __init__(self, *, virtual_network_subnet_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword virtual_network_subnet_id: ARM ID of Virtual Network Subnet.
        :paramtype virtual_network_subnet_id: str
        """
        super().__init__(**kwargs)
        self.virtual_network_subnet_id = virtual_network_subnet_id


class VirtualNetworkRuleListResult(_serialization.Model):
    """The response from the List namespace operation.

    :ivar value: Result of the List VirtualNetwork Rules operation.
    :vartype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.VirtualNetworkRule]
    :ivar next_link: Link to the next set of results. Not empty if Value contains an incomplete
     list of VirtualNetwork Rules.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VirtualNetworkRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List VirtualNetwork Rules operation.
        :paramtype value: list[~azure.mgmt.eventhub.v2018_01_01_preview.models.VirtualNetworkRule]
        :keyword next_link: Link to the next set of results. Not empty if Value contains an incomplete
         list of VirtualNetwork Rules.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
