# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ImageStoreCopyDescription(Model):
    """Information about how to copy image store content from one image store
    relative path to another image store relative path.

    All required parameters must be populated in order to send to Azure.

    :param remote_source: Required. The relative path of source image store
     content to be copied from.
    :type remote_source: str
    :param remote_destination: Required. The relative path of destination
     image store content to be copied to.
    :type remote_destination: str
    :param skip_files: The list of the file names to be skipped for copying.
    :type skip_files: list[str]
    :param check_mark_file: Indicates whether to check mark file during
     copying. The property is true if checking mark file is required, false
     otherwise. The mark file is used to check whether the folder is well
     constructed. If the property is true and mark file does not exist, the
     copy is skipped.
    :type check_mark_file: bool
    """

    _validation = {
        'remote_source': {'required': True},
        'remote_destination': {'required': True},
    }

    _attribute_map = {
        'remote_source': {'key': 'RemoteSource', 'type': 'str'},
        'remote_destination': {'key': 'RemoteDestination', 'type': 'str'},
        'skip_files': {'key': 'SkipFiles', 'type': '[str]'},
        'check_mark_file': {'key': 'CheckMarkFile', 'type': 'bool'},
    }

    def __init__(self, *, remote_source: str, remote_destination: str, skip_files=None, check_mark_file: bool=None, **kwargs) -> None:
        super(ImageStoreCopyDescription, self).__init__(**kwargs)
        self.remote_source = remote_source
        self.remote_destination = remote_destination
        self.skip_files = skip_files
        self.check_mark_file = check_mark_file
