# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .connection_info import ConnectionInfo


class PostgreSqlConnectionInfo(ConnectionInfo):
    """Information for connecting to PostgreSQL server.

    All required parameters must be populated in order to send to Azure.

    :param user_name: User name
    :type user_name: str
    :param password: Password credential.
    :type password: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param server_name: Required. Name of the server
    :type server_name: str
    :param database_name: Name of the database
    :type database_name: str
    :param port: Required. Port for Server
    :type port: int
    """

    _validation = {
        'type': {'required': True},
        'server_name': {'required': True},
        'port': {'required': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(PostgreSqlConnectionInfo, self).__init__(**kwargs)
        self.server_name = kwargs.get('server_name', None)
        self.database_name = kwargs.get('database_name', None)
        self.port = kwargs.get('port', None)
        self.type = 'PostgreSqlConnectionInfo'
