# List of graphs for testing
#
# Structure:
#   [[name, Graph, numorbit, grpsize, generators]]
#
# numorbit, grpsize, generators was calculated by dreadnut
#

import pytest
from pynauty import Graph


@pytest.fixture(params=['a35', 'a52', 'b25', 'b35', 'b52',
                        'bibd-91-10-1', 'g13', 'g15', 'g16',
                        'g16b', 'g33', 'g6', 'g63', "hadamard-7-96",
                        "hadamard-8-96", "levi-r"])
def graph(request):
    if request.param == 'a25':
        return [ "a25",
                 Graph(number_of_vertices=25, directed=False,
                       adjacency_dict = {
                           0: [10, 11, 12, 13, 14, 15],
                           1: [10, 11, 16, 17, 18, 19],
                           2: [10, 12, 16, 20, 21, 22],
                           3: [10, 13, 17, 20, 23, 24],
                           4: [11, 12, 18, 21, 23, 24],
                           5: [11, 14, 19, 20, 22, 23],
                           6: [12, 15, 17, 19, 22, 24],
                           7: [13, 14, 16, 18, 22, 24],
                           8: [13, 15, 16, 19, 21, 23],
                           9: [14, 15, 17, 18, 20, 21],
                           10: [0, 1, 2, 3],
                           11: [0, 1, 4, 5],
                           12: [0, 2, 4, 6],
                           13: [0, 3, 7, 8],
                           14: [0, 5, 7, 9],
                           15: [0, 6, 8, 9],
                           16: [1, 2, 7, 8],
                           17: [1, 3, 6, 9],
                           18: [1, 4, 7, 9],
                           19: [1, 5, 6, 8],
                           20: [2, 3, 5, 9],
                           21: [2, 4, 8, 9],
                           22: [2, 5, 6, 7],
                           23: [3, 4, 5, 8],
                           24: [3, 4, 6, 7],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 4, # number of orbits
                 48, # grpsize
                 [ # autgrp generators
                     [0, 2, 1, 3, 4, 6, 5, 8, 7, 9, 10, 12, 11, 13, 15, 14, 16, 20, 21, 22, 17, 18, 19, 24, 23],
                     [3, 2, 1, 0, 9, 5, 6, 8, 7, 4, 10, 20, 17, 13, 23, 24, 16, 12, 21, 22, 11, 18, 19, 14, 15],
                     [0, 1, 4, 5, 2, 3, 6, 7, 9, 8, 11, 10, 12, 14, 13, 15, 18, 19, 16, 17, 23, 21, 24, 20, 22],
                 ]
                ]
    elif request.param == 'a35':
        return [ "a35",
                 Graph(number_of_vertices=35, directed=False,
                       adjacency_dict = {
                           0: [19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34],
                           1: [9, 10, 11, 12, 15, 16, 17, 18, 27, 28, 29, 30, 31, 32, 33, 34],
                           2: [9, 10, 11, 12, 13, 14, 17, 18, 20, 21, 22, 24, 25, 26, 33, 34],
                           3: [7, 8, 11, 12, 14, 15, 16, 18, 19, 21, 22, 23, 26, 29, 32, 34],
                           4: [7, 8, 11, 12, 13, 15, 16, 17, 19, 20, 24, 25, 26, 27, 28, 30],
                           5: [7, 8, 9, 10, 13, 14, 16, 18, 20, 22, 23, 24, 28, 29, 30, 31],
                           6: [7, 8, 9, 10, 13, 14, 15, 17, 19, 21, 23, 25, 27, 31, 32, 33],
                           7: [3, 4, 5, 6, 14, 16, 17, 18, 24, 25, 26, 30, 31, 32, 33, 34],
                           8: [3, 4, 5, 6, 13, 15, 17, 18, 20, 21, 22, 27, 28, 29, 33, 34],
                           9: [1, 2, 5, 6, 14, 15, 16, 17, 19, 20, 22, 25, 26, 28, 29, 32],
                           10: [1, 2, 5, 6, 13, 15, 16, 18, 19, 21, 23, 24, 26, 27, 30, 34],
                           11: [1, 2, 3, 4, 13, 14, 16, 17, 20, 21, 23, 24, 27, 29, 31, 32],
                           12: [1, 2, 3, 4, 13, 14, 15, 18, 19, 22, 23, 25, 28, 30, 31, 33],
                           13: [2, 4, 5, 6, 8, 10, 11, 12, 23, 25, 26, 28, 29, 31, 32, 34],
                           14: [2, 3, 5, 6, 7, 9, 11, 12, 19, 20, 21, 27, 28, 30, 31, 34],
                           15: [1, 3, 4, 6, 8, 9, 10, 12, 20, 21, 22, 24, 26, 30, 31, 32],
                           16: [1, 3, 4, 5, 7, 9, 10, 11, 21, 22, 23, 25, 26, 27, 28, 33],
                           17: [1, 2, 4, 6, 7, 8, 9, 11, 19, 22, 23, 24, 29, 30, 33, 34],
                           18: [1, 2, 3, 5, 7, 8, 10, 12, 19, 20, 24, 25, 27, 29, 32, 33],
                           19: [0, 3, 4, 6, 9, 10, 12, 14, 17, 18, 23, 24, 26, 27, 28, 29],
                           20: [0, 2, 4, 5, 8, 9, 11, 14, 15, 18, 23, 26, 27, 30, 32, 33],
                           21: [0, 2, 3, 6, 8, 10, 11, 14, 15, 16, 24, 25, 28, 29, 30, 33],
                           22: [0, 2, 3, 5, 8, 9, 12, 15, 16, 17, 23, 24, 25, 27, 31, 34],
                           23: [0, 3, 5, 6, 10, 11, 12, 13, 16, 17, 19, 20, 22, 30, 32, 33],
                           24: [0, 2, 4, 5, 7, 10, 11, 15, 17, 18, 19, 21, 22, 28, 31, 32],
                           25: [0, 2, 4, 6, 7, 9, 12, 13, 16, 18, 21, 22, 27, 29, 30, 32],
                           26: [0, 2, 3, 4, 7, 9, 10, 13, 15, 16, 19, 20, 29, 31, 33, 34],
                           27: [0, 1, 4, 6, 8, 10, 11, 14, 16, 18, 19, 20, 22, 25, 31, 34],
                           28: [0, 1, 4, 5, 8, 9, 12, 13, 14, 16, 19, 21, 24, 32, 33, 34],
                           29: [0, 1, 3, 5, 8, 9, 11, 13, 17, 18, 19, 21, 25, 26, 30, 31],
                           30: [0, 1, 4, 5, 7, 10, 12, 14, 15, 17, 20, 21, 23, 25, 29, 34],
                           31: [0, 1, 5, 6, 7, 11, 12, 13, 14, 15, 22, 24, 26, 27, 29, 33],
                           32: [0, 1, 3, 6, 7, 9, 11, 13, 15, 18, 20, 23, 24, 25, 28, 34],
                           33: [0, 1, 2, 6, 7, 8, 12, 16, 17, 18, 20, 21, 23, 26, 28, 31],
                           34: [0, 1, 2, 3, 7, 8, 10, 13, 14, 17, 22, 26, 27, 28, 30, 32],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 35, # number of orbits
                 1, # grpsize
                 [ # autgrp generators
                 ]
                ]
    elif request.param == 'a52':
        return [ "a52",
                 Graph(number_of_vertices=52, directed=False,
                       adjacency_dict = {
                           0: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25],
                           1: [0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51],
                           2: [0, 1, 3, 4, 11, 12, 13, 14, 15, 16, 17, 18, 19, 31, 32, 33, 34, 35, 36, 46, 47, 48, 49, 50, 51],
                           3: [0, 1, 2, 4, 5, 6, 7, 14, 16, 19, 20, 22, 24, 34, 35, 36, 37, 38, 39, 41, 43, 44, 47, 49, 51],
                           4: [0, 1, 2, 3, 5, 6, 7, 15, 17, 18, 21, 23, 25, 34, 35, 36, 37, 38, 39, 40, 42, 45, 46, 48, 50],
                           5: [0, 1, 3, 4, 9, 10, 13, 14, 17, 20, 22, 23, 25, 28, 32, 33, 34, 37, 38, 41, 42, 44, 45, 47, 50],
                           6: [0, 1, 3, 4, 8, 10, 12, 15, 16, 21, 22, 23, 24, 28, 31, 33, 35, 37, 39, 40, 43, 44, 45, 46, 51],
                           7: [0, 1, 3, 4, 8, 9, 11, 18, 19, 20, 21, 24, 25, 28, 31, 32, 36, 38, 39, 40, 41, 42, 43, 48, 49],
                           8: [0, 1, 6, 7, 9, 10, 13, 14, 16, 17, 18, 21, 24, 28, 29, 30, 31, 37, 38, 41, 45, 46, 48, 49, 51],
                           9: [0, 1, 5, 7, 8, 10, 12, 15, 16, 17, 19, 20, 25, 28, 29, 30, 32, 37, 39, 40, 44, 47, 48, 49, 50],
                           10: [0, 1, 5, 6, 8, 9, 11, 14, 15, 18, 19, 22, 23, 28, 29, 30, 33, 38, 39, 42, 43, 46, 47, 50, 51],
                           11: [0, 1, 2, 7, 10, 12, 13, 18, 19, 20, 21, 22, 23, 29, 30, 31, 32, 34, 35, 40, 41, 42, 43, 50, 51],
                           12: [0, 1, 2, 6, 9, 11, 13, 15, 16, 20, 23, 24, 25, 29, 30, 31, 33, 34, 36, 40, 43, 44, 45, 47, 48],
                           13: [0, 1, 2, 5, 8, 11, 12, 14, 17, 21, 22, 24, 25, 29, 30, 32, 33, 35, 36, 41, 42, 44, 45, 46, 49],
                           14: [0, 2, 3, 5, 8, 10, 13, 16, 18, 19, 23, 24, 25, 27, 30, 32, 33, 35, 37, 38, 41, 43, 46, 47, 48],
                           15: [0, 2, 4, 6, 9, 10, 12, 17, 18, 19, 22, 24, 25, 27, 29, 31, 33, 34, 37, 39, 40, 42, 46, 47, 49],
                           16: [0, 2, 3, 6, 8, 9, 12, 14, 17, 19, 20, 21, 23, 27, 30, 31, 33, 36, 37, 39, 41, 44, 48, 50, 51],
                           17: [0, 2, 4, 5, 8, 9, 13, 15, 16, 18, 20, 21, 22, 27, 29, 32, 33, 36, 37, 38, 40, 45, 49, 50, 51],
                           18: [0, 2, 4, 7, 8, 10, 11, 14, 15, 17, 20, 23, 24, 27, 29, 31, 32, 35, 38, 39, 42, 45, 47, 48, 51],
                           19: [0, 2, 3, 7, 9, 10, 11, 14, 15, 16, 21, 22, 25, 27, 30, 31, 32, 34, 38, 39, 43, 44, 46, 49, 50],
                           20: [0, 3, 5, 7, 9, 11, 12, 16, 17, 18, 22, 23, 24, 27, 28, 30, 32, 34, 36, 39, 40, 41, 45, 47, 51],
                           21: [0, 4, 6, 7, 8, 11, 13, 16, 17, 19, 22, 23, 25, 27, 28, 29, 31, 35, 36, 38, 40, 41, 44, 46, 50],
                           22: [0, 3, 5, 6, 10, 11, 13, 15, 17, 19, 20, 21, 24, 27, 28, 30, 33, 34, 35, 38, 40, 42, 44, 49, 51],
                           23: [0, 4, 5, 6, 10, 11, 12, 14, 16, 18, 20, 21, 25, 27, 28, 29, 33, 34, 35, 39, 41, 43, 45, 48, 50],
                           24: [0, 3, 6, 7, 8, 12, 13, 14, 15, 18, 20, 22, 25, 27, 28, 30, 31, 35, 36, 37, 42, 43, 45, 47, 49],
                           25: [0, 4, 5, 7, 9, 12, 13, 14, 15, 19, 21, 23, 24, 27, 28, 29, 32, 34, 36, 37, 42, 43, 44, 46, 48],
                           26: [27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51],
                           27: [14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39],
                           28: [5, 6, 7, 8, 9, 10, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 37, 38, 39, 40, 41, 42, 43, 44, 45],
                           29: [8, 9, 10, 11, 12, 13, 15, 17, 18, 21, 23, 25, 26, 27, 28, 30, 31, 32, 33, 40, 42, 45, 46, 48, 50],
                           30: [8, 9, 10, 11, 12, 13, 14, 16, 19, 20, 22, 24, 26, 27, 28, 29, 31, 32, 33, 41, 43, 44, 47, 49, 51],
                           31: [2, 6, 7, 8, 11, 12, 15, 16, 18, 19, 21, 24, 26, 27, 29, 30, 35, 36, 39, 40, 43, 46, 48, 49, 51],
                           32: [2, 5, 7, 9, 11, 13, 14, 17, 18, 19, 20, 25, 26, 27, 29, 30, 34, 36, 38, 41, 42, 47, 48, 49, 50],
                           33: [2, 5, 6, 10, 12, 13, 14, 15, 16, 17, 22, 23, 26, 27, 29, 30, 34, 35, 37, 44, 45, 46, 47, 50, 51],
                           34: [2, 3, 4, 5, 11, 12, 15, 19, 20, 22, 23, 25, 26, 27, 32, 33, 35, 36, 39, 40, 42, 43, 44, 47, 50],
                           35: [2, 3, 4, 6, 11, 13, 14, 18, 21, 22, 23, 24, 26, 27, 31, 33, 34, 36, 38, 41, 42, 43, 45, 46, 51],
                           36: [2, 3, 4, 7, 12, 13, 16, 17, 20, 21, 24, 25, 26, 27, 31, 32, 34, 35, 37, 40, 41, 44, 45, 48, 49],
                           37: [3, 4, 5, 6, 8, 9, 14, 15, 16, 17, 24, 25, 26, 27, 28, 33, 36, 38, 39, 44, 45, 46, 47, 48, 49],
                           38: [3, 4, 5, 7, 8, 10, 14, 17, 18, 19, 21, 22, 26, 27, 28, 32, 35, 37, 39, 41, 42, 46, 49, 50, 51],
                           39: [3, 4, 6, 7, 9, 10, 15, 16, 18, 19, 20, 23, 26, 27, 28, 31, 34, 37, 38, 40, 43, 47, 48, 50, 51],
                           40: [1, 4, 6, 7, 9, 11, 12, 15, 17, 20, 21, 22, 26, 28, 29, 31, 34, 36, 39, 42, 44, 45, 49, 50, 51],
                           41: [1, 3, 5, 7, 8, 11, 13, 14, 16, 20, 21, 23, 26, 28, 30, 32, 35, 36, 38, 43, 44, 45, 48, 50, 51],
                           42: [1, 4, 5, 7, 10, 11, 13, 15, 18, 22, 24, 25, 26, 28, 29, 32, 34, 35, 38, 40, 43, 45, 46, 47, 49],
                           43: [1, 3, 6, 7, 10, 11, 12, 14, 19, 23, 24, 25, 26, 28, 30, 31, 34, 35, 39, 41, 42, 44, 46, 47, 48],
                           44: [1, 3, 5, 6, 9, 12, 13, 16, 19, 21, 22, 25, 26, 28, 30, 33, 34, 36, 37, 40, 41, 43, 46, 49, 50],
                           45: [1, 4, 5, 6, 8, 12, 13, 17, 18, 20, 23, 24, 26, 28, 29, 33, 35, 36, 37, 40, 41, 42, 47, 48, 51],
                           46: [1, 2, 4, 6, 8, 10, 13, 14, 15, 19, 21, 25, 26, 29, 31, 33, 35, 37, 38, 42, 43, 44, 48, 49, 50],
                           47: [1, 2, 3, 5, 9, 10, 12, 14, 15, 18, 20, 24, 26, 30, 32, 33, 34, 37, 39, 42, 43, 45, 48, 49, 51],
                           48: [1, 2, 4, 7, 8, 9, 12, 14, 16, 18, 23, 25, 26, 29, 31, 32, 36, 37, 39, 41, 43, 45, 46, 47, 50],
                           49: [1, 2, 3, 7, 8, 9, 13, 15, 17, 19, 22, 24, 26, 30, 31, 32, 36, 37, 38, 40, 42, 44, 46, 47, 51],
                           50: [1, 2, 4, 5, 9, 10, 11, 16, 17, 19, 21, 23, 26, 29, 32, 33, 34, 38, 39, 40, 41, 44, 46, 48, 51],
                           51: [1, 2, 3, 6, 8, 10, 11, 16, 17, 18, 20, 22, 26, 30, 31, 33, 35, 38, 39, 40, 41, 45, 47, 49, 50],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 4, # number of orbits
                 144, # grpsize
                 [ # autgrp generators
                     [0, 1, 2, 4, 3, 6, 5, 7, 9, 8, 10, 11, 13, 12, 15, 14, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 26, 27, 28, 30, 29, 32, 31, 33, 35, 34, 36, 37, 39, 38, 41, 40, 43, 42, 45, 44, 47, 46, 49, 48, 51, 50],
                     [0, 1, 2, 3, 4, 6, 7, 5, 9, 10, 8, 13, 11, 12, 16, 18, 19, 15, 17, 14, 22, 25, 24, 21, 20, 23, 26, 27, 28, 29, 30, 32, 33, 31, 35, 36, 34, 39, 37, 38, 42, 44, 45, 41, 43, 40, 48, 51, 50, 47, 46, 49],
                     [3, 1, 2, 0, 4, 5, 7, 6, 43, 44, 41, 51, 49, 47, 14, 36, 19, 34, 35, 16, 22, 39, 20, 38, 24, 37, 29, 27, 28, 26, 30, 31, 33, 32, 17, 18, 15, 25, 23, 21, 40, 10, 45, 8, 9, 42, 48, 13, 46, 12, 50, 11],
                     [11, 1, 2, 51, 50, 10, 40, 41, 7, 43, 42, 13, 12, 0, 18, 34, 31, 19, 32, 35, 30, 21, 22, 29, 20, 23, 37, 27, 28, 25, 24, 36, 14, 15, 33, 17, 16, 39, 38, 26, 44, 8, 5, 45, 6, 9, 4, 47, 48, 3, 46, 49],
                     [20, 27, 28, 23, 39, 34, 18, 16, 17, 36, 32, 30, 24, 22, 5, 7, 45, 40, 9, 41, 12, 51, 11, 47, 0, 3, 46, 1, 2, 49, 13, 8, 44, 42, 43, 10, 6, 4, 50, 48, 31, 33, 19, 14, 35, 15, 38, 25, 37, 21, 26, 29],
                 ]
                ]
    elif request.param == 'b25':
        return [ "b25",
                 Graph(number_of_vertices=25, directed=False,
                       adjacency_dict = {
                           0: [10, 11, 12, 13, 14, 15],
                           1: [10, 11, 16, 17, 18, 19],
                           2: [10, 12, 16, 20, 21, 22],
                           3: [10, 13, 17, 20, 23, 24],
                           4: [11, 12, 18, 21, 23, 24],
                           5: [11, 14, 19, 20, 22, 23],
                           6: [12, 15, 17, 19, 22, 24],
                           7: [13, 14, 16, 18, 22, 24],
                           8: [13, 15, 18, 19, 20, 21],
                           9: [14, 15, 16, 17, 21, 23],
                           10: [0, 1, 2, 3],
                           11: [0, 1, 4, 5],
                           12: [0, 2, 4, 6],
                           13: [0, 3, 7, 8],
                           14: [0, 5, 7, 9],
                           15: [0, 6, 8, 9],
                           16: [1, 2, 7, 9],
                           17: [1, 3, 6, 9],
                           18: [1, 4, 7, 8],
                           19: [1, 5, 6, 8],
                           20: [2, 3, 5, 8],
                           21: [2, 4, 8, 9],
                           22: [2, 5, 6, 7],
                           23: [3, 4, 5, 9],
                           24: [3, 4, 6, 7],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 5, # number of orbits
                 24, # grpsize
                 [ # autgrp generators
                     [1, 3, 2, 0, 9, 6, 7, 5, 4, 8, 10, 17, 16, 11, 19, 18, 20, 13, 23, 24, 12, 21, 22, 15, 14],
                     [0, 1, 4, 5, 2, 3, 6, 7, 9, 8, 11, 10, 12, 14, 13, 15, 18, 19, 16, 17, 23, 21, 24, 20, 22],
                 ]
                ]
    elif request.param == 'b35':
        return [ "b35",
                 Graph(number_of_vertices=35, directed=False,
                       adjacency_dict = {
                           0: [19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34],
                           1: [9, 10, 11, 12, 15, 16, 17, 18, 27, 28, 29, 30, 31, 32, 33, 34],
                           2: [9, 10, 11, 12, 13, 14, 17, 18, 20, 21, 22, 24, 25, 26, 33, 34],
                           3: [7, 8, 11, 12, 14, 15, 16, 18, 20, 21, 22, 23, 26, 29, 31, 32],
                           4: [7, 8, 11, 12, 13, 15, 16, 17, 19, 22, 24, 25, 26, 27, 28, 30],
                           5: [7, 8, 9, 10, 13, 14, 16, 18, 19, 21, 23, 24, 28, 29, 30, 34],
                           6: [7, 8, 9, 10, 13, 14, 15, 17, 19, 20, 23, 25, 27, 31, 32, 33],
                           7: [3, 4, 5, 6, 14, 16, 17, 18, 24, 25, 26, 30, 31, 32, 33, 34],
                           8: [3, 4, 5, 6, 13, 15, 17, 18, 20, 21, 22, 27, 28, 29, 33, 34],
                           9: [1, 2, 5, 6, 14, 15, 16, 17, 19, 21, 22, 25, 26, 28, 29, 32],
                           10: [1, 2, 5, 6, 13, 15, 16, 18, 20, 22, 23, 24, 26, 27, 30, 31],
                           11: [1, 2, 3, 4, 13, 14, 16, 17, 19, 20, 23, 24, 27, 29, 32, 34],
                           12: [1, 2, 3, 4, 13, 14, 15, 18, 19, 21, 23, 25, 28, 30, 31, 33],
                           13: [2, 4, 5, 6, 8, 10, 11, 12, 23, 25, 26, 28, 29, 31, 32, 34],
                           14: [2, 3, 5, 6, 7, 9, 11, 12, 19, 20, 22, 27, 28, 30, 31, 34],
                           15: [1, 3, 4, 6, 8, 9, 10, 12, 19, 20, 21, 24, 26, 30, 32, 34],
                           16: [1, 3, 4, 5, 7, 9, 10, 11, 20, 21, 23, 25, 26, 27, 28, 33],
                           17: [1, 2, 4, 6, 7, 8, 9, 11, 21, 22, 23, 24, 29, 30, 31, 33],
                           18: [1, 2, 3, 5, 7, 8, 10, 12, 19, 22, 24, 25, 27, 29, 32, 33],
                           19: [0, 4, 5, 6, 9, 11, 12, 14, 15, 18, 23, 24, 26, 27, 29, 33],
                           20: [0, 2, 3, 6, 8, 10, 11, 14, 15, 16, 24, 25, 28, 29, 30, 33],
                           21: [0, 2, 3, 5, 8, 9, 12, 15, 16, 17, 23, 24, 25, 27, 31, 34],
                           22: [0, 2, 3, 4, 8, 9, 10, 14, 17, 18, 23, 26, 27, 28, 30, 32],
                           23: [0, 3, 5, 6, 10, 11, 12, 13, 16, 17, 19, 21, 22, 30, 32, 33],
                           24: [0, 2, 4, 5, 7, 10, 11, 15, 17, 18, 19, 20, 21, 28, 31, 32],
                           25: [0, 2, 4, 6, 7, 9, 12, 13, 16, 18, 20, 21, 27, 29, 30, 32],
                           26: [0, 2, 3, 4, 7, 9, 10, 13, 15, 16, 19, 22, 29, 31, 33, 34],
                           27: [0, 1, 4, 6, 8, 10, 11, 14, 16, 18, 19, 21, 22, 25, 31, 34],
                           28: [0, 1, 4, 5, 8, 9, 12, 13, 14, 16, 20, 22, 24, 31, 32, 33],
                           29: [0, 1, 3, 5, 8, 9, 11, 13, 17, 18, 19, 20, 25, 26, 30, 31],
                           30: [0, 1, 4, 5, 7, 10, 12, 14, 15, 17, 20, 22, 23, 25, 29, 34],
                           31: [0, 1, 3, 6, 7, 10, 12, 13, 14, 17, 21, 24, 26, 27, 28, 29],
                           32: [0, 1, 3, 6, 7, 9, 11, 13, 15, 18, 22, 23, 24, 25, 28, 34],
                           33: [0, 1, 2, 6, 7, 8, 12, 16, 17, 18, 19, 20, 23, 26, 28, 34],
                           34: [0, 1, 2, 5, 7, 8, 11, 13, 14, 15, 21, 26, 27, 30, 32, 33],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 35, # number of orbits
                 1, # grpsize
                 [ # autgrp generators
                 ]
                ]
    elif request.param == 'b52':
        return [ "b52",
                 Graph(number_of_vertices=52, directed=False,
                       adjacency_dict = {
                           0: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25],
                           1: [0, 4, 9, 10, 11, 12, 13, 16, 17, 19, 23, 24, 25, 28, 29, 31, 32, 33, 34, 40, 41, 44, 46, 47, 48],
                           2: [0, 6, 9, 10, 11, 14, 15, 16, 18, 20, 22, 23, 24, 27, 29, 30, 31, 33, 34, 38, 39, 43, 45, 47, 51],
                           3: [0, 4, 5, 7, 11, 14, 15, 16, 19, 20, 21, 24, 25, 27, 28, 32, 34, 35, 36, 38, 39, 43, 44, 48, 49],
                           4: [0, 1, 3, 7, 11, 12, 14, 16, 17, 18, 21, 22, 23, 28, 31, 32, 34, 35, 36, 39, 41, 45, 46, 50, 51],
                           5: [0, 3, 8, 10, 11, 13, 15, 17, 19, 20, 21, 22, 23, 27, 28, 30, 32, 33, 35, 38, 40, 42, 44, 50, 51],
                           6: [0, 2, 7, 8, 12, 13, 14, 16, 19, 20, 22, 23, 25, 27, 29, 30, 31, 35, 36, 37, 41, 43, 44, 47, 50],
                           7: [0, 3, 4, 6, 12, 13, 15, 17, 18, 20, 22, 24, 25, 27, 28, 31, 34, 35, 36, 37, 40, 42, 45, 47, 49],
                           8: [0, 5, 6, 9, 12, 14, 15, 17, 18, 19, 21, 23, 25, 27, 28, 29, 30, 33, 36, 37, 39, 42, 46, 48, 50],
                           9: [0, 1, 2, 8, 11, 13, 14, 17, 18, 20, 21, 24, 25, 29, 30, 31, 32, 33, 36, 38, 41, 42, 45, 48, 49],
                           10: [0, 1, 2, 5, 12, 13, 15, 16, 18, 19, 21, 22, 24, 29, 30, 32, 33, 34, 35, 37, 40, 43, 46, 49, 51],
                           11: [0, 1, 2, 3, 4, 5, 9, 18, 19, 20, 22, 23, 25, 32, 33, 34, 36, 38, 39, 40, 41, 42, 43, 47, 50],
                           12: [0, 1, 4, 6, 7, 8, 10, 18, 19, 20, 21, 23, 24, 28, 29, 31, 35, 37, 39, 40, 41, 42, 43, 48, 51],
                           13: [0, 1, 5, 6, 7, 9, 10, 16, 17, 20, 21, 22, 25, 28, 29, 30, 34, 37, 38, 40, 41, 44, 45, 49, 50],
                           14: [0, 2, 3, 4, 6, 8, 9, 16, 17, 19, 21, 22, 24, 27, 31, 33, 36, 37, 38, 39, 41, 44, 46, 49, 51],
                           15: [0, 2, 3, 5, 7, 8, 10, 16, 17, 18, 23, 24, 25, 27, 30, 32, 35, 37, 38, 39, 40, 45, 46, 47, 48],
                           16: [0, 1, 2, 3, 4, 6, 10, 13, 14, 15, 21, 23, 25, 31, 33, 34, 35, 37, 38, 43, 44, 45, 46, 48, 50],
                           17: [0, 1, 4, 5, 7, 8, 9, 13, 14, 15, 22, 23, 24, 28, 29, 32, 36, 37, 38, 42, 44, 45, 46, 47, 51],
                           18: [0, 2, 4, 7, 8, 9, 10, 11, 12, 15, 21, 22, 25, 27, 29, 31, 32, 39, 40, 42, 43, 45, 46, 49, 50],
                           19: [0, 1, 3, 5, 6, 8, 10, 11, 12, 14, 22, 24, 25, 28, 30, 33, 35, 39, 41, 42, 43, 44, 46, 47, 49],
                           20: [0, 2, 3, 5, 6, 7, 9, 11, 12, 13, 21, 23, 24, 27, 30, 34, 36, 40, 41, 42, 43, 44, 45, 48, 51],
                           21: [0, 3, 4, 5, 8, 9, 10, 12, 13, 14, 16, 18, 20, 27, 28, 32, 33, 37, 41, 43, 45, 48, 49, 50, 51],
                           22: [0, 2, 4, 5, 6, 7, 10, 11, 13, 14, 17, 18, 19, 27, 29, 34, 35, 38, 41, 42, 46, 47, 49, 50, 51],
                           23: [0, 1, 2, 4, 5, 6, 8, 11, 12, 15, 16, 17, 20, 29, 33, 35, 36, 39, 40, 44, 45, 47, 48, 50, 51],
                           24: [0, 1, 2, 3, 7, 9, 10, 12, 14, 15, 17, 19, 20, 30, 31, 32, 34, 37, 39, 42, 44, 47, 48, 49, 51],
                           25: [0, 1, 3, 6, 7, 8, 9, 11, 13, 15, 16, 18, 19, 28, 30, 31, 36, 38, 40, 43, 46, 47, 48, 49, 50],
                           26: [27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51],
                           27: [2, 3, 5, 6, 7, 8, 14, 15, 18, 20, 21, 22, 26, 30, 35, 36, 37, 38, 39, 42, 43, 45, 49, 50, 51],
                           28: [1, 3, 4, 5, 7, 8, 12, 13, 17, 19, 21, 25, 26, 32, 35, 36, 37, 40, 41, 42, 44, 46, 48, 49, 50],
                           29: [1, 2, 6, 8, 9, 10, 12, 13, 17, 18, 22, 23, 26, 30, 31, 33, 37, 40, 41, 42, 45, 46, 47, 50, 51],
                           30: [2, 5, 6, 8, 9, 10, 13, 15, 19, 20, 24, 25, 26, 27, 29, 33, 37, 38, 40, 42, 43, 44, 47, 48, 49],
                           31: [1, 2, 4, 6, 7, 9, 12, 14, 16, 18, 24, 25, 26, 29, 34, 36, 37, 39, 41, 43, 45, 46, 47, 48, 49],
                           32: [1, 3, 4, 5, 9, 10, 11, 15, 17, 18, 21, 24, 26, 28, 33, 34, 38, 39, 40, 42, 45, 46, 48, 49, 51],
                           33: [1, 2, 5, 8, 9, 10, 11, 14, 16, 19, 21, 23, 26, 29, 30, 32, 38, 39, 41, 43, 44, 46, 48, 50, 51],
                           34: [1, 2, 3, 4, 7, 10, 11, 13, 16, 20, 22, 24, 26, 31, 32, 35, 38, 40, 41, 43, 44, 45, 47, 49, 51],
                           35: [3, 4, 5, 6, 7, 10, 12, 15, 16, 19, 22, 23, 26, 27, 28, 34, 37, 39, 40, 43, 44, 46, 47, 50, 51],
                           36: [3, 4, 6, 7, 8, 9, 11, 14, 17, 20, 23, 25, 26, 27, 28, 31, 38, 39, 41, 42, 44, 45, 47, 48, 50],
                           37: [6, 7, 8, 10, 12, 13, 14, 15, 16, 17, 21, 24, 26, 27, 28, 29, 30, 31, 35, 44, 45, 46, 48, 49, 51],
                           38: [2, 3, 5, 9, 11, 13, 14, 15, 16, 17, 22, 25, 26, 27, 30, 32, 33, 34, 36, 44, 45, 46, 47, 49, 50],
                           39: [2, 3, 4, 8, 11, 12, 14, 15, 18, 19, 23, 24, 26, 27, 31, 32, 33, 35, 36, 42, 43, 46, 47, 48, 51],
                           40: [1, 5, 7, 10, 11, 12, 13, 15, 18, 20, 23, 25, 26, 28, 29, 30, 32, 34, 35, 42, 43, 45, 47, 48, 50],
                           41: [1, 4, 6, 9, 11, 12, 13, 14, 19, 20, 21, 22, 26, 28, 29, 31, 33, 34, 36, 42, 43, 44, 49, 50, 51],
                           42: [5, 7, 8, 9, 11, 12, 17, 18, 19, 20, 22, 24, 26, 27, 28, 29, 30, 32, 36, 39, 40, 41, 47, 49, 51],
                           43: [2, 3, 6, 10, 11, 12, 16, 18, 19, 20, 21, 25, 26, 27, 30, 31, 33, 34, 35, 39, 40, 41, 48, 49, 50],
                           44: [1, 3, 5, 6, 13, 14, 16, 17, 19, 20, 23, 24, 26, 28, 30, 33, 34, 35, 36, 37, 38, 41, 47, 48, 51],
                           45: [2, 4, 7, 9, 13, 15, 16, 17, 18, 20, 21, 23, 26, 27, 29, 31, 32, 34, 36, 37, 38, 40, 48, 50, 51],
                           46: [1, 4, 8, 10, 14, 15, 16, 17, 18, 19, 22, 25, 26, 28, 29, 31, 32, 33, 35, 37, 38, 39, 47, 49, 50],
                           47: [1, 2, 6, 7, 11, 15, 17, 19, 22, 23, 24, 25, 26, 29, 30, 31, 34, 35, 36, 38, 39, 40, 42, 44, 46],
                           48: [1, 3, 8, 9, 12, 15, 16, 20, 21, 23, 24, 25, 26, 28, 30, 31, 32, 33, 36, 37, 39, 40, 43, 44, 45],
                           49: [3, 7, 9, 10, 13, 14, 18, 19, 21, 22, 24, 25, 26, 27, 28, 30, 31, 32, 34, 37, 38, 41, 42, 43, 46],
                           50: [4, 5, 6, 8, 11, 13, 16, 18, 21, 22, 23, 25, 26, 27, 28, 29, 33, 35, 36, 38, 40, 41, 43, 45, 46],
                           51: [2, 4, 5, 10, 12, 14, 17, 20, 21, 22, 23, 24, 26, 27, 29, 32, 33, 34, 35, 37, 39, 41, 42, 44, 45],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 8, # number of orbits
                 12, # grpsize
                 [ # autgrp generators
                     [4, 1, 50, 3, 0, 39, 45, 7, 51, 41, 46, 11, 17, 31, 21, 35, 16, 12, 22, 32, 36, 14, 18, 23, 28, 34, 30, 27, 24, 29, 26, 13, 19, 33, 25, 15, 20, 37, 43, 5, 47, 9, 42, 38, 48, 6, 10, 40, 44, 49, 2, 8],
                     [5, 51, 40, 3, 44, 0, 50, 38, 8, 42, 10, 20, 33, 22, 28, 15, 35, 17, 30, 21, 11, 19, 13, 23, 32, 27, 31, 25, 14, 29, 18, 26, 24, 12, 34, 16, 36, 46, 7, 48, 2, 41, 9, 43, 4, 47, 37, 45, 39, 49, 6, 1],
                     [13, 34, 21, 29, 22, 30, 28, 17, 25, 16, 20, 10, 7, 44, 50, 9, 41, 38, 0, 40, 37, 6, 5, 49, 45, 1, 39, 8, 47, 3, 48, 4, 2, 43, 51, 42, 46, 36, 33, 18, 24, 35, 15, 12, 26, 14, 11, 32, 31, 23, 19, 27],
                 ]
                ]
    elif request.param == 'bibd-91-10-1':
        return [ "bibd-91-10-1",
                 Graph(number_of_vertices=182, directed=False,
                       adjacency_dict = {
                           0: [91, 100, 109, 118, 127, 136, 145, 154, 163, 172],
                           1: [91, 101, 110, 119, 128, 137, 146, 155, 164, 173],
                           2: [91, 102, 111, 120, 129, 138, 147, 156, 165, 174],
                           3: [91, 103, 112, 121, 130, 139, 148, 157, 166, 175],
                           4: [91, 104, 113, 122, 131, 140, 149, 158, 167, 176],
                           5: [91, 105, 114, 123, 132, 141, 150, 159, 168, 177],
                           6: [91, 106, 115, 124, 133, 142, 151, 160, 169, 178],
                           7: [91, 107, 116, 125, 134, 143, 152, 161, 170, 179],
                           8: [91, 108, 117, 126, 135, 144, 153, 162, 171, 180],
                           9: [92, 100, 111, 119, 133, 144, 152, 157, 168, 176],
                           10: [92, 101, 109, 120, 134, 142, 153, 158, 166, 177],
                           11: [92, 102, 110, 118, 135, 143, 151, 159, 167, 175],
                           12: [92, 103, 114, 122, 127, 138, 146, 160, 171, 179],
                           13: [92, 104, 112, 123, 128, 136, 147, 161, 169, 180],
                           14: [92, 105, 113, 121, 129, 137, 145, 162, 170, 178],
                           15: [92, 106, 117, 125, 130, 141, 149, 154, 165, 173],
                           16: [92, 107, 115, 126, 131, 139, 150, 155, 163, 174],
                           17: [92, 108, 116, 124, 132, 140, 148, 156, 164, 172],
                           18: [93, 100, 110, 120, 130, 140, 150, 160, 170, 180],
                           19: [93, 101, 111, 118, 131, 141, 148, 161, 171, 178],
                           20: [93, 102, 109, 119, 132, 139, 149, 162, 169, 179],
                           21: [93, 103, 113, 123, 133, 143, 153, 154, 164, 174],
                           22: [93, 104, 114, 121, 134, 144, 151, 155, 165, 172],
                           23: [93, 105, 112, 122, 135, 142, 152, 156, 163, 173],
                           24: [93, 106, 116, 126, 127, 137, 147, 157, 167, 177],
                           25: [93, 107, 117, 124, 128, 138, 145, 158, 168, 175],
                           26: [93, 108, 115, 125, 129, 136, 146, 159, 166, 176],
                           27: [94, 100, 115, 121, 128, 141, 153, 156, 167, 179],
                           28: [94, 101, 116, 122, 129, 139, 151, 154, 168, 180],
                           29: [94, 102, 117, 123, 127, 140, 152, 155, 166, 178],
                           30: [94, 103, 109, 124, 131, 144, 147, 159, 170, 173],
                           31: [94, 104, 110, 125, 132, 142, 145, 157, 171, 174],
                           32: [94, 105, 111, 126, 130, 143, 146, 158, 169, 172],
                           33: [94, 106, 112, 118, 134, 138, 150, 162, 164, 176],
                           34: [94, 107, 113, 119, 135, 136, 148, 160, 165, 177],
                           35: [94, 108, 114, 120, 133, 137, 149, 161, 163, 175],
                           36: [95, 100, 117, 122, 134, 137, 148, 159, 169, 174],
                           37: [95, 101, 115, 123, 135, 138, 149, 157, 170, 172],
                           38: [95, 102, 116, 121, 133, 136, 150, 158, 171, 173],
                           39: [95, 103, 111, 125, 128, 140, 151, 162, 163, 177],
                           40: [95, 104, 109, 126, 129, 141, 152, 160, 164, 175],
                           41: [95, 105, 110, 124, 127, 139, 153, 161, 165, 176],
                           42: [95, 106, 114, 119, 131, 143, 145, 156, 166, 180],
                           43: [95, 107, 112, 120, 132, 144, 146, 154, 167, 178],
                           44: [95, 108, 113, 118, 130, 142, 147, 155, 168, 179],
                           45: [96, 100, 116, 123, 131, 142, 146, 162, 165, 175],
                           46: [96, 101, 117, 121, 132, 143, 147, 160, 163, 176],
                           47: [96, 102, 115, 122, 130, 144, 145, 161, 164, 177],
                           48: [96, 103, 110, 126, 134, 136, 149, 156, 168, 178],
                           49: [96, 104, 111, 124, 135, 137, 150, 154, 166, 179],
                           50: [96, 105, 109, 125, 133, 138, 148, 155, 167, 180],
                           51: [96, 106, 113, 120, 128, 139, 152, 159, 171, 172],
                           52: [96, 107, 114, 118, 129, 140, 153, 157, 169, 173],
                           53: [96, 108, 112, 119, 127, 141, 151, 158, 170, 174],
                           54: [97, 100, 112, 124, 129, 143, 149, 155, 171, 177],
                           55: [97, 101, 113, 125, 127, 144, 150, 156, 169, 175],
                           56: [97, 102, 114, 126, 128, 142, 148, 154, 170, 176],
                           57: [97, 103, 115, 118, 132, 137, 152, 158, 165, 180],
                           58: [97, 104, 116, 119, 130, 138, 153, 159, 163, 178],
                           59: [97, 105, 117, 120, 131, 136, 151, 157, 164, 179],
                           60: [97, 106, 109, 121, 135, 140, 146, 161, 168, 174],
                           61: [97, 107, 110, 122, 133, 141, 147, 162, 166, 172],
                           62: [97, 108, 111, 123, 134, 139, 145, 160, 167, 173],
                           63: [98, 100, 114, 125, 135, 139, 147, 158, 164, 178],
                           64: [98, 101, 112, 126, 133, 140, 145, 159, 165, 179],
                           65: [98, 102, 113, 124, 134, 141, 146, 157, 163, 180],
                           66: [98, 103, 117, 119, 129, 142, 150, 161, 167, 172],
                           67: [98, 104, 115, 120, 127, 143, 148, 162, 168, 173],
                           68: [98, 105, 116, 118, 128, 144, 149, 160, 166, 174],
                           69: [98, 106, 111, 122, 132, 136, 153, 155, 170, 175],
                           70: [98, 107, 109, 123, 130, 137, 151, 156, 171, 176],
                           71: [98, 108, 110, 121, 131, 138, 152, 154, 169, 177],
                           72: [99, 100, 113, 126, 132, 138, 151, 161, 166, 173],
                           73: [99, 101, 114, 124, 130, 136, 152, 162, 167, 174],
                           74: [99, 102, 112, 125, 131, 137, 153, 160, 168, 172],
                           75: [99, 103, 116, 120, 135, 141, 145, 155, 169, 176],
                           76: [99, 104, 117, 118, 133, 139, 146, 156, 170, 177],
                           77: [99, 105, 115, 119, 134, 140, 147, 154, 171, 175],
                           78: [99, 106, 110, 123, 129, 144, 148, 158, 163, 179],
                           79: [99, 107, 111, 121, 127, 142, 149, 159, 164, 180],
                           80: [99, 108, 109, 122, 128, 143, 150, 157, 165, 178],
                           81: [91, 92, 93, 94, 95, 96, 97, 98, 99, 181],
                           82: [100, 101, 102, 103, 104, 105, 106, 107, 108, 181],
                           83: [109, 110, 111, 112, 113, 114, 115, 116, 117, 181],
                           84: [118, 119, 120, 121, 122, 123, 124, 125, 126, 181],
                           85: [127, 128, 129, 130, 131, 132, 133, 134, 135, 181],
                           86: [136, 137, 138, 139, 140, 141, 142, 143, 144, 181],
                           87: [145, 146, 147, 148, 149, 150, 151, 152, 153, 181],
                           88: [154, 155, 156, 157, 158, 159, 160, 161, 162, 181],
                           89: [163, 164, 165, 166, 167, 168, 169, 170, 171, 181],
                           90: [172, 173, 174, 175, 176, 177, 178, 179, 180, 181],
                           91: [0, 1, 2, 3, 4, 5, 6, 7, 8, 81],
                           92: [9, 10, 11, 12, 13, 14, 15, 16, 17, 81],
                           93: [18, 19, 20, 21, 22, 23, 24, 25, 26, 81],
                           94: [27, 28, 29, 30, 31, 32, 33, 34, 35, 81],
                           95: [36, 37, 38, 39, 40, 41, 42, 43, 44, 81],
                           96: [45, 46, 47, 48, 49, 50, 51, 52, 53, 81],
                           97: [54, 55, 56, 57, 58, 59, 60, 61, 62, 81],
                           98: [63, 64, 65, 66, 67, 68, 69, 70, 71, 81],
                           99: [72, 73, 74, 75, 76, 77, 78, 79, 80, 81],
                           100: [0, 9, 18, 27, 36, 45, 54, 63, 72, 82],
                           101: [1, 10, 19, 28, 37, 46, 55, 64, 73, 82],
                           102: [2, 11, 20, 29, 38, 47, 56, 65, 74, 82],
                           103: [3, 12, 21, 30, 39, 48, 57, 66, 75, 82],
                           104: [4, 13, 22, 31, 40, 49, 58, 67, 76, 82],
                           105: [5, 14, 23, 32, 41, 50, 59, 68, 77, 82],
                           106: [6, 15, 24, 33, 42, 51, 60, 69, 78, 82],
                           107: [7, 16, 25, 34, 43, 52, 61, 70, 79, 82],
                           108: [8, 17, 26, 35, 44, 53, 62, 71, 80, 82],
                           109: [0, 10, 20, 30, 40, 50, 60, 70, 80, 83],
                           110: [1, 11, 18, 31, 41, 48, 61, 71, 78, 83],
                           111: [2, 9, 19, 32, 39, 49, 62, 69, 79, 83],
                           112: [3, 13, 23, 33, 43, 53, 54, 64, 74, 83],
                           113: [4, 14, 21, 34, 44, 51, 55, 65, 72, 83],
                           114: [5, 12, 22, 35, 42, 52, 56, 63, 73, 83],
                           115: [6, 16, 26, 27, 37, 47, 57, 67, 77, 83],
                           116: [7, 17, 24, 28, 38, 45, 58, 68, 75, 83],
                           117: [8, 15, 25, 29, 36, 46, 59, 66, 76, 83],
                           118: [0, 11, 19, 33, 44, 52, 57, 68, 76, 84],
                           119: [1, 9, 20, 34, 42, 53, 58, 66, 77, 84],
                           120: [2, 10, 18, 35, 43, 51, 59, 67, 75, 84],
                           121: [3, 14, 22, 27, 38, 46, 60, 71, 79, 84],
                           122: [4, 12, 23, 28, 36, 47, 61, 69, 80, 84],
                           123: [5, 13, 21, 29, 37, 45, 62, 70, 78, 84],
                           124: [6, 17, 25, 30, 41, 49, 54, 65, 73, 84],
                           125: [7, 15, 26, 31, 39, 50, 55, 63, 74, 84],
                           126: [8, 16, 24, 32, 40, 48, 56, 64, 72, 84],
                           127: [0, 12, 24, 29, 41, 53, 55, 67, 79, 85],
                           128: [1, 13, 25, 27, 39, 51, 56, 68, 80, 85],
                           129: [2, 14, 26, 28, 40, 52, 54, 66, 78, 85],
                           130: [3, 15, 18, 32, 44, 47, 58, 70, 73, 85],
                           131: [4, 16, 19, 30, 42, 45, 59, 71, 74, 85],
                           132: [5, 17, 20, 31, 43, 46, 57, 69, 72, 85],
                           133: [6, 9, 21, 35, 38, 50, 61, 64, 76, 85],
                           134: [7, 10, 22, 33, 36, 48, 62, 65, 77, 85],
                           135: [8, 11, 23, 34, 37, 49, 60, 63, 75, 85],
                           136: [0, 13, 26, 34, 38, 48, 59, 69, 73, 86],
                           137: [1, 14, 24, 35, 36, 49, 57, 70, 74, 86],
                           138: [2, 12, 25, 33, 37, 50, 58, 71, 72, 86],
                           139: [3, 16, 20, 28, 41, 51, 62, 63, 76, 86],
                           140: [4, 17, 18, 29, 39, 52, 60, 64, 77, 86],
                           141: [5, 15, 19, 27, 40, 53, 61, 65, 75, 86],
                           142: [6, 10, 23, 31, 44, 45, 56, 66, 79, 86],
                           143: [7, 11, 21, 32, 42, 46, 54, 67, 80, 86],
                           144: [8, 9, 22, 30, 43, 47, 55, 68, 78, 86],
                           145: [0, 14, 25, 31, 42, 47, 62, 64, 75, 87],
                           146: [1, 12, 26, 32, 43, 45, 60, 65, 76, 87],
                           147: [2, 13, 24, 30, 44, 46, 61, 63, 77, 87],
                           148: [3, 17, 19, 34, 36, 50, 56, 67, 78, 87],
                           149: [4, 15, 20, 35, 37, 48, 54, 68, 79, 87],
                           150: [5, 16, 18, 33, 38, 49, 55, 66, 80, 87],
                           151: [6, 11, 22, 28, 39, 53, 59, 70, 72, 87],
                           152: [7, 9, 23, 29, 40, 51, 57, 71, 73, 87],
                           153: [8, 10, 21, 27, 41, 52, 58, 69, 74, 87],
                           154: [0, 15, 21, 28, 43, 49, 56, 71, 77, 88],
                           155: [1, 16, 22, 29, 44, 50, 54, 69, 75, 88],
                           156: [2, 17, 23, 27, 42, 48, 55, 70, 76, 88],
                           157: [3, 9, 24, 31, 37, 52, 59, 65, 80, 88],
                           158: [4, 10, 25, 32, 38, 53, 57, 63, 78, 88],
                           159: [5, 11, 26, 30, 36, 51, 58, 64, 79, 88],
                           160: [6, 12, 18, 34, 40, 46, 62, 68, 74, 88],
                           161: [7, 13, 19, 35, 41, 47, 60, 66, 72, 88],
                           162: [8, 14, 20, 33, 39, 45, 61, 67, 73, 88],
                           163: [0, 16, 23, 35, 39, 46, 58, 65, 78, 89],
                           164: [1, 17, 21, 33, 40, 47, 59, 63, 79, 89],
                           165: [2, 15, 22, 34, 41, 45, 57, 64, 80, 89],
                           166: [3, 10, 26, 29, 42, 49, 61, 68, 72, 89],
                           167: [4, 11, 24, 27, 43, 50, 62, 66, 73, 89],
                           168: [5, 9, 25, 28, 44, 48, 60, 67, 74, 89],
                           169: [6, 13, 20, 32, 36, 52, 55, 71, 75, 89],
                           170: [7, 14, 18, 30, 37, 53, 56, 69, 76, 89],
                           171: [8, 12, 19, 31, 38, 51, 54, 70, 77, 89],
                           172: [0, 17, 22, 32, 37, 51, 61, 66, 74, 90],
                           173: [1, 15, 23, 30, 38, 52, 62, 67, 72, 90],
                           174: [2, 16, 21, 31, 36, 53, 60, 68, 73, 90],
                           175: [3, 11, 25, 35, 40, 45, 55, 69, 77, 90],
                           176: [4, 9, 26, 33, 41, 46, 56, 70, 75, 90],
                           177: [5, 10, 24, 34, 39, 47, 54, 71, 76, 90],
                           178: [6, 14, 19, 29, 43, 48, 58, 63, 80, 90],
                           179: [7, 12, 20, 27, 44, 49, 59, 64, 78, 90],
                           180: [8, 13, 18, 28, 42, 50, 57, 65, 79, 90],
                           181: [81, 82, 83, 84, 85, 86, 87, 88, 89, 90],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 4, # number of orbits
                 311040, # grpsize
                 [ # autgrp generators
                     [0, 1, 2, 4, 5, 3, 8, 6, 7, 9, 10, 11, 13, 14, 12, 17, 15, 16, 18, 19, 20, 22, 23, 21, 26, 24, 25, 36, 37, 38, 40, 41, 39, 44, 42, 43, 45, 46, 47, 49, 50, 48, 53, 51, 52, 27, 28, 29, 31, 32, 30, 35, 33, 34, 72, 73, 74, 76, 77, 75, 80, 78, 79, 54, 55, 56, 58, 59, 57, 62, 60, 61, 63, 64, 65, 67, 68, 66, 71, 69, 70, 81, 82, 83, 84, 86, 87, 85, 90, 88, 89, 91, 92, 93, 95, 96, 94, 99, 97, 98, 100, 101, 102, 104, 105, 103, 108, 106, 107, 109, 110, 111, 113, 114, 112, 117, 115, 116, 118, 119, 120, 122, 123, 121, 126, 124, 125, 136, 137, 138, 140, 141, 139, 144, 142, 143, 145, 146, 147, 149, 150, 148, 153, 151, 152, 127, 128, 129, 131, 132, 130, 135, 133, 134, 172, 173, 174, 176, 177, 175, 180, 178, 179, 154, 155, 156, 158, 159, 157, 162, 160, 161, 163, 164, 165, 167, 168, 166, 171, 169, 170, 181],
                     [0, 1, 2, 6, 7, 8, 3, 4, 5, 9, 10, 11, 15, 16, 17, 12, 13, 14, 18, 19, 20, 24, 25, 26, 21, 22, 23, 54, 55, 56, 60, 61, 62, 57, 58, 59, 63, 64, 65, 69, 70, 71, 66, 67, 68, 72, 73, 74, 78, 79, 80, 75, 76, 77, 27, 28, 29, 33, 34, 35, 30, 31, 32, 36, 37, 38, 42, 43, 44, 39, 40, 41, 45, 46, 47, 51, 52, 53, 48, 49, 50, 81, 82, 83, 84, 88, 89, 90, 85, 86, 87, 91, 92, 93, 97, 98, 99, 94, 95, 96, 100, 101, 102, 106, 107, 108, 103, 104, 105, 109, 110, 111, 115, 116, 117, 112, 113, 114, 118, 119, 120, 124, 125, 126, 121, 122, 123, 154, 155, 156, 160, 161, 162, 157, 158, 159, 163, 164, 165, 169, 170, 171, 166, 167, 168, 172, 173, 174, 178, 179, 180, 175, 176, 177, 127, 128, 129, 133, 134, 135, 130, 131, 132, 136, 137, 138, 142, 143, 144, 139, 140, 141, 145, 146, 147, 151, 152, 153, 148, 149, 150, 181],
                     [0, 1, 2, 6, 7, 8, 3, 4, 5, 18, 19, 20, 24, 25, 26, 21, 22, 23, 9, 10, 11, 15, 16, 17, 12, 13, 14, 27, 28, 29, 33, 34, 35, 30, 31, 32, 45, 46, 47, 51, 52, 53, 48, 49, 50, 36, 37, 38, 42, 43, 44, 39, 40, 41, 54, 55, 56, 60, 61, 62, 57, 58, 59, 72, 73, 74, 78, 79, 80, 75, 76, 77, 63, 64, 65, 69, 70, 71, 66, 67, 68, 81, 82, 84, 83, 85, 87, 86, 88, 90, 89, 91, 93, 92, 94, 96, 95, 97, 99, 98, 100, 101, 102, 106, 107, 108, 103, 104, 105, 118, 119, 120, 124, 125, 126, 121, 122, 123, 109, 110, 111, 115, 116, 117, 112, 113, 114, 127, 128, 129, 133, 134, 135, 130, 131, 132, 145, 146, 147, 151, 152, 153, 148, 149, 150, 136, 137, 138, 142, 143, 144, 139, 140, 141, 154, 155, 156, 160, 161, 162, 157, 158, 159, 172, 173, 174, 178, 179, 180, 175, 176, 177, 163, 164, 165, 169, 170, 171, 166, 167, 168, 181],
                     [0, 1, 2, 3, 4, 5, 6, 7, 8, 27, 28, 29, 30, 31, 32, 33, 34, 35, 54, 55, 56, 57, 58, 59, 60, 61, 62, 18, 19, 20, 21, 22, 23, 24, 25, 26, 45, 46, 47, 48, 49, 50, 51, 52, 53, 72, 73, 74, 75, 76, 77, 78, 79, 80, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 37, 38, 39, 40, 41, 42, 43, 44, 63, 64, 65, 66, 67, 68, 69, 70, 71, 81, 82, 88, 85, 83, 87, 90, 84, 86, 89, 91, 94, 97, 93, 96, 99, 92, 95, 98, 100, 101, 102, 103, 104, 105, 106, 107, 108, 154, 155, 156, 157, 158, 159, 160, 161, 162, 127, 128, 129, 130, 131, 132, 133, 134, 135, 109, 110, 111, 112, 113, 114, 115, 116, 117, 145, 146, 147, 148, 149, 150, 151, 152, 153, 172, 173, 174, 175, 176, 177, 178, 179, 180, 118, 119, 120, 121, 122, 123, 124, 125, 126, 136, 137, 138, 139, 140, 141, 142, 143, 144, 163, 164, 165, 166, 167, 168, 169, 170, 171, 181],
                     [0, 2, 1, 3, 5, 4, 6, 8, 7, 9, 11, 10, 12, 14, 13, 15, 17, 16, 18, 20, 19, 21, 23, 22, 24, 26, 25, 54, 56, 55, 57, 59, 58, 60, 62, 61, 63, 65, 64, 66, 68, 67, 69, 71, 70, 72, 74, 73, 75, 77, 76, 78, 80, 79, 27, 29, 28, 30, 32, 31, 33, 35, 34, 36, 38, 37, 39, 41, 40, 42, 44, 43, 45, 47, 46, 48, 50, 49, 51, 53, 52, 81, 82, 84, 83, 85, 87, 86, 88, 90, 89, 91, 92, 93, 97, 98, 99, 94, 95, 96, 100, 102, 101, 103, 105, 104, 106, 108, 107, 118, 120, 119, 121, 123, 122, 124, 126, 125, 109, 111, 110, 112, 114, 113, 115, 117, 116, 127, 129, 128, 130, 132, 131, 133, 135, 134, 145, 147, 146, 148, 150, 149, 151, 153, 152, 136, 138, 137, 139, 141, 140, 142, 144, 143, 154, 156, 155, 157, 159, 158, 160, 162, 161, 172, 174, 173, 175, 177, 176, 178, 180, 179, 163, 165, 164, 166, 168, 167, 169, 171, 170, 181],
                     [0, 3, 6, 1, 4, 7, 2, 5, 8, 9, 12, 15, 10, 13, 16, 11, 14, 17, 18, 21, 24, 19, 22, 25, 20, 23, 26, 54, 57, 60, 55, 58, 61, 56, 59, 62, 63, 66, 69, 64, 67, 70, 65, 68, 71, 72, 75, 78, 73, 76, 79, 74, 77, 80, 27, 30, 33, 28, 31, 34, 29, 32, 35, 36, 39, 42, 37, 40, 43, 38, 41, 44, 45, 48, 51, 46, 49, 52, 47, 50, 53, 81, 82, 85, 88, 83, 86, 89, 84, 87, 90, 91, 92, 93, 97, 98, 99, 94, 95, 96, 100, 103, 106, 101, 104, 107, 102, 105, 108, 127, 130, 133, 128, 131, 134, 129, 132, 135, 154, 157, 160, 155, 158, 161, 156, 159, 162, 109, 112, 115, 110, 113, 116, 111, 114, 117, 136, 139, 142, 137, 140, 143, 138, 141, 144, 163, 166, 169, 164, 167, 170, 165, 168, 171, 118, 121, 124, 119, 122, 125, 120, 123, 126, 145, 148, 151, 146, 149, 152, 147, 150, 153, 172, 175, 178, 173, 176, 179, 174, 177, 180, 181],
                     [0, 9, 18, 54, 63, 72, 27, 36, 45, 1, 10, 19, 55, 64, 73, 28, 37, 46, 2, 11, 20, 56, 65, 74, 29, 38, 47, 6, 15, 24, 60, 69, 78, 33, 42, 51, 7, 16, 25, 61, 70, 79, 34, 43, 52, 8, 17, 26, 62, 71, 80, 35, 44, 53, 3, 12, 21, 57, 66, 75, 30, 39, 48, 4, 13, 22, 58, 67, 76, 31, 40, 49, 5, 14, 23, 59, 68, 77, 32, 41, 50, 82, 81, 83, 84, 85, 87, 86, 88, 90, 89, 100, 101, 102, 106, 107, 108, 103, 104, 105, 91, 92, 93, 97, 98, 99, 94, 95, 96, 109, 111, 110, 112, 114, 113, 115, 117, 116, 118, 119, 120, 124, 125, 126, 121, 122, 123, 127, 133, 130, 129, 135, 132, 128, 134, 131, 145, 152, 150, 149, 147, 151, 153, 148, 146, 136, 144, 140, 143, 139, 138, 141, 137, 142, 154, 157, 160, 155, 158, 161, 156, 159, 162, 172, 176, 180, 177, 178, 173, 179, 174, 175, 163, 168, 170, 171, 164, 166, 167, 169, 165, 181],
                     [0, 10, 20, 30, 40, 50, 60, 70, 80, 11, 18, 1, 41, 48, 31, 71, 78, 61, 19, 2, 9, 49, 32, 39, 79, 62, 69, 33, 43, 53, 54, 64, 74, 3, 13, 23, 44, 51, 34, 65, 72, 55, 14, 21, 4, 52, 35, 42, 73, 56, 63, 22, 5, 12, 57, 67, 77, 6, 16, 26, 27, 37, 47, 68, 75, 58, 17, 24, 7, 38, 45, 28, 76, 59, 66, 25, 8, 15, 46, 29, 36, 83, 84, 82, 81, 85, 86, 87, 88, 89, 90, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 120, 119, 124, 126, 125, 121, 123, 122, 100, 101, 102, 103, 104, 105, 106, 107, 108, 91, 92, 93, 94, 95, 96, 97, 98, 99, 127, 134, 132, 131, 129, 133, 135, 130, 128, 136, 142, 139, 144, 141, 138, 140, 137, 143, 145, 153, 149, 147, 152, 148, 146, 151, 150, 154, 158, 162, 159, 160, 155, 161, 156, 157, 163, 166, 169, 170, 164, 167, 168, 171, 165, 172, 177, 179, 173, 175, 180, 174, 176, 178, 181],
                     [1, 0, 2, 4, 3, 5, 7, 6, 8, 10, 9, 11, 13, 12, 14, 16, 15, 17, 19, 18, 20, 22, 21, 23, 25, 24, 26, 55, 54, 56, 58, 57, 59, 61, 60, 62, 64, 63, 65, 67, 66, 68, 70, 69, 71, 73, 72, 74, 76, 75, 77, 79, 78, 80, 28, 27, 29, 31, 30, 32, 34, 33, 35, 37, 36, 38, 40, 39, 41, 43, 42, 44, 46, 45, 47, 49, 48, 50, 52, 51, 53, 81, 82, 84, 83, 85, 87, 86, 88, 90, 89, 91, 92, 93, 97, 98, 99, 94, 95, 96, 101, 100, 102, 104, 103, 105, 107, 106, 108, 119, 118, 120, 122, 121, 123, 125, 124, 126, 110, 109, 111, 113, 112, 114, 116, 115, 117, 128, 127, 129, 131, 130, 132, 134, 133, 135, 146, 145, 147, 149, 148, 150, 152, 151, 153, 137, 136, 138, 140, 139, 141, 143, 142, 144, 155, 154, 156, 158, 157, 159, 161, 160, 162, 173, 172, 174, 176, 175, 177, 179, 178, 180, 164, 163, 165, 167, 166, 168, 170, 169, 171, 181],
                 ]
                ]
    elif request.param == 'g13':
        return [ "g13",
                 Graph(number_of_vertices=13, directed=False,
                       adjacency_dict = {
                           0: [6, 7, 8, 9],
                           1: [6, 7, 8, 11],
                           2: [7, 8, 10, 12],
                           3: [7, 9, 11, 12],
                           4: [8, 10, 11, 12],
                           5: [9, 10, 11, 12],
                           6: [0, 1, 9, 10],
                           7: [0, 1, 2, 3],
                           8: [0, 1, 2, 4],
                           9: [0, 3, 5, 6],
                           10: [2, 4, 5, 6],
                           11: [1, 3, 4, 5],
                           12: [2, 3, 4, 5],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 13, # number of orbits
                 1, # grpsize
                 [ # autgrp generators
                 ]
                ]
    elif request.param == 'g15':
        return [ "g15",
                 Graph(number_of_vertices=15, directed=False,
                       adjacency_dict = {
                           0: [3, 7, 8, 12, 13, 14],
                           1: [3, 7, 8, 12, 13, 14],
                           2: [3, 6, 9, 10, 12, 14],
                           3: [0, 1, 2, 4, 9, 11],
                           4: [3, 6, 7, 8, 11, 14],
                           5: [6, 7, 10, 12, 13, 14],
                           6: [2, 4, 5, 9, 11, 12],
                           7: [0, 1, 4, 5, 11, 13],
                           8: [0, 1, 4, 9, 12, 13],
                           9: [2, 3, 6, 8, 10, 11],
                           10: [2, 5, 9, 11, 13, 14],
                           11: [3, 4, 6, 7, 9, 10],
                           12: [0, 1, 2, 5, 6, 8],
                           13: [0, 1, 5, 7, 8, 10],
                           14: [0, 1, 2, 4, 5, 10],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 14, # number of orbits
                 2, # grpsize
                 [ # autgrp generators
                     [1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14],
                 ]
                ]
    elif request.param == 'g16':
        return [ "g16",
                 Graph(number_of_vertices=16, directed=False,
                       adjacency_dict = {
                           0: [8, 9, 10, 11, 12],
                           1: [8, 9, 10, 11, 13],
                           2: [8, 9, 10, 14, 15],
                           3: [8, 9, 12, 13, 14],
                           4: [8, 9, 12, 13, 15],
                           5: [10, 11, 12, 14, 15],
                           6: [10, 11, 13, 14, 15],
                           7: [11, 12, 13, 14, 15],
                           8: [0, 1, 2, 3, 4],
                           9: [0, 1, 2, 3, 4],
                           10: [0, 1, 2, 5, 6],
                           11: [0, 1, 5, 6, 7],
                           12: [0, 3, 4, 5, 7],
                           13: [1, 3, 4, 6, 7],
                           14: [2, 3, 5, 6, 7],
                           15: [2, 4, 5, 6, 7],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 10, # number of orbits
                 8, # grpsize
                 [ # autgrp generators
                     [0, 1, 2, 3, 4, 5, 6, 7, 9, 8, 10, 11, 12, 13, 14, 15],
                     [0, 1, 2, 4, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 14],
                     [1, 0, 2, 3, 4, 6, 5, 7, 8, 9, 10, 11, 13, 12, 14, 15],
                 ]
                ]
    elif request.param == 'g16b':
        return [ "g16b",
          Graph(number_of_vertices=16, directed=False,
                adjacency_dict = {
                    0: [5, 10, 14],
                    1: [3, 5, 8],
                    2: [7, 12, 15],
                    3: [1, 11, 13],
                    4: [6, 11, 12],
                    5: [0, 1, 10],
                    6: [4, 9, 10],
                    7: [2, 8, 15],
                    8: [1, 7, 14],
                    9: [6, 12, 15],
                    10: [0, 5, 6],
                    11: [3, 4, 13],
                    12: [2, 4, 9],
                    13: [3, 11, 14],
                    14: [0, 8, 13],
                    15: [2, 7, 9],
                },
                vertex_coloring = [
                ],
                ),
          8, # number of orbits
          4, # grpsize
          [ # autgrp generators
              [3, 14, 15, 0, 6, 13, 4, 7, 8, 12, 11, 10, 9, 5, 1, 2],
              [5, 14, 2, 13, 4, 0, 6, 7, 8, 9, 10, 11, 12, 3, 1, 15],
          ]
         ]
    elif request.param == 'g33':
        return [ "g33",
                 Graph(number_of_vertices=33, directed=False,
                       adjacency_dict = {
                           0: [10, 11, 12, 14, 15, 16, 17, 18, 19, 21, 22, 23],
                           1: [11, 12, 13, 15, 16, 17, 18, 19, 20, 22, 23, 24],
                           2: [12, 13, 14, 16, 17, 18, 19, 20, 21, 23, 24, 25],
                           3: [13, 14, 15, 17, 18, 19, 20, 21, 22, 24, 25, 26],
                           4: [14, 15, 16, 18, 19, 20, 21, 22, 23, 25, 26, 27],
                           5: [15, 16, 17, 19, 20, 21, 22, 23, 24, 26, 27, 28],
                           6: [16, 17, 18, 20, 21, 22, 23, 24, 25, 27, 28, 29],
                           7: [17, 18, 19, 21, 22, 23, 24, 25, 26, 28, 29, 30],
                           8: [18, 19, 20, 22, 23, 24, 25, 26, 27, 29, 30, 31],
                           9: [19, 20, 21, 23, 24, 25, 26, 27, 28, 30, 31, 32],
                           10: [0, 20, 21, 22, 24, 25, 26, 27, 28, 29, 31, 32],
                           11: [0, 1, 21, 22, 23, 25, 26, 27, 28, 29, 30, 32],
                           12: [0, 1, 2, 22, 23, 24, 26, 27, 28, 29, 30, 31],
                           13: [1, 2, 3, 23, 24, 25, 27, 28, 29, 30, 31, 32],
                           14: [0, 2, 3, 4, 24, 25, 26, 28, 29, 30, 31, 32],
                           15: [0, 1, 3, 4, 5, 25, 26, 27, 29, 30, 31, 32],
                           16: [0, 1, 2, 4, 5, 6, 26, 27, 28, 30, 31, 32],
                           17: [0, 1, 2, 3, 5, 6, 7, 27, 28, 29, 31, 32],
                           18: [0, 1, 2, 3, 4, 6, 7, 8, 28, 29, 30, 32],
                           19: [0, 1, 2, 3, 4, 5, 7, 8, 9, 29, 30, 31],
                           20: [1, 2, 3, 4, 5, 6, 8, 9, 10, 30, 31, 32],
                           21: [0, 2, 3, 4, 5, 6, 7, 9, 10, 11, 31, 32],
                           22: [0, 1, 3, 4, 5, 6, 7, 8, 10, 11, 12, 32],
                           23: [0, 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13],
                           24: [1, 2, 3, 5, 6, 7, 8, 9, 10, 12, 13, 14],
                           25: [2, 3, 4, 6, 7, 8, 9, 10, 11, 13, 14, 15],
                           26: [3, 4, 5, 7, 8, 9, 10, 11, 12, 14, 15, 16],
                           27: [4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 17],
                           28: [5, 6, 7, 9, 10, 11, 12, 13, 14, 16, 17, 18],
                           29: [6, 7, 8, 10, 11, 12, 13, 14, 15, 17, 18, 19],
                           30: [7, 8, 9, 11, 12, 13, 14, 15, 16, 18, 19, 20],
                           31: [8, 9, 10, 12, 13, 14, 15, 16, 17, 19, 20, 21],
                           32: [9, 10, 11, 13, 14, 15, 16, 17, 18, 20, 21, 22],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 1, # number of orbits
                 66, # grpsize
                 [ # autgrp generators
                     [0, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1],
                     [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 0],
                 ]
                ]
    elif request.param == 'g6':
        return [ "g6",
                 Graph(number_of_vertices=6, directed=False,
                       adjacency_dict = {
                           0: [3, 4, 5],
                           1: [3, 4, 5],
                           2: [3, 4, 5],
                           3: [0, 1, 2],
                           4: [0, 1, 2],
                           5: [0, 1, 2],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 1, # number of orbits
                 72, # grpsize
                 [ # autgrp generators
                     [0, 2, 1, 3, 4, 5],
                     [0, 1, 2, 3, 5, 4],
                     [0, 1, 2, 4, 3, 5],
                     [1, 0, 2, 3, 4, 5],
                     [3, 4, 5, 0, 1, 2],
                 ]
                ]
    elif request.param == 'g63':
        return [ "g63",
                 Graph(number_of_vertices=63, directed=False,
                       adjacency_dict = {
                           0: [6, 24, 30, 33, 39, 57],
                           1: [7, 25, 31, 34, 40, 58],
                           2: [8, 26, 32, 35, 41, 59],
                           3: [9, 27, 33, 36, 42, 60],
                           4: [10, 28, 34, 37, 43, 61],
                           5: [11, 29, 35, 38, 44, 62],
                           6: [0, 12, 30, 36, 39, 45],
                           7: [1, 13, 31, 37, 40, 46],
                           8: [2, 14, 32, 38, 41, 47],
                           9: [3, 15, 33, 39, 42, 48],
                           10: [4, 16, 34, 40, 43, 49],
                           11: [5, 17, 35, 41, 44, 50],
                           12: [6, 18, 36, 42, 45, 51],
                           13: [7, 19, 37, 43, 46, 52],
                           14: [8, 20, 38, 44, 47, 53],
                           15: [9, 21, 39, 45, 48, 54],
                           16: [10, 22, 40, 46, 49, 55],
                           17: [11, 23, 41, 47, 50, 56],
                           18: [12, 24, 42, 48, 51, 57],
                           19: [13, 25, 43, 49, 52, 58],
                           20: [14, 26, 44, 50, 53, 59],
                           21: [15, 27, 45, 51, 54, 60],
                           22: [16, 28, 46, 52, 55, 61],
                           23: [17, 29, 47, 53, 56, 62],
                           24: [0, 18, 30, 48, 54, 57],
                           25: [1, 19, 31, 49, 55, 58],
                           26: [2, 20, 32, 50, 56, 59],
                           27: [3, 21, 33, 51, 57, 60],
                           28: [4, 22, 34, 52, 58, 61],
                           29: [5, 23, 35, 53, 59, 62],
                           30: [0, 6, 24, 36, 54, 60],
                           31: [1, 7, 25, 37, 55, 61],
                           32: [2, 8, 26, 38, 56, 62],
                           33: [0, 3, 9, 27, 39, 57],
                           34: [1, 4, 10, 28, 40, 58],
                           35: [2, 5, 11, 29, 41, 59],
                           36: [3, 6, 12, 30, 42, 60],
                           37: [4, 7, 13, 31, 43, 61],
                           38: [5, 8, 14, 32, 44, 62],
                           39: [0, 6, 9, 15, 33, 45],
                           40: [1, 7, 10, 16, 34, 46],
                           41: [2, 8, 11, 17, 35, 47],
                           42: [3, 9, 12, 18, 36, 48],
                           43: [4, 10, 13, 19, 37, 49],
                           44: [5, 11, 14, 20, 38, 50],
                           45: [6, 12, 15, 21, 39, 51],
                           46: [7, 13, 16, 22, 40, 52],
                           47: [8, 14, 17, 23, 41, 53],
                           48: [9, 15, 18, 24, 42, 54],
                           49: [10, 16, 19, 25, 43, 55],
                           50: [11, 17, 20, 26, 44, 56],
                           51: [12, 18, 21, 27, 45, 57],
                           52: [13, 19, 22, 28, 46, 58],
                           53: [14, 20, 23, 29, 47, 59],
                           54: [15, 21, 24, 30, 48, 60],
                           55: [16, 22, 25, 31, 49, 61],
                           56: [17, 23, 26, 32, 50, 62],
                           57: [0, 18, 24, 27, 33, 51],
                           58: [1, 19, 25, 28, 34, 52],
                           59: [2, 20, 26, 29, 35, 53],
                           60: [3, 21, 27, 30, 36, 54],
                           61: [4, 22, 28, 31, 37, 55],
                           62: [5, 23, 29, 32, 38, 56],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 1, # number of orbits
                 12002256, # grpsize
                 [ # autgrp generators
                     [0, 1, 2, 3, 4, 14, 6, 7, 26, 9, 10, 38, 12, 13, 50, 15, 16, 62, 18, 19, 11, 21, 22, 23, 24, 25, 35, 27, 28, 47, 30, 31, 59, 33, 34, 8, 36, 37, 20, 39, 40, 32, 42, 43, 44, 45, 46, 56, 48, 49, 5, 51, 52, 17, 54, 55, 29, 57, 58, 41, 60, 61, 53],
                     [0, 1, 2, 3, 4, 17, 6, 7, 32, 9, 10, 47, 12, 13, 62, 15, 16, 14, 18, 19, 29, 21, 22, 44, 24, 25, 59, 27, 28, 11, 30, 31, 26, 33, 34, 41, 36, 37, 56, 39, 40, 8, 42, 43, 23, 45, 46, 38, 48, 49, 53, 51, 52, 5, 54, 55, 20, 57, 58, 35, 60, 61, 50],
                     [0, 1, 5, 3, 4, 2, 6, 7, 62, 9, 10, 59, 12, 13, 56, 15, 16, 53, 18, 19, 50, 21, 22, 47, 24, 25, 44, 27, 28, 41, 30, 31, 38, 33, 34, 35, 36, 37, 32, 39, 40, 29, 42, 43, 26, 45, 46, 23, 48, 49, 20, 51, 52, 17, 54, 55, 14, 57, 58, 11, 60, 61, 8],
                     [0, 1, 2, 3, 13, 5, 6, 25, 8, 9, 37, 11, 12, 49, 14, 15, 61, 17, 18, 10, 20, 21, 22, 23, 24, 34, 26, 27, 46, 29, 30, 58, 32, 33, 7, 35, 36, 19, 38, 39, 31, 41, 42, 43, 44, 45, 55, 47, 48, 4, 50, 51, 16, 53, 54, 28, 56, 57, 40, 59, 60, 52, 62],
                     [0, 1, 2, 3, 16, 5, 6, 31, 8, 9, 46, 11, 12, 61, 14, 15, 13, 17, 18, 28, 20, 21, 43, 23, 24, 58, 26, 27, 10, 29, 30, 25, 32, 33, 40, 35, 36, 55, 38, 39, 7, 41, 42, 22, 44, 45, 37, 47, 48, 52, 50, 51, 4, 53, 54, 19, 56, 57, 34, 59, 60, 49, 62],
                     [0, 2, 1, 3, 5, 4, 6, 8, 7, 9, 11, 10, 12, 14, 13, 15, 17, 16, 18, 20, 19, 21, 23, 22, 24, 26, 25, 27, 29, 28, 30, 32, 31, 33, 35, 34, 36, 38, 37, 39, 41, 40, 42, 44, 43, 45, 47, 46, 48, 50, 49, 51, 53, 52, 54, 56, 55, 57, 59, 58, 60, 62, 61],
                     [0, 1, 2, 12, 4, 5, 24, 7, 8, 36, 10, 11, 48, 13, 14, 60, 16, 17, 9, 19, 20, 21, 22, 23, 33, 25, 26, 45, 28, 29, 57, 31, 32, 6, 34, 35, 18, 37, 38, 30, 40, 41, 42, 43, 44, 54, 46, 47, 3, 49, 50, 15, 52, 53, 27, 55, 56, 39, 58, 59, 51, 61, 62],
                     [0, 1, 2, 15, 4, 5, 30, 7, 8, 45, 10, 11, 60, 13, 14, 12, 16, 17, 27, 19, 20, 42, 22, 23, 57, 25, 26, 9, 28, 29, 24, 31, 32, 39, 34, 35, 54, 37, 38, 6, 40, 41, 21, 43, 44, 36, 46, 47, 51, 49, 50, 3, 52, 53, 18, 55, 56, 33, 58, 59, 48, 61, 62],
                     [1, 0, 2, 4, 3, 5, 7, 6, 8, 10, 9, 11, 13, 12, 14, 16, 15, 17, 19, 18, 20, 22, 21, 23, 25, 24, 26, 28, 27, 29, 31, 30, 32, 34, 33, 35, 37, 36, 38, 40, 39, 41, 43, 42, 44, 46, 45, 47, 49, 48, 50, 52, 51, 53, 55, 54, 56, 58, 57, 59, 61, 60, 62],
                 ]
                ]
    elif request.param == "hadamard-7-96":
        return [ "hadamard-7-96",
                 Graph(number_of_vertices=96, directed=False,
                       adjacency_dict = {
                           0: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71],
                           1: [60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83],
                           2: [54, 55, 56, 57, 58, 59, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 84, 85, 86, 87, 88, 89],
                           3: [48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89],
                           4: [51, 52, 53, 57, 58, 59, 63, 64, 65, 69, 70, 71, 72, 73, 74, 78, 79, 80, 84, 85, 86, 90, 91, 92],
                           5: [48, 49, 50, 54, 55, 56, 63, 64, 65, 69, 70, 71, 75, 76, 77, 81, 82, 83, 84, 85, 86, 90, 91, 92],
                           6: [50, 51, 52, 54, 55, 59, 62, 63, 64, 66, 67, 71, 72, 73, 77, 80, 81, 82, 84, 85, 89, 92, 93, 94],
                           7: [49, 51, 53, 54, 56, 59, 61, 63, 65, 66, 68, 71, 72, 74, 76, 79, 81, 82, 84, 86, 88, 91, 93, 94],
                           8: [48, 52, 53, 55, 56, 59, 60, 64, 65, 67, 68, 71, 73, 74, 75, 78, 81, 82, 85, 86, 87, 90, 93, 94],
                           9: [48, 50, 51, 56, 57, 59, 60, 62, 63, 68, 69, 71, 73, 76, 77, 78, 79, 82, 85, 88, 89, 90, 91, 94],
                           10: [49, 50, 53, 55, 57, 59, 61, 62, 65, 67, 69, 71, 72, 75, 76, 78, 80, 82, 84, 87, 88, 90, 92, 94],
                           11: [48, 49, 52, 54, 57, 59, 60, 61, 64, 66, 69, 71, 74, 75, 77, 79, 80, 82, 86, 87, 89, 91, 92, 94],
                           12: [49, 50, 52, 56, 58, 59, 61, 62, 64, 68, 70, 71, 72, 75, 77, 78, 79, 81, 84, 87, 89, 90, 91, 93],
                           13: [48, 49, 51, 55, 58, 59, 60, 61, 63, 67, 70, 71, 74, 76, 77, 78, 80, 81, 86, 88, 89, 90, 92, 93],
                           14: [48, 50, 53, 54, 58, 59, 60, 62, 65, 66, 70, 71, 73, 75, 76, 79, 80, 81, 85, 87, 88, 91, 92, 93],
                           15: [48, 49, 53, 56, 57, 58, 62, 63, 64, 66, 67, 71, 74, 75, 76, 78, 79, 83, 84, 85, 89, 92, 93, 94],
                           16: [48, 50, 52, 55, 57, 58, 61, 63, 65, 66, 68, 71, 73, 75, 77, 78, 80, 83, 84, 86, 88, 91, 93, 94],
                           17: [49, 50, 51, 54, 57, 58, 60, 64, 65, 67, 68, 71, 72, 76, 77, 79, 80, 83, 85, 86, 87, 90, 93, 94],
                           18: [49, 52, 53, 54, 55, 57, 60, 62, 63, 68, 70, 71, 72, 74, 75, 80, 82, 83, 85, 88, 89, 90, 91, 93],
                           19: [48, 51, 52, 54, 56, 57, 61, 62, 65, 67, 70, 71, 73, 74, 77, 79, 82, 83, 84, 87, 88, 90, 92, 93],
                           20: [50, 51, 53, 55, 56, 57, 60, 61, 64, 66, 70, 71, 72, 73, 76, 78, 82, 83, 86, 87, 89, 91, 92, 93],
                           21: [48, 51, 53, 54, 55, 58, 61, 62, 64, 68, 69, 71, 73, 74, 76, 80, 81, 83, 84, 87, 89, 90, 91, 94],
                           22: [50, 52, 53, 54, 56, 58, 60, 61, 63, 67, 69, 71, 72, 73, 75, 79, 81, 83, 86, 88, 89, 90, 92, 94],
                           23: [49, 51, 52, 55, 56, 58, 60, 62, 65, 66, 69, 71, 72, 74, 77, 78, 81, 83, 85, 87, 88, 91, 92, 94],
                           24: [72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95],
                           25: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95],
                           26: [48, 49, 50, 51, 52, 53, 60, 61, 62, 63, 64, 65, 78, 79, 80, 81, 82, 83, 90, 91, 92, 93, 94, 95],
                           27: [54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 72, 73, 74, 75, 76, 77, 90, 91, 92, 93, 94, 95],
                           28: [48, 49, 50, 54, 55, 56, 60, 61, 62, 66, 67, 68, 75, 76, 77, 81, 82, 83, 87, 88, 89, 93, 94, 95],
                           29: [51, 52, 53, 57, 58, 59, 60, 61, 62, 66, 67, 68, 72, 73, 74, 78, 79, 80, 87, 88, 89, 93, 94, 95],
                           30: [48, 49, 53, 56, 57, 58, 60, 61, 65, 68, 69, 70, 74, 75, 76, 78, 79, 83, 86, 87, 88, 90, 91, 95],
                           31: [48, 50, 52, 55, 57, 58, 60, 62, 64, 67, 69, 70, 73, 75, 77, 78, 80, 83, 85, 87, 89, 90, 92, 95],
                           32: [49, 50, 51, 54, 57, 58, 61, 62, 63, 66, 69, 70, 72, 76, 77, 79, 80, 83, 84, 88, 89, 91, 92, 95],
                           33: [49, 52, 53, 54, 55, 58, 61, 64, 65, 66, 67, 70, 72, 74, 75, 80, 81, 83, 84, 86, 87, 92, 93, 95],
                           34: [48, 51, 52, 54, 56, 58, 60, 63, 64, 66, 68, 70, 73, 74, 77, 79, 81, 83, 85, 86, 89, 91, 93, 95],
                           35: [50, 51, 53, 55, 56, 58, 62, 63, 65, 67, 68, 70, 72, 73, 76, 78, 81, 83, 84, 85, 88, 90, 93, 95],
                           36: [48, 51, 53, 54, 55, 57, 60, 63, 65, 66, 67, 69, 73, 74, 76, 80, 82, 83, 85, 86, 88, 92, 94, 95],
                           37: [50, 52, 53, 54, 56, 57, 62, 64, 65, 66, 68, 69, 72, 73, 75, 79, 82, 83, 84, 85, 87, 91, 94, 95],
                           38: [49, 51, 52, 55, 56, 57, 61, 63, 64, 67, 68, 69, 72, 74, 77, 78, 82, 83, 84, 86, 89, 90, 94, 95],
                           39: [50, 51, 52, 54, 55, 59, 60, 61, 65, 68, 69, 70, 72, 73, 77, 80, 81, 82, 86, 87, 88, 90, 91, 95],
                           40: [49, 51, 53, 54, 56, 59, 60, 62, 64, 67, 69, 70, 72, 74, 76, 79, 81, 82, 85, 87, 89, 90, 92, 95],
                           41: [48, 52, 53, 55, 56, 59, 61, 62, 63, 66, 69, 70, 73, 74, 75, 78, 81, 82, 84, 88, 89, 91, 92, 95],
                           42: [48, 50, 51, 56, 58, 59, 61, 64, 65, 66, 67, 69, 73, 76, 77, 78, 79, 81, 84, 86, 87, 92, 94, 95],
                           43: [49, 50, 53, 55, 58, 59, 60, 63, 64, 66, 68, 69, 72, 75, 76, 78, 80, 81, 85, 86, 89, 91, 94, 95],
                           44: [48, 49, 52, 54, 58, 59, 62, 63, 65, 67, 68, 69, 74, 75, 77, 79, 80, 81, 84, 85, 88, 90, 94, 95],
                           45: [49, 50, 52, 56, 57, 59, 60, 63, 65, 66, 67, 70, 72, 75, 77, 78, 79, 82, 85, 86, 88, 92, 93, 95],
                           46: [48, 49, 51, 55, 57, 59, 62, 64, 65, 66, 68, 70, 74, 76, 77, 78, 80, 82, 84, 85, 87, 91, 93, 95],
                           47: [48, 50, 53, 54, 57, 59, 61, 63, 64, 67, 68, 70, 73, 75, 76, 79, 80, 82, 84, 86, 89, 90, 93, 95],
                           48: [0, 3, 5, 8, 9, 11, 13, 14, 15, 16, 19, 21, 25, 26, 28, 30, 31, 34, 36, 41, 42, 44, 46, 47],
                           49: [0, 3, 5, 7, 10, 11, 12, 13, 15, 17, 18, 23, 25, 26, 28, 30, 32, 33, 38, 40, 43, 44, 45, 46],
                           50: [0, 3, 5, 6, 9, 10, 12, 14, 16, 17, 20, 22, 25, 26, 28, 31, 32, 35, 37, 39, 42, 43, 45, 47],
                           51: [0, 3, 4, 6, 7, 9, 13, 17, 19, 20, 21, 23, 25, 26, 29, 32, 34, 35, 36, 38, 39, 40, 42, 46],
                           52: [0, 3, 4, 6, 8, 11, 12, 16, 18, 19, 22, 23, 25, 26, 29, 31, 33, 34, 37, 38, 39, 41, 44, 45],
                           53: [0, 3, 4, 7, 8, 10, 14, 15, 18, 20, 21, 22, 25, 26, 29, 30, 33, 35, 36, 37, 40, 41, 43, 47],
                           54: [0, 2, 5, 6, 7, 11, 14, 17, 18, 19, 21, 22, 25, 27, 28, 32, 33, 34, 36, 37, 39, 40, 44, 47],
                           55: [0, 2, 5, 6, 8, 10, 13, 16, 18, 20, 21, 23, 25, 27, 28, 31, 33, 35, 36, 38, 39, 41, 43, 46],
                           56: [0, 2, 5, 7, 8, 9, 12, 15, 19, 20, 22, 23, 25, 27, 28, 30, 34, 35, 37, 38, 40, 41, 42, 45],
                           57: [0, 2, 4, 9, 10, 11, 15, 16, 17, 18, 19, 20, 25, 27, 29, 30, 31, 32, 36, 37, 38, 45, 46, 47],
                           58: [0, 2, 4, 12, 13, 14, 15, 16, 17, 21, 22, 23, 25, 27, 29, 30, 31, 32, 33, 34, 35, 42, 43, 44],
                           59: [0, 2, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 25, 27, 29, 39, 40, 41, 42, 43, 44, 45, 46, 47],
                           60: [0, 1, 8, 9, 11, 13, 14, 17, 18, 20, 22, 23, 26, 27, 28, 29, 30, 31, 34, 36, 39, 40, 43, 45],
                           61: [0, 1, 7, 10, 11, 12, 13, 16, 19, 20, 21, 22, 26, 27, 28, 29, 30, 32, 33, 38, 39, 41, 42, 47],
                           62: [0, 1, 6, 9, 10, 12, 14, 15, 18, 19, 21, 23, 26, 27, 28, 29, 31, 32, 35, 37, 40, 41, 44, 46],
                           63: [0, 1, 4, 5, 6, 7, 9, 13, 15, 16, 18, 22, 26, 27, 32, 34, 35, 36, 38, 41, 43, 44, 45, 47],
                           64: [0, 1, 4, 5, 6, 8, 11, 12, 15, 17, 20, 21, 26, 27, 31, 33, 34, 37, 38, 40, 42, 43, 46, 47],
                           65: [0, 1, 4, 5, 7, 8, 10, 14, 16, 17, 19, 23, 26, 27, 30, 33, 35, 36, 37, 39, 42, 44, 45, 46],
                           66: [0, 1, 2, 3, 6, 7, 11, 14, 15, 16, 20, 23, 28, 29, 32, 33, 34, 36, 37, 41, 42, 43, 45, 46],
                           67: [0, 1, 2, 3, 6, 8, 10, 13, 15, 17, 19, 22, 28, 29, 31, 33, 35, 36, 38, 40, 42, 44, 45, 47],
                           68: [0, 1, 2, 3, 7, 8, 9, 12, 16, 17, 18, 21, 28, 29, 30, 34, 35, 37, 38, 39, 43, 44, 46, 47],
                           69: [0, 1, 2, 3, 4, 5, 9, 10, 11, 21, 22, 23, 30, 31, 32, 36, 37, 38, 39, 40, 41, 42, 43, 44],
                           70: [0, 1, 2, 3, 4, 5, 12, 13, 14, 18, 19, 20, 30, 31, 32, 33, 34, 35, 39, 40, 41, 45, 46, 47],
                           71: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
                           72: [1, 2, 4, 6, 7, 10, 12, 17, 18, 20, 22, 23, 24, 27, 29, 32, 33, 35, 37, 38, 39, 40, 43, 45],
                           73: [1, 2, 4, 6, 8, 9, 14, 16, 19, 20, 21, 22, 24, 27, 29, 31, 34, 35, 36, 37, 39, 41, 42, 47],
                           74: [1, 2, 4, 7, 8, 11, 13, 15, 18, 19, 21, 23, 24, 27, 29, 30, 33, 34, 36, 38, 40, 41, 44, 46],
                           75: [1, 2, 5, 8, 10, 11, 12, 14, 15, 16, 18, 22, 24, 27, 28, 30, 31, 33, 37, 41, 43, 44, 45, 47],
                           76: [1, 2, 5, 7, 9, 10, 13, 14, 15, 17, 20, 21, 24, 27, 28, 30, 32, 35, 36, 40, 42, 43, 46, 47],
                           77: [1, 2, 5, 6, 9, 11, 12, 13, 16, 17, 19, 23, 24, 27, 28, 31, 32, 34, 38, 39, 42, 44, 45, 46],
                           78: [1, 3, 4, 8, 9, 10, 12, 13, 15, 16, 20, 23, 24, 26, 29, 30, 31, 35, 38, 41, 42, 43, 45, 46],
                           79: [1, 3, 4, 7, 9, 11, 12, 14, 15, 17, 19, 22, 24, 26, 29, 30, 32, 34, 37, 40, 42, 44, 45, 47],
                           80: [1, 3, 4, 6, 10, 11, 13, 14, 16, 17, 18, 21, 24, 26, 29, 31, 32, 33, 36, 39, 43, 44, 46, 47],
                           81: [1, 3, 5, 6, 7, 8, 12, 13, 14, 21, 22, 23, 24, 26, 28, 33, 34, 35, 39, 40, 41, 42, 43, 44],
                           82: [1, 3, 5, 6, 7, 8, 9, 10, 11, 18, 19, 20, 24, 26, 28, 36, 37, 38, 39, 40, 41, 45, 46, 47],
                           83: [1, 3, 5, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 28, 30, 31, 32, 33, 34, 35, 36, 37, 38],
                           84: [2, 3, 4, 5, 6, 7, 10, 12, 15, 16, 19, 21, 24, 25, 32, 33, 35, 37, 38, 41, 42, 44, 46, 47],
                           85: [2, 3, 4, 5, 6, 8, 9, 14, 15, 17, 18, 23, 24, 25, 31, 34, 35, 36, 37, 40, 43, 44, 45, 46],
                           86: [2, 3, 4, 5, 7, 8, 11, 13, 16, 17, 20, 22, 24, 25, 30, 33, 34, 36, 38, 39, 42, 43, 45, 47],
                           87: [2, 3, 8, 10, 11, 12, 14, 17, 19, 20, 21, 23, 24, 25, 28, 29, 30, 31, 33, 37, 39, 40, 42, 46],
                           88: [2, 3, 7, 9, 10, 13, 14, 16, 18, 19, 22, 23, 24, 25, 28, 29, 30, 32, 35, 36, 39, 41, 44, 45],
                           89: [2, 3, 6, 9, 11, 12, 13, 15, 18, 20, 21, 22, 24, 25, 28, 29, 31, 32, 34, 38, 40, 41, 43, 47],
                           90: [4, 5, 8, 9, 10, 12, 13, 17, 18, 19, 21, 22, 24, 25, 26, 27, 30, 31, 35, 38, 39, 40, 44, 47],
                           91: [4, 5, 7, 9, 11, 12, 14, 16, 18, 20, 21, 23, 24, 25, 26, 27, 30, 32, 34, 37, 39, 41, 43, 46],
                           92: [4, 5, 6, 10, 11, 13, 14, 15, 19, 20, 22, 23, 24, 25, 26, 27, 31, 32, 33, 36, 40, 41, 42, 45],
                           93: [6, 7, 8, 12, 13, 14, 15, 16, 17, 18, 19, 20, 24, 25, 26, 27, 28, 29, 33, 34, 35, 45, 46, 47],
                           94: [6, 7, 8, 9, 10, 11, 15, 16, 17, 21, 22, 23, 24, 25, 26, 27, 28, 29, 36, 37, 38, 42, 43, 44],
                           95: [24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 3, # number of orbits
                 11520, # grpsize
                 [ # autgrp generators
                     [0, 1, 2, 3, 4, 5, 7, 8, 6, 10, 11, 9, 13, 14, 12, 16, 17, 15, 19, 20, 18, 22, 23, 21, 24, 25, 26, 27, 28, 29, 31, 32, 30, 34, 35, 33, 37, 38, 36, 40, 41, 39, 43, 44, 42, 46, 47, 45, 50, 48, 49, 53, 51, 52, 56, 54, 55, 57, 58, 59, 62, 60, 61, 65, 63, 64, 68, 66, 67, 69, 70, 71, 74, 72, 73, 77, 75, 76, 80, 78, 79, 81, 82, 83, 86, 84, 85, 89, 87, 88, 92, 90, 91, 93, 94, 95],
                     [0, 1, 2, 3, 4, 5, 6, 8, 7, 12, 14, 13, 9, 11, 10, 15, 17, 16, 21, 23, 22, 18, 20, 19, 24, 25, 26, 27, 28, 29, 30, 32, 31, 36, 38, 37, 33, 35, 34, 39, 41, 40, 45, 47, 46, 42, 44, 43, 49, 48, 50, 52, 51, 53, 55, 54, 56, 58, 57, 59, 61, 60, 62, 64, 63, 65, 67, 66, 68, 70, 69, 71, 73, 72, 74, 76, 75, 77, 79, 78, 80, 82, 81, 83, 85, 84, 86, 88, 87, 89, 91, 90, 92, 94, 93, 95],
                     [0, 1, 2, 3, 30, 39, 28, 8, 7, 9, 37, 38, 12, 34, 35, 29, 17, 16, 18, 46, 47, 21, 43, 44, 24, 25, 26, 27, 6, 15, 4, 32, 31, 33, 13, 14, 36, 10, 11, 5, 41, 40, 42, 22, 23, 45, 19, 20, 51, 52, 50, 48, 49, 53, 55, 54, 59, 57, 58, 56, 63, 64, 62, 60, 61, 65, 67, 66, 71, 69, 70, 68, 75, 76, 74, 72, 73, 77, 79, 78, 83, 81, 82, 80, 87, 88, 86, 84, 85, 89, 91, 90, 95, 93, 94, 92],
                     [0, 1, 4, 5, 2, 3, 8, 7, 6, 9, 11, 10, 13, 12, 14, 17, 16, 15, 18, 20, 19, 22, 21, 23, 24, 25, 28, 29, 26, 27, 32, 31, 30, 33, 35, 34, 37, 36, 38, 41, 40, 39, 42, 44, 43, 46, 45, 47, 50, 49, 48, 56, 55, 54, 53, 52, 51, 57, 58, 59, 62, 61, 60, 68, 67, 66, 65, 64, 63, 69, 70, 71, 74, 73, 72, 80, 79, 78, 77, 76, 75, 81, 82, 83, 86, 85, 84, 92, 91, 90, 89, 88, 87, 93, 94, 95],
                     [0, 25, 2, 27, 4, 29, 6, 7, 8, 9, 10, 11, 12, 13, 14, 39, 40, 41, 42, 43, 44, 45, 46, 47, 24, 1, 26, 3, 28, 5, 30, 31, 32, 33, 34, 35, 36, 37, 38, 15, 16, 17, 18, 19, 20, 21, 22, 23, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83],
                     [1, 0, 3, 2, 5, 4, 15, 16, 17, 18, 19, 20, 21, 22, 23, 6, 7, 8, 9, 10, 11, 12, 13, 14, 25, 24, 27, 26, 29, 28, 39, 40, 41, 42, 43, 44, 45, 46, 47, 30, 31, 32, 33, 34, 35, 36, 37, 38, 72, 73, 74, 75, 76, 77, 78, 79, 80, 82, 81, 83, 60, 61, 62, 63, 64, 65, 66, 67, 68, 70, 69, 71, 48, 49, 50, 51, 52, 53, 54, 55, 56, 58, 57, 59, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 93, 95],
                     [2, 3, 0, 1, 4, 5, 6, 8, 7, 9, 11, 10, 12, 14, 13, 15, 17, 16, 18, 20, 19, 21, 23, 22, 26, 27, 24, 25, 28, 29, 30, 32, 31, 33, 35, 34, 36, 38, 37, 39, 41, 40, 42, 44, 43, 45, 47, 46, 76, 75, 77, 73, 72, 74, 55, 54, 56, 57, 58, 59, 88, 87, 89, 85, 84, 86, 67, 66, 68, 69, 70, 71, 52, 51, 53, 49, 48, 50, 79, 78, 80, 81, 82, 83, 64, 63, 65, 61, 60, 62, 91, 90, 92, 93, 94, 95],
                     [9, 18, 10, 19, 11, 20, 13, 14, 12, 0, 4, 2, 6, 8, 7, 22, 23, 21, 1, 5, 3, 15, 17, 16, 33, 42, 34, 43, 35, 44, 37, 38, 36, 24, 28, 26, 30, 32, 31, 46, 47, 45, 25, 29, 27, 39, 41, 40, 56, 73, 51, 48, 77, 79, 76, 78, 50, 69, 94, 59, 68, 85, 63, 60, 89, 91, 88, 90, 62, 57, 82, 71, 80, 49, 75, 72, 53, 55, 52, 54, 74, 93, 70, 83, 92, 61, 87, 84, 65, 67, 64, 66, 86, 81, 58, 95],
                 ]
                ]
    elif request.param == "hadamard-8-96":
        return [ "hadamard-8-96",
                 Graph(number_of_vertices=96, directed=False,
                       adjacency_dict = {
                           0: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71],
                           1: [60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83],
                           2: [54, 55, 56, 57, 58, 59, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 84, 85, 86, 87, 88, 89],
                           3: [48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89],
                           4: [51, 52, 53, 57, 58, 59, 63, 64, 65, 69, 70, 71, 72, 73, 74, 78, 79, 80, 84, 85, 86, 90, 91, 92],
                           5: [48, 49, 50, 54, 55, 56, 63, 64, 65, 69, 70, 71, 75, 76, 77, 81, 82, 83, 84, 85, 86, 90, 91, 92],
                           6: [48, 49, 53, 56, 57, 58, 60, 61, 65, 68, 69, 70, 74, 75, 76, 78, 79, 83, 86, 87, 88, 90, 91, 95],
                           7: [48, 50, 52, 55, 57, 58, 60, 62, 64, 67, 69, 70, 73, 75, 77, 78, 80, 83, 85, 87, 89, 90, 92, 95],
                           8: [49, 50, 51, 54, 57, 58, 61, 62, 63, 66, 69, 70, 72, 76, 77, 79, 80, 83, 84, 88, 89, 91, 92, 95],
                           9: [49, 50, 52, 56, 57, 59, 60, 62, 63, 68, 69, 71, 72, 75, 77, 78, 79, 82, 85, 88, 89, 90, 91, 94],
                           10: [48, 49, 51, 55, 57, 59, 61, 62, 65, 67, 69, 71, 74, 76, 77, 78, 80, 82, 84, 87, 88, 90, 92, 94],
                           11: [48, 50, 53, 54, 57, 59, 60, 61, 64, 66, 69, 71, 73, 75, 76, 79, 80, 82, 86, 87, 89, 91, 92, 94],
                           12: [48, 50, 51, 56, 58, 59, 61, 62, 64, 68, 70, 71, 73, 76, 77, 78, 79, 81, 84, 87, 89, 90, 91, 93],
                           13: [49, 50, 53, 55, 58, 59, 60, 61, 63, 67, 70, 71, 72, 75, 76, 78, 80, 81, 86, 88, 89, 90, 92, 93],
                           14: [48, 49, 52, 54, 58, 59, 60, 62, 65, 66, 70, 71, 74, 75, 77, 79, 80, 81, 85, 87, 88, 91, 92, 93],
                           15: [50, 51, 52, 54, 55, 59, 60, 61, 65, 68, 69, 70, 72, 73, 77, 80, 81, 82, 86, 87, 88, 90, 91, 95],
                           16: [49, 51, 53, 55, 56, 59, 60, 62, 64, 66, 69, 70, 72, 74, 76, 78, 81, 82, 85, 87, 89, 91, 92, 95],
                           17: [48, 52, 53, 54, 56, 59, 61, 62, 63, 67, 69, 70, 73, 74, 75, 79, 81, 82, 84, 88, 89, 90, 92, 95],
                           18: [48, 51, 53, 54, 55, 57, 60, 62, 63, 68, 70, 71, 73, 74, 76, 80, 82, 83, 85, 88, 89, 90, 91, 93],
                           19: [50, 51, 53, 54, 56, 58, 60, 62, 65, 67, 69, 71, 72, 73, 76, 79, 81, 83, 85, 87, 88, 90, 92, 94],
                           20: [48, 51, 52, 55, 56, 58, 60, 61, 63, 66, 69, 71, 73, 74, 77, 78, 81, 83, 86, 88, 89, 91, 92, 94],
                           21: [49, 52, 53, 54, 55, 58, 61, 62, 64, 68, 69, 71, 72, 74, 75, 80, 81, 83, 84, 87, 89, 90, 91, 94],
                           22: [49, 51, 52, 54, 56, 57, 60, 61, 64, 67, 70, 71, 72, 74, 77, 79, 82, 83, 86, 87, 89, 90, 92, 93],
                           23: [50, 52, 53, 55, 56, 57, 61, 62, 65, 66, 70, 71, 72, 73, 75, 78, 82, 83, 84, 87, 88, 91, 92, 93],
                           24: [72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95],
                           25: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95],
                           26: [48, 49, 50, 51, 52, 53, 60, 61, 62, 63, 64, 65, 78, 79, 80, 81, 82, 83, 90, 91, 92, 93, 94, 95],
                           27: [54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 72, 73, 74, 75, 76, 77, 90, 91, 92, 93, 94, 95],
                           28: [48, 49, 50, 54, 55, 56, 60, 61, 62, 66, 67, 68, 75, 76, 77, 81, 82, 83, 87, 88, 89, 93, 94, 95],
                           29: [51, 52, 53, 57, 58, 59, 60, 61, 62, 66, 67, 68, 72, 73, 74, 78, 79, 80, 87, 88, 89, 93, 94, 95],
                           30: [50, 51, 52, 54, 55, 59, 62, 63, 64, 66, 67, 71, 72, 73, 77, 80, 81, 82, 84, 85, 89, 92, 93, 94],
                           31: [49, 51, 53, 54, 56, 59, 61, 63, 65, 66, 68, 71, 72, 74, 76, 79, 81, 82, 84, 86, 88, 91, 93, 94],
                           32: [48, 52, 53, 55, 56, 59, 60, 64, 65, 67, 68, 71, 73, 74, 75, 78, 81, 82, 85, 86, 87, 90, 93, 94],
                           33: [48, 51, 53, 54, 55, 58, 61, 64, 65, 66, 67, 70, 73, 74, 76, 80, 81, 83, 84, 86, 87, 92, 93, 95],
                           34: [50, 52, 53, 54, 56, 58, 60, 63, 64, 66, 68, 70, 72, 73, 75, 79, 81, 83, 85, 86, 89, 91, 93, 95],
                           35: [49, 51, 52, 55, 56, 58, 62, 63, 65, 67, 68, 70, 72, 74, 77, 78, 81, 83, 84, 85, 88, 90, 93, 95],
                           36: [49, 52, 53, 54, 55, 57, 60, 63, 65, 66, 67, 69, 72, 74, 75, 80, 82, 83, 85, 86, 88, 92, 94, 95],
                           37: [48, 51, 52, 54, 56, 57, 62, 64, 65, 66, 68, 69, 73, 74, 77, 79, 82, 83, 84, 85, 87, 91, 94, 95],
                           38: [50, 51, 53, 55, 56, 57, 61, 63, 64, 67, 68, 69, 72, 73, 76, 78, 82, 83, 84, 86, 89, 90, 94, 95],
                           39: [48, 49, 53, 56, 57, 58, 62, 63, 64, 66, 67, 71, 74, 75, 76, 78, 79, 83, 84, 85, 89, 92, 93, 94],
                           40: [48, 50, 52, 54, 57, 58, 61, 63, 65, 67, 68, 71, 73, 75, 77, 79, 80, 83, 84, 86, 88, 90, 93, 94],
                           41: [49, 50, 51, 55, 57, 58, 60, 64, 65, 66, 68, 71, 72, 76, 77, 78, 80, 83, 85, 86, 87, 91, 93, 94],
                           42: [49, 50, 52, 56, 58, 59, 61, 64, 65, 66, 67, 69, 72, 75, 77, 78, 79, 81, 84, 86, 87, 92, 94, 95],
                           43: [48, 49, 52, 55, 57, 59, 61, 63, 64, 66, 68, 70, 74, 75, 77, 78, 80, 82, 84, 86, 89, 91, 93, 95],
                           44: [49, 50, 53, 54, 57, 59, 62, 64, 65, 67, 68, 70, 72, 75, 76, 79, 80, 82, 84, 85, 87, 90, 93, 95],
                           45: [48, 50, 51, 56, 57, 59, 60, 63, 65, 66, 67, 70, 73, 76, 77, 78, 79, 82, 85, 86, 88, 92, 93, 95],
                           46: [48, 50, 53, 55, 58, 59, 62, 63, 65, 66, 68, 69, 73, 75, 76, 78, 80, 81, 84, 85, 88, 91, 94, 95],
                           47: [48, 49, 51, 54, 58, 59, 60, 63, 64, 67, 68, 69, 74, 76, 77, 79, 80, 81, 85, 86, 89, 90, 94, 95],
                           48: [0, 3, 5, 6, 7, 10, 11, 12, 14, 17, 18, 20, 25, 26, 28, 32, 33, 37, 39, 40, 43, 45, 46, 47],
                           49: [0, 3, 5, 6, 8, 9, 10, 13, 14, 16, 21, 22, 25, 26, 28, 31, 35, 36, 39, 41, 42, 43, 44, 47],
                           50: [0, 3, 5, 7, 8, 9, 11, 12, 13, 15, 19, 23, 25, 26, 28, 30, 34, 38, 40, 41, 42, 44, 45, 46],
                           51: [0, 3, 4, 8, 10, 12, 15, 16, 18, 19, 20, 22, 25, 26, 29, 30, 31, 33, 35, 37, 38, 41, 45, 47],
                           52: [0, 3, 4, 7, 9, 14, 15, 17, 20, 21, 22, 23, 25, 26, 29, 30, 32, 34, 35, 36, 37, 40, 42, 43],
                           53: [0, 3, 4, 6, 11, 13, 16, 17, 18, 19, 21, 23, 25, 26, 29, 31, 32, 33, 34, 36, 38, 39, 44, 46],
                           54: [0, 2, 5, 8, 11, 14, 15, 17, 18, 19, 21, 22, 25, 27, 28, 30, 31, 33, 34, 36, 37, 40, 44, 47],
                           55: [0, 2, 5, 7, 10, 13, 15, 16, 18, 20, 21, 23, 25, 27, 28, 30, 32, 33, 35, 36, 38, 41, 43, 46],
                           56: [0, 2, 5, 6, 9, 12, 16, 17, 19, 20, 22, 23, 25, 27, 28, 31, 32, 34, 35, 37, 38, 39, 42, 45],
                           57: [0, 2, 4, 6, 7, 8, 9, 10, 11, 18, 22, 23, 25, 27, 29, 36, 37, 38, 39, 40, 41, 43, 44, 45],
                           58: [0, 2, 4, 6, 7, 8, 12, 13, 14, 19, 20, 21, 25, 27, 29, 33, 34, 35, 39, 40, 41, 42, 46, 47],
                           59: [0, 2, 4, 9, 10, 11, 12, 13, 14, 15, 16, 17, 25, 27, 29, 30, 31, 32, 42, 43, 44, 45, 46, 47],
                           60: [0, 1, 6, 7, 9, 11, 13, 14, 15, 16, 18, 19, 20, 22, 26, 27, 28, 29, 32, 34, 36, 41, 45, 47],
                           61: [0, 1, 6, 8, 10, 11, 12, 13, 15, 17, 20, 21, 22, 23, 26, 27, 28, 29, 31, 33, 38, 40, 42, 43],
                           62: [0, 1, 7, 8, 9, 10, 12, 14, 16, 17, 18, 19, 21, 23, 26, 27, 28, 29, 30, 35, 37, 39, 44, 46],
                           63: [0, 1, 4, 5, 8, 9, 13, 17, 18, 20, 26, 27, 30, 31, 34, 35, 36, 38, 39, 40, 43, 45, 46, 47],
                           64: [0, 1, 4, 5, 7, 11, 12, 16, 21, 22, 26, 27, 30, 32, 33, 34, 37, 38, 39, 41, 42, 43, 44, 47],
                           65: [0, 1, 4, 5, 6, 10, 14, 15, 19, 23, 26, 27, 31, 32, 33, 35, 36, 37, 40, 41, 42, 44, 45, 46],
                           66: [0, 1, 2, 3, 8, 11, 14, 16, 20, 23, 28, 29, 30, 31, 33, 34, 36, 37, 39, 41, 42, 43, 45, 46],
                           67: [0, 1, 2, 3, 7, 10, 13, 17, 19, 22, 28, 29, 30, 32, 33, 35, 36, 38, 39, 40, 42, 44, 45, 47],
                           68: [0, 1, 2, 3, 6, 9, 12, 15, 18, 21, 28, 29, 31, 32, 34, 35, 37, 38, 40, 41, 43, 44, 46, 47],
                           69: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 15, 16, 17, 19, 20, 21, 36, 37, 38, 42, 46, 47],
                           70: [0, 1, 2, 3, 4, 5, 6, 7, 8, 12, 13, 14, 15, 16, 17, 18, 22, 23, 33, 34, 35, 43, 44, 45],
                           71: [0, 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 18, 19, 20, 21, 22, 23, 30, 31, 32, 39, 40, 41],
                           72: [1, 2, 4, 8, 9, 13, 15, 16, 19, 21, 22, 23, 24, 27, 29, 30, 31, 34, 35, 36, 38, 41, 42, 44],
                           73: [1, 2, 4, 7, 11, 12, 15, 17, 18, 19, 20, 23, 24, 27, 29, 30, 32, 33, 34, 37, 38, 40, 45, 46],
                           74: [1, 2, 4, 6, 10, 14, 16, 17, 18, 20, 21, 22, 24, 27, 29, 31, 32, 33, 35, 36, 37, 39, 43, 47],
                           75: [1, 2, 5, 6, 7, 9, 11, 13, 14, 17, 21, 23, 24, 27, 28, 32, 34, 36, 39, 40, 42, 43, 44, 46],
                           76: [1, 2, 5, 6, 8, 10, 11, 12, 13, 16, 18, 19, 24, 27, 28, 31, 33, 38, 39, 41, 44, 45, 46, 47],
                           77: [1, 2, 5, 7, 8, 9, 10, 12, 14, 15, 20, 22, 24, 27, 28, 30, 35, 37, 40, 41, 42, 43, 45, 47],
                           78: [1, 3, 4, 6, 7, 9, 10, 12, 13, 16, 20, 23, 24, 26, 29, 32, 35, 38, 39, 41, 42, 43, 45, 46],
                           79: [1, 3, 4, 6, 8, 9, 11, 12, 14, 17, 19, 22, 24, 26, 29, 31, 34, 37, 39, 40, 42, 44, 45, 47],
                           80: [1, 3, 4, 7, 8, 10, 11, 13, 14, 15, 18, 21, 24, 26, 29, 30, 33, 36, 40, 41, 43, 44, 46, 47],
                           81: [1, 3, 5, 12, 13, 14, 15, 16, 17, 19, 20, 21, 24, 26, 28, 30, 31, 32, 33, 34, 35, 42, 46, 47],
                           82: [1, 3, 5, 9, 10, 11, 15, 16, 17, 18, 22, 23, 24, 26, 28, 30, 31, 32, 36, 37, 38, 43, 44, 45],
                           83: [1, 3, 5, 6, 7, 8, 18, 19, 20, 21, 22, 23, 24, 26, 28, 33, 34, 35, 36, 37, 38, 39, 40, 41],
                           84: [2, 3, 4, 5, 8, 10, 12, 17, 21, 23, 24, 25, 30, 31, 33, 35, 37, 38, 39, 40, 42, 43, 44, 46],
                           85: [2, 3, 4, 5, 7, 9, 14, 16, 18, 19, 24, 25, 30, 32, 34, 35, 36, 37, 39, 41, 44, 45, 46, 47],
                           86: [2, 3, 4, 5, 6, 11, 13, 15, 20, 22, 24, 25, 31, 32, 33, 34, 36, 38, 40, 41, 42, 43, 45, 47],
                           87: [2, 3, 6, 7, 10, 11, 12, 14, 15, 16, 19, 21, 22, 23, 24, 25, 28, 29, 32, 33, 37, 41, 42, 44],
                           88: [2, 3, 6, 8, 9, 10, 13, 14, 15, 17, 18, 19, 20, 23, 24, 25, 28, 29, 31, 35, 36, 40, 45, 46],
                           89: [2, 3, 7, 8, 9, 11, 12, 13, 16, 17, 18, 20, 21, 22, 24, 25, 28, 29, 30, 34, 38, 39, 43, 47],
                           90: [4, 5, 6, 7, 9, 10, 12, 13, 15, 17, 18, 19, 21, 22, 24, 25, 26, 27, 32, 35, 38, 40, 44, 47],
                           91: [4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 20, 21, 23, 24, 25, 26, 27, 31, 34, 37, 41, 43, 46],
                           92: [4, 5, 7, 8, 10, 11, 13, 14, 16, 17, 19, 20, 22, 23, 24, 25, 26, 27, 30, 33, 36, 39, 42, 45],
                           93: [12, 13, 14, 18, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 39, 40, 41, 43, 44, 45],
                           94: [9, 10, 11, 19, 20, 21, 24, 25, 26, 27, 28, 29, 30, 31, 32, 36, 37, 38, 39, 40, 41, 42, 46, 47],
                           95: [6, 7, 8, 15, 16, 17, 24, 25, 26, 27, 28, 29, 33, 34, 35, 36, 37, 38, 42, 43, 44, 45, 46, 47],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 5, # number of orbits
                 256, # grpsize
                 [ # autgrp generators
                     [0, 1, 2, 3, 4, 5, 6, 8, 7, 12, 14, 13, 9, 11, 10, 15, 17, 16, 21, 23, 22, 18, 20, 19, 24, 25, 26, 27, 28, 29, 30, 32, 31, 36, 38, 37, 33, 35, 34, 39, 41, 40, 45, 47, 46, 42, 44, 43, 49, 48, 50, 52, 51, 53, 55, 54, 56, 58, 57, 59, 61, 60, 62, 64, 63, 65, 67, 66, 68, 70, 69, 71, 73, 72, 74, 76, 75, 77, 79, 78, 80, 82, 81, 83, 85, 84, 86, 88, 87, 89, 91, 90, 92, 94, 93, 95],
                     [0, 1, 2, 3, 6, 15, 4, 8, 7, 9, 37, 38, 12, 34, 35, 5, 17, 16, 18, 46, 47, 21, 43, 44, 24, 25, 26, 27, 30, 39, 28, 32, 31, 33, 13, 14, 36, 10, 11, 29, 41, 40, 42, 22, 23, 45, 19, 20, 51, 52, 50, 48, 49, 53, 55, 54, 59, 57, 58, 56, 63, 64, 62, 60, 61, 65, 67, 66, 71, 69, 70, 68, 75, 76, 74, 72, 73, 77, 79, 78, 83, 81, 82, 80, 87, 88, 86, 84, 85, 89, 91, 90, 95, 93, 94, 92],
                     [0, 1, 2, 3, 28, 29, 30, 36, 33, 31, 37, 34, 32, 38, 35, 39, 45, 42, 40, 46, 43, 41, 47, 44, 24, 25, 26, 27, 4, 5, 6, 12, 9, 7, 13, 10, 8, 14, 11, 15, 21, 18, 16, 22, 19, 17, 23, 20, 52, 51, 53, 48, 49, 50, 58, 57, 59, 54, 55, 56, 63, 64, 65, 61, 60, 62, 70, 69, 71, 66, 67, 68, 76, 75, 77, 72, 73, 74, 82, 81, 83, 78, 79, 80, 87, 88, 89, 85, 84, 86, 94, 93, 95, 90, 91, 92],
                     [0, 1, 26, 27, 5, 4, 39, 43, 47, 46, 40, 45, 44, 42, 41, 30, 34, 38, 37, 31, 36, 35, 33, 32, 24, 25, 2, 3, 29, 28, 15, 19, 23, 22, 16, 21, 20, 18, 17, 6, 10, 14, 13, 7, 12, 11, 9, 8, 57, 58, 59, 54, 55, 56, 51, 52, 53, 48, 49, 50, 66, 67, 68, 69, 70, 71, 60, 61, 62, 63, 64, 65, 81, 82, 83, 78, 79, 80, 75, 76, 77, 72, 73, 74, 90, 91, 92, 93, 94, 95, 84, 85, 86, 87, 88, 89],
                     [0, 25, 2, 27, 4, 29, 6, 8, 7, 9, 11, 10, 12, 14, 13, 39, 41, 40, 42, 44, 43, 45, 47, 46, 24, 1, 26, 3, 28, 5, 30, 32, 31, 33, 35, 34, 36, 38, 37, 15, 17, 16, 18, 20, 19, 21, 23, 22, 61, 60, 62, 64, 63, 65, 67, 66, 68, 69, 70, 71, 49, 48, 50, 52, 51, 53, 55, 54, 56, 57, 58, 59, 85, 84, 86, 88, 87, 89, 91, 90, 92, 93, 94, 95, 73, 72, 74, 76, 75, 77, 79, 78, 80, 81, 82, 83],
                     [1, 0, 3, 2, 5, 4, 15, 17, 16, 21, 19, 20, 18, 22, 23, 6, 8, 7, 12, 10, 11, 9, 13, 14, 25, 24, 27, 26, 29, 28, 39, 41, 40, 45, 43, 44, 42, 46, 47, 30, 32, 31, 36, 34, 35, 33, 37, 38, 73, 72, 74, 76, 75, 77, 78, 79, 80, 81, 82, 83, 61, 60, 62, 64, 63, 65, 66, 67, 68, 69, 70, 71, 49, 48, 50, 52, 51, 53, 54, 55, 56, 57, 58, 59, 85, 84, 86, 88, 87, 89, 90, 91, 92, 93, 94, 95],
                     [2, 3, 0, 1, 4, 5, 6, 8, 7, 9, 11, 10, 12, 14, 13, 15, 17, 16, 18, 20, 19, 21, 23, 22, 26, 27, 24, 25, 28, 29, 30, 32, 31, 33, 35, 34, 36, 38, 37, 39, 41, 40, 42, 44, 43, 45, 47, 46, 76, 75, 77, 73, 72, 74, 55, 54, 56, 57, 58, 59, 88, 87, 89, 85, 84, 86, 67, 66, 68, 69, 70, 71, 52, 51, 53, 49, 48, 50, 79, 78, 80, 81, 82, 83, 64, 63, 65, 61, 60, 62, 91, 90, 92, 93, 94, 95],
                 ]
                ]
    elif request.param == "levi-r":
        return [ "levi-r",
                 Graph(number_of_vertices=182, directed=False,
                       adjacency_dict = {
                           0: [96, 97, 100, 102, 113, 126, 139, 152, 165, 178],
                           1: [97, 98, 101, 103, 114, 127, 140, 153, 166, 179],
                           2: [93, 94, 97, 99, 110, 123, 136, 149, 162, 175],
                           3: [91, 92, 95, 97, 108, 121, 134, 147, 160, 173],
                           4: [97, 105, 106, 125, 128, 133, 142, 143, 148, 150],
                           5: [97, 107, 116, 118, 119, 138, 141, 169, 174, 176],
                           6: [97, 112, 115, 120, 129, 131, 132, 156, 161, 163],
                           7: [97, 104, 109, 111, 144, 145, 164, 167, 172, 181],
                           8: [97, 130, 135, 137, 146, 155, 157, 158, 177, 180],
                           9: [97, 117, 122, 124, 151, 154, 159, 168, 170, 171],
                           10: [94, 95, 98, 100, 111, 124, 137, 150, 163, 176],
                           11: [92, 99, 100, 103, 116, 129, 142, 155, 168, 181],
                           12: [91, 93, 100, 101, 104, 117, 130, 143, 156, 169],
                           13: [100, 108, 109, 118, 128, 132, 136, 146, 151, 153],
                           14: [100, 106, 110, 121, 122, 131, 141, 172, 177, 179],
                           15: [100, 105, 115, 119, 123, 134, 135, 159, 164, 166],
                           16: [100, 107, 112, 114, 147, 148, 157, 167, 171, 175],
                           17: [100, 133, 138, 140, 145, 149, 160, 161, 170, 180],
                           18: [100, 120, 125, 127, 144, 154, 158, 162, 173, 174],
                           19: [92, 93, 96, 98, 109, 122, 135, 148, 161, 174],
                           20: [91, 94, 96, 103, 107, 120, 133, 146, 159, 172],
                           21: [95, 96, 99, 101, 112, 125, 138, 151, 164, 177],
                           22: [96, 121, 123, 129, 150, 153, 158, 167, 169, 170],
                           23: [96, 134, 136, 142, 145, 154, 156, 157, 176, 179],
                           24: [96, 108, 110, 116, 143, 144, 163, 166, 171, 180],
                           25: [96, 111, 114, 119, 128, 130, 131, 160, 162, 168],
                           26: [96, 106, 115, 117, 118, 137, 140, 173, 175, 181],
                           27: [96, 104, 105, 124, 127, 132, 141, 147, 149, 155],
                           28: [91, 98, 99, 102, 115, 128, 141, 154, 167, 180],
                           29: [93, 95, 102, 103, 106, 119, 132, 145, 158, 171],
                           30: [92, 94, 101, 102, 105, 118, 131, 144, 157, 170],
                           31: [102, 110, 111, 117, 120, 134, 138, 148, 153, 155],
                           32: [102, 108, 112, 123, 124, 130, 133, 174, 179, 181],
                           33: [102, 104, 107, 121, 125, 136, 137, 161, 166, 168],
                           34: [102, 109, 114, 116, 149, 150, 156, 159, 173, 177],
                           35: [102, 135, 140, 142, 147, 151, 162, 163, 169, 172],
                           36: [102, 122, 127, 129, 143, 146, 160, 164, 175, 176],
                           37: [98, 104, 108, 119, 120, 139, 142, 170, 175, 177],
                           38: [103, 111, 112, 118, 121, 135, 139, 143, 149, 154],
                           39: [101, 134, 139, 141, 146, 150, 161, 162, 171, 181],
                           40: [94, 115, 116, 122, 125, 130, 139, 145, 147, 153],
                           41: [99, 132, 137, 139, 144, 148, 159, 160, 169, 179],
                           42: [93, 131, 133, 139, 151, 155, 166, 167, 173, 176],
                           43: [95, 105, 114, 117, 129, 136, 139, 172, 174, 180],
                           44: [92, 107, 110, 124, 128, 139, 140, 156, 158, 164],
                           45: [91, 106, 109, 123, 127, 138, 139, 157, 163, 168],
                           46: [98, 113, 116, 117, 121, 132, 133, 157, 162, 164],
                           47: [103, 109, 113, 124, 125, 131, 134, 169, 175, 180],
                           48: [101, 108, 113, 115, 148, 149, 158, 168, 172, 176],
                           49: [93, 105, 107, 113, 153, 154, 160, 163, 177, 181],
                           50: [94, 104, 113, 128, 129, 135, 138, 171, 173, 179],
                           51: [99, 106, 111, 113, 146, 147, 156, 166, 170, 174],
                           52: [92, 113, 114, 120, 123, 137, 141, 143, 145, 151],
                           53: [91, 112, 113, 119, 122, 136, 140, 144, 150, 155],
                           54: [95, 110, 113, 118, 127, 130, 142, 159, 161, 167],
                           55: [98, 106, 107, 126, 129, 130, 134, 144, 149, 151],
                           56: [103, 105, 108, 122, 126, 137, 138, 156, 162, 167],
                           57: [101, 121, 126, 128, 145, 155, 159, 163, 174, 175],
                           58: [99, 119, 124, 126, 143, 153, 157, 161, 172, 173],
                           59: [93, 118, 120, 126, 147, 150, 164, 168, 179, 180],
                           60: [94, 109, 112, 117, 126, 141, 142, 158, 160, 166],
                           61: [91, 110, 114, 125, 126, 132, 135, 170, 176, 181],
                           62: [95, 104, 116, 123, 126, 131, 140, 146, 148, 154],
                           63: [92, 111, 115, 126, 127, 133, 136, 169, 171, 177],
                           64: [98, 131, 136, 138, 143, 147, 158, 159, 178, 181],
                           65: [103, 104, 110, 115, 150, 151, 157, 160, 174, 178],
                           66: [101, 107, 111, 122, 123, 132, 142, 173, 178, 180],
                           67: [95, 133, 135, 141, 144, 153, 156, 168, 175, 178],
                           68: [92, 117, 119, 125, 146, 149, 163, 167, 178, 179],
                           69: [91, 118, 124, 129, 145, 148, 162, 166, 177, 178],
                           70: [94, 106, 108, 114, 154, 155, 161, 164, 169, 178],
                           71: [99, 105, 109, 120, 121, 130, 140, 171, 176, 178],
                           72: [93, 112, 116, 127, 128, 134, 137, 170, 172, 178],
                           73: [98, 118, 123, 125, 152, 155, 156, 160, 171, 172],
                           74: [103, 130, 136, 141, 148, 152, 163, 164, 170, 173],
                           75: [101, 109, 110, 119, 129, 133, 137, 147, 152, 154],
                           76: [92, 104, 106, 112, 152, 153, 159, 162, 176, 180],
                           77: [91, 105, 111, 116, 151, 152, 158, 161, 175, 179],
                           78: [95, 120, 122, 128, 149, 152, 157, 166, 169, 181],
                           79: [93, 114, 115, 121, 124, 138, 142, 144, 146, 152],
                           80: [94, 132, 134, 140, 143, 152, 167, 168, 174, 177],
                           81: [99, 107, 108, 117, 127, 131, 135, 145, 150, 152],
                           82: [98, 105, 110, 112, 145, 146, 165, 168, 169, 173],
                           83: [103, 117, 123, 128, 144, 147, 161, 165, 176, 177],
                           84: [101, 106, 116, 120, 124, 135, 136, 160, 165, 167],
                           85: [91, 131, 137, 142, 149, 153, 164, 165, 171, 174],
                           86: [95, 107, 109, 115, 143, 155, 162, 165, 170, 179],
                           87: [92, 130, 132, 138, 150, 154, 165, 166, 172, 175],
                           88: [99, 104, 114, 118, 122, 133, 134, 158, 163, 165],
                           89: [93, 108, 111, 125, 129, 140, 141, 157, 159, 165],
                           90: [94, 119, 121, 127, 148, 151, 156, 165, 180, 181],
                           91: [3, 12, 20, 28, 45, 53, 61, 69, 77, 85],
                           92: [3, 11, 19, 30, 44, 52, 63, 68, 76, 87],
                           93: [2, 12, 19, 29, 42, 49, 59, 72, 79, 89],
                           94: [2, 10, 20, 30, 40, 50, 60, 70, 80, 90],
                           95: [3, 10, 21, 29, 43, 54, 62, 67, 78, 86],
                           96: [0, 19, 20, 21, 22, 23, 24, 25, 26, 27],
                           97: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                           98: [1, 10, 19, 28, 37, 46, 55, 64, 73, 82],
                           99: [2, 11, 21, 28, 41, 51, 58, 71, 81, 88],
                           100: [0, 10, 11, 12, 13, 14, 15, 16, 17, 18],
                           101: [1, 12, 21, 30, 39, 48, 57, 66, 75, 84],
                           102: [0, 28, 29, 30, 31, 32, 33, 34, 35, 36],
                           103: [1, 11, 20, 29, 38, 47, 56, 65, 74, 83],
                           104: [7, 12, 27, 33, 37, 50, 62, 65, 76, 88],
                           105: [4, 15, 27, 30, 43, 49, 56, 71, 77, 82],
                           106: [4, 14, 26, 29, 45, 51, 55, 70, 76, 84],
                           107: [5, 16, 20, 33, 44, 49, 55, 66, 81, 86],
                           108: [3, 13, 24, 32, 37, 48, 56, 70, 81, 89],
                           109: [7, 13, 19, 34, 45, 47, 60, 71, 75, 86],
                           110: [2, 14, 24, 31, 44, 54, 61, 65, 75, 82],
                           111: [7, 10, 25, 31, 38, 51, 63, 66, 77, 89],
                           112: [6, 16, 21, 32, 38, 53, 60, 72, 76, 82],
                           113: [0, 46, 47, 48, 49, 50, 51, 52, 53, 54],
                           114: [1, 16, 25, 34, 43, 52, 61, 70, 79, 88],
                           115: [6, 15, 26, 28, 40, 48, 63, 65, 79, 86],
                           116: [5, 11, 24, 34, 40, 46, 62, 72, 77, 84],
                           117: [9, 12, 26, 31, 43, 46, 60, 68, 81, 83],
                           118: [5, 13, 26, 30, 38, 54, 59, 69, 73, 88],
                           119: [5, 15, 25, 29, 37, 53, 58, 68, 75, 90],
                           120: [6, 18, 20, 31, 37, 52, 59, 71, 78, 84],
                           121: [3, 14, 22, 33, 38, 46, 57, 71, 79, 90],
                           122: [9, 14, 19, 36, 40, 53, 56, 66, 78, 88],
                           123: [2, 15, 22, 32, 45, 52, 62, 66, 73, 83],
                           124: [9, 10, 27, 32, 44, 47, 58, 69, 79, 84],
                           125: [4, 18, 21, 33, 40, 47, 61, 68, 73, 89],
                           126: [0, 55, 56, 57, 58, 59, 60, 61, 62, 63],
                           127: [1, 18, 27, 36, 45, 54, 63, 72, 81, 90],
                           128: [4, 13, 25, 28, 44, 50, 57, 72, 78, 83],
                           129: [6, 11, 22, 36, 43, 50, 55, 69, 75, 89],
                           130: [8, 12, 25, 32, 40, 54, 55, 71, 74, 87],
                           131: [6, 14, 25, 30, 42, 47, 62, 64, 81, 85],
                           132: [6, 13, 27, 29, 41, 46, 61, 66, 80, 87],
                           133: [4, 17, 20, 32, 42, 46, 63, 67, 75, 88],
                           134: [3, 15, 23, 31, 39, 47, 55, 72, 80, 88],
                           135: [8, 15, 19, 35, 38, 50, 61, 67, 81, 84],
                           136: [2, 13, 23, 33, 43, 53, 63, 64, 74, 84],
                           137: [8, 10, 26, 33, 41, 52, 56, 72, 75, 85],
                           138: [5, 17, 21, 31, 45, 50, 56, 64, 79, 87],
                           139: [0, 37, 38, 39, 40, 41, 42, 43, 44, 45],
                           140: [1, 17, 26, 35, 44, 53, 62, 71, 80, 89],
                           141: [5, 14, 27, 28, 39, 52, 60, 67, 74, 89],
                           142: [4, 11, 23, 35, 37, 54, 60, 66, 79, 85],
                           143: [4, 12, 24, 36, 38, 52, 58, 64, 80, 86],
                           144: [7, 18, 24, 30, 41, 53, 55, 67, 79, 83],
                           145: [7, 17, 23, 29, 40, 52, 57, 69, 81, 82],
                           146: [8, 13, 20, 36, 39, 51, 62, 68, 79, 82],
                           147: [3, 16, 27, 35, 40, 51, 59, 64, 75, 83],
                           148: [4, 16, 19, 31, 41, 48, 62, 69, 74, 90],
                           149: [2, 17, 27, 34, 38, 48, 55, 68, 78, 85],
                           150: [4, 10, 22, 34, 39, 53, 59, 65, 81, 87],
                           151: [9, 13, 21, 35, 42, 52, 55, 65, 77, 90],
                           152: [0, 73, 74, 75, 76, 77, 78, 79, 80, 81],
                           153: [1, 13, 22, 31, 40, 49, 58, 67, 76, 85],
                           154: [9, 18, 23, 28, 38, 49, 62, 70, 75, 87],
                           155: [8, 11, 27, 31, 42, 53, 57, 70, 73, 86],
                           156: [6, 12, 23, 34, 44, 51, 56, 67, 73, 90],
                           157: [8, 16, 23, 30, 45, 46, 58, 65, 78, 89],
                           158: [8, 18, 22, 29, 44, 48, 60, 64, 77, 88],
                           159: [9, 15, 20, 34, 41, 54, 57, 64, 76, 89],
                           160: [3, 17, 25, 36, 41, 49, 60, 65, 73, 84],
                           161: [6, 17, 19, 33, 39, 54, 58, 70, 77, 83],
                           162: [2, 18, 25, 35, 39, 46, 56, 69, 76, 86],
                           163: [6, 10, 24, 35, 45, 49, 57, 68, 74, 88],
                           164: [7, 15, 21, 36, 44, 46, 59, 70, 74, 85],
                           165: [0, 82, 83, 84, 85, 86, 87, 88, 89, 90],
                           166: [1, 15, 24, 33, 42, 51, 60, 69, 78, 87],
                           167: [7, 16, 22, 28, 42, 54, 56, 68, 80, 84],
                           168: [9, 11, 25, 33, 45, 48, 59, 67, 80, 82],
                           169: [5, 12, 22, 35, 41, 47, 63, 70, 78, 82],
                           170: [9, 17, 22, 30, 37, 51, 61, 72, 74, 86],
                           171: [9, 16, 24, 29, 39, 50, 63, 71, 73, 85],
                           172: [7, 14, 20, 35, 43, 48, 58, 72, 73, 87],
                           173: [3, 18, 26, 34, 42, 50, 58, 66, 74, 82],
                           174: [5, 18, 19, 32, 43, 51, 57, 65, 80, 85],
                           175: [2, 16, 26, 36, 37, 47, 57, 67, 77, 87],
                           176: [5, 10, 23, 36, 42, 48, 61, 71, 76, 83],
                           177: [8, 14, 21, 34, 37, 49, 63, 69, 80, 83],
                           178: [0, 64, 65, 66, 67, 68, 69, 70, 71, 72],
                           179: [1, 14, 23, 32, 41, 50, 59, 68, 77, 86],
                           180: [8, 17, 24, 28, 43, 47, 59, 66, 76, 90],
                           181: [7, 11, 26, 32, 39, 49, 61, 64, 78, 90],
                       },
                       vertex_coloring = [
                       ],
                       ),
                 2, # number of orbits
                 67392, # grpsize
                 [ # autgrp generators
                     [0, 1, 2, 3, 5, 6, 4, 9, 7, 8, 10, 11, 12, 14, 15, 13, 18, 16, 17, 19, 20, 21, 23, 24, 22, 27, 25, 26, 28, 29, 30, 32, 33, 31, 36, 34, 35, 46, 47, 48, 50, 51, 49, 54, 52, 53, 55, 56, 57, 59, 60, 58, 63, 61, 62, 37, 38, 39, 41, 42, 40, 45, 43, 44, 82, 83, 84, 86, 87, 85, 90, 88, 89, 64, 65, 66, 68, 69, 67, 72, 70, 71, 73, 74, 75, 77, 78, 76, 81, 79, 80, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168],
                     [0, 1, 2, 3, 7, 8, 9, 4, 5, 6, 10, 11, 12, 16, 17, 18, 13, 14, 15, 19, 20, 21, 25, 26, 27, 22, 23, 24, 28, 29, 30, 34, 35, 36, 31, 32, 33, 64, 65, 66, 70, 71, 72, 67, 68, 69, 73, 74, 75, 79, 80, 81, 76, 77, 78, 82, 83, 84, 88, 89, 90, 85, 86, 87, 37, 38, 39, 43, 44, 45, 40, 41, 42, 46, 47, 48, 52, 53, 54, 49, 50, 51, 55, 56, 57, 61, 62, 63, 58, 59, 60, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142],
                     [0, 1, 2, 3, 8, 9, 7, 6, 4, 5, 10, 12, 11, 15, 14, 13, 17, 16, 18, 28, 30, 29, 33, 32, 31, 35, 34, 36, 19, 21, 20, 24, 23, 22, 26, 25, 27, 55, 57, 56, 60, 59, 58, 62, 61, 63, 46, 48, 47, 51, 50, 49, 53, 52, 54, 37, 39, 38, 42, 41, 40, 44, 43, 45, 73, 75, 74, 78, 77, 76, 80, 79, 81, 64, 66, 65, 69, 68, 67, 71, 70, 72, 82, 84, 83, 87, 86, 85, 89, 88, 90, 92, 91, 99, 94, 95, 102, 97, 98, 93, 100, 103, 96, 101, 129, 146, 177, 170, 134, 115, 110, 163, 145, 113, 140, 109, 117, 116, 159, 151, 144, 121, 141, 136, 176, 158, 139, 127, 135, 104, 142, 172, 164, 157, 108, 128, 123, 150, 171, 126, 114, 122, 130, 155, 120, 112, 105, 160, 180, 175, 137, 119, 178, 166, 174, 143, 181, 133, 125, 118, 147, 167, 162, 111, 132, 165, 153, 161, 169, 168, 107, 138, 131, 173, 154, 149, 124, 106, 152, 179, 148, 156],
                     [0, 1, 3, 2, 6, 5, 4, 8, 7, 9, 10, 11, 12, 17, 18, 16, 15, 13, 14, 28, 29, 30, 35, 36, 34, 33, 31, 32, 19, 20, 21, 26, 27, 25, 24, 22, 23, 55, 56, 57, 62, 63, 61, 60, 58, 59, 46, 47, 48, 53, 54, 52, 51, 49, 50, 37, 38, 39, 44, 45, 43, 42, 40, 41, 73, 74, 75, 80, 81, 79, 78, 76, 77, 64, 65, 66, 71, 72, 70, 69, 67, 68, 82, 83, 84, 89, 90, 88, 87, 85, 86, 93, 99, 91, 95, 94, 102, 97, 98, 92, 100, 101, 96, 103, 130, 112, 120, 119, 149, 180, 173, 137, 105, 113, 166, 148, 116, 117, 138, 107, 106, 162, 154, 147, 124, 131, 139, 179, 161, 142, 104, 125, 133, 132, 175, 167, 160, 111, 118, 126, 153, 174, 129, 156, 177, 146, 145, 123, 115, 108, 163, 170, 178, 140, 122, 181, 143, 164, 172, 171, 136, 128, 121, 150, 157, 165, 114, 135, 168, 169, 151, 159, 158, 110, 141, 134, 176, 144, 152, 127, 109, 155],
                     [0, 1, 2, 3, 8, 9, 7, 6, 4, 5, 11, 10, 12, 13, 15, 14, 18, 17, 16, 29, 28, 30, 31, 33, 32, 36, 35, 34, 20, 19, 21, 22, 24, 23, 27, 26, 25, 56, 55, 57, 58, 60, 59, 63, 62, 61, 47, 46, 48, 49, 51, 50, 54, 53, 52, 38, 37, 39, 40, 42, 41, 45, 44, 43, 74, 73, 75, 76, 78, 77, 81, 80, 79, 65, 64, 66, 67, 69, 68, 72, 71, 70, 83, 82, 84, 85, 87, 86, 90, 89, 88, 91, 95, 93, 99, 92, 102, 97, 103, 94, 100, 101, 96, 98, 156, 177, 135, 154, 108, 132, 123, 129, 144, 113, 127, 172, 124, 169, 151, 122, 167, 134, 119, 110, 116, 157, 139, 114, 146, 111, 143, 164, 109, 180, 121, 106, 136, 142, 170, 126, 140, 159, 137, 130, 112, 161, 128, 173, 158, 149, 155, 118, 178, 153, 107, 150, 104, 125, 148, 141, 160, 145, 175, 181, 131, 165, 179, 120, 176, 117, 138, 174, 115, 147, 171, 162, 168, 105, 152, 166, 133, 163],
                     [0, 1, 2, 3, 9, 7, 8, 5, 6, 4, 19, 21, 20, 23, 22, 24, 27, 26, 25, 10, 12, 11, 14, 13, 15, 18, 17, 16, 28, 30, 29, 32, 31, 33, 36, 35, 34, 55, 57, 56, 59, 58, 60, 63, 62, 61, 46, 48, 47, 50, 49, 51, 54, 53, 52, 37, 39, 38, 41, 40, 42, 45, 44, 43, 64, 66, 65, 68, 67, 69, 72, 71, 70, 82, 84, 83, 86, 85, 87, 90, 89, 88, 73, 75, 74, 77, 76, 78, 81, 80, 79, 91, 95, 94, 93, 92, 100, 97, 98, 99, 96, 103, 102, 101, 107, 171, 170, 104, 134, 176, 123, 174, 155, 113, 127, 180, 164, 133, 145, 144, 130, 121, 150, 110, 148, 168, 139, 114, 154, 177, 120, 158, 157, 117, 108, 163, 136, 161, 181, 126, 140, 167, 151, 159, 119, 118, 156, 147, 124, 175, 122, 142, 165, 179, 128, 112, 146, 132, 131, 143, 173, 137, 162, 135, 116, 152, 166, 141, 125, 172, 106, 105, 169, 160, 111, 149, 109, 129, 178, 153, 115, 138],
                     [0, 2, 1, 3, 4, 6, 5, 9, 8, 7, 10, 11, 12, 17, 18, 16, 15, 13, 14, 30, 28, 29, 34, 35, 36, 32, 33, 31, 20, 21, 19, 27, 25, 26, 22, 23, 24, 60, 58, 59, 55, 56, 57, 62, 63, 61, 50, 51, 49, 48, 46, 47, 52, 53, 54, 40, 41, 42, 38, 39, 37, 45, 43, 44, 80, 81, 79, 78, 76, 77, 73, 74, 75, 70, 71, 72, 68, 69, 67, 66, 64, 65, 90, 88, 89, 85, 86, 87, 83, 84, 82, 91, 92, 101, 98, 95, 102, 97, 94, 103, 100, 93, 96, 99, 117, 148, 125, 115, 160, 170, 127, 124, 119, 113, 123, 107, 129, 104, 161, 112, 141, 173, 144, 114, 111, 106, 139, 110, 133, 116, 130, 174, 138, 128, 147, 157, 140, 137, 132, 126, 136, 120, 142, 143, 122, 151, 180, 134, 105, 153, 150, 145, 178, 149, 172, 155, 169, 135, 177, 167, 108, 118, 179, 176, 171, 165, 175, 159, 181, 156, 109, 164, 154, 121, 131, 166, 163, 158, 152, 162, 146, 168],
                     [0, 10, 11, 12, 17, 18, 16, 15, 13, 14, 1, 2, 3, 8, 9, 7, 6, 4, 5, 19, 20, 21, 26, 27, 25, 24, 22, 23, 28, 30, 29, 33, 32, 31, 35, 34, 36, 55, 60, 62, 56, 58, 63, 57, 59, 61, 46, 50, 54, 52, 47, 51, 49, 53, 48, 37, 40, 43, 41, 44, 38, 45, 39, 42, 73, 80, 78, 75, 79, 77, 74, 81, 76, 64, 70, 67, 72, 69, 66, 68, 65, 71, 82, 90, 86, 85, 84, 89, 88, 87, 83, 91, 93, 92, 103, 101, 96, 100, 98, 99, 97, 95, 102, 94, 134, 145, 170, 120, 130, 135, 168, 166, 112, 113, 163, 167, 162, 121, 158, 144, 107, 117, 122, 181, 179, 138, 139, 176, 180, 175, 108, 171, 157, 133, 104, 109, 155, 153, 125, 126, 150, 154, 149, 160, 119, 105, 146, 156, 161, 142, 140, 177, 178, 137, 141, 136, 147, 132, 118, 172, 143, 148, 116, 114, 164, 165, 111, 115, 110, 173, 106, 131, 159, 169, 174, 129, 127, 151, 152, 124, 128, 123],
                     [1, 0, 2, 3, 5, 4, 6, 9, 8, 7, 10, 19, 28, 82, 64, 73, 46, 55, 37, 11, 20, 29, 83, 65, 74, 47, 56, 38, 12, 21, 30, 84, 66, 75, 48, 57, 39, 18, 27, 36, 90, 72, 81, 54, 63, 45, 16, 25, 34, 88, 70, 79, 52, 61, 43, 17, 26, 35, 89, 71, 80, 53, 62, 44, 14, 23, 32, 86, 68, 77, 50, 59, 41, 15, 24, 33, 87, 69, 78, 51, 60, 42, 13, 22, 31, 85, 67, 76, 49, 58, 40, 91, 92, 99, 94, 95, 103, 97, 100, 93, 98, 102, 101, 96, 154, 118, 138, 133, 173, 168, 136, 124, 132, 114, 113, 156, 148, 167, 105, 125, 120, 147, 181, 123, 111, 119, 140, 139, 169, 161, 180, 131, 112, 107, 160, 155, 110, 137, 106, 127, 126, 143, 174, 141, 170, 151, 146, 121, 116, 149, 176, 145, 166, 165, 104, 135, 115, 157, 177, 172, 134, 129, 175, 163, 171, 153, 152, 117, 109, 128, 144, 164, 159, 108, 142, 162, 150, 158, 179, 178, 130, 122],
                     [91, 92, 95, 97, 173, 147, 160, 121, 134, 108, 93, 101, 100, 117, 104, 130, 169, 156, 143, 98, 102, 99, 167, 180, 154, 115, 128, 141, 96, 94, 103, 146, 159, 172, 133, 107, 120, 122, 144, 155, 119, 112, 150, 136, 140, 113, 109, 157, 168, 163, 106, 138, 127, 139, 123, 135, 170, 181, 125, 176, 132, 126, 110, 114, 174, 131, 142, 149, 153, 165, 171, 164, 137, 161, 105, 116, 179, 152, 175, 111, 158, 151, 148, 118, 129, 178, 162, 166, 177, 124, 145, 0, 1, 10, 29, 2, 28, 3, 19, 21, 12, 11, 20, 30, 14, 74, 50, 35, 9, 46, 62, 79, 41, 45, 63, 25, 75, 13, 83, 40, 36, 7, 37, 54, 89, 58, 61, 52, 26, 84, 15, 65, 60, 34, 8, 55, 43, 72, 51, 53, 44, 27, 66, 18, 38, 90, 31, 5, 82, 67, 42, 81, 77, 68, 24, 39, 17, 47, 80, 32, 6, 73, 86, 49, 71, 69, 87, 22, 48, 16, 56, 70, 33, 4, 64, 78, 59, 88, 85, 76, 23, 57],
                 ]
                ]
