/**
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var IS_BROWSER = require( './../../is-browser' );
var getGlobal = require( '@stdlib/utils/global' );


// VARIABLES //

var Global = getGlobal();


// MAIN //

/**
* Returns a boolean indicating if an environment is a touch device.
*
* @private
* @returns {boolean} boolean indicating if an environment is a touch-enabled environment
*/
function isTouchDevice() {
	if ( !IS_BROWSER ) {
		return false;
	}
	return !!(
		'ontouchstart' in Global ||
		(
			Global.DocumentTouch &&
			Global.document &&
			Global.document instanceof Global.DocumentTouch
		) ||
		(
			Global.navigator &&
			(
				Global.navigator.maxTouchPoints > 0 ||
				Global.navigator.msMaxTouchPoints > 0
			)
		)
	);
}


// EXPORTS //

module.exports = isTouchDevice;
