# News - 15 series

<!-- prettier-ignore-start -->
(release-15-0-4)=
## Release 15.0.4 - 2025-03-29
<!-- prettier-ignore-end -->

### Improvements

#### Clarified `X / -1` and `X / -1.0` semantics

In many languages, `X / -1` and `X / -1.0` return `-X`. But Groonga
may not return `-X` when `X` is unsigned integer.

`X / -1` and `X / -1.0` always return `-X` from this release.

This is a backward incompatible change but we assume that no user
depends on this behavior.

<!-- prettier-ignore-start -->
(release-15-0-3)=
## Release 15.0.3 - 2025-03-10
<!-- prettier-ignore-end -->

### Improvements

#### {ref}`offline-index-construction`: Added support for parallel construction with {ref}`table-hash-key` lexicon

Parallel offline index construction iterates sorted terms
internally. {ref}`table-pat-key` and {ref}`table-pat-key` can do it
effectively because they are based on tree. But {ref}`table-hash-key`
can't do it effectively because it's not based on tree. So we didn't
support parallel offline index construction with
{ref}`table-hash-key` lexicon.

This release adds support for parallel offline index construction with
{ref}`table-hash-key` lexicon. It sort terms in a normal way. So it's
not so effective. Parallel offline index construction with
{ref}`table-hash-key` lexicon will be slower than
{ref}`table-pat-key`/{ref}`table-dat-key`. But it may be faster than
sequential offline index construction with {ref}`table-hash-key`
lexicon.

<!-- prettier-ignore-start -->
(release-15-0-2)=
## Release 15.0.2 - 2025-02-21
<!-- prettier-ignore-end -->

### Fixes

#### {ref}`offline-index-construction`: Fixed a bug that options may be ignored in parallel construction

Groonga may ignore options of {doc}`/reference/normalizers`,
{doc}`/reference/tokenizers` and/or {doc}`/reference/token_filters` in
the target index when offline index construction is executed in
parallel.

This issue may occur when:

- Offline index construction is executed in parallel.
- {doc}`/reference/normalizers`, {doc}`/reference/tokenizers`, and/or
  {doc}`/reference/token_filters` options are used.

If {doc}`/reference/normalizers/normalizer_table` is used and this
happens, the offline index construction is failed. Because
{doc}`/reference/normalizers/normalizer_table` has a required
parameter. If options are ignored, the required parameter is missing.

<!-- prettier-ignore-start -->
(release-15-0-1)=
## Release 15.0.1 - 2025-02-20
<!-- prettier-ignore-end -->

### Improvements

#### [{doc}`/install/ubuntu`] Dropped support for Ubuntu 20.04 (Focal Fossa)

Ubuntu 20.04 will reach EOL in May 2025, so support for it has been dropped
starting with this release.

<!-- prettier-ignore-start -->
(release-15-0-0)=
## Release 15.0.0 - 2025-02-09
<!-- prettier-ignore-end -->

This is our annual major release! This release doesn't have any
backward incompatible changes! So you can upgrade Groonga without
migrating your existing databases. You can still use your existing
databases as-is.

### Improvements

#### {ref}`table-pat-key`: Added support for {ref}`builtin-type-float32` as key type

[GH-2211](https://github.com/groonga/groonga/issues/2211)

{ref}`table-pat-key` encodes/decodes numeric keys for fast search
internally. So {ref}`table-pat-key` must know how to encode/decode
keys. {ref}`table-pat-key` didn't know how to encode/decode
{ref}`builtin-type-float32` before this release. Now,
{ref}`table-pat-key` can encode/decode {ref}`builtin-type-float32`. So
you can use {ref}`builtin-type-float32` as a {ref}`table-pat-key` key
type like other numeric types such as {ref}`builtin-type-int32` and
{ref}`builtin-type-float` now.
