// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/translate/v3beta1/translation_service.proto

package translate

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// State of the job.
type BatchTranslateMetadata_State int32

const (
	// Invalid.
	BatchTranslateMetadata_STATE_UNSPECIFIED BatchTranslateMetadata_State = 0
	// Request is being processed.
	BatchTranslateMetadata_RUNNING BatchTranslateMetadata_State = 1
	// The batch is processed, and at least one item was successfully
	// processed.
	BatchTranslateMetadata_SUCCEEDED BatchTranslateMetadata_State = 2
	// The batch is done and no item was successfully processed.
	BatchTranslateMetadata_FAILED BatchTranslateMetadata_State = 3
	// Request is in the process of being canceled after caller invoked
	// longrunning.Operations.CancelOperation on the request id.
	BatchTranslateMetadata_CANCELLING BatchTranslateMetadata_State = 4
	// The batch is done after the user has called the
	// longrunning.Operations.CancelOperation. Any records processed before the
	// cancel command are output as specified in the request.
	BatchTranslateMetadata_CANCELLED BatchTranslateMetadata_State = 5
)

var BatchTranslateMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "RUNNING",
	2: "SUCCEEDED",
	3: "FAILED",
	4: "CANCELLING",
	5: "CANCELLED",
}

var BatchTranslateMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"RUNNING":           1,
	"SUCCEEDED":         2,
	"FAILED":            3,
	"CANCELLING":        4,
	"CANCELLED":         5,
}

func (x BatchTranslateMetadata_State) String() string {
	return proto.EnumName(BatchTranslateMetadata_State_name, int32(x))
}

func (BatchTranslateMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{15, 0}
}

// Enumerates the possible states that the creation request can be in.
type CreateGlossaryMetadata_State int32

const (
	// Invalid.
	CreateGlossaryMetadata_STATE_UNSPECIFIED CreateGlossaryMetadata_State = 0
	// Request is being processed.
	CreateGlossaryMetadata_RUNNING CreateGlossaryMetadata_State = 1
	// The glossary was successfully created.
	CreateGlossaryMetadata_SUCCEEDED CreateGlossaryMetadata_State = 2
	// Failed to create the glossary.
	CreateGlossaryMetadata_FAILED CreateGlossaryMetadata_State = 3
	// Request is in the process of being canceled after caller invoked
	// longrunning.Operations.CancelOperation on the request id.
	CreateGlossaryMetadata_CANCELLING CreateGlossaryMetadata_State = 4
	// The glossary creation request was successfully canceled.
	CreateGlossaryMetadata_CANCELLED CreateGlossaryMetadata_State = 5
)

var CreateGlossaryMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "RUNNING",
	2: "SUCCEEDED",
	3: "FAILED",
	4: "CANCELLING",
	5: "CANCELLED",
}

var CreateGlossaryMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"RUNNING":           1,
	"SUCCEEDED":         2,
	"FAILED":            3,
	"CANCELLING":        4,
	"CANCELLED":         5,
}

func (x CreateGlossaryMetadata_State) String() string {
	return proto.EnumName(CreateGlossaryMetadata_State_name, int32(x))
}

func (CreateGlossaryMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{24, 0}
}

// Enumerates the possible states that the creation request can be in.
type DeleteGlossaryMetadata_State int32

const (
	// Invalid.
	DeleteGlossaryMetadata_STATE_UNSPECIFIED DeleteGlossaryMetadata_State = 0
	// Request is being processed.
	DeleteGlossaryMetadata_RUNNING DeleteGlossaryMetadata_State = 1
	// The glossary was successfully deleted.
	DeleteGlossaryMetadata_SUCCEEDED DeleteGlossaryMetadata_State = 2
	// Failed to delete the glossary.
	DeleteGlossaryMetadata_FAILED DeleteGlossaryMetadata_State = 3
	// Request is in the process of being canceled after caller invoked
	// longrunning.Operations.CancelOperation on the request id.
	DeleteGlossaryMetadata_CANCELLING DeleteGlossaryMetadata_State = 4
	// The glossary deletion request was successfully canceled.
	DeleteGlossaryMetadata_CANCELLED DeleteGlossaryMetadata_State = 5
)

var DeleteGlossaryMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "RUNNING",
	2: "SUCCEEDED",
	3: "FAILED",
	4: "CANCELLING",
	5: "CANCELLED",
}

var DeleteGlossaryMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"RUNNING":           1,
	"SUCCEEDED":         2,
	"FAILED":            3,
	"CANCELLING":        4,
	"CANCELLED":         5,
}

func (x DeleteGlossaryMetadata_State) String() string {
	return proto.EnumName(DeleteGlossaryMetadata_State_name, int32(x))
}

func (DeleteGlossaryMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{25, 0}
}

// Configures which glossary should be used for a specific target language,
// and defines options for applying that glossary.
type TranslateTextGlossaryConfig struct {
	// Required. Specifies the glossary used for this translation. Use
	// this format: projects/*/locations/*/glossaries/*
	Glossary string `protobuf:"bytes,1,opt,name=glossary,proto3" json:"glossary,omitempty"`
	// Optional. Indicates match is case-insensitive.
	// Default value is false if missing.
	IgnoreCase           bool     `protobuf:"varint,2,opt,name=ignore_case,json=ignoreCase,proto3" json:"ignore_case,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TranslateTextGlossaryConfig) Reset()         { *m = TranslateTextGlossaryConfig{} }
func (m *TranslateTextGlossaryConfig) String() string { return proto.CompactTextString(m) }
func (*TranslateTextGlossaryConfig) ProtoMessage()    {}
func (*TranslateTextGlossaryConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{0}
}

func (m *TranslateTextGlossaryConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TranslateTextGlossaryConfig.Unmarshal(m, b)
}
func (m *TranslateTextGlossaryConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TranslateTextGlossaryConfig.Marshal(b, m, deterministic)
}
func (m *TranslateTextGlossaryConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TranslateTextGlossaryConfig.Merge(m, src)
}
func (m *TranslateTextGlossaryConfig) XXX_Size() int {
	return xxx_messageInfo_TranslateTextGlossaryConfig.Size(m)
}
func (m *TranslateTextGlossaryConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TranslateTextGlossaryConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TranslateTextGlossaryConfig proto.InternalMessageInfo

func (m *TranslateTextGlossaryConfig) GetGlossary() string {
	if m != nil {
		return m.Glossary
	}
	return ""
}

func (m *TranslateTextGlossaryConfig) GetIgnoreCase() bool {
	if m != nil {
		return m.IgnoreCase
	}
	return false
}

// The request message for synchronous translation.
type TranslateTextRequest struct {
	// Required. The content of the input in string format.
	// We recommend the total content be less than 30k codepoints.
	// Use BatchTranslateText for larger text.
	Contents []string `protobuf:"bytes,1,rep,name=contents,proto3" json:"contents,omitempty"`
	// Optional. The format of the source text, for example, "text/html",
	//  "text/plain". If left blank, the MIME type defaults to "text/html".
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Optional. The BCP-47 language code of the input text if
	// known, for example, "en-US" or "sr-Latn". Supported language codes are
	// listed in Language Support. If the source language isn't specified, the API
	// attempts to identify the source language automatically and returns the
	// source language within the response.
	SourceLanguageCode string `protobuf:"bytes,4,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. The BCP-47 language code to use for translation of the input
	// text, set to one of the language codes listed in Language Support.
	TargetLanguageCode string `protobuf:"bytes,5,opt,name=target_language_code,json=targetLanguageCode,proto3" json:"target_language_code,omitempty"`
	// Required. Location to make a regional or global call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// For global calls, use `projects/{project-id}/locations/global`.
	//
	// Models and glossaries must be within the same region (have same
	// location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
	Parent string `protobuf:"bytes,8,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The `model` type requested for this translation.
	//
	// The format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-id}/locations/{location-id}/models/general/nmt`,
	//   `projects/{project-id}/locations/{location-id}/models/general/base`
	//
	//
	// For global (non-regionalized) requests, use `location-id` `global`.
	// For example,
	// `projects/{project-id}/locations/global/models/general/nmt`.
	//
	// If missing, the system decides which google base model to use.
	Model string `protobuf:"bytes,6,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. Glossary to be applied. The glossary must be
	// within the same region (have the same location-id) as the model, otherwise
	// an INVALID_ARGUMENT (400) error is returned.
	GlossaryConfig       *TranslateTextGlossaryConfig `protobuf:"bytes,7,opt,name=glossary_config,json=glossaryConfig,proto3" json:"glossary_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *TranslateTextRequest) Reset()         { *m = TranslateTextRequest{} }
func (m *TranslateTextRequest) String() string { return proto.CompactTextString(m) }
func (*TranslateTextRequest) ProtoMessage()    {}
func (*TranslateTextRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{1}
}

func (m *TranslateTextRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TranslateTextRequest.Unmarshal(m, b)
}
func (m *TranslateTextRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TranslateTextRequest.Marshal(b, m, deterministic)
}
func (m *TranslateTextRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TranslateTextRequest.Merge(m, src)
}
func (m *TranslateTextRequest) XXX_Size() int {
	return xxx_messageInfo_TranslateTextRequest.Size(m)
}
func (m *TranslateTextRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TranslateTextRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TranslateTextRequest proto.InternalMessageInfo

func (m *TranslateTextRequest) GetContents() []string {
	if m != nil {
		return m.Contents
	}
	return nil
}

func (m *TranslateTextRequest) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

func (m *TranslateTextRequest) GetSourceLanguageCode() string {
	if m != nil {
		return m.SourceLanguageCode
	}
	return ""
}

func (m *TranslateTextRequest) GetTargetLanguageCode() string {
	if m != nil {
		return m.TargetLanguageCode
	}
	return ""
}

func (m *TranslateTextRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *TranslateTextRequest) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *TranslateTextRequest) GetGlossaryConfig() *TranslateTextGlossaryConfig {
	if m != nil {
		return m.GlossaryConfig
	}
	return nil
}

type TranslateTextResponse struct {
	// Text translation responses with no glossary applied.
	// This field has the same length as
	// [`contents`][google.cloud.translation.v3beta1.TranslateTextRequest.contents].
	Translations []*Translation `protobuf:"bytes,1,rep,name=translations,proto3" json:"translations,omitempty"`
	// Text translation responses if a glossary is provided in the request.
	// This can be the same as
	// [`translations`][google.cloud.translation.v3beta1.TranslateTextResponse.translations] if no terms apply.
	// This field has the same length as
	// [`contents`][google.cloud.translation.v3beta1.TranslateTextRequest.contents].
	GlossaryTranslations []*Translation `protobuf:"bytes,3,rep,name=glossary_translations,json=glossaryTranslations,proto3" json:"glossary_translations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TranslateTextResponse) Reset()         { *m = TranslateTextResponse{} }
func (m *TranslateTextResponse) String() string { return proto.CompactTextString(m) }
func (*TranslateTextResponse) ProtoMessage()    {}
func (*TranslateTextResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{2}
}

func (m *TranslateTextResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TranslateTextResponse.Unmarshal(m, b)
}
func (m *TranslateTextResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TranslateTextResponse.Marshal(b, m, deterministic)
}
func (m *TranslateTextResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TranslateTextResponse.Merge(m, src)
}
func (m *TranslateTextResponse) XXX_Size() int {
	return xxx_messageInfo_TranslateTextResponse.Size(m)
}
func (m *TranslateTextResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TranslateTextResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TranslateTextResponse proto.InternalMessageInfo

func (m *TranslateTextResponse) GetTranslations() []*Translation {
	if m != nil {
		return m.Translations
	}
	return nil
}

func (m *TranslateTextResponse) GetGlossaryTranslations() []*Translation {
	if m != nil {
		return m.GlossaryTranslations
	}
	return nil
}

// A single translation response.
type Translation struct {
	// Text translated into the target language.
	TranslatedText string `protobuf:"bytes,1,opt,name=translated_text,json=translatedText,proto3" json:"translated_text,omitempty"`
	// Only present when `model` is present in the request.
	// This is same as `model` provided in the request.
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	// The BCP-47 language code of source text in the initial request, detected
	// automatically, if no source language was passed within the initial
	// request. If the source language was passed, auto-detection of the language
	// does not occur and this field is empty.
	DetectedLanguageCode string `protobuf:"bytes,4,opt,name=detected_language_code,json=detectedLanguageCode,proto3" json:"detected_language_code,omitempty"`
	// The `glossary_config` used for this translation.
	GlossaryConfig       *TranslateTextGlossaryConfig `protobuf:"bytes,3,opt,name=glossary_config,json=glossaryConfig,proto3" json:"glossary_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Translation) Reset()         { *m = Translation{} }
func (m *Translation) String() string { return proto.CompactTextString(m) }
func (*Translation) ProtoMessage()    {}
func (*Translation) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{3}
}

func (m *Translation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Translation.Unmarshal(m, b)
}
func (m *Translation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Translation.Marshal(b, m, deterministic)
}
func (m *Translation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Translation.Merge(m, src)
}
func (m *Translation) XXX_Size() int {
	return xxx_messageInfo_Translation.Size(m)
}
func (m *Translation) XXX_DiscardUnknown() {
	xxx_messageInfo_Translation.DiscardUnknown(m)
}

var xxx_messageInfo_Translation proto.InternalMessageInfo

func (m *Translation) GetTranslatedText() string {
	if m != nil {
		return m.TranslatedText
	}
	return ""
}

func (m *Translation) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *Translation) GetDetectedLanguageCode() string {
	if m != nil {
		return m.DetectedLanguageCode
	}
	return ""
}

func (m *Translation) GetGlossaryConfig() *TranslateTextGlossaryConfig {
	if m != nil {
		return m.GlossaryConfig
	}
	return nil
}

// The request message for language detection.
type DetectLanguageRequest struct {
	// Required. Location to make a regional or global call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// For global calls, use `projects/{project-id}/locations/global`.
	//
	// Only models within the same region (has same location-id) can be used.
	// Otherwise an INVALID_ARGUMENT (400) error is returned.
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language detection model to be used.
	//
	// Format:
	// `projects/{project-id}/locations/{location-id}/models/language-detection/{model-id}`
	//
	// Only one language detection model is currently supported:
	// `projects/{project-id}/locations/{location-id}/models/language-detection/default`.
	//
	// If not specified, the default model is used.
	Model string `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The source of the document from which to detect the language.
	//
	// Types that are valid to be assigned to Source:
	//	*DetectLanguageRequest_Content
	Source isDetectLanguageRequest_Source `protobuf_oneof:"source"`
	// Optional. The format of the source text, for example, "text/html",
	// "text/plain". If left blank, the MIME type defaults to "text/html".
	MimeType             string   `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectLanguageRequest) Reset()         { *m = DetectLanguageRequest{} }
func (m *DetectLanguageRequest) String() string { return proto.CompactTextString(m) }
func (*DetectLanguageRequest) ProtoMessage()    {}
func (*DetectLanguageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{4}
}

func (m *DetectLanguageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectLanguageRequest.Unmarshal(m, b)
}
func (m *DetectLanguageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectLanguageRequest.Marshal(b, m, deterministic)
}
func (m *DetectLanguageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectLanguageRequest.Merge(m, src)
}
func (m *DetectLanguageRequest) XXX_Size() int {
	return xxx_messageInfo_DetectLanguageRequest.Size(m)
}
func (m *DetectLanguageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectLanguageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DetectLanguageRequest proto.InternalMessageInfo

func (m *DetectLanguageRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *DetectLanguageRequest) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

type isDetectLanguageRequest_Source interface {
	isDetectLanguageRequest_Source()
}

type DetectLanguageRequest_Content struct {
	Content string `protobuf:"bytes,1,opt,name=content,proto3,oneof"`
}

func (*DetectLanguageRequest_Content) isDetectLanguageRequest_Source() {}

func (m *DetectLanguageRequest) GetSource() isDetectLanguageRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *DetectLanguageRequest) GetContent() string {
	if x, ok := m.GetSource().(*DetectLanguageRequest_Content); ok {
		return x.Content
	}
	return ""
}

func (m *DetectLanguageRequest) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DetectLanguageRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DetectLanguageRequest_Content)(nil),
	}
}

// The response message for language detection.
type DetectedLanguage struct {
	// The BCP-47 language code of source content in the request, detected
	// automatically.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The confidence of the detection result for this language.
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectedLanguage) Reset()         { *m = DetectedLanguage{} }
func (m *DetectedLanguage) String() string { return proto.CompactTextString(m) }
func (*DetectedLanguage) ProtoMessage()    {}
func (*DetectedLanguage) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{5}
}

func (m *DetectedLanguage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectedLanguage.Unmarshal(m, b)
}
func (m *DetectedLanguage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectedLanguage.Marshal(b, m, deterministic)
}
func (m *DetectedLanguage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectedLanguage.Merge(m, src)
}
func (m *DetectedLanguage) XXX_Size() int {
	return xxx_messageInfo_DetectedLanguage.Size(m)
}
func (m *DetectedLanguage) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectedLanguage.DiscardUnknown(m)
}

var xxx_messageInfo_DetectedLanguage proto.InternalMessageInfo

func (m *DetectedLanguage) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *DetectedLanguage) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// The response message for language detection.
type DetectLanguageResponse struct {
	// A list of detected languages sorted by detection confidence in descending
	// order. The most probable language first.
	Languages            []*DetectedLanguage `protobuf:"bytes,1,rep,name=languages,proto3" json:"languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *DetectLanguageResponse) Reset()         { *m = DetectLanguageResponse{} }
func (m *DetectLanguageResponse) String() string { return proto.CompactTextString(m) }
func (*DetectLanguageResponse) ProtoMessage()    {}
func (*DetectLanguageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{6}
}

func (m *DetectLanguageResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectLanguageResponse.Unmarshal(m, b)
}
func (m *DetectLanguageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectLanguageResponse.Marshal(b, m, deterministic)
}
func (m *DetectLanguageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectLanguageResponse.Merge(m, src)
}
func (m *DetectLanguageResponse) XXX_Size() int {
	return xxx_messageInfo_DetectLanguageResponse.Size(m)
}
func (m *DetectLanguageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectLanguageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DetectLanguageResponse proto.InternalMessageInfo

func (m *DetectLanguageResponse) GetLanguages() []*DetectedLanguage {
	if m != nil {
		return m.Languages
	}
	return nil
}

// The request message for discovering supported languages.
type GetSupportedLanguagesRequest struct {
	// Required. Location to make a regional or global call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// For global calls, use `projects/{project-id}/locations/global`.
	//
	// Only models within the same region (have same location-id) can be used,
	// otherwise an INVALID_ARGUMENT (400) error is returned.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language to use to return localized, human readable names
	// of supported languages. If missing, then display names are not returned
	// in a response.
	DisplayLanguageCode string `protobuf:"bytes,1,opt,name=display_language_code,json=displayLanguageCode,proto3" json:"display_language_code,omitempty"`
	// Optional. Get supported languages of this model.
	//
	// The format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-id}/locations/{location-id}/models/general/nmt`,
	//   `projects/{project-id}/locations/{location-id}/models/general/base`
	//
	//
	// Returns languages supported by the specified model.
	// If missing, we get supported languages of Google general base (PBMT) model.
	Model                string   `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSupportedLanguagesRequest) Reset()         { *m = GetSupportedLanguagesRequest{} }
func (m *GetSupportedLanguagesRequest) String() string { return proto.CompactTextString(m) }
func (*GetSupportedLanguagesRequest) ProtoMessage()    {}
func (*GetSupportedLanguagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{7}
}

func (m *GetSupportedLanguagesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSupportedLanguagesRequest.Unmarshal(m, b)
}
func (m *GetSupportedLanguagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSupportedLanguagesRequest.Marshal(b, m, deterministic)
}
func (m *GetSupportedLanguagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSupportedLanguagesRequest.Merge(m, src)
}
func (m *GetSupportedLanguagesRequest) XXX_Size() int {
	return xxx_messageInfo_GetSupportedLanguagesRequest.Size(m)
}
func (m *GetSupportedLanguagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSupportedLanguagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSupportedLanguagesRequest proto.InternalMessageInfo

func (m *GetSupportedLanguagesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GetSupportedLanguagesRequest) GetDisplayLanguageCode() string {
	if m != nil {
		return m.DisplayLanguageCode
	}
	return ""
}

func (m *GetSupportedLanguagesRequest) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// The response message for discovering supported languages.
type SupportedLanguages struct {
	// A list of supported language responses. This list contains an entry
	// for each language the Translation API supports.
	Languages            []*SupportedLanguage `protobuf:"bytes,1,rep,name=languages,proto3" json:"languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SupportedLanguages) Reset()         { *m = SupportedLanguages{} }
func (m *SupportedLanguages) String() string { return proto.CompactTextString(m) }
func (*SupportedLanguages) ProtoMessage()    {}
func (*SupportedLanguages) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{8}
}

func (m *SupportedLanguages) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SupportedLanguages.Unmarshal(m, b)
}
func (m *SupportedLanguages) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SupportedLanguages.Marshal(b, m, deterministic)
}
func (m *SupportedLanguages) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SupportedLanguages.Merge(m, src)
}
func (m *SupportedLanguages) XXX_Size() int {
	return xxx_messageInfo_SupportedLanguages.Size(m)
}
func (m *SupportedLanguages) XXX_DiscardUnknown() {
	xxx_messageInfo_SupportedLanguages.DiscardUnknown(m)
}

var xxx_messageInfo_SupportedLanguages proto.InternalMessageInfo

func (m *SupportedLanguages) GetLanguages() []*SupportedLanguage {
	if m != nil {
		return m.Languages
	}
	return nil
}

// A single supported language response corresponds to information related
// to one supported language.
type SupportedLanguage struct {
	// Supported language code, generally consisting of its ISO 639-1
	// identifier, for example, 'en', 'ja'. In certain cases, BCP-47 codes
	// including language and region identifiers are returned (for example,
	// 'zh-TW' and 'zh-CN')
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Human readable name of the language localized in the display language
	// specified in the request.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Can be used as source language.
	SupportSource bool `protobuf:"varint,3,opt,name=support_source,json=supportSource,proto3" json:"support_source,omitempty"`
	// Can be used as target language.
	SupportTarget        bool     `protobuf:"varint,4,opt,name=support_target,json=supportTarget,proto3" json:"support_target,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SupportedLanguage) Reset()         { *m = SupportedLanguage{} }
func (m *SupportedLanguage) String() string { return proto.CompactTextString(m) }
func (*SupportedLanguage) ProtoMessage()    {}
func (*SupportedLanguage) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{9}
}

func (m *SupportedLanguage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SupportedLanguage.Unmarshal(m, b)
}
func (m *SupportedLanguage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SupportedLanguage.Marshal(b, m, deterministic)
}
func (m *SupportedLanguage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SupportedLanguage.Merge(m, src)
}
func (m *SupportedLanguage) XXX_Size() int {
	return xxx_messageInfo_SupportedLanguage.Size(m)
}
func (m *SupportedLanguage) XXX_DiscardUnknown() {
	xxx_messageInfo_SupportedLanguage.DiscardUnknown(m)
}

var xxx_messageInfo_SupportedLanguage proto.InternalMessageInfo

func (m *SupportedLanguage) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *SupportedLanguage) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *SupportedLanguage) GetSupportSource() bool {
	if m != nil {
		return m.SupportSource
	}
	return false
}

func (m *SupportedLanguage) GetSupportTarget() bool {
	if m != nil {
		return m.SupportTarget
	}
	return false
}

// The Google Cloud Storage location for the input content.
type GcsSource struct {
	// Required. Source data URI. For example, `gs://my_bucket/my_object`.
	InputUri             string   `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsSource) Reset()         { *m = GcsSource{} }
func (m *GcsSource) String() string { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()    {}
func (*GcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{10}
}

func (m *GcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsSource.Unmarshal(m, b)
}
func (m *GcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsSource.Marshal(b, m, deterministic)
}
func (m *GcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsSource.Merge(m, src)
}
func (m *GcsSource) XXX_Size() int {
	return xxx_messageInfo_GcsSource.Size(m)
}
func (m *GcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_GcsSource proto.InternalMessageInfo

func (m *GcsSource) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

// Input configuration for BatchTranslateText request.
type InputConfig struct {
	// Optional. Can be "text/plain" or "text/html".
	// For `.tsv`, "text/html" is used if mime_type is missing.
	// For `.html`, this field must be "text/html" or empty.
	// For `.txt`, this field must be "text/plain" or empty.
	MimeType string `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Required. Specify the input.
	//
	// Types that are valid to be assigned to Source:
	//	*InputConfig_GcsSource
	Source               isInputConfig_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InputConfig) Reset()         { *m = InputConfig{} }
func (m *InputConfig) String() string { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()    {}
func (*InputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{11}
}

func (m *InputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputConfig.Unmarshal(m, b)
}
func (m *InputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputConfig.Marshal(b, m, deterministic)
}
func (m *InputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputConfig.Merge(m, src)
}
func (m *InputConfig) XXX_Size() int {
	return xxx_messageInfo_InputConfig.Size(m)
}
func (m *InputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputConfig proto.InternalMessageInfo

func (m *InputConfig) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InputConfig_GcsSource)(nil),
	}
}

// The Google Cloud Storage location for the output content
type GcsDestination struct {
	// Required. There must be no files under 'output_uri_prefix'.
	// 'output_uri_prefix' must end with "/", otherwise an INVALID_ARGUMENT (400)
	// error is returned..
	OutputUriPrefix      string   `protobuf:"bytes,1,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{12}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

func (m *GcsDestination) GetOutputUriPrefix() string {
	if m != nil {
		return m.OutputUriPrefix
	}
	return ""
}

// Output configuration for BatchTranslateText request.
type OutputConfig struct {
	// Required. The destination of output.
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	Destination          isOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{13}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OutputConfig_GcsDestination)(nil),
	}
}

// The batch translation request.
type BatchTranslateTextRequest struct {
	// Required. Location to make a regional call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// The `global` location is not supported for batch translation.
	//
	// Only AutoML Translation models or glossaries within the same region (have
	// the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
	// error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Source language code.
	SourceLanguageCode string `protobuf:"bytes,2,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. Specify up to 10 language codes here.
	TargetLanguageCodes []string `protobuf:"bytes,3,rep,name=target_language_codes,json=targetLanguageCodes,proto3" json:"target_language_codes,omitempty"`
	// Optional. The models to use for translation. Map's key is target language
	// code. Map's value is model name. Value can be a built-in general model,
	// or an AutoML Translation model.
	//
	// The value format depends on model type:
	//
	// - AutoML Translation models:
	//   `projects/{project-id}/locations/{location-id}/models/{model-id}`
	//
	// - General (built-in) models:
	//   `projects/{project-id}/locations/{location-id}/models/general/nmt`,
	//   `projects/{project-id}/locations/{location-id}/models/general/base`
	//
	//
	// If the map is empty or a specific model is
	// not requested for a language pair, then default google model (nmt) is used.
	Models map[string]string `protobuf:"bytes,4,rep,name=models,proto3" json:"models,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Input configurations.
	// The total number of files matched should be <= 1000.
	// The total content size should be <= 100M Unicode codepoints.
	// The files must use UTF-8 encoding.
	InputConfigs []*InputConfig `protobuf:"bytes,5,rep,name=input_configs,json=inputConfigs,proto3" json:"input_configs,omitempty"`
	// Required. Output configuration.
	// If 2 input configs match to the same file (that is, same input path),
	// we don't generate output for duplicate inputs.
	OutputConfig *OutputConfig `protobuf:"bytes,6,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Optional. Glossaries to be applied for translation.
	// It's keyed by target language code.
	Glossaries           map[string]*TranslateTextGlossaryConfig `protobuf:"bytes,7,rep,name=glossaries,proto3" json:"glossaries,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *BatchTranslateTextRequest) Reset()         { *m = BatchTranslateTextRequest{} }
func (m *BatchTranslateTextRequest) String() string { return proto.CompactTextString(m) }
func (*BatchTranslateTextRequest) ProtoMessage()    {}
func (*BatchTranslateTextRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{14}
}

func (m *BatchTranslateTextRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchTranslateTextRequest.Unmarshal(m, b)
}
func (m *BatchTranslateTextRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchTranslateTextRequest.Marshal(b, m, deterministic)
}
func (m *BatchTranslateTextRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchTranslateTextRequest.Merge(m, src)
}
func (m *BatchTranslateTextRequest) XXX_Size() int {
	return xxx_messageInfo_BatchTranslateTextRequest.Size(m)
}
func (m *BatchTranslateTextRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchTranslateTextRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchTranslateTextRequest proto.InternalMessageInfo

func (m *BatchTranslateTextRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchTranslateTextRequest) GetSourceLanguageCode() string {
	if m != nil {
		return m.SourceLanguageCode
	}
	return ""
}

func (m *BatchTranslateTextRequest) GetTargetLanguageCodes() []string {
	if m != nil {
		return m.TargetLanguageCodes
	}
	return nil
}

func (m *BatchTranslateTextRequest) GetModels() map[string]string {
	if m != nil {
		return m.Models
	}
	return nil
}

func (m *BatchTranslateTextRequest) GetInputConfigs() []*InputConfig {
	if m != nil {
		return m.InputConfigs
	}
	return nil
}

func (m *BatchTranslateTextRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

func (m *BatchTranslateTextRequest) GetGlossaries() map[string]*TranslateTextGlossaryConfig {
	if m != nil {
		return m.Glossaries
	}
	return nil
}

// State metadata for the batch translation operation.
type BatchTranslateMetadata struct {
	// The state of the operation.
	State BatchTranslateMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.translation.v3beta1.BatchTranslateMetadata_State" json:"state,omitempty"`
	// Number of successfully translated characters so far (Unicode codepoints).
	TranslatedCharacters int64 `protobuf:"varint,2,opt,name=translated_characters,json=translatedCharacters,proto3" json:"translated_characters,omitempty"`
	// Number of characters that have failed to process so far (Unicode
	// codepoints).
	FailedCharacters int64 `protobuf:"varint,3,opt,name=failed_characters,json=failedCharacters,proto3" json:"failed_characters,omitempty"`
	// Total number of characters (Unicode codepoints).
	// This is the total number of codepoints from input files times the number of
	// target languages and appears here shortly after the call is submitted.
	TotalCharacters int64 `protobuf:"varint,4,opt,name=total_characters,json=totalCharacters,proto3" json:"total_characters,omitempty"`
	// Time when the operation was submitted.
	SubmitTime           *timestamp.Timestamp `protobuf:"bytes,5,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *BatchTranslateMetadata) Reset()         { *m = BatchTranslateMetadata{} }
func (m *BatchTranslateMetadata) String() string { return proto.CompactTextString(m) }
func (*BatchTranslateMetadata) ProtoMessage()    {}
func (*BatchTranslateMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{15}
}

func (m *BatchTranslateMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchTranslateMetadata.Unmarshal(m, b)
}
func (m *BatchTranslateMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchTranslateMetadata.Marshal(b, m, deterministic)
}
func (m *BatchTranslateMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchTranslateMetadata.Merge(m, src)
}
func (m *BatchTranslateMetadata) XXX_Size() int {
	return xxx_messageInfo_BatchTranslateMetadata.Size(m)
}
func (m *BatchTranslateMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchTranslateMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BatchTranslateMetadata proto.InternalMessageInfo

func (m *BatchTranslateMetadata) GetState() BatchTranslateMetadata_State {
	if m != nil {
		return m.State
	}
	return BatchTranslateMetadata_STATE_UNSPECIFIED
}

func (m *BatchTranslateMetadata) GetTranslatedCharacters() int64 {
	if m != nil {
		return m.TranslatedCharacters
	}
	return 0
}

func (m *BatchTranslateMetadata) GetFailedCharacters() int64 {
	if m != nil {
		return m.FailedCharacters
	}
	return 0
}

func (m *BatchTranslateMetadata) GetTotalCharacters() int64 {
	if m != nil {
		return m.TotalCharacters
	}
	return 0
}

func (m *BatchTranslateMetadata) GetSubmitTime() *timestamp.Timestamp {
	if m != nil {
		return m.SubmitTime
	}
	return nil
}

// Stored in the [google.longrunning.Operation.response][google.longrunning.Operation.response] field returned by
// BatchTranslateText if at least one sentence is translated successfully.
type BatchTranslateResponse struct {
	// Total number of characters (Unicode codepoints).
	TotalCharacters int64 `protobuf:"varint,1,opt,name=total_characters,json=totalCharacters,proto3" json:"total_characters,omitempty"`
	// Number of successfully translated characters (Unicode codepoints).
	TranslatedCharacters int64 `protobuf:"varint,2,opt,name=translated_characters,json=translatedCharacters,proto3" json:"translated_characters,omitempty"`
	// Number of characters that have failed to process (Unicode codepoints).
	FailedCharacters int64 `protobuf:"varint,3,opt,name=failed_characters,json=failedCharacters,proto3" json:"failed_characters,omitempty"`
	// Time when the operation was submitted.
	SubmitTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// The time when the operation is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is set to true.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *BatchTranslateResponse) Reset()         { *m = BatchTranslateResponse{} }
func (m *BatchTranslateResponse) String() string { return proto.CompactTextString(m) }
func (*BatchTranslateResponse) ProtoMessage()    {}
func (*BatchTranslateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{16}
}

func (m *BatchTranslateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchTranslateResponse.Unmarshal(m, b)
}
func (m *BatchTranslateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchTranslateResponse.Marshal(b, m, deterministic)
}
func (m *BatchTranslateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchTranslateResponse.Merge(m, src)
}
func (m *BatchTranslateResponse) XXX_Size() int {
	return xxx_messageInfo_BatchTranslateResponse.Size(m)
}
func (m *BatchTranslateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchTranslateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchTranslateResponse proto.InternalMessageInfo

func (m *BatchTranslateResponse) GetTotalCharacters() int64 {
	if m != nil {
		return m.TotalCharacters
	}
	return 0
}

func (m *BatchTranslateResponse) GetTranslatedCharacters() int64 {
	if m != nil {
		return m.TranslatedCharacters
	}
	return 0
}

func (m *BatchTranslateResponse) GetFailedCharacters() int64 {
	if m != nil {
		return m.FailedCharacters
	}
	return 0
}

func (m *BatchTranslateResponse) GetSubmitTime() *timestamp.Timestamp {
	if m != nil {
		return m.SubmitTime
	}
	return nil
}

func (m *BatchTranslateResponse) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Input configuration for glossaries.
type GlossaryInputConfig struct {
	// Required. Specify the input.
	//
	// Types that are valid to be assigned to Source:
	//	*GlossaryInputConfig_GcsSource
	Source               isGlossaryInputConfig_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *GlossaryInputConfig) Reset()         { *m = GlossaryInputConfig{} }
func (m *GlossaryInputConfig) String() string { return proto.CompactTextString(m) }
func (*GlossaryInputConfig) ProtoMessage()    {}
func (*GlossaryInputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{17}
}

func (m *GlossaryInputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GlossaryInputConfig.Unmarshal(m, b)
}
func (m *GlossaryInputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GlossaryInputConfig.Marshal(b, m, deterministic)
}
func (m *GlossaryInputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GlossaryInputConfig.Merge(m, src)
}
func (m *GlossaryInputConfig) XXX_Size() int {
	return xxx_messageInfo_GlossaryInputConfig.Size(m)
}
func (m *GlossaryInputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_GlossaryInputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_GlossaryInputConfig proto.InternalMessageInfo

type isGlossaryInputConfig_Source interface {
	isGlossaryInputConfig_Source()
}

type GlossaryInputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*GlossaryInputConfig_GcsSource) isGlossaryInputConfig_Source() {}

func (m *GlossaryInputConfig) GetSource() isGlossaryInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *GlossaryInputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*GlossaryInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GlossaryInputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GlossaryInputConfig_GcsSource)(nil),
	}
}

// Represents a glossary built from user provided data.
type Glossary struct {
	// Required. The resource name of the glossary. Glossary names have the form
	// `projects/{project-id}/locations/{location-id}/glossaries/{glossary-id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Languages supported by the glossary.
	//
	// Types that are valid to be assigned to Languages:
	//	*Glossary_LanguagePair
	//	*Glossary_LanguageCodesSet_
	Languages isGlossary_Languages `protobuf_oneof:"languages"`
	// Required. Provides examples to build the glossary from.
	// Total glossary must not exceed 10M Unicode codepoints.
	InputConfig *GlossaryInputConfig `protobuf:"bytes,5,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Output only. The number of entries defined in the glossary.
	EntryCount int32 `protobuf:"varint,6,opt,name=entry_count,json=entryCount,proto3" json:"entry_count,omitempty"`
	// Output only. When CreateGlossary was called.
	SubmitTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// Output only. When the glossary creation was finished.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Glossary) Reset()         { *m = Glossary{} }
func (m *Glossary) String() string { return proto.CompactTextString(m) }
func (*Glossary) ProtoMessage()    {}
func (*Glossary) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{18}
}

func (m *Glossary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Glossary.Unmarshal(m, b)
}
func (m *Glossary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Glossary.Marshal(b, m, deterministic)
}
func (m *Glossary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Glossary.Merge(m, src)
}
func (m *Glossary) XXX_Size() int {
	return xxx_messageInfo_Glossary.Size(m)
}
func (m *Glossary) XXX_DiscardUnknown() {
	xxx_messageInfo_Glossary.DiscardUnknown(m)
}

var xxx_messageInfo_Glossary proto.InternalMessageInfo

func (m *Glossary) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isGlossary_Languages interface {
	isGlossary_Languages()
}

type Glossary_LanguagePair struct {
	LanguagePair *Glossary_LanguageCodePair `protobuf:"bytes,3,opt,name=language_pair,json=languagePair,proto3,oneof"`
}

type Glossary_LanguageCodesSet_ struct {
	LanguageCodesSet *Glossary_LanguageCodesSet `protobuf:"bytes,4,opt,name=language_codes_set,json=languageCodesSet,proto3,oneof"`
}

func (*Glossary_LanguagePair) isGlossary_Languages() {}

func (*Glossary_LanguageCodesSet_) isGlossary_Languages() {}

func (m *Glossary) GetLanguages() isGlossary_Languages {
	if m != nil {
		return m.Languages
	}
	return nil
}

func (m *Glossary) GetLanguagePair() *Glossary_LanguageCodePair {
	if x, ok := m.GetLanguages().(*Glossary_LanguagePair); ok {
		return x.LanguagePair
	}
	return nil
}

func (m *Glossary) GetLanguageCodesSet() *Glossary_LanguageCodesSet {
	if x, ok := m.GetLanguages().(*Glossary_LanguageCodesSet_); ok {
		return x.LanguageCodesSet
	}
	return nil
}

func (m *Glossary) GetInputConfig() *GlossaryInputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *Glossary) GetEntryCount() int32 {
	if m != nil {
		return m.EntryCount
	}
	return 0
}

func (m *Glossary) GetSubmitTime() *timestamp.Timestamp {
	if m != nil {
		return m.SubmitTime
	}
	return nil
}

func (m *Glossary) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Glossary) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Glossary_LanguagePair)(nil),
		(*Glossary_LanguageCodesSet_)(nil),
	}
}

// Used with unidirectional glossaries.
type Glossary_LanguageCodePair struct {
	// Required. The BCP-47 language code of the input text, for example,
	// "en-US". Expected to be an exact match for GlossaryTerm.language_code.
	SourceLanguageCode string `protobuf:"bytes,1,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. The BCP-47 language code for translation output, for example,
	// "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
	TargetLanguageCode   string   `protobuf:"bytes,2,opt,name=target_language_code,json=targetLanguageCode,proto3" json:"target_language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Glossary_LanguageCodePair) Reset()         { *m = Glossary_LanguageCodePair{} }
func (m *Glossary_LanguageCodePair) String() string { return proto.CompactTextString(m) }
func (*Glossary_LanguageCodePair) ProtoMessage()    {}
func (*Glossary_LanguageCodePair) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{18, 0}
}

func (m *Glossary_LanguageCodePair) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Glossary_LanguageCodePair.Unmarshal(m, b)
}
func (m *Glossary_LanguageCodePair) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Glossary_LanguageCodePair.Marshal(b, m, deterministic)
}
func (m *Glossary_LanguageCodePair) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Glossary_LanguageCodePair.Merge(m, src)
}
func (m *Glossary_LanguageCodePair) XXX_Size() int {
	return xxx_messageInfo_Glossary_LanguageCodePair.Size(m)
}
func (m *Glossary_LanguageCodePair) XXX_DiscardUnknown() {
	xxx_messageInfo_Glossary_LanguageCodePair.DiscardUnknown(m)
}

var xxx_messageInfo_Glossary_LanguageCodePair proto.InternalMessageInfo

func (m *Glossary_LanguageCodePair) GetSourceLanguageCode() string {
	if m != nil {
		return m.SourceLanguageCode
	}
	return ""
}

func (m *Glossary_LanguageCodePair) GetTargetLanguageCode() string {
	if m != nil {
		return m.TargetLanguageCode
	}
	return ""
}

// Used with equivalent term set glossaries.
type Glossary_LanguageCodesSet struct {
	// The BCP-47 language code(s) for terms defined in the glossary.
	// All entries are unique. The list contains at least two entries.
	// Expected to be an exact match for GlossaryTerm.language_code.
	LanguageCodes        []string `protobuf:"bytes,1,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Glossary_LanguageCodesSet) Reset()         { *m = Glossary_LanguageCodesSet{} }
func (m *Glossary_LanguageCodesSet) String() string { return proto.CompactTextString(m) }
func (*Glossary_LanguageCodesSet) ProtoMessage()    {}
func (*Glossary_LanguageCodesSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{18, 1}
}

func (m *Glossary_LanguageCodesSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Glossary_LanguageCodesSet.Unmarshal(m, b)
}
func (m *Glossary_LanguageCodesSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Glossary_LanguageCodesSet.Marshal(b, m, deterministic)
}
func (m *Glossary_LanguageCodesSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Glossary_LanguageCodesSet.Merge(m, src)
}
func (m *Glossary_LanguageCodesSet) XXX_Size() int {
	return xxx_messageInfo_Glossary_LanguageCodesSet.Size(m)
}
func (m *Glossary_LanguageCodesSet) XXX_DiscardUnknown() {
	xxx_messageInfo_Glossary_LanguageCodesSet.DiscardUnknown(m)
}

var xxx_messageInfo_Glossary_LanguageCodesSet proto.InternalMessageInfo

func (m *Glossary_LanguageCodesSet) GetLanguageCodes() []string {
	if m != nil {
		return m.LanguageCodes
	}
	return nil
}

// Request message for CreateGlossary.
type CreateGlossaryRequest struct {
	// Required. The project name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The glossary to create.
	Glossary             *Glossary `protobuf:"bytes,2,opt,name=glossary,proto3" json:"glossary,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateGlossaryRequest) Reset()         { *m = CreateGlossaryRequest{} }
func (m *CreateGlossaryRequest) String() string { return proto.CompactTextString(m) }
func (*CreateGlossaryRequest) ProtoMessage()    {}
func (*CreateGlossaryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{19}
}

func (m *CreateGlossaryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateGlossaryRequest.Unmarshal(m, b)
}
func (m *CreateGlossaryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateGlossaryRequest.Marshal(b, m, deterministic)
}
func (m *CreateGlossaryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateGlossaryRequest.Merge(m, src)
}
func (m *CreateGlossaryRequest) XXX_Size() int {
	return xxx_messageInfo_CreateGlossaryRequest.Size(m)
}
func (m *CreateGlossaryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateGlossaryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateGlossaryRequest proto.InternalMessageInfo

func (m *CreateGlossaryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateGlossaryRequest) GetGlossary() *Glossary {
	if m != nil {
		return m.Glossary
	}
	return nil
}

// Request message for GetGlossary.
type GetGlossaryRequest struct {
	// Required. The name of the glossary to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetGlossaryRequest) Reset()         { *m = GetGlossaryRequest{} }
func (m *GetGlossaryRequest) String() string { return proto.CompactTextString(m) }
func (*GetGlossaryRequest) ProtoMessage()    {}
func (*GetGlossaryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{20}
}

func (m *GetGlossaryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGlossaryRequest.Unmarshal(m, b)
}
func (m *GetGlossaryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGlossaryRequest.Marshal(b, m, deterministic)
}
func (m *GetGlossaryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGlossaryRequest.Merge(m, src)
}
func (m *GetGlossaryRequest) XXX_Size() int {
	return xxx_messageInfo_GetGlossaryRequest.Size(m)
}
func (m *GetGlossaryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGlossaryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetGlossaryRequest proto.InternalMessageInfo

func (m *GetGlossaryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for DeleteGlossary.
type DeleteGlossaryRequest struct {
	// Required. The name of the glossary to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteGlossaryRequest) Reset()         { *m = DeleteGlossaryRequest{} }
func (m *DeleteGlossaryRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteGlossaryRequest) ProtoMessage()    {}
func (*DeleteGlossaryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{21}
}

func (m *DeleteGlossaryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteGlossaryRequest.Unmarshal(m, b)
}
func (m *DeleteGlossaryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteGlossaryRequest.Marshal(b, m, deterministic)
}
func (m *DeleteGlossaryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteGlossaryRequest.Merge(m, src)
}
func (m *DeleteGlossaryRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteGlossaryRequest.Size(m)
}
func (m *DeleteGlossaryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteGlossaryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteGlossaryRequest proto.InternalMessageInfo

func (m *DeleteGlossaryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListGlossaries.
type ListGlossariesRequest struct {
	// Required. The name of the project from which to list all of the glossaries.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. The server may return fewer glossaries than
	// requested. If unspecified, the server picks an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	// Typically, this is the value of [ListGlossariesResponse.next_page_token]
	// returned from the previous call to `ListGlossaries` method.
	// The first page is returned if `page_token`is empty or missing.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter specifying constraints of a list operation.
	// Filtering is not supported yet, and the parameter currently has no effect.
	// If missing, no filtering is performed.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGlossariesRequest) Reset()         { *m = ListGlossariesRequest{} }
func (m *ListGlossariesRequest) String() string { return proto.CompactTextString(m) }
func (*ListGlossariesRequest) ProtoMessage()    {}
func (*ListGlossariesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{22}
}

func (m *ListGlossariesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGlossariesRequest.Unmarshal(m, b)
}
func (m *ListGlossariesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGlossariesRequest.Marshal(b, m, deterministic)
}
func (m *ListGlossariesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGlossariesRequest.Merge(m, src)
}
func (m *ListGlossariesRequest) XXX_Size() int {
	return xxx_messageInfo_ListGlossariesRequest.Size(m)
}
func (m *ListGlossariesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGlossariesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListGlossariesRequest proto.InternalMessageInfo

func (m *ListGlossariesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListGlossariesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListGlossariesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListGlossariesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response message for ListGlossaries.
type ListGlossariesResponse struct {
	// The list of glossaries for a project.
	Glossaries []*Glossary `protobuf:"bytes,1,rep,name=glossaries,proto3" json:"glossaries,omitempty"`
	// A token to retrieve a page of results. Pass this value in the
	// [ListGlossariesRequest.page_token] field in the subsequent call to
	// `ListGlossaries` method to retrieve the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGlossariesResponse) Reset()         { *m = ListGlossariesResponse{} }
func (m *ListGlossariesResponse) String() string { return proto.CompactTextString(m) }
func (*ListGlossariesResponse) ProtoMessage()    {}
func (*ListGlossariesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{23}
}

func (m *ListGlossariesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGlossariesResponse.Unmarshal(m, b)
}
func (m *ListGlossariesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGlossariesResponse.Marshal(b, m, deterministic)
}
func (m *ListGlossariesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGlossariesResponse.Merge(m, src)
}
func (m *ListGlossariesResponse) XXX_Size() int {
	return xxx_messageInfo_ListGlossariesResponse.Size(m)
}
func (m *ListGlossariesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGlossariesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListGlossariesResponse proto.InternalMessageInfo

func (m *ListGlossariesResponse) GetGlossaries() []*Glossary {
	if m != nil {
		return m.Glossaries
	}
	return nil
}

func (m *ListGlossariesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Stored in the [google.longrunning.Operation.metadata][google.longrunning.Operation.metadata] field returned by
// CreateGlossary.
type CreateGlossaryMetadata struct {
	// The name of the glossary that is being created.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current state of the glossary creation operation.
	State CreateGlossaryMetadata_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.translation.v3beta1.CreateGlossaryMetadata_State" json:"state,omitempty"`
	// The time when the operation was submitted to the server.
	SubmitTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateGlossaryMetadata) Reset()         { *m = CreateGlossaryMetadata{} }
func (m *CreateGlossaryMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateGlossaryMetadata) ProtoMessage()    {}
func (*CreateGlossaryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{24}
}

func (m *CreateGlossaryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateGlossaryMetadata.Unmarshal(m, b)
}
func (m *CreateGlossaryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateGlossaryMetadata.Marshal(b, m, deterministic)
}
func (m *CreateGlossaryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateGlossaryMetadata.Merge(m, src)
}
func (m *CreateGlossaryMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateGlossaryMetadata.Size(m)
}
func (m *CreateGlossaryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateGlossaryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateGlossaryMetadata proto.InternalMessageInfo

func (m *CreateGlossaryMetadata) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateGlossaryMetadata) GetState() CreateGlossaryMetadata_State {
	if m != nil {
		return m.State
	}
	return CreateGlossaryMetadata_STATE_UNSPECIFIED
}

func (m *CreateGlossaryMetadata) GetSubmitTime() *timestamp.Timestamp {
	if m != nil {
		return m.SubmitTime
	}
	return nil
}

// Stored in the [google.longrunning.Operation.metadata][google.longrunning.Operation.metadata] field returned by
// DeleteGlossary.
type DeleteGlossaryMetadata struct {
	// The name of the glossary that is being deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current state of the glossary deletion operation.
	State DeleteGlossaryMetadata_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.translation.v3beta1.DeleteGlossaryMetadata_State" json:"state,omitempty"`
	// The time when the operation was submitted to the server.
	SubmitTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeleteGlossaryMetadata) Reset()         { *m = DeleteGlossaryMetadata{} }
func (m *DeleteGlossaryMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteGlossaryMetadata) ProtoMessage()    {}
func (*DeleteGlossaryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{25}
}

func (m *DeleteGlossaryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteGlossaryMetadata.Unmarshal(m, b)
}
func (m *DeleteGlossaryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteGlossaryMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteGlossaryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteGlossaryMetadata.Merge(m, src)
}
func (m *DeleteGlossaryMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteGlossaryMetadata.Size(m)
}
func (m *DeleteGlossaryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteGlossaryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteGlossaryMetadata proto.InternalMessageInfo

func (m *DeleteGlossaryMetadata) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteGlossaryMetadata) GetState() DeleteGlossaryMetadata_State {
	if m != nil {
		return m.State
	}
	return DeleteGlossaryMetadata_STATE_UNSPECIFIED
}

func (m *DeleteGlossaryMetadata) GetSubmitTime() *timestamp.Timestamp {
	if m != nil {
		return m.SubmitTime
	}
	return nil
}

// Stored in the [google.longrunning.Operation.response][google.longrunning.Operation.response] field returned by
// DeleteGlossary.
type DeleteGlossaryResponse struct {
	// The name of the deleted glossary.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The time when the operation was submitted to the server.
	SubmitTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// The time when the glossary deletion is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is set to true.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeleteGlossaryResponse) Reset()         { *m = DeleteGlossaryResponse{} }
func (m *DeleteGlossaryResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteGlossaryResponse) ProtoMessage()    {}
func (*DeleteGlossaryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56145e4302ec702e, []int{26}
}

func (m *DeleteGlossaryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteGlossaryResponse.Unmarshal(m, b)
}
func (m *DeleteGlossaryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteGlossaryResponse.Marshal(b, m, deterministic)
}
func (m *DeleteGlossaryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteGlossaryResponse.Merge(m, src)
}
func (m *DeleteGlossaryResponse) XXX_Size() int {
	return xxx_messageInfo_DeleteGlossaryResponse.Size(m)
}
func (m *DeleteGlossaryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteGlossaryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteGlossaryResponse proto.InternalMessageInfo

func (m *DeleteGlossaryResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteGlossaryResponse) GetSubmitTime() *timestamp.Timestamp {
	if m != nil {
		return m.SubmitTime
	}
	return nil
}

func (m *DeleteGlossaryResponse) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.translation.v3beta1.BatchTranslateMetadata_State", BatchTranslateMetadata_State_name, BatchTranslateMetadata_State_value)
	proto.RegisterEnum("google.cloud.translation.v3beta1.CreateGlossaryMetadata_State", CreateGlossaryMetadata_State_name, CreateGlossaryMetadata_State_value)
	proto.RegisterEnum("google.cloud.translation.v3beta1.DeleteGlossaryMetadata_State", DeleteGlossaryMetadata_State_name, DeleteGlossaryMetadata_State_value)
	proto.RegisterType((*TranslateTextGlossaryConfig)(nil), "google.cloud.translation.v3beta1.TranslateTextGlossaryConfig")
	proto.RegisterType((*TranslateTextRequest)(nil), "google.cloud.translation.v3beta1.TranslateTextRequest")
	proto.RegisterType((*TranslateTextResponse)(nil), "google.cloud.translation.v3beta1.TranslateTextResponse")
	proto.RegisterType((*Translation)(nil), "google.cloud.translation.v3beta1.Translation")
	proto.RegisterType((*DetectLanguageRequest)(nil), "google.cloud.translation.v3beta1.DetectLanguageRequest")
	proto.RegisterType((*DetectedLanguage)(nil), "google.cloud.translation.v3beta1.DetectedLanguage")
	proto.RegisterType((*DetectLanguageResponse)(nil), "google.cloud.translation.v3beta1.DetectLanguageResponse")
	proto.RegisterType((*GetSupportedLanguagesRequest)(nil), "google.cloud.translation.v3beta1.GetSupportedLanguagesRequest")
	proto.RegisterType((*SupportedLanguages)(nil), "google.cloud.translation.v3beta1.SupportedLanguages")
	proto.RegisterType((*SupportedLanguage)(nil), "google.cloud.translation.v3beta1.SupportedLanguage")
	proto.RegisterType((*GcsSource)(nil), "google.cloud.translation.v3beta1.GcsSource")
	proto.RegisterType((*InputConfig)(nil), "google.cloud.translation.v3beta1.InputConfig")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.translation.v3beta1.GcsDestination")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.translation.v3beta1.OutputConfig")
	proto.RegisterType((*BatchTranslateTextRequest)(nil), "google.cloud.translation.v3beta1.BatchTranslateTextRequest")
	proto.RegisterMapType((map[string]*TranslateTextGlossaryConfig)(nil), "google.cloud.translation.v3beta1.BatchTranslateTextRequest.GlossariesEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.translation.v3beta1.BatchTranslateTextRequest.ModelsEntry")
	proto.RegisterType((*BatchTranslateMetadata)(nil), "google.cloud.translation.v3beta1.BatchTranslateMetadata")
	proto.RegisterType((*BatchTranslateResponse)(nil), "google.cloud.translation.v3beta1.BatchTranslateResponse")
	proto.RegisterType((*GlossaryInputConfig)(nil), "google.cloud.translation.v3beta1.GlossaryInputConfig")
	proto.RegisterType((*Glossary)(nil), "google.cloud.translation.v3beta1.Glossary")
	proto.RegisterType((*Glossary_LanguageCodePair)(nil), "google.cloud.translation.v3beta1.Glossary.LanguageCodePair")
	proto.RegisterType((*Glossary_LanguageCodesSet)(nil), "google.cloud.translation.v3beta1.Glossary.LanguageCodesSet")
	proto.RegisterType((*CreateGlossaryRequest)(nil), "google.cloud.translation.v3beta1.CreateGlossaryRequest")
	proto.RegisterType((*GetGlossaryRequest)(nil), "google.cloud.translation.v3beta1.GetGlossaryRequest")
	proto.RegisterType((*DeleteGlossaryRequest)(nil), "google.cloud.translation.v3beta1.DeleteGlossaryRequest")
	proto.RegisterType((*ListGlossariesRequest)(nil), "google.cloud.translation.v3beta1.ListGlossariesRequest")
	proto.RegisterType((*ListGlossariesResponse)(nil), "google.cloud.translation.v3beta1.ListGlossariesResponse")
	proto.RegisterType((*CreateGlossaryMetadata)(nil), "google.cloud.translation.v3beta1.CreateGlossaryMetadata")
	proto.RegisterType((*DeleteGlossaryMetadata)(nil), "google.cloud.translation.v3beta1.DeleteGlossaryMetadata")
	proto.RegisterType((*DeleteGlossaryResponse)(nil), "google.cloud.translation.v3beta1.DeleteGlossaryResponse")
}

func init() {
	proto.RegisterFile("google/cloud/translate/v3beta1/translation_service.proto", fileDescriptor_56145e4302ec702e)
}

var fileDescriptor_56145e4302ec702e = []byte{
	// 2040 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x59, 0x4f, 0x73, 0x23, 0x47,
	0x15, 0xf7, 0x48, 0x96, 0xff, 0x3c, 0x59, 0xb2, 0xb6, 0xd7, 0x72, 0x14, 0x6d, 0x36, 0x71, 0x26,
	0x15, 0x30, 0xde, 0x42, 0xda, 0xd8, 0xbb, 0xd9, 0x8d, 0x4c, 0x80, 0xb5, 0xac, 0x95, 0x0d, 0x8e,
	0xe3, 0x8c, 0xec, 0x40, 0x2d, 0x5b, 0xa5, 0x1a, 0x8f, 0xda, 0x93, 0xc9, 0x8e, 0x66, 0x86, 0xe9,
	0x96, 0x59, 0x2f, 0xa4, 0x8a, 0x0a, 0x45, 0x15, 0x07, 0x6e, 0x9c, 0xb8, 0x00, 0x17, 0xa8, 0x82,
	0xa2, 0x8a, 0x13, 0x55, 0x1c, 0xb9, 0x26, 0x07, 0x2e, 0x7c, 0x05, 0x4e, 0xb9, 0x51, 0xc5, 0x01,
	0x6e, 0xd4, 0x74, 0xf7, 0x48, 0x3d, 0xa3, 0xb1, 0x35, 0xf6, 0x26, 0x55, 0x70, 0x53, 0xbf, 0x7e,
	0xef, 0xf5, 0x7b, 0xbf, 0xf7, 0xfa, 0xbd, 0x37, 0x2d, 0xb8, 0x6f, 0xba, 0xae, 0x69, 0xe3, 0xba,
	0x61, 0xbb, 0x83, 0x5e, 0x9d, 0xfa, 0xba, 0x43, 0x6c, 0x9d, 0xe2, 0xfa, 0xe9, 0xc6, 0x31, 0xa6,
	0xfa, 0x1b, 0x43, 0x8a, 0xe5, 0x3a, 0x5d, 0x82, 0xfd, 0x53, 0xcb, 0xc0, 0x35, 0xcf, 0x77, 0xa9,
	0x8b, 0x56, 0xb8, 0x64, 0x8d, 0x49, 0xd6, 0x24, 0xbe, 0x9a, 0x90, 0xad, 0xbe, 0x24, 0x74, 0xeb,
	0x9e, 0x55, 0xd7, 0x1d, 0xc7, 0xa5, 0x6c, 0x9b, 0x70, 0xf9, 0xea, 0x8b, 0xd2, 0xae, 0x8f, 0x89,
	0x3b, 0xf0, 0x43, 0xd5, 0xd5, 0xd7, 0xc4, 0x96, 0xed, 0x3a, 0xa6, 0x3f, 0x70, 0x1c, 0xcb, 0x31,
	0xeb, 0xae, 0x87, 0xfd, 0x88, 0xfc, 0x2b, 0x82, 0x89, 0xad, 0x8e, 0x07, 0x27, 0x75, 0x6a, 0xf5,
	0x31, 0xa1, 0x7a, 0xdf, 0x13, 0x0c, 0x2f, 0x48, 0x07, 0x18, 0xb6, 0x85, 0x1d, 0xca, 0x37, 0xd4,
	0x47, 0x70, 0xe3, 0x30, 0x74, 0xf4, 0x10, 0x3f, 0xa5, 0x6d, 0xdb, 0x25, 0x44, 0xf7, 0xcf, 0x9a,
	0xae, 0x73, 0x62, 0x99, 0xa8, 0x0a, 0x73, 0xa6, 0xa0, 0x54, 0x94, 0x15, 0x65, 0x75, 0x5e, 0x1b,
	0xae, 0xd1, 0x2b, 0x90, 0xb7, 0x4c, 0xc7, 0xf5, 0x71, 0xd7, 0xd0, 0x09, 0xae, 0x64, 0x56, 0x94,
	0xd5, 0x39, 0x0d, 0x38, 0xa9, 0xa9, 0x13, 0xac, 0x7e, 0x92, 0x81, 0xa5, 0x88, 0x72, 0x0d, 0x7f,
	0x7f, 0x80, 0x09, 0x0d, 0xb4, 0x1a, 0xae, 0x43, 0xb1, 0x43, 0x49, 0x45, 0x59, 0xc9, 0x06, 0x5a,
	0xc3, 0x35, 0xba, 0x01, 0xf3, 0x7d, 0xab, 0x8f, 0xbb, 0xf4, 0xcc, 0xc3, 0x95, 0x2c, 0x3f, 0x32,
	0x20, 0x1c, 0x9e, 0x79, 0x18, 0xdd, 0x86, 0x25, 0x0e, 0x4e, 0xd7, 0xd6, 0x1d, 0x73, 0xa0, 0x9b,
	0xb8, 0x6b, 0xb8, 0x3d, 0x5c, 0x99, 0x66, 0x7c, 0x88, 0xef, 0xed, 0x89, 0xad, 0xa6, 0xdb, 0x63,
	0x12, 0x54, 0xf7, 0x4d, 0x4c, 0x63, 0x12, 0x39, 0x2e, 0xc1, 0xf7, 0x22, 0x12, 0xcb, 0x30, 0xe3,
	0xe9, 0x3e, 0x76, 0x68, 0x65, 0x8e, 0xf1, 0x88, 0x15, 0x5a, 0x82, 0x5c, 0xdf, 0xed, 0x61, 0xbb,
	0x32, 0xc3, 0xc8, 0x7c, 0x81, 0x4e, 0x60, 0x31, 0x04, 0xa4, 0x6b, 0x30, 0xcc, 0x2a, 0xb3, 0x2b,
	0xca, 0x6a, 0x7e, 0xfd, 0xed, 0xda, 0xa4, 0x9c, 0xa8, 0x5d, 0x00, 0xbc, 0x56, 0x34, 0x23, 0x6b,
	0xf5, 0x6f, 0x0a, 0x94, 0x63, 0x58, 0x12, 0xcf, 0x75, 0x08, 0x46, 0xef, 0xc1, 0x82, 0xa4, 0x9c,
	0x03, 0x9a, 0x5f, 0xff, 0x6a, 0xfa, 0xe3, 0x2d, 0xd7, 0xd1, 0x22, 0x2a, 0xd0, 0x31, 0x94, 0x87,
	0x4e, 0x45, 0x74, 0x67, 0xaf, 0xa2, 0x7b, 0x29, 0xd4, 0x25, 0x11, 0x89, 0xfa, 0x99, 0x02, 0x79,
	0x89, 0x80, 0xbe, 0x0c, 0x8b, 0xc3, 0x1b, 0xd7, 0xeb, 0x52, 0xfc, 0x94, 0x8a, 0x84, 0x2b, 0x8e,
	0xc8, 0x81, 0xdf, 0xa3, 0x38, 0x64, 0xe4, 0x38, 0xdc, 0x81, 0xe5, 0x1e, 0xa6, 0xd8, 0x08, 0x84,
	0x93, 0x72, 0x63, 0x29, 0xdc, 0x8d, 0xc4, 0x3a, 0x21, 0x7a, 0xd9, 0x2f, 0x22, 0x7a, 0x3f, 0x53,
	0xa0, 0xbc, 0xcd, 0x0c, 0x08, 0x8f, 0x0f, 0xaf, 0xc2, 0x28, 0xdb, 0x72, 0xc9, 0xd9, 0x36, 0x2d,
	0x7b, 0x59, 0x85, 0x59, 0x71, 0x51, 0x38, 0x38, 0x3b, 0x53, 0x5a, 0x48, 0xb8, 0xf0, 0xe2, 0x6c,
	0xcd, 0xc1, 0x0c, 0xbf, 0x1c, 0xea, 0x77, 0xa0, 0xb4, 0x1d, 0x83, 0x02, 0xbd, 0x06, 0x85, 0x28,
	0x66, 0x1c, 0xf9, 0x05, 0x5b, 0xc6, 0xea, 0x65, 0x00, 0x06, 0x51, 0x0f, 0x3b, 0x06, 0xbf, 0xed,
	0x19, 0x4d, 0xa2, 0xa8, 0x1f, 0xc2, 0x72, 0xdc, 0x45, 0x91, 0xa1, 0x07, 0x30, 0x1f, 0x6a, 0x0a,
	0xd3, 0x73, 0x7d, 0x32, 0xbe, 0x71, 0x2b, 0xb5, 0x91, 0x12, 0xf5, 0xc7, 0x0a, 0xbc, 0xd4, 0xc6,
	0xb4, 0x33, 0xf0, 0x3c, 0xd7, 0x97, 0x78, 0xc8, 0x38, 0xac, 0xd9, 0x08, 0xac, 0xeb, 0x50, 0xee,
	0x59, 0xc4, 0xb3, 0xf5, 0xb3, 0x6e, 0x92, 0xc7, 0xd7, 0xc5, 0x66, 0x24, 0x49, 0x12, 0x13, 0x4e,
	0x35, 0x01, 0x8d, 0x1f, 0x8f, 0xde, 0x1b, 0x77, 0x75, 0x63, 0xb2, 0xab, 0x63, 0x8a, 0x64, 0x5f,
	0x7f, 0xaf, 0xc0, 0xb5, 0x31, 0x86, 0x74, 0x21, 0x7b, 0x15, 0x16, 0x42, 0x6f, 0x1d, 0xbd, 0x8f,
	0x85, 0x03, 0x79, 0x41, 0xdb, 0xd7, 0xfb, 0x18, 0xbd, 0x0e, 0x45, 0xc2, 0x95, 0x77, 0x79, 0x82,
	0x30, 0xc0, 0xe6, 0xb4, 0x82, 0xa0, 0x76, 0x18, 0x51, 0x66, 0xe3, 0x25, 0x93, 0xe5, 0xe5, 0x88,
	0xed, 0x90, 0x11, 0xd5, 0x55, 0x98, 0x6f, 0x1b, 0x44, 0xc8, 0xdc, 0x80, 0x79, 0xcb, 0xf1, 0x06,
	0xb4, 0x3b, 0xf0, 0xad, 0xb0, 0x79, 0x30, 0xc2, 0x91, 0x6f, 0xa9, 0x1f, 0x2b, 0x90, 0xdf, 0x0d,
	0x16, 0xa2, 0xd1, 0x44, 0xb2, 0x57, 0x89, 0x95, 0xfd, 0x3d, 0x00, 0xd3, 0x20, 0xa1, 0x81, 0x19,
	0x76, 0x43, 0x6f, 0x4d, 0x86, 0x75, 0x68, 0xca, 0xce, 0x94, 0x36, 0x6f, 0x86, 0x0b, 0xe9, 0x2e,
	0x7c, 0x0d, 0x8a, 0x6d, 0x83, 0x6c, 0x63, 0x42, 0x2d, 0x87, 0x57, 0xa1, 0x35, 0xb8, 0xe6, 0x0e,
	0xa8, 0x30, 0xba, 0xeb, 0xf9, 0xf8, 0xc4, 0x7a, 0x2a, 0xcc, 0x59, 0xe4, 0x1b, 0x47, 0xbe, 0x75,
	0xc0, 0xc8, 0xea, 0x33, 0x58, 0x78, 0x97, 0x91, 0x84, 0x0b, 0xdf, 0x83, 0xc5, 0xc0, 0xca, 0xde,
	0x48, 0x1d, 0x93, 0xcc, 0xaf, 0xdf, 0x4e, 0x65, 0xaa, 0x64, 0xc6, 0xce, 0x94, 0x56, 0x34, 0x23,
	0x94, 0xad, 0x02, 0xe4, 0x25, 0xc5, 0xea, 0x27, 0x39, 0x78, 0x71, 0x4b, 0xa7, 0xc6, 0x07, 0x89,
	0xfd, 0x75, 0x94, 0xfd, 0x4a, 0x24, 0xfb, 0xcf, 0x6b, 0x9f, 0x99, 0x73, 0xdb, 0xe7, 0x3a, 0x94,
	0x93, 0xda, 0x27, 0xef, 0x04, 0xf3, 0xda, 0xf5, 0xf1, 0xfe, 0x49, 0x50, 0x17, 0x66, 0xd8, 0x15,
	0x21, 0x95, 0x69, 0x76, 0x01, 0xda, 0x93, 0xdd, 0x3f, 0xd7, 0x95, 0xda, 0x3b, 0x4c, 0x53, 0xcb,
	0xa1, 0xfe, 0x99, 0x26, 0xd4, 0x22, 0x0d, 0x0a, 0x3c, 0xb1, 0x78, 0xc9, 0x26, 0x95, 0x5c, 0xda,
	0xb6, 0x24, 0x65, 0x9c, 0xb6, 0x60, 0x8d, 0x16, 0x04, 0x75, 0xa0, 0x20, 0x02, 0x2f, 0xfa, 0xc0,
	0x0c, 0x0b, 0x5d, 0x6d, 0xb2, 0x4e, 0x39, 0x07, 0xb4, 0x05, 0x57, 0xce, 0x88, 0x27, 0x00, 0xa2,
	0x11, 0x58, 0x98, 0x54, 0x66, 0x99, 0x95, 0xdf, 0x7e, 0x1e, 0x34, 0xda, 0x43, 0x6d, 0x1c, 0x11,
	0x49, 0x7d, 0xf5, 0x2d, 0xc8, 0x4b, 0x60, 0xa1, 0x12, 0x64, 0x9f, 0xe0, 0x70, 0x68, 0x0b, 0x7e,
	0x06, 0x75, 0xec, 0x54, 0xb7, 0x07, 0x61, 0xb8, 0xf9, 0xa2, 0x91, 0xb9, 0xaf, 0x54, 0x7f, 0x04,
	0x8b, 0x31, 0xcd, 0x09, 0xe2, 0x1d, 0x59, 0xfc, 0xb9, 0x3b, 0xe4, 0xe8, 0x74, 0xf5, 0xd7, 0x59,
	0x58, 0x8e, 0xba, 0xfc, 0x0e, 0xa6, 0x7a, 0x4f, 0xa7, 0x3a, 0x3a, 0x84, 0x1c, 0xa1, 0x3a, 0xe5,
	0x15, 0xa1, 0xb8, 0xfe, 0xf5, 0xcb, 0x62, 0x17, 0x2a, 0xaa, 0x75, 0x02, 0x2d, 0x1a, 0x57, 0x86,
	0x36, 0xa0, 0x2c, 0x8d, 0x1a, 0xc6, 0x07, 0xba, 0xaf, 0x1b, 0x14, 0xfb, 0x84, 0x79, 0x96, 0xd5,
	0x96, 0x46, 0x9b, 0xcd, 0xe1, 0x1e, 0xba, 0x05, 0xd7, 0x4e, 0x74, 0xcb, 0x8e, 0x0a, 0x64, 0x99,
	0x40, 0x89, 0x6f, 0x48, 0xcc, 0x5f, 0x81, 0x12, 0x75, 0xa9, 0x6e, 0xcb, 0xbc, 0xd3, 0x8c, 0x77,
	0x91, 0xd1, 0x25, 0xd6, 0x4d, 0xc8, 0x93, 0xc1, 0x71, 0xdf, 0xa2, 0xdd, 0x60, 0x66, 0x67, 0x53,
	0x40, 0x7e, 0xbd, 0x1a, 0x3a, 0x1a, 0x0e, 0xf4, 0xb5, 0xc3, 0x70, 0xa0, 0xd7, 0x80, 0xb3, 0x07,
	0x04, 0x15, 0x43, 0x8e, 0x79, 0x86, 0xca, 0x70, 0xad, 0x73, 0xf8, 0xe0, 0xb0, 0xd5, 0x3d, 0xda,
	0xef, 0x1c, 0xb4, 0x9a, 0xbb, 0x0f, 0x77, 0x5b, 0xdb, 0xa5, 0x29, 0x94, 0x87, 0x59, 0xed, 0x68,
	0x7f, 0x7f, 0x77, 0xbf, 0x5d, 0x52, 0x50, 0x01, 0xe6, 0x3b, 0x47, 0xcd, 0x66, 0xab, 0xb5, 0xdd,
	0xda, 0x2e, 0x65, 0x10, 0xc0, 0xcc, 0xc3, 0x07, 0xbb, 0x7b, 0xad, 0xed, 0x52, 0x16, 0x15, 0x01,
	0x9a, 0x0f, 0xf6, 0x9b, 0xad, 0xbd, 0xbd, 0x80, 0x75, 0x3a, 0x60, 0x15, 0xeb, 0xd6, 0x76, 0x29,
	0xa7, 0xfe, 0x32, 0x13, 0x8f, 0xd0, 0xb0, 0xb7, 0x27, 0x79, 0xaa, 0x24, 0x7b, 0xfa, 0xc5, 0xc3,
	0x1e, 0xc3, 0x72, 0xfa, 0x32, 0x58, 0xa2, 0xbb, 0x30, 0x87, 0x9d, 0x5e, 0xda, 0x28, 0xcc, 0x62,
	0xa7, 0xc7, 0x42, 0xd0, 0x87, 0xeb, 0x61, 0x6a, 0xcb, 0xfd, 0x2c, 0xda, 0xb2, 0x94, 0xcf, 0xad,
	0x65, 0xfd, 0x2a, 0x07, 0x73, 0xe1, 0x79, 0x08, 0xc1, 0x34, 0xeb, 0xeb, 0xfc, 0x96, 0xb2, 0xdf,
	0xe8, 0x58, 0x1a, 0x0c, 0x3c, 0xdd, 0xf2, 0xc5, 0x40, 0xbb, 0x99, 0xe2, 0x6c, 0xa1, 0xb6, 0x26,
	0x97, 0xf3, 0x03, 0xdd, 0xf2, 0x77, 0xa6, 0x46, 0x73, 0x45, 0xb0, 0x46, 0x4f, 0x00, 0x45, 0xdb,
	0x41, 0x97, 0x88, 0x89, 0xe0, 0xea, 0x07, 0x91, 0x0e, 0xa6, 0x3b, 0x53, 0x5a, 0xc9, 0x8e, 0xd1,
	0xd0, 0x77, 0x61, 0x41, 0xae, 0xf6, 0x22, 0x36, 0x77, 0xd3, 0x1f, 0x23, 0x17, 0xfd, 0xbc, 0x54,
	0xf4, 0x83, 0x0f, 0x58, 0x1c, 0x14, 0xbb, 0xae, 0xe1, 0x0e, 0x1c, 0xca, 0x2a, 0x7e, 0x4e, 0x03,
	0x46, 0x6a, 0x06, 0x94, 0x78, 0x3e, 0xcd, 0x5e, 0x39, 0x9f, 0xe6, 0x52, 0xe7, 0x53, 0xf5, 0x14,
	0x4a, 0x71, 0xfc, 0xcf, 0xed, 0xdb, 0xca, 0xa5, 0x3f, 0x7b, 0x33, 0xe7, 0x7d, 0xf6, 0x56, 0xdf,
	0x8a, 0x9e, 0xcb, 0xa0, 0x7f, 0x1d, 0x8a, 0xb1, 0xb6, 0xcf, 0xbf, 0xd6, 0x0b, 0x91, 0x20, 0x6d,
	0xe5, 0xa5, 0xa1, 0x57, 0xfd, 0x01, 0x94, 0x9b, 0x3e, 0xd6, 0x29, 0x0e, 0xe1, 0x9f, 0x34, 0x94,
	0x3c, 0x94, 0x9e, 0x18, 0x78, 0x6b, 0x59, 0x4b, 0x1f, 0xdb, 0xd1, 0x73, 0x84, 0xba, 0x0a, 0xa8,
	0x8d, 0x69, 0xfc, 0xd4, 0x84, 0x2b, 0xa2, 0xde, 0x0a, 0x3e, 0xc6, 0x6c, 0x3c, 0x6e, 0x62, 0x12,
	0xf3, 0x4f, 0x14, 0x28, 0xef, 0x59, 0x84, 0x8e, 0x1a, 0xe4, 0x24, 0x87, 0x6e, 0xc0, 0xbc, 0x17,
	0x20, 0x46, 0xac, 0x67, 0x1c, 0xf0, 0x9c, 0x36, 0x17, 0x10, 0x3a, 0xd6, 0x33, 0x8c, 0x6e, 0x02,
	0xb0, 0x4d, 0xea, 0x3e, 0xc1, 0x8e, 0xf8, 0x38, 0x61, 0xec, 0x87, 0x01, 0x21, 0xd0, 0x79, 0x62,
	0xd9, 0x14, 0xfb, 0xe2, 0xbb, 0x4f, 0xac, 0xd4, 0x9f, 0x2b, 0xb0, 0x1c, 0xb7, 0x42, 0x54, 0xe0,
	0x6f, 0x45, 0x86, 0x0c, 0xfe, 0xcd, 0x71, 0x19, 0x04, 0x25, 0x69, 0xf4, 0x25, 0x58, 0x74, 0xf0,
	0x53, 0xda, 0x95, 0x4c, 0xe4, 0x19, 0x53, 0x08, 0xc8, 0x07, 0xa1, 0x99, 0xea, 0xef, 0x32, 0xb0,
	0x1c, 0x8d, 0xf2, 0xb0, 0x65, 0x27, 0xd5, 0xa4, 0x61, 0x1b, 0xcf, 0xa4, 0x6d, 0xe3, 0xc9, 0xca,
	0xa3, 0x6d, 0x3c, 0x76, 0x3b, 0xb3, 0xff, 0x8b, 0x9d, 0x33, 0x00, 0x2a, 0x9a, 0x6b, 0x9f, 0x33,
	0x50, 0xc9, 0xca, 0xff, 0xff, 0x80, 0xfa, 0x8d, 0x12, 0x07, 0x6a, 0x98, 0xe0, 0x49, 0x40, 0xc5,
	0x5c, 0xca, 0x5c, 0xb9, 0x32, 0x67, 0x53, 0x57, 0xe6, 0xf5, 0x3f, 0x17, 0x00, 0x49, 0x2f, 0x56,
	0x1d, 0xfe, 0x02, 0x8c, 0xfe, 0xa5, 0x40, 0x21, 0x32, 0xe9, 0xa2, 0x37, 0x2f, 0x39, 0x1a, 0x8b,
	0x82, 0x52, 0xbd, 0x77, 0x69, 0x39, 0x8e, 0x90, 0xea, 0x7f, 0xfc, 0xf7, 0x7f, 0xfc, 0x22, 0x63,
	0xab, 0x6f, 0x0e, 0x9f, 0xaa, 0x7f, 0xc8, 0x6b, 0xd1, 0xdb, 0x9e, 0xef, 0x7e, 0x88, 0x0d, 0x4a,
	0xea, 0x6b, 0x75, 0xdb, 0x35, 0xf8, 0xd3, 0x5b, 0x7d, 0xed, 0xa3, 0x06, 0x95, 0xf5, 0x34, 0x94,
	0xb5, 0x47, 0x75, 0x75, 0xed, 0x02, 0xe1, 0x71, 0x01, 0xf4, 0x1f, 0x05, 0x8a, 0xd1, 0xf7, 0x1e,
	0x74, 0x2f, 0xed, 0xa3, 0x4e, 0xec, 0x11, 0xac, 0x7a, 0xff, 0xf2, 0x82, 0xc2, 0x73, 0xca, 0x3c,
	0x77, 0xd4, 0x7b, 0xa9, 0x3d, 0xef, 0x45, 0x14, 0x05, 0xae, 0xdf, 0x56, 0x6f, 0x5d, 0xe8, 0xfa,
	0x98, 0x04, 0xfa, 0x69, 0x06, 0xca, 0x89, 0xcf, 0x4f, 0x28, 0xc5, 0x8d, 0xbd, 0xe8, 0xdd, 0xaa,
	0x7a, 0xe7, 0x0a, 0x8f, 0x45, 0x44, 0x3d, 0x65, 0x28, 0x78, 0x68, 0x33, 0x2d, 0x0a, 0x75, 0x32,
	0xa6, 0xe4, 0xd1, 0x1b, 0xa8, 0x7e, 0x11, 0x0c, 0x09, 0x22, 0xe8, 0x2f, 0x0a, 0xa0, 0xf1, 0x8f,
	0x55, 0xb4, 0xf9, 0x1c, 0x9f, 0xb8, 0xd5, 0x9b, 0xa1, 0xb0, 0xf4, 0x87, 0x47, 0xed, 0xdd, 0xf0,
	0x0f, 0x0f, 0xf5, 0x21, 0x73, 0xf5, 0x9b, 0x6a, 0x6a, 0x57, 0x1b, 0xc7, 0x63, 0x47, 0x05, 0x21,
	0xfc, 0x93, 0x02, 0xc5, 0x68, 0x93, 0x49, 0x93, 0xbe, 0x89, 0x93, 0xcd, 0x24, 0x93, 0x5b, 0xcc,
	0xe4, 0x6f, 0xa8, 0x1b, 0xa9, 0xa3, 0x33, 0xea, 0xc8, 0x8d, 0xd1, 0xdf, 0x2d, 0x7f, 0x55, 0xa0,
	0x18, 0x1d, 0x01, 0xd2, 0x58, 0x9c, 0x38, 0xba, 0xa4, 0xb9, 0x70, 0xc9, 0xd3, 0x86, 0xba, 0xc9,
	0x9c, 0xb9, 0x8b, 0xae, 0xe2, 0x0c, 0xfa, 0xa3, 0x02, 0x79, 0x69, 0x46, 0x43, 0x77, 0x52, 0xdd,
	0x96, 0x38, 0xdc, 0x97, 0x18, 0x6e, 0x92, 0xcc, 0x0d, 0xfa, 0xc7, 0x39, 0xc6, 0x4a, 0xb6, 0xd6,
	0xd7, 0x3e, 0x42, 0xbf, 0x65, 0x25, 0x4e, 0xee, 0x49, 0xe9, 0x4a, 0x5c, 0xc2, 0x68, 0x39, 0x29,
	0x47, 0x84, 0x9d, 0x6b, 0x57, 0xb1, 0xb3, 0x7a, 0xf3, 0xd3, 0x07, 0x55, 0xd9, 0x12, 0x7e, 0x92,
	0xee, 0x59, 0xa4, 0x66, 0xb8, 0xfd, 0xad, 0x7f, 0x2a, 0xa0, 0x1a, 0x6e, 0x3f, 0xd9, 0x72, 0x1c,
	0xda, 0xbd, 0xf5, 0xc2, 0x78, 0x6f, 0x3b, 0x08, 0xba, 0xe1, 0x81, 0xf2, 0xa8, 0x2d, 0x44, 0x4d,
	0x37, 0x98, 0xf3, 0x6b, 0xae, 0x6f, 0xd6, 0x4d, 0xec, 0xb0, 0x5e, 0x59, 0x1f, 0x1d, 0x76, 0xde,
	0xff, 0xa6, 0x9b, 0x43, 0xca, 0xbf, 0x15, 0xe5, 0x0f, 0x99, 0x97, 0xdb, 0x5c, 0x59, 0x93, 0xd9,
	0x31, 0xbc, 0x98, 0xb5, 0xf7, 0x37, 0xb6, 0x02, 0xee, 0x4f, 0x43, 0x86, 0xc7, 0x8c, 0xe1, 0xf1,
	0x90, 0xe1, 0xf1, 0xfb, 0x5c, 0xdd, 0x67, 0x99, 0x57, 0x39, 0x43, 0xa3, 0xc1, 0x38, 0x1a, 0x8d,
	0x21, 0x4b, 0xa3, 0x21, 0x78, 0x8e, 0x67, 0x98, 0x71, 0x1b, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff,
	0xc7, 0xf9, 0x08, 0x13, 0xd3, 0x1d, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TranslationServiceClient is the client API for TranslationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TranslationServiceClient interface {
	// Translates input text and returns translated text.
	TranslateText(ctx context.Context, in *TranslateTextRequest, opts ...grpc.CallOption) (*TranslateTextResponse, error)
	// Detects the language of text within a request.
	DetectLanguage(ctx context.Context, in *DetectLanguageRequest, opts ...grpc.CallOption) (*DetectLanguageResponse, error)
	// Returns a list of supported languages for translation.
	GetSupportedLanguages(ctx context.Context, in *GetSupportedLanguagesRequest, opts ...grpc.CallOption) (*SupportedLanguages, error)
	// Translates a large volume of text in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can
	// use google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateText(ctx context.Context, in *BatchTranslateTextRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a glossary and returns the long-running operation. Returns
	// NOT_FOUND, if the project doesn't exist.
	CreateGlossary(ctx context.Context, in *CreateGlossaryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
	// exist.
	ListGlossaries(ctx context.Context, in *ListGlossariesRequest, opts ...grpc.CallOption) (*ListGlossariesResponse, error)
	// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
	// exist.
	GetGlossary(ctx context.Context, in *GetGlossaryRequest, opts ...grpc.CallOption) (*Glossary, error)
	// Deletes a glossary, or cancels glossary construction
	// if the glossary isn't created yet.
	// Returns NOT_FOUND, if the glossary doesn't exist.
	DeleteGlossary(ctx context.Context, in *DeleteGlossaryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type translationServiceClient struct {
	cc *grpc.ClientConn
}

func NewTranslationServiceClient(cc *grpc.ClientConn) TranslationServiceClient {
	return &translationServiceClient{cc}
}

func (c *translationServiceClient) TranslateText(ctx context.Context, in *TranslateTextRequest, opts ...grpc.CallOption) (*TranslateTextResponse, error) {
	out := new(TranslateTextResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/TranslateText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DetectLanguage(ctx context.Context, in *DetectLanguageRequest, opts ...grpc.CallOption) (*DetectLanguageResponse, error) {
	out := new(DetectLanguageResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/DetectLanguage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetSupportedLanguages(ctx context.Context, in *GetSupportedLanguagesRequest, opts ...grpc.CallOption) (*SupportedLanguages, error) {
	out := new(SupportedLanguages)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/GetSupportedLanguages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) BatchTranslateText(ctx context.Context, in *BatchTranslateTextRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/BatchTranslateText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) CreateGlossary(ctx context.Context, in *CreateGlossaryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/CreateGlossary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) ListGlossaries(ctx context.Context, in *ListGlossariesRequest, opts ...grpc.CallOption) (*ListGlossariesResponse, error) {
	out := new(ListGlossariesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/ListGlossaries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) GetGlossary(ctx context.Context, in *GetGlossaryRequest, opts ...grpc.CallOption) (*Glossary, error) {
	out := new(Glossary)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/GetGlossary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *translationServiceClient) DeleteGlossary(ctx context.Context, in *DeleteGlossaryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.translation.v3beta1.TranslationService/DeleteGlossary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TranslationServiceServer is the server API for TranslationService service.
type TranslationServiceServer interface {
	// Translates input text and returns translated text.
	TranslateText(context.Context, *TranslateTextRequest) (*TranslateTextResponse, error)
	// Detects the language of text within a request.
	DetectLanguage(context.Context, *DetectLanguageRequest) (*DetectLanguageResponse, error)
	// Returns a list of supported languages for translation.
	GetSupportedLanguages(context.Context, *GetSupportedLanguagesRequest) (*SupportedLanguages, error)
	// Translates a large volume of text in asynchronous batch mode.
	// This function provides real-time output as the inputs are being processed.
	// If caller cancels a request, the partial results (for an input file, it's
	// all or nothing) may still be available on the specified output location.
	//
	// This call returns immediately and you can
	// use google.longrunning.Operation.name to poll the status of the call.
	BatchTranslateText(context.Context, *BatchTranslateTextRequest) (*longrunning.Operation, error)
	// Creates a glossary and returns the long-running operation. Returns
	// NOT_FOUND, if the project doesn't exist.
	CreateGlossary(context.Context, *CreateGlossaryRequest) (*longrunning.Operation, error)
	// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
	// exist.
	ListGlossaries(context.Context, *ListGlossariesRequest) (*ListGlossariesResponse, error)
	// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
	// exist.
	GetGlossary(context.Context, *GetGlossaryRequest) (*Glossary, error)
	// Deletes a glossary, or cancels glossary construction
	// if the glossary isn't created yet.
	// Returns NOT_FOUND, if the glossary doesn't exist.
	DeleteGlossary(context.Context, *DeleteGlossaryRequest) (*longrunning.Operation, error)
}

func RegisterTranslationServiceServer(s *grpc.Server, srv TranslationServiceServer) {
	s.RegisterService(&_TranslationService_serviceDesc, srv)
}

func _TranslationService_TranslateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TranslateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).TranslateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/TranslateText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).TranslateText(ctx, req.(*TranslateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DetectLanguage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectLanguageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DetectLanguage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/DetectLanguage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DetectLanguage(ctx, req.(*DetectLanguageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetSupportedLanguages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSupportedLanguagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetSupportedLanguages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/GetSupportedLanguages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetSupportedLanguages(ctx, req.(*GetSupportedLanguagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_BatchTranslateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchTranslateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).BatchTranslateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/BatchTranslateText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).BatchTranslateText(ctx, req.(*BatchTranslateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_CreateGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).CreateGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/CreateGlossary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).CreateGlossary(ctx, req.(*CreateGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_ListGlossaries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlossariesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).ListGlossaries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/ListGlossaries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).ListGlossaries(ctx, req.(*ListGlossariesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_GetGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).GetGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/GetGlossary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).GetGlossary(ctx, req.(*GetGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranslationService_DeleteGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranslationServiceServer).DeleteGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.translation.v3beta1.TranslationService/DeleteGlossary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranslationServiceServer).DeleteGlossary(ctx, req.(*DeleteGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TranslationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.translation.v3beta1.TranslationService",
	HandlerType: (*TranslationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TranslateText",
			Handler:    _TranslationService_TranslateText_Handler,
		},
		{
			MethodName: "DetectLanguage",
			Handler:    _TranslationService_DetectLanguage_Handler,
		},
		{
			MethodName: "GetSupportedLanguages",
			Handler:    _TranslationService_GetSupportedLanguages_Handler,
		},
		{
			MethodName: "BatchTranslateText",
			Handler:    _TranslationService_BatchTranslateText_Handler,
		},
		{
			MethodName: "CreateGlossary",
			Handler:    _TranslationService_CreateGlossary_Handler,
		},
		{
			MethodName: "ListGlossaries",
			Handler:    _TranslationService_ListGlossaries_Handler,
		},
		{
			MethodName: "GetGlossary",
			Handler:    _TranslationService_GetGlossary_Handler,
		},
		{
			MethodName: "DeleteGlossary",
			Handler:    _TranslationService_DeleteGlossary_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/translate/v3beta1/translation_service.proto",
}
