// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateApplication
func (c *ApplicationInsights) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for Amazon CloudWatch Application Insights.
//
// Adds an application that is created from a resource group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation CreateApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is already created or in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateApplication
func (c *ApplicationInsights) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateComponent = "CreateComponent"

// CreateComponentRequest generates a "aws/request.Request" representing the
// client's request for the CreateComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComponent for more information on using the CreateComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateComponentRequest method.
//    req, resp := client.CreateComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateComponent
func (c *ApplicationInsights) CreateComponentRequest(input *CreateComponentInput) (req *request.Request, output *CreateComponentOutput) {
	op := &request.Operation{
		Name:       opCreateComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateComponentInput{}
	}

	output = &CreateComponentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateComponent API operation for Amazon CloudWatch Application Insights.
//
// Creates a custom component by grouping similar standalone instances to monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation CreateComponent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is already created or in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateComponent
func (c *ApplicationInsights) CreateComponent(input *CreateComponentInput) (*CreateComponentOutput, error) {
	req, out := c.CreateComponentRequest(input)
	return out, req.Send()
}

// CreateComponentWithContext is the same as CreateComponent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) CreateComponentWithContext(ctx aws.Context, input *CreateComponentInput, opts ...request.Option) (*CreateComponentOutput, error) {
	req, out := c.CreateComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteApplication
func (c *ApplicationInsights) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for Amazon CloudWatch Application Insights.
//
// Removes the specified application from monitoring. Does not delete the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not understood by the server.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteApplication
func (c *ApplicationInsights) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteComponent = "DeleteComponent"

// DeleteComponentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteComponent for more information on using the DeleteComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteComponentRequest method.
//    req, resp := client.DeleteComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteComponent
func (c *ApplicationInsights) DeleteComponentRequest(input *DeleteComponentInput) (req *request.Request, output *DeleteComponentOutput) {
	op := &request.Operation{
		Name:       opDeleteComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteComponentInput{}
	}

	output = &DeleteComponentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteComponent API operation for Amazon CloudWatch Application Insights.
//
// Ungroups a custom component. When you ungroup custom components, all applicable
// monitors that are set up for the component are removed and the instances
// revert to their standalone status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DeleteComponent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteComponent
func (c *ApplicationInsights) DeleteComponent(input *DeleteComponentInput) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	return out, req.Send()
}

// DeleteComponentWithContext is the same as DeleteComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DeleteComponentWithContext(ctx aws.Context, input *DeleteComponentInput, opts ...request.Option) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplication = "DescribeApplication"

// DescribeApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplication for more information on using the DescribeApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationRequest method.
//    req, resp := client.DescribeApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeApplication
func (c *ApplicationInsights) DescribeApplicationRequest(input *DescribeApplicationInput) (req *request.Request, output *DescribeApplicationOutput) {
	op := &request.Operation{
		Name:       opDescribeApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationInput{}
	}

	output = &DescribeApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplication API operation for Amazon CloudWatch Application Insights.
//
// Describes the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeApplication
func (c *ApplicationInsights) DescribeApplication(input *DescribeApplicationInput) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	return out, req.Send()
}

// DescribeApplicationWithContext is the same as DescribeApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeApplicationWithContext(ctx aws.Context, input *DescribeApplicationInput, opts ...request.Option) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComponent = "DescribeComponent"

// DescribeComponentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComponent for more information on using the DescribeComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComponentRequest method.
//    req, resp := client.DescribeComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponent
func (c *ApplicationInsights) DescribeComponentRequest(input *DescribeComponentInput) (req *request.Request, output *DescribeComponentOutput) {
	op := &request.Operation{
		Name:       opDescribeComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComponentInput{}
	}

	output = &DescribeComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComponent API operation for Amazon CloudWatch Application Insights.
//
// Describes a component and lists the resources that are grouped together in
// a component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeComponent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponent
func (c *ApplicationInsights) DescribeComponent(input *DescribeComponentInput) (*DescribeComponentOutput, error) {
	req, out := c.DescribeComponentRequest(input)
	return out, req.Send()
}

// DescribeComponentWithContext is the same as DescribeComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeComponentWithContext(ctx aws.Context, input *DescribeComponentInput, opts ...request.Option) (*DescribeComponentOutput, error) {
	req, out := c.DescribeComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComponentConfiguration = "DescribeComponentConfiguration"

// DescribeComponentConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComponentConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComponentConfiguration for more information on using the DescribeComponentConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComponentConfigurationRequest method.
//    req, resp := client.DescribeComponentConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfiguration
func (c *ApplicationInsights) DescribeComponentConfigurationRequest(input *DescribeComponentConfigurationInput) (req *request.Request, output *DescribeComponentConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeComponentConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComponentConfigurationInput{}
	}

	output = &DescribeComponentConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComponentConfiguration API operation for Amazon CloudWatch Application Insights.
//
// Describes the monitoring configuration of the component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeComponentConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfiguration
func (c *ApplicationInsights) DescribeComponentConfiguration(input *DescribeComponentConfigurationInput) (*DescribeComponentConfigurationOutput, error) {
	req, out := c.DescribeComponentConfigurationRequest(input)
	return out, req.Send()
}

// DescribeComponentConfigurationWithContext is the same as DescribeComponentConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComponentConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeComponentConfigurationWithContext(ctx aws.Context, input *DescribeComponentConfigurationInput, opts ...request.Option) (*DescribeComponentConfigurationOutput, error) {
	req, out := c.DescribeComponentConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComponentConfigurationRecommendation = "DescribeComponentConfigurationRecommendation"

// DescribeComponentConfigurationRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComponentConfigurationRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComponentConfigurationRecommendation for more information on using the DescribeComponentConfigurationRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComponentConfigurationRecommendationRequest method.
//    req, resp := client.DescribeComponentConfigurationRecommendationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfigurationRecommendation
func (c *ApplicationInsights) DescribeComponentConfigurationRecommendationRequest(input *DescribeComponentConfigurationRecommendationInput) (req *request.Request, output *DescribeComponentConfigurationRecommendationOutput) {
	op := &request.Operation{
		Name:       opDescribeComponentConfigurationRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComponentConfigurationRecommendationInput{}
	}

	output = &DescribeComponentConfigurationRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComponentConfigurationRecommendation API operation for Amazon CloudWatch Application Insights.
//
// Describes the recommended monitoring configuration of the component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeComponentConfigurationRecommendation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfigurationRecommendation
func (c *ApplicationInsights) DescribeComponentConfigurationRecommendation(input *DescribeComponentConfigurationRecommendationInput) (*DescribeComponentConfigurationRecommendationOutput, error) {
	req, out := c.DescribeComponentConfigurationRecommendationRequest(input)
	return out, req.Send()
}

// DescribeComponentConfigurationRecommendationWithContext is the same as DescribeComponentConfigurationRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComponentConfigurationRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeComponentConfigurationRecommendationWithContext(ctx aws.Context, input *DescribeComponentConfigurationRecommendationInput, opts ...request.Option) (*DescribeComponentConfigurationRecommendationOutput, error) {
	req, out := c.DescribeComponentConfigurationRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeObservation = "DescribeObservation"

// DescribeObservationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeObservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeObservation for more information on using the DescribeObservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeObservationRequest method.
//    req, resp := client.DescribeObservationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeObservation
func (c *ApplicationInsights) DescribeObservationRequest(input *DescribeObservationInput) (req *request.Request, output *DescribeObservationOutput) {
	op := &request.Operation{
		Name:       opDescribeObservation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeObservationInput{}
	}

	output = &DescribeObservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeObservation API operation for Amazon CloudWatch Application Insights.
//
// Describes an anomaly or error with the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeObservation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeObservation
func (c *ApplicationInsights) DescribeObservation(input *DescribeObservationInput) (*DescribeObservationOutput, error) {
	req, out := c.DescribeObservationRequest(input)
	return out, req.Send()
}

// DescribeObservationWithContext is the same as DescribeObservation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeObservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeObservationWithContext(ctx aws.Context, input *DescribeObservationInput, opts ...request.Option) (*DescribeObservationOutput, error) {
	req, out := c.DescribeObservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProblem = "DescribeProblem"

// DescribeProblemRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProblem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProblem for more information on using the DescribeProblem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProblemRequest method.
//    req, resp := client.DescribeProblemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblem
func (c *ApplicationInsights) DescribeProblemRequest(input *DescribeProblemInput) (req *request.Request, output *DescribeProblemOutput) {
	op := &request.Operation{
		Name:       opDescribeProblem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProblemInput{}
	}

	output = &DescribeProblemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProblem API operation for Amazon CloudWatch Application Insights.
//
// Describes an application problem.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeProblem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblem
func (c *ApplicationInsights) DescribeProblem(input *DescribeProblemInput) (*DescribeProblemOutput, error) {
	req, out := c.DescribeProblemRequest(input)
	return out, req.Send()
}

// DescribeProblemWithContext is the same as DescribeProblem with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProblem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeProblemWithContext(ctx aws.Context, input *DescribeProblemInput, opts ...request.Option) (*DescribeProblemOutput, error) {
	req, out := c.DescribeProblemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProblemObservations = "DescribeProblemObservations"

// DescribeProblemObservationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProblemObservations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProblemObservations for more information on using the DescribeProblemObservations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProblemObservationsRequest method.
//    req, resp := client.DescribeProblemObservationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblemObservations
func (c *ApplicationInsights) DescribeProblemObservationsRequest(input *DescribeProblemObservationsInput) (req *request.Request, output *DescribeProblemObservationsOutput) {
	op := &request.Operation{
		Name:       opDescribeProblemObservations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProblemObservationsInput{}
	}

	output = &DescribeProblemObservationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProblemObservations API operation for Amazon CloudWatch Application Insights.
//
// Describes the anomalies or errors associated with the problem.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeProblemObservations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblemObservations
func (c *ApplicationInsights) DescribeProblemObservations(input *DescribeProblemObservationsInput) (*DescribeProblemObservationsOutput, error) {
	req, out := c.DescribeProblemObservationsRequest(input)
	return out, req.Send()
}

// DescribeProblemObservationsWithContext is the same as DescribeProblemObservations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProblemObservations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeProblemObservationsWithContext(ctx aws.Context, input *DescribeProblemObservationsInput, opts ...request.Option) (*DescribeProblemObservationsOutput, error) {
	req, out := c.DescribeProblemObservationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListApplications
func (c *ApplicationInsights) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for Amazon CloudWatch Application Insights.
//
// Lists the IDs of the applications that you are monitoring.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation ListApplications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListApplications
func (c *ApplicationInsights) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplications operation.
//    pageNum := 0
//    err := client.ListApplicationsPages(params,
//        func(page *applicationinsights.ListApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationInsights) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListComponents = "ListComponents"

// ListComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponents for more information on using the ListComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListComponentsRequest method.
//    req, resp := client.ListComponentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListComponents
func (c *ApplicationInsights) ListComponentsRequest(input *ListComponentsInput) (req *request.Request, output *ListComponentsOutput) {
	op := &request.Operation{
		Name:       opListComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentsInput{}
	}

	output = &ListComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponents API operation for Amazon CloudWatch Application Insights.
//
// Lists the auto-grouped, standalone, and custom components of the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation ListComponents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListComponents
func (c *ApplicationInsights) ListComponents(input *ListComponentsInput) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	return out, req.Send()
}

// ListComponentsWithContext is the same as ListComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListComponentsWithContext(ctx aws.Context, input *ListComponentsInput, opts ...request.Option) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentsPages iterates over the pages of a ListComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListComponents operation.
//    pageNum := 0
//    err := client.ListComponentsPages(params,
//        func(page *applicationinsights.ListComponentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationInsights) ListComponentsPages(input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool) error {
	return c.ListComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentsPagesWithContext same as ListComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListComponentsPagesWithContext(ctx aws.Context, input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListComponentsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListProblems = "ListProblems"

// ListProblemsRequest generates a "aws/request.Request" representing the
// client's request for the ListProblems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProblems for more information on using the ListProblems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProblemsRequest method.
//    req, resp := client.ListProblemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListProblems
func (c *ApplicationInsights) ListProblemsRequest(input *ListProblemsInput) (req *request.Request, output *ListProblemsOutput) {
	op := &request.Operation{
		Name:       opListProblems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProblemsInput{}
	}

	output = &ListProblemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProblems API operation for Amazon CloudWatch Application Insights.
//
// Lists the problems with your application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation ListProblems for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListProblems
func (c *ApplicationInsights) ListProblems(input *ListProblemsInput) (*ListProblemsOutput, error) {
	req, out := c.ListProblemsRequest(input)
	return out, req.Send()
}

// ListProblemsWithContext is the same as ListProblems with the addition of
// the ability to pass a context and additional request options.
//
// See ListProblems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListProblemsWithContext(ctx aws.Context, input *ListProblemsInput, opts ...request.Option) (*ListProblemsOutput, error) {
	req, out := c.ListProblemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProblemsPages iterates over the pages of a ListProblems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProblems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProblems operation.
//    pageNum := 0
//    err := client.ListProblemsPages(params,
//        func(page *applicationinsights.ListProblemsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationInsights) ListProblemsPages(input *ListProblemsInput, fn func(*ListProblemsOutput, bool) bool) error {
	return c.ListProblemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProblemsPagesWithContext same as ListProblemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListProblemsPagesWithContext(ctx aws.Context, input *ListProblemsInput, fn func(*ListProblemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProblemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProblemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListProblemsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opUpdateComponent = "UpdateComponent"

// UpdateComponentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateComponent for more information on using the UpdateComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateComponentRequest method.
//    req, resp := client.UpdateComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponent
func (c *ApplicationInsights) UpdateComponentRequest(input *UpdateComponentInput) (req *request.Request, output *UpdateComponentOutput) {
	op := &request.Operation{
		Name:       opUpdateComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateComponentInput{}
	}

	output = &UpdateComponentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateComponent API operation for Amazon CloudWatch Application Insights.
//
// Updates the custom component name and/or the list of resources that make
// up the component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation UpdateComponent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is already created or in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponent
func (c *ApplicationInsights) UpdateComponent(input *UpdateComponentInput) (*UpdateComponentOutput, error) {
	req, out := c.UpdateComponentRequest(input)
	return out, req.Send()
}

// UpdateComponentWithContext is the same as UpdateComponent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) UpdateComponentWithContext(ctx aws.Context, input *UpdateComponentInput, opts ...request.Option) (*UpdateComponentOutput, error) {
	req, out := c.UpdateComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateComponentConfiguration = "UpdateComponentConfiguration"

// UpdateComponentConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateComponentConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateComponentConfiguration for more information on using the UpdateComponentConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateComponentConfigurationRequest method.
//    req, resp := client.UpdateComponentConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponentConfiguration
func (c *ApplicationInsights) UpdateComponentConfigurationRequest(input *UpdateComponentConfigurationInput) (req *request.Request, output *UpdateComponentConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateComponentConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateComponentConfigurationInput{}
	}

	output = &UpdateComponentConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateComponentConfiguration API operation for Amazon CloudWatch Application Insights.
//
// Updates the monitoring configurations for the component. The configuration
// input parameter is an escaped JSON of the configuration and should match
// the schema of what is returned by DescribeComponentConfigurationRecommendation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation UpdateComponentConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource does not exist in the customer account.
//
//   * ErrCodeValidationException "ValidationException"
//   The parameter is not valid.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponentConfiguration
func (c *ApplicationInsights) UpdateComponentConfiguration(input *UpdateComponentConfigurationInput) (*UpdateComponentConfigurationOutput, error) {
	req, out := c.UpdateComponentConfigurationRequest(input)
	return out, req.Send()
}

// UpdateComponentConfigurationWithContext is the same as UpdateComponentConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateComponentConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) UpdateComponentConfigurationWithContext(ctx aws.Context, input *UpdateComponentConfigurationInput, opts ...request.Option) (*UpdateComponentConfigurationOutput, error) {
	req, out := c.UpdateComponentConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes a standalone resource or similarly grouped resources that the application
// is made up of.
type ApplicationComponent struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	ComponentName *string `type:"string"`

	// Indicates whether the application component is monitored.
	Monitor *bool `type:"boolean"`

	// The resource type. Supported resource types include EC2 instances, Auto Scaling
	// group, Classic ELB, Application ELB, and SQS Queue.
	ResourceType *string `type:"string"`

	// The stack tier of the application component.
	Tier *string `type:"string"`
}

// String returns the string representation
func (s ApplicationComponent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationComponent) GoString() string {
	return s.String()
}

// SetComponentName sets the ComponentName field's value.
func (s *ApplicationComponent) SetComponentName(v string) *ApplicationComponent {
	s.ComponentName = &v
	return s
}

// SetMonitor sets the Monitor field's value.
func (s *ApplicationComponent) SetMonitor(v bool) *ApplicationComponent {
	s.Monitor = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ApplicationComponent) SetResourceType(v string) *ApplicationComponent {
	s.ResourceType = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *ApplicationComponent) SetTier(v string) *ApplicationComponent {
	s.Tier = &v
	return s
}

// Describes the status of the application.
type ApplicationInfo struct {
	_ struct{} `type:"structure"`

	// The lifecycle of the application.
	LifeCycle *string `type:"string"`

	// The issues on the user side that are blocking Application Insights from fully
	// monitoring the application.
	Remarks *string `type:"string"`

	// The name of the resource group used for the application.
	ResourceGroupName *string `type:"string"`
}

// String returns the string representation
func (s ApplicationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationInfo) GoString() string {
	return s.String()
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *ApplicationInfo) SetLifeCycle(v string) *ApplicationInfo {
	s.LifeCycle = &v
	return s
}

// SetRemarks sets the Remarks field's value.
func (s *ApplicationInfo) SetRemarks(v string) *ApplicationInfo {
	s.Remarks = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ApplicationInfo) SetResourceGroupName(v string) *ApplicationInfo {
	s.ResourceGroupName = &v
	return s
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *CreateApplicationInput) SetResourceGroupName(v string) *CreateApplicationInput {
	s.ResourceGroupName = &v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the application.
	ApplicationInfo *ApplicationInfo `type:"structure"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationInfo sets the ApplicationInfo field's value.
func (s *CreateApplicationOutput) SetApplicationInfo(v *ApplicationInfo) *CreateApplicationOutput {
	s.ApplicationInfo = v
	return s
}

type CreateComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`

	// The list of resource ARNs that belong to the component.
	//
	// ResourceList is a required field
	ResourceList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComponentInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceList == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *CreateComponentInput) SetComponentName(v string) *CreateComponentInput {
	s.ComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *CreateComponentInput) SetResourceGroupName(v string) *CreateComponentInput {
	s.ResourceGroupName = &v
	return s
}

// SetResourceList sets the ResourceList field's value.
func (s *CreateComponentInput) SetResourceList(v []*string) *CreateComponentInput {
	s.ResourceList = v
	return s
}

type CreateComponentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComponentOutput) GoString() string {
	return s.String()
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DeleteApplicationInput) SetResourceGroupName(v string) *DeleteApplicationInput {
	s.ResourceGroupName = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type DeleteComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteComponentInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *DeleteComponentInput) SetComponentName(v string) *DeleteComponentInput {
	s.ComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DeleteComponentInput) SetResourceGroupName(v string) *DeleteComponentInput {
	s.ResourceGroupName = &v
	return s
}

type DeleteComponentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteComponentOutput) GoString() string {
	return s.String()
}

type DescribeApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationInput"}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DescribeApplicationInput) SetResourceGroupName(v string) *DescribeApplicationInput {
	s.ResourceGroupName = &v
	return s
}

type DescribeApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the application.
	ApplicationInfo *ApplicationInfo `type:"structure"`
}

// String returns the string representation
func (s DescribeApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationInfo sets the ApplicationInfo field's value.
func (s *DescribeApplicationOutput) SetApplicationInfo(v *ApplicationInfo) *DescribeApplicationOutput {
	s.ApplicationInfo = v
	return s
}

type DescribeComponentConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeComponentConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComponentConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComponentConfigurationInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *DescribeComponentConfigurationInput) SetComponentName(v string) *DescribeComponentConfigurationInput {
	s.ComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DescribeComponentConfigurationInput) SetResourceGroupName(v string) *DescribeComponentConfigurationInput {
	s.ResourceGroupName = &v
	return s
}

type DescribeComponentConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration settings of the component. The value is the escaped JSON
	// of the configuration.
	ComponentConfiguration *string `type:"string"`

	// Indicates whether the application component is monitored.
	Monitor *bool `type:"boolean"`

	// The tier of the application component. Supported tiers include DOT_NET_WORKER,
	// DOT_NET_WEB_TIER, SQL_SERVER, and DEFAULT
	Tier *string `type:"string"`
}

// String returns the string representation
func (s DescribeComponentConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentConfigurationOutput) GoString() string {
	return s.String()
}

// SetComponentConfiguration sets the ComponentConfiguration field's value.
func (s *DescribeComponentConfigurationOutput) SetComponentConfiguration(v string) *DescribeComponentConfigurationOutput {
	s.ComponentConfiguration = &v
	return s
}

// SetMonitor sets the Monitor field's value.
func (s *DescribeComponentConfigurationOutput) SetMonitor(v bool) *DescribeComponentConfigurationOutput {
	s.Monitor = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *DescribeComponentConfigurationOutput) SetTier(v string) *DescribeComponentConfigurationOutput {
	s.Tier = &v
	return s
}

type DescribeComponentConfigurationRecommendationInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`

	// The tier of the application component. Supported tiers include DOT_NET_WORKER,
	// DOT_NET_WEB_TIER, SQL_SERVER, and DEFAULT.
	//
	// Tier is a required field
	Tier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeComponentConfigurationRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentConfigurationRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComponentConfigurationRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComponentConfigurationRecommendationInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.Tier == nil {
		invalidParams.Add(request.NewErrParamRequired("Tier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *DescribeComponentConfigurationRecommendationInput) SetComponentName(v string) *DescribeComponentConfigurationRecommendationInput {
	s.ComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DescribeComponentConfigurationRecommendationInput) SetResourceGroupName(v string) *DescribeComponentConfigurationRecommendationInput {
	s.ResourceGroupName = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *DescribeComponentConfigurationRecommendationInput) SetTier(v string) *DescribeComponentConfigurationRecommendationInput {
	s.Tier = &v
	return s
}

type DescribeComponentConfigurationRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// The recommended configuration settings of the component. The value is the
	// escaped JSON of the configuration.
	ComponentConfiguration *string `type:"string"`
}

// String returns the string representation
func (s DescribeComponentConfigurationRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentConfigurationRecommendationOutput) GoString() string {
	return s.String()
}

// SetComponentConfiguration sets the ComponentConfiguration field's value.
func (s *DescribeComponentConfigurationRecommendationOutput) SetComponentConfiguration(v string) *DescribeComponentConfigurationRecommendationOutput {
	s.ComponentConfiguration = &v
	return s
}

type DescribeComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComponentInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *DescribeComponentInput) SetComponentName(v string) *DescribeComponentInput {
	s.ComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DescribeComponentInput) SetResourceGroupName(v string) *DescribeComponentInput {
	s.ResourceGroupName = &v
	return s
}

type DescribeComponentOutput struct {
	_ struct{} `type:"structure"`

	// Describes a standalone resource or similarly grouped resources that the application
	// is made up of.
	ApplicationComponent *ApplicationComponent `type:"structure"`

	// The list of resource ARNs that belong to the component.
	ResourceList []*string `type:"list"`
}

// String returns the string representation
func (s DescribeComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentOutput) GoString() string {
	return s.String()
}

// SetApplicationComponent sets the ApplicationComponent field's value.
func (s *DescribeComponentOutput) SetApplicationComponent(v *ApplicationComponent) *DescribeComponentOutput {
	s.ApplicationComponent = v
	return s
}

// SetResourceList sets the ResourceList field's value.
func (s *DescribeComponentOutput) SetResourceList(v []*string) *DescribeComponentOutput {
	s.ResourceList = v
	return s
}

type DescribeObservationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the observation.
	//
	// ObservationId is a required field
	ObservationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeObservationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeObservationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeObservationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeObservationInput"}
	if s.ObservationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ObservationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObservationId sets the ObservationId field's value.
func (s *DescribeObservationInput) SetObservationId(v string) *DescribeObservationInput {
	s.ObservationId = &v
	return s
}

type DescribeObservationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the observation.
	Observation *Observation `type:"structure"`
}

// String returns the string representation
func (s DescribeObservationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeObservationOutput) GoString() string {
	return s.String()
}

// SetObservation sets the Observation field's value.
func (s *DescribeObservationOutput) SetObservation(v *Observation) *DescribeObservationOutput {
	s.Observation = v
	return s
}

type DescribeProblemInput struct {
	_ struct{} `type:"structure"`

	// The ID of the problem.
	//
	// ProblemId is a required field
	ProblemId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProblemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProblemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProblemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProblemInput"}
	if s.ProblemId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProblemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProblemId sets the ProblemId field's value.
func (s *DescribeProblemInput) SetProblemId(v string) *DescribeProblemInput {
	s.ProblemId = &v
	return s
}

type DescribeProblemObservationsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the problem.
	//
	// ProblemId is a required field
	ProblemId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProblemObservationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProblemObservationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProblemObservationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProblemObservationsInput"}
	if s.ProblemId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProblemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProblemId sets the ProblemId field's value.
func (s *DescribeProblemObservationsInput) SetProblemId(v string) *DescribeProblemObservationsInput {
	s.ProblemId = &v
	return s
}

type DescribeProblemObservationsOutput struct {
	_ struct{} `type:"structure"`

	// Observations related to the problem.
	RelatedObservations *RelatedObservations `type:"structure"`
}

// String returns the string representation
func (s DescribeProblemObservationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProblemObservationsOutput) GoString() string {
	return s.String()
}

// SetRelatedObservations sets the RelatedObservations field's value.
func (s *DescribeProblemObservationsOutput) SetRelatedObservations(v *RelatedObservations) *DescribeProblemObservationsOutput {
	s.RelatedObservations = v
	return s
}

type DescribeProblemOutput struct {
	_ struct{} `type:"structure"`

	// Information about the problem.
	Problem *Problem `type:"structure"`
}

// String returns the string representation
func (s DescribeProblemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProblemOutput) GoString() string {
	return s.String()
}

// SetProblem sets the Problem field's value.
func (s *DescribeProblemOutput) SetProblem(v *Problem) *DescribeProblemOutput {
	s.Problem = v
	return s
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of applications.
	ApplicationInfoList []*ApplicationInfo `type:"list"`

	// The token used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplicationInfoList sets the ApplicationInfoList field's value.
func (s *ListApplicationsOutput) SetApplicationInfoList(v []*ApplicationInfo) *ListApplicationsOutput {
	s.ApplicationInfoList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListComponentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentsInput) SetMaxResults(v int64) *ListComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsInput) SetNextToken(v string) *ListComponentsInput {
	s.NextToken = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ListComponentsInput) SetResourceGroupName(v string) *ListComponentsInput {
	s.ResourceGroupName = &v
	return s
}

type ListComponentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of application components.
	ApplicationComponentList []*ApplicationComponent `type:"list"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComponentsOutput) GoString() string {
	return s.String()
}

// SetApplicationComponentList sets the ApplicationComponentList field's value.
func (s *ListComponentsOutput) SetApplicationComponentList(v []*ApplicationComponent) *ListComponentsOutput {
	s.ApplicationComponentList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsOutput) SetNextToken(v string) *ListComponentsOutput {
	s.NextToken = &v
	return s
}

type ListProblemsInput struct {
	_ struct{} `type:"structure"`

	// The time when the problem ended, in epoch seconds. If not specified, problems
	// within the past seven days are returned.
	EndTime *time.Time `type:"timestamp"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`

	// The name of the resource group.
	ResourceGroupName *string `type:"string"`

	// The time when the problem was detected, in epoch seconds. If you don't specify
	// a time frame for the request, problems within the past seven days are returned.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ListProblemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProblemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProblemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProblemsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListProblemsInput) SetEndTime(v time.Time) *ListProblemsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProblemsInput) SetMaxResults(v int64) *ListProblemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProblemsInput) SetNextToken(v string) *ListProblemsInput {
	s.NextToken = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ListProblemsInput) SetResourceGroupName(v string) *ListProblemsInput {
	s.ResourceGroupName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListProblemsInput) SetStartTime(v time.Time) *ListProblemsInput {
	s.StartTime = &v
	return s
}

type ListProblemsOutput struct {
	_ struct{} `type:"structure"`

	// The token used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `type:"string"`

	// The list of problems.
	ProblemList []*Problem `type:"list"`
}

// String returns the string representation
func (s ListProblemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProblemsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProblemsOutput) SetNextToken(v string) *ListProblemsOutput {
	s.NextToken = &v
	return s
}

// SetProblemList sets the ProblemList field's value.
func (s *ListProblemsOutput) SetProblemList(v []*Problem) *ListProblemsOutput {
	s.ProblemList = v
	return s
}

// Describes an anomaly or error with the application.
type Observation struct {
	_ struct{} `type:"structure"`

	// The time when the observation ended, in epoch seconds.
	EndTime *time.Time `type:"timestamp"`

	// The ID of the observation type.
	Id *string `type:"string"`

	// The timestamp in the CloudWatch Logs that specifies when the matched line
	// occurred.
	LineTime *time.Time `type:"timestamp"`

	// The log filter of the observation.
	LogFilter *string `type:"string" enum:"LogFilter"`

	// The log group name.
	LogGroup *string `type:"string"`

	// The log text of the observation.
	LogText *string `type:"string"`

	// The name of the observation metric.
	MetricName *string `type:"string"`

	// The namespace of the observation metric.
	MetricNamespace *string `type:"string"`

	// The source resource ARN of the observation.
	SourceARN *string `type:"string"`

	// The source type of the observation.
	SourceType *string `type:"string"`

	// The time when the observation was first detected, in epoch seconds.
	StartTime *time.Time `type:"timestamp"`

	// The unit of the source observation metric.
	Unit *string `type:"string"`

	// The value of the source observation metric.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s Observation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Observation) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *Observation) SetEndTime(v time.Time) *Observation {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *Observation) SetId(v string) *Observation {
	s.Id = &v
	return s
}

// SetLineTime sets the LineTime field's value.
func (s *Observation) SetLineTime(v time.Time) *Observation {
	s.LineTime = &v
	return s
}

// SetLogFilter sets the LogFilter field's value.
func (s *Observation) SetLogFilter(v string) *Observation {
	s.LogFilter = &v
	return s
}

// SetLogGroup sets the LogGroup field's value.
func (s *Observation) SetLogGroup(v string) *Observation {
	s.LogGroup = &v
	return s
}

// SetLogText sets the LogText field's value.
func (s *Observation) SetLogText(v string) *Observation {
	s.LogText = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *Observation) SetMetricName(v string) *Observation {
	s.MetricName = &v
	return s
}

// SetMetricNamespace sets the MetricNamespace field's value.
func (s *Observation) SetMetricNamespace(v string) *Observation {
	s.MetricNamespace = &v
	return s
}

// SetSourceARN sets the SourceARN field's value.
func (s *Observation) SetSourceARN(v string) *Observation {
	s.SourceARN = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Observation) SetSourceType(v string) *Observation {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Observation) SetStartTime(v time.Time) *Observation {
	s.StartTime = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Observation) SetUnit(v string) *Observation {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Observation) SetValue(v float64) *Observation {
	s.Value = &v
	return s
}

// Describes a problem that is detected by correlating observations.
type Problem struct {
	_ struct{} `type:"structure"`

	// The resource affected by the problem.
	AffectedResource *string `type:"string"`

	// The time when the problem ended, in epoch seconds.
	EndTime *time.Time `type:"timestamp"`

	// Feedback provided by the user about the problem.
	Feedback map[string]*string `type:"map"`

	// The ID of the problem.
	Id *string `type:"string"`

	// A detailed analysis of the problem using machine learning.
	Insights *string `type:"string"`

	// The name of the resource group affected by the problem.
	ResourceGroupName *string `type:"string"`

	// A measure of the level of impact of the problem.
	SeverityLevel *string `type:"string" enum:"SeverityLevel"`

	// The time when the problem started, in epoch seconds.
	StartTime *time.Time `type:"timestamp"`

	// The status of the problem.
	Status *string `type:"string" enum:"Status"`

	// The name of the problem.
	Title *string `type:"string"`
}

// String returns the string representation
func (s Problem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Problem) GoString() string {
	return s.String()
}

// SetAffectedResource sets the AffectedResource field's value.
func (s *Problem) SetAffectedResource(v string) *Problem {
	s.AffectedResource = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Problem) SetEndTime(v time.Time) *Problem {
	s.EndTime = &v
	return s
}

// SetFeedback sets the Feedback field's value.
func (s *Problem) SetFeedback(v map[string]*string) *Problem {
	s.Feedback = v
	return s
}

// SetId sets the Id field's value.
func (s *Problem) SetId(v string) *Problem {
	s.Id = &v
	return s
}

// SetInsights sets the Insights field's value.
func (s *Problem) SetInsights(v string) *Problem {
	s.Insights = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *Problem) SetResourceGroupName(v string) *Problem {
	s.ResourceGroupName = &v
	return s
}

// SetSeverityLevel sets the SeverityLevel field's value.
func (s *Problem) SetSeverityLevel(v string) *Problem {
	s.SeverityLevel = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Problem) SetStartTime(v time.Time) *Problem {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Problem) SetStatus(v string) *Problem {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Problem) SetTitle(v string) *Problem {
	s.Title = &v
	return s
}

// Describes observations related to the problem.
type RelatedObservations struct {
	_ struct{} `type:"structure"`

	// The list of observations related to the problem.
	ObservationList []*Observation `type:"list"`
}

// String returns the string representation
func (s RelatedObservations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelatedObservations) GoString() string {
	return s.String()
}

// SetObservationList sets the ObservationList field's value.
func (s *RelatedObservations) SetObservationList(v []*Observation) *RelatedObservations {
	s.ObservationList = v
	return s
}

type UpdateComponentConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The configuration settings of the component. The value is the escaped JSON
	// of the configuration. For more information about the JSON format, see Working
	// with JSON (https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html).
	// You can send a request to DescribeComponentConfigurationRecommendation to
	// see the recommended configuration for a component.
	ComponentConfiguration *string `type:"string"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `type:"string" required:"true"`

	// Indicates whether the application component is monitored.
	Monitor *bool `type:"boolean"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`

	// The tier of the application component. Supported tiers include DOT_NET_WORKER,
	// DOT_NET_WEB_TIER, SQL_SERVER, and DEFAULT.
	Tier *string `type:"string"`
}

// String returns the string representation
func (s UpdateComponentConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateComponentConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComponentConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateComponentConfigurationInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentConfiguration sets the ComponentConfiguration field's value.
func (s *UpdateComponentConfigurationInput) SetComponentConfiguration(v string) *UpdateComponentConfigurationInput {
	s.ComponentConfiguration = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *UpdateComponentConfigurationInput) SetComponentName(v string) *UpdateComponentConfigurationInput {
	s.ComponentName = &v
	return s
}

// SetMonitor sets the Monitor field's value.
func (s *UpdateComponentConfigurationInput) SetMonitor(v bool) *UpdateComponentConfigurationInput {
	s.Monitor = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *UpdateComponentConfigurationInput) SetResourceGroupName(v string) *UpdateComponentConfigurationInput {
	s.ResourceGroupName = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *UpdateComponentConfigurationInput) SetTier(v string) *UpdateComponentConfigurationInput {
	s.Tier = &v
	return s
}

type UpdateComponentConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateComponentConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateComponentConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `type:"string" required:"true"`

	// The new name of the component.
	NewComponentName *string `type:"string"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `type:"string" required:"true"`

	// The list of resource ARNs that belong to the component.
	ResourceList []*string `type:"list"`
}

// String returns the string representation
func (s UpdateComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateComponentInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *UpdateComponentInput) SetComponentName(v string) *UpdateComponentInput {
	s.ComponentName = &v
	return s
}

// SetNewComponentName sets the NewComponentName field's value.
func (s *UpdateComponentInput) SetNewComponentName(v string) *UpdateComponentInput {
	s.NewComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *UpdateComponentInput) SetResourceGroupName(v string) *UpdateComponentInput {
	s.ResourceGroupName = &v
	return s
}

// SetResourceList sets the ResourceList field's value.
func (s *UpdateComponentInput) SetResourceList(v []*string) *UpdateComponentInput {
	s.ResourceList = v
	return s
}

type UpdateComponentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateComponentOutput) GoString() string {
	return s.String()
}

const (
	// FeedbackKeyInsightsFeedback is a FeedbackKey enum value
	FeedbackKeyInsightsFeedback = "INSIGHTS_FEEDBACK"
)

const (
	// FeedbackValueNotSpecified is a FeedbackValue enum value
	FeedbackValueNotSpecified = "NOT_SPECIFIED"

	// FeedbackValueUseful is a FeedbackValue enum value
	FeedbackValueUseful = "USEFUL"

	// FeedbackValueNotUseful is a FeedbackValue enum value
	FeedbackValueNotUseful = "NOT_USEFUL"
)

const (
	// LogFilterError is a LogFilter enum value
	LogFilterError = "ERROR"

	// LogFilterWarn is a LogFilter enum value
	LogFilterWarn = "WARN"

	// LogFilterInfo is a LogFilter enum value
	LogFilterInfo = "INFO"
)

const (
	// SeverityLevelLow is a SeverityLevel enum value
	SeverityLevelLow = "LOW"

	// SeverityLevelMedium is a SeverityLevel enum value
	SeverityLevelMedium = "MEDIUM"

	// SeverityLevelHigh is a SeverityLevel enum value
	SeverityLevelHigh = "HIGH"
)

const (
	// StatusIgnore is a Status enum value
	StatusIgnore = "IGNORE"

	// StatusResolved is a Status enum value
	StatusResolved = "RESOLVED"

	// StatusPending is a Status enum value
	StatusPending = "PENDING"
)
