// Code generated by smithy-go-codegen DO NOT EDIT.

package emrserverless

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/emrserverless/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCancelJobRun struct {
}

func (*awsRestjson1_serializeOpCancelJobRun) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelJobRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelJobRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/jobruns/{jobRunId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelJobRunInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelJobRunInput(v *CancelJobRunInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JobRunId == nil || len(*v.JobRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobRunId must not be empty")}
	}
	if v.JobRunId != nil {
		if err := encoder.SetURI("jobRunId").String(*v.JobRunId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateApplication struct {
}

func (*awsRestjson1_serializeOpCreateApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateApplicationInput(v *CreateApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateApplicationInput(v *CreateApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoStartConfiguration != nil {
		ok := object.Key("autoStartConfiguration")
		if err := awsRestjson1_serializeDocumentAutoStartConfig(v.AutoStartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.AutoStopConfiguration != nil {
		ok := object.Key("autoStopConfiguration")
		if err := awsRestjson1_serializeDocumentAutoStopConfig(v.AutoStopConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.InitialCapacity != nil {
		ok := object.Key("initialCapacity")
		if err := awsRestjson1_serializeDocumentInitialCapacityConfigMap(v.InitialCapacity, ok); err != nil {
			return err
		}
	}

	if v.MaximumCapacity != nil {
		ok := object.Key("maximumCapacity")
		if err := awsRestjson1_serializeDocumentMaximumAllowedResources(v.MaximumCapacity, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("networkConfiguration")
		if err := awsRestjson1_serializeDocumentNetworkConfiguration(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ReleaseLabel != nil {
		ok := object.Key("releaseLabel")
		ok.String(*v.ReleaseLabel)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApplication struct {
}

func (*awsRestjson1_serializeOpDeleteApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApplicationInput(v *DeleteApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApplication struct {
}

func (*awsRestjson1_serializeOpGetApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApplicationInput(v *GetApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDashboardForJobRun struct {
}

func (*awsRestjson1_serializeOpGetDashboardForJobRun) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDashboardForJobRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDashboardForJobRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/jobruns/{jobRunId}/dashboard")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDashboardForJobRunInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDashboardForJobRunInput(v *GetDashboardForJobRunInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JobRunId == nil || len(*v.JobRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobRunId must not be empty")}
	}
	if v.JobRunId != nil {
		if err := encoder.SetURI("jobRunId").String(*v.JobRunId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetJobRun struct {
}

func (*awsRestjson1_serializeOpGetJobRun) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetJobRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/jobruns/{jobRunId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetJobRunInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetJobRunInput(v *GetJobRunInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.JobRunId == nil || len(*v.JobRunId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobRunId must not be empty")}
	}
	if v.JobRunId != nil {
		if err := encoder.SetURI("jobRunId").String(*v.JobRunId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListApplications struct {
}

func (*awsRestjson1_serializeOpListApplications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListApplications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApplicationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListApplicationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListApplicationsInput(v *ListApplicationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.States != nil {
		for i := range v.States {
			encoder.AddQuery("states").String(string(v.States[i]))
		}
	}

	return nil
}

type awsRestjson1_serializeOpListJobRuns struct {
}

func (*awsRestjson1_serializeOpListJobRuns) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobRuns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobRunsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/jobruns")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobRunsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobRunsInput(v *ListJobRunsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.CreatedAtAfter != nil {
		encoder.SetQuery("createdAtAfter").String(smithytime.FormatDateTime(*v.CreatedAtAfter))
	}

	if v.CreatedAtBefore != nil {
		encoder.SetQuery("createdAtBefore").String(smithytime.FormatDateTime(*v.CreatedAtBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.States != nil {
		for i := range v.States {
			encoder.AddQuery("states").String(string(v.States[i]))
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartApplication struct {
}

func (*awsRestjson1_serializeOpStartApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/start")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartApplicationInput(v *StartApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartJobRun struct {
}

func (*awsRestjson1_serializeOpStartJobRun) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartJobRun) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartJobRunInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/jobruns")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartJobRunInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartJobRunInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartJobRunInput(v *StartJobRunInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartJobRunInput(v *StartJobRunInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.ConfigurationOverrides != nil {
		ok := object.Key("configurationOverrides")
		if err := awsRestjson1_serializeDocumentConfigurationOverrides(v.ConfigurationOverrides, ok); err != nil {
			return err
		}
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("executionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.ExecutionTimeoutMinutes != nil {
		ok := object.Key("executionTimeoutMinutes")
		ok.Long(*v.ExecutionTimeoutMinutes)
	}

	if v.JobDriver != nil {
		ok := object.Key("jobDriver")
		if err := awsRestjson1_serializeDocumentJobDriver(v.JobDriver, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopApplication struct {
}

func (*awsRestjson1_serializeOpStopApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopApplicationInput(v *StopApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApplication struct {
}

func (*awsRestjson1_serializeOpUpdateApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApplicationInput(v *UpdateApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateApplicationInput(v *UpdateApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoStartConfiguration != nil {
		ok := object.Key("autoStartConfiguration")
		if err := awsRestjson1_serializeDocumentAutoStartConfig(v.AutoStartConfiguration, ok); err != nil {
			return err
		}
	}

	if v.AutoStopConfiguration != nil {
		ok := object.Key("autoStopConfiguration")
		if err := awsRestjson1_serializeDocumentAutoStopConfig(v.AutoStopConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.InitialCapacity != nil {
		ok := object.Key("initialCapacity")
		if err := awsRestjson1_serializeDocumentInitialCapacityConfigMap(v.InitialCapacity, ok); err != nil {
			return err
		}
	}

	if v.MaximumCapacity != nil {
		ok := object.Key("maximumCapacity")
		if err := awsRestjson1_serializeDocumentMaximumAllowedResources(v.MaximumCapacity, ok); err != nil {
			return err
		}
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("networkConfiguration")
		if err := awsRestjson1_serializeDocumentNetworkConfiguration(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutoStartConfig(v *types.AutoStartConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAutoStopConfig(v *types.AutoStopConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.IdleTimeoutMinutes != nil {
		ok := object.Key("idleTimeoutMinutes")
		ok.Integer(*v.IdleTimeoutMinutes)
	}

	return nil
}

func awsRestjson1_serializeDocumentConfiguration(v *types.Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Classification != nil {
		ok := object.Key("classification")
		ok.String(*v.Classification)
	}

	if v.Configurations != nil {
		ok := object.Key("configurations")
		if err := awsRestjson1_serializeDocumentConfigurationList(v.Configurations, ok); err != nil {
			return err
		}
	}

	if v.Properties != nil {
		ok := object.Key("properties")
		if err := awsRestjson1_serializeDocumentSensitivePropertiesMap(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConfigurationList(v []types.Configuration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentConfigurationOverrides(v *types.ConfigurationOverrides, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationConfiguration != nil {
		ok := object.Key("applicationConfiguration")
		if err := awsRestjson1_serializeDocumentConfigurationList(v.ApplicationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MonitoringConfiguration != nil {
		ok := object.Key("monitoringConfiguration")
		if err := awsRestjson1_serializeDocumentMonitoringConfiguration(v.MonitoringConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEntryPointArguments(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentHive(v *types.Hive, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitQueryFile != nil {
		ok := object.Key("initQueryFile")
		ok.String(*v.InitQueryFile)
	}

	if v.Parameters != nil {
		ok := object.Key("parameters")
		ok.String(*v.Parameters)
	}

	if v.Query != nil {
		ok := object.Key("query")
		ok.String(*v.Query)
	}

	return nil
}

func awsRestjson1_serializeDocumentInitialCapacityConfig(v *types.InitialCapacityConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WorkerConfiguration != nil {
		ok := object.Key("workerConfiguration")
		if err := awsRestjson1_serializeDocumentWorkerResourceConfig(v.WorkerConfiguration, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("workerCount")
		ok.Long(v.WorkerCount)
	}

	return nil
}

func awsRestjson1_serializeDocumentInitialCapacityConfigMap(v map[string]types.InitialCapacityConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentInitialCapacityConfig(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentJobDriver(v types.JobDriver, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.JobDriverMemberHive:
		av := object.Key("hive")
		if err := awsRestjson1_serializeDocumentHive(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobDriverMemberSparkSubmit:
		av := object.Key("sparkSubmit")
		if err := awsRestjson1_serializeDocumentSparkSubmit(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentManagedPersistenceMonitoringConfiguration(v *types.ManagedPersistenceMonitoringConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.EncryptionKeyArn != nil {
		ok := object.Key("encryptionKeyArn")
		ok.String(*v.EncryptionKeyArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentMaximumAllowedResources(v *types.MaximumAllowedResources, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cpu != nil {
		ok := object.Key("cpu")
		ok.String(*v.Cpu)
	}

	if v.Disk != nil {
		ok := object.Key("disk")
		ok.String(*v.Disk)
	}

	if v.Memory != nil {
		ok := object.Key("memory")
		ok.String(*v.Memory)
	}

	return nil
}

func awsRestjson1_serializeDocumentMonitoringConfiguration(v *types.MonitoringConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManagedPersistenceMonitoringConfiguration != nil {
		ok := object.Key("managedPersistenceMonitoringConfiguration")
		if err := awsRestjson1_serializeDocumentManagedPersistenceMonitoringConfiguration(v.ManagedPersistenceMonitoringConfiguration, ok); err != nil {
			return err
		}
	}

	if v.S3MonitoringConfiguration != nil {
		ok := object.Key("s3MonitoringConfiguration")
		if err := awsRestjson1_serializeDocumentS3MonitoringConfiguration(v.S3MonitoringConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNetworkConfiguration(v *types.NetworkConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIds(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentS3MonitoringConfiguration(v *types.S3MonitoringConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionKeyArn != nil {
		ok := object.Key("encryptionKeyArn")
		ok.String(*v.EncryptionKeyArn)
	}

	if v.LogUri != nil {
		ok := object.Key("logUri")
		ok.String(*v.LogUri)
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSensitivePropertiesMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentSparkSubmit(v *types.SparkSubmit, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntryPoint != nil {
		ok := object.Key("entryPoint")
		ok.String(*v.EntryPoint)
	}

	if v.EntryPointArguments != nil {
		ok := object.Key("entryPointArguments")
		if err := awsRestjson1_serializeDocumentEntryPointArguments(v.EntryPointArguments, ok); err != nil {
			return err
		}
	}

	if v.SparkSubmitParameters != nil {
		ok := object.Key("sparkSubmitParameters")
		ok.String(*v.SparkSubmitParameters)
	}

	return nil
}

func awsRestjson1_serializeDocumentSubnetIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentWorkerResourceConfig(v *types.WorkerResourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cpu != nil {
		ok := object.Key("cpu")
		ok.String(*v.Cpu)
	}

	if v.Disk != nil {
		ok := object.Key("disk")
		ok.String(*v.Disk)
	}

	if v.Memory != nil {
		ok := object.Key("memory")
		ok.String(*v.Memory)
	}

	return nil
}
