/* consts.c generated by valac 0.16.1, the Vala compiler
 * generated from consts.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <freesmartphone.h>
#include <fsobasics.h>
#include <float.h>
#include <math.h>


#define FSO_GSM_CONSTANTS_TYPE_SIM_FILESYSTEM_ENTRY (fso_gsm_constants_sim_filesystem_entry_get_type ())
typedef struct _FsoGsmConstantsSimFilesystemEntry FsoGsmConstantsSimFilesystemEntry;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FSO_GSM_CONSTANTS_TYPE_SIM_FILESYSTEM_COMMAND (fso_gsm_constants_sim_filesystem_command_get_type ())

#define FSO_GSM_CONSTANTS_TYPE_AT_RESPONSE (fso_gsm_constants_at_response_get_type ())

#define FSO_GSM_PLUS_CMGL_TYPE_MODE (fso_gsm_plus_cmgl_mode_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FSO_GSM_CONSTANTS_TYPE_BEARER_CLASS (fso_gsm_constants_bearer_class_get_type ())

#define FSO_GSM_CONSTANTS_TYPE_CALL_FORWARDING_TYPE (fso_gsm_constants_call_forwarding_type_get_type ())

#define FSO_GSM_CONSTANTS_TYPE_CALL_FORWARDING_MODE (fso_gsm_constants_call_forwarding_mode_get_type ())

#define FSO_GSM_CONSTANTS_TYPE_CALL_FORWARDING_STATUS (fso_gsm_constants_call_forwarding_status_get_type ())

struct _FsoGsmConstantsSimFilesystemEntry {
	gint id;
	gint parent;
	gchar* name;
};

typedef enum  {
	FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_READ_BINARY = 176,
	FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_READ_RECORD = 192,
	FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_UPDATE_BINARY = 214,
	FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_UPDATE_RECORD = 220,
	FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_STATUS = 242
} FsoGsmConstantsSimFilesystemCommand;

typedef enum  {
	FSO_GSM_CONSTANTS_AT_RESPONSE_VALID = 0,
	FSO_GSM_CONSTANTS_AT_RESPONSE_OK = 1,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CONNECT = 2,
	FSO_GSM_CONSTANTS_AT_RESPONSE_UNEXPECTED_LENGTH = 501,
	FSO_GSM_CONSTANTS_AT_RESPONSE_UNABLE_TO_PARSE = 502,
	FSO_GSM_CONSTANTS_AT_RESPONSE_ERROR = 503,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_START = 1000,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_000_PHONE_FAILURE = 1000,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_001_NO_CONNECTION_TO_PHONE = 1001,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_002_PHONE_ADAPTER_LINK_RESERVED = 1002,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_003_OPERATION_NOT_ALLOWED = 1003,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_004_OPERATION_NOT_SUPPORTED = 1004,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_005_PH_SIM_PIN_REQUIRED = 1005,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_006_PH_FSIM_PIN_REQUIRED = 1006,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_007_PH_FSIM_PUK_REQUIRED = 1007,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_010_SIM_NOT_INSERTED = 1010,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_011_SIM_PIN_REQUIRED = 1011,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_012_SIM_PUK_REQUIRED = 1012,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_013_SIM_FAILURE = 1013,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_014_SIM_BUSY = 1014,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_015_SIM_WRONG = 1015,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_016_INCORRECT_PASSWORD = 1016,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_017_SIM_PIN2_REQUIRED = 1017,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_018_SIM_PUK2_REQUIRED = 1018,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_020_MEMORY_FULL = 1020,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_021_INVALID_INDEX = 1021,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_022_NOT_FOUND = 1022,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_023_MEMORY_FAILURE = 1023,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_024_TEXT_STRING_TOO_LONG = 1024,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_025_INVALID_CHARACTERS_IN_TEXT_STRING = 1025,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_026_DIAL_STRING_TOO_LONG = 1026,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_027_INVALID_CHARACTERS_IN_DIAL_STRING = 1027,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_030_NO_NETWORK_SERVICE = 1030,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_031_NETWORK_TIMEOUT = 1031,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_032_NETWORK_NOT_ALLOWED_EMERGENCY_CALLS_ONLY = 1032,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_040_NETWORK_PERSONALIZATION_PIN_REQUIRED = 1040,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_041_NETWORK_PERSONALIZATION_PUK_REQUIRED = 1041,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_042_NETWORK_SUBSET_PERSONALIZATION_PIN_REQUIRED = 1042,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_043_NETWORK_SUBSET_PERSONALIZATION_PUK_REQUIRED = 1043,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_044_SERVICE_PROVIDER_PERSONALIZATION_PIN_REQUIRED = 1044,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_045_SERVICE_PROVIDER_PERSONALIZATION_PUK_REQUIRED = 1045,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_046_CORPORATE_PERSONALIZATION_PIN_REQUIRED = 1046,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_047_CORPORATE_PERSONALIZATION_PUK_REQUIRED = 1047,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_048_PH_SIM_PUK_REQUIRED = 1048,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_100_UNKNOWN_ERROR = 1100,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_103_GPRS_ILLEGAL_MS = 1103,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_106_GPRS_ILLEGAL_ME = 1106,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_107_GPRS_SERVICES_NOT_ALLOWED = 1107,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_111_GPRS_PLMN_NOT_ALLOWED = 1111,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_112_GPRS_LOCATION_AREA_NOT_ALLOWED = 1112,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_113_GPRS_ROAMING_NOT_ALLOWED_IN_THIS_LOCATION_AREA = 1113,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_126_GPRS_OPERATION_TEMPORARY_NOT_ALLOWED = 1126,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_132_GPRS_SERVICE_OPERATION_NOT_SUPPORTED = 1132,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_133_GPRS_REQUESTED_SERVICE_OPTION_NOT_SUBSCRIBED = 1133,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_134_GPRS_SERVICE_OPTION_TEMPORARY_OUT_OF_ORDER = 1134,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_148_GPRS_UNSPECIFIED_ERROR = 1148,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_149_GPRS_PDP_AUTHENTICATION_FAILURE = 1149,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_150_GPRS_INVALID_MOBILE_CLASS = 1150,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_256_OPERATION_TEMPORARILY_NOT_ALLOWED = 1256,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_257_CALL_BARRED = 1257,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_258_PHONE_IS_BUSY = 1258,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_259_USER_ABORT = 1259,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_260_INVALID_DIAL_STRING = 1260,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_261_SS_NOT_EXECUTED = 1261,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_262_SIM_BLOCKED = 1262,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_263_INVALID_BLOCK = 1263,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_265_BUSY_TRY_AGAIN = 1265,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_512_FAILED_TO_ABORT_COMMAND = 1512,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_513_ACM_RESET_NEEDED = 1513,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_514_SIM_APPLICATION_TOOLKIT_BUSY = 1514,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_772_SIM_POWERED_DOWN = 1772,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_START = 2000,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_001_UNASSIGNED_NUMBER = 2001,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_008_OPERATOR_DETERMINED_BARRING = 2008,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_010_CALL_BARED = 2010,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_021_SHORT_MESSAGE_TRANSFER_REJECTED = 2021,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_027_DESTINATION_OUT_OF_SERVICE = 2027,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_028_UNIDENTIFIED_SUBSCRIBER = 2028,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_029_FACILITY_REJECTED = 2029,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_030_UNKNOWN_SUBSCRIBER = 2030,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_038_NETWORK_OUT_OF_ORDER = 2038,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_041_TEMPORARY_FAILURE = 2041,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_042_CONGESTION = 2042,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_047_RECOURCES_UNAVAILABLE = 2047,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_050_REQUESTED_FACILITY_NOT_SUBSCRIBED = 2050,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_069_REQUESTED_FACILITY_NOT_IMPLEMENTED = 2069,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_081_INVALID_SHORT_MESSAGE_TRANSFER_REFERENCE_VALUE = 2081,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_095_INVALID_MESSAGE_UNSPECIFIED = 2095,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_096_INVALID_MANDATORY_INFORMATION = 2096,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_097_MESSAGE_TYPE_NON_EXISTENT_OR_NOT_IMPLEMENTED = 2097,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_098_MESSAGE_NOT_COMPATIBLE_WITH_SHORT_MESSAGE_PROTOCOL = 2098,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_099_INFORMATION_ELEMENT_NON_EXISTENT_OR_NOT_IMPLEMENTED = 2099,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_111_PROTOCOL_ERROR_UNSPECIFIED = 2111,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_127_INTERNETWORKING_UNSPECIFIED = 2127,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_128_TELEMATIC_INTERNETWORKING_NOT_SUPPORTED = 2128,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_129_SHORT_MESSAGE_TYPE_0_NOT_SUPPORTED = 2129,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_130_CANNOT_REPLACE_SHORT_MESSAGE = 2130,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_143_UNSPECIFIED_TP_PID_ERROR = 2143,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_144_DATA_CODE_SCHEME_NOT_SUPPORTED = 2144,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_145_MESSAGE_CLASS_NOT_SUPPORTED = 2145,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_159_UNSPECIFIED_TP_DCS_ERROR = 2159,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_160_COMMAND_CANNOT_BE_ACTIONED = 2160,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_161_COMMAND_UNSUPPORTED = 2161,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_175_UNSPECIFIED_TP_COMMAND_ERROR = 2175,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_176_TPDU_NOT_SUPPORTED = 2176,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_192_SC_BUSY = 2192,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_193_NO_SC_SUBSCRIPTION = 2193,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_194_SC_SYSTEM_FAILURE = 2194,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_195_INVALID_SME_ADDRESS = 2195,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_196_DESTINATION_SME_BARRED = 2196,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_197_SM_REJECTED_DUPLICATE_SM = 2197,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_198_TP_VPF_NOT_SUPPORTED = 2198,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_199_TP_VP_NOT_SUPPORTED = 2199,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_208_D0_SIM_SMS_STORAGE_FULL = 2208,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_209_NO_SMS_STORAGE_CAPABILITY_IN_SIM = 2209,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_210_ERROR_IN_MS = 2210,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_211_MEMORY_CAPACITY_EXCEEDED = 2211,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_212_SIM_APPLICATION_TOOLKIT_BUSY = 2212,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_213_SIM_DATA_DOWNLOAD_ERROR = 2213,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_255_UNSPECIFIED_ERROR_CAUSE = 2255,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_300_ME_FAILURE = 2300,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_301_SMS_SERVICE_OF_ME_RESERVED = 2301,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_302_OPERATION_NOT_ALLOWED = 2302,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_303_OPERATION_NOT_SUPPORTED = 2303,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_304_INVALID_PDU_MODE_PARAMETER = 2304,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_305_INVALID_TEXT_MODE_PARAMETER = 2305,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_310_SIM_NOT_INSERTED = 2310,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_311_SIM_PIN_REQUIRED = 2311,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_312_PH_SIM_PIN_REQUIRED = 2312,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_313_SIM_FAILURE = 2313,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_314_SIM_BUSY = 2314,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_315_SIM_WRONG = 2315,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_316_SIM_PUK_REQUIRED = 2316,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_317_SIM_PIN2_REQUIRED = 2317,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_318_SIM_PUK2_REQUIRED = 2318,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_320_MEMORY_FAILURE = 2320,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_321_INVALID_MEMORY_INDEX = 2321,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_322_MEMORY_FULL = 2322,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_330_SMSC_ADDRESS_UNKNOWN = 2330,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_331_NO_NETWORK_SERVICE = 2331,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_332_NETWORK_TIMEOUT = 2332,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_340_NO_CNMA_EXPECTED = 2340,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_500_UNKNOWN_ERROR = 2500,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_512_FAILED_TO_ABORT_COMMAND = 2512,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_513_ACM_RESET_NEEDED = 2513,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_514_INVALID_STATUS = 2514,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_515_DEVICE_BUSY_OR_INVALID_CHARACTER_IN_STRING = 2515,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_516_INVALID_LENGTH = 2516,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_517_INVALID_CHARACTER_IN_PDU = 2517,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_518_INVALID_PARAMETER = 2518,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_519_INVALID_LENGTH_OR_CHARACTER = 2519,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_520_INVALID_CHARACTER_IN_TEXT = 2520,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_521_TIMER_EXPIRED = 2521,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_522_OPERATION_TEMPORARY_NOT_ALLOWED = 2522,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_532_SIM_NOT_READY = 2532,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_534_CELL_BROADCAST_ERROR_UNKNOWN = 2534,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_535_PROTOCOL_STACK_BUSY = 2535,
	FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_538_INVALID_PARAMETER = 2538,
	FSO_GSM_CONSTANTS_AT_RESPONSE_EXT_ERROR_START = 3000,
	FSO_GSM_CONSTANTS_AT_RESPONSE_EXT_ERROR_0_INVALID_PARAMETERR = 3000
} FsoGsmConstantsAtResponse;

typedef enum  {
	FSO_GSM_PLUS_CMGL_MODE_INVALID = -1,
	FSO_GSM_PLUS_CMGL_MODE_REC_UNREAD = 0,
	FSO_GSM_PLUS_CMGL_MODE_REC_READ = 1,
	FSO_GSM_PLUS_CMGL_MODE_STO_UNSENT = 2,
	FSO_GSM_PLUS_CMGL_MODE_STO_SENT = 3,
	FSO_GSM_PLUS_CMGL_MODE_ALL = 4
} FsoGsmPlusCMGLMode;

typedef enum  {
	FSO_GSM_CONSTANTS_BEARER_CLASS_UNKNOWN = 0,
	FSO_GSM_CONSTANTS_BEARER_CLASS_VOICE = 1,
	FSO_GSM_CONSTANTS_BEARER_CLASS_DATA = 2,
	FSO_GSM_CONSTANTS_BEARER_CLASS_FAX = 4,
	FSO_GSM_CONSTANTS_BEARER_CLASS_DEFAULT = 7,
	FSO_GSM_CONSTANTS_BEARER_CLASS_SMS = 8,
	FSO_GSM_CONSTANTS_BEARER_CLASS_DATA_SYNC = 16,
	FSO_GSM_CONSTANTS_BEARER_CLASS_DATA_ASYNC = 32,
	FSO_GSM_CONSTANTS_BEARER_CLASS_SS_DEFAULT = 61,
	FSO_GSM_CONSTANTS_BEARER_CLASS_PACKET = 64,
	FSO_GSM_CONSTANTS_BEARER_CLASS_PAD = 128
} FsoGsmConstantsBearerClass;

typedef enum  {
	FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_UNCONDITIONAL = 0,
	FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_BUSY = 1,
	FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_NO_REPLY = 2,
	FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_NOT_REACHABLE = 3,
	FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_ALL = 4,
	FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_ALL_CONDITIONAL = 5
} FsoGsmConstantsCallForwardingType;

typedef enum  {
	FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_DISABLE = 0,
	FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_ENABLE = 1,
	FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_QUERY_STATUS = 2,
	FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_REGISTRATION = 3,
	FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_ERASURE = 4
} FsoGsmConstantsCallForwardingMode;

typedef enum  {
	FSO_GSM_CONSTANTS_CALL_FORWARDING_STATUS_NOT_ACTIVE = 0,
	FSO_GSM_CONSTANTS_CALL_FORWARDING_STATUS_ACTIVE = 1
} FsoGsmConstantsCallForwardingStatus;



#define FSO_GSM_CONSTANTS_PHONE_DIGITS "0123456789ABCD*#+pw"
#define FSO_GSM_CONSTANTS_PHONE_DIGITS_RE "[0-9A-D\\*#\\+pw]"
#define FSO_GSM_CONSTANTS_CALL_INDEX_MIN 1
#define FSO_GSM_CONSTANTS_CALL_INDEX_MAX ((guint) 7)
GType fso_gsm_constants_sim_filesystem_entry_get_type (void) G_GNUC_CONST;
FsoGsmConstantsSimFilesystemEntry* fso_gsm_constants_sim_filesystem_entry_dup (const FsoGsmConstantsSimFilesystemEntry* self);
void fso_gsm_constants_sim_filesystem_entry_free (FsoGsmConstantsSimFilesystemEntry* self);
void fso_gsm_constants_sim_filesystem_entry_copy (const FsoGsmConstantsSimFilesystemEntry* self, FsoGsmConstantsSimFilesystemEntry* dest);
void fso_gsm_constants_sim_filesystem_entry_destroy (FsoGsmConstantsSimFilesystemEntry* self);
GType fso_gsm_constants_sim_filesystem_command_get_type (void) G_GNUC_CONST;
GType fso_gsm_constants_at_response_get_type (void) G_GNUC_CONST;
GError* fso_gsm_constants_atResponseCodeToError (FsoGsmConstantsAtResponse code, const gchar* detail);
gchar* fso_gsm_constants_cleanPhoneNumber (const gchar* number);
gchar* fso_gsm_constants_devicePowerStatusToString (gint code);
gchar* fso_gsm_constants_deviceFunctionalityStatusToString (gint code);
gint fso_gsm_constants_deviceFunctionalityStringToStatus (const gchar* level);
gint fso_gsm_constants_simFilesystemEntryNameToCode (const gchar* name);
GType fso_gsm_plus_cmgl_mode_get_type (void) G_GNUC_CONST;
FsoGsmPlusCMGLMode fso_gsm_constants_simMessagebookStringToStatus (const gchar* category);
gchar* fso_gsm_constants_simMessagebookStatusToString (gint code);
gchar* fso_gsm_constants_simPhonebookCodeToString (const gchar* code);
gchar* fso_gsm_constants_simPhonebookStringToCode (const gchar* category);
gchar* fso_gsm_constants_networkProviderStatusToString (gint code);
gchar* fso_gsm_constants_networkProviderActToString (gint code);
gchar* fso_gsm_constants_networkRegistrationModeToString (gint code);
gchar* fso_gsm_constants_networkRegistrationStatusToString (gint code);
gint fso_gsm_constants_networkSignalIndicatorToPercentage (gint sig);
gint fso_gsm_constants_networkSignalToPercentage (gint sig);
gchar* fso_gsm_constants_phonenumberTupleToString (const gchar* number, gint ntype);
gchar* fso_gsm_constants_phonenumberStringToTuple (const gchar* number);
gchar* fso_gsm_constants_phonenumberStringToRealTuple (const gchar* number, guint8* ntype);
guint8 fso_gsm_constants_determinePhoneNumberType (const gchar* number);
FreeSmartphoneGSMSIMAuthStatus fso_gsm_constants_simAuthStatusToEnum (const gchar* status);
gchar* fso_gsm_constants_callStatusToString (gint code);
FreeSmartphoneGSMCallStatus fso_gsm_constants_callStatusToEnum (gint code);
gchar* fso_gsm_constants_callDirectionToString (gint code);
gint fso_gsm_constants_callStringToType (const gchar* ctype);
gchar* fso_gsm_constants_callTypeToString (gint code);
gchar* fso_gsm_constants_ceerCauseToString (gint location, gint reason, gint ssrelease);
gchar* fso_gsm_constants_cssiCodeToString (gint code);
gchar* fso_gsm_constants_cssuCodeToString (gint code);
gint fso_gsm_constants_ctzvToTimeZone (gint ctzv);
GType fso_gsm_constants_bearer_class_get_type (void) G_GNUC_CONST;
GType fso_gsm_constants_call_forwarding_type_get_type (void) G_GNUC_CONST;
GType fso_gsm_constants_call_forwarding_mode_get_type (void) G_GNUC_CONST;
GType fso_gsm_constants_call_forwarding_status_get_type (void) G_GNUC_CONST;

const FsoGsmConstantsSimFilesystemEntry FSO_GSM_CONSTANTS_SimFilesystem[123] = {{0x3F00, 0x0000, "MF"}, {0x2FE2, 0x3F00, "EFiccid"}, {0x2F05, 0x3F00, "EFelp"}, {0x7F10, 0x3F00, "DFtelecom"}, {0x6F3A, 0x7F10, "EFadn"}, {0x6F3B, 0x7F10, "EFfdn"}, {0x6F3C, 0x7F10, "EFsms"}, {0x6F3D, 0x7F10, "EFccp"}, {0x6F40, 0x7F10, "EFmsisdn"}, {0x6F42, 0x7F10, "EFsmsp"}, {0x6F43, 0x7F10, "EFsmss"}, {0x6F44, 0x7F10, "EFlnd"}, {0x6F47, 0x7F10, "EFsmsr"}, {0x6F49, 0x7F10, "EFsdn"}, {0x6F4A, 0x7F10, "EFext1"}, {0x6F4B, 0x7F10, "EFext2"}, {0x6F4C, 0x7F10, "EFext3"}, {0x6F4D, 0x7F10, "EFbdn"}, {0x6F4E, 0x7F10, "EFext4"}, {0x6F4F, 0x7F10, "EFeccp"}, {0x6F58, 0x7F10, "EFcmi"}, {0x5F50, 0x7F10, "DFgraphics"}, {0x4F20, 0x5F50, "EFimg"}, {0x4F01, 0x5F50, "EFimg1"}, {0x4F02, 0x5F50, "EFimg2"}, {0x4F03, 0x5F50, "EFimg3"}, {0x4F04, 0x5F50, "EFimg4"}, {0x4F05, 0x5F50, "EFimg5"}, {0x7F20, 0x3F00, "DFgsm"}, {0x6F05, 0x7F20, "EFlp"}, {0x6F07, 0x7F20, "EFimsi"}, {0x6F20, 0x7F20, "EFkc"}, {0x6F2C, 0x7F20, "EFdck"}, {0x6F30, 0x7F20, "EFplmnsel"}, {0x6F31, 0x7F20, "EFhpplmn"}, {0x6F32, 0x7F20, "EFcnl"}, {0x6F37, 0x7F20, "EFacmmax"}, {0x6F38, 0x7F20, "EFsst"}, {0x6F39, 0x7F20, "EFacm"}, {0x6F3E, 0x7F20, "EFgid1"}, {0x6F3F, 0x7F20, "EFgid2"}, {0x6F41, 0x7F20, "EFpuct"}, {0x6F45, 0x7F20, "EFcbmi"}, {0x6F46, 0x7F20, "EFspn"}, {0x6F48, 0x7F20, "EFcbmid"}, {0x6F50, 0x7F20, "EFcbmir"}, {0x6F51, 0x7F20, "EFnia"}, {0x6F52, 0x7F20, "EFkcgprs"}, {0x6F53, 0x7F20, "EFlocigprs"}, {0x6F54, 0x7F20, "EFsume"}, {0x6F60, 0x7F20, "EFplmnwact"}, {0x6F61, 0x7F20, "EFoplmnwact"}, {0x6F62, 0x7F20, "EFhplmnwact"}, {0x6F63, 0x7F20, "EFcpbcch"}, {0x6F64, 0x7F20, "EFinvscan"}, {0x6F74, 0x7F20, "EFbcch"}, {0x6F78, 0x7F20, "EFacc"}, {0x6F7B, 0x7F20, "EFfplmn"}, {0x6F7E, 0x7F20, "EFloci"}, {0x6FAD, 0x7F20, "EFad"}, {0x6FAE, 0x7F20, "EFphase"}, {0x6FB1, 0x7F20, "EFvgcs"}, {0x6FB2, 0x7F20, "EFvgcss"}, {0x6FB3, 0x7F20, "EFvbs"}, {0x6FB4, 0x7F20, "EFvbss"}, {0x6FB5, 0x7F20, "EFemlpp"}, {0x6FB6, 0x7F20, "EFaaem"}, {0x6FB7, 0x7F20, "EFecc"}, {0x6FC5, 0x7F20, "EFpnn"}, {0x6FC6, 0x7F20, "EFopl"}, {0x6FC7, 0x7F20, "EFmbdn"}, {0x6FC8, 0x7F20, "EFext6"}, {0x6FC9, 0x7F20, "EFmbi"}, {0x6FCA, 0x7F20, "EFmwis"}, {0x6FCB, 0x7F20, "EFcfis"}, {0x6FCC, 0x7F20, "EFext7"}, {0x6FCD, 0x7F20, "EFspdi"}, {0x6FCE, 0x7F20, "EFmmsn"}, {0x6FCF, 0x7F20, "EFext8"}, {0x6FD0, 0x7F20, "EFmmsicp"}, {0x6FD1, 0x7F20, "EFmmsup"}, {0x6FD2, 0x7F20, "EFmmsucp"}, {0x6F17, 0x7F20, "EF_MAILBOX_CPHS"}, {0x6F11, 0x7F20, "EF_VOICE_MAIL_INDICATOR_CPHS"}, {0x6F13, 0x7F20, "EF_CFF_CPHS"}, {0x6f14, 0x7F20, "EF_SPN_CPHS"}, {0x6f18, 0x7F20, "EF_SPN_SHORT_CPHS"}, {0x6f16, 0x7F20, "EF_INFO_CPHS"}, {0x5F30, 0x7F20, "DFiridium"}, {0x5F31, 0x7F20, "DFglobst"}, {0x5F32, 0x7F20, "DFico"}, {0x5F33, 0x7F20, "DFaces"}, {0x5F40, 0x7F20, "DFeia/tia-553"}, {0x4F80, 0x5F40, "EFsid"}, {0x4F81, 0x5F40, "EFgpi"}, {0x4F82, 0x5F40, "EFipc"}, {0x4F83, 0x5F40, "EFcount"}, {0x4F84, 0x5F40, "EFnsid"}, {0x4F85, 0x5F40, "EFpsid"}, {0x4F86, 0x5F40, "EFnetsel"}, {0x4F87, 0x5F40, "EFspl"}, {0x4F88, 0x5F40, "EFmin"}, {0x4F89, 0x5F40, "EFaccolc"}, {0x4F8A, 0x5F40, "EFfc1"}, {0x4F8B, 0x5F40, "EFs-esn"}, {0x4F8C, 0x5F40, "EFcsid"}, {0x4F8D, 0x5F40, "EFreg-thresh"}, {0x4F8E, 0x5F40, "EFccch"}, {0x4F8F, 0x5F40, "EFldcc"}, {0x4F90, 0x5F40, "EFgsm-recon"}, {0x4F91, 0x5F40, "EFamps-2-gsm"}, {0x4F93, 0x5F40, "EFamps-ui"}, {0x5F60, 0x7F20, "DFcts"}, {0x5F70, 0x7F20, "DFsolsa"}, {0x4F30, 0x5F70, "EFsai"}, {0x4F31, 0x5F70, "EFsll"}, {0x5F3C, 0x7F20, "DFmexe"}, {0x4F40, 0x5F3C, "EFmexe-st"}, {0x4F41, 0x5F3C, "EForpk"}, {0x4F42, 0x5F3C, "EFarpk"}, {0x4F43, 0x5F3C, "EFtprpk"}, {0x7F22, 0x3F00, "DFis41"}, {0x7F23, 0x3F00, "DFfp-cts"}};

void fso_gsm_constants_sim_filesystem_entry_copy (const FsoGsmConstantsSimFilesystemEntry* self, FsoGsmConstantsSimFilesystemEntry* dest) {
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).parent;
	(*dest).parent = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
}


void fso_gsm_constants_sim_filesystem_entry_destroy (FsoGsmConstantsSimFilesystemEntry* self) {
	_g_free0 ((*self).name);
}


FsoGsmConstantsSimFilesystemEntry* fso_gsm_constants_sim_filesystem_entry_dup (const FsoGsmConstantsSimFilesystemEntry* self) {
	FsoGsmConstantsSimFilesystemEntry* dup;
	dup = g_new0 (FsoGsmConstantsSimFilesystemEntry, 1);
	fso_gsm_constants_sim_filesystem_entry_copy (self, dup);
	return dup;
}


void fso_gsm_constants_sim_filesystem_entry_free (FsoGsmConstantsSimFilesystemEntry* self) {
	fso_gsm_constants_sim_filesystem_entry_destroy (self);
	g_free (self);
}


GType fso_gsm_constants_sim_filesystem_entry_get_type (void) {
	static volatile gsize fso_gsm_constants_sim_filesystem_entry_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_constants_sim_filesystem_entry_type_id__volatile)) {
		GType fso_gsm_constants_sim_filesystem_entry_type_id;
		fso_gsm_constants_sim_filesystem_entry_type_id = g_boxed_type_register_static ("FsoGsmConstantsSimFilesystemEntry", (GBoxedCopyFunc) fso_gsm_constants_sim_filesystem_entry_dup, (GBoxedFreeFunc) fso_gsm_constants_sim_filesystem_entry_free);
		g_once_init_leave (&fso_gsm_constants_sim_filesystem_entry_type_id__volatile, fso_gsm_constants_sim_filesystem_entry_type_id);
	}
	return fso_gsm_constants_sim_filesystem_entry_type_id__volatile;
}


GType fso_gsm_constants_sim_filesystem_command_get_type (void) {
	static volatile gsize fso_gsm_constants_sim_filesystem_command_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_constants_sim_filesystem_command_type_id__volatile)) {
		static const GEnumValue values[] = {{FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_READ_BINARY, "FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_READ_BINARY", "read-binary"}, {FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_READ_RECORD, "FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_READ_RECORD", "read-record"}, {FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_UPDATE_BINARY, "FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_UPDATE_BINARY", "update-binary"}, {FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_UPDATE_RECORD, "FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_UPDATE_RECORD", "update-record"}, {FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_STATUS, "FSO_GSM_CONSTANTS_SIM_FILESYSTEM_COMMAND_STATUS", "status"}, {0, NULL, NULL}};
		GType fso_gsm_constants_sim_filesystem_command_type_id;
		fso_gsm_constants_sim_filesystem_command_type_id = g_enum_register_static ("FsoGsmConstantsSimFilesystemCommand", values);
		g_once_init_leave (&fso_gsm_constants_sim_filesystem_command_type_id__volatile, fso_gsm_constants_sim_filesystem_command_type_id);
	}
	return fso_gsm_constants_sim_filesystem_command_type_id__volatile;
}


/**
     * At response codes
     **/
GType fso_gsm_constants_at_response_get_type (void) {
	static volatile gsize fso_gsm_constants_at_response_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_constants_at_response_type_id__volatile)) {
		static const GEnumValue values[] = {{FSO_GSM_CONSTANTS_AT_RESPONSE_VALID, "FSO_GSM_CONSTANTS_AT_RESPONSE_VALID", "valid"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_OK, "FSO_GSM_CONSTANTS_AT_RESPONSE_OK", "ok"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CONNECT, "FSO_GSM_CONSTANTS_AT_RESPONSE_CONNECT", "connect"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_UNEXPECTED_LENGTH, "FSO_GSM_CONSTANTS_AT_RESPONSE_UNEXPECTED_LENGTH", "unexpected-length"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_UNABLE_TO_PARSE, "FSO_GSM_CONSTANTS_AT_RESPONSE_UNABLE_TO_PARSE", "unable-to-parse"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_ERROR, "FSO_GSM_CONSTANTS_AT_RESPONSE_ERROR", "error"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_START, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_START", "cme-error-start"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_000_PHONE_FAILURE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_000_PHONE_FAILURE", "cme-error-000-phone-failure"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_001_NO_CONNECTION_TO_PHONE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_001_NO_CONNECTION_TO_PHONE", "cme-error-001-no-connection-to-phone"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_002_PHONE_ADAPTER_LINK_RESERVED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_002_PHONE_ADAPTER_LINK_RESERVED", "cme-error-002-phone-adapter-link-reserved"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_003_OPERATION_NOT_ALLOWED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_003_OPERATION_NOT_ALLOWED", "cme-error-003-operation-not-allowed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_004_OPERATION_NOT_SUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_004_OPERATION_NOT_SUPPORTED", "cme-error-004-operation-not-supported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_005_PH_SIM_PIN_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_005_PH_SIM_PIN_REQUIRED", "cme-error-005-ph-sim-pin-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_006_PH_FSIM_PIN_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_006_PH_FSIM_PIN_REQUIRED", "cme-error-006-ph-fsim-pin-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_007_PH_FSIM_PUK_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_007_PH_FSIM_PUK_REQUIRED", "cme-error-007-ph-fsim-puk-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_010_SIM_NOT_INSERTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_010_SIM_NOT_INSERTED", "cme-error-010-sim-not-inserted"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_011_SIM_PIN_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_011_SIM_PIN_REQUIRED", "cme-error-011-sim-pin-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_012_SIM_PUK_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_012_SIM_PUK_REQUIRED", "cme-error-012-sim-puk-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_013_SIM_FAILURE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_013_SIM_FAILURE", "cme-error-013-sim-failure"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_014_SIM_BUSY, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_014_SIM_BUSY", "cme-error-014-sim-busy"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_015_SIM_WRONG, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_015_SIM_WRONG", "cme-error-015-sim-wrong"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_016_INCORRECT_PASSWORD, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_016_INCORRECT_PASSWORD", "cme-error-016-incorrect-password"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_017_SIM_PIN2_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_017_SIM_PIN2_REQUIRED", "cme-error-017-sim-pin2-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_018_SIM_PUK2_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_018_SIM_PUK2_REQUIRED", "cme-error-018-sim-puk2-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_020_MEMORY_FULL, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_020_MEMORY_FULL", "cme-error-020-memory-full"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_021_INVALID_INDEX, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_021_INVALID_INDEX", "cme-error-021-invalid-index"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_022_NOT_FOUND, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_022_NOT_FOUND", "cme-error-022-not-found"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_023_MEMORY_FAILURE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_023_MEMORY_FAILURE", "cme-error-023-memory-failure"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_024_TEXT_STRING_TOO_LONG, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_024_TEXT_STRING_TOO_LONG", "cme-error-024-text-string-too-long"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_025_INVALID_CHARACTERS_IN_TEXT_STRING, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_025_INVALID_CHARACTERS_IN_TEXT_STRING", "cme-error-025-invalid-characters-in-text-string"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_026_DIAL_STRING_TOO_LONG, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_026_DIAL_STRING_TOO_LONG", "cme-error-026-dial-string-too-long"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_027_INVALID_CHARACTERS_IN_DIAL_STRING, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_027_INVALID_CHARACTERS_IN_DIAL_STRING", "cme-error-027-invalid-characters-in-dial-string"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_030_NO_NETWORK_SERVICE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_030_NO_NETWORK_SERVICE", "cme-error-030-no-network-service"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_031_NETWORK_TIMEOUT, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_031_NETWORK_TIMEOUT", "cme-error-031-network-timeout"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_032_NETWORK_NOT_ALLOWED_EMERGENCY_CALLS_ONLY, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_032_NETWORK_NOT_ALLOWED_EMERGENCY_CALLS_ONLY", "cme-error-032-network-not-allowed-emergency-calls-only"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_040_NETWORK_PERSONALIZATION_PIN_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_040_NETWORK_PERSONALIZATION_PIN_REQUIRED", "cme-error-040-network-personalization-pin-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_041_NETWORK_PERSONALIZATION_PUK_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_041_NETWORK_PERSONALIZATION_PUK_REQUIRED", "cme-error-041-network-personalization-puk-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_042_NETWORK_SUBSET_PERSONALIZATION_PIN_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_042_NETWORK_SUBSET_PERSONALIZATION_PIN_REQUIRED", "cme-error-042-network-subset-personalization-pin-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_043_NETWORK_SUBSET_PERSONALIZATION_PUK_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_043_NETWORK_SUBSET_PERSONALIZATION_PUK_REQUIRED", "cme-error-043-network-subset-personalization-puk-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_044_SERVICE_PROVIDER_PERSONALIZATION_PIN_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_044_SERVICE_PROVIDER_PERSONALIZATION_PIN_REQUIRED", "cme-error-044-service-provider-personalization-pin-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_045_SERVICE_PROVIDER_PERSONALIZATION_PUK_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_045_SERVICE_PROVIDER_PERSONALIZATION_PUK_REQUIRED", "cme-error-045-service-provider-personalization-puk-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_046_CORPORATE_PERSONALIZATION_PIN_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_046_CORPORATE_PERSONALIZATION_PIN_REQUIRED", "cme-error-046-corporate-personalization-pin-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_047_CORPORATE_PERSONALIZATION_PUK_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_047_CORPORATE_PERSONALIZATION_PUK_REQUIRED", "cme-error-047-corporate-personalization-puk-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_048_PH_SIM_PUK_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_048_PH_SIM_PUK_REQUIRED", "cme-error-048-ph-sim-puk-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_100_UNKNOWN_ERROR, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_100_UNKNOWN_ERROR", "cme-error-100-unknown-error"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_103_GPRS_ILLEGAL_MS, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_103_GPRS_ILLEGAL_MS", "cme-error-103-gprs-illegal-ms"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_106_GPRS_ILLEGAL_ME, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_106_GPRS_ILLEGAL_ME", "cme-error-106-gprs-illegal-me"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_107_GPRS_SERVICES_NOT_ALLOWED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_107_GPRS_SERVICES_NOT_ALLOWED", "cme-error-107-gprs-services-not-allowed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_111_GPRS_PLMN_NOT_ALLOWED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_111_GPRS_PLMN_NOT_ALLOWED", "cme-error-111-gprs-plmn-not-allowed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_112_GPRS_LOCATION_AREA_NOT_ALLOWED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_112_GPRS_LOCATION_AREA_NOT_ALLOWED", "cme-error-112-gprs-location-area-not-allowed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_113_GPRS_ROAMING_NOT_ALLOWED_IN_THIS_LOCATION_AREA, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_113_GPRS_ROAMING_NOT_ALLOWED_IN_THIS_LOCATION_AREA", "cme-error-113-gprs-roaming-not-allowed-in-this-location-area"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_126_GPRS_OPERATION_TEMPORARY_NOT_ALLOWED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_126_GPRS_OPERATION_TEMPORARY_NOT_ALLOWED", "cme-error-126-gprs-operation-temporary-not-allowed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_132_GPRS_SERVICE_OPERATION_NOT_SUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_132_GPRS_SERVICE_OPERATION_NOT_SUPPORTED", "cme-error-132-gprs-service-operation-not-supported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_133_GPRS_REQUESTED_SERVICE_OPTION_NOT_SUBSCRIBED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_133_GPRS_REQUESTED_SERVICE_OPTION_NOT_SUBSCRIBED", "cme-error-133-gprs-requested-service-option-not-subscribed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_134_GPRS_SERVICE_OPTION_TEMPORARY_OUT_OF_ORDER, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_134_GPRS_SERVICE_OPTION_TEMPORARY_OUT_OF_ORDER", "cme-error-134-gprs-service-option-temporary-out-of-order"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_148_GPRS_UNSPECIFIED_ERROR, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_148_GPRS_UNSPECIFIED_ERROR", "cme-error-148-gprs-unspecified-error"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_149_GPRS_PDP_AUTHENTICATION_FAILURE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_149_GPRS_PDP_AUTHENTICATION_FAILURE", "cme-error-149-gprs-pdp-authentication-failure"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_150_GPRS_INVALID_MOBILE_CLASS, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_150_GPRS_INVALID_MOBILE_CLASS", "cme-error-150-gprs-invalid-mobile-class"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_256_OPERATION_TEMPORARILY_NOT_ALLOWED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_256_OPERATION_TEMPORARILY_NOT_ALLOWED", "cme-error-256-operation-temporarily-not-allowed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_257_CALL_BARRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_257_CALL_BARRED", "cme-error-257-call-barred"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_258_PHONE_IS_BUSY, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_258_PHONE_IS_BUSY", "cme-error-258-phone-is-busy"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_259_USER_ABORT, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_259_USER_ABORT", "cme-error-259-user-abort"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_260_INVALID_DIAL_STRING, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_260_INVALID_DIAL_STRING", "cme-error-260-invalid-dial-string"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_261_SS_NOT_EXECUTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_261_SS_NOT_EXECUTED", "cme-error-261-ss-not-executed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_262_SIM_BLOCKED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_262_SIM_BLOCKED", "cme-error-262-sim-blocked"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_263_INVALID_BLOCK, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_263_INVALID_BLOCK", "cme-error-263-invalid-block"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_265_BUSY_TRY_AGAIN, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_265_BUSY_TRY_AGAIN", "cme-error-265-busy-try-again"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_512_FAILED_TO_ABORT_COMMAND, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_512_FAILED_TO_ABORT_COMMAND", "cme-error-512-failed-to-abort-command"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_513_ACM_RESET_NEEDED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_513_ACM_RESET_NEEDED", "cme-error-513-acm-reset-needed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_514_SIM_APPLICATION_TOOLKIT_BUSY, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_514_SIM_APPLICATION_TOOLKIT_BUSY", "cme-error-514-sim-application-toolkit-busy"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_772_SIM_POWERED_DOWN, "FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_772_SIM_POWERED_DOWN", "cme-error-772-sim-powered-down"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_START, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_START", "cms-error-start"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_001_UNASSIGNED_NUMBER, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_001_UNASSIGNED_NUMBER", "cms-error-001-unassigned-number"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_008_OPERATOR_DETERMINED_BARRING, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_008_OPERATOR_DETERMINED_BARRING", "cms-error-008-operator-determined-barring"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_010_CALL_BARED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_010_CALL_BARED", "cms-error-010-call-bared"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_021_SHORT_MESSAGE_TRANSFER_REJECTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_021_SHORT_MESSAGE_TRANSFER_REJECTED", "cms-error-021-short-message-transfer-rejected"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_027_DESTINATION_OUT_OF_SERVICE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_027_DESTINATION_OUT_OF_SERVICE", "cms-error-027-destination-out-of-service"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_028_UNIDENTIFIED_SUBSCRIBER, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_028_UNIDENTIFIED_SUBSCRIBER", "cms-error-028-unidentified-subscriber"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_029_FACILITY_REJECTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_029_FACILITY_REJECTED", "cms-error-029-facility-rejected"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_030_UNKNOWN_SUBSCRIBER, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_030_UNKNOWN_SUBSCRIBER", "cms-error-030-unknown-subscriber"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_038_NETWORK_OUT_OF_ORDER, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_038_NETWORK_OUT_OF_ORDER", "cms-error-038-network-out-of-order"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_041_TEMPORARY_FAILURE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_041_TEMPORARY_FAILURE", "cms-error-041-temporary-failure"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_042_CONGESTION, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_042_CONGESTION", "cms-error-042-congestion"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_047_RECOURCES_UNAVAILABLE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_047_RECOURCES_UNAVAILABLE", "cms-error-047-recources-unavailable"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_050_REQUESTED_FACILITY_NOT_SUBSCRIBED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_050_REQUESTED_FACILITY_NOT_SUBSCRIBED", "cms-error-050-requested-facility-not-subscribed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_069_REQUESTED_FACILITY_NOT_IMPLEMENTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_069_REQUESTED_FACILITY_NOT_IMPLEMENTED", "cms-error-069-requested-facility-not-implemented"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_081_INVALID_SHORT_MESSAGE_TRANSFER_REFERENCE_VALUE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_081_INVALID_SHORT_MESSAGE_TRANSFER_REFERENCE_VALUE", "cms-error-081-invalid-short-message-transfer-reference-value"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_095_INVALID_MESSAGE_UNSPECIFIED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_095_INVALID_MESSAGE_UNSPECIFIED", "cms-error-095-invalid-message-unspecified"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_096_INVALID_MANDATORY_INFORMATION, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_096_INVALID_MANDATORY_INFORMATION", "cms-error-096-invalid-mandatory-information"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_097_MESSAGE_TYPE_NON_EXISTENT_OR_NOT_IMPLEMENTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_097_MESSAGE_TYPE_NON_EXISTENT_OR_NOT_IMPLEMENTED", "cms-error-097-message-type-non-existent-or-not-implemented"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_098_MESSAGE_NOT_COMPATIBLE_WITH_SHORT_MESSAGE_PROTOCOL, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_098_MESSAGE_NOT_COMPATIBLE_WITH_SHORT_MESSAGE_PROTOCOL", "cms-error-098-message-not-compatible-with-short-message-protocol"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_099_INFORMATION_ELEMENT_NON_EXISTENT_OR_NOT_IMPLEMENTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_099_INFORMATION_ELEMENT_NON_EXISTENT_OR_NOT_IMPLEMENTED", "cms-error-099-information-element-non-existent-or-not-implemented"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_111_PROTOCOL_ERROR_UNSPECIFIED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_111_PROTOCOL_ERROR_UNSPECIFIED", "cms-error-111-protocol-error-unspecified"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_127_INTERNETWORKING_UNSPECIFIED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_127_INTERNETWORKING_UNSPECIFIED", "cms-error-127-internetworking-unspecified"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_128_TELEMATIC_INTERNETWORKING_NOT_SUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_128_TELEMATIC_INTERNETWORKING_NOT_SUPPORTED", "cms-error-128-telematic-internetworking-not-supported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_129_SHORT_MESSAGE_TYPE_0_NOT_SUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_129_SHORT_MESSAGE_TYPE_0_NOT_SUPPORTED", "cms-error-129-short-message-type-0-not-supported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_130_CANNOT_REPLACE_SHORT_MESSAGE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_130_CANNOT_REPLACE_SHORT_MESSAGE", "cms-error-130-cannot-replace-short-message"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_143_UNSPECIFIED_TP_PID_ERROR, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_143_UNSPECIFIED_TP_PID_ERROR", "cms-error-143-unspecified-tp-pid-error"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_144_DATA_CODE_SCHEME_NOT_SUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_144_DATA_CODE_SCHEME_NOT_SUPPORTED", "cms-error-144-data-code-scheme-not-supported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_145_MESSAGE_CLASS_NOT_SUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_145_MESSAGE_CLASS_NOT_SUPPORTED", "cms-error-145-message-class-not-supported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_159_UNSPECIFIED_TP_DCS_ERROR, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_159_UNSPECIFIED_TP_DCS_ERROR", "cms-error-159-unspecified-tp-dcs-error"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_160_COMMAND_CANNOT_BE_ACTIONED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_160_COMMAND_CANNOT_BE_ACTIONED", "cms-error-160-command-cannot-be-actioned"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_161_COMMAND_UNSUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_161_COMMAND_UNSUPPORTED", "cms-error-161-command-unsupported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_175_UNSPECIFIED_TP_COMMAND_ERROR, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_175_UNSPECIFIED_TP_COMMAND_ERROR", "cms-error-175-unspecified-tp-command-error"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_176_TPDU_NOT_SUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_176_TPDU_NOT_SUPPORTED", "cms-error-176-tpdu-not-supported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_192_SC_BUSY, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_192_SC_BUSY", "cms-error-192-sc-busy"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_193_NO_SC_SUBSCRIPTION, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_193_NO_SC_SUBSCRIPTION", "cms-error-193-no-sc-subscription"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_194_SC_SYSTEM_FAILURE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_194_SC_SYSTEM_FAILURE", "cms-error-194-sc-system-failure"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_195_INVALID_SME_ADDRESS, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_195_INVALID_SME_ADDRESS", "cms-error-195-invalid-sme-address"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_196_DESTINATION_SME_BARRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_196_DESTINATION_SME_BARRED", "cms-error-196-destination-sme-barred"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_197_SM_REJECTED_DUPLICATE_SM, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_197_SM_REJECTED_DUPLICATE_SM", "cms-error-197-sm-rejected-duplicate-sm"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_198_TP_VPF_NOT_SUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_198_TP_VPF_NOT_SUPPORTED", "cms-error-198-tp-vpf-not-supported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_199_TP_VP_NOT_SUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_199_TP_VP_NOT_SUPPORTED", "cms-error-199-tp-vp-not-supported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_208_D0_SIM_SMS_STORAGE_FULL, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_208_D0_SIM_SMS_STORAGE_FULL", "cms-error-208-d0-sim-sms-storage-full"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_209_NO_SMS_STORAGE_CAPABILITY_IN_SIM, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_209_NO_SMS_STORAGE_CAPABILITY_IN_SIM", "cms-error-209-no-sms-storage-capability-in-sim"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_210_ERROR_IN_MS, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_210_ERROR_IN_MS", "cms-error-210-error-in-ms"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_211_MEMORY_CAPACITY_EXCEEDED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_211_MEMORY_CAPACITY_EXCEEDED", "cms-error-211-memory-capacity-exceeded"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_212_SIM_APPLICATION_TOOLKIT_BUSY, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_212_SIM_APPLICATION_TOOLKIT_BUSY", "cms-error-212-sim-application-toolkit-busy"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_213_SIM_DATA_DOWNLOAD_ERROR, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_213_SIM_DATA_DOWNLOAD_ERROR", "cms-error-213-sim-data-download-error"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_255_UNSPECIFIED_ERROR_CAUSE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_255_UNSPECIFIED_ERROR_CAUSE", "cms-error-255-unspecified-error-cause"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_300_ME_FAILURE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_300_ME_FAILURE", "cms-error-300-me-failure"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_301_SMS_SERVICE_OF_ME_RESERVED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_301_SMS_SERVICE_OF_ME_RESERVED", "cms-error-301-sms-service-of-me-reserved"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_302_OPERATION_NOT_ALLOWED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_302_OPERATION_NOT_ALLOWED", "cms-error-302-operation-not-allowed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_303_OPERATION_NOT_SUPPORTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_303_OPERATION_NOT_SUPPORTED", "cms-error-303-operation-not-supported"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_304_INVALID_PDU_MODE_PARAMETER, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_304_INVALID_PDU_MODE_PARAMETER", "cms-error-304-invalid-pdu-mode-parameter"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_305_INVALID_TEXT_MODE_PARAMETER, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_305_INVALID_TEXT_MODE_PARAMETER", "cms-error-305-invalid-text-mode-parameter"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_310_SIM_NOT_INSERTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_310_SIM_NOT_INSERTED", "cms-error-310-sim-not-inserted"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_311_SIM_PIN_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_311_SIM_PIN_REQUIRED", "cms-error-311-sim-pin-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_312_PH_SIM_PIN_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_312_PH_SIM_PIN_REQUIRED", "cms-error-312-ph-sim-pin-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_313_SIM_FAILURE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_313_SIM_FAILURE", "cms-error-313-sim-failure"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_314_SIM_BUSY, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_314_SIM_BUSY", "cms-error-314-sim-busy"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_315_SIM_WRONG, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_315_SIM_WRONG", "cms-error-315-sim-wrong"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_316_SIM_PUK_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_316_SIM_PUK_REQUIRED", "cms-error-316-sim-puk-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_317_SIM_PIN2_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_317_SIM_PIN2_REQUIRED", "cms-error-317-sim-pin2-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_318_SIM_PUK2_REQUIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_318_SIM_PUK2_REQUIRED", "cms-error-318-sim-puk2-required"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_320_MEMORY_FAILURE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_320_MEMORY_FAILURE", "cms-error-320-memory-failure"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_321_INVALID_MEMORY_INDEX, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_321_INVALID_MEMORY_INDEX", "cms-error-321-invalid-memory-index"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_322_MEMORY_FULL, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_322_MEMORY_FULL", "cms-error-322-memory-full"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_330_SMSC_ADDRESS_UNKNOWN, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_330_SMSC_ADDRESS_UNKNOWN", "cms-error-330-smsc-address-unknown"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_331_NO_NETWORK_SERVICE, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_331_NO_NETWORK_SERVICE", "cms-error-331-no-network-service"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_332_NETWORK_TIMEOUT, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_332_NETWORK_TIMEOUT", "cms-error-332-network-timeout"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_340_NO_CNMA_EXPECTED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_340_NO_CNMA_EXPECTED", "cms-error-340-no-cnma-expected"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_500_UNKNOWN_ERROR, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_500_UNKNOWN_ERROR", "cms-error-500-unknown-error"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_512_FAILED_TO_ABORT_COMMAND, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_512_FAILED_TO_ABORT_COMMAND", "cms-error-512-failed-to-abort-command"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_513_ACM_RESET_NEEDED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_513_ACM_RESET_NEEDED", "cms-error-513-acm-reset-needed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_514_INVALID_STATUS, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_514_INVALID_STATUS", "cms-error-514-invalid-status"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_515_DEVICE_BUSY_OR_INVALID_CHARACTER_IN_STRING, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_515_DEVICE_BUSY_OR_INVALID_CHARACTER_IN_STRING", "cms-error-515-device-busy-or-invalid-character-in-string"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_516_INVALID_LENGTH, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_516_INVALID_LENGTH", "cms-error-516-invalid-length"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_517_INVALID_CHARACTER_IN_PDU, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_517_INVALID_CHARACTER_IN_PDU", "cms-error-517-invalid-character-in-pdu"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_518_INVALID_PARAMETER, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_518_INVALID_PARAMETER", "cms-error-518-invalid-parameter"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_519_INVALID_LENGTH_OR_CHARACTER, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_519_INVALID_LENGTH_OR_CHARACTER", "cms-error-519-invalid-length-or-character"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_520_INVALID_CHARACTER_IN_TEXT, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_520_INVALID_CHARACTER_IN_TEXT", "cms-error-520-invalid-character-in-text"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_521_TIMER_EXPIRED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_521_TIMER_EXPIRED", "cms-error-521-timer-expired"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_522_OPERATION_TEMPORARY_NOT_ALLOWED, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_522_OPERATION_TEMPORARY_NOT_ALLOWED", "cms-error-522-operation-temporary-not-allowed"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_532_SIM_NOT_READY, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_532_SIM_NOT_READY", "cms-error-532-sim-not-ready"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_534_CELL_BROADCAST_ERROR_UNKNOWN, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_534_CELL_BROADCAST_ERROR_UNKNOWN", "cms-error-534-cell-broadcast-error-unknown"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_535_PROTOCOL_STACK_BUSY, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_535_PROTOCOL_STACK_BUSY", "cms-error-535-protocol-stack-busy"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_538_INVALID_PARAMETER, "FSO_GSM_CONSTANTS_AT_RESPONSE_CMS_ERROR_538_INVALID_PARAMETER", "cms-error-538-invalid-parameter"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_EXT_ERROR_START, "FSO_GSM_CONSTANTS_AT_RESPONSE_EXT_ERROR_START", "ext-error-start"}, {FSO_GSM_CONSTANTS_AT_RESPONSE_EXT_ERROR_0_INVALID_PARAMETERR, "FSO_GSM_CONSTANTS_AT_RESPONSE_EXT_ERROR_0_INVALID_PARAMETERR", "ext-error-0-invalid-parameterr"}, {0, NULL, NULL}};
		GType fso_gsm_constants_at_response_type_id;
		fso_gsm_constants_at_response_type_id = g_enum_register_static ("FsoGsmConstantsAtResponse", values);
		g_once_init_leave (&fso_gsm_constants_at_response_type_id__volatile, fso_gsm_constants_at_response_type_id);
	}
	return fso_gsm_constants_at_response_type_id__volatile;
}


GError* fso_gsm_constants_atResponseCodeToError (FsoGsmConstantsAtResponse code, const gchar* detail) {
	GError* result = NULL;
	FsoGsmConstantsAtResponse _tmp0_;
	g_return_val_if_fail (detail != NULL, NULL);
	_tmp0_ = code;
	switch (_tmp0_) {
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_010_SIM_NOT_INSERTED:
		{
			const gchar* _tmp1_;
			GError* _tmp2_;
			_tmp1_ = detail;
			_tmp2_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_SIM_NOT_PRESENT, _tmp1_);
			result = _tmp2_;
			return result;
		}
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_005_PH_SIM_PIN_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_006_PH_FSIM_PIN_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_007_PH_FSIM_PUK_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_011_SIM_PIN_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_012_SIM_PUK_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_017_SIM_PIN2_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_018_SIM_PUK2_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_040_NETWORK_PERSONALIZATION_PIN_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_041_NETWORK_PERSONALIZATION_PUK_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_042_NETWORK_SUBSET_PERSONALIZATION_PIN_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_043_NETWORK_SUBSET_PERSONALIZATION_PUK_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_044_SERVICE_PROVIDER_PERSONALIZATION_PIN_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_045_SERVICE_PROVIDER_PERSONALIZATION_PUK_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_046_CORPORATE_PERSONALIZATION_PIN_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_047_CORPORATE_PERSONALIZATION_PUK_REQUIRED:
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_048_PH_SIM_PUK_REQUIRED:
		{
			const gchar* _tmp3_;
			GError* _tmp4_;
			_tmp3_ = detail;
			_tmp4_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_AUTHORIZATION_REQUIRED, _tmp3_);
			result = _tmp4_;
			return result;
		}
		case FSO_GSM_CONSTANTS_AT_RESPONSE_CME_ERROR_021_INVALID_INDEX:
		{
			GError* _tmp5_;
			_tmp5_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_SIM_INVALID_INDEX, "Accessed invalid SIM index");
			result = _tmp5_;
			return result;
		}
		default:
		{
			const gchar* _tmp6_;
			GError* _tmp7_;
			_tmp6_ = detail;
			_tmp7_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_DEVICE_FAILED, _tmp6_);
			result = _tmp7_;
			return result;
		}
	}
}


gchar* fso_gsm_constants_cleanPhoneNumber (const gchar* number) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (number != NULL, NULL);
	_tmp0_ = number;
	_tmp1_ = fso_framework_string_handling_filterByAllowedCharacters (_tmp0_, FSO_GSM_CONSTANTS_PHONE_DIGITS);
	result = _tmp1_;
	return result;
}


gchar* fso_gsm_constants_devicePowerStatusToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("battery");
			result = _tmp1_;
			return result;
		}
		case 1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("ac");
			result = _tmp2_;
			return result;
		}
		case 2:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("usb");
			result = _tmp3_;
			return result;
		}
		case 3:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("failure");
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("unknown");
			result = _tmp5_;
			return result;
		}
	}
}


gchar* fso_gsm_constants_deviceFunctionalityStatusToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("minimal");
			result = _tmp1_;
			return result;
		}
		case 1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("full");
			result = _tmp2_;
			return result;
		}
		case 4:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("airplane");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("unknown");
			result = _tmp4_;
			return result;
		}
	}
}


gint fso_gsm_constants_deviceFunctionalityStringToStatus (const gchar* level) {
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_val_if_fail (level != NULL, 0);
	_tmp0_ = level;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("minimal")))) {
		switch (0) {
			default:
			{
				result = 0;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("full")))) {
		switch (0) {
			default:
			{
				result = 1;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("airplane")))) {
		switch (0) {
			default:
			{
				result = 4;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = -1;
				return result;
			}
		}
	}
}


gint fso_gsm_constants_simFilesystemEntryNameToCode (const gchar* name) {
	gint result = 0;
	const gchar* _tmp5_;
	g_return_val_if_fail (name != NULL, 0);
	{
		FsoGsmConstantsSimFilesystemEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = FSO_GSM_CONSTANTS_SimFilesystem;
		entry_collection_length1 = G_N_ELEMENTS (FSO_GSM_CONSTANTS_SimFilesystem);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (FSO_GSM_CONSTANTS_SimFilesystem); entry_it = entry_it + 1) {
			FsoGsmConstantsSimFilesystemEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				FsoGsmConstantsSimFilesystemEntry _tmp0_;
				const gchar* _tmp1_;
				const gchar* _tmp2_;
				_tmp0_ = entry;
				_tmp1_ = _tmp0_.name;
				_tmp2_ = name;
				if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
					FsoGsmConstantsSimFilesystemEntry _tmp3_;
					gint _tmp4_;
					_tmp3_ = entry;
					_tmp4_ = _tmp3_.id;
					result = _tmp4_;
					return result;
				}
			}
		}
	}
	_tmp5_ = name;
	g_warning ("consts.vala:456: simFilesystemEntryNameToCode: '%s' not found", _tmp5_);
	result = -1;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


FsoGsmPlusCMGLMode fso_gsm_constants_simMessagebookStringToStatus (const gchar* category) {
	FsoGsmPlusCMGLMode result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	g_return_val_if_fail (category != NULL, 0);
	_tmp0_ = category;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("unread")))) {
		switch (0) {
			default:
			{
				result = FSO_GSM_PLUS_CMGL_MODE_REC_UNREAD;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("read")))) {
		switch (0) {
			default:
			{
				result = FSO_GSM_PLUS_CMGL_MODE_REC_READ;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("unsent")))) {
		switch (0) {
			default:
			{
				result = FSO_GSM_PLUS_CMGL_MODE_STO_UNSENT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("sent")))) {
		switch (0) {
			default:
			{
				result = FSO_GSM_PLUS_CMGL_MODE_STO_SENT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("all")))) {
		switch (0) {
			default:
			{
				result = FSO_GSM_PLUS_CMGL_MODE_ALL;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				_tmp4_ = category;
				_tmp5_ = string_to_string (_tmp4_);
				_tmp6_ = g_strconcat ("Unsupported sim messagebook category ", _tmp5_, NULL);
				_tmp7_ = _tmp6_;
				g_warning ("consts.vala:475: %s", _tmp7_);
				_g_free0 (_tmp7_);
				result = FSO_GSM_PLUS_CMGL_MODE_INVALID;
				return result;
			}
		}
	}
}


gchar* fso_gsm_constants_simMessagebookStatusToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case FSO_GSM_PLUS_CMGL_MODE_REC_UNREAD:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("unread");
			result = _tmp1_;
			return result;
		}
		case FSO_GSM_PLUS_CMGL_MODE_REC_READ:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("read");
			result = _tmp2_;
			return result;
		}
		case FSO_GSM_PLUS_CMGL_MODE_STO_UNSENT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("unsent");
			result = _tmp3_;
			return result;
		}
		case FSO_GSM_PLUS_CMGL_MODE_STO_SENT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("sent");
			result = _tmp4_;
			return result;
		}
		default:
		{
			gint _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp5_ = code;
			_tmp6_ = g_strdup_printf ("%i", _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat ("Unsupported sim messagebook code ", _tmp7_, NULL);
			_tmp9_ = _tmp8_;
			g_warning ("consts.vala:493: %s", _tmp9_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp7_);
			_tmp10_ = g_strdup ("unknown");
			result = _tmp10_;
			return result;
		}
	}
}


gchar* fso_gsm_constants_simPhonebookCodeToString (const gchar* code) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	g_return_val_if_fail (code != NULL, NULL);
	_tmp0_ = code;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("LD")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("dialed");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("EN")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("emergency");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("FD")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("fixed");
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("MC")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("missed");
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("ON")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("own");
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("RC")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("received");
				result = _tmp9_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("SM")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("contacts");
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("VM")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("voicebox");
				result = _tmp11_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				_tmp12_ = code;
				_tmp13_ = g_strdup_printf ("aux:%s", _tmp12_);
				result = _tmp13_;
				return result;
			}
		}
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch49_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch49_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally49;
	__catch49_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* fso_gsm_constants_simPhonebookStringToCode (const gchar* category) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = category;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("dialed")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("LD");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("emergency")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("EN");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("fixed")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("FD");
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("missed")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("MC");
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("own")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("ON");
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("received")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("RC");
				result = _tmp9_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("contacts")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("SM");
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("voicebox")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("VM");
				result = _tmp11_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
				_tmp12_ = category;
				_tmp13_ = g_str_has_prefix (_tmp12_, "aux:");
				if (_tmp13_) {
					const gchar* _tmp14_;
					gchar* _tmp15_ = NULL;
					_tmp14_ = category;
					_tmp15_ = string_replace (_tmp14_, "aux:", "");
					result = _tmp15_;
					return result;
				} else {
					gchar* _tmp16_;
					_tmp16_ = g_strdup ("");
					result = _tmp16_;
					return result;
				}
			}
		}
	}
}


gchar* fso_gsm_constants_networkProviderStatusToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 1:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("available");
			result = _tmp1_;
			return result;
		}
		case 2:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("current");
			result = _tmp2_;
			return result;
		}
		case 3:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("forbidden");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("unknown");
			result = _tmp4_;
			return result;
		}
	}
}


gchar* fso_gsm_constants_networkProviderActToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 1:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Compact GSM");
			result = _tmp1_;
			return result;
		}
		case 2:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("UMTS");
			result = _tmp2_;
			return result;
		}
		case 3:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("EDGE");
			result = _tmp3_;
			return result;
		}
		case 4:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("HSDPA");
			result = _tmp4_;
			return result;
		}
		case 5:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("HSUPA");
			result = _tmp5_;
			return result;
		}
		case 6:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("HSDPA/HSUPA");
			result = _tmp6_;
			return result;
		}
		default:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("GSM");
			result = _tmp7_;
			return result;
		}
	}
}


gchar* fso_gsm_constants_networkRegistrationModeToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("automatic");
			result = _tmp1_;
			return result;
		}
		case 1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("manual");
			result = _tmp2_;
			return result;
		}
		case 2:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("unregister");
			result = _tmp3_;
			return result;
		}
		case 4:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("manual;automatic");
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("unknown");
			result = _tmp5_;
			return result;
		}
	}
}


gchar* fso_gsm_constants_networkRegistrationStatusToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("unregistered");
			result = _tmp1_;
			return result;
		}
		case 1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("home");
			result = _tmp2_;
			return result;
		}
		case 2:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("searching");
			result = _tmp3_;
			return result;
		}
		case 3:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("denied");
			result = _tmp4_;
			return result;
		}
		case 5:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("roaming");
			result = _tmp5_;
			return result;
		}
		default:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("unknown");
			result = _tmp6_;
			return result;
		}
	}
}


gint fso_gsm_constants_networkSignalIndicatorToPercentage (gint sig) {
	gint result = 0;
	gint _tmp0_;
	gint _result_;
	gint _tmp1_;
	gint _tmp2_;
	_tmp0_ = sig;
	_result_ = _tmp0_ * 20;
	_tmp1_ = _result_;
	if (_tmp1_ < 0) {
		result = 0;
		return result;
	}
	_tmp2_ = _result_;
	if (_tmp2_ > 100) {
		result = 100;
		return result;
	}
	result = _result_;
	return result;
}


gint fso_gsm_constants_networkSignalToPercentage (gint sig) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_;
	gint _tmp4_;
	gdouble dsig;
	gdouble _tmp5_;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	_tmp1_ = sig;
	if (_tmp1_ <= 0) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_;
		_tmp2_ = sig;
		_tmp0_ = _tmp2_ > 31;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = 0;
		return result;
	}
	_tmp4_ = sig;
	dsig = (gdouble) _tmp4_;
	_tmp5_ = dsig;
	_tmp6_ = log10 (_tmp5_);
	_tmp7_ = log10 (31.0);
	_tmp8_ = round ((_tmp6_ / _tmp7_) * 100);
	result = (gint) _tmp8_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gchar* fso_gsm_constants_phonenumberTupleToString (const gchar* number, gint ntype) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (number != NULL, NULL);
	_tmp0_ = ntype;
	if (_tmp0_ == 145) {
		const gchar* _tmp1_;
		gchar _tmp2_ = '\0';
		_tmp1_ = number;
		_tmp2_ = string_get (_tmp1_, (glong) 0);
		if (_tmp2_ == '+') {
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = number;
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		} else {
			const gchar* _tmp5_;
			gchar* _tmp6_ = NULL;
			_tmp5_ = number;
			_tmp6_ = g_strdup_printf ("+%s", _tmp5_);
			result = _tmp6_;
			return result;
		}
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = number;
		_tmp8_ = g_strdup (_tmp7_);
		result = _tmp8_;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gchar* fso_gsm_constants_phonenumberStringToTuple (const gchar* number) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (number != NULL, NULL);
	_tmp0_ = number;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	if (_tmp1_ == '+') {
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp2_ = number;
		_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) (-1));
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("\"%s\",145", _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		result = _tmp6_;
		return result;
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		_tmp7_ = number;
		_tmp8_ = g_strdup_printf ("\"%s\",129", _tmp7_);
		result = _tmp8_;
		return result;
	}
}


gchar* fso_gsm_constants_phonenumberStringToRealTuple (const gchar* number, guint8* ntype) {
	guint8 _vala_ntype = 0U;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar _tmp1_ = '\0';
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (number != NULL, NULL);
	_tmp0_ = number;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	if (_tmp1_ == '+') {
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		_vala_ntype = (guint8) 145;
		_tmp2_ = number;
		_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) (-1));
		result = _tmp3_;
		if (ntype) {
			*ntype = _vala_ntype;
		}
		return result;
	}
	_vala_ntype = (guint8) 129;
	_tmp4_ = number;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	if (ntype) {
		*ntype = _vala_ntype;
	}
	return result;
}


guint8 fso_gsm_constants_determinePhoneNumberType (const gchar* number) {
	guint8 result = 0U;
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	gchar _tmp2_ = '\0';
	gint _tmp3_;
	g_return_val_if_fail (number != NULL, 0U);
	_tmp1_ = number;
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '+') {
		_tmp0_ = 145;
	} else {
		_tmp0_ = 129;
	}
	_tmp3_ = _tmp0_;
	result = (guint8) _tmp3_;
	return result;
}


FreeSmartphoneGSMSIMAuthStatus fso_gsm_constants_simAuthStatusToEnum (const gchar* status) {
	FreeSmartphoneGSMSIMAuthStatus result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	g_return_val_if_fail (status != NULL, 0);
	_tmp0_ = status;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("READY")))) {
		switch (0) {
			default:
			{
				result = FREE_SMARTPHONE_GSM_SIM_AUTH_STATUS_READY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("SIM PIN")))) {
		switch (0) {
			default:
			{
				result = FREE_SMARTPHONE_GSM_SIM_AUTH_STATUS_PIN_REQUIRED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("SIM PUK")))) {
		switch (0) {
			default:
			{
				result = FREE_SMARTPHONE_GSM_SIM_AUTH_STATUS_PUK_REQUIRED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("SIM PIN2")))) {
		switch (0) {
			default:
			{
				result = FREE_SMARTPHONE_GSM_SIM_AUTH_STATUS_PIN2_REQUIRED;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("SIM PUK2")))) {
		switch (0) {
			default:
			{
				result = FREE_SMARTPHONE_GSM_SIM_AUTH_STATUS_PUK2_REQUIRED;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				_tmp4_ = status;
				g_warning ("consts.vala:714: unknown SIM PIN status %s!!!", _tmp4_);
				result = FREE_SMARTPHONE_GSM_SIM_AUTH_STATUS_UNKNOWN;
				return result;
			}
		}
	}
}


gchar* fso_gsm_constants_callStatusToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("active");
			result = _tmp1_;
			return result;
		}
		case 1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("held");
			result = _tmp2_;
			return result;
		}
		case 2:
		case 3:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("outgoing");
			result = _tmp3_;
			return result;
		}
		case 4:
		case 5:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("incoming");
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("unknown");
			result = _tmp5_;
			return result;
		}
	}
}


FreeSmartphoneGSMCallStatus fso_gsm_constants_callStatusToEnum (gint code) {
	FreeSmartphoneGSMCallStatus result = 0;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 0:
		{
			result = FREE_SMARTPHONE_GSM_CALL_STATUS_ACTIVE;
			return result;
		}
		case 1:
		{
			result = FREE_SMARTPHONE_GSM_CALL_STATUS_HELD;
			return result;
		}
		case 2:
		case 3:
		{
			result = FREE_SMARTPHONE_GSM_CALL_STATUS_OUTGOING;
			return result;
		}
		case 4:
		case 5:
		{
			result = FREE_SMARTPHONE_GSM_CALL_STATUS_INCOMING;
			return result;
		}
		default:
		{
			g_warning ("consts.vala:753: invalid call status!!! setting to RELEASE");
			result = FREE_SMARTPHONE_GSM_CALL_STATUS_RELEASE;
			return result;
		}
	}
}


gchar* fso_gsm_constants_callDirectionToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("outgoing");
			result = _tmp1_;
			return result;
		}
		case 1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("incoming");
			result = _tmp2_;
			return result;
		}
		default:
		{
			gint _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = code;
			g_warning ("consts.vala:767: invalid call status: %d", _tmp3_);
			_tmp4_ = g_strdup ("unknown");
			result = _tmp4_;
			return result;
		}
	}
}


gint fso_gsm_constants_callStringToType (const gchar* ctype) {
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	g_return_val_if_fail (ctype != NULL, 0);
	_tmp0_ = ctype;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("voice")))) {
		switch (0) {
			default:
			{
				result = 0;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("data")))) {
		switch (0) {
			default:
			{
				result = 1;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("fax")))) {
		switch (0) {
			default:
			{
				result = 2;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("voice;data:voice")))) {
		switch (0) {
			default:
			{
				result = 3;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("voice/data:voice")))) {
		switch (0) {
			default:
			{
				result = 4;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("voice/fax:voice")))) {
		switch (0) {
			default:
			{
				result = 5;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("voice;data:data")))) {
		switch (0) {
			default:
			{
				result = 6;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("voice/data:data")))) {
		switch (0) {
			default:
			{
				result = 7;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("voice/fax:fax")))) {
		switch (0) {
			default:
			{
				result = 8;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("unknown")))) {
		switch (0) {
			default:
			{
				result = 9;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				_tmp4_ = ctype;
				g_warning ("consts.vala:796: invalid call type: %s", _tmp4_);
				result = 9;
				return result;
			}
		}
	}
}


gchar* fso_gsm_constants_callTypeToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("voice");
			result = _tmp1_;
			return result;
		}
		case 1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("data");
			result = _tmp2_;
			return result;
		}
		case 2:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("fax");
			result = _tmp3_;
			return result;
		}
		case 3:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("voice;data:voice");
			result = _tmp4_;
			return result;
		}
		case 4:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("voice/dat:voice");
			result = _tmp5_;
			return result;
		}
		case 5:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("voice/fax:voice");
			result = _tmp6_;
			return result;
		}
		case 6:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("voice;data:data");
			result = _tmp7_;
			return result;
		}
		case 7:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("voice/data:data");
			result = _tmp8_;
			return result;
		}
		case 8:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("voice/fax:fax");
			result = _tmp9_;
			return result;
		}
		default:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("unknown");
			result = _tmp10_;
			return result;
		}
	}
}


gchar* fso_gsm_constants_ceerCauseToString (gint location, gint reason, gint ssrelease) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* res;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gboolean _tmp4_;
	gint _tmp16_;
	_tmp0_ = g_strdup ("");
	res = _tmp0_;
	_tmp2_ = location;
	if (_tmp2_ != 8) {
		gint _tmp3_;
		_tmp3_ = location;
		_tmp1_ = _tmp3_ != 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		gint _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp5_ = location;
		_tmp6_ = g_strdup_printf ("%i", _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = reason;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = ssrelease;
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat ("<", _tmp7_, ":", _tmp10_, ":", _tmp13_, ">", NULL);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		result = _tmp15_;
		_g_free0 (res);
		return result;
	}
	_tmp16_ = reason;
	switch (_tmp16_) {
		case 1:
		{
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = res;
			_tmp18_ = g_strconcat (_tmp17_, "unassigned (unallocated) number", NULL);
			_g_free0 (res);
			res = _tmp18_;
			break;
		}
		case 3:
		{
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp19_ = res;
			_tmp20_ = g_strconcat (_tmp19_, "no route to destination", NULL);
			_g_free0 (res);
			res = _tmp20_;
			break;
		}
		case 6:
		{
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp21_ = res;
			_tmp22_ = g_strconcat (_tmp21_, "channel unacceptable", NULL);
			_g_free0 (res);
			res = _tmp22_;
			break;
		}
		case 8:
		{
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp23_ = res;
			_tmp24_ = g_strconcat (_tmp23_, "operator determined barring", NULL);
			_g_free0 (res);
			res = _tmp24_;
			break;
		}
		case 16:
		{
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = res;
			_tmp26_ = g_strconcat (_tmp25_, "normal call clearing", NULL);
			_g_free0 (res);
			res = _tmp26_;
			break;
		}
		case 17:
		{
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp27_ = res;
			_tmp28_ = g_strconcat (_tmp27_, "user busy", NULL);
			_g_free0 (res);
			res = _tmp28_;
			break;
		}
		case 18:
		{
			const gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp29_ = res;
			_tmp30_ = g_strconcat (_tmp29_, "no user responding", NULL);
			_g_free0 (res);
			res = _tmp30_;
			break;
		}
		case 19:
		{
			const gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp31_ = res;
			_tmp32_ = g_strconcat (_tmp31_, "user alerting, no answer", NULL);
			_g_free0 (res);
			res = _tmp32_;
			break;
		}
		case 21:
		{
			const gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp33_ = res;
			_tmp34_ = g_strconcat (_tmp33_, "call rejected", NULL);
			_g_free0 (res);
			res = _tmp34_;
			break;
		}
		case 22:
		{
			const gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp35_ = res;
			_tmp36_ = g_strconcat (_tmp35_, "number changed", NULL);
			_g_free0 (res);
			res = _tmp36_;
			break;
		}
		case 25:
		{
			const gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp37_ = res;
			_tmp38_ = g_strconcat (_tmp37_, "pre-emption", NULL);
			_g_free0 (res);
			res = _tmp38_;
			break;
		}
		case 26:
		{
			const gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp39_ = res;
			_tmp40_ = g_strconcat (_tmp39_, "non-selected user clearing", NULL);
			_g_free0 (res);
			res = _tmp40_;
			break;
		}
		case 27:
		{
			const gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp41_ = res;
			_tmp42_ = g_strconcat (_tmp41_, "destination out of order", NULL);
			_g_free0 (res);
			res = _tmp42_;
			break;
		}
		case 28:
		{
			const gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp43_ = res;
			_tmp44_ = g_strconcat (_tmp43_, "invalid number format (incomplete number)", NULL);
			_g_free0 (res);
			res = _tmp44_;
			break;
		}
		case 29:
		{
			const gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp45_ = res;
			_tmp46_ = g_strconcat (_tmp45_, "facility rejected", NULL);
			_g_free0 (res);
			res = _tmp46_;
			break;
		}
		case 30:
		{
			const gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp47_ = res;
			_tmp48_ = g_strconcat (_tmp47_, "response to STATUS ENQUIRY", NULL);
			_g_free0 (res);
			res = _tmp48_;
			break;
		}
		case 31:
		{
			const gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp49_ = res;
			_tmp50_ = g_strconcat (_tmp49_, "normal, unspecified", NULL);
			_g_free0 (res);
			res = _tmp50_;
			break;
		}
		case 34:
		{
			const gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp51_ = res;
			_tmp52_ = g_strconcat (_tmp51_, "no circuit/channel available", NULL);
			_g_free0 (res);
			res = _tmp52_;
			break;
		}
		case 38:
		{
			const gchar* _tmp53_;
			gchar* _tmp54_;
			_tmp53_ = res;
			_tmp54_ = g_strconcat (_tmp53_, "network out of order", NULL);
			_g_free0 (res);
			res = _tmp54_;
			break;
		}
		case 41:
		{
			const gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp55_ = res;
			_tmp56_ = g_strconcat (_tmp55_, "temporary failure", NULL);
			_g_free0 (res);
			res = _tmp56_;
			break;
		}
		case 42:
		{
			const gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp57_ = res;
			_tmp58_ = g_strconcat (_tmp57_, "switching equipment congestion", NULL);
			_g_free0 (res);
			res = _tmp58_;
			break;
		}
		case 43:
		{
			const gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp59_ = res;
			_tmp60_ = g_strconcat (_tmp59_, "access information discarded", NULL);
			_g_free0 (res);
			res = _tmp60_;
			break;
		}
		case 44:
		{
			const gchar* _tmp61_;
			gchar* _tmp62_;
			_tmp61_ = res;
			_tmp62_ = g_strconcat (_tmp61_, "requested circuit/channel not available", NULL);
			_g_free0 (res);
			res = _tmp62_;
			break;
		}
		case 47:
		{
			const gchar* _tmp63_;
			gchar* _tmp64_;
			_tmp63_ = res;
			_tmp64_ = g_strconcat (_tmp63_, "resource unavailable, unspecified", NULL);
			_g_free0 (res);
			res = _tmp64_;
			break;
		}
		case 49:
		{
			const gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp65_ = res;
			_tmp66_ = g_strconcat (_tmp65_, "quality of service unavailable", NULL);
			_g_free0 (res);
			res = _tmp66_;
			break;
		}
		case 50:
		{
			const gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp67_ = res;
			_tmp68_ = g_strconcat (_tmp67_, "requested facility not subscribed", NULL);
			_g_free0 (res);
			res = _tmp68_;
			break;
		}
		case 55:
		{
			const gchar* _tmp69_;
			gchar* _tmp70_;
			_tmp69_ = res;
			_tmp70_ = g_strconcat (_tmp69_, "incoming calls barred within the CUG", NULL);
			_g_free0 (res);
			res = _tmp70_;
			break;
		}
		case 57:
		{
			const gchar* _tmp71_;
			gchar* _tmp72_;
			_tmp71_ = res;
			_tmp72_ = g_strconcat (_tmp71_, "bearer capability not authorized", NULL);
			_g_free0 (res);
			res = _tmp72_;
			break;
		}
		case 58:
		{
			const gchar* _tmp73_;
			gchar* _tmp74_;
			_tmp73_ = res;
			_tmp74_ = g_strconcat (_tmp73_, "bearer capability not presently available", NULL);
			_g_free0 (res);
			res = _tmp74_;
			break;
		}
		case 63:
		{
			const gchar* _tmp75_;
			gchar* _tmp76_;
			_tmp75_ = res;
			_tmp76_ = g_strconcat (_tmp75_, "service or option not available, unspecified", NULL);
			_g_free0 (res);
			res = _tmp76_;
			break;
		}
		case 65:
		{
			const gchar* _tmp77_;
			gchar* _tmp78_;
			_tmp77_ = res;
			_tmp78_ = g_strconcat (_tmp77_, "bearer service not implemented", NULL);
			_g_free0 (res);
			res = _tmp78_;
			break;
		}
		case 68:
		{
			const gchar* _tmp79_;
			gchar* _tmp80_;
			_tmp79_ = res;
			_tmp80_ = g_strconcat (_tmp79_, "ACM equal or greater than ACM max", NULL);
			_g_free0 (res);
			res = _tmp80_;
			break;
		}
		case 69:
		{
			const gchar* _tmp81_;
			gchar* _tmp82_;
			_tmp81_ = res;
			_tmp82_ = g_strconcat (_tmp81_, "requested facility not implemented", NULL);
			_g_free0 (res);
			res = _tmp82_;
			break;
		}
		case 70:
		{
			const gchar* _tmp83_;
			gchar* _tmp84_;
			_tmp83_ = res;
			_tmp84_ = g_strconcat (_tmp83_, "only restricted digital information bearer capability is available", NULL);
			_g_free0 (res);
			res = _tmp84_;
			break;
		}
		case 79:
		{
			const gchar* _tmp85_;
			gchar* _tmp86_;
			_tmp85_ = res;
			_tmp86_ = g_strconcat (_tmp85_, "service or option not implemented, unspecified", NULL);
			_g_free0 (res);
			res = _tmp86_;
			break;
		}
		default:
		{
			const gchar* _tmp87_;
			gchar* _tmp88_;
			_tmp87_ = res;
			_tmp88_ = g_strconcat (_tmp87_, "<unknown GSM release cause for L3 Call Control (CC)>", NULL);
			_g_free0 (res);
			res = _tmp88_;
			break;
		}
	}
	result = res;
	return result;
}


gchar* fso_gsm_constants_cssiCodeToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("unconditional-forwardings-active");
			result = _tmp1_;
			return result;
		}
		case 1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("conditional-forwardings-active");
			result = _tmp2_;
			return result;
		}
		case 2:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("forwarded");
			result = _tmp3_;
			return result;
		}
		case 3:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("waiting-call-pending");
			result = _tmp4_;
			return result;
		}
		default:
		{
			gint _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp5_ = code;
			_tmp6_ = g_strdup_printf ("%i", _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat ("<unknown:cssi:", _tmp7_, ">", NULL);
			_tmp9_ = _tmp8_;
			_g_free0 (_tmp7_);
			result = _tmp9_;
			return result;
		}
	}
}


gchar* fso_gsm_constants_cssuCodeToString (gint code) {
	gchar* result = NULL;
	gint _tmp0_;
	_tmp0_ = code;
	switch (_tmp0_) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("forwarded");
			result = _tmp1_;
			return result;
		}
		case 5:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("held-terminated");
			result = _tmp2_;
			return result;
		}
		case 10:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("additional-call-forwarded");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gint _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp4_ = code;
			_tmp5_ = g_strdup_printf ("%i", _tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strconcat ("<unknown:cssu:", _tmp6_, ">", NULL);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			result = _tmp8_;
			return result;
		}
	}
}


/**
     * Compute the timezone offset out of a value from +CTZV
     * 35 (observed in Taipei, UTC+7)
     * 105 (observed in UTC-4)
     *
     * Excerpt from IRC:
     * <DieterS> Lets try again: 0x19 -> swap the BCD digits: 0x91, high bit is minus -> -11 this is -2:45
     * <wpwrak> dieter: i think if you try enough variations, you can produce any number ;-)
     * <DieterS> Now the same for a real world example: 105  = 0x69 swap 0x96, high bit set, minus 16, this minus 4 hours
     * <DieterS> Werner: Sure, but one can also read the GSM spec ;-)
     * <wpwrak> dieter: that's cheating :)
     * <DieterS> Start with 04.08, check 03.40 and look at 02.42
     * <DieterS> So it's is really simple ;-)
     **/
gint fso_gsm_constants_ctzvToTimeZone (gint ctzv) {
	gint result = 0;
	gint _tmp0_;
	gint bcd1;
	gint _tmp1_;
	gint bcd2;
	gint _tmp2_;
	gint _tmp3_;
	gint zone;
	gint _tmp4_;
	gboolean sign;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gint _tmp9_;
	_tmp0_ = ctzv;
	bcd1 = _tmp0_ / 0x10;
	_tmp1_ = ctzv;
	bcd2 = (_tmp1_ % 0x10) & 0x7;
	_tmp2_ = bcd2;
	_tmp3_ = bcd1;
	zone = (_tmp2_ * 10) + _tmp3_;
	_tmp4_ = ctzv;
	sign = (_tmp4_ & 0x08) == 8;
	_tmp6_ = sign;
	if (_tmp6_) {
		gint _tmp7_;
		_tmp7_ = zone;
		_tmp5_ = (-_tmp7_) * 15;
	} else {
		gint _tmp8_;
		_tmp8_ = zone;
		_tmp5_ = _tmp8_ * 15;
	}
	_tmp9_ = _tmp5_;
	result = _tmp9_;
	return result;
}


GType fso_gsm_constants_bearer_class_get_type (void) {
	static volatile gsize fso_gsm_constants_bearer_class_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_constants_bearer_class_type_id__volatile)) {
		static const GEnumValue values[] = {{FSO_GSM_CONSTANTS_BEARER_CLASS_UNKNOWN, "FSO_GSM_CONSTANTS_BEARER_CLASS_UNKNOWN", "unknown"}, {FSO_GSM_CONSTANTS_BEARER_CLASS_VOICE, "FSO_GSM_CONSTANTS_BEARER_CLASS_VOICE", "voice"}, {FSO_GSM_CONSTANTS_BEARER_CLASS_DATA, "FSO_GSM_CONSTANTS_BEARER_CLASS_DATA", "data"}, {FSO_GSM_CONSTANTS_BEARER_CLASS_FAX, "FSO_GSM_CONSTANTS_BEARER_CLASS_FAX", "fax"}, {FSO_GSM_CONSTANTS_BEARER_CLASS_DEFAULT, "FSO_GSM_CONSTANTS_BEARER_CLASS_DEFAULT", "default"}, {FSO_GSM_CONSTANTS_BEARER_CLASS_SMS, "FSO_GSM_CONSTANTS_BEARER_CLASS_SMS", "sms"}, {FSO_GSM_CONSTANTS_BEARER_CLASS_DATA_SYNC, "FSO_GSM_CONSTANTS_BEARER_CLASS_DATA_SYNC", "data-sync"}, {FSO_GSM_CONSTANTS_BEARER_CLASS_DATA_ASYNC, "FSO_GSM_CONSTANTS_BEARER_CLASS_DATA_ASYNC", "data-async"}, {FSO_GSM_CONSTANTS_BEARER_CLASS_SS_DEFAULT, "FSO_GSM_CONSTANTS_BEARER_CLASS_SS_DEFAULT", "ss-default"}, {FSO_GSM_CONSTANTS_BEARER_CLASS_PACKET, "FSO_GSM_CONSTANTS_BEARER_CLASS_PACKET", "packet"}, {FSO_GSM_CONSTANTS_BEARER_CLASS_PAD, "FSO_GSM_CONSTANTS_BEARER_CLASS_PAD", "pad"}, {0, NULL, NULL}};
		GType fso_gsm_constants_bearer_class_type_id;
		fso_gsm_constants_bearer_class_type_id = g_enum_register_static ("FsoGsmConstantsBearerClass", values);
		g_once_init_leave (&fso_gsm_constants_bearer_class_type_id__volatile, fso_gsm_constants_bearer_class_type_id);
	}
	return fso_gsm_constants_bearer_class_type_id__volatile;
}


GType fso_gsm_constants_call_forwarding_type_get_type (void) {
	static volatile gsize fso_gsm_constants_call_forwarding_type_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_constants_call_forwarding_type_type_id__volatile)) {
		static const GEnumValue values[] = {{FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_UNCONDITIONAL, "FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_UNCONDITIONAL", "unconditional"}, {FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_BUSY, "FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_BUSY", "busy"}, {FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_NO_REPLY, "FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_NO_REPLY", "no-reply"}, {FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_NOT_REACHABLE, "FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_NOT_REACHABLE", "not-reachable"}, {FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_ALL, "FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_ALL", "all"}, {FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_ALL_CONDITIONAL, "FSO_GSM_CONSTANTS_CALL_FORWARDING_TYPE_ALL_CONDITIONAL", "all-conditional"}, {0, NULL, NULL}};
		GType fso_gsm_constants_call_forwarding_type_type_id;
		fso_gsm_constants_call_forwarding_type_type_id = g_enum_register_static ("FsoGsmConstantsCallForwardingType", values);
		g_once_init_leave (&fso_gsm_constants_call_forwarding_type_type_id__volatile, fso_gsm_constants_call_forwarding_type_type_id);
	}
	return fso_gsm_constants_call_forwarding_type_type_id__volatile;
}


GType fso_gsm_constants_call_forwarding_mode_get_type (void) {
	static volatile gsize fso_gsm_constants_call_forwarding_mode_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_constants_call_forwarding_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_DISABLE, "FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_DISABLE", "disable"}, {FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_ENABLE, "FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_ENABLE", "enable"}, {FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_QUERY_STATUS, "FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_QUERY_STATUS", "query-status"}, {FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_REGISTRATION, "FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_REGISTRATION", "registration"}, {FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_ERASURE, "FSO_GSM_CONSTANTS_CALL_FORWARDING_MODE_ERASURE", "erasure"}, {0, NULL, NULL}};
		GType fso_gsm_constants_call_forwarding_mode_type_id;
		fso_gsm_constants_call_forwarding_mode_type_id = g_enum_register_static ("FsoGsmConstantsCallForwardingMode", values);
		g_once_init_leave (&fso_gsm_constants_call_forwarding_mode_type_id__volatile, fso_gsm_constants_call_forwarding_mode_type_id);
	}
	return fso_gsm_constants_call_forwarding_mode_type_id__volatile;
}


GType fso_gsm_constants_call_forwarding_status_get_type (void) {
	static volatile gsize fso_gsm_constants_call_forwarding_status_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_constants_call_forwarding_status_type_id__volatile)) {
		static const GEnumValue values[] = {{FSO_GSM_CONSTANTS_CALL_FORWARDING_STATUS_NOT_ACTIVE, "FSO_GSM_CONSTANTS_CALL_FORWARDING_STATUS_NOT_ACTIVE", "not-active"}, {FSO_GSM_CONSTANTS_CALL_FORWARDING_STATUS_ACTIVE, "FSO_GSM_CONSTANTS_CALL_FORWARDING_STATUS_ACTIVE", "active"}, {0, NULL, NULL}};
		GType fso_gsm_constants_call_forwarding_status_type_id;
		fso_gsm_constants_call_forwarding_status_type_id = g_enum_register_static ("FsoGsmConstantsCallForwardingStatus", values);
		g_once_init_leave (&fso_gsm_constants_call_forwarding_status_type_id__volatile, fso_gsm_constants_call_forwarding_status_type_id);
	}
	return fso_gsm_constants_call_forwarding_status_type_id__volatile;
}



