/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/reporting/TypeMismatch.hpp"

namespace ast {

TypeMismatch::TypeMismatch(
	const AstNode &ambigousNode,
	std::list<const TypeDeclaration*> possibleTypes,
	std::string msg) :	AmbiguousTypes(ambigousNode,
						possibleTypes,
						msg)
{
}

void
TypeMismatch::put(std::ostream &stream) const 
{
	stream << this->location << ": "
		<< " Type mismatch ("
		<< this->message << ")" 
		<< std::endl;

	stream << "\tPossible types would be: " << std::endl;
		

	for (std::list< std::pair<std::string, Location> >::const_iterator i =
		this->typeNames.begin();
		i != this->typeNames.end(); i++) {

		stream << "\t\t" << (*i).first << " (defined at: "
			<< (*i).second << ")" << std::endl;
	}
}

}; /* namespace ast */
