// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file rpc_types.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_RPC_RPC_TYPES_HPP
#define FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_RPC_RPC_TYPES_HPP

#include <array>
#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(RPC_TYPES_SOURCE)
#define RPC_TYPES_DllAPI __declspec( dllexport )
#else
#define RPC_TYPES_DllAPI __declspec( dllimport )
#endif // RPC_TYPES_SOURCE
#else
#define RPC_TYPES_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define RPC_TYPES_DllAPI
#endif // _WIN32

namespace eprosima {

namespace fastdds {

namespace dds {


typedef std::array<uint8_t, 12> GuidPrefix_t;

/*!
 * @brief This class represents the structure EntityId_t defined by the user in the IDL file.
 * @ingroup rpc_types
 */
class EntityId_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport EntityId_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~EntityId_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object EntityId_t that will be copied.
     */
    eProsima_user_DllExport EntityId_t(
            const EntityId_t& x)
    {
                    m_entityKey = x.m_entityKey;

                    m_entityKind = x.m_entityKind;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object EntityId_t that will be copied.
     */
    eProsima_user_DllExport EntityId_t(
            EntityId_t&& x) noexcept
    {
        m_entityKey = std::move(x.m_entityKey);
        m_entityKind = x.m_entityKind;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object EntityId_t that will be copied.
     */
    eProsima_user_DllExport EntityId_t& operator =(
            const EntityId_t& x)
    {

                    m_entityKey = x.m_entityKey;

                    m_entityKind = x.m_entityKind;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object EntityId_t that will be copied.
     */
    eProsima_user_DllExport EntityId_t& operator =(
            EntityId_t&& x) noexcept
    {

        m_entityKey = std::move(x.m_entityKey);
        m_entityKind = x.m_entityKind;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityId_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const EntityId_t& x) const
    {
        return (m_entityKey == x.m_entityKey &&
           m_entityKind == x.m_entityKind);
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityId_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const EntityId_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member entityKey
     * @param _entityKey New value to be copied in member entityKey
     */
    eProsima_user_DllExport void entityKey(
            const std::array<uint8_t, 3>& _entityKey)
    {
        m_entityKey = _entityKey;
    }

    /*!
     * @brief This function moves the value in member entityKey
     * @param _entityKey New value to be moved in member entityKey
     */
    eProsima_user_DllExport void entityKey(
            std::array<uint8_t, 3>&& _entityKey)
    {
        m_entityKey = std::move(_entityKey);
    }

    /*!
     * @brief This function returns a constant reference to member entityKey
     * @return Constant reference to member entityKey
     */
    eProsima_user_DllExport const std::array<uint8_t, 3>& entityKey() const
    {
        return m_entityKey;
    }

    /*!
     * @brief This function returns a reference to member entityKey
     * @return Reference to member entityKey
     */
    eProsima_user_DllExport std::array<uint8_t, 3>& entityKey()
    {
        return m_entityKey;
    }


    /*!
     * @brief This function sets a value in member entityKind
     * @param _entityKind New value for member entityKind
     */
    eProsima_user_DllExport void entityKind(
            uint8_t _entityKind)
    {
        m_entityKind = _entityKind;
    }

    /*!
     * @brief This function returns the value of member entityKind
     * @return Value of member entityKind
     */
    eProsima_user_DllExport uint8_t entityKind() const
    {
        return m_entityKind;
    }

    /*!
     * @brief This function returns a reference to member entityKind
     * @return Reference to member entityKind
     */
    eProsima_user_DllExport uint8_t& entityKind()
    {
        return m_entityKind;
    }



private:

    std::array<uint8_t, 3> m_entityKey{0};
    uint8_t m_entityKind{0};

};
/*!
 * @brief This class represents the structure GUID_t defined by the user in the IDL file.
 * @ingroup rpc_types
 */
class GUID_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport GUID_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~GUID_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object GUID_t that will be copied.
     */
    eProsima_user_DllExport GUID_t(
            const GUID_t& x)
    {
                    m_guidPrefix = x.m_guidPrefix;

                    m_entityId = x.m_entityId;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object GUID_t that will be copied.
     */
    eProsima_user_DllExport GUID_t(
            GUID_t&& x) noexcept
    {
        m_guidPrefix = std::move(x.m_guidPrefix);
        m_entityId = std::move(x.m_entityId);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object GUID_t that will be copied.
     */
    eProsima_user_DllExport GUID_t& operator =(
            const GUID_t& x)
    {

                    m_guidPrefix = x.m_guidPrefix;

                    m_entityId = x.m_entityId;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object GUID_t that will be copied.
     */
    eProsima_user_DllExport GUID_t& operator =(
            GUID_t&& x) noexcept
    {

        m_guidPrefix = std::move(x.m_guidPrefix);
        m_entityId = std::move(x.m_entityId);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x GUID_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const GUID_t& x) const
    {
        return (m_guidPrefix == x.m_guidPrefix &&
           m_entityId == x.m_entityId);
    }

    /*!
     * @brief Comparison operator.
     * @param x GUID_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const GUID_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member guidPrefix
     * @param _guidPrefix New value to be copied in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            const GuidPrefix_t& _guidPrefix)
    {
        m_guidPrefix = _guidPrefix;
    }

    /*!
     * @brief This function moves the value in member guidPrefix
     * @param _guidPrefix New value to be moved in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            GuidPrefix_t&& _guidPrefix)
    {
        m_guidPrefix = std::move(_guidPrefix);
    }

    /*!
     * @brief This function returns a constant reference to member guidPrefix
     * @return Constant reference to member guidPrefix
     */
    eProsima_user_DllExport const GuidPrefix_t& guidPrefix() const
    {
        return m_guidPrefix;
    }

    /*!
     * @brief This function returns a reference to member guidPrefix
     * @return Reference to member guidPrefix
     */
    eProsima_user_DllExport GuidPrefix_t& guidPrefix()
    {
        return m_guidPrefix;
    }


    /*!
     * @brief This function copies the value in member entityId
     * @param _entityId New value to be copied in member entityId
     */
    eProsima_user_DllExport void entityId(
            const EntityId_t& _entityId)
    {
        m_entityId = _entityId;
    }

    /*!
     * @brief This function moves the value in member entityId
     * @param _entityId New value to be moved in member entityId
     */
    eProsima_user_DllExport void entityId(
            EntityId_t&& _entityId)
    {
        m_entityId = std::move(_entityId);
    }

    /*!
     * @brief This function returns a constant reference to member entityId
     * @return Constant reference to member entityId
     */
    eProsima_user_DllExport const EntityId_t& entityId() const
    {
        return m_entityId;
    }

    /*!
     * @brief This function returns a reference to member entityId
     * @return Reference to member entityId
     */
    eProsima_user_DllExport EntityId_t& entityId()
    {
        return m_entityId;
    }



private:

    GuidPrefix_t m_guidPrefix{0};
    EntityId_t m_entityId;

};
/*!
 * @brief This class represents the structure SequenceNumber_t defined by the user in the IDL file.
 * @ingroup rpc_types
 */
class SequenceNumber_t
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceNumber_t()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceNumber_t()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceNumber_t that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_t(
            const SequenceNumber_t& x)
    {
                    m_high = x.m_high;

                    m_low = x.m_low;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceNumber_t that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_t(
            SequenceNumber_t&& x) noexcept
    {
        m_high = x.m_high;
        m_low = x.m_low;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceNumber_t that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_t& operator =(
            const SequenceNumber_t& x)
    {

                    m_high = x.m_high;

                    m_low = x.m_low;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceNumber_t that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_t& operator =(
            SequenceNumber_t&& x) noexcept
    {

        m_high = x.m_high;
        m_low = x.m_low;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceNumber_t object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceNumber_t& x) const
    {
        return (m_high == x.m_high &&
           m_low == x.m_low);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceNumber_t object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceNumber_t& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member high
     * @param _high New value for member high
     */
    eProsima_user_DllExport void high(
            int32_t _high)
    {
        m_high = _high;
    }

    /*!
     * @brief This function returns the value of member high
     * @return Value of member high
     */
    eProsima_user_DllExport int32_t high() const
    {
        return m_high;
    }

    /*!
     * @brief This function returns a reference to member high
     * @return Reference to member high
     */
    eProsima_user_DllExport int32_t& high()
    {
        return m_high;
    }


    /*!
     * @brief This function sets a value in member low
     * @param _low New value for member low
     */
    eProsima_user_DllExport void low(
            uint32_t _low)
    {
        m_low = _low;
    }

    /*!
     * @brief This function returns the value of member low
     * @return Value of member low
     */
    eProsima_user_DllExport uint32_t low() const
    {
        return m_low;
    }

    /*!
     * @brief This function returns a reference to member low
     * @return Reference to member low
     */
    eProsima_user_DllExport uint32_t& low()
    {
        return m_low;
    }



private:

    int32_t m_high{0};
    uint32_t m_low{0};

};
/*!
 * @brief This class represents the structure SampleIdentity defined by the user in the IDL file.
 * @ingroup rpc_types
 */
class SampleIdentity
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SampleIdentity()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SampleIdentity()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SampleIdentity that will be copied.
     */
    eProsima_user_DllExport SampleIdentity(
            const SampleIdentity& x)
    {
                    m_writer_guid = x.m_writer_guid;

                    m_sequence_number = x.m_sequence_number;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SampleIdentity that will be copied.
     */
    eProsima_user_DllExport SampleIdentity(
            SampleIdentity&& x) noexcept
    {
        m_writer_guid = std::move(x.m_writer_guid);
        m_sequence_number = std::move(x.m_sequence_number);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SampleIdentity that will be copied.
     */
    eProsima_user_DllExport SampleIdentity& operator =(
            const SampleIdentity& x)
    {

                    m_writer_guid = x.m_writer_guid;

                    m_sequence_number = x.m_sequence_number;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SampleIdentity that will be copied.
     */
    eProsima_user_DllExport SampleIdentity& operator =(
            SampleIdentity&& x) noexcept
    {

        m_writer_guid = std::move(x.m_writer_guid);
        m_sequence_number = std::move(x.m_sequence_number);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SampleIdentity object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SampleIdentity& x) const
    {
        return (m_writer_guid == x.m_writer_guid &&
           m_sequence_number == x.m_sequence_number);
    }

    /*!
     * @brief Comparison operator.
     * @param x SampleIdentity object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SampleIdentity& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member writer_guid
     * @param _writer_guid New value to be copied in member writer_guid
     */
    eProsima_user_DllExport void writer_guid(
            const GUID_t& _writer_guid)
    {
        m_writer_guid = _writer_guid;
    }

    /*!
     * @brief This function moves the value in member writer_guid
     * @param _writer_guid New value to be moved in member writer_guid
     */
    eProsima_user_DllExport void writer_guid(
            GUID_t&& _writer_guid)
    {
        m_writer_guid = std::move(_writer_guid);
    }

    /*!
     * @brief This function returns a constant reference to member writer_guid
     * @return Constant reference to member writer_guid
     */
    eProsima_user_DllExport const GUID_t& writer_guid() const
    {
        return m_writer_guid;
    }

    /*!
     * @brief This function returns a reference to member writer_guid
     * @return Reference to member writer_guid
     */
    eProsima_user_DllExport GUID_t& writer_guid()
    {
        return m_writer_guid;
    }


    /*!
     * @brief This function copies the value in member sequence_number
     * @param _sequence_number New value to be copied in member sequence_number
     */
    eProsima_user_DllExport void sequence_number(
            const SequenceNumber_t& _sequence_number)
    {
        m_sequence_number = _sequence_number;
    }

    /*!
     * @brief This function moves the value in member sequence_number
     * @param _sequence_number New value to be moved in member sequence_number
     */
    eProsima_user_DllExport void sequence_number(
            SequenceNumber_t&& _sequence_number)
    {
        m_sequence_number = std::move(_sequence_number);
    }

    /*!
     * @brief This function returns a constant reference to member sequence_number
     * @return Constant reference to member sequence_number
     */
    eProsima_user_DllExport const SequenceNumber_t& sequence_number() const
    {
        return m_sequence_number;
    }

    /*!
     * @brief This function returns a reference to member sequence_number
     * @return Reference to member sequence_number
     */
    eProsima_user_DllExport SequenceNumber_t& sequence_number()
    {
        return m_sequence_number;
    }



private:

    GUID_t m_writer_guid;
    SequenceNumber_t m_sequence_number;

};
namespace rpc {

typedef uint8_t UnknownOperation;

typedef uint8_t UnknownException;

typedef uint8_t UnusedMember;

/*!
 * @brief This class represents the enumeration RemoteExceptionCode_t defined by the user in the IDL file.
 * @ingroup rpc_types
 */
enum class RemoteExceptionCode_t : int32_t
{
    REMOTE_EX_OK,
    REMOTE_EX_UNSUPPORTED,
    REMOTE_EX_INVALID_ARGUMENT,
    REMOTE_EX_OUT_OF_RESOURCES,
    REMOTE_EX_UNKNOWN_OPERATION,
    REMOTE_EX_UNKNOWN_EXCEPTION
};
typedef eprosima::fastcdr::fixed_string<255> InstanceName;

/*!
 * @brief This class represents the structure RequestHeader defined by the user in the IDL file.
 * @ingroup rpc_types
 */
class RequestHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport RequestHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~RequestHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object RequestHeader that will be copied.
     */
    eProsima_user_DllExport RequestHeader(
            const RequestHeader& x)
    {
                    m_requestId = x.m_requestId;

                    m_instanceName = x.m_instanceName;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object RequestHeader that will be copied.
     */
    eProsima_user_DllExport RequestHeader(
            RequestHeader&& x) noexcept
    {
        m_requestId = std::move(x.m_requestId);
        m_instanceName = std::move(x.m_instanceName);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object RequestHeader that will be copied.
     */
    eProsima_user_DllExport RequestHeader& operator =(
            const RequestHeader& x)
    {

                    m_requestId = x.m_requestId;

                    m_instanceName = x.m_instanceName;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object RequestHeader that will be copied.
     */
    eProsima_user_DllExport RequestHeader& operator =(
            RequestHeader&& x) noexcept
    {

        m_requestId = std::move(x.m_requestId);
        m_instanceName = std::move(x.m_instanceName);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x RequestHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const RequestHeader& x) const
    {
        return (m_requestId == x.m_requestId &&
           m_instanceName == x.m_instanceName);
    }

    /*!
     * @brief Comparison operator.
     * @param x RequestHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const RequestHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member requestId
     * @param _requestId New value to be copied in member requestId
     */
    eProsima_user_DllExport void requestId(
            const eprosima::fastdds::dds::SampleIdentity& _requestId)
    {
        m_requestId = _requestId;
    }

    /*!
     * @brief This function moves the value in member requestId
     * @param _requestId New value to be moved in member requestId
     */
    eProsima_user_DllExport void requestId(
            eprosima::fastdds::dds::SampleIdentity&& _requestId)
    {
        m_requestId = std::move(_requestId);
    }

    /*!
     * @brief This function returns a constant reference to member requestId
     * @return Constant reference to member requestId
     */
    eProsima_user_DllExport const eprosima::fastdds::dds::SampleIdentity& requestId() const
    {
        return m_requestId;
    }

    /*!
     * @brief This function returns a reference to member requestId
     * @return Reference to member requestId
     */
    eProsima_user_DllExport eprosima::fastdds::dds::SampleIdentity& requestId()
    {
        return m_requestId;
    }


    /*!
     * @brief This function copies the value in member instanceName
     * @param _instanceName New value to be copied in member instanceName
     */
    eProsima_user_DllExport void instanceName(
            const InstanceName& _instanceName)
    {
        m_instanceName = _instanceName;
    }

    /*!
     * @brief This function moves the value in member instanceName
     * @param _instanceName New value to be moved in member instanceName
     */
    eProsima_user_DllExport void instanceName(
            InstanceName&& _instanceName)
    {
        m_instanceName = std::move(_instanceName);
    }

    /*!
     * @brief This function returns a constant reference to member instanceName
     * @return Constant reference to member instanceName
     */
    eProsima_user_DllExport const InstanceName& instanceName() const
    {
        return m_instanceName;
    }

    /*!
     * @brief This function returns a reference to member instanceName
     * @return Reference to member instanceName
     */
    eProsima_user_DllExport InstanceName& instanceName()
    {
        return m_instanceName;
    }



private:

    eprosima::fastdds::dds::SampleIdentity m_requestId;
    InstanceName m_instanceName;

};
/*!
 * @brief This class represents the structure ReplyHeader defined by the user in the IDL file.
 * @ingroup rpc_types
 */
class ReplyHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ReplyHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ReplyHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ReplyHeader that will be copied.
     */
    eProsima_user_DllExport ReplyHeader(
            const ReplyHeader& x)
    {
                    m_relatedRequestId = x.m_relatedRequestId;

                    m_remoteEx = x.m_remoteEx;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ReplyHeader that will be copied.
     */
    eProsima_user_DllExport ReplyHeader(
            ReplyHeader&& x) noexcept
    {
        m_relatedRequestId = std::move(x.m_relatedRequestId);
        m_remoteEx = x.m_remoteEx;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ReplyHeader that will be copied.
     */
    eProsima_user_DllExport ReplyHeader& operator =(
            const ReplyHeader& x)
    {

                    m_relatedRequestId = x.m_relatedRequestId;

                    m_remoteEx = x.m_remoteEx;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ReplyHeader that will be copied.
     */
    eProsima_user_DllExport ReplyHeader& operator =(
            ReplyHeader&& x) noexcept
    {

        m_relatedRequestId = std::move(x.m_relatedRequestId);
        m_remoteEx = x.m_remoteEx;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ReplyHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ReplyHeader& x) const
    {
        return (m_relatedRequestId == x.m_relatedRequestId &&
           m_remoteEx == x.m_remoteEx);
    }

    /*!
     * @brief Comparison operator.
     * @param x ReplyHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ReplyHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member relatedRequestId
     * @param _relatedRequestId New value to be copied in member relatedRequestId
     */
    eProsima_user_DllExport void relatedRequestId(
            const eprosima::fastdds::dds::SampleIdentity& _relatedRequestId)
    {
        m_relatedRequestId = _relatedRequestId;
    }

    /*!
     * @brief This function moves the value in member relatedRequestId
     * @param _relatedRequestId New value to be moved in member relatedRequestId
     */
    eProsima_user_DllExport void relatedRequestId(
            eprosima::fastdds::dds::SampleIdentity&& _relatedRequestId)
    {
        m_relatedRequestId = std::move(_relatedRequestId);
    }

    /*!
     * @brief This function returns a constant reference to member relatedRequestId
     * @return Constant reference to member relatedRequestId
     */
    eProsima_user_DllExport const eprosima::fastdds::dds::SampleIdentity& relatedRequestId() const
    {
        return m_relatedRequestId;
    }

    /*!
     * @brief This function returns a reference to member relatedRequestId
     * @return Reference to member relatedRequestId
     */
    eProsima_user_DllExport eprosima::fastdds::dds::SampleIdentity& relatedRequestId()
    {
        return m_relatedRequestId;
    }


    /*!
     * @brief This function sets a value in member remoteEx
     * @param _remoteEx New value for member remoteEx
     */
    eProsima_user_DllExport void remoteEx(
            RemoteExceptionCode_t _remoteEx)
    {
        m_remoteEx = _remoteEx;
    }

    /*!
     * @brief This function returns the value of member remoteEx
     * @return Value of member remoteEx
     */
    eProsima_user_DllExport RemoteExceptionCode_t remoteEx() const
    {
        return m_remoteEx;
    }

    /*!
     * @brief This function returns a reference to member remoteEx
     * @return Reference to member remoteEx
     */
    eProsima_user_DllExport RemoteExceptionCode_t& remoteEx()
    {
        return m_remoteEx;
    }



private:

    eprosima::fastdds::dds::SampleIdentity m_relatedRequestId;
    RemoteExceptionCode_t m_remoteEx{RemoteExceptionCode_t::REMOTE_EX_OK};

};

} // namespace rpc

} // namespace dds

} // namespace fastdds

} // namespace eprosima


#endif // _FAST_DDS_GENERATED_EPROSIMA_FASTDDS_DDS_RPC_RPC_TYPES_HPP_


