// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(sxtb)                      \
  M(sxtb16)                    \
  M(sxth)                      \
  M(uxtb)                      \
  M(uxtb16)                    \
  M(uxth)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  ShiftType ror;
  uint32_t amount;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] = {
    {{vc, r2, r5, ROR, 0}, false, al, "vc r2 r5 ROR 0", "vc_r2_r5_ROR_0"},
    {{eq, r5, r7, ROR, 0}, false, al, "eq r5 r7 ROR 0", "eq_r5_r7_ROR_0"},
    {{ge, r3, r2, ROR, 8}, false, al, "ge r3 r2 ROR 8", "ge_r3_r2_ROR_8"},
    {{cc, r11, r3, ROR, 16}, false, al, "cc r11 r3 ROR 16", "cc_r11_r3_ROR_16"},
    {{cs, r13, r6, ROR, 0}, false, al, "cs r13 r6 ROR 0", "cs_r13_r6_ROR_0"},
    {{al, r6, r7, ROR, 16}, false, al, "al r6 r7 ROR 16", "al_r6_r7_ROR_16"},
    {{le, r12, r12, ROR, 0}, false, al, "le r12 r12 ROR 0", "le_r12_r12_ROR_0"},
    {{mi, r4, r5, ROR, 16}, false, al, "mi r4 r5 ROR 16", "mi_r4_r5_ROR_16"},
    {{pl, r9, r2, ROR, 16}, false, al, "pl r9 r2 ROR 16", "pl_r9_r2_ROR_16"},
    {{vs, r5, r11, ROR, 8}, false, al, "vs r5 r11 ROR 8", "vs_r5_r11_ROR_8"},
    {{vs, r0, r3, ROR, 0}, false, al, "vs r0 r3 ROR 0", "vs_r0_r3_ROR_0"},
    {{vs, r5, r4, ROR, 24}, false, al, "vs r5 r4 ROR 24", "vs_r5_r4_ROR_24"},
    {{le, r14, r12, ROR, 24},
     false,
     al,
     "le r14 r12 ROR 24",
     "le_r14_r12_ROR_24"},
    {{ne, r6, r12, ROR, 16}, false, al, "ne r6 r12 ROR 16", "ne_r6_r12_ROR_16"},
    {{cs, r0, r9, ROR, 16}, false, al, "cs r0 r9 ROR 16", "cs_r0_r9_ROR_16"},
    {{ne, r12, r2, ROR, 0}, false, al, "ne r12 r2 ROR 0", "ne_r12_r2_ROR_0"},
    {{cc, r9, r6, ROR, 8}, false, al, "cc r9 r6 ROR 8", "cc_r9_r6_ROR_8"},
    {{pl, r7, r14, ROR, 8}, false, al, "pl r7 r14 ROR 8", "pl_r7_r14_ROR_8"},
    {{vs, r0, r1, ROR, 24}, false, al, "vs r0 r1 ROR 24", "vs_r0_r1_ROR_24"},
    {{ls, r8, r6, ROR, 24}, false, al, "ls r8 r6 ROR 24", "ls_r8_r6_ROR_24"},
    {{cs, r13, r14, ROR, 0}, false, al, "cs r13 r14 ROR 0", "cs_r13_r14_ROR_0"},
    {{al, r11, r7, ROR, 8}, false, al, "al r11 r7 ROR 8", "al_r11_r7_ROR_8"},
    {{ne, r12, r11, ROR, 0}, false, al, "ne r12 r11 ROR 0", "ne_r12_r11_ROR_0"},
    {{cc, r0, r5, ROR, 24}, false, al, "cc r0 r5 ROR 24", "cc_r0_r5_ROR_24"},
    {{vc, r12, r0, ROR, 0}, false, al, "vc r12 r0 ROR 0", "vc_r12_r0_ROR_0"},
    {{al, r7, r7, ROR, 0}, false, al, "al r7 r7 ROR 0", "al_r7_r7_ROR_0"},
    {{ne, r3, r11, ROR, 0}, false, al, "ne r3 r11 ROR 0", "ne_r3_r11_ROR_0"},
    {{ge, r5, r10, ROR, 16}, false, al, "ge r5 r10 ROR 16", "ge_r5_r10_ROR_16"},
    {{cc, r14, r9, ROR, 8}, false, al, "cc r14 r9 ROR 8", "cc_r14_r9_ROR_8"},
    {{cc, r0, r3, ROR, 0}, false, al, "cc r0 r3 ROR 0", "cc_r0_r3_ROR_0"},
    {{le, r14, r2, ROR, 16}, false, al, "le r14 r2 ROR 16", "le_r14_r2_ROR_16"},
    {{vs, r5, r14, ROR, 24}, false, al, "vs r5 r14 ROR 24", "vs_r5_r14_ROR_24"},
    {{pl, r1, r2, ROR, 16}, false, al, "pl r1 r2 ROR 16", "pl_r1_r2_ROR_16"},
    {{lt, r4, r4, ROR, 0}, false, al, "lt r4 r4 ROR 0", "lt_r4_r4_ROR_0"},
    {{vs, r2, r12, ROR, 0}, false, al, "vs r2 r12 ROR 0", "vs_r2_r12_ROR_0"},
    {{cc, r9, r10, ROR, 8}, false, al, "cc r9 r10 ROR 8", "cc_r9_r10_ROR_8"},
    {{ge, r5, r13, ROR, 0}, false, al, "ge r5 r13 ROR 0", "ge_r5_r13_ROR_0"},
    {{hi, r12, r10, ROR, 8}, false, al, "hi r12 r10 ROR 8", "hi_r12_r10_ROR_8"},
    {{cs, r13, r14, ROR, 8}, false, al, "cs r13 r14 ROR 8", "cs_r13_r14_ROR_8"},
    {{cc, r10, r10, ROR, 0}, false, al, "cc r10 r10 ROR 0", "cc_r10_r10_ROR_0"},
    {{gt, r4, r6, ROR, 16}, false, al, "gt r4 r6 ROR 16", "gt_r4_r6_ROR_16"},
    {{al, r13, r5, ROR, 16}, false, al, "al r13 r5 ROR 16", "al_r13_r5_ROR_16"},
    {{pl, r4, r8, ROR, 0}, false, al, "pl r4 r8 ROR 0", "pl_r4_r8_ROR_0"},
    {{gt, r11, r13, ROR, 24},
     false,
     al,
     "gt r11 r13 ROR 24",
     "gt_r11_r13_ROR_24"},
    {{cs, r10, r14, ROR, 0}, false, al, "cs r10 r14 ROR 0", "cs_r10_r14_ROR_0"},
    {{ne, r3, r14, ROR, 8}, false, al, "ne r3 r14 ROR 8", "ne_r3_r14_ROR_8"},
    {{vc, r10, r5, ROR, 8}, false, al, "vc r10 r5 ROR 8", "vc_r10_r5_ROR_8"},
    {{lt, r0, r1, ROR, 0}, false, al, "lt r0 r1 ROR 0", "lt_r0_r1_ROR_0"},
    {{le, r10, r10, ROR, 16},
     false,
     al,
     "le r10 r10 ROR 16",
     "le_r10_r10_ROR_16"},
    {{eq, r10, r5, ROR, 24}, false, al, "eq r10 r5 ROR 24", "eq_r10_r5_ROR_24"},
    {{gt, r7, r5, ROR, 16}, false, al, "gt r7 r5 ROR 16", "gt_r7_r5_ROR_16"},
    {{ne, r1, r14, ROR, 24}, false, al, "ne r1 r14 ROR 24", "ne_r1_r14_ROR_24"},
    {{cc, r8, r13, ROR, 0}, false, al, "cc r8 r13 ROR 0", "cc_r8_r13_ROR_0"},
    {{lt, r3, r14, ROR, 0}, false, al, "lt r3 r14 ROR 0", "lt_r3_r14_ROR_0"},
    {{ne, r3, r5, ROR, 24}, false, al, "ne r3 r5 ROR 24", "ne_r3_r5_ROR_24"},
    {{ls, r1, r1, ROR, 8}, false, al, "ls r1 r1 ROR 8", "ls_r1_r1_ROR_8"},
    {{mi, r5, r8, ROR, 0}, false, al, "mi r5 r8 ROR 0", "mi_r5_r8_ROR_0"},
    {{pl, r3, r2, ROR, 0}, false, al, "pl r3 r2 ROR 0", "pl_r3_r2_ROR_0"},
    {{lt, r6, r5, ROR, 24}, false, al, "lt r6 r5 ROR 24", "lt_r6_r5_ROR_24"},
    {{ne, r6, r10, ROR, 0}, false, al, "ne r6 r10 ROR 0", "ne_r6_r10_ROR_0"},
    {{ls, r11, r5, ROR, 24}, false, al, "ls r11 r5 ROR 24", "ls_r11_r5_ROR_24"},
    {{gt, r12, r2, ROR, 24}, false, al, "gt r12 r2 ROR 24", "gt_r12_r2_ROR_24"},
    {{vc, r11, r2, ROR, 8}, false, al, "vc r11 r2 ROR 8", "vc_r11_r2_ROR_8"},
    {{vc, r9, r14, ROR, 0}, false, al, "vc r9 r14 ROR 0", "vc_r9_r14_ROR_0"},
    {{le, r1, r1, ROR, 0}, false, al, "le r1 r1 ROR 0", "le_r1_r1_ROR_0"},
    {{lt, r13, r6, ROR, 24}, false, al, "lt r13 r6 ROR 24", "lt_r13_r6_ROR_24"},
    {{cs, r6, r11, ROR, 8}, false, al, "cs r6 r11 ROR 8", "cs_r6_r11_ROR_8"},
    {{ge, r13, r0, ROR, 16}, false, al, "ge r13 r0 ROR 16", "ge_r13_r0_ROR_16"},
    {{gt, r9, r5, ROR, 16}, false, al, "gt r9 r5 ROR 16", "gt_r9_r5_ROR_16"},
    {{al, r9, r0, ROR, 0}, false, al, "al r9 r0 ROR 0", "al_r9_r0_ROR_0"},
    {{hi, r12, r12, ROR, 16},
     false,
     al,
     "hi r12 r12 ROR 16",
     "hi_r12_r12_ROR_16"},
    {{al, r9, r1, ROR, 24}, false, al, "al r9 r1 ROR 24", "al_r9_r1_ROR_24"},
    {{pl, r13, r3, ROR, 8}, false, al, "pl r13 r3 ROR 8", "pl_r13_r3_ROR_8"},
    {{eq, r10, r2, ROR, 24}, false, al, "eq r10 r2 ROR 24", "eq_r10_r2_ROR_24"},
    {{cc, r4, r11, ROR, 16}, false, al, "cc r4 r11 ROR 16", "cc_r4_r11_ROR_16"},
    {{vs, r4, r4, ROR, 8}, false, al, "vs r4 r4 ROR 8", "vs_r4_r4_ROR_8"},
    {{cs, r9, r0, ROR, 16}, false, al, "cs r9 r0 ROR 16", "cs_r9_r0_ROR_16"},
    {{hi, r1, r2, ROR, 8}, false, al, "hi r1 r2 ROR 8", "hi_r1_r2_ROR_8"},
    {{vs, r4, r6, ROR, 16}, false, al, "vs r4 r6 ROR 16", "vs_r4_r6_ROR_16"},
    {{hi, r2, r12, ROR, 16}, false, al, "hi r2 r12 ROR 16", "hi_r2_r12_ROR_16"},
    {{vs, r14, r4, ROR, 24}, false, al, "vs r14 r4 ROR 24", "vs_r14_r4_ROR_24"},
    {{pl, r0, r6, ROR, 24}, false, al, "pl r0 r6 ROR 24", "pl_r0_r6_ROR_24"},
    {{vs, r3, r6, ROR, 0}, false, al, "vs r3 r6 ROR 0", "vs_r3_r6_ROR_0"},
    {{eq, r14, r13, ROR, 0}, false, al, "eq r14 r13 ROR 0", "eq_r14_r13_ROR_0"},
    {{ge, r1, r12, ROR, 8}, false, al, "ge r1 r12 ROR 8", "ge_r1_r12_ROR_8"},
    {{gt, r12, r6, ROR, 24}, false, al, "gt r12 r6 ROR 24", "gt_r12_r6_ROR_24"},
    {{al, r12, r8, ROR, 24}, false, al, "al r12 r8 ROR 24", "al_r12_r8_ROR_24"},
    {{mi, r8, r10, ROR, 0}, false, al, "mi r8 r10 ROR 0", "mi_r8_r10_ROR_0"},
    {{gt, r0, r4, ROR, 0}, false, al, "gt r0 r4 ROR 0", "gt_r0_r4_ROR_0"},
    {{vs, r1, r11, ROR, 8}, false, al, "vs r1 r11 ROR 8", "vs_r1_r11_ROR_8"},
    {{cc, r7, r3, ROR, 8}, false, al, "cc r7 r3 ROR 8", "cc_r7_r3_ROR_8"},
    {{eq, r14, r6, ROR, 0}, false, al, "eq r14 r6 ROR 0", "eq_r14_r6_ROR_0"},
    {{le, r3, r7, ROR, 16}, false, al, "le r3 r7 ROR 16", "le_r3_r7_ROR_16"},
    {{eq, r13, r13, ROR, 24},
     false,
     al,
     "eq r13 r13 ROR 24",
     "eq_r13_r13_ROR_24"},
    {{le, r13, r12, ROR, 8}, false, al, "le r13 r12 ROR 8", "le_r13_r12_ROR_8"},
    {{eq, r11, r10, ROR, 24},
     false,
     al,
     "eq r11 r10 ROR 24",
     "eq_r11_r10_ROR_24"},
    {{le, r3, r3, ROR, 0}, false, al, "le r3 r3 ROR 0", "le_r3_r3_ROR_0"},
    {{hi, r7, r1, ROR, 0}, false, al, "hi r7 r1 ROR 0", "hi_r7_r1_ROR_0"},
    {{lt, r5, r5, ROR, 24}, false, al, "lt r5 r5 ROR 24", "lt_r5_r5_ROR_24"},
    {{hi, r11, r3, ROR, 0}, false, al, "hi r11 r3 ROR 0", "hi_r11_r3_ROR_0"},
    {{vs, r2, r10, ROR, 0}, false, al, "vs r2 r10 ROR 0", "vs_r2_r10_ROR_0"},
    {{vc, r7, r6, ROR, 0}, false, al, "vc r7 r6 ROR 0", "vc_r7_r6_ROR_0"},
    {{cs, r14, r7, ROR, 8}, false, al, "cs r14 r7 ROR 8", "cs_r14_r7_ROR_8"},
    {{ge, r4, r11, ROR, 16}, false, al, "ge r4 r11 ROR 16", "ge_r4_r11_ROR_16"},
    {{mi, r5, r3, ROR, 16}, false, al, "mi r5 r3 ROR 16", "mi_r5_r3_ROR_16"},
    {{al, r4, r11, ROR, 8}, false, al, "al r4 r11 ROR 8", "al_r4_r11_ROR_8"},
    {{vs, r14, r10, ROR, 16},
     false,
     al,
     "vs r14 r10 ROR 16",
     "vs_r14_r10_ROR_16"},
    {{cc, r9, r5, ROR, 8}, false, al, "cc r9 r5 ROR 8", "cc_r9_r5_ROR_8"},
    {{vs, r4, r12, ROR, 24}, false, al, "vs r4 r12 ROR 24", "vs_r4_r12_ROR_24"},
    {{hi, r13, r9, ROR, 24}, false, al, "hi r13 r9 ROR 24", "hi_r13_r9_ROR_24"},
    {{cc, r5, r4, ROR, 0}, false, al, "cc r5 r4 ROR 0", "cc_r5_r4_ROR_0"},
    {{mi, r2, r0, ROR, 16}, false, al, "mi r2 r0 ROR 16", "mi_r2_r0_ROR_16"},
    {{hi, r14, r14, ROR, 8}, false, al, "hi r14 r14 ROR 8", "hi_r14_r14_ROR_8"},
    {{eq, r2, r9, ROR, 24}, false, al, "eq r2 r9 ROR 24", "eq_r2_r9_ROR_24"},
    {{mi, r14, r13, ROR, 24},
     false,
     al,
     "mi r14 r13 ROR 24",
     "mi_r14_r13_ROR_24"},
    {{ne, r13, r4, ROR, 8}, false, al, "ne r13 r4 ROR 8", "ne_r13_r4_ROR_8"},
    {{pl, r9, r8, ROR, 24}, false, al, "pl r9 r8 ROR 24", "pl_r9_r8_ROR_24"},
    {{hi, r4, r9, ROR, 8}, false, al, "hi r4 r9 ROR 8", "hi_r4_r9_ROR_8"},
    {{mi, r9, r6, ROR, 0}, false, al, "mi r9 r6 ROR 0", "mi_r9_r6_ROR_0"},
    {{ge, r8, r12, ROR, 8}, false, al, "ge r8 r12 ROR 8", "ge_r8_r12_ROR_8"},
    {{pl, r1, r1, ROR, 16}, false, al, "pl r1 r1 ROR 16", "pl_r1_r1_ROR_16"},
    {{mi, r8, r0, ROR, 16}, false, al, "mi r8 r0 ROR 16", "mi_r8_r0_ROR_16"},
    {{le, r0, r4, ROR, 16}, false, al, "le r0 r4 ROR 16", "le_r0_r4_ROR_16"},
    {{mi, r10, r2, ROR, 16}, false, al, "mi r10 r2 ROR 16", "mi_r10_r2_ROR_16"},
    {{ne, r11, r12, ROR, 0}, false, al, "ne r11 r12 ROR 0", "ne_r11_r12_ROR_0"},
    {{lt, r12, r11, ROR, 24},
     false,
     al,
     "lt r12 r11 ROR 24",
     "lt_r12_r11_ROR_24"},
    {{ne, r0, r10, ROR, 0}, false, al, "ne r0 r10 ROR 0", "ne_r0_r10_ROR_0"},
    {{ls, r2, r14, ROR, 8}, false, al, "ls r2 r14 ROR 8", "ls_r2_r14_ROR_8"},
    {{al, r2, r1, ROR, 8}, false, al, "al r2 r1 ROR 8", "al_r2_r1_ROR_8"},
    {{pl, r12, r5, ROR, 0}, false, al, "pl r12 r5 ROR 0", "pl_r12_r5_ROR_0"},
    {{le, r1, r14, ROR, 8}, false, al, "le r1 r14 ROR 8", "le_r1_r14_ROR_8"},
    {{pl, r0, r14, ROR, 0}, false, al, "pl r0 r14 ROR 0", "pl_r0_r14_ROR_0"},
    {{eq, r2, r1, ROR, 0}, false, al, "eq r2 r1 ROR 0", "eq_r2_r1_ROR_0"},
    {{al, r0, r14, ROR, 16}, false, al, "al r0 r14 ROR 16", "al_r0_r14_ROR_16"},
    {{eq, r1, r8, ROR, 0}, false, al, "eq r1 r8 ROR 0", "eq_r1_r8_ROR_0"},
    {{mi, r13, r0, ROR, 8}, false, al, "mi r13 r0 ROR 8", "mi_r13_r0_ROR_8"},
    {{mi, r6, r13, ROR, 0}, false, al, "mi r6 r13 ROR 0", "mi_r6_r13_ROR_0"},
    {{vs, r0, r7, ROR, 8}, false, al, "vs r0 r7 ROR 8", "vs_r0_r7_ROR_8"},
    {{ge, r11, r6, ROR, 24}, false, al, "ge r11 r6 ROR 24", "ge_r11_r6_ROR_24"},
    {{lt, r14, r14, ROR, 16},
     false,
     al,
     "lt r14 r14 ROR 16",
     "lt_r14_r14_ROR_16"},
    {{hi, r11, r6, ROR, 16}, false, al, "hi r11 r6 ROR 16", "hi_r11_r6_ROR_16"},
    {{cc, r2, r12, ROR, 24}, false, al, "cc r2 r12 ROR 24", "cc_r2_r12_ROR_24"},
    {{lt, r0, r6, ROR, 8}, false, al, "lt r0 r6 ROR 8", "lt_r0_r6_ROR_8"},
    {{cs, r6, r10, ROR, 24}, false, al, "cs r6 r10 ROR 24", "cs_r6_r10_ROR_24"},
    {{mi, r12, r13, ROR, 8}, false, al, "mi r12 r13 ROR 8", "mi_r12_r13_ROR_8"},
    {{cs, r4, r6, ROR, 16}, false, al, "cs r4 r6 ROR 16", "cs_r4_r6_ROR_16"},
    {{gt, r8, r2, ROR, 0}, false, al, "gt r8 r2 ROR 0", "gt_r8_r2_ROR_0"},
    {{mi, r4, r14, ROR, 8}, false, al, "mi r4 r14 ROR 8", "mi_r4_r14_ROR_8"},
    {{ne, r1, r5, ROR, 0}, false, al, "ne r1 r5 ROR 0", "ne_r1_r5_ROR_0"},
    {{hi, r11, r6, ROR, 8}, false, al, "hi r11 r6 ROR 8", "hi_r11_r6_ROR_8"},
    {{pl, r1, r8, ROR, 16}, false, al, "pl r1 r8 ROR 16", "pl_r1_r8_ROR_16"},
    {{cc, r2, r3, ROR, 8}, false, al, "cc r2 r3 ROR 8", "cc_r2_r3_ROR_8"},
    {{ne, r14, r5, ROR, 16}, false, al, "ne r14 r5 ROR 16", "ne_r14_r5_ROR_16"},
    {{hi, r8, r2, ROR, 0}, false, al, "hi r8 r2 ROR 0", "hi_r8_r2_ROR_0"},
    {{eq, r12, r9, ROR, 8}, false, al, "eq r12 r9 ROR 8", "eq_r12_r9_ROR_8"},
    {{cs, r3, r0, ROR, 0}, false, al, "cs r3 r0 ROR 0", "cs_r3_r0_ROR_0"},
    {{ne, r2, r6, ROR, 16}, false, al, "ne r2 r6 ROR 16", "ne_r2_r6_ROR_16"},
    {{eq, r1, r13, ROR, 8}, false, al, "eq r1 r13 ROR 8", "eq_r1_r13_ROR_8"},
    {{vc, r6, r0, ROR, 8}, false, al, "vc r6 r0 ROR 8", "vc_r6_r0_ROR_8"},
    {{pl, r9, r3, ROR, 16}, false, al, "pl r9 r3 ROR 16", "pl_r9_r3_ROR_16"},
    {{al, r1, r14, ROR, 0}, false, al, "al r1 r14 ROR 0", "al_r1_r14_ROR_0"},
    {{ls, r4, r8, ROR, 0}, false, al, "ls r4 r8 ROR 0", "ls_r4_r8_ROR_0"},
    {{ge, r10, r7, ROR, 16}, false, al, "ge r10 r7 ROR 16", "ge_r10_r7_ROR_16"},
    {{ls, r1, r8, ROR, 16}, false, al, "ls r1 r8 ROR 16", "ls_r1_r8_ROR_16"},
    {{cs, r12, r13, ROR, 24},
     false,
     al,
     "cs r12 r13 ROR 24",
     "cs_r12_r13_ROR_24"},
    {{le, r8, r10, ROR, 8}, false, al, "le r8 r10 ROR 8", "le_r8_r10_ROR_8"},
    {{eq, r3, r3, ROR, 16}, false, al, "eq r3 r3 ROR 16", "eq_r3_r3_ROR_16"},
    {{ge, r13, r11, ROR, 16},
     false,
     al,
     "ge r13 r11 ROR 16",
     "ge_r13_r11_ROR_16"},
    {{hi, r4, r11, ROR, 0}, false, al, "hi r4 r11 ROR 0", "hi_r4_r11_ROR_0"},
    {{mi, r4, r9, ROR, 8}, false, al, "mi r4 r9 ROR 8", "mi_r4_r9_ROR_8"},
    {{eq, r4, r10, ROR, 16}, false, al, "eq r4 r10 ROR 16", "eq_r4_r10_ROR_16"},
    {{mi, r9, r11, ROR, 8}, false, al, "mi r9 r11 ROR 8", "mi_r9_r11_ROR_8"},
    {{vc, r5, r5, ROR, 24}, false, al, "vc r5 r5 ROR 24", "vc_r5_r5_ROR_24"},
    {{hi, r13, r8, ROR, 16}, false, al, "hi r13 r8 ROR 16", "hi_r13_r8_ROR_16"},
    {{pl, r2, r10, ROR, 0}, false, al, "pl r2 r10 ROR 0", "pl_r2_r10_ROR_0"},
    {{le, r0, r6, ROR, 24}, false, al, "le r0 r6 ROR 24", "le_r0_r6_ROR_24"},
    {{ls, r11, r6, ROR, 16}, false, al, "ls r11 r6 ROR 16", "ls_r11_r6_ROR_16"},
    {{eq, r7, r3, ROR, 0}, false, al, "eq r7 r3 ROR 0", "eq_r7_r3_ROR_0"},
    {{cs, r13, r1, ROR, 24}, false, al, "cs r13 r1 ROR 24", "cs_r13_r1_ROR_24"},
    {{gt, r7, r11, ROR, 8}, false, al, "gt r7 r11 ROR 8", "gt_r7_r11_ROR_8"},
    {{le, r5, r11, ROR, 0}, false, al, "le r5 r11 ROR 0", "le_r5_r11_ROR_0"},
    {{ne, r11, r4, ROR, 24}, false, al, "ne r11 r4 ROR 24", "ne_r11_r4_ROR_24"},
    {{cs, r3, r5, ROR, 16}, false, al, "cs r3 r5 ROR 16", "cs_r3_r5_ROR_16"},
    {{lt, r10, r14, ROR, 0}, false, al, "lt r10 r14 ROR 0", "lt_r10_r14_ROR_0"},
    {{ls, r4, r0, ROR, 24}, false, al, "ls r4 r0 ROR 24", "ls_r4_r0_ROR_24"},
    {{le, r0, r13, ROR, 24}, false, al, "le r0 r13 ROR 24", "le_r0_r13_ROR_24"},
    {{lt, r10, r0, ROR, 0}, false, al, "lt r10 r0 ROR 0", "lt_r10_r0_ROR_0"},
    {{cc, r11, r14, ROR, 24},
     false,
     al,
     "cc r11 r14 ROR 24",
     "cc_r11_r14_ROR_24"},
    {{mi, r4, r14, ROR, 16}, false, al, "mi r4 r14 ROR 16", "mi_r4_r14_ROR_16"},
    {{ls, r11, r0, ROR, 0}, false, al, "ls r11 r0 ROR 0", "ls_r11_r0_ROR_0"},
    {{ge, r6, r4, ROR, 16}, false, al, "ge r6 r4 ROR 16", "ge_r6_r4_ROR_16"},
    {{cc, r8, r6, ROR, 16}, false, al, "cc r8 r6 ROR 16", "cc_r8_r6_ROR_16"},
    {{mi, r12, r11, ROR, 8}, false, al, "mi r12 r11 ROR 8", "mi_r12_r11_ROR_8"},
    {{lt, r1, r6, ROR, 0}, false, al, "lt r1 r6 ROR 0", "lt_r1_r6_ROR_0"},
    {{lt, r4, r12, ROR, 8}, false, al, "lt r4 r12 ROR 8", "lt_r4_r12_ROR_8"},
    {{al, r3, r5, ROR, 24}, false, al, "al r3 r5 ROR 24", "al_r3_r5_ROR_24"},
    {{le, r4, r12, ROR, 16}, false, al, "le r4 r12 ROR 16", "le_r4_r12_ROR_16"},
    {{eq, r9, r8, ROR, 16}, false, al, "eq r9 r8 ROR 16", "eq_r9_r8_ROR_16"},
    {{ge, r7, r1, ROR, 0}, false, al, "ge r7 r1 ROR 0", "ge_r7_r1_ROR_0"},
    {{vc, r2, r6, ROR, 16}, false, al, "vc r2 r6 ROR 16", "vc_r2_r6_ROR_16"},
    {{ne, r9, r4, ROR, 16}, false, al, "ne r9 r4 ROR 16", "ne_r9_r4_ROR_16"},
    {{mi, r0, r12, ROR, 24}, false, al, "mi r0 r12 ROR 24", "mi_r0_r12_ROR_24"},
    {{vc, r5, r8, ROR, 16}, false, al, "vc r5 r8 ROR 16", "vc_r5_r8_ROR_16"},
    {{pl, r1, r13, ROR, 24}, false, al, "pl r1 r13 ROR 24", "pl_r1_r13_ROR_24"},
    {{mi, r14, r14, ROR, 8}, false, al, "mi r14 r14 ROR 8", "mi_r14_r14_ROR_8"},
    {{eq, r9, r6, ROR, 16}, false, al, "eq r9 r6 ROR 16", "eq_r9_r6_ROR_16"},
    {{cc, r6, r0, ROR, 0}, false, al, "cc r6 r0 ROR 0", "cc_r6_r0_ROR_0"},
    {{gt, r2, r14, ROR, 8}, false, al, "gt r2 r14 ROR 8", "gt_r2_r14_ROR_8"},
    {{vs, r2, r11, ROR, 16}, false, al, "vs r2 r11 ROR 16", "vs_r2_r11_ROR_16"},
    {{al, r10, r9, ROR, 0}, false, al, "al r10 r9 ROR 0", "al_r10_r9_ROR_0"},
    {{lt, r4, r3, ROR, 16}, false, al, "lt r4 r3 ROR 16", "lt_r4_r3_ROR_16"},
    {{hi, r7, r10, ROR, 24}, false, al, "hi r7 r10 ROR 24", "hi_r7_r10_ROR_24"},
    {{vs, r14, r11, ROR, 16},
     false,
     al,
     "vs r14 r11 ROR 16",
     "vs_r14_r11_ROR_16"},
    {{cs, r3, r6, ROR, 24}, false, al, "cs r3 r6 ROR 24", "cs_r3_r6_ROR_24"},
    {{eq, r5, r0, ROR, 24}, false, al, "eq r5 r0 ROR 24", "eq_r5_r0_ROR_24"},
    {{hi, r3, r5, ROR, 24}, false, al, "hi r3 r5 ROR 24", "hi_r3_r5_ROR_24"},
    {{al, r10, r10, ROR, 16},
     false,
     al,
     "al r10 r10 ROR 16",
     "al_r10_r10_ROR_16"},
    {{le, r7, r14, ROR, 16}, false, al, "le r7 r14 ROR 16", "le_r7_r14_ROR_16"},
    {{ne, r7, r2, ROR, 24}, false, al, "ne r7 r2 ROR 24", "ne_r7_r2_ROR_24"},
    {{mi, r6, r6, ROR, 24}, false, al, "mi r6 r6 ROR 24", "mi_r6_r6_ROR_24"},
    {{gt, r1, r5, ROR, 16}, false, al, "gt r1 r5 ROR 16", "gt_r1_r5_ROR_16"},
    {{al, r7, r5, ROR, 8}, false, al, "al r7 r5 ROR 8", "al_r7_r5_ROR_8"},
    {{le, r13, r6, ROR, 8}, false, al, "le r13 r6 ROR 8", "le_r13_r6_ROR_8"},
    {{cc, r12, r12, ROR, 8}, false, al, "cc r12 r12 ROR 8", "cc_r12_r12_ROR_8"},
    {{pl, r1, r12, ROR, 8}, false, al, "pl r1 r12 ROR 8", "pl_r1_r12_ROR_8"},
    {{ls, r2, r10, ROR, 16}, false, al, "ls r2 r10 ROR 16", "ls_r2_r10_ROR_16"},
    {{le, r4, r12, ROR, 8}, false, al, "le r4 r12 ROR 8", "le_r4_r12_ROR_8"},
    {{ne, r2, r0, ROR, 24}, false, al, "ne r2 r0 ROR 24", "ne_r2_r0_ROR_24"},
    {{ne, r4, r2, ROR, 8}, false, al, "ne r4 r2 ROR 8", "ne_r4_r2_ROR_8"},
    {{mi, r7, r5, ROR, 0}, false, al, "mi r7 r5 ROR 0", "mi_r7_r5_ROR_0"},
    {{vs, r5, r12, ROR, 16}, false, al, "vs r5 r12 ROR 16", "vs_r5_r12_ROR_16"},
    {{al, r7, r13, ROR, 24}, false, al, "al r7 r13 ROR 24", "al_r7_r13_ROR_24"},
    {{cs, r2, r3, ROR, 0}, false, al, "cs r2 r3 ROR 0", "cs_r2_r3_ROR_0"},
    {{al, r7, r14, ROR, 0}, false, al, "al r7 r14 ROR 0", "al_r7_r14_ROR_0"},
    {{lt, r5, r7, ROR, 16}, false, al, "lt r5 r7 ROR 16", "lt_r5_r7_ROR_16"},
    {{al, r7, r5, ROR, 24}, false, al, "al r7 r5 ROR 24", "al_r7_r5_ROR_24"},
    {{vs, r2, r3, ROR, 0}, false, al, "vs r2 r3 ROR 0", "vs_r2_r3_ROR_0"},
    {{ne, r7, r10, ROR, 8}, false, al, "ne r7 r10 ROR 8", "ne_r7_r10_ROR_8"},
    {{eq, r10, r8, ROR, 8}, false, al, "eq r10 r8 ROR 8", "eq_r10_r8_ROR_8"},
    {{al, r7, r2, ROR, 0}, false, al, "al r7 r2 ROR 0", "al_r7_r2_ROR_0"},
    {{vc, r11, r6, ROR, 24}, false, al, "vc r11 r6 ROR 24", "vc_r11_r6_ROR_24"},
    {{eq, r10, r3, ROR, 24}, false, al, "eq r10 r3 ROR 24", "eq_r10_r3_ROR_24"},
    {{gt, r14, r11, ROR, 0}, false, al, "gt r14 r11 ROR 0", "gt_r14_r11_ROR_0"},
    {{al, r14, r11, ROR, 0}, false, al, "al r14 r11 ROR 0", "al_r14_r11_ROR_0"},
    {{pl, r7, r7, ROR, 8}, false, al, "pl r7 r7 ROR 8", "pl_r7_r7_ROR_8"},
    {{hi, r7, r8, ROR, 0}, false, al, "hi r7 r8 ROR 0", "hi_r7_r8_ROR_0"},
    {{lt, r7, r5, ROR, 16}, false, al, "lt r7 r5 ROR 16", "lt_r7_r5_ROR_16"},
    {{eq, r7, r9, ROR, 16}, false, al, "eq r7 r9 ROR 16", "eq_r7_r9_ROR_16"},
    {{cs, r1, r12, ROR, 24}, false, al, "cs r1 r12 ROR 24", "cs_r1_r12_ROR_24"},
    {{al, r10, r9, ROR, 8}, false, al, "al r10 r9 ROR 8", "al_r10_r9_ROR_8"},
    {{ge, r2, r6, ROR, 24}, false, al, "ge r2 r6 ROR 24", "ge_r2_r6_ROR_24"},
    {{mi, r5, r12, ROR, 0}, false, al, "mi r5 r12 ROR 0", "mi_r5_r12_ROR_0"},
    {{al, r11, r8, ROR, 24}, false, al, "al r11 r8 ROR 24", "al_r11_r8_ROR_24"},
    {{mi, r10, r1, ROR, 0}, false, al, "mi r10 r1 ROR 0", "mi_r10_r1_ROR_0"},
    {{ls, r11, r7, ROR, 0}, false, al, "ls r11 r7 ROR 0", "ls_r11_r7_ROR_0"},
    {{vs, r13, r14, ROR, 8}, false, al, "vs r13 r14 ROR 8", "vs_r13_r14_ROR_8"},
    {{gt, r0, r6, ROR, 8}, false, al, "gt r0 r6 ROR 8", "gt_r0_r6_ROR_8"},
    {{cs, r3, r4, ROR, 16}, false, al, "cs r3 r4 ROR 16", "cs_r3_r4_ROR_16"},
    {{eq, r0, r7, ROR, 0}, false, al, "eq r0 r7 ROR 0", "eq_r0_r7_ROR_0"},
    {{le, r12, r11, ROR, 16},
     false,
     al,
     "le r12 r11 ROR 16",
     "le_r12_r11_ROR_16"},
    {{pl, r8, r7, ROR, 8}, false, al, "pl r8 r7 ROR 8", "pl_r8_r7_ROR_8"},
    {{ls, r5, r3, ROR, 8}, false, al, "ls r5 r3 ROR 8", "ls_r5_r3_ROR_8"},
    {{vs, r2, r12, ROR, 16}, false, al, "vs r2 r12 ROR 16", "vs_r2_r12_ROR_16"},
    {{ls, r4, r3, ROR, 0}, false, al, "ls r4 r3 ROR 0", "ls_r4_r3_ROR_0"},
    {{pl, r9, r3, ROR, 8}, false, al, "pl r9 r3 ROR 8", "pl_r9_r3_ROR_8"},
    {{vs, r10, r8, ROR, 0}, false, al, "vs r10 r8 ROR 0", "vs_r10_r8_ROR_0"},
    {{pl, r7, r13, ROR, 0}, false, al, "pl r7 r13 ROR 0", "pl_r7_r13_ROR_0"},
    {{ls, r0, r0, ROR, 16}, false, al, "ls r0 r0 ROR 16", "ls_r0_r0_ROR_16"},
    {{le, r14, r7, ROR, 16}, false, al, "le r14 r7 ROR 16", "le_r14_r7_ROR_16"},
    {{pl, r13, r4, ROR, 24}, false, al, "pl r13 r4 ROR 24", "pl_r13_r4_ROR_24"},
    {{ls, r3, r4, ROR, 24}, false, al, "ls r3 r4 ROR 24", "ls_r3_r4_ROR_24"},
    {{hi, r1, r3, ROR, 8}, false, al, "hi r1 r3 ROR 8", "hi_r1_r3_ROR_8"},
    {{hi, r2, r7, ROR, 0}, false, al, "hi r2 r7 ROR 0", "hi_r2_r7_ROR_0"},
    {{ls, r12, r11, ROR, 8}, false, al, "ls r12 r11 ROR 8", "ls_r12_r11_ROR_8"},
    {{mi, r7, r12, ROR, 0}, false, al, "mi r7 r12 ROR 0", "mi_r7_r12_ROR_0"},
    {{gt, r2, r6, ROR, 16}, false, al, "gt r2 r6 ROR 16", "gt_r2_r6_ROR_16"},
    {{cs, r7, r14, ROR, 24}, false, al, "cs r7 r14 ROR 24", "cs_r7_r14_ROR_24"},
    {{vc, r0, r0, ROR, 8}, false, al, "vc r0 r0 ROR 8", "vc_r0_r0_ROR_8"},
    {{al, r10, r10, ROR, 0}, false, al, "al r10 r10 ROR 0", "al_r10_r10_ROR_0"},
    {{al, r1, r4, ROR, 0}, false, al, "al r1 r4 ROR 0", "al_r1_r4_ROR_0"},
    {{vc, r2, r8, ROR, 0}, false, al, "vc r2 r8 ROR 0", "vc_r2_r8_ROR_0"},
    {{vc, r4, r6, ROR, 16}, false, al, "vc r4 r6 ROR 16", "vc_r4_r6_ROR_16"},
    {{pl, r1, r9, ROR, 0}, false, al, "pl r1 r9 ROR 0", "pl_r1_r9_ROR_0"},
    {{le, r2, r9, ROR, 0}, false, al, "le r2 r9 ROR 0", "le_r2_r9_ROR_0"},
    {{mi, r14, r5, ROR, 16}, false, al, "mi r14 r5 ROR 16", "mi_r14_r5_ROR_16"},
    {{le, r3, r5, ROR, 24}, false, al, "le r3 r5 ROR 24", "le_r3_r5_ROR_24"},
    {{lt, r4, r14, ROR, 0}, false, al, "lt r4 r14 ROR 0", "lt_r4_r14_ROR_0"},
    {{al, r9, r9, ROR, 0}, false, al, "al r9 r9 ROR 0", "al_r9_r9_ROR_0"},
    {{lt, r13, r12, ROR, 24},
     false,
     al,
     "lt r13 r12 ROR 24",
     "lt_r13_r12_ROR_24"},
    {{mi, r7, r7, ROR, 16}, false, al, "mi r7 r7 ROR 16", "mi_r7_r7_ROR_16"},
    {{lt, r0, r10, ROR, 0}, false, al, "lt r0 r10 ROR 0", "lt_r0_r10_ROR_0"},
    {{al, r0, r12, ROR, 16}, false, al, "al r0 r12 ROR 16", "al_r0_r12_ROR_16"},
    {{mi, r12, r5, ROR, 8}, false, al, "mi r12 r5 ROR 8", "mi_r12_r5_ROR_8"},
    {{vc, r13, r1, ROR, 0}, false, al, "vc r13 r1 ROR 0", "vc_r13_r1_ROR_0"},
    {{mi, r1, r11, ROR, 24}, false, al, "mi r1 r11 ROR 24", "mi_r1_r11_ROR_24"},
    {{cc, r1, r3, ROR, 0}, false, al, "cc r1 r3 ROR 0", "cc_r1_r3_ROR_0"},
    {{mi, r6, r7, ROR, 0}, false, al, "mi r6 r7 ROR 0", "mi_r6_r7_ROR_0"},
    {{cs, r1, r13, ROR, 24}, false, al, "cs r1 r13 ROR 24", "cs_r1_r13_ROR_24"},
    {{pl, r8, r3, ROR, 24}, false, al, "pl r8 r3 ROR 24", "pl_r8_r3_ROR_24"},
    {{mi, r11, r12, ROR, 16},
     false,
     al,
     "mi r11 r12 ROR 16",
     "mi_r11_r12_ROR_16"},
    {{cs, r3, r12, ROR, 0}, false, al, "cs r3 r12 ROR 0", "cs_r3_r12_ROR_0"},
    {{cs, r0, r2, ROR, 24}, false, al, "cs r0 r2 ROR 24", "cs_r0_r2_ROR_24"},
    {{vs, r0, r8, ROR, 8}, false, al, "vs r0 r8 ROR 8", "vs_r0_r8_ROR_8"},
    {{lt, r3, r13, ROR, 0}, false, al, "lt r3 r13 ROR 0", "lt_r3_r13_ROR_0"},
    {{mi, r11, r14, ROR, 16},
     false,
     al,
     "mi r11 r14 ROR 16",
     "mi_r11_r14_ROR_16"},
    {{mi, r10, r9, ROR, 0}, false, al, "mi r10 r9 ROR 0", "mi_r10_r9_ROR_0"},
    {{cc, r8, r6, ROR, 8}, false, al, "cc r8 r6 ROR 8", "cc_r8_r6_ROR_8"},
    {{le, r4, r5, ROR, 24}, false, al, "le r4 r5 ROR 24", "le_r4_r5_ROR_24"},
    {{le, r12, r4, ROR, 8}, false, al, "le r12 r4 ROR 8", "le_r12_r4_ROR_8"},
    {{ge, r8, r11, ROR, 0}, false, al, "ge r8 r11 ROR 0", "ge_r8_r11_ROR_0"},
    {{ne, r5, r1, ROR, 8}, false, al, "ne r5 r1 ROR 8", "ne_r5_r1_ROR_8"},
    {{vc, r10, r6, ROR, 0}, false, al, "vc r10 r6 ROR 0", "vc_r10_r6_ROR_0"},
    {{le, r7, r8, ROR, 24}, false, al, "le r7 r8 ROR 24", "le_r7_r8_ROR_24"},
    {{ge, r10, r11, ROR, 8}, false, al, "ge r10 r11 ROR 8", "ge_r10_r11_ROR_8"},
    {{lt, r13, r11, ROR, 0}, false, al, "lt r13 r11 ROR 0", "lt_r13_r11_ROR_0"},
    {{ge, r7, r10, ROR, 16}, false, al, "ge r7 r10 ROR 16", "ge_r7_r10_ROR_16"},
    {{ge, r5, r9, ROR, 0}, false, al, "ge r5 r9 ROR 0", "ge_r5_r9_ROR_0"},
    {{ne, r5, r2, ROR, 0}, false, al, "ne r5 r2 ROR 0", "ne_r5_r2_ROR_0"},
    {{cc, r12, r7, ROR, 0}, false, al, "cc r12 r7 ROR 0", "cc_r12_r7_ROR_0"},
    {{le, r11, r7, ROR, 0}, false, al, "le r11 r7 ROR 0", "le_r11_r7_ROR_0"},
    {{al, r1, r11, ROR, 0}, false, al, "al r1 r11 ROR 0", "al_r1_r11_ROR_0"},
    {{eq, r4, r2, ROR, 24}, false, al, "eq r4 r2 ROR 24", "eq_r4_r2_ROR_24"},
    {{ne, r8, r12, ROR, 8}, false, al, "ne r8 r12 ROR 8", "ne_r8_r12_ROR_8"},
    {{al, r9, r11, ROR, 0}, false, al, "al r9 r11 ROR 0", "al_r9_r11_ROR_0"},
    {{le, r9, r0, ROR, 8}, false, al, "le r9 r0 ROR 8", "le_r9_r0_ROR_8"},
    {{mi, r6, r2, ROR, 0}, false, al, "mi r6 r2 ROR 0", "mi_r6_r2_ROR_0"},
    {{ne, r0, r10, ROR, 16}, false, al, "ne r0 r10 ROR 16", "ne_r0_r10_ROR_16"},
    {{ne, r4, r9, ROR, 24}, false, al, "ne r4 r9 ROR 24", "ne_r4_r9_ROR_24"},
    {{lt, r7, r10, ROR, 0}, false, al, "lt r7 r10 ROR 0", "lt_r7_r10_ROR_0"},
    {{hi, r2, r0, ROR, 8}, false, al, "hi r2 r0 ROR 8", "hi_r2_r0_ROR_8"},
    {{eq, r1, r6, ROR, 16}, false, al, "eq r1 r6 ROR 16", "eq_r1_r6_ROR_16"},
    {{pl, r4, r2, ROR, 24}, false, al, "pl r4 r2 ROR 24", "pl_r4_r2_ROR_24"},
    {{vs, r11, r10, ROR, 24},
     false,
     al,
     "vs r11 r10 ROR 24",
     "vs_r11_r10_ROR_24"},
    {{lt, r3, r11, ROR, 8}, false, al, "lt r3 r11 ROR 8", "lt_r3_r11_ROR_8"},
    {{hi, r8, r0, ROR, 0}, false, al, "hi r8 r0 ROR 0", "hi_r8_r0_ROR_0"},
    {{lt, r11, r11, ROR, 16},
     false,
     al,
     "lt r11 r11 ROR 16",
     "lt_r11_r11_ROR_16"},
    {{cs, r7, r6, ROR, 24}, false, al, "cs r7 r6 ROR 24", "cs_r7_r6_ROR_24"},
    {{pl, r8, r9, ROR, 24}, false, al, "pl r8 r9 ROR 24", "pl_r8_r9_ROR_24"},
    {{ne, r5, r4, ROR, 8}, false, al, "ne r5 r4 ROR 8", "ne_r5_r4_ROR_8"},
    {{ne, r5, r4, ROR, 0}, false, al, "ne r5 r4 ROR 0", "ne_r5_r4_ROR_0"},
    {{gt, r0, r14, ROR, 24}, false, al, "gt r0 r14 ROR 24", "gt_r0_r14_ROR_24"},
    {{mi, r10, r12, ROR, 8}, false, al, "mi r10 r12 ROR 8", "mi_r10_r12_ROR_8"},
    {{le, r3, r14, ROR, 0}, false, al, "le r3 r14 ROR 0", "le_r3_r14_ROR_0"},
    {{ne, r10, r14, ROR, 16},
     false,
     al,
     "ne r10 r14 ROR 16",
     "ne_r10_r14_ROR_16"},
    {{ls, r14, r9, ROR, 24}, false, al, "ls r14 r9 ROR 24", "ls_r14_r9_ROR_24"},
    {{ge, r2, r10, ROR, 24}, false, al, "ge r2 r10 ROR 24", "ge_r2_r10_ROR_24"},
    {{lt, r12, r14, ROR, 0}, false, al, "lt r12 r14 ROR 0", "lt_r12_r14_ROR_0"},
    {{eq, r7, r14, ROR, 0}, false, al, "eq r7 r14 ROR 0", "eq_r7_r14_ROR_0"},
    {{al, r1, r8, ROR, 0}, false, al, "al r1 r8 ROR 0", "al_r1_r8_ROR_0"},
    {{vc, r12, r13, ROR, 0}, false, al, "vc r12 r13 ROR 0", "vc_r12_r13_ROR_0"},
    {{le, r4, r6, ROR, 24}, false, al, "le r4 r6 ROR 24", "le_r4_r6_ROR_24"},
    {{vc, r12, r5, ROR, 24}, false, al, "vc r12 r5 ROR 24", "vc_r12_r5_ROR_24"},
    {{al, r10, r12, ROR, 8}, false, al, "al r10 r12 ROR 8", "al_r10_r12_ROR_8"},
    {{pl, r12, r4, ROR, 8}, false, al, "pl r12 r4 ROR 8", "pl_r12_r4_ROR_8"},
    {{eq, r1, r7, ROR, 8}, false, al, "eq r1 r7 ROR 8", "eq_r1_r7_ROR_8"},
    {{hi, r2, r8, ROR, 16}, false, al, "hi r2 r8 ROR 16", "hi_r2_r8_ROR_16"},
    {{gt, r0, r11, ROR, 16}, false, al, "gt r0 r11 ROR 16", "gt_r0_r11_ROR_16"},
    {{ge, r10, r6, ROR, 24}, false, al, "ge r10 r6 ROR 24", "ge_r10_r6_ROR_24"},
    {{ne, r1, r5, ROR, 24}, false, al, "ne r1 r5 ROR 24", "ne_r1_r5_ROR_24"},
    {{vc, r8, r10, ROR, 16}, false, al, "vc r8 r10 ROR 16", "vc_r8_r10_ROR_16"},
    {{eq, r13, r7, ROR, 8}, false, al, "eq r13 r7 ROR 8", "eq_r13_r7_ROR_8"},
    {{pl, r14, r6, ROR, 8}, false, al, "pl r14 r6 ROR 8", "pl_r14_r6_ROR_8"},
    {{vs, r6, r2, ROR, 16}, false, al, "vs r6 r2 ROR 16", "vs_r6_r2_ROR_16"},
    {{gt, r9, r8, ROR, 0}, false, al, "gt r9 r8 ROR 0", "gt_r9_r8_ROR_0"},
    {{al, r6, r9, ROR, 16}, false, al, "al r6 r9 ROR 16", "al_r6_r9_ROR_16"},
    {{cc, r6, r3, ROR, 0}, false, al, "cc r6 r3 ROR 0", "cc_r6_r3_ROR_0"},
    {{cc, r2, r5, ROR, 24}, false, al, "cc r2 r5 ROR 24", "cc_r2_r5_ROR_24"},
    {{mi, r4, r1, ROR, 16}, false, al, "mi r4 r1 ROR 16", "mi_r4_r1_ROR_16"},
    {{vc, r4, r4, ROR, 0}, false, al, "vc r4 r4 ROR 0", "vc_r4_r4_ROR_0"},
    {{cc, r2, r10, ROR, 24}, false, al, "cc r2 r10 ROR 24", "cc_r2_r10_ROR_24"},
    {{vs, r9, r8, ROR, 0}, false, al, "vs r9 r8 ROR 0", "vs_r9_r8_ROR_0"},
    {{gt, r0, r9, ROR, 8}, false, al, "gt r0 r9 ROR 8", "gt_r0_r9_ROR_8"},
    {{ls, r10, r11, ROR, 8}, false, al, "ls r10 r11 ROR 8", "ls_r10_r11_ROR_8"},
    {{al, r11, r9, ROR, 16}, false, al, "al r11 r9 ROR 16", "al_r11_r9_ROR_16"},
    {{vs, r0, r10, ROR, 16}, false, al, "vs r0 r10 ROR 16", "vs_r0_r10_ROR_16"},
    {{ls, r14, r10, ROR, 0}, false, al, "ls r14 r10 ROR 0", "ls_r14_r10_ROR_0"},
    {{gt, r10, r5, ROR, 24}, false, al, "gt r10 r5 ROR 24", "gt_r10_r5_ROR_24"},
    {{al, r14, r14, ROR, 0}, false, al, "al r14 r14 ROR 0", "al_r14_r14_ROR_0"},
    {{ge, r6, r9, ROR, 16}, false, al, "ge r6 r9 ROR 16", "ge_r6_r9_ROR_16"},
    {{vs, r1, r2, ROR, 8}, false, al, "vs r1 r2 ROR 8", "vs_r1_r2_ROR_8"},
    {{lt, r11, r1, ROR, 8}, false, al, "lt r11 r1 ROR 8", "lt_r11_r1_ROR_8"},
    {{mi, r12, r5, ROR, 0}, false, al, "mi r12 r5 ROR 0", "mi_r12_r5_ROR_0"},
    {{pl, r0, r0, ROR, 24}, false, al, "pl r0 r0 ROR 24", "pl_r0_r0_ROR_24"},
    {{gt, r5, r2, ROR, 8}, false, al, "gt r5 r2 ROR 8", "gt_r5_r2_ROR_8"},
    {{ne, r10, r10, ROR, 0}, false, al, "ne r10 r10 ROR 0", "ne_r10_r10_ROR_0"},
    {{mi, r11, r12, ROR, 8}, false, al, "mi r11 r12 ROR 8", "mi_r11_r12_ROR_8"},
    {{vs, r9, r9, ROR, 16}, false, al, "vs r9 r9 ROR 16", "vs_r9_r9_ROR_16"},
    {{mi, r9, r6, ROR, 16}, false, al, "mi r9 r6 ROR 16", "mi_r9_r6_ROR_16"},
    {{vs, r12, r11, ROR, 24},
     false,
     al,
     "vs r12 r11 ROR 24",
     "vs_r12_r11_ROR_24"},
    {{eq, r0, r1, ROR, 0}, false, al, "eq r0 r1 ROR 0", "eq_r0_r1_ROR_0"},
    {{vc, r12, r11, ROR, 24},
     false,
     al,
     "vc r12 r11 ROR 24",
     "vc_r12_r11_ROR_24"},
    {{cs, r14, r13, ROR, 16},
     false,
     al,
     "cs r14 r13 ROR 16",
     "cs_r14_r13_ROR_16"},
    {{vs, r12, r1, ROR, 8}, false, al, "vs r12 r1 ROR 8", "vs_r12_r1_ROR_8"},
    {{cc, r13, r9, ROR, 0}, false, al, "cc r13 r9 ROR 0", "cc_r13_r9_ROR_0"},
    {{ne, r3, r8, ROR, 8}, false, al, "ne r3 r8 ROR 8", "ne_r3_r8_ROR_8"},
    {{ne, r8, r6, ROR, 8}, false, al, "ne r8 r6 ROR 8", "ne_r8_r6_ROR_8"},
    {{cc, r6, r8, ROR, 16}, false, al, "cc r6 r8 ROR 16", "cc_r6_r8_ROR_16"},
    {{gt, r14, r14, ROR, 16},
     false,
     al,
     "gt r14 r14 ROR 16",
     "gt_r14_r14_ROR_16"},
    {{lt, r7, r6, ROR, 16}, false, al, "lt r7 r6 ROR 16", "lt_r7_r6_ROR_16"},
    {{pl, r10, r6, ROR, 8}, false, al, "pl r10 r6 ROR 8", "pl_r10_r6_ROR_8"},
    {{ne, r5, r12, ROR, 0}, false, al, "ne r5 r12 ROR 0", "ne_r5_r12_ROR_0"},
    {{al, r8, r11, ROR, 16}, false, al, "al r8 r11 ROR 16", "al_r8_r11_ROR_16"},
    {{pl, r7, r9, ROR, 8}, false, al, "pl r7 r9 ROR 8", "pl_r7_r9_ROR_8"},
    {{mi, r2, r7, ROR, 8}, false, al, "mi r2 r7 ROR 8", "mi_r2_r7_ROR_8"},
    {{ls, r4, r3, ROR, 16}, false, al, "ls r4 r3 ROR 16", "ls_r4_r3_ROR_16"},
    {{mi, r10, r8, ROR, 8}, false, al, "mi r10 r8 ROR 8", "mi_r10_r8_ROR_8"},
    {{mi, r3, r3, ROR, 24}, false, al, "mi r3 r3 ROR 24", "mi_r3_r3_ROR_24"},
    {{hi, r14, r7, ROR, 0}, false, al, "hi r14 r7 ROR 0", "hi_r14_r7_ROR_0"},
    {{al, r3, r6, ROR, 16}, false, al, "al r3 r6 ROR 16", "al_r3_r6_ROR_16"},
    {{gt, r3, r4, ROR, 0}, false, al, "gt r3 r4 ROR 0", "gt_r3_r4_ROR_0"},
    {{pl, r14, r14, ROR, 0}, false, al, "pl r14 r14 ROR 0", "pl_r14_r14_ROR_0"},
    {{hi, r3, r4, ROR, 0}, false, al, "hi r3 r4 ROR 0", "hi_r3_r4_ROR_0"},
    {{le, r6, r3, ROR, 24}, false, al, "le r6 r3 ROR 24", "le_r6_r3_ROR_24"},
    {{eq, r6, r10, ROR, 0}, false, al, "eq r6 r10 ROR 0", "eq_r6_r10_ROR_0"},
    {{vs, r2, r11, ROR, 0}, false, al, "vs r2 r11 ROR 0", "vs_r2_r11_ROR_0"},
    {{lt, r1, r0, ROR, 24}, false, al, "lt r1 r0 ROR 24", "lt_r1_r0_ROR_24"},
    {{hi, r3, r7, ROR, 8}, false, al, "hi r3 r7 ROR 8", "hi_r3_r7_ROR_8"},
    {{eq, r2, r0, ROR, 24}, false, al, "eq r2 r0 ROR 24", "eq_r2_r0_ROR_24"},
    {{vs, r0, r7, ROR, 0}, false, al, "vs r0 r7 ROR 0", "vs_r0_r7_ROR_0"},
    {{hi, r5, r11, ROR, 24}, false, al, "hi r5 r11 ROR 24", "hi_r5_r11_ROR_24"},
    {{lt, r4, r9, ROR, 8}, false, al, "lt r4 r9 ROR 8", "lt_r4_r9_ROR_8"},
    {{mi, r8, r4, ROR, 16}, false, al, "mi r8 r4 ROR 16", "mi_r8_r4_ROR_16"},
    {{eq, r6, r5, ROR, 0}, false, al, "eq r6 r5 ROR 0", "eq_r6_r5_ROR_0"},
    {{ne, r4, r1, ROR, 8}, false, al, "ne r4 r1 ROR 8", "ne_r4_r1_ROR_8"},
    {{mi, r8, r5, ROR, 0}, false, al, "mi r8 r5 ROR 0", "mi_r8_r5_ROR_0"},
    {{hi, r5, r14, ROR, 8}, false, al, "hi r5 r14 ROR 8", "hi_r5_r14_ROR_8"},
    {{gt, r4, r2, ROR, 24}, false, al, "gt r4 r2 ROR 24", "gt_r4_r2_ROR_24"},
    {{ls, r9, r9, ROR, 16}, false, al, "ls r9 r9 ROR 16", "ls_r9_r9_ROR_16"},
    {{cs, r5, r2, ROR, 8}, false, al, "cs r5 r2 ROR 8", "cs_r5_r2_ROR_8"},
    {{gt, r10, r6, ROR, 16}, false, al, "gt r10 r6 ROR 16", "gt_r10_r6_ROR_16"},
    {{ls, r5, r7, ROR, 8}, false, al, "ls r5 r7 ROR 8", "ls_r5_r7_ROR_8"},
    {{ls, r13, r8, ROR, 16}, false, al, "ls r13 r8 ROR 16", "ls_r13_r8_ROR_16"},
    {{ls, r4, r11, ROR, 0}, false, al, "ls r4 r11 ROR 0", "ls_r4_r11_ROR_0"},
    {{mi, r14, r3, ROR, 24}, false, al, "mi r14 r3 ROR 24", "mi_r14_r3_ROR_24"},
    {{hi, r0, r14, ROR, 8}, false, al, "hi r0 r14 ROR 8", "hi_r0_r14_ROR_8"},
    {{ne, r3, r0, ROR, 8}, false, al, "ne r3 r0 ROR 8", "ne_r3_r0_ROR_8"},
    {{cs, r12, r10, ROR, 0}, false, al, "cs r12 r10 ROR 0", "cs_r12_r10_ROR_0"},
    {{ne, r10, r0, ROR, 24}, false, al, "ne r10 r0 ROR 24", "ne_r10_r0_ROR_24"},
    {{pl, r11, r6, ROR, 24}, false, al, "pl r11 r6 ROR 24", "pl_r11_r6_ROR_24"},
    {{mi, r3, r10, ROR, 16}, false, al, "mi r3 r10 ROR 16", "mi_r3_r10_ROR_16"},
    {{vc, r2, r5, ROR, 16}, false, al, "vc r2 r5 ROR 16", "vc_r2_r5_ROR_16"},
    {{eq, r5, r11, ROR, 16}, false, al, "eq r5 r11 ROR 16", "eq_r5_r11_ROR_16"},
    {{al, r4, r11, ROR, 24}, false, al, "al r4 r11 ROR 24", "al_r4_r11_ROR_24"},
    {{pl, r13, r4, ROR, 0}, false, al, "pl r13 r4 ROR 0", "pl_r13_r4_ROR_0"},
    {{ls, r14, r13, ROR, 8}, false, al, "ls r14 r13 ROR 8", "ls_r14_r13_ROR_8"},
    {{ge, r12, r2, ROR, 24}, false, al, "ge r12 r2 ROR 24", "ge_r12_r2_ROR_24"},
    {{eq, r10, r1, ROR, 16}, false, al, "eq r10 r1 ROR 16", "eq_r10_r1_ROR_16"},
    {{le, r0, r14, ROR, 24}, false, al, "le r0 r14 ROR 24", "le_r0_r14_ROR_24"},
    {{al, r3, r9, ROR, 8}, false, al, "al r3 r9 ROR 8", "al_r3_r9_ROR_8"},
    {{cc, r11, r12, ROR, 8}, false, al, "cc r11 r12 ROR 8", "cc_r11_r12_ROR_8"},
    {{ls, r3, r0, ROR, 24}, false, al, "ls r3 r0 ROR 24", "ls_r3_r0_ROR_24"},
    {{hi, r6, r6, ROR, 16}, false, al, "hi r6 r6 ROR 16", "hi_r6_r6_ROR_16"},
    {{cs, r10, r5, ROR, 8}, false, al, "cs r10 r5 ROR 8", "cs_r10_r5_ROR_8"},
    {{mi, r13, r0, ROR, 0}, false, al, "mi r13 r0 ROR 0", "mi_r13_r0_ROR_0"},
    {{le, r6, r3, ROR, 16}, false, al, "le r6 r3 ROR 16", "le_r6_r3_ROR_16"},
    {{ls, r11, r12, ROR, 16},
     false,
     al,
     "ls r11 r12 ROR 16",
     "ls_r11_r12_ROR_16"},
    {{gt, r11, r10, ROR, 16},
     false,
     al,
     "gt r11 r10 ROR 16",
     "gt_r11_r10_ROR_16"},
    {{le, r4, r11, ROR, 0}, false, al, "le r4 r11 ROR 0", "le_r4_r11_ROR_0"},
    {{gt, r3, r7, ROR, 16}, false, al, "gt r3 r7 ROR 16", "gt_r3_r7_ROR_16"},
    {{ne, r10, r0, ROR, 8}, false, al, "ne r10 r0 ROR 8", "ne_r10_r0_ROR_8"},
    {{cc, r7, r5, ROR, 16}, false, al, "cc r7 r5 ROR 16", "cc_r7_r5_ROR_16"},
    {{vc, r10, r0, ROR, 8}, false, al, "vc r10 r0 ROR 8", "vc_r10_r0_ROR_8"},
    {{le, r7, r12, ROR, 8}, false, al, "le r7 r12 ROR 8", "le_r7_r12_ROR_8"},
    {{ls, r1, r4, ROR, 24}, false, al, "ls r1 r4 ROR 24", "ls_r1_r4_ROR_24"},
    {{al, r11, r7, ROR, 16}, false, al, "al r11 r7 ROR 16", "al_r11_r7_ROR_16"},
    {{pl, r8, r4, ROR, 16}, false, al, "pl r8 r4 ROR 16", "pl_r8_r4_ROR_16"},
    {{ne, r5, r9, ROR, 16}, false, al, "ne r5 r9 ROR 16", "ne_r5_r9_ROR_16"},
    {{lt, r7, r13, ROR, 16}, false, al, "lt r7 r13 ROR 16", "lt_r7_r13_ROR_16"},
    {{vc, r5, r7, ROR, 16}, false, al, "vc r5 r7 ROR 16", "vc_r5_r7_ROR_16"},
    {{ls, r3, r10, ROR, 8}, false, al, "ls r3 r10 ROR 8", "ls_r3_r10_ROR_8"},
    {{al, r1, r7, ROR, 16}, false, al, "al r1 r7 ROR 16", "al_r1_r7_ROR_16"},
    {{al, r9, r12, ROR, 8}, false, al, "al r9 r12 ROR 8", "al_r9_r12_ROR_8"},
    {{vc, r14, r9, ROR, 8}, false, al, "vc r14 r9 ROR 8", "vc_r14_r9_ROR_8"},
    {{vs, r4, r1, ROR, 24}, false, al, "vs r4 r1 ROR 24", "vs_r4_r1_ROR_24"},
    {{lt, r11, r9, ROR, 24}, false, al, "lt r11 r9 ROR 24", "lt_r11_r9_ROR_24"},
    {{eq, r12, r8, ROR, 8}, false, al, "eq r12 r8 ROR 8", "eq_r12_r8_ROR_8"},
    {{eq, r5, r5, ROR, 24}, false, al, "eq r5 r5 ROR 24", "eq_r5_r5_ROR_24"},
    {{gt, r2, r4, ROR, 16}, false, al, "gt r2 r4 ROR 16", "gt_r2_r4_ROR_16"},
    {{cs, r12, r0, ROR, 0}, false, al, "cs r12 r0 ROR 0", "cs_r12_r0_ROR_0"},
    {{ge, r11, r9, ROR, 16}, false, al, "ge r11 r9 ROR 16", "ge_r11_r9_ROR_16"},
    {{le, r3, r12, ROR, 0}, false, al, "le r3 r12 ROR 0", "le_r3_r12_ROR_0"},
    {{al, r6, r3, ROR, 0}, false, al, "al r6 r3 ROR 0", "al_r6_r3_ROR_0"},
    {{cc, r8, r3, ROR, 0}, false, al, "cc r8 r3 ROR 0", "cc_r8_r3_ROR_0"},
    {{le, r14, r8, ROR, 8}, false, al, "le r14 r8 ROR 8", "le_r14_r8_ROR_8"},
    {{al, r12, r5, ROR, 8}, false, al, "al r12 r5 ROR 8", "al_r12_r5_ROR_8"},
    {{hi, r2, r11, ROR, 24}, false, al, "hi r2 r11 ROR 24", "hi_r2_r11_ROR_24"},
    {{cc, r2, r7, ROR, 16}, false, al, "cc r2 r7 ROR 16", "cc_r2_r7_ROR_16"},
    {{le, r3, r1, ROR, 0}, false, al, "le r3 r1 ROR 0", "le_r3_r1_ROR_0"},
    {{vs, r14, r2, ROR, 0}, false, al, "vs r14 r2 ROR 0", "vs_r14_r2_ROR_0"},
    {{lt, r1, r3, ROR, 24}, false, al, "lt r1 r3 ROR 24", "lt_r1_r3_ROR_24"},
    {{cc, r0, r9, ROR, 16}, false, al, "cc r0 r9 ROR 16", "cc_r0_r9_ROR_16"},
    {{ne, r11, r6, ROR, 0}, false, al, "ne r11 r6 ROR 0", "ne_r11_r6_ROR_0"},
    {{cs, r4, r5, ROR, 16}, false, al, "cs r4 r5 ROR 16", "cs_r4_r5_ROR_16"},
    {{eq, r9, r5, ROR, 16}, false, al, "eq r9 r5 ROR 16", "eq_r9_r5_ROR_16"},
    {{cs, r11, r8, ROR, 8}, false, al, "cs r11 r8 ROR 8", "cs_r11_r8_ROR_8"},
    {{al, r13, r7, ROR, 8}, false, al, "al r13 r7 ROR 8", "al_r13_r7_ROR_8"},
    {{al, r5, r13, ROR, 16}, false, al, "al r5 r13 ROR 16", "al_r5_r13_ROR_16"},
    {{ge, r9, r7, ROR, 16}, false, al, "ge r9 r7 ROR 16", "ge_r9_r7_ROR_16"},
    {{vs, r1, r9, ROR, 24}, false, al, "vs r1 r9 ROR 24", "vs_r1_r9_ROR_24"},
    {{lt, r0, r3, ROR, 8}, false, al, "lt r0 r3 ROR 8", "lt_r0_r3_ROR_8"},
    {{pl, r7, r0, ROR, 16}, false, al, "pl r7 r0 ROR 16", "pl_r7_r0_ROR_16"},
    {{lt, r5, r14, ROR, 24}, false, al, "lt r5 r14 ROR 24", "lt_r5_r14_ROR_24"},
    {{vc, r0, r5, ROR, 8}, false, al, "vc r0 r5 ROR 8", "vc_r0_r5_ROR_8"},
    {{le, r6, r8, ROR, 16}, false, al, "le r6 r8 ROR 16", "le_r6_r8_ROR_16"},
    {{ge, r6, r6, ROR, 16}, false, al, "ge r6 r6 ROR 16", "ge_r6_r6_ROR_16"},
    {{eq, r8, r2, ROR, 24}, false, al, "eq r8 r2 ROR 24", "eq_r8_r2_ROR_24"},
    {{cc, r12, r6, ROR, 0}, false, al, "cc r12 r6 ROR 0", "cc_r12_r6_ROR_0"},
    {{ls, r3, r13, ROR, 0}, false, al, "ls r3 r13 ROR 0", "ls_r3_r13_ROR_0"},
    {{gt, r1, r11, ROR, 16}, false, al, "gt r1 r11 ROR 16", "gt_r1_r11_ROR_16"},
    {{pl, r10, r1, ROR, 24}, false, al, "pl r10 r1 ROR 24", "pl_r10_r1_ROR_24"},
    {{vc, r11, r7, ROR, 8}, false, al, "vc r11 r7 ROR 8", "vc_r11_r7_ROR_8"},
    {{vc, r3, r13, ROR, 16}, false, al, "vc r3 r13 ROR 16", "vc_r3_r13_ROR_16"},
    {{vc, r4, r12, ROR, 16}, false, al, "vc r4 r12 ROR 16", "vc_r4_r12_ROR_16"},
    {{mi, r1, r8, ROR, 8}, false, al, "mi r1 r8 ROR 8", "mi_r1_r8_ROR_8"},
    {{ls, r9, r5, ROR, 24}, false, al, "ls r9 r5 ROR 24", "ls_r9_r5_ROR_24"},
    {{vc, r14, r0, ROR, 8}, false, al, "vc r14 r0 ROR 8", "vc_r14_r0_ROR_8"},
    {{ls, r5, r5, ROR, 8}, false, al, "ls r5 r5 ROR 8", "ls_r5_r5_ROR_8"},
    {{le, r8, r4, ROR, 8}, false, al, "le r8 r4 ROR 8", "le_r8_r4_ROR_8"},
    {{pl, r6, r13, ROR, 0}, false, al, "pl r6 r13 ROR 0", "pl_r6_r13_ROR_0"},
    {{ne, r0, r3, ROR, 24}, false, al, "ne r0 r3 ROR 24", "ne_r0_r3_ROR_24"},
    {{mi, r4, r0, ROR, 0}, false, al, "mi r4 r0 ROR 0", "mi_r4_r0_ROR_0"},
    {{ls, r7, r7, ROR, 16}, false, al, "ls r7 r7 ROR 16", "ls_r7_r7_ROR_16"},
    {{vs, r12, r2, ROR, 16}, false, al, "vs r12 r2 ROR 16", "vs_r12_r2_ROR_16"},
    {{pl, r0, r0, ROR, 8}, false, al, "pl r0 r0 ROR 8", "pl_r0_r0_ROR_8"},
    {{le, r12, r3, ROR, 24}, false, al, "le r12 r3 ROR 24", "le_r12_r3_ROR_24"},
    {{mi, r13, r6, ROR, 24}, false, al, "mi r13 r6 ROR 24", "mi_r13_r6_ROR_24"},
    {{vs, r2, r8, ROR, 0}, false, al, "vs r2 r8 ROR 0", "vs_r2_r8_ROR_0"},
    {{ne, r11, r11, ROR, 0}, false, al, "ne r11 r11 ROR 0", "ne_r11_r11_ROR_0"},
    {{cs, r10, r3, ROR, 0}, false, al, "cs r10 r3 ROR 0", "cs_r10_r3_ROR_0"},
    {{gt, r8, r6, ROR, 0}, false, al, "gt r8 r6 ROR 0", "gt_r8_r6_ROR_0"},
    {{mi, r6, r12, ROR, 0}, false, al, "mi r6 r12 ROR 0", "mi_r6_r12_ROR_0"},
    {{ne, r10, r8, ROR, 16}, false, al, "ne r10 r8 ROR 16", "ne_r10_r8_ROR_16"},
    {{hi, r0, r10, ROR, 24}, false, al, "hi r0 r10 ROR 24", "hi_r0_r10_ROR_24"},
    {{pl, r14, r0, ROR, 0}, false, al, "pl r14 r0 ROR 0", "pl_r14_r0_ROR_0"},
    {{vs, r0, r3, ROR, 8}, false, al, "vs r0 r3 ROR 8", "vs_r0_r3_ROR_8"},
    {{cs, r11, r5, ROR, 8}, false, al, "cs r11 r5 ROR 8", "cs_r11_r5_ROR_8"},
    {{le, r3, r12, ROR, 24}, false, al, "le r3 r12 ROR 24", "le_r3_r12_ROR_24"},
    {{vs, r14, r8, ROR, 16}, false, al, "vs r14 r8 ROR 16", "vs_r14_r8_ROR_16"},
    {{le, r10, r4, ROR, 24}, false, al, "le r10 r4 ROR 24", "le_r10_r4_ROR_24"},
    {{eq, r12, r7, ROR, 0}, false, al, "eq r12 r7 ROR 0", "eq_r12_r7_ROR_0"},
    {{cs, r9, r4, ROR, 0}, false, al, "cs r9 r4 ROR 0", "cs_r9_r4_ROR_0"},
    {{vs, r12, r5, ROR, 16}, false, al, "vs r12 r5 ROR 16", "vs_r12_r5_ROR_16"},
    {{pl, r9, r4, ROR, 16}, false, al, "pl r9 r4 ROR 16", "pl_r9_r4_ROR_16"},
    {{hi, r3, r0, ROR, 24}, false, al, "hi r3 r0 ROR 24", "hi_r3_r0_ROR_24"},
    {{cc, r2, r6, ROR, 8}, false, al, "cc r2 r6 ROR 8", "cc_r2_r6_ROR_8"},
    {{le, r12, r12, ROR, 16},
     false,
     al,
     "le r12 r12 ROR 16",
     "le_r12_r12_ROR_16"},
    {{lt, r1, r8, ROR, 8}, false, al, "lt r1 r8 ROR 8", "lt_r1_r8_ROR_8"},
    {{lt, r5, r10, ROR, 24}, false, al, "lt r5 r10 ROR 24", "lt_r5_r10_ROR_24"},
    {{pl, r4, r7, ROR, 8}, false, al, "pl r4 r7 ROR 8", "pl_r4_r7_ROR_8"},
    {{ne, r5, r9, ROR, 24}, false, al, "ne r5 r9 ROR 24", "ne_r5_r9_ROR_24"},
    {{al, r13, r8, ROR, 8}, false, al, "al r13 r8 ROR 8", "al_r13_r8_ROR_8"},
    {{eq, r9, r9, ROR, 0}, false, al, "eq r9 r9 ROR 0", "eq_r9_r9_ROR_0"},
    {{ls, r9, r2, ROR, 0}, false, al, "ls r9 r2 ROR 0", "ls_r9_r2_ROR_0"},
    {{eq, r12, r4, ROR, 16}, false, al, "eq r12 r4 ROR 16", "eq_r12_r4_ROR_16"},
    {{pl, r4, r7, ROR, 16}, false, al, "pl r4 r7 ROR 16", "pl_r4_r7_ROR_16"},
    {{ls, r7, r6, ROR, 8}, false, al, "ls r7 r6 ROR 8", "ls_r7_r6_ROR_8"},
    {{vc, r7, r9, ROR, 8}, false, al, "vc r7 r9 ROR 8", "vc_r7_r9_ROR_8"},
    {{hi, r6, r7, ROR, 8}, false, al, "hi r6 r7 ROR 8", "hi_r6_r7_ROR_8"},
    {{vs, r5, r14, ROR, 0}, false, al, "vs r5 r14 ROR 0", "vs_r5_r14_ROR_0"},
    {{vs, r8, r3, ROR, 8}, false, al, "vs r8 r3 ROR 8", "vs_r8_r3_ROR_8"},
    {{vs, r13, r9, ROR, 24}, false, al, "vs r13 r9 ROR 24", "vs_r13_r9_ROR_24"},
    {{hi, r1, r13, ROR, 24}, false, al, "hi r1 r13 ROR 24", "hi_r1_r13_ROR_24"},
    {{mi, r7, r0, ROR, 0}, false, al, "mi r7 r0 ROR 0", "mi_r7_r0_ROR_0"},
    {{cc, r6, r6, ROR, 16}, false, al, "cc r6 r6 ROR 16", "cc_r6_r6_ROR_16"},
    {{le, r5, r5, ROR, 24}, false, al, "le r5 r5 ROR 24", "le_r5_r5_ROR_24"},
    {{ge, r7, r3, ROR, 8}, false, al, "ge r7 r3 ROR 8", "ge_r7_r3_ROR_8"},
    {{vs, r0, r14, ROR, 24}, false, al, "vs r0 r14 ROR 24", "vs_r0_r14_ROR_24"},
    {{ne, r0, r5, ROR, 0}, false, al, "ne r0 r5 ROR 0", "ne_r0_r5_ROR_0"},
    {{ne, r9, r1, ROR, 8}, false, al, "ne r9 r1 ROR 8", "ne_r9_r1_ROR_8"},
    {{vs, r3, r13, ROR, 24}, false, al, "vs r3 r13 ROR 24", "vs_r3_r13_ROR_24"},
    {{lt, r9, r11, ROR, 24}, false, al, "lt r9 r11 ROR 24", "lt_r9_r11_ROR_24"},
    {{mi, r7, r3, ROR, 24}, false, al, "mi r7 r3 ROR 24", "mi_r7_r3_ROR_24"},
    {{lt, r9, r9, ROR, 0}, false, al, "lt r9 r9 ROR 0", "lt_r9_r9_ROR_0"},
    {{al, r2, r13, ROR, 0}, false, al, "al r2 r13 ROR 0", "al_r2_r13_ROR_0"},
    {{gt, r1, r14, ROR, 24}, false, al, "gt r1 r14 ROR 24", "gt_r1_r14_ROR_24"},
    {{cs, r7, r0, ROR, 16}, false, al, "cs r7 r0 ROR 16", "cs_r7_r0_ROR_16"},
    {{pl, r8, r3, ROR, 8}, false, al, "pl r8 r3 ROR 8", "pl_r8_r3_ROR_8"},
    {{ls, r8, r2, ROR, 24}, false, al, "ls r8 r2 ROR 24", "ls_r8_r2_ROR_24"},
    {{ne, r11, r0, ROR, 8}, false, al, "ne r11 r0 ROR 8", "ne_r11_r0_ROR_8"},
    {{cc, r14, r9, ROR, 24}, false, al, "cc r14 r9 ROR 24", "cc_r14_r9_ROR_24"},
    {{le, r7, r4, ROR, 0}, false, al, "le r7 r4 ROR 0", "le_r7_r4_ROR_0"},
    {{cc, r0, r5, ROR, 0}, false, al, "cc r0 r5 ROR 0", "cc_r0_r5_ROR_0"},
    {{cc, r4, r14, ROR, 16}, false, al, "cc r4 r14 ROR 16", "cc_r4_r14_ROR_16"},
    {{le, r11, r10, ROR, 16},
     false,
     al,
     "le r11 r10 ROR 16",
     "le_r11_r10_ROR_16"},
    {{ls, r8, r7, ROR, 16}, false, al, "ls r8 r7 ROR 16", "ls_r8_r7_ROR_16"},
    {{ls, r9, r8, ROR, 16}, false, al, "ls r9 r8 ROR 16", "ls_r9_r8_ROR_16"},
    {{cc, r8, r4, ROR, 24}, false, al, "cc r8 r4 ROR 24", "cc_r8_r4_ROR_24"},
    {{hi, r0, r13, ROR, 0}, false, al, "hi r0 r13 ROR 0", "hi_r0_r13_ROR_0"},
    {{hi, r8, r10, ROR, 8}, false, al, "hi r8 r10 ROR 8", "hi_r8_r10_ROR_8"},
    {{ge, r9, r9, ROR, 24}, false, al, "ge r9 r9 ROR 24", "ge_r9_r9_ROR_24"},
    {{pl, r7, r12, ROR, 8}, false, al, "pl r7 r12 ROR 8", "pl_r7_r12_ROR_8"},
    {{vs, r7, r13, ROR, 16}, false, al, "vs r7 r13 ROR 16", "vs_r7_r13_ROR_16"},
    {{eq, r12, r9, ROR, 0}, false, al, "eq r12 r9 ROR 0", "eq_r12_r9_ROR_0"},
    {{ls, r0, r9, ROR, 8}, false, al, "ls r0 r9 ROR 8", "ls_r0_r9_ROR_8"},
    {{mi, r7, r4, ROR, 24}, false, al, "mi r7 r4 ROR 24", "mi_r7_r4_ROR_24"},
    {{eq, r13, r8, ROR, 24}, false, al, "eq r13 r8 ROR 24", "eq_r13_r8_ROR_24"},
    {{lt, r14, r9, ROR, 8}, false, al, "lt r14 r9 ROR 8", "lt_r14_r9_ROR_8"},
    {{ne, r1, r14, ROR, 8}, false, al, "ne r1 r14 ROR 8", "ne_r1_r14_ROR_8"},
    {{ne, r13, r13, ROR, 16},
     false,
     al,
     "ne r13 r13 ROR 16",
     "ne_r13_r13_ROR_16"},
    {{pl, r1, r11, ROR, 8}, false, al, "pl r1 r11 ROR 8", "pl_r1_r11_ROR_8"},
    {{ls, r0, r4, ROR, 8}, false, al, "ls r0 r4 ROR 8", "ls_r0_r4_ROR_8"},
    {{ge, r13, r3, ROR, 24}, false, al, "ge r13 r3 ROR 24", "ge_r13_r3_ROR_24"},
    {{cs, r7, r12, ROR, 8}, false, al, "cs r7 r12 ROR 8", "cs_r7_r12_ROR_8"},
    {{lt, r6, r2, ROR, 24}, false, al, "lt r6 r2 ROR 24", "lt_r6_r2_ROR_24"},
    {{gt, r5, r9, ROR, 24}, false, al, "gt r5 r9 ROR 24", "gt_r5_r9_ROR_24"},
    {{eq, r1, r2, ROR, 16}, false, al, "eq r1 r2 ROR 16", "eq_r1_r2_ROR_16"},
    {{ne, r8, r8, ROR, 16}, false, al, "ne r8 r8 ROR 16", "ne_r8_r8_ROR_16"},
    {{le, r9, r1, ROR, 8}, false, al, "le r9 r1 ROR 8", "le_r9_r1_ROR_8"},
    {{ne, r13, r0, ROR, 24}, false, al, "ne r13 r0 ROR 24", "ne_r13_r0_ROR_24"},
    {{cs, r12, r2, ROR, 0}, false, al, "cs r12 r2 ROR 0", "cs_r12_r2_ROR_0"},
    {{mi, r14, r0, ROR, 16}, false, al, "mi r14 r0 ROR 16", "mi_r14_r0_ROR_16"},
    {{cs, r2, r9, ROR, 16}, false, al, "cs r2 r9 ROR 16", "cs_r2_r9_ROR_16"},
    {{ne, r10, r9, ROR, 16}, false, al, "ne r10 r9 ROR 16", "ne_r10_r9_ROR_16"},
    {{lt, r1, r11, ROR, 8}, false, al, "lt r1 r11 ROR 8", "lt_r1_r11_ROR_8"},
    {{cc, r6, r10, ROR, 24}, false, al, "cc r6 r10 ROR 24", "cc_r6_r10_ROR_24"},
    {{le, r13, r10, ROR, 16},
     false,
     al,
     "le r13 r10 ROR 16",
     "le_r13_r10_ROR_16"},
    {{mi, r2, r10, ROR, 24}, false, al, "mi r2 r10 ROR 24", "mi_r2_r10_ROR_24"},
    {{hi, r13, r12, ROR, 24},
     false,
     al,
     "hi r13 r12 ROR 24",
     "hi_r13_r12_ROR_24"},
    {{le, r13, r5, ROR, 24}, false, al, "le r13 r5 ROR 24", "le_r13_r5_ROR_24"},
    {{cs, r11, r8, ROR, 16}, false, al, "cs r11 r8 ROR 16", "cs_r11_r8_ROR_16"},
    {{vc, r10, r11, ROR, 24},
     false,
     al,
     "vc r10 r11 ROR 24",
     "vc_r10_r11_ROR_24"},
    {{eq, r3, r5, ROR, 0}, false, al, "eq r3 r5 ROR 0", "eq_r3_r5_ROR_0"},
    {{ne, r9, r7, ROR, 0}, false, al, "ne r9 r7 ROR 0", "ne_r9_r7_ROR_0"},
    {{vc, r4, r8, ROR, 16}, false, al, "vc r4 r8 ROR 16", "vc_r4_r8_ROR_16"},
    {{le, r10, r6, ROR, 8}, false, al, "le r10 r6 ROR 8", "le_r10_r6_ROR_8"},
    {{eq, r7, r1, ROR, 8}, false, al, "eq r7 r1 ROR 8", "eq_r7_r1_ROR_8"},
    {{pl, r2, r10, ROR, 8}, false, al, "pl r2 r10 ROR 8", "pl_r2_r10_ROR_8"},
    {{ge, r8, r13, ROR, 16}, false, al, "ge r8 r13 ROR 16", "ge_r8_r13_ROR_16"},
    {{cs, r10, r3, ROR, 24}, false, al, "cs r10 r3 ROR 24", "cs_r10_r3_ROR_24"},
    {{gt, r5, r2, ROR, 24}, false, al, "gt r5 r2 ROR 24", "gt_r5_r2_ROR_24"},
    {{ge, r2, r1, ROR, 0}, false, al, "ge r2 r1 ROR 0", "ge_r2_r1_ROR_0"},
    {{cc, r6, r3, ROR, 16}, false, al, "cc r6 r3 ROR 16", "cc_r6_r3_ROR_16"},
    {{cs, r5, r0, ROR, 16}, false, al, "cs r5 r0 ROR 16", "cs_r5_r0_ROR_16"},
    {{mi, r3, r9, ROR, 8}, false, al, "mi r3 r9 ROR 8", "mi_r3_r9_ROR_8"},
    {{eq, r1, r5, ROR, 0}, false, al, "eq r1 r5 ROR 0", "eq_r1_r5_ROR_0"},
    {{hi, r12, r11, ROR, 24},
     false,
     al,
     "hi r12 r11 ROR 24",
     "hi_r12_r11_ROR_24"},
    {{eq, r4, r9, ROR, 24}, false, al, "eq r4 r9 ROR 24", "eq_r4_r9_ROR_24"},
    {{pl, r2, r7, ROR, 16}, false, al, "pl r2 r7 ROR 16", "pl_r2_r7_ROR_16"},
    {{mi, r5, r13, ROR, 16}, false, al, "mi r5 r13 ROR 16", "mi_r5_r13_ROR_16"},
    {{vs, r0, r8, ROR, 24}, false, al, "vs r0 r8 ROR 24", "vs_r0_r8_ROR_24"},
    {{eq, r13, r4, ROR, 16}, false, al, "eq r13 r4 ROR 16", "eq_r13_r4_ROR_16"},
    {{gt, r4, r3, ROR, 16}, false, al, "gt r4 r3 ROR 16", "gt_r4_r3_ROR_16"},
    {{lt, r11, r7, ROR, 8}, false, al, "lt r11 r7 ROR 8", "lt_r11_r7_ROR_8"},
    {{lt, r11, r1, ROR, 24}, false, al, "lt r11 r1 ROR 24", "lt_r11_r1_ROR_24"},
    {{ne, r0, r9, ROR, 0}, false, al, "ne r0 r9 ROR 0", "ne_r0_r9_ROR_0"},
    {{al, r8, r12, ROR, 16}, false, al, "al r8 r12 ROR 16", "al_r8_r12_ROR_16"},
    {{cc, r5, r5, ROR, 16}, false, al, "cc r5 r5 ROR 16", "cc_r5_r5_ROR_16"},
    {{le, r5, r10, ROR, 24}, false, al, "le r5 r10 ROR 24", "le_r5_r10_ROR_24"},
    {{lt, r4, r13, ROR, 16}, false, al, "lt r4 r13 ROR 16", "lt_r4_r13_ROR_16"},
    {{hi, r14, r1, ROR, 16}, false, al, "hi r14 r1 ROR 16", "hi_r14_r1_ROR_16"},
    {{cs, r12, r7, ROR, 0}, false, al, "cs r12 r7 ROR 0", "cs_r12_r7_ROR_0"},
    {{mi, r4, r2, ROR, 0}, false, al, "mi r4 r2 ROR 0", "mi_r4_r2_ROR_0"},
    {{al, r8, r11, ROR, 24}, false, al, "al r8 r11 ROR 24", "al_r8_r11_ROR_24"},
    {{vs, r3, r2, ROR, 0}, false, al, "vs r3 r2 ROR 0", "vs_r3_r2_ROR_0"},
    {{eq, r13, r10, ROR, 16},
     false,
     al,
     "eq r13 r10 ROR 16",
     "eq_r13_r10_ROR_16"},
    {{vc, r14, r13, ROR, 24},
     false,
     al,
     "vc r14 r13 ROR 24",
     "vc_r14_r13_ROR_24"},
    {{ge, r14, r5, ROR, 0}, false, al, "ge r14 r5 ROR 0", "ge_r14_r5_ROR_0"},
    {{mi, r8, r6, ROR, 8}, false, al, "mi r8 r6 ROR 8", "mi_r8_r6_ROR_8"},
    {{hi, r1, r11, ROR, 24}, false, al, "hi r1 r11 ROR 24", "hi_r1_r11_ROR_24"},
    {{vs, r9, r14, ROR, 0}, false, al, "vs r9 r14 ROR 0", "vs_r9_r14_ROR_0"},
    {{le, r0, r11, ROR, 8}, false, al, "le r0 r11 ROR 8", "le_r0_r11_ROR_8"},
    {{le, r3, r4, ROR, 16}, false, al, "le r3 r4 ROR 16", "le_r3_r4_ROR_16"},
    {{vc, r1, r10, ROR, 16}, false, al, "vc r1 r10 ROR 16", "vc_r1_r10_ROR_16"},
    {{gt, r11, r8, ROR, 8}, false, al, "gt r11 r8 ROR 8", "gt_r11_r8_ROR_8"},
    {{lt, r10, r3, ROR, 24}, false, al, "lt r10 r3 ROR 24", "lt_r10_r3_ROR_24"},
    {{vs, r13, r6, ROR, 16}, false, al, "vs r13 r6 ROR 16", "vs_r13_r6_ROR_16"},
    {{pl, r11, r9, ROR, 0}, false, al, "pl r11 r9 ROR 0", "pl_r11_r9_ROR_0"},
    {{pl, r4, r12, ROR, 24}, false, al, "pl r4 r12 ROR 24", "pl_r4_r12_ROR_24"},
    {{pl, r14, r8, ROR, 0}, false, al, "pl r14 r8 ROR 0", "pl_r14_r8_ROR_0"},
    {{gt, r3, r12, ROR, 16}, false, al, "gt r3 r12 ROR 16", "gt_r3_r12_ROR_16"},
    {{le, r0, r6, ROR, 8}, false, al, "le r0 r6 ROR 8", "le_r0_r6_ROR_8"},
    {{hi, r11, r2, ROR, 24}, false, al, "hi r11 r2 ROR 24", "hi_r11_r2_ROR_24"},
    {{al, r5, r11, ROR, 24}, false, al, "al r5 r11 ROR 24", "al_r5_r11_ROR_24"},
    {{vs, r9, r9, ROR, 8}, false, al, "vs r9 r9 ROR 8", "vs_r9_r9_ROR_8"},
    {{cc, r7, r11, ROR, 0}, false, al, "cc r7 r11 ROR 0", "cc_r7_r11_ROR_0"},
    {{vc, r10, r9, ROR, 0}, false, al, "vc r10 r9 ROR 0", "vc_r10_r9_ROR_0"},
    {{ge, r10, r6, ROR, 0}, false, al, "ge r10 r6 ROR 0", "ge_r10_r6_ROR_0"},
    {{le, r7, r11, ROR, 24}, false, al, "le r7 r11 ROR 24", "le_r7_r11_ROR_24"},
    {{cc, r6, r5, ROR, 8}, false, al, "cc r6 r5 ROR 8", "cc_r6_r5_ROR_8"},
    {{eq, r5, r10, ROR, 24}, false, al, "eq r5 r10 ROR 24", "eq_r5_r10_ROR_24"},
    {{hi, r3, r2, ROR, 8}, false, al, "hi r3 r2 ROR 8", "hi_r3_r2_ROR_8"},
    {{vs, r13, r5, ROR, 16}, false, al, "vs r13 r5 ROR 16", "vs_r13_r5_ROR_16"},
    {{cc, r13, r12, ROR, 0}, false, al, "cc r13 r12 ROR 0", "cc_r13_r12_ROR_0"},
    {{ge, r3, r6, ROR, 16}, false, al, "ge r3 r6 ROR 16", "ge_r3_r6_ROR_16"},
    {{mi, r11, r1, ROR, 0}, false, al, "mi r11 r1 ROR 0", "mi_r11_r1_ROR_0"},
    {{ge, r2, r3, ROR, 0}, false, al, "ge r2 r3 ROR 0", "ge_r2_r3_ROR_0"},
    {{hi, r0, r0, ROR, 24}, false, al, "hi r0 r0 ROR 24", "hi_r0_r0_ROR_24"},
    {{ne, r12, r8, ROR, 8}, false, al, "ne r12 r8 ROR 8", "ne_r12_r8_ROR_8"},
    {{mi, r4, r11, ROR, 8}, false, al, "mi r4 r11 ROR 8", "mi_r4_r11_ROR_8"},
    {{gt, r10, r14, ROR, 16},
     false,
     al,
     "gt r10 r14 ROR 16",
     "gt_r10_r14_ROR_16"},
    {{pl, r9, r10, ROR, 16}, false, al, "pl r9 r10 ROR 16", "pl_r9_r10_ROR_16"},
    {{mi, r1, r2, ROR, 8}, false, al, "mi r1 r2 ROR 8", "mi_r1_r2_ROR_8"},
    {{vs, r1, r8, ROR, 16}, false, al, "vs r1 r8 ROR 16", "vs_r1_r8_ROR_16"},
    {{gt, r0, r12, ROR, 0}, false, al, "gt r0 r12 ROR 0", "gt_r0_r12_ROR_0"},
    {{ls, r13, r6, ROR, 8}, false, al, "ls r13 r6 ROR 8", "ls_r13_r6_ROR_8"},
    {{vs, r11, r0, ROR, 0}, false, al, "vs r11 r0 ROR 0", "vs_r11_r0_ROR_0"},
    {{cs, r4, r12, ROR, 8}, false, al, "cs r4 r12 ROR 8", "cs_r4_r12_ROR_8"},
    {{cs, r13, r6, ROR, 8}, false, al, "cs r13 r6 ROR 8", "cs_r13_r6_ROR_8"},
    {{eq, r11, r3, ROR, 24}, false, al, "eq r11 r3 ROR 24", "eq_r11_r3_ROR_24"},
    {{ls, r9, r14, ROR, 24}, false, al, "ls r9 r14 ROR 24", "ls_r9_r14_ROR_24"},
    {{eq, r6, r8, ROR, 0}, false, al, "eq r6 r8 ROR 0", "eq_r6_r8_ROR_0"},
    {{hi, r9, r4, ROR, 16}, false, al, "hi r9 r4 ROR 16", "hi_r9_r4_ROR_16"},
    {{vc, r8, r12, ROR, 16}, false, al, "vc r8 r12 ROR 16", "vc_r8_r12_ROR_16"},
    {{lt, r1, r13, ROR, 24}, false, al, "lt r1 r13 ROR 24", "lt_r1_r13_ROR_24"},
    {{ge, r1, r8, ROR, 16}, false, al, "ge r1 r8 ROR 16", "ge_r1_r8_ROR_16"},
    {{vs, r3, r9, ROR, 24}, false, al, "vs r3 r9 ROR 24", "vs_r3_r9_ROR_24"},
    {{cc, r6, r11, ROR, 0}, false, al, "cc r6 r11 ROR 0", "cc_r6_r11_ROR_0"},
    {{al, r5, r10, ROR, 16}, false, al, "al r5 r10 ROR 16", "al_r5_r10_ROR_16"},
    {{ge, r1, r6, ROR, 8}, false, al, "ge r1 r6 ROR 8", "ge_r1_r6_ROR_8"},
    {{ge, r1, r4, ROR, 24}, false, al, "ge r1 r4 ROR 24", "ge_r1_r4_ROR_24"},
    {{hi, r9, r9, ROR, 0}, false, al, "hi r9 r9 ROR 0", "hi_r9_r9_ROR_0"},
    {{cs, r2, r13, ROR, 0}, false, al, "cs r2 r13 ROR 0", "cs_r2_r13_ROR_0"},
    {{gt, r8, r5, ROR, 24}, false, al, "gt r8 r5 ROR 24", "gt_r8_r5_ROR_24"},
    {{le, r7, r2, ROR, 0}, false, al, "le r7 r2 ROR 0", "le_r7_r2_ROR_0"},
    {{hi, r3, r13, ROR, 0}, false, al, "hi r3 r13 ROR 0", "hi_r3_r13_ROR_0"},
    {{ne, r11, r12, ROR, 24},
     false,
     al,
     "ne r11 r12 ROR 24",
     "ne_r11_r12_ROR_24"},
    {{gt, r8, r1, ROR, 24}, false, al, "gt r8 r1 ROR 24", "gt_r8_r1_ROR_24"},
    {{le, r1, r10, ROR, 8}, false, al, "le r1 r10 ROR 8", "le_r1_r10_ROR_8"},
    {{mi, r14, r3, ROR, 16}, false, al, "mi r14 r3 ROR 16", "mi_r14_r3_ROR_16"},
    {{al, r0, r9, ROR, 16}, false, al, "al r0 r9 ROR 16", "al_r0_r9_ROR_16"},
    {{vs, r10, r3, ROR, 24}, false, al, "vs r10 r3 ROR 24", "vs_r10_r3_ROR_24"},
    {{le, r8, r0, ROR, 0}, false, al, "le r8 r0 ROR 0", "le_r8_r0_ROR_0"},
    {{vs, r3, r0, ROR, 16}, false, al, "vs r3 r0 ROR 16", "vs_r3_r0_ROR_16"},
    {{ne, r2, r6, ROR, 8}, false, al, "ne r2 r6 ROR 8", "ne_r2_r6_ROR_8"},
    {{al, r8, r4, ROR, 24}, false, al, "al r8 r4 ROR 24", "al_r8_r4_ROR_24"},
    {{pl, r1, r4, ROR, 24}, false, al, "pl r1 r4 ROR 24", "pl_r1_r4_ROR_24"},
    {{hi, r2, r10, ROR, 8}, false, al, "hi r2 r10 ROR 8", "hi_r2_r10_ROR_8"},
    {{eq, r4, r9, ROR, 0}, false, al, "eq r4 r9 ROR 0", "eq_r4_r9_ROR_0"},
    {{hi, r5, r2, ROR, 24}, false, al, "hi r5 r2 ROR 24", "hi_r5_r2_ROR_24"},
    {{pl, r10, r13, ROR, 16},
     false,
     al,
     "pl r10 r13 ROR 16",
     "pl_r10_r13_ROR_16"},
    {{ge, r14, r8, ROR, 16}, false, al, "ge r14 r8 ROR 16", "ge_r14_r8_ROR_16"},
    {{gt, r0, r10, ROR, 0}, false, al, "gt r0 r10 ROR 0", "gt_r0_r10_ROR_0"},
    {{ne, r12, r3, ROR, 16}, false, al, "ne r12 r3 ROR 16", "ne_r12_r3_ROR_16"},
    {{ne, r5, r12, ROR, 8}, false, al, "ne r5 r12 ROR 8", "ne_r5_r12_ROR_8"},
    {{vc, r0, r4, ROR, 8}, false, al, "vc r0 r4 ROR 8", "vc_r0_r4_ROR_8"},
    {{le, r10, r2, ROR, 24}, false, al, "le r10 r2 ROR 24", "le_r10_r2_ROR_24"},
    {{vc, r3, r2, ROR, 16}, false, al, "vc r3 r2 ROR 16", "vc_r3_r2_ROR_16"},
    {{ge, r3, r11, ROR, 0}, false, al, "ge r3 r11 ROR 0", "ge_r3_r11_ROR_0"},
    {{ne, r1, r0, ROR, 24}, false, al, "ne r1 r0 ROR 24", "ne_r1_r0_ROR_24"},
    {{lt, r8, r5, ROR, 8}, false, al, "lt r8 r5 ROR 8", "lt_r8_r5_ROR_8"},
    {{ne, r6, r5, ROR, 0}, false, al, "ne r6 r5 ROR 0", "ne_r6_r5_ROR_0"},
    {{gt, r8, r0, ROR, 24}, false, al, "gt r8 r0 ROR 24", "gt_r8_r0_ROR_24"},
    {{pl, r13, r11, ROR, 24},
     false,
     al,
     "pl r13 r11 ROR 24",
     "pl_r13_r11_ROR_24"},
    {{ne, r5, r14, ROR, 16}, false, al, "ne r5 r14 ROR 16", "ne_r5_r14_ROR_16"},
    {{cc, r1, r7, ROR, 24}, false, al, "cc r1 r7 ROR 24", "cc_r1_r7_ROR_24"},
    {{ge, r9, r10, ROR, 8}, false, al, "ge r9 r10 ROR 8", "ge_r9_r10_ROR_8"},
    {{vc, r7, r3, ROR, 8}, false, al, "vc r7 r3 ROR 8", "vc_r7_r3_ROR_8"},
    {{eq, r7, r1, ROR, 16}, false, al, "eq r7 r1 ROR 16", "eq_r7_r1_ROR_16"},
    {{gt, r3, r2, ROR, 16}, false, al, "gt r3 r2 ROR 16", "gt_r3_r2_ROR_16"},
    {{mi, r13, r11, ROR, 0}, false, al, "mi r13 r11 ROR 0", "mi_r13_r11_ROR_0"},
    {{lt, r2, r5, ROR, 16}, false, al, "lt r2 r5 ROR 16", "lt_r2_r5_ROR_16"},
    {{gt, r3, r14, ROR, 16}, false, al, "gt r3 r14 ROR 16", "gt_r3_r14_ROR_16"},
    {{eq, r12, r11, ROR, 24},
     false,
     al,
     "eq r12 r11 ROR 24",
     "eq_r12_r11_ROR_24"},
    {{lt, r1, r1, ROR, 8}, false, al, "lt r1 r1 ROR 8", "lt_r1_r1_ROR_8"},
    {{al, r1, r9, ROR, 0}, false, al, "al r1 r9 ROR 0", "al_r1_r9_ROR_0"},
    {{ls, r6, r6, ROR, 16}, false, al, "ls r6 r6 ROR 16", "ls_r6_r6_ROR_16"},
    {{ls, r9, r4, ROR, 0}, false, al, "ls r9 r4 ROR 0", "ls_r9_r4_ROR_0"},
    {{cs, r3, r3, ROR, 0}, false, al, "cs r3 r3 ROR 0", "cs_r3_r3_ROR_0"},
    {{ne, r8, r6, ROR, 24}, false, al, "ne r8 r6 ROR 24", "ne_r8_r6_ROR_24"},
    {{eq, r6, r9, ROR, 8}, false, al, "eq r6 r9 ROR 8", "eq_r6_r9_ROR_8"},
    {{ls, r6, r6, ROR, 8}, false, al, "ls r6 r6 ROR 8", "ls_r6_r6_ROR_8"},
    {{al, r8, r5, ROR, 8}, false, al, "al r8 r5 ROR 8", "al_r8_r5_ROR_8"},
    {{mi, r12, r8, ROR, 8}, false, al, "mi r12 r8 ROR 8", "mi_r12_r8_ROR_8"},
    {{le, r1, r8, ROR, 16}, false, al, "le r1 r8 ROR 16", "le_r1_r8_ROR_16"},
    {{cc, r9, r7, ROR, 16}, false, al, "cc r9 r7 ROR 16", "cc_r9_r7_ROR_16"},
    {{ne, r1, r14, ROR, 0}, false, al, "ne r1 r14 ROR 0", "ne_r1_r14_ROR_0"},
    {{cc, r10, r13, ROR, 24},
     false,
     al,
     "cc r10 r13 ROR 24",
     "cc_r10_r13_ROR_24"},
    {{ge, r0, r12, ROR, 16}, false, al, "ge r0 r12 ROR 16", "ge_r0_r12_ROR_16"},
    {{ne, r12, r8, ROR, 0}, false, al, "ne r12 r8 ROR 0", "ne_r12_r8_ROR_0"},
    {{vc, r13, r11, ROR, 0}, false, al, "vc r13 r11 ROR 0", "vc_r13_r11_ROR_0"},
    {{al, r2, r0, ROR, 16}, false, al, "al r2 r0 ROR 16", "al_r2_r0_ROR_16"},
    {{pl, r10, r0, ROR, 24}, false, al, "pl r10 r0 ROR 24", "pl_r10_r0_ROR_24"},
    {{lt, r5, r14, ROR, 16}, false, al, "lt r5 r14 ROR 16", "lt_r5_r14_ROR_16"},
    {{cc, r9, r14, ROR, 8}, false, al, "cc r9 r14 ROR 8", "cc_r9_r14_ROR_8"},
    {{ls, r11, r11, ROR, 24},
     false,
     al,
     "ls r11 r11 ROR 24",
     "ls_r11_r11_ROR_24"},
    {{al, r5, r5, ROR, 0}, false, al, "al r5 r5 ROR 0", "al_r5_r5_ROR_0"},
    {{ge, r9, r1, ROR, 0}, false, al, "ge r9 r1 ROR 0", "ge_r9_r1_ROR_0"},
    {{vs, r10, r12, ROR, 0}, false, al, "vs r10 r12 ROR 0", "vs_r10_r12_ROR_0"},
    {{cs, r7, r9, ROR, 16}, false, al, "cs r7 r9 ROR 16", "cs_r7_r9_ROR_16"},
    {{cc, r2, r8, ROR, 8}, false, al, "cc r2 r8 ROR 8", "cc_r2_r8_ROR_8"},
    {{lt, r0, r7, ROR, 0}, false, al, "lt r0 r7 ROR 0", "lt_r0_r7_ROR_0"},
    {{cs, r4, r8, ROR, 16}, false, al, "cs r4 r8 ROR 16", "cs_r4_r8_ROR_16"},
    {{al, r11, r5, ROR, 24}, false, al, "al r11 r5 ROR 24", "al_r11_r5_ROR_24"},
    {{vc, r6, r3, ROR, 8}, false, al, "vc r6 r3 ROR 8", "vc_r6_r3_ROR_8"},
    {{cc, r14, r10, ROR, 16},
     false,
     al,
     "cc r14 r10 ROR 16",
     "cc_r14_r10_ROR_16"},
    {{mi, r5, r4, ROR, 8}, false, al, "mi r5 r4 ROR 8", "mi_r5_r4_ROR_8"},
    {{lt, r6, r6, ROR, 16}, false, al, "lt r6 r6 ROR 16", "lt_r6_r6_ROR_16"},
    {{ge, r6, r12, ROR, 24}, false, al, "ge r6 r12 ROR 24", "ge_r6_r12_ROR_24"},
    {{mi, r11, r2, ROR, 0}, false, al, "mi r11 r2 ROR 0", "mi_r11_r2_ROR_0"},
    {{cs, r13, r5, ROR, 8}, false, al, "cs r13 r5 ROR 8", "cs_r13_r5_ROR_8"},
    {{cc, r2, r1, ROR, 16}, false, al, "cc r2 r1 ROR 16", "cc_r2_r1_ROR_16"},
    {{eq, r9, r12, ROR, 24}, false, al, "eq r9 r12 ROR 24", "eq_r9_r12_ROR_24"},
    {{al, r9, r4, ROR, 8}, false, al, "al r9 r4 ROR 8", "al_r9_r4_ROR_8"},
    {{ne, r12, r4, ROR, 8}, false, al, "ne r12 r4 ROR 8", "ne_r12_r4_ROR_8"},
    {{cs, r2, r10, ROR, 24}, false, al, "cs r2 r10 ROR 24", "cs_r2_r10_ROR_24"},
    {{hi, r10, r5, ROR, 8}, false, al, "hi r10 r5 ROR 8", "hi_r10_r5_ROR_8"},
    {{ne, r5, r12, ROR, 16}, false, al, "ne r5 r12 ROR 16", "ne_r5_r12_ROR_16"},
    {{vc, r4, r9, ROR, 16}, false, al, "vc r4 r9 ROR 16", "vc_r4_r9_ROR_16"},
    {{pl, r13, r7, ROR, 16}, false, al, "pl r13 r7 ROR 16", "pl_r13_r7_ROR_16"},
    {{ne, r6, r0, ROR, 8}, false, al, "ne r6 r0 ROR 8", "ne_r6_r0_ROR_8"},
    {{hi, r7, r9, ROR, 16}, false, al, "hi r7 r9 ROR 16", "hi_r7_r9_ROR_16"},
    {{vs, r1, r0, ROR, 16}, false, al, "vs r1 r0 ROR 16", "vs_r1_r0_ROR_16"},
    {{mi, r0, r2, ROR, 0}, false, al, "mi r0 r2 ROR 0", "mi_r0_r2_ROR_0"},
    {{eq, r3, r9, ROR, 8}, false, al, "eq r3 r9 ROR 8", "eq_r3_r9_ROR_8"},
    {{ne, r2, r0, ROR, 8}, false, al, "ne r2 r0 ROR 8", "ne_r2_r0_ROR_8"},
    {{ge, r7, r12, ROR, 16}, false, al, "ge r7 r12 ROR 16", "ge_r7_r12_ROR_16"},
    {{mi, r2, r3, ROR, 8}, false, al, "mi r2 r3 ROR 8", "mi_r2_r3_ROR_8"},
    {{hi, r12, r11, ROR, 0}, false, al, "hi r12 r11 ROR 0", "hi_r12_r11_ROR_0"},
    {{ge, r10, r0, ROR, 24}, false, al, "ge r10 r0 ROR 24", "ge_r10_r0_ROR_24"},
    {{cc, r13, r6, ROR, 24}, false, al, "cc r13 r6 ROR 24", "cc_r13_r6_ROR_24"},
    {{vc, r9, r5, ROR, 16}, false, al, "vc r9 r5 ROR 16", "vc_r9_r5_ROR_16"},
    {{ge, r10, r0, ROR, 16}, false, al, "ge r10 r0 ROR 16", "ge_r10_r0_ROR_16"},
    {{ge, r5, r6, ROR, 24}, false, al, "ge r5 r6 ROR 24", "ge_r5_r6_ROR_24"},
    {{al, r4, r1, ROR, 8}, false, al, "al r4 r1 ROR 8", "al_r4_r1_ROR_8"},
    {{le, r11, r0, ROR, 0}, false, al, "le r11 r0 ROR 0", "le_r11_r0_ROR_0"},
    {{pl, r4, r0, ROR, 16}, false, al, "pl r4 r0 ROR 16", "pl_r4_r0_ROR_16"},
    {{le, r6, r8, ROR, 0}, false, al, "le r6 r8 ROR 0", "le_r6_r8_ROR_0"},
    {{pl, r14, r7, ROR, 0}, false, al, "pl r14 r7 ROR 0", "pl_r14_r7_ROR_0"},
    {{vs, r8, r1, ROR, 0}, false, al, "vs r8 r1 ROR 0", "vs_r8_r1_ROR_0"},
    {{gt, r14, r7, ROR, 0}, false, al, "gt r14 r7 ROR 0", "gt_r14_r7_ROR_0"},
    {{mi, r10, r10, ROR, 16},
     false,
     al,
     "mi r10 r10 ROR 16",
     "mi_r10_r10_ROR_16"},
    {{vs, r4, r2, ROR, 16}, false, al, "vs r4 r2 ROR 16", "vs_r4_r2_ROR_16"},
    {{ls, r12, r4, ROR, 16}, false, al, "ls r12 r4 ROR 16", "ls_r12_r4_ROR_16"},
    {{cs, r13, r0, ROR, 0}, false, al, "cs r13 r0 ROR 0", "cs_r13_r0_ROR_0"},
    {{mi, r13, r6, ROR, 8}, false, al, "mi r13 r6 ROR 8", "mi_r13_r6_ROR_8"},
    {{al, r2, r1, ROR, 0}, false, al, "al r2 r1 ROR 0", "al_r2_r1_ROR_0"},
    {{pl, r6, r1, ROR, 8}, false, al, "pl r6 r1 ROR 8", "pl_r6_r1_ROR_8"},
    {{vs, r9, r11, ROR, 24}, false, al, "vs r9 r11 ROR 24", "vs_r9_r11_ROR_24"},
    {{al, r9, r9, ROR, 16}, false, al, "al r9 r9 ROR 16", "al_r9_r9_ROR_16"},
    {{cs, r4, r11, ROR, 24}, false, al, "cs r4 r11 ROR 24", "cs_r4_r11_ROR_24"},
    {{ne, r8, r14, ROR, 16}, false, al, "ne r8 r14 ROR 16", "ne_r8_r14_ROR_16"},
    {{eq, r14, r10, ROR, 24},
     false,
     al,
     "eq r14 r10 ROR 24",
     "eq_r14_r10_ROR_24"},
    {{cs, r5, r11, ROR, 16}, false, al, "cs r5 r11 ROR 16", "cs_r5_r11_ROR_16"},
    {{mi, r7, r9, ROR, 24}, false, al, "mi r7 r9 ROR 24", "mi_r7_r9_ROR_24"},
    {{hi, r2, r10, ROR, 16}, false, al, "hi r2 r10 ROR 16", "hi_r2_r10_ROR_16"},
    {{gt, r11, r9, ROR, 24}, false, al, "gt r11 r9 ROR 24", "gt_r11_r9_ROR_24"},
    {{vc, r6, r13, ROR, 0}, false, al, "vc r6 r13 ROR 0", "vc_r6_r13_ROR_0"},
    {{le, r10, r11, ROR, 8}, false, al, "le r10 r11 ROR 8", "le_r10_r11_ROR_8"},
    {{cc, r4, r0, ROR, 0}, false, al, "cc r4 r0 ROR 0", "cc_r4_r0_ROR_0"},
    {{eq, r2, r8, ROR, 0}, false, al, "eq r2 r8 ROR 0", "eq_r2_r8_ROR_0"},
    {{gt, r9, r8, ROR, 16}, false, al, "gt r9 r8 ROR 16", "gt_r9_r8_ROR_16"},
    {{hi, r0, r9, ROR, 0}, false, al, "hi r0 r9 ROR 0", "hi_r0_r9_ROR_0"},
    {{ls, r14, r9, ROR, 0}, false, al, "ls r14 r9 ROR 0", "ls_r14_r9_ROR_0"},
    {{cs, r14, r0, ROR, 16}, false, al, "cs r14 r0 ROR 16", "cs_r14_r0_ROR_16"},
    {{vs, r3, r7, ROR, 0}, false, al, "vs r3 r7 ROR 0", "vs_r3_r7_ROR_0"},
    {{pl, r3, r6, ROR, 8}, false, al, "pl r3 r6 ROR 8", "pl_r3_r6_ROR_8"},
    {{al, r11, r5, ROR, 8}, false, al, "al r11 r5 ROR 8", "al_r11_r5_ROR_8"},
    {{hi, r13, r8, ROR, 0}, false, al, "hi r13 r8 ROR 0", "hi_r13_r8_ROR_0"},
    {{gt, r8, r9, ROR, 0}, false, al, "gt r8 r9 ROR 0", "gt_r8_r9_ROR_0"},
    {{ne, r8, r4, ROR, 24}, false, al, "ne r8 r4 ROR 24", "ne_r8_r4_ROR_24"},
    {{ls, r11, r14, ROR, 8}, false, al, "ls r11 r14 ROR 8", "ls_r11_r14_ROR_8"},
    {{ls, r6, r7, ROR, 8}, false, al, "ls r6 r7 ROR 8", "ls_r6_r7_ROR_8"},
    {{ge, r9, r6, ROR, 24}, false, al, "ge r9 r6 ROR 24", "ge_r9_r6_ROR_24"},
    {{le, r13, r14, ROR, 8}, false, al, "le r13 r14 ROR 8", "le_r13_r14_ROR_8"},
    {{hi, r11, r13, ROR, 8}, false, al, "hi r11 r13 ROR 8", "hi_r11_r13_ROR_8"},
    {{vc, r1, r7, ROR, 24}, false, al, "vc r1 r7 ROR 24", "vc_r1_r7_ROR_24"},
    {{lt, r3, r14, ROR, 8}, false, al, "lt r3 r14 ROR 8", "lt_r3_r14_ROR_8"},
    {{vs, r7, r1, ROR, 8}, false, al, "vs r7 r1 ROR 8", "vs_r7_r1_ROR_8"},
    {{al, r3, r14, ROR, 8}, false, al, "al r3 r14 ROR 8", "al_r3_r14_ROR_8"},
    {{le, r4, r3, ROR, 0}, false, al, "le r4 r3 ROR 0", "le_r4_r3_ROR_0"},
    {{hi, r12, r10, ROR, 0}, false, al, "hi r12 r10 ROR 0", "hi_r12_r10_ROR_0"},
    {{eq, r13, r12, ROR, 24},
     false,
     al,
     "eq r13 r12 ROR 24",
     "eq_r13_r12_ROR_24"},
    {{cc, r1, r1, ROR, 24}, false, al, "cc r1 r1 ROR 24", "cc_r1_r1_ROR_24"},
    {{vc, r7, r1, ROR, 24}, false, al, "vc r7 r1 ROR 24", "vc_r7_r1_ROR_24"},
    {{ne, r2, r3, ROR, 24}, false, al, "ne r2 r3 ROR 24", "ne_r2_r3_ROR_24"},
    {{lt, r10, r12, ROR, 16},
     false,
     al,
     "lt r10 r12 ROR 16",
     "lt_r10_r12_ROR_16"},
    {{mi, r6, r13, ROR, 24}, false, al, "mi r6 r13 ROR 24", "mi_r6_r13_ROR_24"},
    {{cc, r11, r4, ROR, 24}, false, al, "cc r11 r4 ROR 24", "cc_r11_r4_ROR_24"},
    {{vc, r7, r4, ROR, 24}, false, al, "vc r7 r4 ROR 24", "vc_r7_r4_ROR_24"},
    {{pl, r11, r5, ROR, 0}, false, al, "pl r11 r5 ROR 0", "pl_r11_r5_ROR_0"},
    {{vs, r4, r2, ROR, 8}, false, al, "vs r4 r2 ROR 8", "vs_r4_r2_ROR_8"},
    {{gt, r13, r0, ROR, 8}, false, al, "gt r13 r0 ROR 8", "gt_r13_r0_ROR_8"},
    {{ge, r8, r8, ROR, 16}, false, al, "ge r8 r8 ROR 16", "ge_r8_r8_ROR_16"},
    {{hi, r10, r14, ROR, 0}, false, al, "hi r10 r14 ROR 0", "hi_r10_r14_ROR_0"},
    {{al, r7, r0, ROR, 16}, false, al, "al r7 r0 ROR 16", "al_r7_r0_ROR_16"},
    {{lt, r2, r9, ROR, 16}, false, al, "lt r2 r9 ROR 16", "lt_r2_r9_ROR_16"},
    {{cs, r14, r4, ROR, 0}, false, al, "cs r14 r4 ROR 0", "cs_r14_r4_ROR_0"},
    {{lt, r3, r5, ROR, 16}, false, al, "lt r3 r5 ROR 16", "lt_r3_r5_ROR_16"},
    {{vc, r4, r12, ROR, 0}, false, al, "vc r4 r12 ROR 0", "vc_r4_r12_ROR_0"},
    {{hi, r4, r10, ROR, 8}, false, al, "hi r4 r10 ROR 8", "hi_r4_r10_ROR_8"},
    {{vc, r13, r6, ROR, 0}, false, al, "vc r13 r6 ROR 0", "vc_r13_r6_ROR_0"},
    {{vc, r9, r9, ROR, 24}, false, al, "vc r9 r9 ROR 24", "vc_r9_r9_ROR_24"},
    {{lt, r0, r4, ROR, 24}, false, al, "lt r0 r4 ROR 24", "lt_r0_r4_ROR_24"},
    {{cs, r9, r13, ROR, 8}, false, al, "cs r9 r13 ROR 8", "cs_r9_r13_ROR_8"},
    {{al, r2, r13, ROR, 16}, false, al, "al r2 r13 ROR 16", "al_r2_r13_ROR_16"},
    {{vc, r14, r4, ROR, 24}, false, al, "vc r14 r4 ROR 24", "vc_r14_r4_ROR_24"},
    {{cs, r12, r8, ROR, 0}, false, al, "cs r12 r8 ROR 0", "cs_r12_r8_ROR_0"},
    {{hi, r4, r7, ROR, 0}, false, al, "hi r4 r7 ROR 0", "hi_r4_r7_ROR_0"},
    {{cc, r14, r13, ROR, 0}, false, al, "cc r14 r13 ROR 0", "cc_r14_r13_ROR_0"},
    {{gt, r13, r2, ROR, 0}, false, al, "gt r13 r2 ROR 0", "gt_r13_r2_ROR_0"},
    {{al, r3, r14, ROR, 24}, false, al, "al r3 r14 ROR 24", "al_r3_r14_ROR_24"},
    {{vs, r7, r11, ROR, 8}, false, al, "vs r7 r11 ROR 8", "vs_r7_r11_ROR_8"},
    {{eq, r3, r11, ROR, 8}, false, al, "eq r3 r11 ROR 8", "eq_r3_r11_ROR_8"},
    {{lt, r8, r1, ROR, 24}, false, al, "lt r8 r1 ROR 24", "lt_r8_r1_ROR_24"},
    {{ge, r9, r1, ROR, 8}, false, al, "ge r9 r1 ROR 8", "ge_r9_r1_ROR_8"},
    {{ls, r7, r9, ROR, 8}, false, al, "ls r7 r9 ROR 8", "ls_r7_r9_ROR_8"},
    {{pl, r8, r13, ROR, 16}, false, al, "pl r8 r13 ROR 16", "pl_r8_r13_ROR_16"},
    {{lt, r4, r11, ROR, 0}, false, al, "lt r4 r11 ROR 0", "lt_r4_r11_ROR_0"},
    {{vc, r1, r11, ROR, 8}, false, al, "vc r1 r11 ROR 8", "vc_r1_r11_ROR_8"},
    {{eq, r9, r4, ROR, 8}, false, al, "eq r9 r4 ROR 8", "eq_r9_r4_ROR_8"},
    {{le, r0, r11, ROR, 0}, false, al, "le r0 r11 ROR 0", "le_r0_r11_ROR_0"},
    {{eq, r14, r1, ROR, 16}, false, al, "eq r14 r1 ROR 16", "eq_r14_r1_ROR_16"},
    {{ne, r13, r8, ROR, 0}, false, al, "ne r13 r8 ROR 0", "ne_r13_r8_ROR_0"},
    {{eq, r7, r2, ROR, 16}, false, al, "eq r7 r2 ROR 16", "eq_r7_r2_ROR_16"},
    {{ge, r6, r7, ROR, 24}, false, al, "ge r6 r7 ROR 24", "ge_r6_r7_ROR_24"},
    {{gt, r10, r2, ROR, 8}, false, al, "gt r10 r2 ROR 8", "gt_r10_r2_ROR_8"},
    {{le, r13, r2, ROR, 8}, false, al, "le r13 r2 ROR 8", "le_r13_r2_ROR_8"},
    {{lt, r11, r6, ROR, 8}, false, al, "lt r11 r6 ROR 8", "lt_r11_r6_ROR_8"},
    {{ne, r2, r8, ROR, 8}, false, al, "ne r2 r8 ROR 8", "ne_r2_r8_ROR_8"},
    {{lt, r4, r14, ROR, 8}, false, al, "lt r4 r14 ROR 8", "lt_r4_r14_ROR_8"},
    {{vc, r10, r7, ROR, 24}, false, al, "vc r10 r7 ROR 24", "vc_r10_r7_ROR_24"},
    {{eq, r4, r12, ROR, 0}, false, al, "eq r4 r12 ROR 0", "eq_r4_r12_ROR_0"},
    {{lt, r1, r2, ROR, 16}, false, al, "lt r1 r2 ROR 16", "lt_r1_r2_ROR_16"},
    {{gt, r2, r6, ROR, 24}, false, al, "gt r2 r6 ROR 24", "gt_r2_r6_ROR_24"},
    {{cc, r5, r14, ROR, 8}, false, al, "cc r5 r14 ROR 8", "cc_r5_r14_ROR_8"},
    {{eq, r7, r11, ROR, 8}, false, al, "eq r7 r11 ROR 8", "eq_r7_r11_ROR_8"},
    {{gt, r14, r9, ROR, 8}, false, al, "gt r14 r9 ROR 8", "gt_r14_r9_ROR_8"},
    {{vs, r10, r5, ROR, 16}, false, al, "vs r10 r5 ROR 16", "vs_r10_r5_ROR_16"},
    {{eq, r8, r13, ROR, 0}, false, al, "eq r8 r13 ROR 0", "eq_r8_r13_ROR_0"},
    {{gt, r5, r14, ROR, 16}, false, al, "gt r5 r14 ROR 16", "gt_r5_r14_ROR_16"},
    {{ge, r9, r3, ROR, 16}, false, al, "ge r9 r3 ROR 16", "ge_r9_r3_ROR_16"},
    {{hi, r2, r6, ROR, 0}, false, al, "hi r2 r6 ROR 0", "hi_r2_r6_ROR_0"},
    {{mi, r3, r1, ROR, 0}, false, al, "mi r3 r1 ROR 0", "mi_r3_r1_ROR_0"},
    {{gt, r14, r6, ROR, 24}, false, al, "gt r14 r6 ROR 24", "gt_r14_r6_ROR_24"},
    {{cs, r0, r11, ROR, 0}, false, al, "cs r0 r11 ROR 0", "cs_r0_r11_ROR_0"},
    {{cc, r2, r8, ROR, 16}, false, al, "cc r2 r8 ROR 16", "cc_r2_r8_ROR_16"},
    {{cc, r8, r4, ROR, 16}, false, al, "cc r8 r4 ROR 16", "cc_r8_r4_ROR_16"},
    {{gt, r6, r6, ROR, 16}, false, al, "gt r6 r6 ROR 16", "gt_r6_r6_ROR_16"},
    {{eq, r8, r3, ROR, 8}, false, al, "eq r8 r3 ROR 8", "eq_r8_r3_ROR_8"},
    {{ne, r12, r8, ROR, 24}, false, al, "ne r12 r8 ROR 24", "ne_r12_r8_ROR_24"},
    {{mi, r10, r2, ROR, 8}, false, al, "mi r10 r2 ROR 8", "mi_r10_r2_ROR_8"},
    {{ls, r1, r5, ROR, 24}, false, al, "ls r1 r5 ROR 24", "ls_r1_r5_ROR_24"},
    {{ge, r3, r14, ROR, 0}, false, al, "ge r3 r14 ROR 0", "ge_r3_r14_ROR_0"},
    {{le, r6, r1, ROR, 16}, false, al, "le r6 r1 ROR 16", "le_r6_r1_ROR_16"},
    {{cc, r8, r2, ROR, 16}, false, al, "cc r8 r2 ROR 16", "cc_r8_r2_ROR_16"},
    {{al, r1, r14, ROR, 16}, false, al, "al r1 r14 ROR 16", "al_r1_r14_ROR_16"},
    {{ge, r12, r5, ROR, 0}, false, al, "ge r12 r5 ROR 0", "ge_r12_r5_ROR_0"},
    {{cs, r1, r9, ROR, 16}, false, al, "cs r1 r9 ROR 16", "cs_r1_r9_ROR_16"},
    {{eq, r8, r2, ROR, 8}, false, al, "eq r8 r2 ROR 8", "eq_r8_r2_ROR_8"},
    {{al, r10, r6, ROR, 16}, false, al, "al r10 r6 ROR 16", "al_r10_r6_ROR_16"},
    {{ge, r5, r12, ROR, 24}, false, al, "ge r5 r12 ROR 24", "ge_r5_r12_ROR_24"},
    {{eq, r4, r13, ROR, 24}, false, al, "eq r4 r13 ROR 24", "eq_r4_r13_ROR_24"},
    {{le, r6, r1, ROR, 8}, false, al, "le r6 r1 ROR 8", "le_r6_r1_ROR_8"},
    {{gt, r13, r10, ROR, 24},
     false,
     al,
     "gt r13 r10 ROR 24",
     "gt_r13_r10_ROR_24"},
    {{lt, r4, r9, ROR, 0}, false, al, "lt r4 r9 ROR 0", "lt_r4_r9_ROR_0"},
    {{ls, r12, r14, ROR, 8}, false, al, "ls r12 r14 ROR 8", "ls_r12_r14_ROR_8"},
    {{cs, r14, r10, ROR, 16},
     false,
     al,
     "cs r14 r10 ROR 16",
     "cs_r14_r10_ROR_16"},
    {{ne, r4, r10, ROR, 0}, false, al, "ne r4 r10 ROR 0", "ne_r4_r10_ROR_0"},
    {{ge, r2, r11, ROR, 16}, false, al, "ge r2 r11 ROR 16", "ge_r2_r11_ROR_16"},
    {{lt, r4, r13, ROR, 0}, false, al, "lt r4 r13 ROR 0", "lt_r4_r13_ROR_0"},
    {{pl, r7, r12, ROR, 0}, false, al, "pl r7 r12 ROR 0", "pl_r7_r12_ROR_0"},
    {{vc, r10, r11, ROR, 0}, false, al, "vc r10 r11 ROR 0", "vc_r10_r11_ROR_0"},
    {{pl, r8, r2, ROR, 24}, false, al, "pl r8 r2 ROR 24", "pl_r8_r2_ROR_24"},
    {{pl, r7, r1, ROR, 16}, false, al, "pl r7 r1 ROR 16", "pl_r7_r1_ROR_16"},
    {{ls, r3, r12, ROR, 24}, false, al, "ls r3 r12 ROR 24", "ls_r3_r12_ROR_24"},
    {{cs, r3, r10, ROR, 16}, false, al, "cs r3 r10 ROR 16", "cs_r3_r10_ROR_16"},
    {{vc, r2, r8, ROR, 24}, false, al, "vc r2 r8 ROR 24", "vc_r2_r8_ROR_24"},
    {{al, r1, r11, ROR, 24}, false, al, "al r1 r11 ROR 24", "al_r1_r11_ROR_24"},
    {{ne, r11, r6, ROR, 16}, false, al, "ne r11 r6 ROR 16", "ne_r11_r6_ROR_16"},
    {{hi, r4, r13, ROR, 8}, false, al, "hi r4 r13 ROR 8", "hi_r4_r13_ROR_8"},
    {{vs, r8, r4, ROR, 24}, false, al, "vs r8 r4 ROR 24", "vs_r8_r4_ROR_24"},
    {{eq, r13, r1, ROR, 0}, false, al, "eq r13 r1 ROR 0", "eq_r13_r1_ROR_0"},
    {{eq, r11, r6, ROR, 24}, false, al, "eq r11 r6 ROR 24", "eq_r11_r6_ROR_24"},
    {{ne, r5, r10, ROR, 0}, false, al, "ne r5 r10 ROR 0", "ne_r5_r10_ROR_0"},
    {{cc, r8, r13, ROR, 16}, false, al, "cc r8 r13 ROR 16", "cc_r8_r13_ROR_16"},
    {{al, r14, r14, ROR, 24},
     false,
     al,
     "al r14 r14 ROR 24",
     "al_r14_r14_ROR_24"},
    {{ge, r9, r2, ROR, 8}, false, al, "ge r9 r2 ROR 8", "ge_r9_r2_ROR_8"},
    {{le, r11, r3, ROR, 24}, false, al, "le r11 r3 ROR 24", "le_r11_r3_ROR_24"},
    {{cs, r14, r10, ROR, 0}, false, al, "cs r14 r10 ROR 0", "cs_r14_r10_ROR_0"},
    {{cs, r12, r11, ROR, 8}, false, al, "cs r12 r11 ROR 8", "cs_r12_r11_ROR_8"},
    {{le, r2, r6, ROR, 0}, false, al, "le r2 r6 ROR 0", "le_r2_r6_ROR_0"},
    {{lt, r3, r10, ROR, 0}, false, al, "lt r3 r10 ROR 0", "lt_r3_r10_ROR_0"},
    {{cs, r13, r4, ROR, 24}, false, al, "cs r13 r4 ROR 24", "cs_r13_r4_ROR_24"},
    {{pl, r14, r12, ROR, 16},
     false,
     al,
     "pl r14 r12 ROR 16",
     "pl_r14_r12_ROR_16"},
    {{gt, r2, r14, ROR, 16}, false, al, "gt r2 r14 ROR 16", "gt_r2_r14_ROR_16"},
    {{vc, r2, r3, ROR, 8}, false, al, "vc r2 r3 ROR 8", "vc_r2_r3_ROR_8"},
    {{ge, r12, r0, ROR, 16}, false, al, "ge r12 r0 ROR 16", "ge_r12_r0_ROR_16"},
    {{ls, r8, r4, ROR, 0}, false, al, "ls r8 r4 ROR 0", "ls_r8_r4_ROR_0"},
    {{ge, r6, r14, ROR, 16}, false, al, "ge r6 r14 ROR 16", "ge_r6_r14_ROR_16"},
    {{ne, r1, r4, ROR, 0}, false, al, "ne r1 r4 ROR 0", "ne_r1_r4_ROR_0"},
    {{le, r8, r10, ROR, 16}, false, al, "le r8 r10 ROR 16", "le_r8_r10_ROR_16"},
    {{al, r1, r13, ROR, 16}, false, al, "al r1 r13 ROR 16", "al_r1_r13_ROR_16"},
    {{gt, r6, r12, ROR, 0}, false, al, "gt r6 r12 ROR 0", "gt_r6_r12_ROR_0"},
    {{ls, r11, r5, ROR, 16}, false, al, "ls r11 r5 ROR 16", "ls_r11_r5_ROR_16"},
    {{ls, r12, r4, ROR, 0}, false, al, "ls r12 r4 ROR 0", "ls_r12_r4_ROR_0"},
    {{vc, r1, r12, ROR, 24}, false, al, "vc r1 r12 ROR 24", "vc_r1_r12_ROR_24"},
    {{cs, r2, r11, ROR, 0}, false, al, "cs r2 r11 ROR 0", "cs_r2_r11_ROR_0"},
    {{hi, r6, r10, ROR, 24}, false, al, "hi r6 r10 ROR 24", "hi_r6_r10_ROR_24"},
    {{lt, r13, r10, ROR, 0}, false, al, "lt r13 r10 ROR 0", "lt_r13_r10_ROR_0"},
    {{vc, r6, r14, ROR, 24}, false, al, "vc r6 r14 ROR 24", "vc_r6_r14_ROR_24"},
    {{vc, r1, r5, ROR, 24}, false, al, "vc r1 r5 ROR 24", "vc_r1_r5_ROR_24"},
    {{ne, r9, r9, ROR, 8}, false, al, "ne r9 r9 ROR 8", "ne_r9_r9_ROR_8"},
    {{cs, r7, r2, ROR, 8}, false, al, "cs r7 r2 ROR 8", "cs_r7_r2_ROR_8"},
    {{lt, r5, r9, ROR, 24}, false, al, "lt r5 r9 ROR 24", "lt_r5_r9_ROR_24"},
    {{gt, r13, r0, ROR, 24}, false, al, "gt r13 r0 ROR 24", "gt_r13_r0_ROR_24"},
    {{lt, r10, r7, ROR, 24}, false, al, "lt r10 r7 ROR 24", "lt_r10_r7_ROR_24"},
    {{pl, r4, r0, ROR, 0}, false, al, "pl r4 r0 ROR 0", "pl_r4_r0_ROR_0"},
    {{vc, r9, r7, ROR, 24}, false, al, "vc r9 r7 ROR 24", "vc_r9_r7_ROR_24"},
    {{hi, r14, r0, ROR, 8}, false, al, "hi r14 r0 ROR 8", "hi_r14_r0_ROR_8"},
    {{mi, r4, r7, ROR, 16}, false, al, "mi r4 r7 ROR 16", "mi_r4_r7_ROR_16"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-operand-rn-ror-amount-sxtb-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-ror-amount-sxtb16-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-ror-amount-sxth-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-ror-amount-uxtb-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-ror-amount-uxtb16-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-ror-amount-uxth-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseA32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    ShiftType ror = kTests[i].operands.ror;
    uint32_t amount = kTests[i].operands.amount;
    Operand op(rn, ror, amount);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RD_OPERAND_RN_ROR_AMOUNT_" #mnemonic "_A32",  \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
