'''
Create Q-Q Plot of two samples quanitiles of randomnly generated data.

'''

import matplotlib.pyplot as plt
import numpy as np

import statsmodels.api as sm
from statsmodels.graphics.gofplots import qqplot_2samples

x = np.random.normal(loc=8.5, scale=2.5, size=37)
y = np.random.normal(loc=8.0, scale=3.0, size=37)
pp_x = sm.ProbPlot(x)
pp_y = sm.ProbPlot(y)
qqplot_2samples(pp_x, pp_y)
plt.show()
