#!/bin/bash

# detect-dead-packages.sh -- show packages no longer present in Debian
#
# This file is part of the forensics-extra.
#
# Copyright 2025 Joao Eriberto Mota Filho <eriberto@debian.org>
#
# You can use this program under the BSD-3-Clause conditions.

####################
### Main program ###
####################

### Check for the right path
[ -e list-of-packages-extra ] || { echo -e "\nI can't find list-of-packages-extra. Aborting.\n"; exit 1; }

# List of packages in local list-of-packages-extra file.
[ -d tmp ] || mkdir tmp
cat list-of-packages-extra | cut -d" " -f1  | egrep '^[a-z0-9]' > tmp/list-of-packages

# Verify the presence of each package
for i in $(cat tmp/list-of-packages)
do
    echo $i;
    apt-cache search $i > /dev/null || \
    echo "The package $i seems missing in Sid." \
    exit 1;
done
    echo -e "\n\nFinished. No errors.\n"
