/** @file importidtech1.h  Importer plugin for id Tech 1 resource formats.
 *
 * @ingroup idtech1converter
 *
 * The IdTech1Converter plugin provides a collection of resource interpreters
 * and import logics for the translation of id Tech 1 format resources (plus
 * derivative formats, such as UDMF).
 *
 * @authors Copyright © 2007-2014 Daniel Swanson <danij@dengine.net>
 *
 * @par License
 * GPL: http://www.gnu.org/licenses/gpl.html
 *
 * <small>This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version. This program is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details. You should have received a copy of the GNU
 * General Public License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA</small>
 */

#ifndef IMPORTIDTECH1_H
#define IMPORTIDTECH1_H

#include "doomsday.h"
#include "mapimporter.h"

DENG_USING_API(Base);
DENG_USING_API(F);
DENG_USING_API(Map);
DENG_USING_API(Material);
DENG_USING_API(MPE);
DENG_USING_API(Uri);

#endif // IMPORTIDTECH1_H
