We’re proud to announce the new bug-fix release of darktable, 5.2.1!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-5.2.1](https://github.com/darktable-org/darktable/releases/tag/release-5.2.1).

To build from source, do not use the autogenerated tarball provided by GitHub on the release page, download our tar.xz file instead. If you're just building for yourself without creating a package for some distribution, then using source code cloning in git is an even more convenient way.

The checksums are:

```
$ sha256sum darktable-5.2.1.tar.xz
53a46cd46ef7118485c4abf4ab407c181639bb8634243ec0ed1f7c1e8299bec6  darktable-5.2.1.tar.xz

$ sha256sum darktable-5.2.1-x86_64.dmg
bdffebcf758cd1ec6d4ee26eb031d52b1d7e4fe8fe000e728edb14bec91f3a35  darktable-5.2.1-x86_64.dmg

$ sha256sum darktable-5.2.1-arm64.dmg
8dabf58b6d76c04800be8ab540d3c2f1e772123279e22629a7396fe3e26273de  darktable-5.2.1-arm64.dmg

$ sha256sum darktable-5.2.1-arm64-13.5.dmg
8b35cff9d926bc4ae08ea88a09a2a45082756548c9f641afad0d785371dcf384  darktable-5.2.1-arm64-13.5.dmg

$ sha256sum darktable-5.2.1-win64.exe
4c1499e9d137efcd87e8b70fb6a0374f7139f1d0f0c49baeac9923ef7df7bdaa  darktable-5.2.1-win64.exe

$ sha256sum Darktable-5.2.1-x86_64.AppImage
294eff1d74d322cc5459221361ac7bdcdf0dc41529a02c165d0861e085978d58  Darktable-5.2.1-x86_64.AppImage
```

When updating from the stable 5.0 series, please bear in mind that your edits will be preserved during this process, but the new library and configuration will no longer be usable with 5.0.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since darktable 5.2.0:

- 74 commits to darktable+rawspeed
- 37 pull requests handled
- 11 issues closed

_Please note that the darktable documentation is not currently complete for release 5.2
and contributions are greatly appreciated. Please see the
[project documentation](https://github.com/darktable-org/dtdocs#contributing)
for more information on how to contribute._

## The Big Ones

The following is a summary of the main features added to darktable
5.2. Please see the user manual for more details of the individual
changes (where available).

- N/A

## UI/UX Improvements

- Reset window position if it can't be placed at last used position on
  any available monitor in a multi-monitor setup.

## Performance Improvements

- N/A

## Other Changes

- Add busy cursor while generating a GPX track preview and a progress
  bar while applying positions from a track to images.

## Bug Fixes

- Fixed translation of snapshot module's labels.

- Expanded width of preference boxes Lua Options so that long input is visible.

- Fixed compilation when OpenMP is disabled.

- Fixed an OpenCL bug in rastermask module for non-raw images.

- Fixed regression introduced in darktable 5.0 with inability to read
  raw files from ancient (over two decades old) Canon cameras that
  recorded raw files with .tiff extension.

- Fixed the inability of external raster masks module to work in
  Windows with PFM files that have Unicode characters in the file
  name.

- Fixed a bug in liquify OpenCL code leading to incorrect clamped
  output.

- Fix color equalizer picker not working in quick access panel.

- Paletted TIFFs were read incorrectly by the main libtiff-based
  loader, with loss of color information. We are now handing them over
  to the GraphicsMagick/ImageMagick fallback loader (usually available
  in official/distro builds) for correct reading.

- The variable names for the metadata tags variables have been changed
  to the full case sensitive tag name to avoid ambiguity.

- Fixed inability to remove collections with ' in the name.

## Lua

### API Version

- API version is now 9.5.0

### New Features

- Added apply_sidecar to dt_lua_image_t so that a sidecar file can be loaded
  and applied to an image in lighttable.

### Bug Fixes

- N/A

### Add action support for Lua

- N/A

### Other Lua changes

- N/A

## Notes

- When exporting to AVIF, EXR, JPEG XL, or XCF, selecting specific
  metadata (e.g. geo-tag or creator) is not currently possible. For
  AVIF, EXR, JPEG XL, and XCF formats, darktable will not include any
  metadata fields unless the user selects all of the checkboxes in the
  export module's preference options.

- Starting with release 4.8, macOS versions older than 13.5 are not
  supported.

## Changed Dependencies

### Mandatory

- N/A

### Optional

- N/A

## RawSpeed changes

- OM Sytem OM-1 Mark II and OM-3 crop was updated for better handling
  of high-resolution raws.

## Camera support, compared to 5.2.0

### Base Support

- Nikon D200 (12bit-compressed)
- Nikon D5300 (12bit-compressed)
- Panasonic DC-GH7 (4:3)
- Samsung GX-1L

### White Balance Presets

- Fujifilm GFX 100 model name fix
- Nikon Z50_2

### Noise Profiles

- Fujifilm GFX100S II
- Panasonic DC-S5M2X
- Pentax *ist D

### Missing Compression Mode Support

- Apple ProRAW DNGs
- CinemaDNG lossless (Blackmagic, some DJI, etc.) and lossy (Blackmagic)
- DNG 1.7 using JPEG XL (Adobe enhanced, Samsung Expert RAW)
- Fujifilm lossy RAFs
- Nikon high efficiency NEFs
- Phase One other than IIQ L
- Sony downsized lossless ARWs ("M" for full-frame, "S" for full-frame & APS-C)

### Suspended Support

Support for the following cameras is suspended because no samples are available on https://raw.pixls.us:

- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm IS-1
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Olympus SP320
- Phase One IQ250
- ST Micro STV680

## Translations

- Czech
- German
- European Spanish
- Finnish
- French
- Hungarian
- Italian
- Japanese
- Korean
- Dutch
- Brazilian Portuguese
- Russian
- Slovenian
- Albanian
- Ukrainian
- Chinese (Simplified)
- Chinese (Traditional)
