#define WIN32_LEAN_AND_MEAN
#define STRICT

//#include <stdlib.h>
#include <windows.h> 

// screen saver package
#include "scrplus.h"

extern "C" {
	// Win95 specific globals
	extern HWND hwnd;      // window handle
	extern HDC hdc;        // device context
	extern HGDIOBJ fgpen;  // current pen color
	extern HBRUSH fgbrush; // current brush color
	extern RECT rc;        // coords of the screen

	void xlockmore_create(void);
	void xlockmore_destroy(void);
	unsigned int xlockmore_scrm_timer(void);
}


// MySaverProc
//   function called by the screen saver library

LRESULT CALLBACK MySaverProc(HWND myhwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg) { 
	case WM_ERASEBKGND: { 
		HDC myhdc=(HDC) wParam; RECT myrc; GetClientRect(myhwnd,&myrc);
        FillRect(myhdc, &myrc, (struct HBRUSH__ *)GetStockObject(BLACK_BRUSH));
		} break;
	case WM_CREATE: {
		hwnd = myhwnd;
		GetClientRect(hwnd, &rc); // get window coords
		hdc = GetDC(hwnd);        // get device context
		fgpen = SelectObject(hdc, 
			CreatePen(PS_SOLID, 0, RGB(255, 255, 255)));

		xlockmore_create();
		} break;
	case WM_DESTROY: {
		xlockmore_destroy();
		DeleteObject(fgpen);
		DeleteObject(fgbrush);
		} break;
	case SCRM_TIMER: {
		return xlockmore_scrm_timer();
		} break;
    }
    return DefScreenSaverProc(myhwnd, msg, wParam, lParam);
}


int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE,LPSTR,int)
{ 
	return ScrExecute(hInstance,MySaverProc);
}
