/* -*- Mode: C; tab-width: 4 -*- */
/* Xapi --- mapped X API calls */

#if !defined( lint ) && !defined( SABER )
static const char sccsid[] = "@(#)Xapi.c	4.07 98/04/16 xlockmore";

#endif

#ifdef WIN32

#include <stdlib.h>
#include <math.h>
#include "xlock.h"

/*-
 *  global variables
 */
HWND hwnd;                         /* window handle */
HDC hdc;                           /* device context */
HGDIOBJ fgpen;                     /* current pen color */
HGDIOBJ fgbrush;                   /* current brush color */
int cred, cgreen, cblue;           /* color reference of the pen */
unsigned char *red, *green, *blue; /* holds a list of colors */
int colorcount;                    /* number of colors used */
unsigned int randommode;           /* number of mode to index */
RECT rc;                           /* coords of the screen */

/* -------------------------------------------------------------------- */

/* the following are functions in UNIX but not WIN32 */

/*-
 *  nice
 */
int nice(int level)
{
	return 1;
}

/*-
 *  sleep
 */
void sleep(int sec)
{
}

/*-
 *  sigmask
 */
int sigmask(int signum)
{
	return 0;
}


/* the following are macros in X, but I have implemented as functions */

/*-
 *  BlackPixel
 *    returns the color cell of Black
 *    NOTE: this is currently set to the end of the color
 *    palette table, 
 */
unsigned long BlackPixel(Display *display, int screen_number)
{
	return colorcount+1;
}

/*-
 *  WhitePixel
 *    returns the color cell of White
 *    NOTE: this is currently set to the end of the color
 *    palette table - 1
 */
unsigned long WhitePixel(Display *display, int screen_number)
{
	return colorcount;
}

/*-
 *  BlackPixelOfScreen
 *    returns the color cell of Black
 *    NOTE: currently is fixed to 1
 */
int BlackPixelOfScreen(Screen *screen)
{
	return 1;
}

/*-
 *  WhitePixelOfScreen
 *    returns the color cell of White
 *    NOTE: currently is fixed to 0
 */
int WhitePixelOfScreen(Screen *screen)
{
	return 0;
}

/*-
 *  CellsOfScreen
 *    returns number of entries the colormap can hold
 */
int CellsOfScreen(Screen *screen)
{
	return colorcount;
}

/*-
 *  DefaultColormap
 *    not currently used, returns 0
 */
Colormap DefaultColormap(Display *display, int screen_number)
{
	return 0;
}

/*-
 *  DefaultColormapOfScreen
 *    not currently used, returns 0
 */
Colormap DefaultColormapOfScreen(Screen *screen)
{
	return 0;
}

/*-
 *  DefaultVisual
 *    not currently used, returns NULL
 */
Visual *DefaultVisual(Display *display, int screen_number)
{
	return NULL;
}

/*-
 *  DisplayPlanes
 *    not currently used, returns 0
 */
int DisplayPlanes(Display *display, int screen_number)
{
	return 0;
}

/*-
 *  DisplayString
 *    not currently used, returns NULL
 */
char *DisplayString(Display *display)
{
	return NULL;
}

/*-
 *  RootWindow
 *    not currently used, returns 0
 */
Window RootWindow(Display *display, int screen_number)
{
	return 0;
}

/*-
 *  ScreenOfDisplay
 *    not currently used, returns NULL
 */
Screen *ScreenOfDisplay(Display *display, int screen_number)
{
	return NULL;
}

/* -------------------------------------------------------------------- */

/* X function mappings */

/*-
 *  XAddHosts
 *    not currently used
 */
void XAddHosts(Display *display, XHostAddress *hosts, int num_hosts)
{
}

/*-
 *  XAllocColor
 *    not currently used
 */
Status XAllocColor(Display *display, Colormap colormap, 
				   XColor *screen_in_out)
{
	return 0;
}

/*-
 *  XAllocNamedColor
 *    not currently used
 */
Status XAllocNamedColor(Display *display, Colormap colormap,
						char *color_name, XColor *screen_def_return,
						XColor *exact_def_return)
{
	return 0;
}

/*-
 *  XBell
 *    not currently used
 */
void XBell(Display *display, int percent)
{
}

/*-
 *  XCheckMaskEvent
 *    not currently used, return True
 */
Bool XCheckMaskEvent(Display *display, long event_mask, 
					 XEvent *event_return)
{
	return True;
}

/*-
 *  XClearWindow
 *    sets the base window/screen to black
 */
void XClearWindow(Display *display, Window w)
{
	FillRect(hdc, &rc, (struct HBRUSH__ *)GetStockObject(BLACK_BRUSH));
}

/*-
 *  XCloseDisplay
 *    not currently used
 */
void XCloseDisplay(Display *display)
{
}

/*-
 *  XConfigureWindow
 *    not currently used
 */
void XConfigureWindow(Display *display, Window w, 
					  unsigned int value_mask, 
					  XWindowChanges *values)
{
}

/*-
 *  XCopyColormapAndFree
 *    not currently used, returns 0
 */
Colormap XCopyColormapAndFree(Display *display, Colormap colormap)
{
	return 0;
}

/*-
 *  XCreateColormap
 *    used to create the colormap
 */
Colormap XCreateColormap(Display *display, Window w, 
						 Visual *visual, int alloc)
{
	return 0;
}

/*-
 *  XCreateFontCursor
 *    not currently used, returns 0
 */
Cursor XCreateFontCursor(Display *display, unsigned int shape)
{
	return 0;
}

/*-
 *  XCreateImage
 *    not currently used, returns NULL
 */
XImage *XCreateImage(Display *display, Visual *visual, 
					 unsigned int depth, int format, int offset,
					 char *data, unsigned int width,
					 unsigned int height, int bitmap_pad,
					 int bytes_per_line)
{
	return NULL;
}

/*-
 *  XDestroyImage
 *    not currently used
 */
void XDestroyImage(XImage *ximage)
{
}

/*-
 *  XDisableAccessControl
 *    not currently used
 */
void XDisableAccessControl(Display *display)
{
}

/*-
 *  XDrawArc
 *    draws an arc
 */
void XDrawArc(Display *display, Drawable d, GC gc, int x, int y,
			  unsigned int width, unsigned int height,
			  int angle1, int angle2)
{
	int xa1, ya1;
	int xa2, ya2;
	int cx, cy;
	double a1, a2;
	double rx, ry;
	double ang_inc = M_PI * 2.0 / 23040.0;

	rx = width/2.0;
	ry = height/2.0;
	cx = x + width/2;
	cy = y + height/2;

	a1 = (23040 - angle1) * ang_inc;
	a2 = (23040 - angle2) * ang_inc;

	xa1 = (int)((rx * cos(a1)) + cx);
	ya1 = (int)((ry * sin(a1)) + cy);
	xa2 = (int)((rx * cos(a2)) + cx);
	ya2 = (int)((ry * sin(a2)) + cy);

	Arc(gc, x, y, x + width, y + height, xa1, ya1, xa2, ya2);
}

/*-
 *  XDrawImageString
 *    not currently used
 */
void XDrawImageString(Display *display, Drawable d, GC gc, 
					  int x, int y, char *string, int length)
{
}

/*-
 *  XDrawLine
 *    draws a line on the screen in the current pen color
 */
void XDrawLine(Display *display, Drawable d, GC gc, 
			   int x1, int y1, int x2, int y2)
{
		MoveToEx(gc, x1, y1, NULL);
		LineTo(gc, x2, y2);
}

/*-
 *  XDrawPoint
 *    draws a point on the screen
 */
void XDrawPoint(Display *display, Drawable d, GC gc, int x, int y)
{
	SetPixelV(gc, x, y, RGB(cred, cgreen, cblue));
}

/*-
 *  XDrawPoints
 *    draws a series of points on the screen. Points may be
 *    specified as being (1) relative to the origin, or 
 *    (2) relative to the previous point (with the first point 
 *    relative to the origin).
 */
void XDrawPoints(Display *display, Drawable d, GC gc, 
				 XPoint *pts, int numpts, int mode)
{
	int i;
	int tx, ty;

	if (mode == CoordModeOrigin) {
		for (i=0; i<numpts; i++) {
			SetPixelV(gc, pts[i].x, pts[i].y, RGB(cred, cgreen, cblue));
		}
	}
	else if (mode == CoordModePrevious) {
		if (numpts > 0) {
			tx = pts[0].x;
			ty = pts[0].y;
			SetPixelV(gc, tx, ty, RGB(cred, cgreen, cblue));
			for (i=1; i<numpts; i++) {
				tx += pts[i].x;
				ty += pts[i].y;
				SetPixelV(gc, tx, ty, RGB(cred, cgreen, cblue));
			}
		}
	}
}

/*-
 *  XDrawString
 *    not currently used
 */
void XDrawString(Display *display, Drawable d, GC gc, int x, int y, 
				 char *string, int length)
{
}

/*-
 *  XEnableAccessControl
 *    not currently used
 */
void XEnableAccessControl(Display *display)
{
}

/*-
 *  XFillArc
 *    draws a filled arc on screen
 */
void XFillArc(Display *display, Drawable d, GC gc, int x, int y,
			  unsigned int width, unsigned int height,
			  int angle1, int angle2)
{
	int xa1, ya1;
	int xa2, ya2;
	int cx, cy;
	double a1, a2;
	double rx, ry;
	double ang_inc = M_PI * 2.0 / 23040.0;

	rx = width/2.0;
	ry = height/2.0;
	cx = x + width/2;
	cy = y + height/2;

	a1 = (23040 - angle1) * ang_inc;
	a2 = (23040 - angle2) * ang_inc;

	xa1 = (int)((rx * cos(a1)) + cx);
	ya1 = (int)((ry * sin(a1)) + cy);
	xa2 = (int)((rx * cos(a2)) + cx);
	ya2 = (int)((ry * sin(a2)) + cy);

	/* should check for a pie or chord filled arc type, but 
	   currently assuming pie filled arc */
	Pie(gc, x, y, x + width, y + height, xa1, ya1, xa2, ya2);
}

/*-
 *  XFillPolygon
 *    draws a filled polygon on screen. Points can be specified as
 *    being relative to the origin, or relative to the previous
 *    point (with the first point relative to the origin)
 */
void XFillPolygon(Display *display, Drawable d, GC gc, XPoint *points,
				  int npoints, int shape, int mode)
{
	int i;
	int tx, ty;
	POINT *pts;

	if (npoints <= 0)
		return;

	/* allocate memory */
	pts = calloc(npoints, sizeof(POINT));

	if (mode == CoordModeOrigin) {
		for (i=0; i<npoints; i++) {
			pts[i].x = points[i].x;
			pts[i].y = points[i].y;
		}
	}
	else  if (mode == CoordModePrevious) {
		tx = pts[0].x = points[0].x;
		ty = pts[0].y = points[0].y;
		for (i=1; i<npoints; i++){
			tx += points[i].x;
			ty += points[i].y;
			pts[i].x = tx;
			pts[i].y = ty;
		}
	}
	
	Polygon(gc, pts, npoints);

	/* free memory */
	free(pts);
}

/*-
 *  XFillRectangle
 *    draws a filled rectangle on screen
 */
void XFillRectangle(Display *display, Drawable d, GC gc, int x, int y, 
					unsigned int width, unsigned int height)
{
	Rectangle(gc, x, y, x + width, y + height);
}

/*-
 *  XFlush
 *    not currently used
 */
void XFlush(Display *display)
{
}

/*-
 *  XFree
 *    not currently used
 */
void XFree(void *data)
{
}

/*-
 *  XFreeColormap
 *    not currently used
 */
void XFreeColormap(Display *display, Colormap colormap)
{
}

/*-
 *  XFreeColors
 *    not currently used
 */
void XFreeColors(Display *display, Colormap colormap, 
				 unsigned long pixels[], int npixels, 
				 unsigned long planes)
{
}

/*-
 *  XGetVisualInfo
 *    not currently used
 */
XVisualInfo *XGetVisualInfo(Display *display, long vinfo_mask,
							XVisualInfo *vinfo_template,
							int *nitems_return)
{
	return NULL;
}

/*-
 *  XGetWindowAttributes
 *    retrieves info about the window
 */
Status XGetWindowAttributes(Display *display, Window w,
							XWindowAttributes *window_attr_return)
{
	memset(window_attr_return, 0, sizeof(XWindowAttributes));

	window_attr_return->width = rc.right;
	window_attr_return->height = rc.bottom;
	window_attr_return->depth = 8; /* incorrect, but we'll set it to 8 */
	window_attr_return->root = hwnd;

	return 0;
}

/*-
 *  XGrabKeyboard
 *    not currently used
 */
int XGrabKeyboard(Display *display, Window grab_window, 
				  Bool owner_events, int pointer_mode,
				  int keyboard_mode, Time time)
{
	return 0;
}

/*-
 *  XGrabPointer
 *    not currently used
 */
int XGrabPointer(Display *display, Window grab_window, Bool owner_events,
				 unsigned int event_mask, int pointer_mode, 
				 int keyboard_mode, Window confine_to, Cursor cursor,
				 Time time)
{
	return 0;
}

/*-
 *  XGrabServer
 *    not currently used
 */
void XGrabServer(Display *display)
{
}

/*-
 *  XInstallColormap
 *    not currently used
 */
void XInstallColormap(Display *display, Colormap colormap)
{
}

/*-
 *  XListHosts
 *    not currently used, returns NULL
 */
XHostAddress *XListHosts(Display *display, int *nhosts_return,
						 Bool *state_return)
{
	return NULL;
}

/*-
 *  XLoadQueryFont
 *    not currently used
 */
XFontStruct *XLoadQueryFont(Display *display, char *name)
{
	return NULL;
}

/*-
 *  XLookupString
 *    not currently used
 */
int XLookupString(XKeyEvent *event_struct, char *buffer_return,
				  int bytes_buffer, KeySym *keysym_return,
				  XComposeStatus *status_in_out)
{
	return 0;
}

/*-
 *  XMapWindow
 *    not currently used
 */
void XMapWindow(Display *display, Window w)
{
}

/*-
 *  XNextEvent
 *    not currently used
 */
void XNextEvent(Display *display, XEvent *event_return)
{
}

/*-
 *  XOpenDisplay
 *    not currently used
 */
Display *XOpenDisplay(char *display_name)
{
	return NULL;
}

/*-
 *  XParseColor
 *    not currently used
 */
Status XParseColor(Display *display, Colormap colormap, 
				   char *spec, XColor *exact_def_return)
{
	return 0;
}

/*-
 *  XPending
 *    not currently used, return 0
 */
int XPending(Display *display)
{
	return 0;
}

/*-
 *  XPutBackEvent
 *    not currently used
 */
void XPutBackEvent(Display *display, XEvent *event)
{
}

/*-
 *  XQueryColor
 *    not currently used
 */
void XQueryColor(Display *display, Colormap colormap, XColor *def_in_out)
{
}

/*-
 *  XRaiseWindow
 *    not currently used
 */
void XRaiseWindow(Display *display, Window w)
{
}

/*-
 *  XRemoveHosts
 *    not currently used
 */
void XRemoveHosts(Display *display, XHostAddress *hosts, int num_hosts)
{
}

/*-
 *  XResourceManagerString
 *    not currently used, return NULL
 */
char *XResourceManagerString(Display *display)
{
	return NULL;
}

/*-
 *  XrmDestroyDatabase
 *    not currently used
 */
void XrmDestroyDatabase(XrmDatabase database)
{
}

/*-
 *  XrmGetFileDatabase
 *    not currently used, return NULL
 */
XrmDatabase XrmGetFileDatabase(char *filename)
{
	return NULL;
}

/*-
 *  XrmGetResource
 *    not currently used, return True
 */
Bool XrmGetResource(XrmDatabase database, char *str_name,
					char *str_class, char **str_type_return, 
					XrmValue *value_return)
{
	return True;
}

/*-
 *  XrmGetFileDatabase
 *    not currently used, return NULL
 */
XrmDatabase XrmGetStringDatabase(char *data)
{
	return NULL;
}

/*-
 *  XrmInitialize
 *    not currently used
 */
void XrmInitialize(void)
{
}

/*-
 *  XrmMergeDatabases
 *    not currently used
 */
void XrmMergeDatabases(XrmDatabase source_db, XrmDatabase *target_db)
{
}

/*-
 *  XrmParseCommand
 *    not currently used
 */
void XrmParseCommand(XrmDatabase *database, XrmOptionDescList table,
					 int table_count, char *name, int *argc_in_out,
					 char **argv_in_out)
{
}

/*-
 *  XSetForeground
 *    sets the color of the current color, forground pen and
 *    brush
 */
void XSetForeground(Display *display, GC gc, unsigned long foreground)
{
	cred = red[foreground];
	cgreen = green[foreground];
	cblue = blue[foreground];
	DeleteObject(fgpen);
	DeleteObject(fgbrush);
	fgpen = SelectObject(gc, 
		CreatePen(PS_SOLID, 0, RGB(cred, cgreen, cblue)));
	fgbrush = SelectObject(gc,
		CreateSolidBrush(RGB(cred, cgreen, cblue)));
}

/*-
 *  XSetLineAttributes
 *    creates a new pen that has the attributes given
 */
void XSetLineAttributes(Display *display, GC gc, 
						unsigned int line_width, int line_style,
						int cap_style, int join_style)
{
	DWORD penstyle;
	LOGBRUSH lb;

	/* set the brush info */
	lb.lbStyle = BS_SOLID;
	lb.lbColor = RGB(cred, cgreen, cblue);
	lb.lbHatch = 0;

	/* set the pen style */
	penstyle = PS_GEOMETRIC;

	switch (line_style) {
	case LineSolid: 
		penstyle |= PS_SOLID; break;
	case LineOnOffDash:
		penstyle |= PS_DASH; break;
	case LineDoubleDash:
		penstyle |= PS_DOT; break;
	}

	switch (cap_style) {
	case CapNotLast:
		penstyle |= PS_ENDCAP_FLAT; break;
	case CapButt:
		penstyle |= PS_ENDCAP_FLAT; break;
	case CapRound:
		penstyle |= PS_ENDCAP_ROUND; break;
	case CapProjecting:
		penstyle |= PS_ENDCAP_SQUARE; break;
	}

	switch (join_style) {
	case JoinMiter:
		penstyle |= PS_JOIN_MITER; break;
	case JoinRound:
		penstyle |= PS_JOIN_ROUND; break;
	case JoinBevel:
		penstyle |= PS_JOIN_BEVEL; break;
	}

	
	DeleteObject(fgpen);
	fgpen = SelectObject(gc,
		ExtCreatePen(penstyle, line_width, &lb, 0, NULL));
}

/*-
 *  XSetScreenSaver
 *    not currently used
 */
void XSetScreenSaver(Display *display, int timeout, int interval,
					 int prefer_blanking, int allow_exposures)
{
}

/*-
 *  XSetWindowColormap
 *    not currently used
 */
void XSetWindowColormap(Display *display, Window w, Colormap colormap)
{
}

/*-
 *  XSetWMName
 *    not currently used
 */
void XSetWMName(Display *display, Window w, XTextProperty *text_prop)
{
}

/*-
 *  XStringListToTextProperty
 *    not currently used
 */
Status XStringListToTextProperty(char **list, int count, 
								 XTextProperty *text_prop_return)
{
	return 0;
}

/*-
 *  XSync
 *    not currently used
 */
void XSync(Display *display, Bool discard)
{
}

/*-
 *  XTextWidth
 *    not currently used, returns 0
 */
int XTextWidth(XFontStruct *font_struct, char *string, int count)
{
	return 0;
}

/*-
 *  XUngrabKeyboard
 *    not currently used
 */
void XUngrabKeyboard(Display *display, Time time)
{
}

/*-
 *  XUngrabPointer
 *    not currently used
 */
void XUngrabPointer(Display *display, Time time)
{
}

/*-
 *  XUngrabServer
 *    not currently used
 */
void XUngrabServer(Display *display)
{
}

/*-
 *  XUnmapWindow
 *    not currently used
 */
void XUnmapWindow(Display *display, Window w)
{
}

#endif /* WIN32 */

/* -------------------------------------------------------------------- */
