(define (hyper n a b)
  (cond ((= n 0) (+ b 1))
        ((= n 1) (+ a b))
        ((= b 1) a)
        ((= n 2) (* a b))
        ((= n 3) (expt a b))
        ((= n 4) (expt a (hyper n a (- b 1))))
        ((> n 4) (hyper (- n 1) a (hyper n a (- b 1))))))

(define (digits n)
  (letrec
    ((d (lambda (c r)
	  (if (> c n)
	      r
	      (d (* 10 c) (+ 1 r))))))
    (d 1 0)))

(if (not (= (hyper 4 3 3) 7625597484987))
    (error "hyper4 3 3 failed"))
(if (not (= (hyper 4 4 3) 13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006084096))
    (error "hyper4 4 3 failed"))
(if (not (= (digits (hyper 4 5 3)) 2185))
    (error "hyper4 5 3 failed"))
;(if (not (= (digits (hyper 4 6 3)) ))
;    (error "hyper4 5 3 failed"))
