% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_rename.R
\name{data_rename}
\alias{data_rename}
\alias{data_rename_rows}
\title{Rename columns and variable names}
\usage{
data_rename(data, select = NULL, replacement = NULL, ...)

data_rename_rows(data, rows = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}), or a
character vector of variable names including ranges specified via \code{:}
(e.g., \code{c("col1:col3", "col5")}),
\item for some functions, like \code{data_select()} or \code{data_rename()}, \code{select} can
be a named character vector. In this case, the names are used to rename
the columns in the output data frame. See 'Details' in the related
functions to see where this option applies.
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with()}, \code{ends_with()},
\code{contains()}, a range using \code{:}, or \code{regex()}. \code{starts_with()},
\code{ends_with()}, and  \code{contains()} accept several patterns, e.g
\code{starts_with("Sep", "Petal")}. \code{regex()} can be used to define regular
expression patterns.
\item a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with()},
\code{-is.numeric} or \code{-(Sepal.Width:Petal.Length)}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{extract_column_names(iris, select = c("Species", "Test"))}
will just return \code{"Species"}.}

\item{replacement}{Character vector. Can be one of the following:
\itemize{
\item A character vector that indicates the new names of the columns selected
in \code{select}. \code{select} and \code{replacement} must be of the same length.
\item A string (i.e. character vector of length 1) with a "glue" styled
pattern. Currently supported tokens are:
\itemize{
\item \code{{col}} which will be replaced by the column name, i.e. the
corresponding value in \code{select}.
\item \code{{n}} will be replaced by the number of the variable that is replaced.
\item \code{{letter}} will be replaced by alphabetical letters in sequential
order.
If more than 26 letters are required, letters are repeated, but have
sequential numeric indices (e.g., \code{a1} to \code{z1}, followed by \code{a2} to
\code{z2}).
\item Finally, the name of a user-defined object that is available in the
environment can be used. Note that the object's name is not allowed to
be one of the pre-defined tokens, \code{"col"}, \code{"n"} and \code{"letter"}.
}

An example for the use of tokens is...

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data_rename(
  mtcars,
  select = c("am", "vs"),
  replacement = "new_name_from_\{col\}"
)
}\if{html}{\out{</div>}}

... which would return new column names \code{new_name_from_am} and
\code{new_name_from_vs}. See 'Examples'.
}

If \code{select} is a named vector, \code{replacement} is ignored.}

\item{...}{Other arguments passed to or from other functions.}

\item{rows}{Vector of row names.}
}
\value{
A modified data frame.
}
\description{
Safe and intuitive functions to rename variables or rows in
data frames. \code{data_rename()} will rename column names, i.e. it facilitates
renaming variables. \code{data_rename_rows()} is a convenient shortcut
to add or rename row names of a data frame, but unlike \code{row.names()}, its
input and output is a data frame, thus, integrating smoothly into a
possible pipe-workflow.
}
\details{
\code{select} can also be a named character vector. In this case, the names are
used to rename the columns in the output data frame. If you have a named
list, use \code{unlist()} to convert it to a named vector. See 'Examples'.
}
\examples{
# Rename columns
head(data_rename(iris, "Sepal.Length", "length"))

# Use named vector to rename
head(data_rename(iris, c(length = "Sepal.Length", width = "Sepal.Width")))

# Change all
head(data_rename(iris, replacement = paste0("Var", 1:5)))

# Use glue-styled patterns
head(data_rename(mtcars[1:3], c("mpg", "cyl", "disp"), "formerly_{col}"))
head(data_rename(mtcars[1:3], c("mpg", "cyl", "disp"), "{col}_is_column_{n}"))
head(data_rename(mtcars[1:3], c("mpg", "cyl", "disp"), "new_{letter}"))

# User-defined glue-styled patterns from objects in environment
x <- c("hi", "there", "!")
head(data_rename(mtcars[1:3], c("mpg", "cyl", "disp"), "col_{x}"))
}
\seealso{
\itemize{
\item Add a prefix or suffix to column names: \code{\link[=data_addprefix]{data_addprefix()}}, \code{\link[=data_addsuffix]{data_addsuffix()}}
\item Functions to reorder or remove columns: \code{\link[=data_reorder]{data_reorder()}}, \code{\link[=data_relocate]{data_relocate()}},
\code{\link[=data_remove]{data_remove()}}
\item Functions to reshape, pivot or rotate data frames: \code{\link[=data_to_long]{data_to_long()}},
\code{\link[=data_to_wide]{data_to_wide()}}, \code{\link[=data_rotate]{data_rotate()}}
\item Functions to recode data: \code{\link[=rescale]{rescale()}}, \code{\link[=reverse]{reverse()}}, \code{\link[=categorize]{categorize()}},
\code{\link[=recode_values]{recode_values()}}, \code{\link[=slide]{slide()}}
\item Functions to standardize, normalize, rank-transform: \code{\link[=center]{center()}}, \code{\link[=standardize]{standardize()}},
\code{\link[=normalize]{normalize()}}, \code{\link[=ranktransform]{ranktransform()}}, \code{\link[=winsorize]{winsorize()}}
\item Split and merge data frames: \code{\link[=data_partition]{data_partition()}}, \code{\link[=data_merge]{data_merge()}}
\item Functions to find or select columns: \code{\link[=data_select]{data_select()}}, \code{\link[=extract_column_names]{extract_column_names()}}
\item Functions to filter rows: \code{\link[=data_match]{data_match()}}, \code{\link[=data_filter]{data_filter()}}
}
}
