# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessControlRulesMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify whether the access control rules are in Audit mode, in
    Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
    """

    AUDIT = "Audit"
    ENFORCE = "Enforce"
    DISABLED = "Disabled"


class AccessLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Access Level, accepted values include None, Read, Write."""

    NONE = "None"
    READ = "Read"
    WRITE = "Write"


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AggregatedReplicationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This is the aggregated replication status based on all the regional replication status flags."""

    UNKNOWN = "Unknown"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    FAILED = "Failed"


class AllocationStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the allocation strategy for the virtual machine scale set based on which the VMs will
    be allocated.
    """

    LOWEST_PRICE = "LowestPrice"
    CAPACITY_OPTIMIZED = "CapacityOptimized"
    PRIORITIZED = "Prioritized"


class AlternativeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the type of the alternative option."""

    NONE = "None"
    OFFER = "Offer"
    PLAN = "Plan"


class Architecture(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CPU architecture supported by an OS disk."""

    X64 = "x64"
    ARM64 = "Arm64"


class ArchitectureTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the Architecture Type."""

    X64 = "x64"
    ARM64 = "Arm64"


class AvailabilityPolicyDiskDelay(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines on how to handle disks with slow I/O."""

    NONE = "None"
    """Defaults to behavior without av policy specified, which is VM restart upon slow disk io."""
    AUTOMATIC_REATTACH = "AutomaticReattach"
    """Upon a disk io failure or slow response, try detaching then reattaching the disk."""


class AvailabilitySetSkuTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the sku of an Availability Set. Use 'Aligned' for virtual machines with managed disks
    and 'Classic' for virtual machines with unmanaged disks. Default value is 'Classic'.
    """

    CLASSIC = "Classic"
    ALIGNED = "Aligned"


class CachingTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.**
    The default values are: **None for Standard storage. ReadOnly for Premium storage**.
    """

    NONE = "None"
    READ_ONLY = "ReadOnly"
    READ_WRITE = "ReadWrite"


class CapacityReservationGroupInstanceViewTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CapacityReservationGroupInstanceViewTypes."""

    INSTANCE_VIEW = "instanceView"


class CapacityReservationInstanceViewTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CapacityReservationInstanceViewTypes."""

    INSTANCE_VIEW = "instanceView"


class CloudServiceSlotType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Slot type for the cloud service.
    Possible values are :code:`<br />`\\ :code:`<br />`\\ **Production**\\ :code:`<br />`\\
    :code:`<br />`\\ **Staging**\\ :code:`<br />`\\ :code:`<br />`
    If not specified, the default value is Production.
    """

    PRODUCTION = "Production"
    STAGING = "Staging"


class CloudServiceUpgradeMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Update mode for the cloud service. Role instances are allocated to update domains when the
    service is deployed. Updates can be initiated manually in each update domain or initiated
    automatically in all update domains.
    Possible Values are :code:`<br />`\\ :code:`<br />`\\ **Auto**\\ :code:`<br />`\\ :code:`<br
    />`\\ **Manual** :code:`<br />`\\ :code:`<br />`\\ **Simultaneous**\\ :code:`<br />`\\
    :code:`<br />`
    If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called
    to apply the update. If set to Auto, the update is automatically applied to each update domain
    in sequence.
    """

    AUTO = "Auto"
    MANUAL = "Manual"
    SIMULTANEOUS = "Simultaneous"


class ConfidentialVMEncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """confidential VM encryption types."""

    ENCRYPTED_VM_GUEST_STATE_ONLY_WITH_PMK = "EncryptedVMGuestStateOnlyWithPmk"
    ENCRYPTED_WITH_PMK = "EncryptedWithPmk"
    ENCRYPTED_WITH_CMK = "EncryptedWithCmk"
    NON_PERSISTED_TPM = "NonPersistedTPM"


class ConsistencyModeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore
    point. For now, only CrashConsistent is accepted as a valid input. Please refer to
    https://aka.ms/RestorePoints for more details.
    """

    CRASH_CONSISTENT = "CrashConsistent"
    FILE_SYSTEM_CONSISTENT = "FileSystemConsistent"
    APPLICATION_CONSISTENT = "ApplicationConsistent"


class CopyCompletionErrorReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the error code if the background copy of a resource created via the CopyStart
    operation fails.
    """

    COPY_SOURCE_NOT_FOUND = "CopySourceNotFound"
    """Indicates that the source snapshot was deleted while the background copy of the resource
    created via CopyStart operation was in progress."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DataAccessAuthMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Additional authentication requirements when exporting or uploading to a disk or snapshot."""

    AZURE_ACTIVE_DIRECTORY = "AzureActiveDirectory"
    """When export/upload URL is used, the system checks if the user has an identity in Azure Active
    Directory and has necessary permissions to export/upload the data. Please refer to
    aka.ms/DisksAzureADAuth."""
    NONE = "None"
    """No additional authentication would be performed when accessing export/upload URL."""


class DedicatedHostLicenseTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the software license type that will be applied to the VMs deployed on the dedicated
    host. Possible values are: **None,** **Windows_Server_Hybrid,** **Windows_Server_Perpetual.**
    The default value is: **None.**.
    """

    NONE = "None"
    WINDOWS_SERVER_HYBRID = "Windows_Server_Hybrid"
    WINDOWS_SERVER_PERPETUAL = "Windows_Server_Perpetual"


class DeleteOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify what happens to the network interface when the VM is deleted."""

    DELETE = "Delete"
    DETACH = "Detach"


class DiffDiskOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the ephemeral disk option for operating system disk."""

    LOCAL = "Local"


class DiffDiskPlacement(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the ephemeral disk placement for operating system disk. This property can be used by
    user in the request to choose the location i.e, cache disk, resource disk or nvme disk space
    for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size
    requirements, please refer Ephemeral OS disk size requirements for Windows VM at
    https://docs.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
    and Linux VM at
    https://docs.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
    Minimum api-version for NvmeDisk: 2024-03-01.
    """

    CACHE_DISK = "CacheDisk"
    RESOURCE_DISK = "ResourceDisk"
    NVME_DISK = "NvmeDisk"


class DiskControllerTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the disk controller type configured for the VM and VirtualMachineScaleSet. This
    property is only supported for virtual machines whose operating system disk and VM sku supports
    Generation 2 (https://docs.microsoft.com/en-us/azure/virtual-machines/generation-2), please
    check the HyperVGenerations capability returned as part of VM sku capabilities in the response
    of Microsoft.Compute SKUs api for the region contains V2
    (https://docs.microsoft.com/rest/api/compute/resourceskus/list). For more information about
    Disk Controller Types supported please refer to https://aka.ms/azure-diskcontrollertypes.
    """

    SCSI = "SCSI"
    NV_ME = "NVMe"


class DiskCreateOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This enumerates the possible sources of a disk's creation."""

    EMPTY = "Empty"
    """Create an empty data disk of a size given by diskSizeGB."""
    ATTACH = "Attach"
    """Disk will be attached to a VM."""
    FROM_IMAGE = "FromImage"
    """Create a new disk from a platform image specified by the given imageReference or
    galleryImageReference."""
    IMPORT = "Import"
    """Create a disk by importing from a blob specified by a sourceUri in a storage account specified
    by storageAccountId."""
    COPY = "Copy"
    """Create a new disk or snapshot by copying from a disk or snapshot specified by the given
    sourceResourceId."""
    RESTORE = "Restore"
    """Create a new disk by copying from a backup recovery point."""
    UPLOAD = "Upload"
    """Create a new disk by obtaining a write token and using it to directly upload the contents of
    the disk."""
    COPY_START = "CopyStart"
    """Create a new disk by using a deep copy process, where the resource creation is considered
    complete only after all data has been copied from the source."""
    IMPORT_SECURE = "ImportSecure"
    """Similar to Import create option. Create a new Trusted Launch VM or Confidential VM supported
    disk by importing additional blobs for VM guest state specified by securityDataUri and VM
    metadata specified by securityMetadataUri in storage account specified by storageAccountId. The
    VM metadata is optional and only required for certain Confidential VM configurations and not
    required for Trusted Launch VM."""
    UPLOAD_PREPARED_SECURE = "UploadPreparedSecure"
    """Similar to Upload create option. Create a new Trusted Launch VM or Confidential VM supported
    disk and upload using write token in disk, VM guest state and VM metadata. The VM metadata is
    optional and only required for certain Confidential VM configurations and not required for
    Trusted Launch VM."""
    COPY_FROM_SAN_SNAPSHOT = "CopyFromSanSnapshot"
    """Create a new disk by exporting from elastic san volume snapshot"""
    IMPORT_ENUM = "Import"
    """Create a disk by importing from a blob specified by a sourceUri in a storage account specified
    by storageAccountId."""


class DiskCreateOptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies how the virtual machine disk should be created. Possible values are **Attach:** This
    value is used when you are using a specialized disk to create the virtual machine.
    **FromImage:** This value is used when you are using an image to create the virtual machine. If
    you are using a platform image, you should also use the imageReference element described above.
    If you are using a marketplace image, you should also use the plan element previously
    described. **Empty:** This value is used when creating an empty data disk. **Copy:** This value
    is used to create a data disk from a snapshot or another disk. **Restore:** This value is used
    to create a data disk from a disk restore point.
    """

    FROM_IMAGE = "FromImage"
    EMPTY = "Empty"
    ATTACH = "Attach"
    COPY = "Copy"
    RESTORE = "Restore"


class DiskDeleteOptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the behavior of the managed disk when the VM gets deleted, for example whether the
    managed disk is deleted or detached. Supported values are: **Delete.** If this value is used,
    the managed disk is deleted when VM gets deleted. **Detach.** If this value is used, the
    managed disk is retained after VM gets deleted. Minimum api-version: 2021-03-01.
    """

    DELETE = "Delete"
    DETACH = "Detach"


class DiskDetachOptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the detach behavior to be used while detaching a disk or which is already in the
    process of detachment from the virtual machine. Supported values are: **ForceDetach.**
    detachOption: **ForceDetach** is applicable only for managed data disks. If a previous
    detachment attempt of the data disk did not complete due to an unexpected failure from the
    virtual machine and the disk is still not released then use force-detach as a last resort
    option to detach the disk forcibly from the VM. All writes might not have been flushed when
    using this detach behavior. **This feature is still in preview**. To force-detach a data disk
    update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
    """

    FORCE_DETACH = "ForceDetach"


class DiskEncryptionSetIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported
    for new creations. Disk Encryption Sets can be updated with Identity type None during migration
    of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources
    to lose access to the keys.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class DiskEncryptionSetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of key used to encrypt the data of the disk."""

    ENCRYPTION_AT_REST_WITH_CUSTOMER_KEY = "EncryptionAtRestWithCustomerKey"
    """Resource using diskEncryptionSet would be encrypted at rest with Customer managed key that can
    be changed and revoked by a customer."""
    ENCRYPTION_AT_REST_WITH_PLATFORM_AND_CUSTOMER_KEYS = "EncryptionAtRestWithPlatformAndCustomerKeys"
    """Resource using diskEncryptionSet would be encrypted at rest with two layers of encryption. One
    of the keys is Customer managed and the other key is Platform managed."""
    CONFIDENTIAL_VM_ENCRYPTED_WITH_CUSTOMER_KEY = "ConfidentialVmEncryptedWithCustomerKey"
    """Confidential VM supported disk and VM guest state would be encrypted with customer managed key."""


class DiskSecurityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the SecurityType of the VM. Applicable for OS disks only."""

    TRUSTED_LAUNCH = "TrustedLaunch"
    """Trusted Launch provides security features such as secure boot and virtual Trusted Platform
    Module (vTPM)"""
    CONFIDENTIAL_VM_VMGUEST_STATE_ONLY_ENCRYPTED_WITH_PLATFORM_KEY = (
        "ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey"
    )
    """Indicates Confidential VM disk with only VM guest state encrypted"""
    CONFIDENTIAL_VM_DISK_ENCRYPTED_WITH_PLATFORM_KEY = "ConfidentialVM_DiskEncryptedWithPlatformKey"
    """Indicates Confidential VM disk with both OS disk and VM guest state encrypted with a platform
    managed key"""
    CONFIDENTIAL_VM_DISK_ENCRYPTED_WITH_CUSTOMER_KEY = "ConfidentialVM_DiskEncryptedWithCustomerKey"
    """Indicates Confidential VM disk with both OS disk and VM guest state encrypted with a customer
    managed key"""
    CONFIDENTIAL_VM_NON_PERSISTED_TPM = "ConfidentialVM_NonPersistedTPM"
    """Indicates Confidential VM disk with a ephemeral vTPM. vTPM state is not persisted across VM
    reboots."""


class DiskState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This enumerates the possible state of the disk."""

    UNATTACHED = "Unattached"
    """The disk is not being used and can be attached to a VM."""
    ATTACHED = "Attached"
    """The disk is currently attached to a running VM."""
    RESERVED = "Reserved"
    """The disk is attached to a stopped-deallocated VM."""
    FROZEN = "Frozen"
    """The disk is attached to a VM which is in hibernated state."""
    ACTIVE_SAS = "ActiveSAS"
    """The disk currently has an Active SAS Uri associated with it."""
    ACTIVE_SAS_FROZEN = "ActiveSASFrozen"
    """The disk is attached to a VM in hibernated state and has an active SAS URI associated with it."""
    READY_TO_UPLOAD = "ReadyToUpload"
    """A disk is ready to be created by upload by requesting a write token."""
    ACTIVE_UPLOAD = "ActiveUpload"
    """A disk is created for upload and a write token has been issued for uploading to it."""


class DiskStorageAccountTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sku name."""

    STANDARD_LRS = "Standard_LRS"
    """Standard HDD locally redundant storage. Best for backup, non-critical, and infrequent access."""
    PREMIUM_LRS = "Premium_LRS"
    """Premium SSD locally redundant storage. Best for production and performance sensitive workloads."""
    STANDARD_SSD_LRS = "StandardSSD_LRS"
    """Standard SSD locally redundant storage. Best for web servers, lightly used enterprise
    applications and dev/test."""
    ULTRA_SSD_LRS = "UltraSSD_LRS"
    """Ultra SSD locally redundant storage. Best for IO-intensive workloads such as SAP HANA, top tier
    databases (for example, SQL, Oracle), and other transaction-heavy workloads."""
    PREMIUM_ZRS = "Premium_ZRS"
    """Premium SSD zone redundant storage. Best for the production workloads that need storage
    resiliency against zone failures."""
    STANDARD_SSD_ZRS = "StandardSSD_ZRS"
    """Standard SSD zone redundant storage. Best for web servers, lightly used enterprise applications
    and dev/test that need storage resiliency against zone failures."""
    PREMIUM_V2_LRS = "PremiumV2_LRS"
    """Premium SSD v2 locally redundant storage. Best for production and performance-sensitive
    workloads that consistently require low latency and high IOPS and throughput."""


class DomainNameLabelScopeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Domain name label scope.The concatenation of the hashed domain name label that generated
    according to the policy from domain name label scope and vm index will be the domain name
    labels of the PublicIPAddress resources that will be created.
    """

    TENANT_REUSE = "TenantReuse"
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    NO_REUSE = "NoReuse"


class EdgeZoneStorageAccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the storage account type to be used to store the image. This property is not
    updatable.
    """

    STANDARD_LRS = "Standard_LRS"
    STANDARD_ZRS = "Standard_ZRS"
    STANDARD_SSD_LRS = "StandardSSD_LRS"
    PREMIUM_LRS = "Premium_LRS"


class EncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of key used to encrypt the data of the disk."""

    ENCRYPTION_AT_REST_WITH_PLATFORM_KEY = "EncryptionAtRestWithPlatformKey"
    """Disk is encrypted at rest with Platform managed key. It is the default encryption type. This is
    not a valid encryption type for disk encryption sets."""
    ENCRYPTION_AT_REST_WITH_CUSTOMER_KEY = "EncryptionAtRestWithCustomerKey"
    """Disk is encrypted at rest with Customer managed key that can be changed and revoked by a
    customer."""
    ENCRYPTION_AT_REST_WITH_PLATFORM_AND_CUSTOMER_KEYS = "EncryptionAtRestWithPlatformAndCustomerKeys"
    """Disk is encrypted at rest with 2 layers of encryption. One of the keys is Customer managed and
    the other key is Platform managed."""


class EndpointAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify if the requests will be allowed to access the host
    endpoints. Possible values are: 'Allow', 'Deny'.
    """

    ALLOW = "Allow"
    DENY = "Deny"


class EndpointTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the Endpoint type for which this profile is defining the
    access control for. Possible values are: 'WireServer' or 'IMDS'.
    """

    WIRE_SERVER = "WireServer"
    IMDS = "IMDS"


class ExecutionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Script execution status."""

    UNKNOWN = "Unknown"
    PENDING = "Pending"
    RUNNING = "Running"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    TIMED_OUT = "TimedOut"
    CANCELED = "Canceled"


class ExpandTypeForListVMs(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExpandTypeForListVMs."""

    INSTANCE_VIEW = "instanceView"


class ExpandTypesForGetCapacityReservationGroups(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExpandTypesForGetCapacityReservationGroups."""

    VIRTUAL_MACHINE_SCALE_SET_VMS_REF = "virtualMachineScaleSetVMs/$ref"
    VIRTUAL_MACHINES_REF = "virtualMachines/$ref"


class ExpandTypesForGetVMScaleSets(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExpandTypesForGetVMScaleSets."""

    USER_DATA = "userData"


class ExpandTypesForListVMs(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExpandTypesForListVMs."""

    INSTANCE_VIEW = "instanceView"


class ExtendedLocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the extended location."""

    EDGE_ZONE = "EdgeZone"


class ExtendedLocationTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of extendedLocation."""

    EDGE_ZONE = "EdgeZone"


class FileFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Used to specify the file format when making request for SAS on a VHDX file format snapshot."""

    VHD = "VHD"
    """A VHD file is a disk image file in the Virtual Hard Disk file format."""
    VHDX = "VHDX"
    """A VHDX file is a disk image file in the Virtual Hard Disk v2 file format."""


class GalleryApplicationCustomActionParameterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the type of the custom action parameter. Possible values are: String,
    ConfigurationDataBlob or LogOutputBlob.
    """

    STRING = "String"
    CONFIGURATION_DATA_BLOB = "ConfigurationDataBlob"
    LOG_OUTPUT_BLOB = "LogOutputBlob"


class GalleryApplicationScriptRebootBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Optional. The action to be taken with regards to install/update/remove of the gallery
    application in the event of a reboot.
    """

    NONE = "None"
    RERUN = "Rerun"


class GalleryExpandParams(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GalleryExpandParams."""

    SHARING_PROFILE_GROUPS = "SharingProfile/Groups"


class GalleryExtendedLocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """It is type of the extended location."""

    EDGE_ZONE = "EdgeZone"
    UNKNOWN = "Unknown"


class GalleryProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state, which only appears in the response."""

    CREATING = "Creating"
    UPDATING = "Updating"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    MIGRATING = "Migrating"


class GalleryScriptParameterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the type of the Gallery Script parameter. Possible values are: String, Int, Double,
    Boolean, Enum.
    """

    STRING = "String"
    """String gallery script parameter type"""
    INT = "Int"
    """Int gallery script parameter type"""
    DOUBLE = "Double"
    """Double gallery script parameter type"""
    BOOLEAN = "Boolean"
    """Boolean gallery script parameter type"""
    ENUM = "Enum"
    """Enum gallery script parameter type"""
    INT_ENUM = "Int"
    """Int gallery script parameter type"""


class GallerySharingPermissionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the permission of sharing gallery. Possible values are:
    **Private,** **Groups,** **Community.**.
    """

    PRIVATE = "Private"
    GROUPS = "Groups"
    COMMUNITY = "Community"


class HighSpeedInterconnectPlacement(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the high speed interconnect placement for the virtual machine scale set."""

    NONE = "None"
    """No high speed interconnect placement"""
    TRUNK = "Trunk"
    """Trunk high speed interconnect placement"""


class HostCaching(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'."""

    NONE = "None"
    READ_ONLY = "ReadOnly"
    READ_WRITE = "ReadWrite"


class HyperVGeneration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The hypervisor generation of the Virtual Machine. Applicable to OS disks only."""

    V1 = "V1"
    V2 = "V2"


class HyperVGenerationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the HyperVGeneration Type associated with a resource."""

    V1 = "V1"
    V2 = "V2"


class HyperVGenerationTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the HyperVGeneration Type."""

    V1 = "V1"
    V2 = "V2"


class ImageState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the state of the image."""

    ACTIVE = "Active"
    SCHEDULED_FOR_DEPRECATION = "ScheduledForDeprecation"
    DEPRECATED = "Deprecated"


class InstanceViewTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """InstanceViewTypes."""

    INSTANCE_VIEW = "instanceView"
    USER_DATA = "userData"
    RESILIENCY_VIEW = "resiliencyView"


class IntervalInMins(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Interval value in minutes used to create LogAnalytics call rate logs."""

    THREE_MINS = "ThreeMins"
    FIVE_MINS = "FiveMins"
    THIRTY_MINS = "ThirtyMins"
    SIXTY_MINS = "SixtyMins"


class IPVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available from Api-Version 2017-03-30 onwards, it represents whether the specific
    ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and
    'IPv6'.
    """

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class IPVersions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available from Api-Version 2017-03-30 onwards, it represents whether the specific
    ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and
    'IPv6'.
    """

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class LinuxPatchAssessmentMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.\\ :code:`<br
    />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br />` **ImageDefault** -
    You control the timing of patch assessments on a virtual machine. :code:`<br />`\\ :code:`<br
    />` **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The
    property provisionVMAgent must be true.
    """

    IMAGE_DEFAULT = "ImageDefault"
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"


class LinuxVMGuestPatchAutomaticByPlatformRebootSetting(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the reboot setting for all AutomaticByPlatform patch installation operations."""

    UNKNOWN = "Unknown"
    IF_REQUIRED = "IfRequired"
    NEVER = "Never"
    ALWAYS = "Always"


class LinuxVMGuestPatchMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated
    to virtual machine scale set with OrchestrationMode as Flexible.\\ :code:`<br />`\\ :code:`<br
    />` Possible values are:\\ :code:`<br />`\\ :code:`<br />` **ImageDefault** - The virtual
    machine's default patching configuration is used. :code:`<br />`\\ :code:`<br />`
    **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform.
    The property provisionVMAgent must be true.
    """

    IMAGE_DEFAULT = "ImageDefault"
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"


class MaintenanceOperationResultCodeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Last Maintenance Operation Result Code."""

    NONE = "None"
    RETRY_LATER = "RetryLater"
    MAINTENANCE_ABORTED = "MaintenanceAborted"
    MAINTENANCE_COMPLETED = "MaintenanceCompleted"


class Mode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will
    start to audit or monitor but not enforce access control over requests to host endpoints in
    Audit mode, while in Enforce mode it will enforce access control. The default value is Enforce
    mode.
    """

    AUDIT = "Audit"
    ENFORCE = "Enforce"


class Modes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the execution mode. In Audit mode, the system acts as if it is enforcing the access
    control policy, including emitting access denial entries in the logs but it does not actually
    deny any requests to host endpoints. In Enforce mode, the system will enforce the access
    control and it is the recommended mode of operation.
    """

    AUDIT = "Audit"
    ENFORCE = "Enforce"
    DISABLED = "Disabled"


class NetworkAccessPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Policy for accessing the disk via network."""

    ALLOW_ALL = "AllowAll"
    """The disk can be exported or uploaded to from any network."""
    ALLOW_PRIVATE = "AllowPrivate"
    """The disk can be exported or uploaded to using a DiskAccess resource's private endpoints."""
    DENY_ALL = "DenyAll"
    """The disk cannot be exported."""


class NetworkApiVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """specifies the Microsoft.Network API version used when creating networking resources in the
    Network Interface Configurations.
    """

    TWO_THOUSAND_TWENTY11_01 = "2020-11-01"
    TWO_THOUSAND_TWENTY_TWO11_01 = "2022-11-01"


class NetworkInterfaceAuxiliaryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether the Auxiliary mode is enabled for the Network Interface resource."""

    NONE = "None"
    ACCELERATED_CONNECTIONS = "AcceleratedConnections"
    FLOATING = "Floating"


class NetworkInterfaceAuxiliarySku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether the Auxiliary sku is enabled for the Network Interface resource."""

    NONE = "None"
    A1 = "A1"
    A2 = "A2"
    A4 = "A4"
    A8 = "A8"


class OperatingSystemStateTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows the user to specify whether the virtual machines created under this image
    are 'Generalized' or 'Specialized'.
    """

    GENERALIZED = "Generalized"
    SPECIALIZED = "Specialized"


class OperatingSystemType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the Operating System type."""

    WINDOWS = "Windows"
    LINUX = "Linux"


class OperatingSystemTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Operating System type."""

    WINDOWS = "Windows"
    LINUX = "Linux"


class OrchestrationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the orchestration mode for the virtual machine scale set."""

    UNIFORM = "Uniform"
    FLEXIBLE = "Flexible"


class OrchestrationServiceNames(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the service."""

    AUTOMATIC_REPAIRS = "AutomaticRepairs"
    AUTOMATIC_ZONE_REBALANCING = "AutomaticZoneRebalancing"
    """AutomaticZoneRebalancing orchestration service."""


class OrchestrationServiceOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The latest operation status of the service."""

    IN_PROGRESS = "InProgress"
    """InProgress orchestration service operation status."""
    COMPLETED = "Completed"
    """Completed orchestration service operation status."""


class OrchestrationServiceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the service."""

    NOT_RUNNING = "NotRunning"
    RUNNING = "Running"
    SUSPENDED = "Suspended"


class OrchestrationServiceStateAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action to be performed."""

    RESUME = "Resume"
    SUSPEND = "Suspend"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class PatchAssessmentState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the availability of a given patch."""

    UNKNOWN = "Unknown"
    AVAILABLE = "Available"


class PatchInstallationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the patch after the installation operation completed."""

    UNKNOWN = "Unknown"
    INSTALLED = "Installed"
    FAILED = "Failed"
    EXCLUDED = "Excluded"
    NOT_SELECTED = "NotSelected"
    PENDING = "Pending"


class PatchOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The overall success or failure status of the operation. It remains "InProgress" until the
    operation completes. At that point it will become "Unknown", "Failed", "Succeeded", or
    "CompletedWithWarnings.".
    """

    UNKNOWN = "Unknown"
    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    COMPLETED_WITH_WARNINGS = "CompletedWithWarnings"


class PolicyViolationCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the nature of the policy violation."""

    OTHER = "Other"
    IMAGE_FLAGGED_UNSAFE = "ImageFlaggedUnsafe"
    COPYRIGHT_VALIDATION = "CopyrightValidation"
    IP_THEFT = "IpTheft"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class ProtocolTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the protocol of WinRM listener. Possible values are: **http,** **https.**."""

    HTTP = "Http"
    HTTPS = "Https"


class ProvisionedBandwidthCopyOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """If this field is set on a snapshot and createOption is CopyStart, the snapshot will be copied
    at a quicker speed.
    """

    NONE = "None"
    ENHANCED = "Enhanced"


class ProximityPlacementGroupType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the type of the proximity placement group. Possible values are: **Standard** :
    Co-locate resources within an Azure region or Availability Zone. **Ultra** : For future use.
    """

    STANDARD = "Standard"
    ULTRA = "Ultra"


class PublicIPAddressSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify public IP sku name."""

    BASIC = "Basic"
    STANDARD = "Standard"


class PublicIPAddressSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify public IP sku tier."""

    REGIONAL = "Regional"
    GLOBAL = "Global"
    GLOBAL_ENUM = "Global"


class PublicIPAllocationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify the public IP allocation type."""

    DYNAMIC = "Dynamic"
    STATIC = "Static"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Policy for controlling export on the disk."""

    ENABLED = "Enabled"
    """You can generate a SAS URI to access the underlying data of the disk publicly on the internet
    when NetworkAccessPolicy is set to AllowAll. You can access the data via the SAS URI only from
    your trusted Azure VNET when NetworkAccessPolicy is set to AllowPrivate."""
    DISABLED = "Disabled"
    """You cannot access the underlying data of the disk publicly on the internet even when
    NetworkAccessPolicy is set to AllowAll. You can access the data via the SAS URI only from your
    trusted Azure VNET when NetworkAccessPolicy is set to AllowPrivate."""


class RebalanceBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of rebalance behavior that will be used for recreating virtual machines in the scale set
    across availability zones. Default and only supported value for now is CreateBeforeDelete.
    """

    CREATE_BEFORE_DELETE = "CreateBeforeDelete"


class RebalanceStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of rebalance strategy that will be used for rebalancing virtual machines in the scale set
    across availability zones. Default and only supported value for now is Recreate.
    """

    RECREATE = "Recreate"


class RepairAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy
    virtual machines in the scale set. Default value is replace.
    """

    REPLACE = "Replace"
    RESTART = "Restart"
    REIMAGE = "Reimage"


class ReplicationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Optional parameter which specifies the mode to be used for replication. This property is not
    updatable.
    """

    FULL = "Full"
    SHALLOW = "Shallow"


class ReplicationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This is the regional replication state."""

    UNKNOWN = "Unknown"
    REPLICATING = "Replicating"
    COMPLETED = "Completed"
    FAILED = "Failed"


class ReplicationStatusTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ReplicationStatusTypes."""

    REPLICATION_STATUS = "ReplicationStatus"
    UEFI_SETTINGS = "UefiSettings"


class ReservationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the type of capacity reservation. Allowed values are 'Block' for block capacity
    reservations and 'Targeted' for reservations that enable a VM to consume a specific capacity
    reservation when a capacity reservation group is provided. The reservation type is immutable
    and cannot be changed after it is assigned.
    """

    TARGETED = "Targeted"
    """To consume on demand allocated capacity reservation when a capacity reservation group is
    provided."""
    BLOCK = "Block"
    """To consume scheduled allocated block capacity reservation when a capacity reservation group is
    provided."""


class ResilientVMDeletionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the resilient VM deletion status for the virtual machine."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    IN_PROGRESS = "InProgress"
    FAILED = "Failed"


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity used for the gallery. The type 'SystemAssigned, UserAssigned' includes
    both an implicitly created identity and a set of user assigned identities. The type 'None' will
    remove all identities from the gallery.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class ResourceIdOptionsForGetCapacityReservationGroups(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ResourceIdOptionsForGetCapacityReservationGroups."""

    CREATED_IN_SUBSCRIPTION = "CreatedInSubscription"
    SHARED_WITH_SUBSCRIPTION = "SharedWithSubscription"
    ALL = "All"


class ResourceSkuCapacityScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scale type applicable to the sku."""

    AUTOMATIC = "Automatic"
    MANUAL = "Manual"
    NONE = "None"


class ResourceSkuRestrictionsReasonCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason for restriction."""

    QUOTA_ID = "QuotaId"
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"


class ResourceSkuRestrictionsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of restrictions."""

    LOCATION = "Location"
    ZONE = "Zone"


class RestorePointCollectionExpandOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RestorePointCollectionExpandOptions."""

    RESTORE_POINTS = "restorePoints"


class RestorePointEncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of key used to encrypt the data of the disk restore point."""

    ENCRYPTION_AT_REST_WITH_PLATFORM_KEY = "EncryptionAtRestWithPlatformKey"
    """Disk Restore Point is encrypted at rest with Platform managed key."""
    ENCRYPTION_AT_REST_WITH_CUSTOMER_KEY = "EncryptionAtRestWithCustomerKey"
    """Disk Restore Point is encrypted at rest with Customer managed key that can be changed and
    revoked by a customer."""
    ENCRYPTION_AT_REST_WITH_PLATFORM_AND_CUSTOMER_KEYS = "EncryptionAtRestWithPlatformAndCustomerKeys"
    """Disk Restore Point is encrypted at rest with 2 layers of encryption. One of the keys is
    Customer managed and the other key is Platform managed."""


class RestorePointExpandOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RestorePointExpandOptions."""

    INSTANCE_VIEW = "instanceView"


class RollingUpgradeActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The last action performed on the rolling upgrade."""

    START = "Start"
    CANCEL = "Cancel"


class RollingUpgradeStatusCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Code indicating the current status of the upgrade."""

    ROLLING_FORWARD = "RollingForward"
    CANCELLED = "Cancelled"
    COMPLETED = "Completed"
    FAULTED = "Faulted"


class ScriptShellTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Script shell types."""

    DEFAULT = "Default"
    """Default script shell type."""
    POWERSHELL7 = "Powershell7"
    """Powershell7 script shell type."""


class SecurityEncryptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for
    encryption of the managed disk along with VMGuestState blob, VMGuestStateOnly for encryption of
    just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the
    VMGuestState blob.. **Note:** It can be set for only Confidential VMs.
    """

    VM_GUEST_STATE_ONLY = "VMGuestStateOnly"
    DISK_WITH_VM_GUEST_STATE = "DiskWithVMGuestState"
    NON_PERSISTED_TPM = "NonPersistedTPM"


class SecurityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the SecurityType of the virtual machine. It has to be set to any specified value to
    enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this
    property is set.
    """

    TRUSTED_LAUNCH = "TrustedLaunch"
    CONFIDENTIAL_VM = "ConfidentialVM"


class SelectPermissions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SelectPermissions."""

    PERMISSIONS = "Permissions"


class SettingNames(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the name of the setting to which the content applies. Possible values are:
    FirstLogonCommands and AutoLogon.
    """

    AUTO_LOGON = "AutoLogon"
    FIRST_LOGON_COMMANDS = "FirstLogonCommands"


class SharedGalleryHostCaching(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'."""

    NONE = "None"
    READ_ONLY = "ReadOnly"
    READ_WRITE = "ReadWrite"


class SharedToValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SharedToValues."""

    TENANT = "tenant"


class SharingProfileGroupTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the type of sharing group. Possible values are:
    **Subscriptions,** **AADTenants.**.
    """

    SUBSCRIPTIONS = "Subscriptions"
    AAD_TENANTS = "AADTenants"


class SharingState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sharing state of the gallery, which only appears in the response."""

    SUCCEEDED = "Succeeded"
    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    UNKNOWN = "Unknown"


class SharingUpdateOperationTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the operation type of gallery sharing update. Possible
    values are: **Add,** **Remove,** **Reset.**.
    """

    ADD = "Add"
    REMOVE = "Remove"
    RESET = "Reset"
    ENABLE_COMMUNITY = "EnableCommunity"


class SnapshotAccessState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of snapshot which determines the access availability of the snapshot."""

    UNKNOWN = "Unknown"
    """Default value."""
    PENDING = "Pending"
    """The snapshot cannot be used for restore, copy or download to offline."""
    AVAILABLE = "Available"
    """The snapshot can be used for restore, copy to different region, and download to offline."""
    INSTANT_ACCESS = "InstantAccess"
    """The snapshot can be used for restoring disks with fast performance but cannot be copied or
    downloaded."""
    AVAILABLE_WITH_INSTANT_ACCESS = "AvailableWithInstantAccess"
    """The snapshot can be used for restoring disks with fast performance, copied and downloaded."""


class SnapshotStorageAccountTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sku name."""

    STANDARD_LRS = "Standard_LRS"
    """Standard HDD locally redundant storage"""
    PREMIUM_LRS = "Premium_LRS"
    """Premium SSD locally redundant storage"""
    STANDARD_ZRS = "Standard_ZRS"
    """Standard zone redundant storage"""


class SoftDeletedArtifactTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """artifact type of the soft-deleted resource."""

    IMAGES = "Images"


class SshEncryptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The encryption type of the SSH keys to be generated. See SshEncryptionTypes for possible set of
    values. If not provided, will default to RSA.
    """

    RSA = "RSA"
    ED25519 = "Ed25519"


class StatusLevelTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The level code."""

    INFO = "Info"
    WARNING = "Warning"
    ERROR = "Error"


class StorageAccountStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the strategy to be used when selecting the storage account type. Cannot be specified
    along with storageAccountType, but can be overridden per region by specifying
    targetRegions[].storageAccountType. This property is not updatable.
    """

    PREFER_STANDARD_ZRS = "PreferStandard_ZRS"
    """Choose Standard_ZRS storage if the region supports it, else choose Standard_LRS storage, unless
    overridden by specifying regional storageAccountType. If no storageAccountStrategy is
    specified, this is the default strategy (from API version 2025-03-03 onwards)."""
    DEFAULT_STANDARD_LRS = "DefaultStandard_LRS"
    """Choose Standard_LRS storage unless overridden by specifying regional storageAccountType."""


class StorageAccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the storage account type to be used to store the image. This property is not
    updatable.
    """

    STANDARD_LRS = "Standard_LRS"
    STANDARD_ZRS = "Standard_ZRS"
    PREMIUM_LRS = "Premium_LRS"
    PREMIUM_V2_LRS = "PremiumV2_LRS"


class StorageAccountTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the storage account type for the managed disk. Managed OS disk storage account type
    can only be set when you create the scale set. NOTE: UltraSSD_LRS can only be used with data
    disks. It cannot be used with OS Disk. Standard_LRS uses Standard HDD. StandardSSD_LRS uses
    Standard SSD. Premium_LRS uses Premium SSD. UltraSSD_LRS uses Ultra disk. Premium_ZRS uses
    Premium SSD zone redundant storage. StandardSSD_ZRS uses Standard SSD zone redundant storage.
    For more information regarding disks supported for Windows Virtual Machines, refer to
    https://docs.microsoft.com/azure/virtual-machines/windows/disks-types and, for Linux Virtual
    Machines, refer to https://docs.microsoft.com/azure/virtual-machines/linux/disks-types.
    """

    STANDARD_LRS = "Standard_LRS"
    PREMIUM_LRS = "Premium_LRS"
    STANDARD_SSD_LRS = "StandardSSD_LRS"
    ULTRA_SSD_LRS = "UltraSSD_LRS"
    PREMIUM_ZRS = "Premium_ZRS"
    STANDARD_SSD_ZRS = "StandardSSD_ZRS"
    PREMIUM_V2_LRS = "PremiumV2_LRS"


class SupportedSecurityOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Refers to the security capability of the disk supported to create a Trusted launch or
    Confidential VM.
    """

    TRUSTED_LAUNCH_SUPPORTED = "TrustedLaunchSupported"
    """The disk supports creating Trusted Launch VMs."""
    TRUSTED_LAUNCH_AND_CONFIDENTIAL_VM_SUPPORTED = "TrustedLaunchAndConfidentialVMSupported"
    """The disk supports creating both Trusted Launch and Confidential VMs."""


class UefiKeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of key signature."""

    SHA256 = "sha256"
    X509 = "x509"


class UefiSignatureTemplateName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the signature template that contains default UEFI keys."""

    NO_SIGNATURE_TEMPLATE = "NoSignatureTemplate"
    MICROSOFT_UEFI_CERTIFICATE_AUTHORITY_TEMPLATE = "MicrosoftUefiCertificateAuthorityTemplate"
    MICROSOFT_WINDOWS_TEMPLATE = "MicrosoftWindowsTemplate"


class UpgradeMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of an upgrade to virtual machines in the scale set.\\ :code:`<br />`\\
    :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br />` **Manual** - You  control
    the application of updates to virtual machines in the scale set. You do this by using the
    manualUpgrade action.\\ :code:`<br />`\\ :code:`<br />` **Automatic** - All virtual machines in
    the scale set are  automatically updated at the same time.
    """

    AUTOMATIC = "Automatic"
    MANUAL = "Manual"
    ROLLING = "Rolling"


class UpgradeOperationInvoker(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Invoker of the Upgrade Operation."""

    UNKNOWN = "Unknown"
    USER = "User"
    PLATFORM = "Platform"


class UpgradeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Code indicating the current status of the upgrade."""

    ROLLING_FORWARD = "RollingForward"
    CANCELLED = "Cancelled"
    COMPLETED = "Completed"
    FAULTED = "Faulted"


class ValidationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property specifies the status of the validationProfile of the image version."""

    UNKNOWN = "Unknown"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"


class VirtualMachineEvictionPolicyTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the eviction policy for the Azure Spot VM/VMSS."""

    DEALLOCATE = "Deallocate"
    DELETE = "Delete"


class VirtualMachinePriorityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the priority for a standalone virtual machine or the virtual machines in the scale
    set. 'Low' enum will be deprecated in the future, please use 'Spot' as the enum to deploy Azure
    Spot VM/VMSS.
    """

    REGULAR = "Regular"
    LOW = "Low"
    SPOT = "Spot"


class VirtualMachineScaleSetScaleInRules(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VirtualMachineScaleSetScaleInRules."""

    DEFAULT = "Default"
    OLDEST_VM = "OldestVM"
    NEWEST_VM = "NewestVM"


class VirtualMachineScaleSetSkuScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scale type applicable to the sku."""

    AUTOMATIC = "Automatic"
    NONE = "None"


class VirtualMachineSizeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the size of the virtual machine. The enum data type is currently deprecated and will
    be removed by December 23rd 2023. The recommended way to get the list of available sizes is
    using these APIs: `List all available virtual machine sizes in an availability set
    <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_\\ , `List
    all available virtual machine sizes in a region
    <https://docs.microsoft.com/rest/api/compute/resourceskus/list>`_\\ , `List all available
    virtual machine sizes for resizing
    <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. For more
    information about virtual machine sizes, see `Sizes for virtual machines
    <https://docs.microsoft.com/azure/virtual-machines/sizes>`_. The available VM sizes depend on
    region and availability set.
    """

    BASIC_A0 = "Basic_A0"
    BASIC_A1 = "Basic_A1"
    BASIC_A2 = "Basic_A2"
    BASIC_A3 = "Basic_A3"
    BASIC_A4 = "Basic_A4"
    STANDARD_A0 = "Standard_A0"
    STANDARD_A1 = "Standard_A1"
    STANDARD_A2 = "Standard_A2"
    STANDARD_A3 = "Standard_A3"
    STANDARD_A4 = "Standard_A4"
    STANDARD_A5 = "Standard_A5"
    STANDARD_A6 = "Standard_A6"
    STANDARD_A7 = "Standard_A7"
    STANDARD_A8 = "Standard_A8"
    STANDARD_A9 = "Standard_A9"
    STANDARD_A10 = "Standard_A10"
    STANDARD_A11 = "Standard_A11"
    STANDARD_A1_V2 = "Standard_A1_v2"
    STANDARD_A2_V2 = "Standard_A2_v2"
    STANDARD_A4_V2 = "Standard_A4_v2"
    STANDARD_A8_V2 = "Standard_A8_v2"
    STANDARD_A2_M_V2 = "Standard_A2m_v2"
    STANDARD_A4_M_V2 = "Standard_A4m_v2"
    STANDARD_A8_M_V2 = "Standard_A8m_v2"
    STANDARD_B1_S = "Standard_B1s"
    STANDARD_B1_MS = "Standard_B1ms"
    STANDARD_B2_S = "Standard_B2s"
    STANDARD_B2_MS = "Standard_B2ms"
    STANDARD_B4_MS = "Standard_B4ms"
    STANDARD_B8_MS = "Standard_B8ms"
    STANDARD_D1 = "Standard_D1"
    STANDARD_D2 = "Standard_D2"
    STANDARD_D3 = "Standard_D3"
    STANDARD_D4 = "Standard_D4"
    STANDARD_D11 = "Standard_D11"
    STANDARD_D12 = "Standard_D12"
    STANDARD_D13 = "Standard_D13"
    STANDARD_D14 = "Standard_D14"
    STANDARD_D1_V2 = "Standard_D1_v2"
    STANDARD_D2_V2 = "Standard_D2_v2"
    STANDARD_D3_V2 = "Standard_D3_v2"
    STANDARD_D4_V2 = "Standard_D4_v2"
    STANDARD_D5_V2 = "Standard_D5_v2"
    STANDARD_D2_V3 = "Standard_D2_v3"
    STANDARD_D4_V3 = "Standard_D4_v3"
    STANDARD_D8_V3 = "Standard_D8_v3"
    STANDARD_D16_V3 = "Standard_D16_v3"
    STANDARD_D32_V3 = "Standard_D32_v3"
    STANDARD_D64_V3 = "Standard_D64_v3"
    STANDARD_D2_S_V3 = "Standard_D2s_v3"
    STANDARD_D4_S_V3 = "Standard_D4s_v3"
    STANDARD_D8_S_V3 = "Standard_D8s_v3"
    STANDARD_D16_S_V3 = "Standard_D16s_v3"
    STANDARD_D32_S_V3 = "Standard_D32s_v3"
    STANDARD_D64_S_V3 = "Standard_D64s_v3"
    STANDARD_D11_V2 = "Standard_D11_v2"
    STANDARD_D12_V2 = "Standard_D12_v2"
    STANDARD_D13_V2 = "Standard_D13_v2"
    STANDARD_D14_V2 = "Standard_D14_v2"
    STANDARD_D15_V2 = "Standard_D15_v2"
    STANDARD_DS1 = "Standard_DS1"
    STANDARD_DS2 = "Standard_DS2"
    STANDARD_DS3 = "Standard_DS3"
    STANDARD_DS4 = "Standard_DS4"
    STANDARD_DS11 = "Standard_DS11"
    STANDARD_DS12 = "Standard_DS12"
    STANDARD_DS13 = "Standard_DS13"
    STANDARD_DS14 = "Standard_DS14"
    STANDARD_DS1_V2 = "Standard_DS1_v2"
    STANDARD_DS2_V2 = "Standard_DS2_v2"
    STANDARD_DS3_V2 = "Standard_DS3_v2"
    STANDARD_DS4_V2 = "Standard_DS4_v2"
    STANDARD_DS5_V2 = "Standard_DS5_v2"
    STANDARD_DS11_V2 = "Standard_DS11_v2"
    STANDARD_DS12_V2 = "Standard_DS12_v2"
    STANDARD_DS13_V2 = "Standard_DS13_v2"
    STANDARD_DS14_V2 = "Standard_DS14_v2"
    STANDARD_DS15_V2 = "Standard_DS15_v2"
    STANDARD_DS13_4_V2 = "Standard_DS13-4_v2"
    STANDARD_DS13_2_V2 = "Standard_DS13-2_v2"
    STANDARD_DS14_8_V2 = "Standard_DS14-8_v2"
    STANDARD_DS14_4_V2 = "Standard_DS14-4_v2"
    STANDARD_E2_V3 = "Standard_E2_v3"
    STANDARD_E4_V3 = "Standard_E4_v3"
    STANDARD_E8_V3 = "Standard_E8_v3"
    STANDARD_E16_V3 = "Standard_E16_v3"
    STANDARD_E32_V3 = "Standard_E32_v3"
    STANDARD_E64_V3 = "Standard_E64_v3"
    STANDARD_E2_S_V3 = "Standard_E2s_v3"
    STANDARD_E4_S_V3 = "Standard_E4s_v3"
    STANDARD_E8_S_V3 = "Standard_E8s_v3"
    STANDARD_E16_S_V3 = "Standard_E16s_v3"
    STANDARD_E32_S_V3 = "Standard_E32s_v3"
    STANDARD_E64_S_V3 = "Standard_E64s_v3"
    STANDARD_E32_16_V3 = "Standard_E32-16_v3"
    STANDARD_E32_8_S_V3 = "Standard_E32-8s_v3"
    STANDARD_E64_32_S_V3 = "Standard_E64-32s_v3"
    STANDARD_E64_16_S_V3 = "Standard_E64-16s_v3"
    STANDARD_F1 = "Standard_F1"
    STANDARD_F2 = "Standard_F2"
    STANDARD_F4 = "Standard_F4"
    STANDARD_F8 = "Standard_F8"
    STANDARD_F16 = "Standard_F16"
    STANDARD_F1_S = "Standard_F1s"
    STANDARD_F2_S = "Standard_F2s"
    STANDARD_F4_S = "Standard_F4s"
    STANDARD_F8_S = "Standard_F8s"
    STANDARD_F16_S = "Standard_F16s"
    STANDARD_F2_S_V2 = "Standard_F2s_v2"
    STANDARD_F4_S_V2 = "Standard_F4s_v2"
    STANDARD_F8_S_V2 = "Standard_F8s_v2"
    STANDARD_F16_S_V2 = "Standard_F16s_v2"
    STANDARD_F32_S_V2 = "Standard_F32s_v2"
    STANDARD_F64_S_V2 = "Standard_F64s_v2"
    STANDARD_F72_S_V2 = "Standard_F72s_v2"
    STANDARD_G1 = "Standard_G1"
    STANDARD_G2 = "Standard_G2"
    STANDARD_G3 = "Standard_G3"
    STANDARD_G4 = "Standard_G4"
    STANDARD_G5 = "Standard_G5"
    STANDARD_GS1 = "Standard_GS1"
    STANDARD_GS2 = "Standard_GS2"
    STANDARD_GS3 = "Standard_GS3"
    STANDARD_GS4 = "Standard_GS4"
    STANDARD_GS5 = "Standard_GS5"
    STANDARD_GS4_8 = "Standard_GS4-8"
    STANDARD_GS4_4 = "Standard_GS4-4"
    STANDARD_GS5_16 = "Standard_GS5-16"
    STANDARD_GS5_8 = "Standard_GS5-8"
    STANDARD_H8 = "Standard_H8"
    STANDARD_H16 = "Standard_H16"
    STANDARD_H8_M = "Standard_H8m"
    STANDARD_H16_M = "Standard_H16m"
    STANDARD_H16_R = "Standard_H16r"
    STANDARD_H16_MR = "Standard_H16mr"
    STANDARD_L4_S = "Standard_L4s"
    STANDARD_L8_S = "Standard_L8s"
    STANDARD_L16_S = "Standard_L16s"
    STANDARD_L32_S = "Standard_L32s"
    STANDARD_M64_S = "Standard_M64s"
    STANDARD_M64_MS = "Standard_M64ms"
    STANDARD_M128_S = "Standard_M128s"
    STANDARD_M128_MS = "Standard_M128ms"
    STANDARD_M64_32_MS = "Standard_M64-32ms"
    STANDARD_M64_16_MS = "Standard_M64-16ms"
    STANDARD_M128_64_MS = "Standard_M128-64ms"
    STANDARD_M128_32_MS = "Standard_M128-32ms"
    STANDARD_NC6 = "Standard_NC6"
    STANDARD_NC12 = "Standard_NC12"
    STANDARD_NC24 = "Standard_NC24"
    STANDARD_NC24_R = "Standard_NC24r"
    STANDARD_NC6_S_V2 = "Standard_NC6s_v2"
    STANDARD_NC12_S_V2 = "Standard_NC12s_v2"
    STANDARD_NC24_S_V2 = "Standard_NC24s_v2"
    STANDARD_NC24_RS_V2 = "Standard_NC24rs_v2"
    STANDARD_NC6_S_V3 = "Standard_NC6s_v3"
    STANDARD_NC12_S_V3 = "Standard_NC12s_v3"
    STANDARD_NC24_S_V3 = "Standard_NC24s_v3"
    STANDARD_NC24_RS_V3 = "Standard_NC24rs_v3"
    STANDARD_ND6_S = "Standard_ND6s"
    STANDARD_ND12_S = "Standard_ND12s"
    STANDARD_ND24_S = "Standard_ND24s"
    STANDARD_ND24_RS = "Standard_ND24rs"
    STANDARD_NV6 = "Standard_NV6"
    STANDARD_NV12 = "Standard_NV12"
    STANDARD_NV24 = "Standard_NV24"


class VmDiskTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VM disk types which are disallowed."""

    NONE = "None"
    UNMANAGED = "Unmanaged"


class VMGuestPatchClassificationLinux(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VMGuestPatchClassificationLinux."""

    CRITICAL = "Critical"
    SECURITY = "Security"
    OTHER = "Other"


class VMGuestPatchClassificationWindows(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VMGuestPatchClassificationWindows."""

    CRITICAL = "Critical"
    SECURITY = "Security"
    UPDATE_ROLL_UP = "UpdateRollUp"
    FEATURE_PACK = "FeaturePack"
    SERVICE_PACK = "ServicePack"
    DEFINITION = "Definition"
    TOOLS = "Tools"
    UPDATES = "Updates"


class VMGuestPatchRebootBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the reboot requirements of the patch."""

    UNKNOWN = "Unknown"
    NEVER_REBOOTS = "NeverReboots"
    ALWAYS_REQUIRES_REBOOT = "AlwaysRequiresReboot"
    CAN_REQUEST_REBOOT = "CanRequestReboot"


class VMGuestPatchRebootSetting(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines when it is acceptable to reboot a VM during a software update operation."""

    IF_REQUIRED = "IfRequired"
    NEVER = "Never"
    ALWAYS = "Always"


class VMGuestPatchRebootStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reboot state of the VM following completion of the operation."""

    UNKNOWN = "Unknown"
    NOT_NEEDED = "NotNeeded"
    REQUIRED = "Required"
    STARTED = "Started"
    FAILED = "Failed"
    COMPLETED = "Completed"


class WindowsPatchAssessmentMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.\\ :code:`<br
    />`\\ :code:`<br />` Possible values are:\\ :code:`<br />`\\ :code:`<br />` **ImageDefault** -
    You control the timing of patch assessments on a virtual machine.\\ :code:`<br />`\\ :code:`<br
    />` **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The
    property provisionVMAgent must be true.
    """

    IMAGE_DEFAULT = "ImageDefault"
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"


class WindowsVMGuestPatchAutomaticByPlatformRebootSetting(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the reboot setting for all AutomaticByPlatform patch installation operations."""

    UNKNOWN = "Unknown"
    IF_REQUIRED = "IfRequired"
    NEVER = "Never"
    ALWAYS = "Always"


class WindowsVMGuestPatchMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated
    to virtual machine scale set with OrchestrationMode as Flexible.\\ :code:`<br />`\\ :code:`<br
    />` Possible values are:\\ :code:`<br />`\\ :code:`<br />` **Manual** - You  control the
    application of patches to a virtual machine. You do this by applying patches manually inside
    the VM. In this mode, automatic updates are disabled; the property
    WindowsConfiguration.enableAutomaticUpdates must be false\\ :code:`<br />`\\ :code:`<br />`
    **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property
    WindowsConfiguration.enableAutomaticUpdates must be true. :code:`<br />`\\ :code:`<br />`
    **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The
    properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true.
    """

    MANUAL = "Manual"
    AUTOMATIC_BY_OS = "AutomaticByOS"
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"


class ZonalPlatformFaultDomainAlignMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the align mode between Virtual Machine Scale Set compute and storage Fault Domain
    count.
    """

    ALIGNED = "Aligned"
    UNALIGNED = "Unaligned"


class ZonePlacementPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the policy for resource's placement in availability zone. Possible values are:
    **Any** (used for Virtual Machines), **Auto** (used for Virtual Machine Scale Sets) - An
    availability zone will be automatically picked by system as part of resource creation.
    """

    ANY = "Any"
    AUTO = "Auto"
    """Automatic zone placement in a Virtual Machine Scale Set."""
