# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AzStackHCIClusterProperties(_serialization.Model):
    """AzStackHCI cluster properties.

    All required parameters must be populated in order to send to Azure.

    :ivar cluster_name: Gets or sets the AzStackHCICluster FQDN name. Required.
    :vartype cluster_name: str
    :ivar resource_name: Gets or sets the AzStackHCICluster resource name. Required.
    :vartype resource_name: str
    :ivar storage_account_name: Gets or sets the Storage account name. Required.
    :vartype storage_account_name: str
    :ivar storage_containers: Gets or sets the list of AzStackHCICluster Storage Container.
     Required.
    :vartype storage_containers:
     list[~azure.mgmt.recoveryservicesdatareplication.models.StorageContainerProperties]
    """

    _validation = {
        "cluster_name": {"required": True, "min_length": 1},
        "resource_name": {"required": True, "min_length": 1},
        "storage_account_name": {"required": True, "min_length": 1},
        "storage_containers": {"required": True},
    }

    _attribute_map = {
        "cluster_name": {"key": "clusterName", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
        "storage_account_name": {"key": "storageAccountName", "type": "str"},
        "storage_containers": {"key": "storageContainers", "type": "[StorageContainerProperties]"},
    }

    def __init__(
        self,
        *,
        cluster_name: str,
        resource_name: str,
        storage_account_name: str,
        storage_containers: List["_models.StorageContainerProperties"],
        **kwargs: Any
    ) -> None:
        """
        :keyword cluster_name: Gets or sets the AzStackHCICluster FQDN name. Required.
        :paramtype cluster_name: str
        :keyword resource_name: Gets or sets the AzStackHCICluster resource name. Required.
        :paramtype resource_name: str
        :keyword storage_account_name: Gets or sets the Storage account name. Required.
        :paramtype storage_account_name: str
        :keyword storage_containers: Gets or sets the list of AzStackHCICluster Storage Container.
         Required.
        :paramtype storage_containers:
         list[~azure.mgmt.recoveryservicesdatareplication.models.StorageContainerProperties]
        """
        super().__init__(**kwargs)
        self.cluster_name = cluster_name
        self.resource_name = resource_name
        self.storage_account_name = storage_account_name
        self.storage_containers = storage_containers


class FabricModelCustomProperties(_serialization.Model):
    """Fabric model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzStackHCIFabricModelCustomProperties, HyperVMigrateFabricModelCustomProperties,
    VMwareMigrateFabricModelCustomProperties

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "AzStackHCI": "AzStackHCIFabricModelCustomProperties",
            "HyperVMigrate": "HyperVMigrateFabricModelCustomProperties",
            "VMwareMigrate": "VMwareMigrateFabricModelCustomProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class AzStackHCIFabricModelCustomProperties(FabricModelCustomProperties):
    """AzStackHCI fabric model custom properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar az_stack_hci_site_id: Gets or sets the ARM Id of the AzStackHCI site. Required.
    :vartype az_stack_hci_site_id: str
    :ivar appliance_name: Gets or sets the Appliance name.
    :vartype appliance_name: list[str]
    :ivar cluster: AzStackHCI cluster properties. Required.
    :vartype cluster:
     ~azure.mgmt.recoveryservicesdatareplication.models.AzStackHCIClusterProperties
    :ivar fabric_resource_id: Gets or sets the fabric resource Id.
    :vartype fabric_resource_id: str
    :ivar fabric_container_id: Gets or sets the fabric container Id.
    :vartype fabric_container_id: str
    :ivar migration_solution_id: Gets or sets the Migration solution ARM Id. Required.
    :vartype migration_solution_id: str
    :ivar migration_hub_uri: Gets or sets the migration hub Uri.
    :vartype migration_hub_uri: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "az_stack_hci_site_id": {"required": True, "min_length": 1},
        "appliance_name": {"readonly": True},
        "cluster": {"required": True},
        "fabric_resource_id": {"readonly": True},
        "fabric_container_id": {"readonly": True},
        "migration_solution_id": {"required": True, "min_length": 1},
        "migration_hub_uri": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "az_stack_hci_site_id": {"key": "azStackHciSiteId", "type": "str"},
        "appliance_name": {"key": "applianceName", "type": "[str]"},
        "cluster": {"key": "cluster", "type": "AzStackHCIClusterProperties"},
        "fabric_resource_id": {"key": "fabricResourceId", "type": "str"},
        "fabric_container_id": {"key": "fabricContainerId", "type": "str"},
        "migration_solution_id": {"key": "migrationSolutionId", "type": "str"},
        "migration_hub_uri": {"key": "migrationHubUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        az_stack_hci_site_id: str,
        cluster: "_models.AzStackHCIClusterProperties",
        migration_solution_id: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword az_stack_hci_site_id: Gets or sets the ARM Id of the AzStackHCI site. Required.
        :paramtype az_stack_hci_site_id: str
        :keyword cluster: AzStackHCI cluster properties. Required.
        :paramtype cluster:
         ~azure.mgmt.recoveryservicesdatareplication.models.AzStackHCIClusterProperties
        :keyword migration_solution_id: Gets or sets the Migration solution ARM Id. Required.
        :paramtype migration_solution_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "AzStackHCI"
        self.az_stack_hci_site_id = az_stack_hci_site_id
        self.appliance_name = None
        self.cluster = cluster
        self.fabric_resource_id = None
        self.fabric_container_id = None
        self.migration_solution_id = migration_solution_id
        self.migration_hub_uri = None


class CheckNameAvailabilityModel(_serialization.Model):
    """Check name availability model.

    :ivar name: Gets or sets the resource name.
    :vartype name: str
    :ivar type: Gets or sets the resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Gets or sets the resource name.
        :paramtype name: str
        :keyword type: Gets or sets the resource type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponseModel(_serialization.Model):
    """Check name availability response model.

    :ivar name_available: Gets or sets a value indicating whether resource name is available or
     not.
    :vartype name_available: bool
    :ivar reason: Gets or sets the reason for resource name unavailability.
    :vartype reason: str
    :ivar message: Gets or sets the message for resource name unavailability.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Gets or sets a value indicating whether resource name is available or
         not.
        :paramtype name_available: bool
        :keyword reason: Gets or sets the reason for resource name unavailability.
        :paramtype reason: str
        :keyword message: Gets or sets the message for resource name unavailability.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class DeploymentPreflightModel(_serialization.Model):
    """Deployment preflight model.

    :ivar resources: Gets or sets the list of resources.
    :vartype resources:
     list[~azure.mgmt.recoveryservicesdatareplication.models.DeploymentPreflightResource]
    """

    _attribute_map = {
        "resources": {"key": "resources", "type": "[DeploymentPreflightResource]"},
    }

    def __init__(
        self, *, resources: Optional[List["_models.DeploymentPreflightResource"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resources: Gets or sets the list of resources.
        :paramtype resources:
         list[~azure.mgmt.recoveryservicesdatareplication.models.DeploymentPreflightResource]
        """
        super().__init__(**kwargs)
        self.resources = resources


class DeploymentPreflightResource(_serialization.Model):
    """Deployment preflight resource.

    :ivar name: Gets or sets the resource name.
    :vartype name: str
    :ivar type: Gets or sets the resource type.
    :vartype type: str
    :ivar location: Gets or sets the location of the resource.
    :vartype location: str
    :ivar api_version: Gets or sets the Api version.
    :vartype api_version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "api_version": {"key": "apiVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        api_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gets or sets the resource name.
        :paramtype name: str
        :keyword type: Gets or sets the resource type.
        :paramtype type: str
        :keyword location: Gets or sets the location of the resource.
        :paramtype location: str
        :keyword api_version: Gets or sets the Api version.
        :paramtype api_version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.location = location
        self.api_version = api_version


class DraModel(_serialization.Model):
    """Dra model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Dra model properties. Required.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.DraModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.DraModelSystemData
    """

    _validation = {
        "properties": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "DraModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "DraModelSystemData"},
    }

    def __init__(self, *, properties: "_models.DraModelProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Dra model properties. Required.
        :paramtype properties: ~azure.mgmt.recoveryservicesdatareplication.models.DraModelProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class DraModelCollection(_serialization.Model):
    """Dra model collection.

    :ivar value: Gets or sets the list of Dras.
    :vartype value: list[~azure.mgmt.recoveryservicesdatareplication.models.DraModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DraModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DraModel"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of Dras.
        :paramtype value: list[~azure.mgmt.recoveryservicesdatareplication.models.DraModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DraModelCustomProperties(_serialization.Model):
    """Dra model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VMwareDraModelCustomProperties

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"VMware": "VMwareDraModelCustomProperties"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class DraModelProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Dra model properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar correlation_id: Gets or sets the Dra correlation Id.
    :vartype correlation_id: str
    :ivar machine_id: Gets or sets the machine Id where Dra is running. Required.
    :vartype machine_id: str
    :ivar machine_name: Gets or sets the machine name where Dra is running. Required.
    :vartype machine_name: str
    :ivar authentication_identity: Identity model. Required.
    :vartype authentication_identity:
     ~azure.mgmt.recoveryservicesdatareplication.models.IdentityModel
    :ivar resource_access_identity: Identity model. Required.
    :vartype resource_access_identity:
     ~azure.mgmt.recoveryservicesdatareplication.models.IdentityModel
    :ivar is_responsive: Gets or sets a value indicating whether Dra is responsive.
    :vartype is_responsive: bool
    :ivar last_heartbeat: Gets or sets the time when last heartbeat was sent by the Dra.
    :vartype last_heartbeat: ~datetime.datetime
    :ivar version_number: Gets or sets the Dra version.
    :vartype version_number: str
    :ivar provisioning_state: Gets or sets the provisioning state of the Dra. Known values are:
     "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar health_errors: Gets or sets the list of health errors.
    :vartype health_errors:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HealthErrorModel]
    :ivar custom_properties: Dra model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.DraModelCustomProperties
    """

    _validation = {
        "correlation_id": {"readonly": True},
        "machine_id": {"required": True, "min_length": 1},
        "machine_name": {"required": True, "min_length": 1},
        "authentication_identity": {"required": True},
        "resource_access_identity": {"required": True},
        "is_responsive": {"readonly": True},
        "last_heartbeat": {"readonly": True},
        "version_number": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "health_errors": {"readonly": True},
        "custom_properties": {"required": True},
    }

    _attribute_map = {
        "correlation_id": {"key": "correlationId", "type": "str"},
        "machine_id": {"key": "machineId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
        "authentication_identity": {"key": "authenticationIdentity", "type": "IdentityModel"},
        "resource_access_identity": {"key": "resourceAccessIdentity", "type": "IdentityModel"},
        "is_responsive": {"key": "isResponsive", "type": "bool"},
        "last_heartbeat": {"key": "lastHeartbeat", "type": "iso-8601"},
        "version_number": {"key": "versionNumber", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthErrorModel]"},
        "custom_properties": {"key": "customProperties", "type": "DraModelCustomProperties"},
    }

    def __init__(
        self,
        *,
        machine_id: str,
        machine_name: str,
        authentication_identity: "_models.IdentityModel",
        resource_access_identity: "_models.IdentityModel",
        custom_properties: "_models.DraModelCustomProperties",
        **kwargs: Any
    ) -> None:
        """
        :keyword machine_id: Gets or sets the machine Id where Dra is running. Required.
        :paramtype machine_id: str
        :keyword machine_name: Gets or sets the machine name where Dra is running. Required.
        :paramtype machine_name: str
        :keyword authentication_identity: Identity model. Required.
        :paramtype authentication_identity:
         ~azure.mgmt.recoveryservicesdatareplication.models.IdentityModel
        :keyword resource_access_identity: Identity model. Required.
        :paramtype resource_access_identity:
         ~azure.mgmt.recoveryservicesdatareplication.models.IdentityModel
        :keyword custom_properties: Dra model custom properties. Required.
        :paramtype custom_properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.DraModelCustomProperties
        """
        super().__init__(**kwargs)
        self.correlation_id = None
        self.machine_id = machine_id
        self.machine_name = machine_name
        self.authentication_identity = authentication_identity
        self.resource_access_identity = resource_access_identity
        self.is_responsive = None
        self.last_heartbeat = None
        self.version_number = None
        self.provisioning_state = None
        self.health_errors = None
        self.custom_properties = custom_properties


class SystemDataModel(_serialization.Model):
    """System data required to be defined for Azure resources.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class DraModelSystemData(SystemDataModel):
    """DraModelSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class EmailConfigurationModel(_serialization.Model):
    """Email configuration model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Email configuration model properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.EmailConfigurationModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data:
     ~azure.mgmt.recoveryservicesdatareplication.models.EmailConfigurationModelSystemData
    """

    _validation = {
        "properties": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "EmailConfigurationModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "EmailConfigurationModelSystemData"},
    }

    def __init__(self, *, properties: "_models.EmailConfigurationModelProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Email configuration model properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.EmailConfigurationModelProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class EmailConfigurationModelCollection(_serialization.Model):
    """Email configuration model collection.

    :ivar value: Gets or sets the list of email configurations.
    :vartype value:
     list[~azure.mgmt.recoveryservicesdatareplication.models.EmailConfigurationModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EmailConfigurationModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EmailConfigurationModel"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of email configurations.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesdatareplication.models.EmailConfigurationModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EmailConfigurationModelProperties(_serialization.Model):
    """Email configuration model properties.

    All required parameters must be populated in order to send to Azure.

    :ivar send_to_owners: Gets or sets a value indicating whether to send email to subscription
     administrator. Required.
    :vartype send_to_owners: bool
    :ivar custom_email_addresses: Gets or sets the custom email address for sending emails.
    :vartype custom_email_addresses: list[str]
    :ivar locale: Gets or sets the locale for the email notification.
    :vartype locale: str
    """

    _validation = {
        "send_to_owners": {"required": True},
    }

    _attribute_map = {
        "send_to_owners": {"key": "sendToOwners", "type": "bool"},
        "custom_email_addresses": {"key": "customEmailAddresses", "type": "[str]"},
        "locale": {"key": "locale", "type": "str"},
    }

    def __init__(
        self,
        *,
        send_to_owners: bool,
        custom_email_addresses: Optional[List[str]] = None,
        locale: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword send_to_owners: Gets or sets a value indicating whether to send email to subscription
         administrator. Required.
        :paramtype send_to_owners: bool
        :keyword custom_email_addresses: Gets or sets the custom email address for sending emails.
        :paramtype custom_email_addresses: list[str]
        :keyword locale: Gets or sets the locale for the email notification.
        :paramtype locale: str
        """
        super().__init__(**kwargs)
        self.send_to_owners = send_to_owners
        self.custom_email_addresses = custom_email_addresses
        self.locale = locale


class EmailConfigurationModelSystemData(SystemDataModel):
    """EmailConfigurationModelSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.recoveryservicesdatareplication.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.recoveryservicesdatareplication.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorModel(_serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Gets or sets the error code.
    :vartype code: str
    :ivar type: Gets or sets the error type.
    :vartype type: str
    :ivar severity: Gets or sets the error severity.
    :vartype severity: str
    :ivar creation_time: Gets or sets the creation time of error.
    :vartype creation_time: ~datetime.datetime
    :ivar message: Gets or sets the error message.
    :vartype message: str
    :ivar causes: Gets or sets the possible causes of error.
    :vartype causes: str
    :ivar recommendation: Gets or sets the recommended action to resolve error.
    :vartype recommendation: str
    """

    _validation = {
        "code": {"readonly": True},
        "type": {"readonly": True},
        "severity": {"readonly": True},
        "creation_time": {"readonly": True},
        "message": {"readonly": True},
        "causes": {"readonly": True},
        "recommendation": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "causes": {"key": "causes", "type": "str"},
        "recommendation": {"key": "recommendation", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.type = None
        self.severity = None
        self.creation_time = None
        self.message = None
        self.causes = None
        self.recommendation = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.recoveryservicesdatareplication.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.recoveryservicesdatareplication.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class EventModel(_serialization.Model):
    """Event model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Event model properties. Required.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.EventModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.EventModelSystemData
    """

    _validation = {
        "properties": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "EventModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "EventModelSystemData"},
    }

    def __init__(self, *, properties: "_models.EventModelProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Event model properties. Required.
        :paramtype properties: ~azure.mgmt.recoveryservicesdatareplication.models.EventModelProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class EventModelCollection(_serialization.Model):
    """Event model collection.

    :ivar value: Gets or sets the list of events.
    :vartype value: list[~azure.mgmt.recoveryservicesdatareplication.models.EventModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EventModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.EventModel"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of events.
        :paramtype value: list[~azure.mgmt.recoveryservicesdatareplication.models.EventModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventModelCustomProperties(_serialization.Model):
    """Event model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIEventModelCustomProperties

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"HyperVToAzStackHCI": "HyperVToAzStackHCIEventModelCustomProperties"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class EventModelProperties(_serialization.Model):
    """Event model properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: Gets or sets the resource type.
    :vartype resource_type: str
    :ivar resource_name: Gets or sets the resource name.
    :vartype resource_name: str
    :ivar event_type: Gets or sets the event type.
    :vartype event_type: str
    :ivar event_name: Gets or sets the event name.
    :vartype event_name: str
    :ivar time_of_occurrence: Gets or sets the time at which the event occurred at source.
    :vartype time_of_occurrence: ~datetime.datetime
    :ivar severity: Gets or sets the event severity.
    :vartype severity: str
    :ivar description: Gets or sets the event description.
    :vartype description: str
    :ivar correlation_id: Gets or sets the event correlation Id.
    :vartype correlation_id: str
    :ivar health_errors: Gets or sets the errors associated with this event.
    :vartype health_errors:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HealthErrorModel]
    :ivar custom_properties: Event model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.EventModelCustomProperties
    """

    _validation = {
        "resource_type": {"readonly": True},
        "resource_name": {"readonly": True},
        "event_type": {"readonly": True},
        "event_name": {"readonly": True},
        "time_of_occurrence": {"readonly": True},
        "severity": {"readonly": True},
        "description": {"readonly": True},
        "correlation_id": {"readonly": True},
        "health_errors": {"readonly": True},
        "custom_properties": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
        "event_type": {"key": "eventType", "type": "str"},
        "event_name": {"key": "eventName", "type": "str"},
        "time_of_occurrence": {"key": "timeOfOccurrence", "type": "iso-8601"},
        "severity": {"key": "severity", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthErrorModel]"},
        "custom_properties": {"key": "customProperties", "type": "EventModelCustomProperties"},
    }

    def __init__(self, *, custom_properties: "_models.EventModelCustomProperties", **kwargs: Any) -> None:
        """
        :keyword custom_properties: Event model custom properties. Required.
        :paramtype custom_properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.EventModelCustomProperties
        """
        super().__init__(**kwargs)
        self.resource_type = None
        self.resource_name = None
        self.event_type = None
        self.event_name = None
        self.time_of_occurrence = None
        self.severity = None
        self.description = None
        self.correlation_id = None
        self.health_errors = None
        self.custom_properties = custom_properties


class EventModelSystemData(SystemDataModel):
    """EventModelSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class FabricModel(_serialization.Model):
    """Fabric model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Gets or sets the location of the fabric. Required.
    :vartype location: str
    :ivar tags: Gets or sets the resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Fabric model properties. Required.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelSystemData
    """

    _validation = {
        "location": {"required": True, "min_length": 1},
        "properties": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "FabricModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "FabricModelSystemData"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.FabricModelProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets or sets the location of the fabric. Required.
        :paramtype location: str
        :keyword tags: Gets or sets the resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Fabric model properties. Required.
        :paramtype properties: ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class FabricModelCollection(_serialization.Model):
    """Fabric model collection.

    :ivar value: Gets or sets the list of fabrics.
    :vartype value: list[~azure.mgmt.recoveryservicesdatareplication.models.FabricModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FabricModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.FabricModel"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of fabrics.
        :paramtype value: list[~azure.mgmt.recoveryservicesdatareplication.models.FabricModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FabricModelProperties(_serialization.Model):
    """Fabric model properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Gets or sets the provisioning state of the fabric. Known values are:
     "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar service_endpoint: Gets or sets the service endpoint.
    :vartype service_endpoint: str
    :ivar service_resource_id: Gets or sets the service resource Id.
    :vartype service_resource_id: str
    :ivar health: Gets or sets the fabric health. Known values are: "Normal", "Warning", and
     "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicesdatareplication.models.HealthStatus
    :ivar health_errors: Gets or sets the list of health errors.
    :vartype health_errors:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HealthErrorModel]
    :ivar custom_properties: Fabric model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelCustomProperties
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "service_endpoint": {"readonly": True},
        "service_resource_id": {"readonly": True},
        "health": {"readonly": True},
        "health_errors": {"readonly": True},
        "custom_properties": {"required": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "service_endpoint": {"key": "serviceEndpoint", "type": "str"},
        "service_resource_id": {"key": "serviceResourceId", "type": "str"},
        "health": {"key": "health", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthErrorModel]"},
        "custom_properties": {"key": "customProperties", "type": "FabricModelCustomProperties"},
    }

    def __init__(self, *, custom_properties: "_models.FabricModelCustomProperties", **kwargs: Any) -> None:
        """
        :keyword custom_properties: Fabric model custom properties. Required.
        :paramtype custom_properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelCustomProperties
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.service_endpoint = None
        self.service_resource_id = None
        self.health = None
        self.health_errors = None
        self.custom_properties = custom_properties


class FabricModelSystemData(SystemDataModel):
    """FabricModelSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class FabricModelUpdate(_serialization.Model):
    """Fabric model for update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Gets or sets the resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Fabric model properties.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data:
     ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelUpdateSystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "FabricModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "FabricModelUpdateSystemData"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.FabricModelProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Gets or sets the resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Fabric model properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesdatareplication.models.FabricModelProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class FabricModelUpdateSystemData(SystemDataModel):
    """FabricModelUpdateSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class FailoverProtectedItemProperties(_serialization.Model):
    """Failover properties of the protected item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar protected_item_name: Gets or sets the protected item name.
    :vartype protected_item_name: str
    :ivar vm_name: Gets or sets the VM name.
    :vartype vm_name: str
    :ivar test_vm_name: Gets or sets the test VM name.
    :vartype test_vm_name: str
    :ivar recovery_point_id: Gets or sets the recovery point Id.
    :vartype recovery_point_id: str
    :ivar recovery_point_time: Gets or sets the recovery point time.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar network_name: Gets or sets the network name.
    :vartype network_name: str
    :ivar subnet: Gets or sets the network subnet.
    :vartype subnet: str
    """

    _validation = {
        "protected_item_name": {"readonly": True},
        "vm_name": {"readonly": True},
        "test_vm_name": {"readonly": True},
        "recovery_point_id": {"readonly": True},
        "recovery_point_time": {"readonly": True},
        "network_name": {"readonly": True},
        "subnet": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_name": {"key": "protectedItemName", "type": "str"},
        "vm_name": {"key": "vmName", "type": "str"},
        "test_vm_name": {"key": "testVmName", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
        "network_name": {"key": "networkName", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.protected_item_name = None
        self.vm_name = None
        self.test_vm_name = None
        self.recovery_point_id = None
        self.recovery_point_time = None
        self.network_name = None
        self.subnet = None


class WorkflowModelCustomProperties(_serialization.Model):
    """Workflow model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FailoverWorkflowModelCustomProperties, TestFailoverCleanupWorkflowModelCustomProperties,
    TestFailoverWorkflowModelCustomProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar affected_object_details: Gets or sets any custom properties of the affected object.
    :vartype affected_object_details: dict[str, str]
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "affected_object_details": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "affected_object_details": {"key": "affectedObjectDetails", "type": "{str}"},
    }

    _subtype_map = {
        "instance_type": {
            "FailoverWorkflowDetails": "FailoverWorkflowModelCustomProperties",
            "TestFailoverCleanupWorkflowDetails": "TestFailoverCleanupWorkflowModelCustomProperties",
            "TestFailoverWorkflowDetails": "TestFailoverWorkflowModelCustomProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None
        self.affected_object_details = None


class FailoverWorkflowModelCustomProperties(WorkflowModelCustomProperties):
    """Failover workflow model custom properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar affected_object_details: Gets or sets any custom properties of the affected object.
    :vartype affected_object_details: dict[str, str]
    :ivar protected_item_details: Gets or sets the failed over protected item details.
    :vartype protected_item_details:
     list[~azure.mgmt.recoveryservicesdatareplication.models.FailoverProtectedItemProperties]
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "affected_object_details": {"readonly": True},
        "protected_item_details": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "affected_object_details": {"key": "affectedObjectDetails", "type": "{str}"},
        "protected_item_details": {"key": "protectedItemDetails", "type": "[FailoverProtectedItemProperties]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "FailoverWorkflowDetails"
        self.protected_item_details = None


class HealthErrorModel(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Health error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar affected_resource_type: Gets or sets the type of affected resource type.
    :vartype affected_resource_type: str
    :ivar affected_resource_correlation_ids: Gets or sets the list of affected resource correlation
     Ids. This can be used to
     uniquely identify the count of items affected by a specific category and severity
     as well as count of item affected by an specific issue.
    :vartype affected_resource_correlation_ids: list[str]
    :ivar child_errors: Gets or sets a list of child health errors associated with this error.
    :vartype child_errors:
     list[~azure.mgmt.recoveryservicesdatareplication.models.InnerHealthErrorModel]
    :ivar code: Gets or sets the error code.
    :vartype code: str
    :ivar health_category: Gets or sets the health category.
    :vartype health_category: str
    :ivar category: Gets or sets the error category.
    :vartype category: str
    :ivar severity: Gets or sets the error severity.
    :vartype severity: str
    :ivar source: Gets or sets the error source.
    :vartype source: str
    :ivar creation_time: Gets or sets the error creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar is_customer_resolvable: Gets or sets a value indicating whether the error is customer
     resolvable.
    :vartype is_customer_resolvable: bool
    :ivar summary: Gets or sets the error summary.
    :vartype summary: str
    :ivar message: Gets or sets the error message.
    :vartype message: str
    :ivar causes: Gets or sets possible causes of the error.
    :vartype causes: str
    :ivar recommendation: Gets or sets recommended action to resolve the error.
    :vartype recommendation: str
    """

    _validation = {
        "code": {"readonly": True},
        "health_category": {"readonly": True},
        "category": {"readonly": True},
        "severity": {"readonly": True},
        "source": {"readonly": True},
        "creation_time": {"readonly": True},
        "is_customer_resolvable": {"readonly": True},
        "summary": {"readonly": True},
        "message": {"readonly": True},
        "causes": {"readonly": True},
        "recommendation": {"readonly": True},
    }

    _attribute_map = {
        "affected_resource_type": {"key": "affectedResourceType", "type": "str"},
        "affected_resource_correlation_ids": {"key": "affectedResourceCorrelationIds", "type": "[str]"},
        "child_errors": {"key": "childErrors", "type": "[InnerHealthErrorModel]"},
        "code": {"key": "code", "type": "str"},
        "health_category": {"key": "healthCategory", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "is_customer_resolvable": {"key": "isCustomerResolvable", "type": "bool"},
        "summary": {"key": "summary", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "causes": {"key": "causes", "type": "str"},
        "recommendation": {"key": "recommendation", "type": "str"},
    }

    def __init__(
        self,
        *,
        affected_resource_type: Optional[str] = None,
        affected_resource_correlation_ids: Optional[List[str]] = None,
        child_errors: Optional[List["_models.InnerHealthErrorModel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword affected_resource_type: Gets or sets the type of affected resource type.
        :paramtype affected_resource_type: str
        :keyword affected_resource_correlation_ids: Gets or sets the list of affected resource
         correlation Ids. This can be used to
         uniquely identify the count of items affected by a specific category and severity
         as well as count of item affected by an specific issue.
        :paramtype affected_resource_correlation_ids: list[str]
        :keyword child_errors: Gets or sets a list of child health errors associated with this error.
        :paramtype child_errors:
         list[~azure.mgmt.recoveryservicesdatareplication.models.InnerHealthErrorModel]
        """
        super().__init__(**kwargs)
        self.affected_resource_type = affected_resource_type
        self.affected_resource_correlation_ids = affected_resource_correlation_ids
        self.child_errors = child_errors
        self.code = None
        self.health_category = None
        self.category = None
        self.severity = None
        self.source = None
        self.creation_time = None
        self.is_customer_resolvable = None
        self.summary = None
        self.message = None
        self.causes = None
        self.recommendation = None


class HyperVMigrateFabricModelCustomProperties(FabricModelCustomProperties):
    """HyperV migrate fabric model custom properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar hyper_v_site_id: Gets or sets the ARM Id of the HyperV site. Required.
    :vartype hyper_v_site_id: str
    :ivar fabric_resource_id: Gets or sets the fabric resource Id.
    :vartype fabric_resource_id: str
    :ivar fabric_container_id: Gets or sets the fabric container Id.
    :vartype fabric_container_id: str
    :ivar migration_solution_id: Gets or sets the migration solution ARM Id. Required.
    :vartype migration_solution_id: str
    :ivar migration_hub_uri: Gets or sets the migration hub Uri.
    :vartype migration_hub_uri: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "hyper_v_site_id": {"required": True, "min_length": 1},
        "fabric_resource_id": {"readonly": True},
        "fabric_container_id": {"readonly": True},
        "migration_solution_id": {"required": True, "min_length": 1},
        "migration_hub_uri": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "hyper_v_site_id": {"key": "hyperVSiteId", "type": "str"},
        "fabric_resource_id": {"key": "fabricResourceId", "type": "str"},
        "fabric_container_id": {"key": "fabricContainerId", "type": "str"},
        "migration_solution_id": {"key": "migrationSolutionId", "type": "str"},
        "migration_hub_uri": {"key": "migrationHubUri", "type": "str"},
    }

    def __init__(self, *, hyper_v_site_id: str, migration_solution_id: str, **kwargs: Any) -> None:
        """
        :keyword hyper_v_site_id: Gets or sets the ARM Id of the HyperV site. Required.
        :paramtype hyper_v_site_id: str
        :keyword migration_solution_id: Gets or sets the migration solution ARM Id. Required.
        :paramtype migration_solution_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVMigrate"
        self.hyper_v_site_id = hyper_v_site_id
        self.fabric_resource_id = None
        self.fabric_container_id = None
        self.migration_solution_id = migration_solution_id
        self.migration_hub_uri = None


class HyperVToAzStackHCIDiskInput(_serialization.Model):
    """HyperVToAzStack disk input.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_id: Gets or sets the disk Id. Required.
    :vartype disk_id: str
    :ivar storage_container_id: Gets or sets the target storage account ARM Id.
    :vartype storage_container_id: str
    :ivar is_dynamic: Gets or sets a value indicating whether dynamic sizing is enabled on the
     virtual hard
     disk.
    :vartype is_dynamic: bool
    :ivar disk_size_gb: Gets or sets the disk size in GB. Required.
    :vartype disk_size_gb: int
    :ivar disk_file_format: Gets or sets the type of the virtual hard disk, vhd or vhdx. Required.
    :vartype disk_file_format: str
    :ivar is_os_disk: Gets or sets a value indicating whether disk is os disk. Required.
    :vartype is_os_disk: bool
    """

    _validation = {
        "disk_id": {"required": True, "min_length": 1},
        "disk_size_gb": {"required": True},
        "disk_file_format": {"required": True, "min_length": 1},
        "is_os_disk": {"required": True},
    }

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "storage_container_id": {"key": "storageContainerId", "type": "str"},
        "is_dynamic": {"key": "isDynamic", "type": "bool"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "disk_file_format": {"key": "diskFileFormat", "type": "str"},
        "is_os_disk": {"key": "isOsDisk", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        disk_size_gb: int,
        disk_file_format: str,
        is_os_disk: bool,
        storage_container_id: Optional[str] = None,
        is_dynamic: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_id: Gets or sets the disk Id. Required.
        :paramtype disk_id: str
        :keyword storage_container_id: Gets or sets the target storage account ARM Id.
        :paramtype storage_container_id: str
        :keyword is_dynamic: Gets or sets a value indicating whether dynamic sizing is enabled on the
         virtual hard
         disk.
        :paramtype is_dynamic: bool
        :keyword disk_size_gb: Gets or sets the disk size in GB. Required.
        :paramtype disk_size_gb: int
        :keyword disk_file_format: Gets or sets the type of the virtual hard disk, vhd or vhdx.
         Required.
        :paramtype disk_file_format: str
        :keyword is_os_disk: Gets or sets a value indicating whether disk is os disk. Required.
        :paramtype is_os_disk: bool
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.storage_container_id = storage_container_id
        self.is_dynamic = is_dynamic
        self.disk_size_gb = disk_size_gb
        self.disk_file_format = disk_file_format
        self.is_os_disk = is_os_disk


class HyperVToAzStackHCIEventModelCustomProperties(EventModelCustomProperties):
    """HyperV to  AzStackHCI event model custom properties. This class provides provider specific
    details for events of type DataContract.HealthEvents.HealthEventType.ProtectedItemHealth and
    DataContract.HealthEvents.HealthEventType.AgentHealth.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar event_source_friendly_name: Gets or sets the friendly name of the source which has raised
     this health event.
    :vartype event_source_friendly_name: str
    :ivar protected_item_friendly_name: Gets or sets the protected item friendly name.
    :vartype protected_item_friendly_name: str
    :ivar source_appliance_name: Gets or sets the source appliance name.
    :vartype source_appliance_name: str
    :ivar target_appliance_name: Gets or sets the source target name.
    :vartype target_appliance_name: str
    :ivar server_type: Gets or sets the server type.
    :vartype server_type: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "event_source_friendly_name": {"readonly": True},
        "protected_item_friendly_name": {"readonly": True},
        "source_appliance_name": {"readonly": True},
        "target_appliance_name": {"readonly": True},
        "server_type": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "event_source_friendly_name": {"key": "eventSourceFriendlyName", "type": "str"},
        "protected_item_friendly_name": {"key": "protectedItemFriendlyName", "type": "str"},
        "source_appliance_name": {"key": "sourceApplianceName", "type": "str"},
        "target_appliance_name": {"key": "targetApplianceName", "type": "str"},
        "server_type": {"key": "serverType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVToAzStackHCI"
        self.event_source_friendly_name = None
        self.protected_item_friendly_name = None
        self.source_appliance_name = None
        self.target_appliance_name = None
        self.server_type = None


class HyperVToAzStackHCINicInput(_serialization.Model):
    """HyperVToAzStackHCI NIC properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar nic_id: Gets or sets the NIC Id. Required.
    :vartype nic_id: str
    :ivar network_name: Gets or sets the network name.
    :vartype network_name: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
     Required.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
     Required.
    :vartype test_network_id: str
    :ivar selection_type_for_failover: Gets or sets the selection type of the NIC. Required. Known
     values are: "NotSelected", "SelectedByUser", "SelectedByDefault", and "SelectedByUserOverride".
    :vartype selection_type_for_failover: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.VMNicSelection
    """

    _validation = {
        "nic_id": {"required": True, "min_length": 1},
        "network_name": {"readonly": True},
        "target_network_id": {"required": True, "min_length": 1},
        "test_network_id": {"required": True, "min_length": 1},
        "selection_type_for_failover": {"required": True},
    }

    _attribute_map = {
        "nic_id": {"key": "nicId", "type": "str"},
        "network_name": {"key": "networkName", "type": "str"},
        "target_network_id": {"key": "targetNetworkId", "type": "str"},
        "test_network_id": {"key": "testNetworkId", "type": "str"},
        "selection_type_for_failover": {"key": "selectionTypeForFailover", "type": "str"},
    }

    def __init__(
        self,
        *,
        nic_id: str,
        target_network_id: str,
        test_network_id: str,
        selection_type_for_failover: Union[str, "_models.VMNicSelection"],
        **kwargs: Any
    ) -> None:
        """
        :keyword nic_id: Gets or sets the NIC Id. Required.
        :paramtype nic_id: str
        :keyword target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
         Required.
        :paramtype target_network_id: str
        :keyword test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
         Required.
        :paramtype test_network_id: str
        :keyword selection_type_for_failover: Gets or sets the selection type of the NIC. Required.
         Known values are: "NotSelected", "SelectedByUser", "SelectedByDefault", and
         "SelectedByUserOverride".
        :paramtype selection_type_for_failover: str or
         ~azure.mgmt.recoveryservicesdatareplication.models.VMNicSelection
        """
        super().__init__(**kwargs)
        self.nic_id = nic_id
        self.network_name = None
        self.target_network_id = target_network_id
        self.test_network_id = test_network_id
        self.selection_type_for_failover = selection_type_for_failover


class PlannedFailoverModelCustomProperties(_serialization.Model):
    """Planned failover model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIPlannedFailoverModelCustomProperties,
    VMwareToAzStackHCIPlannedFailoverModelCustomProperties

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "HyperVToAzStackHCI": "HyperVToAzStackHCIPlannedFailoverModelCustomProperties",
            "VMwareToAzStackHCI": "VMwareToAzStackHCIPlannedFailoverModelCustomProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class HyperVToAzStackHCIPlannedFailoverModelCustomProperties(PlannedFailoverModelCustomProperties):
    """HyperV to AzStackHCI planned failover model custom properties.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar shutdown_source_vm: Gets or sets a value indicating whether VM needs to be shut down.
     Required.
    :vartype shutdown_source_vm: bool
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "shutdown_source_vm": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "shutdown_source_vm": {"key": "shutdownSourceVM", "type": "bool"},
    }

    def __init__(self, *, shutdown_source_vm: bool, **kwargs: Any) -> None:
        """
        :keyword shutdown_source_vm: Gets or sets a value indicating whether VM needs to be shut down.
         Required.
        :paramtype shutdown_source_vm: bool
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVToAzStackHCI"
        self.shutdown_source_vm = shutdown_source_vm


class PolicyModelCustomProperties(_serialization.Model):
    """Policy model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIPolicyModelCustomProperties, VMwareToAzStackHCIPolicyModelCustomProperties

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "HyperVToAzStackHCI": "HyperVToAzStackHCIPolicyModelCustomProperties",
            "VMwareToAzStackHCI": "VMwareToAzStackHCIPolicyModelCustomProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class HyperVToAzStackHCIPolicyModelCustomProperties(PolicyModelCustomProperties):
    """HyperV To AzStackHCI Policy model custom properties.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar recovery_point_history_in_minutes: Gets or sets the duration in minutes until which the
     recovery points need to be
     stored. Required.
    :vartype recovery_point_history_in_minutes: int
    :ivar crash_consistent_frequency_in_minutes: Gets or sets the crash consistent snapshot
     frequency (in minutes). Required.
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar app_consistent_frequency_in_minutes: Gets or sets the app consistent snapshot frequency
     (in minutes). Required.
    :vartype app_consistent_frequency_in_minutes: int
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "recovery_point_history_in_minutes": {"required": True},
        "crash_consistent_frequency_in_minutes": {"required": True},
        "app_consistent_frequency_in_minutes": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_history_in_minutes": {"key": "recoveryPointHistoryInMinutes", "type": "int"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        recovery_point_history_in_minutes: int,
        crash_consistent_frequency_in_minutes: int,
        app_consistent_frequency_in_minutes: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_history_in_minutes: Gets or sets the duration in minutes until which
         the recovery points need to be
         stored. Required.
        :paramtype recovery_point_history_in_minutes: int
        :keyword crash_consistent_frequency_in_minutes: Gets or sets the crash consistent snapshot
         frequency (in minutes). Required.
        :paramtype crash_consistent_frequency_in_minutes: int
        :keyword app_consistent_frequency_in_minutes: Gets or sets the app consistent snapshot
         frequency (in minutes). Required.
        :paramtype app_consistent_frequency_in_minutes: int
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVToAzStackHCI"
        self.recovery_point_history_in_minutes = recovery_point_history_in_minutes
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes


class HyperVToAzStackHCIProtectedDiskProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """HyperVToAzStackHCI protected disk properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_container_id: Gets or sets the ARM Id of the storage container.
    :vartype storage_container_id: str
    :ivar storage_container_local_path: Gets or sets the local path of the storage container.
    :vartype storage_container_local_path: str
    :ivar source_disk_id: Gets or sets the source disk Id.
    :vartype source_disk_id: str
    :ivar source_disk_name: Gets or sets the source disk Name.
    :vartype source_disk_name: str
    :ivar seed_disk_name: Gets or sets the seed disk name.
    :vartype seed_disk_name: str
    :ivar test_migrate_disk_name: Gets or sets the test failover clone disk.
    :vartype test_migrate_disk_name: str
    :ivar migrate_disk_name: Gets or sets the failover clone disk.
    :vartype migrate_disk_name: str
    :ivar is_os_disk: Gets or sets a value indicating whether the disk is the OS disk.
    :vartype is_os_disk: bool
    :ivar capacity_in_bytes: Gets or sets the disk capacity in bytes.
    :vartype capacity_in_bytes: int
    :ivar is_dynamic: Gets or sets a value indicating whether dynamic sizing is enabled on the
     virtual hard
     disk.
    :vartype is_dynamic: bool
    :ivar disk_type: Gets or sets the disk type.
    :vartype disk_type: str
    """

    _validation = {
        "storage_container_id": {"readonly": True},
        "storage_container_local_path": {"readonly": True},
        "source_disk_id": {"readonly": True},
        "source_disk_name": {"readonly": True},
        "seed_disk_name": {"readonly": True},
        "test_migrate_disk_name": {"readonly": True},
        "migrate_disk_name": {"readonly": True},
        "is_os_disk": {"readonly": True},
        "capacity_in_bytes": {"readonly": True},
        "is_dynamic": {"readonly": True},
        "disk_type": {"readonly": True},
    }

    _attribute_map = {
        "storage_container_id": {"key": "storageContainerId", "type": "str"},
        "storage_container_local_path": {"key": "storageContainerLocalPath", "type": "str"},
        "source_disk_id": {"key": "sourceDiskId", "type": "str"},
        "source_disk_name": {"key": "sourceDiskName", "type": "str"},
        "seed_disk_name": {"key": "seedDiskName", "type": "str"},
        "test_migrate_disk_name": {"key": "testMigrateDiskName", "type": "str"},
        "migrate_disk_name": {"key": "migrateDiskName", "type": "str"},
        "is_os_disk": {"key": "isOsDisk", "type": "bool"},
        "capacity_in_bytes": {"key": "capacityInBytes", "type": "int"},
        "is_dynamic": {"key": "isDynamic", "type": "bool"},
        "disk_type": {"key": "diskType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.storage_container_id = None
        self.storage_container_local_path = None
        self.source_disk_id = None
        self.source_disk_name = None
        self.seed_disk_name = None
        self.test_migrate_disk_name = None
        self.migrate_disk_name = None
        self.is_os_disk = None
        self.capacity_in_bytes = None
        self.is_dynamic = None
        self.disk_type = None


class ProtectedItemModelCustomProperties(_serialization.Model):
    """Protected item model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIProtectedItemModelCustomProperties,
    VMwareToAzStackHCIProtectedItemModelCustomProperties

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "HyperVToAzStackHCI": "HyperVToAzStackHCIProtectedItemModelCustomProperties",
            "VMwareToAzStackHCI": "VMwareToAzStackHCIProtectedItemModelCustomProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class HyperVToAzStackHCIProtectedItemModelCustomProperties(
    ProtectedItemModelCustomProperties
):  # pylint: disable=too-many-instance-attributes
    """HyperV to AzStackHCI Protected item model custom properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar active_location: Gets or sets the location of the protected item. Known values are:
     "Primary" and "Recovery".
    :vartype active_location: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemActiveLocation
    :ivar target_hci_cluster_id: Gets or sets the Target HCI Cluster ARM Id. Required.
    :vartype target_hci_cluster_id: str
    :ivar target_arc_cluster_custom_location_id: Gets or sets the Target Arc Cluster Custom
     Location ARM Id. Required.
    :vartype target_arc_cluster_custom_location_id: str
    :ivar target_az_stack_hci_cluster_name: Gets or sets the Target AzStackHCI cluster name.
    :vartype target_az_stack_hci_cluster_name: str
    :ivar fabric_discovery_machine_id: Gets or sets the ARM Id of the discovered machine. Required.
    :vartype fabric_discovery_machine_id: str
    :ivar disks_to_include: Gets or sets the list of disks to replicate. Required.
    :vartype disks_to_include:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCIDiskInput]
    :ivar nics_to_include: Gets or sets the list of VM NIC to replicate. Required.
    :vartype nics_to_include:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCINicInput]
    :ivar source_vm_name: Gets or sets the source VM display name.
    :vartype source_vm_name: str
    :ivar source_cpu_cores: Gets or sets the source VM CPU cores.
    :vartype source_cpu_cores: int
    :ivar source_memory_in_mega_bytes: Gets or sets the source VM ram memory size in megabytes.
    :vartype source_memory_in_mega_bytes: float
    :ivar target_vm_name: Gets or sets the target VM display name.
    :vartype target_vm_name: str
    :ivar target_resource_group_id: Gets or sets the target resource group ARM Id. Required.
    :vartype target_resource_group_id: str
    :ivar storage_container_id: Gets or sets the target storage container ARM Id. Required.
    :vartype storage_container_id: str
    :ivar hyper_v_generation: Gets or sets the hypervisor generation of the virtual machine.
     Required.
    :vartype hyper_v_generation: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
    :vartype test_network_id: str
    :ivar target_cpu_cores: Gets or sets the target CPU cores.
    :vartype target_cpu_cores: int
    :ivar is_dynamic_ram: Gets or sets a value indicating whether memory is dynamical.
    :vartype is_dynamic_ram: bool
    :ivar dynamic_memory_config: Protected item dynamic memory config.
    :vartype dynamic_memory_config:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemDynamicMemoryConfig
    :ivar target_memory_in_mega_bytes: Gets or sets the target memory in mega-bytes.
    :vartype target_memory_in_mega_bytes: int
    :ivar run_as_account_id: Gets or sets the Run As account Id. Required.
    :vartype run_as_account_id: str
    :ivar source_dra_name: Gets or sets the source DRA name. Required.
    :vartype source_dra_name: str
    :ivar target_dra_name: Gets or sets the target DRA name. Required.
    :vartype target_dra_name: str
    :ivar source_appliance_name: Gets or sets the source appliance name.
    :vartype source_appliance_name: str
    :ivar target_appliance_name: Gets or sets the target appliance name.
    :vartype target_appliance_name: str
    :ivar os_type: Gets or sets the type of the OS.
    :vartype os_type: str
    :ivar os_name: Gets or sets the name of the OS.
    :vartype os_name: str
    :ivar firmware_type: Gets or sets the firmware type.
    :vartype firmware_type: str
    :ivar target_location: Gets or sets the target location.
    :vartype target_location: str
    :ivar custom_location_region: Gets or sets the location of Azure Arc HCI custom location
     resource. Required.
    :vartype custom_location_region: str
    :ivar failover_recovery_point_id: Gets or sets the recovery point Id to which the VM was failed
     over.
    :vartype failover_recovery_point_id: str
    :ivar last_recovery_point_received: Gets or sets the last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :ivar last_recovery_point_id: Gets or sets the last recovery point Id.
    :vartype last_recovery_point_id: str
    :ivar initial_replication_progress_percentage: Gets or sets the initial replication progress
     percentage. This is calculated based on
     total bytes processed for all disks in the source VM.
    :vartype initial_replication_progress_percentage: int
    :ivar resync_progress_percentage: Gets or sets the resync progress percentage. This is
     calculated based on total bytes
     processed for all disks in the source VM.
    :vartype resync_progress_percentage: int
    :ivar protected_disks: Gets or sets the list of protected disks.
    :vartype protected_disks:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCIProtectedDiskProperties]
    :ivar protected_nics: Gets or sets the VM NIC details.
    :vartype protected_nics:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCIProtectedNicProperties]
    :ivar target_vm_bios_id: Gets or sets the BIOS Id of the target AzStackHCI VM.
    :vartype target_vm_bios_id: str
    :ivar last_replication_update_time: Gets or sets the latest timestamp that replication status
     is updated.
    :vartype last_replication_update_time: ~datetime.datetime
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "active_location": {"readonly": True},
        "target_hci_cluster_id": {"required": True, "min_length": 1},
        "target_arc_cluster_custom_location_id": {"required": True, "min_length": 1},
        "target_az_stack_hci_cluster_name": {"readonly": True},
        "fabric_discovery_machine_id": {"required": True, "min_length": 1},
        "disks_to_include": {"required": True, "min_items": 1},
        "nics_to_include": {"required": True, "min_items": 1},
        "source_vm_name": {"readonly": True},
        "source_cpu_cores": {"readonly": True},
        "source_memory_in_mega_bytes": {"readonly": True},
        "target_resource_group_id": {"required": True, "min_length": 1},
        "storage_container_id": {"required": True, "min_length": 1},
        "hyper_v_generation": {"required": True, "min_length": 1},
        "run_as_account_id": {"required": True, "min_length": 1},
        "source_dra_name": {"required": True, "min_length": 1},
        "target_dra_name": {"required": True, "min_length": 1},
        "source_appliance_name": {"readonly": True},
        "target_appliance_name": {"readonly": True},
        "os_type": {"readonly": True},
        "os_name": {"readonly": True},
        "firmware_type": {"readonly": True},
        "target_location": {"readonly": True},
        "custom_location_region": {"required": True, "min_length": 1},
        "failover_recovery_point_id": {"readonly": True},
        "last_recovery_point_received": {"readonly": True},
        "last_recovery_point_id": {"readonly": True},
        "initial_replication_progress_percentage": {"readonly": True},
        "resync_progress_percentage": {"readonly": True},
        "protected_disks": {"readonly": True},
        "protected_nics": {"readonly": True},
        "target_vm_bios_id": {"readonly": True},
        "last_replication_update_time": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "active_location": {"key": "activeLocation", "type": "str"},
        "target_hci_cluster_id": {"key": "targetHciClusterId", "type": "str"},
        "target_arc_cluster_custom_location_id": {"key": "targetArcClusterCustomLocationId", "type": "str"},
        "target_az_stack_hci_cluster_name": {"key": "targetAzStackHciClusterName", "type": "str"},
        "fabric_discovery_machine_id": {"key": "fabricDiscoveryMachineId", "type": "str"},
        "disks_to_include": {"key": "disksToInclude", "type": "[HyperVToAzStackHCIDiskInput]"},
        "nics_to_include": {"key": "nicsToInclude", "type": "[HyperVToAzStackHCINicInput]"},
        "source_vm_name": {"key": "sourceVmName", "type": "str"},
        "source_cpu_cores": {"key": "sourceCpuCores", "type": "int"},
        "source_memory_in_mega_bytes": {"key": "sourceMemoryInMegaBytes", "type": "float"},
        "target_vm_name": {"key": "targetVmName", "type": "str"},
        "target_resource_group_id": {"key": "targetResourceGroupId", "type": "str"},
        "storage_container_id": {"key": "storageContainerId", "type": "str"},
        "hyper_v_generation": {"key": "hyperVGeneration", "type": "str"},
        "target_network_id": {"key": "targetNetworkId", "type": "str"},
        "test_network_id": {"key": "testNetworkId", "type": "str"},
        "target_cpu_cores": {"key": "targetCpuCores", "type": "int"},
        "is_dynamic_ram": {"key": "isDynamicRam", "type": "bool"},
        "dynamic_memory_config": {"key": "dynamicMemoryConfig", "type": "ProtectedItemDynamicMemoryConfig"},
        "target_memory_in_mega_bytes": {"key": "targetMemoryInMegaBytes", "type": "int"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "source_dra_name": {"key": "sourceDraName", "type": "str"},
        "target_dra_name": {"key": "targetDraName", "type": "str"},
        "source_appliance_name": {"key": "sourceApplianceName", "type": "str"},
        "target_appliance_name": {"key": "targetApplianceName", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "firmware_type": {"key": "firmwareType", "type": "str"},
        "target_location": {"key": "targetLocation", "type": "str"},
        "custom_location_region": {"key": "customLocationRegion", "type": "str"},
        "failover_recovery_point_id": {"key": "failoverRecoveryPointId", "type": "str"},
        "last_recovery_point_received": {"key": "lastRecoveryPointReceived", "type": "iso-8601"},
        "last_recovery_point_id": {"key": "lastRecoveryPointId", "type": "str"},
        "initial_replication_progress_percentage": {"key": "initialReplicationProgressPercentage", "type": "int"},
        "resync_progress_percentage": {"key": "resyncProgressPercentage", "type": "int"},
        "protected_disks": {"key": "protectedDisks", "type": "[HyperVToAzStackHCIProtectedDiskProperties]"},
        "protected_nics": {"key": "protectedNics", "type": "[HyperVToAzStackHCIProtectedNicProperties]"},
        "target_vm_bios_id": {"key": "targetVmBiosId", "type": "str"},
        "last_replication_update_time": {"key": "lastReplicationUpdateTime", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        target_hci_cluster_id: str,
        target_arc_cluster_custom_location_id: str,
        fabric_discovery_machine_id: str,
        disks_to_include: List["_models.HyperVToAzStackHCIDiskInput"],
        nics_to_include: List["_models.HyperVToAzStackHCINicInput"],
        target_resource_group_id: str,
        storage_container_id: str,
        hyper_v_generation: str,
        run_as_account_id: str,
        source_dra_name: str,
        target_dra_name: str,
        custom_location_region: str,
        target_vm_name: Optional[str] = None,
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        target_cpu_cores: Optional[int] = None,
        is_dynamic_ram: Optional[bool] = None,
        dynamic_memory_config: Optional["_models.ProtectedItemDynamicMemoryConfig"] = None,
        target_memory_in_mega_bytes: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_hci_cluster_id: Gets or sets the Target HCI Cluster ARM Id. Required.
        :paramtype target_hci_cluster_id: str
        :keyword target_arc_cluster_custom_location_id: Gets or sets the Target Arc Cluster Custom
         Location ARM Id. Required.
        :paramtype target_arc_cluster_custom_location_id: str
        :keyword fabric_discovery_machine_id: Gets or sets the ARM Id of the discovered machine.
         Required.
        :paramtype fabric_discovery_machine_id: str
        :keyword disks_to_include: Gets or sets the list of disks to replicate. Required.
        :paramtype disks_to_include:
         list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCIDiskInput]
        :keyword nics_to_include: Gets or sets the list of VM NIC to replicate. Required.
        :paramtype nics_to_include:
         list[~azure.mgmt.recoveryservicesdatareplication.models.HyperVToAzStackHCINicInput]
        :keyword target_vm_name: Gets or sets the target VM display name.
        :paramtype target_vm_name: str
        :keyword target_resource_group_id: Gets or sets the target resource group ARM Id. Required.
        :paramtype target_resource_group_id: str
        :keyword storage_container_id: Gets or sets the target storage container ARM Id. Required.
        :paramtype storage_container_id: str
        :keyword hyper_v_generation: Gets or sets the hypervisor generation of the virtual machine.
         Required.
        :paramtype hyper_v_generation: str
        :keyword target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
        :paramtype target_network_id: str
        :keyword test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
        :paramtype test_network_id: str
        :keyword target_cpu_cores: Gets or sets the target CPU cores.
        :paramtype target_cpu_cores: int
        :keyword is_dynamic_ram: Gets or sets a value indicating whether memory is dynamical.
        :paramtype is_dynamic_ram: bool
        :keyword dynamic_memory_config: Protected item dynamic memory config.
        :paramtype dynamic_memory_config:
         ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemDynamicMemoryConfig
        :keyword target_memory_in_mega_bytes: Gets or sets the target memory in mega-bytes.
        :paramtype target_memory_in_mega_bytes: int
        :keyword run_as_account_id: Gets or sets the Run As account Id. Required.
        :paramtype run_as_account_id: str
        :keyword source_dra_name: Gets or sets the source DRA name. Required.
        :paramtype source_dra_name: str
        :keyword target_dra_name: Gets or sets the target DRA name. Required.
        :paramtype target_dra_name: str
        :keyword custom_location_region: Gets or sets the location of Azure Arc HCI custom location
         resource. Required.
        :paramtype custom_location_region: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVToAzStackHCI"
        self.active_location = None
        self.target_hci_cluster_id = target_hci_cluster_id
        self.target_arc_cluster_custom_location_id = target_arc_cluster_custom_location_id
        self.target_az_stack_hci_cluster_name = None
        self.fabric_discovery_machine_id = fabric_discovery_machine_id
        self.disks_to_include = disks_to_include
        self.nics_to_include = nics_to_include
        self.source_vm_name = None
        self.source_cpu_cores = None
        self.source_memory_in_mega_bytes = None
        self.target_vm_name = target_vm_name
        self.target_resource_group_id = target_resource_group_id
        self.storage_container_id = storage_container_id
        self.hyper_v_generation = hyper_v_generation
        self.target_network_id = target_network_id
        self.test_network_id = test_network_id
        self.target_cpu_cores = target_cpu_cores
        self.is_dynamic_ram = is_dynamic_ram
        self.dynamic_memory_config = dynamic_memory_config
        self.target_memory_in_mega_bytes = target_memory_in_mega_bytes
        self.run_as_account_id = run_as_account_id
        self.source_dra_name = source_dra_name
        self.target_dra_name = target_dra_name
        self.source_appliance_name = None
        self.target_appliance_name = None
        self.os_type = None
        self.os_name = None
        self.firmware_type = None
        self.target_location = None
        self.custom_location_region = custom_location_region
        self.failover_recovery_point_id = None
        self.last_recovery_point_received = None
        self.last_recovery_point_id = None
        self.initial_replication_progress_percentage = None
        self.resync_progress_percentage = None
        self.protected_disks = None
        self.protected_nics = None
        self.target_vm_bios_id = None
        self.last_replication_update_time = None


class HyperVToAzStackHCIProtectedNicProperties(_serialization.Model):
    """HyperVToAzStackHCI NIC properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nic_id: Gets or sets the NIC Id.
    :vartype nic_id: str
    :ivar mac_address: Gets or sets the NIC mac address.
    :vartype mac_address: str
    :ivar network_name: Gets or sets the network name.
    :vartype network_name: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
    :vartype test_network_id: str
    :ivar selection_type_for_failover: Gets or sets the selection type of the NIC. Known values
     are: "NotSelected", "SelectedByUser", "SelectedByDefault", and "SelectedByUserOverride".
    :vartype selection_type_for_failover: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.VMNicSelection
    """

    _validation = {
        "nic_id": {"readonly": True},
        "mac_address": {"readonly": True},
        "network_name": {"readonly": True},
        "target_network_id": {"readonly": True},
        "test_network_id": {"readonly": True},
        "selection_type_for_failover": {"readonly": True},
    }

    _attribute_map = {
        "nic_id": {"key": "nicId", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "network_name": {"key": "networkName", "type": "str"},
        "target_network_id": {"key": "targetNetworkId", "type": "str"},
        "test_network_id": {"key": "testNetworkId", "type": "str"},
        "selection_type_for_failover": {"key": "selectionTypeForFailover", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.nic_id = None
        self.mac_address = None
        self.network_name = None
        self.target_network_id = None
        self.test_network_id = None
        self.selection_type_for_failover = None


class RecoveryPointModelCustomProperties(_serialization.Model):
    """Recovery point model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIRecoveryPointModelCustomProperties

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"HyperVToAzStackHCI": "HyperVToAzStackHCIRecoveryPointModelCustomProperties"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class HyperVToAzStackHCIRecoveryPointModelCustomProperties(RecoveryPointModelCustomProperties):
    """HyperV to AzStackHCI recovery point model custom properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar disk_ids: Gets or sets the list of the disk Ids.
    :vartype disk_ids: list[str]
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "disk_ids": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "disk_ids": {"key": "diskIds", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVToAzStackHCI"
        self.disk_ids = None


class ReplicationExtensionModelCustomProperties(_serialization.Model):
    """Replication extension model custom properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVToAzStackHCIReplicationExtensionModelCustomProperties,
    VMwareToAzStackHCIReplicationExtensionModelCustomProperties

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "HyperVToAzStackHCI": "HyperVToAzStackHCIReplicationExtensionModelCustomProperties",
            "VMwareToAzStackHCI": "VMwareToAzStackHCIReplicationExtensionModelCustomProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class HyperVToAzStackHCIReplicationExtensionModelCustomProperties(
    ReplicationExtensionModelCustomProperties
):  # pylint: disable=too-many-instance-attributes
    """HyperV to AzStackHCI Replication extension model custom properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar hyper_v_fabric_arm_id: Gets or sets the ARM Id of the source HyperV fabric. Required.
    :vartype hyper_v_fabric_arm_id: str
    :ivar hyper_v_site_id: Gets or sets the ARM Id of the HyperV site.
    :vartype hyper_v_site_id: str
    :ivar az_stack_hci_fabric_arm_id: Gets or sets the ARM Id of the target AzStackHCI fabric.
     Required.
    :vartype az_stack_hci_fabric_arm_id: str
    :ivar az_stack_hci_site_id: Gets or sets the ARM Id of the AzStackHCI site.
    :vartype az_stack_hci_site_id: str
    :ivar storage_account_id: Gets or sets the storage account Id.
    :vartype storage_account_id: str
    :ivar storage_account_sas_secret_name: Gets or sets the Sas Secret of storage account.
    :vartype storage_account_sas_secret_name: str
    :ivar asr_service_uri: Gets or sets the Uri of ASR.
    :vartype asr_service_uri: str
    :ivar rcm_service_uri: Gets or sets the Uri of Rcm.
    :vartype rcm_service_uri: str
    :ivar gateway_service_uri: Gets or sets the Uri of Gateway.
    :vartype gateway_service_uri: str
    :ivar source_gateway_service_id: Gets or sets the gateway service Id of source.
    :vartype source_gateway_service_id: str
    :ivar target_gateway_service_id: Gets or sets the gateway service Id of target.
    :vartype target_gateway_service_id: str
    :ivar source_storage_container_name: Gets or sets the source storage container name.
    :vartype source_storage_container_name: str
    :ivar target_storage_container_name: Gets or sets the target storage container name.
    :vartype target_storage_container_name: str
    :ivar resource_location: Gets or sets the resource location.
    :vartype resource_location: str
    :ivar subscription_id: Gets or sets the subscription.
    :vartype subscription_id: str
    :ivar resource_group: Gets or sets the resource group.
    :vartype resource_group: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "hyper_v_fabric_arm_id": {"required": True, "min_length": 1},
        "hyper_v_site_id": {"readonly": True},
        "az_stack_hci_fabric_arm_id": {"required": True, "min_length": 1},
        "az_stack_hci_site_id": {"readonly": True},
        "asr_service_uri": {"readonly": True},
        "rcm_service_uri": {"readonly": True},
        "gateway_service_uri": {"readonly": True},
        "source_gateway_service_id": {"readonly": True},
        "target_gateway_service_id": {"readonly": True},
        "source_storage_container_name": {"readonly": True},
        "target_storage_container_name": {"readonly": True},
        "resource_location": {"readonly": True},
        "subscription_id": {"readonly": True},
        "resource_group": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "hyper_v_fabric_arm_id": {"key": "hyperVFabricArmId", "type": "str"},
        "hyper_v_site_id": {"key": "hyperVSiteId", "type": "str"},
        "az_stack_hci_fabric_arm_id": {"key": "azStackHciFabricArmId", "type": "str"},
        "az_stack_hci_site_id": {"key": "azStackHciSiteId", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "storage_account_sas_secret_name": {"key": "storageAccountSasSecretName", "type": "str"},
        "asr_service_uri": {"key": "asrServiceUri", "type": "str"},
        "rcm_service_uri": {"key": "rcmServiceUri", "type": "str"},
        "gateway_service_uri": {"key": "gatewayServiceUri", "type": "str"},
        "source_gateway_service_id": {"key": "sourceGatewayServiceId", "type": "str"},
        "target_gateway_service_id": {"key": "targetGatewayServiceId", "type": "str"},
        "source_storage_container_name": {"key": "sourceStorageContainerName", "type": "str"},
        "target_storage_container_name": {"key": "targetStorageContainerName", "type": "str"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        hyper_v_fabric_arm_id: str,
        az_stack_hci_fabric_arm_id: str,
        storage_account_id: Optional[str] = None,
        storage_account_sas_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hyper_v_fabric_arm_id: Gets or sets the ARM Id of the source HyperV fabric. Required.
        :paramtype hyper_v_fabric_arm_id: str
        :keyword az_stack_hci_fabric_arm_id: Gets or sets the ARM Id of the target AzStackHCI fabric.
         Required.
        :paramtype az_stack_hci_fabric_arm_id: str
        :keyword storage_account_id: Gets or sets the storage account Id.
        :paramtype storage_account_id: str
        :keyword storage_account_sas_secret_name: Gets or sets the Sas Secret of storage account.
        :paramtype storage_account_sas_secret_name: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVToAzStackHCI"
        self.hyper_v_fabric_arm_id = hyper_v_fabric_arm_id
        self.hyper_v_site_id = None
        self.az_stack_hci_fabric_arm_id = az_stack_hci_fabric_arm_id
        self.az_stack_hci_site_id = None
        self.storage_account_id = storage_account_id
        self.storage_account_sas_secret_name = storage_account_sas_secret_name
        self.asr_service_uri = None
        self.rcm_service_uri = None
        self.gateway_service_uri = None
        self.source_gateway_service_id = None
        self.target_gateway_service_id = None
        self.source_storage_container_name = None
        self.target_storage_container_name = None
        self.resource_location = None
        self.subscription_id = None
        self.resource_group = None


class IdentityModel(_serialization.Model):
    """Identity model.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Gets or sets the tenant Id of the SPN with which Dra communicates to service.
     Required.
    :vartype tenant_id: str
    :ivar application_id: Gets or sets the client/application Id of the SPN with which Dra
     communicates to
     service. Required.
    :vartype application_id: str
    :ivar object_id: Gets or sets the object Id of the SPN with which Dra communicates to service.
     Required.
    :vartype object_id: str
    :ivar audience: Gets or sets the audience of the SPN with which Dra communicates to service.
     Required.
    :vartype audience: str
    :ivar aad_authority: Gets or sets the authority of the SPN with which Dra communicates to
     service. Required.
    :vartype aad_authority: str
    """

    _validation = {
        "tenant_id": {"required": True, "min_length": 1},
        "application_id": {"required": True, "min_length": 1},
        "object_id": {"required": True, "min_length": 1},
        "audience": {"required": True, "min_length": 1},
        "aad_authority": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "application_id": {"key": "applicationId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "audience": {"key": "audience", "type": "str"},
        "aad_authority": {"key": "aadAuthority", "type": "str"},
    }

    def __init__(
        self, *, tenant_id: str, application_id: str, object_id: str, audience: str, aad_authority: str, **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: Gets or sets the tenant Id of the SPN with which Dra communicates to
         service. Required.
        :paramtype tenant_id: str
        :keyword application_id: Gets or sets the client/application Id of the SPN with which Dra
         communicates to
         service. Required.
        :paramtype application_id: str
        :keyword object_id: Gets or sets the object Id of the SPN with which Dra communicates to
         service. Required.
        :paramtype object_id: str
        :keyword audience: Gets or sets the audience of the SPN with which Dra communicates to service.
         Required.
        :paramtype audience: str
        :keyword aad_authority: Gets or sets the authority of the SPN with which Dra communicates to
         service. Required.
        :paramtype aad_authority: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.application_id = application_id
        self.object_id = object_id
        self.audience = audience
        self.aad_authority = aad_authority


class InnerHealthErrorModel(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Inner health error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Gets or sets the error code.
    :vartype code: str
    :ivar health_category: Gets or sets the health category.
    :vartype health_category: str
    :ivar category: Gets or sets the error category.
    :vartype category: str
    :ivar severity: Gets or sets the error severity.
    :vartype severity: str
    :ivar source: Gets or sets the error source.
    :vartype source: str
    :ivar creation_time: Gets or sets the error creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar is_customer_resolvable: Gets or sets a value indicating whether the error is customer
     resolvable.
    :vartype is_customer_resolvable: bool
    :ivar summary: Gets or sets the error summary.
    :vartype summary: str
    :ivar message: Gets or sets the error message.
    :vartype message: str
    :ivar causes: Gets or sets possible causes of the error.
    :vartype causes: str
    :ivar recommendation: Gets or sets recommended action to resolve the error.
    :vartype recommendation: str
    """

    _validation = {
        "code": {"readonly": True},
        "health_category": {"readonly": True},
        "category": {"readonly": True},
        "severity": {"readonly": True},
        "source": {"readonly": True},
        "creation_time": {"readonly": True},
        "is_customer_resolvable": {"readonly": True},
        "summary": {"readonly": True},
        "message": {"readonly": True},
        "causes": {"readonly": True},
        "recommendation": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "health_category": {"key": "healthCategory", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "is_customer_resolvable": {"key": "isCustomerResolvable", "type": "bool"},
        "summary": {"key": "summary", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "causes": {"key": "causes", "type": "str"},
        "recommendation": {"key": "recommendation", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.health_category = None
        self.category = None
        self.severity = None
        self.source = None
        self.creation_time = None
        self.is_customer_resolvable = None
        self.summary = None
        self.message = None
        self.causes = None
        self.recommendation = None


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.recoveryservicesdatareplication.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.recoveryservicesdatareplication.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.recoveryservicesdatareplication.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.recoveryservicesdatareplication.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.recoveryservicesdatareplication.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationModel(_serialization.Model):
    """Operation model.

    :ivar name: Gets or sets the name of the operation.
    :vartype name: str
    :ivar is_data_action: Gets or sets a value indicating whether the action is specific to data
     plane or
     control plane.
    :vartype is_data_action: bool
    :ivar origin: Gets or sets the executor of the operation.
    :vartype origin: str
    :ivar display: Operation model properties.
    :vartype display: ~azure.mgmt.recoveryservicesdatareplication.models.OperationModelProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "origin": {"key": "origin", "type": "str"},
        "display": {"key": "display", "type": "OperationModelProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        origin: Optional[str] = None,
        display: Optional["_models.OperationModelProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gets or sets the name of the operation.
        :paramtype name: str
        :keyword is_data_action: Gets or sets a value indicating whether the action is specific to data
         plane or
         control plane.
        :paramtype is_data_action: bool
        :keyword origin: Gets or sets the executor of the operation.
        :paramtype origin: str
        :keyword display: Operation model properties.
        :paramtype display: ~azure.mgmt.recoveryservicesdatareplication.models.OperationModelProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.origin = origin
        self.display = display


class OperationModelCollection(_serialization.Model):
    """Available operations of the service.

    :ivar value: Gets or sets the list of operations.
    :vartype value: list[~azure.mgmt.recoveryservicesdatareplication.models.OperationModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationModel"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of operations.
        :paramtype value: list[~azure.mgmt.recoveryservicesdatareplication.models.OperationModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationModelProperties(_serialization.Model):
    """Operation model properties.

    :ivar provider: Gets or sets the resource provider name.
    :vartype provider: str
    :ivar resource: Gets or sets resource name.
    :vartype resource: str
    :ivar operation: Gets or sets the operation.
    :vartype operation: str
    :ivar description: Gets or sets the description.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Gets or sets the resource provider name.
        :paramtype provider: str
        :keyword resource: Gets or sets resource name.
        :paramtype resource: str
        :keyword operation: Gets or sets the operation.
        :paramtype operation: str
        :keyword description: Gets or sets the description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationStatus(_serialization.Model):
    """Defines the operation status.

    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar name: Gets or sets the operation name.
    :vartype name: str
    :ivar status: Gets or sets the status of the operation. ARM expects the terminal status to be
     one of
     Succeeded/ Failed/ Canceled. All other values imply that the operation is still running.
    :vartype status: str
    :ivar start_time: Gets or sets the start time.
    :vartype start_time: str
    :ivar end_time: Gets or sets the end time.
    :vartype end_time: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Gets or sets the Id.
        :paramtype id: str
        :keyword name: Gets or sets the operation name.
        :paramtype name: str
        :keyword status: Gets or sets the status of the operation. ARM expects the terminal status to
         be one of
         Succeeded/ Failed/ Canceled. All other values imply that the operation is still running.
        :paramtype status: str
        :keyword start_time: Gets or sets the start time.
        :paramtype start_time: str
        :keyword end_time: Gets or sets the end time.
        :paramtype end_time: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.start_time = start_time
        self.end_time = end_time


class PlannedFailoverModel(_serialization.Model):
    """Planned failover model.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Planned failover model properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.PlannedFailoverModelProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "PlannedFailoverModelProperties"},
    }

    def __init__(self, *, properties: "_models.PlannedFailoverModelProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Planned failover model properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.PlannedFailoverModelProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PlannedFailoverModelProperties(_serialization.Model):
    """Planned failover model properties.

    All required parameters must be populated in order to send to Azure.

    :ivar custom_properties: Planned failover model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.PlannedFailoverModelCustomProperties
    """

    _validation = {
        "custom_properties": {"required": True},
    }

    _attribute_map = {
        "custom_properties": {"key": "customProperties", "type": "PlannedFailoverModelCustomProperties"},
    }

    def __init__(self, *, custom_properties: "_models.PlannedFailoverModelCustomProperties", **kwargs: Any) -> None:
        """
        :keyword custom_properties: Planned failover model custom properties. Required.
        :paramtype custom_properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.PlannedFailoverModelCustomProperties
        """
        super().__init__(**kwargs)
        self.custom_properties = custom_properties


class PolicyModel(_serialization.Model):
    """Policy model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Policy model properties. Required.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.PolicyModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.PolicyModelSystemData
    """

    _validation = {
        "properties": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "PolicyModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "PolicyModelSystemData"},
    }

    def __init__(self, *, properties: "_models.PolicyModelProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Policy model properties. Required.
        :paramtype properties: ~azure.mgmt.recoveryservicesdatareplication.models.PolicyModelProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class PolicyModelCollection(_serialization.Model):
    """Policy model collection.

    :ivar value: Gets or sets the list of policies.
    :vartype value: list[~azure.mgmt.recoveryservicesdatareplication.models.PolicyModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PolicyModel"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of policies.
        :paramtype value: list[~azure.mgmt.recoveryservicesdatareplication.models.PolicyModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyModelProperties(_serialization.Model):
    """Policy model properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Gets or sets the provisioning state of the policy. Known values are:
     "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar custom_properties: Policy model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.PolicyModelCustomProperties
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "custom_properties": {"required": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "custom_properties": {"key": "customProperties", "type": "PolicyModelCustomProperties"},
    }

    def __init__(self, *, custom_properties: "_models.PolicyModelCustomProperties", **kwargs: Any) -> None:
        """
        :keyword custom_properties: Policy model custom properties. Required.
        :paramtype custom_properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.PolicyModelCustomProperties
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.custom_properties = custom_properties


class PolicyModelSystemData(SystemDataModel):
    """PolicyModelSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class ProtectedItemDynamicMemoryConfig(_serialization.Model):
    """Protected item dynamic memory config.

    All required parameters must be populated in order to send to Azure.

    :ivar maximum_memory_in_mega_bytes: Gets or sets maximum memory in MB. Required.
    :vartype maximum_memory_in_mega_bytes: int
    :ivar minimum_memory_in_mega_bytes: Gets or sets minimum memory in MB. Required.
    :vartype minimum_memory_in_mega_bytes: int
    :ivar target_memory_buffer_percentage: Gets or sets target memory buffer in %. Required.
    :vartype target_memory_buffer_percentage: int
    """

    _validation = {
        "maximum_memory_in_mega_bytes": {"required": True},
        "minimum_memory_in_mega_bytes": {"required": True},
        "target_memory_buffer_percentage": {"required": True},
    }

    _attribute_map = {
        "maximum_memory_in_mega_bytes": {"key": "maximumMemoryInMegaBytes", "type": "int"},
        "minimum_memory_in_mega_bytes": {"key": "minimumMemoryInMegaBytes", "type": "int"},
        "target_memory_buffer_percentage": {"key": "targetMemoryBufferPercentage", "type": "int"},
    }

    def __init__(
        self,
        *,
        maximum_memory_in_mega_bytes: int,
        minimum_memory_in_mega_bytes: int,
        target_memory_buffer_percentage: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword maximum_memory_in_mega_bytes: Gets or sets maximum memory in MB. Required.
        :paramtype maximum_memory_in_mega_bytes: int
        :keyword minimum_memory_in_mega_bytes: Gets or sets minimum memory in MB. Required.
        :paramtype minimum_memory_in_mega_bytes: int
        :keyword target_memory_buffer_percentage: Gets or sets target memory buffer in %. Required.
        :paramtype target_memory_buffer_percentage: int
        """
        super().__init__(**kwargs)
        self.maximum_memory_in_mega_bytes = maximum_memory_in_mega_bytes
        self.minimum_memory_in_mega_bytes = minimum_memory_in_mega_bytes
        self.target_memory_buffer_percentage = target_memory_buffer_percentage


class ProtectedItemJobProperties(_serialization.Model):
    """Protected item job properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar scenario_name: Gets or sets protection scenario name.
    :vartype scenario_name: str
    :ivar id: Gets or sets workflow Id.
    :vartype id: str
    :ivar name: Gets or sets workflow name.
    :vartype name: str
    :ivar display_name: Gets or sets the workflow friendly display name.
    :vartype display_name: str
    :ivar state: Gets or sets workflow state.
    :vartype state: str
    :ivar start_time: Gets or sets start time of the workflow.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets or sets end time of the workflow.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "scenario_name": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "state": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "scenario_name": {"key": "scenarioName", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.scenario_name = None
        self.id = None
        self.name = None
        self.display_name = None
        self.state = None
        self.start_time = None
        self.end_time = None


class ProtectedItemModel(_serialization.Model):
    """Protected item model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Protected item model properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelSystemData
    """

    _validation = {
        "properties": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "ProtectedItemModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "ProtectedItemModelSystemData"},
    }

    def __init__(self, *, properties: "_models.ProtectedItemModelProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Protected item model properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProtectedItemModelCollection(_serialization.Model):
    """Protected item model collection.

    :ivar value: Gets or sets the list of protected items.
    :vartype value: list[~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ProtectedItemModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ProtectedItemModel"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of protected items.
        :paramtype value: list[~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProtectedItemModelProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Protected item model properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar policy_name: Gets or sets the policy name. Required.
    :vartype policy_name: str
    :ivar replication_extension_name: Gets or sets the replication extension name. Required.
    :vartype replication_extension_name: str
    :ivar correlation_id: Gets or sets the protected item correlation Id.
    :vartype correlation_id: str
    :ivar provisioning_state: Gets or sets the provisioning state of the Dra. Known values are:
     "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar protection_state: Gets or sets the protection state. Known values are:
     "UnprotectedStatesBegin", "EnablingProtection", "EnablingFailed", "DisablingProtection",
     "MarkedForDeletion", "DisablingFailed", "UnprotectedStatesEnd",
     "InitialReplicationStatesBegin", "InitialReplicationInProgress",
     "InitialReplicationCompletedOnPrimary", "InitialReplicationCompletedOnRecovery",
     "InitialReplicationFailed", "InitialReplicationStatesEnd", "ProtectedStatesBegin", "Protected",
     "ProtectedStatesEnd", "PlannedFailoverTransitionStatesBegin", "PlannedFailoverInitiated",
     "PlannedFailoverCompleting", "PlannedFailoverCompleted", "PlannedFailoverFailed",
     "PlannedFailoverCompletionFailed", "PlannedFailoverTransitionStatesEnd",
     "UnplannedFailoverTransitionStatesBegin", "UnplannedFailoverInitiated",
     "UnplannedFailoverCompleting", "UnplannedFailoverCompleted", "UnplannedFailoverFailed",
     "UnplannedFailoverCompletionFailed", "UnplannedFailoverTransitionStatesEnd",
     "CommitFailoverStatesBegin", "CommitFailoverInProgressOnPrimary",
     "CommitFailoverInProgressOnRecovery", "CommitFailoverCompleted",
     "CommitFailoverFailedOnPrimary", "CommitFailoverFailedOnRecovery", "CommitFailoverStatesEnd",
     "CancelFailoverStatesBegin", "CancelFailoverInProgressOnPrimary",
     "CancelFailoverInProgressOnRecovery", "CancelFailoverFailedOnPrimary",
     "CancelFailoverFailedOnRecovery", "CancelFailoverStatesEnd", "ChangeRecoveryPointStatesBegin",
     "ChangeRecoveryPointInitiated", "ChangeRecoveryPointCompleted", "ChangeRecoveryPointFailed",
     "ChangeRecoveryPointStatesEnd", "ReprotectStatesBegin", "ReprotectInitiated",
     "ReprotectFailed", and "ReprotectStatesEnd".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectionState
    :ivar protection_state_description: Gets or sets the protection state description.
    :vartype protection_state_description: str
    :ivar test_failover_state: Gets or sets the test failover state. Known values are: "None",
     "TestFailoverInitiated", "TestFailoverCompleting", "TestFailoverCompleted",
     "TestFailoverFailed", "TestFailoverCompletionFailed", "TestFailoverCleanupInitiated",
     "TestFailoverCleanupCompleting", and "MarkedForDeletion".
    :vartype test_failover_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.TestFailoverState
    :ivar test_failover_state_description: Gets or sets the Test failover state description.
    :vartype test_failover_state_description: str
    :ivar resynchronization_state: Gets or sets the resynchronization state. Known values are:
     "None", "ResynchronizationInitiated", "ResynchronizationCompleted", and
     "ResynchronizationFailed".
    :vartype resynchronization_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ResynchronizationState
    :ivar fabric_object_id: Gets or sets the fabric object Id.
    :vartype fabric_object_id: str
    :ivar fabric_object_name: Gets or sets the fabric object name.
    :vartype fabric_object_name: str
    :ivar source_fabric_provider_id: Gets or sets the source fabric provider Id.
    :vartype source_fabric_provider_id: str
    :ivar target_fabric_provider_id: Gets or sets the target fabric provider Id.
    :vartype target_fabric_provider_id: str
    :ivar fabric_id: Gets or sets the fabric Id.
    :vartype fabric_id: str
    :ivar target_fabric_id: Gets or sets the target fabric Id.
    :vartype target_fabric_id: str
    :ivar dra_id: Gets or sets the DRA Id.
    :vartype dra_id: str
    :ivar target_dra_id: Gets or sets the target DRA Id.
    :vartype target_dra_id: str
    :ivar resync_required: Gets or sets a value indicating whether resynchronization is required or
     not.
    :vartype resync_required: bool
    :ivar last_successful_planned_failover_time: Gets or sets the Last successful planned failover
     time.
    :vartype last_successful_planned_failover_time: ~datetime.datetime
    :ivar last_successful_unplanned_failover_time: Gets or sets the Last successful unplanned
     failover time.
    :vartype last_successful_unplanned_failover_time: ~datetime.datetime
    :ivar last_successful_test_failover_time: Gets or sets the Last successful test failover time.
    :vartype last_successful_test_failover_time: ~datetime.datetime
    :ivar current_job:
    :vartype current_job:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelPropertiesCurrentJob
    :ivar allowed_jobs: Gets or sets the allowed scenarios on the protected item.
    :vartype allowed_jobs: list[str]
    :ivar last_failed_enable_protection_job:
    :vartype last_failed_enable_protection_job:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelPropertiesLastFailedEnableProtectionJob
    :ivar last_failed_planned_failover_job:
    :vartype last_failed_planned_failover_job:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelPropertiesLastFailedPlannedFailoverJob
    :ivar last_test_failover_job:
    :vartype last_test_failover_job:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelPropertiesLastTestFailoverJob
    :ivar replication_health: Gets or sets protected item replication health. Known values are:
     "Normal", "Warning", and "Critical".
    :vartype replication_health: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.HealthStatus
    :ivar health_errors: Gets or sets the list of health errors.
    :vartype health_errors:
     list[~azure.mgmt.recoveryservicesdatareplication.models.HealthErrorModel]
    :ivar custom_properties: Protected item model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelCustomProperties
    """

    _validation = {
        "policy_name": {"required": True, "min_length": 1},
        "replication_extension_name": {"required": True, "min_length": 1},
        "correlation_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "protection_state": {"readonly": True},
        "protection_state_description": {"readonly": True},
        "test_failover_state": {"readonly": True},
        "test_failover_state_description": {"readonly": True},
        "resynchronization_state": {"readonly": True},
        "fabric_object_id": {"readonly": True},
        "fabric_object_name": {"readonly": True},
        "source_fabric_provider_id": {"readonly": True},
        "target_fabric_provider_id": {"readonly": True},
        "fabric_id": {"readonly": True},
        "target_fabric_id": {"readonly": True},
        "dra_id": {"readonly": True},
        "target_dra_id": {"readonly": True},
        "resync_required": {"readonly": True},
        "last_successful_planned_failover_time": {"readonly": True},
        "last_successful_unplanned_failover_time": {"readonly": True},
        "last_successful_test_failover_time": {"readonly": True},
        "current_job": {"readonly": True},
        "allowed_jobs": {"readonly": True},
        "last_failed_enable_protection_job": {"readonly": True},
        "last_failed_planned_failover_job": {"readonly": True},
        "last_test_failover_job": {"readonly": True},
        "replication_health": {"readonly": True},
        "health_errors": {"readonly": True},
        "custom_properties": {"required": True},
    }

    _attribute_map = {
        "policy_name": {"key": "policyName", "type": "str"},
        "replication_extension_name": {"key": "replicationExtensionName", "type": "str"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "protection_state_description": {"key": "protectionStateDescription", "type": "str"},
        "test_failover_state": {"key": "testFailoverState", "type": "str"},
        "test_failover_state_description": {"key": "testFailoverStateDescription", "type": "str"},
        "resynchronization_state": {"key": "resynchronizationState", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "fabric_object_name": {"key": "fabricObjectName", "type": "str"},
        "source_fabric_provider_id": {"key": "sourceFabricProviderId", "type": "str"},
        "target_fabric_provider_id": {"key": "targetFabricProviderId", "type": "str"},
        "fabric_id": {"key": "fabricId", "type": "str"},
        "target_fabric_id": {"key": "targetFabricId", "type": "str"},
        "dra_id": {"key": "draId", "type": "str"},
        "target_dra_id": {"key": "targetDraId", "type": "str"},
        "resync_required": {"key": "resyncRequired", "type": "bool"},
        "last_successful_planned_failover_time": {"key": "lastSuccessfulPlannedFailoverTime", "type": "iso-8601"},
        "last_successful_unplanned_failover_time": {"key": "lastSuccessfulUnplannedFailoverTime", "type": "iso-8601"},
        "last_successful_test_failover_time": {"key": "lastSuccessfulTestFailoverTime", "type": "iso-8601"},
        "current_job": {"key": "currentJob", "type": "ProtectedItemModelPropertiesCurrentJob"},
        "allowed_jobs": {"key": "allowedJobs", "type": "[str]"},
        "last_failed_enable_protection_job": {
            "key": "lastFailedEnableProtectionJob",
            "type": "ProtectedItemModelPropertiesLastFailedEnableProtectionJob",
        },
        "last_failed_planned_failover_job": {
            "key": "lastFailedPlannedFailoverJob",
            "type": "ProtectedItemModelPropertiesLastFailedPlannedFailoverJob",
        },
        "last_test_failover_job": {
            "key": "lastTestFailoverJob",
            "type": "ProtectedItemModelPropertiesLastTestFailoverJob",
        },
        "replication_health": {"key": "replicationHealth", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthErrorModel]"},
        "custom_properties": {"key": "customProperties", "type": "ProtectedItemModelCustomProperties"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        policy_name: str,
        replication_extension_name: str,
        custom_properties: "_models.ProtectedItemModelCustomProperties",
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_name: Gets or sets the policy name. Required.
        :paramtype policy_name: str
        :keyword replication_extension_name: Gets or sets the replication extension name. Required.
        :paramtype replication_extension_name: str
        :keyword custom_properties: Protected item model custom properties. Required.
        :paramtype custom_properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemModelCustomProperties
        """
        super().__init__(**kwargs)
        self.policy_name = policy_name
        self.replication_extension_name = replication_extension_name
        self.correlation_id = None
        self.provisioning_state = None
        self.protection_state = None
        self.protection_state_description = None
        self.test_failover_state = None
        self.test_failover_state_description = None
        self.resynchronization_state = None
        self.fabric_object_id = None
        self.fabric_object_name = None
        self.source_fabric_provider_id = None
        self.target_fabric_provider_id = None
        self.fabric_id = None
        self.target_fabric_id = None
        self.dra_id = None
        self.target_dra_id = None
        self.resync_required = None
        self.last_successful_planned_failover_time = None
        self.last_successful_unplanned_failover_time = None
        self.last_successful_test_failover_time = None
        self.current_job = None
        self.allowed_jobs = None
        self.last_failed_enable_protection_job = None
        self.last_failed_planned_failover_job = None
        self.last_test_failover_job = None
        self.replication_health = None
        self.health_errors = None
        self.custom_properties = custom_properties


class ProtectedItemModelPropertiesCurrentJob(ProtectedItemJobProperties):
    """ProtectedItemModelPropertiesCurrentJob.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar scenario_name: Gets or sets protection scenario name.
    :vartype scenario_name: str
    :ivar id: Gets or sets workflow Id.
    :vartype id: str
    :ivar name: Gets or sets workflow name.
    :vartype name: str
    :ivar display_name: Gets or sets the workflow friendly display name.
    :vartype display_name: str
    :ivar state: Gets or sets workflow state.
    :vartype state: str
    :ivar start_time: Gets or sets start time of the workflow.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets or sets end time of the workflow.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "scenario_name": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "state": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "scenario_name": {"key": "scenarioName", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ProtectedItemModelPropertiesLastFailedEnableProtectionJob(ProtectedItemJobProperties):
    """ProtectedItemModelPropertiesLastFailedEnableProtectionJob.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar scenario_name: Gets or sets protection scenario name.
    :vartype scenario_name: str
    :ivar id: Gets or sets workflow Id.
    :vartype id: str
    :ivar name: Gets or sets workflow name.
    :vartype name: str
    :ivar display_name: Gets or sets the workflow friendly display name.
    :vartype display_name: str
    :ivar state: Gets or sets workflow state.
    :vartype state: str
    :ivar start_time: Gets or sets start time of the workflow.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets or sets end time of the workflow.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "scenario_name": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "state": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "scenario_name": {"key": "scenarioName", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ProtectedItemModelPropertiesLastFailedPlannedFailoverJob(ProtectedItemJobProperties):
    """ProtectedItemModelPropertiesLastFailedPlannedFailoverJob.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar scenario_name: Gets or sets protection scenario name.
    :vartype scenario_name: str
    :ivar id: Gets or sets workflow Id.
    :vartype id: str
    :ivar name: Gets or sets workflow name.
    :vartype name: str
    :ivar display_name: Gets or sets the workflow friendly display name.
    :vartype display_name: str
    :ivar state: Gets or sets workflow state.
    :vartype state: str
    :ivar start_time: Gets or sets start time of the workflow.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets or sets end time of the workflow.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "scenario_name": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "state": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "scenario_name": {"key": "scenarioName", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ProtectedItemModelPropertiesLastTestFailoverJob(ProtectedItemJobProperties):
    """ProtectedItemModelPropertiesLastTestFailoverJob.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar scenario_name: Gets or sets protection scenario name.
    :vartype scenario_name: str
    :ivar id: Gets or sets workflow Id.
    :vartype id: str
    :ivar name: Gets or sets workflow name.
    :vartype name: str
    :ivar display_name: Gets or sets the workflow friendly display name.
    :vartype display_name: str
    :ivar state: Gets or sets workflow state.
    :vartype state: str
    :ivar start_time: Gets or sets start time of the workflow.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets or sets end time of the workflow.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "scenario_name": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "state": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "scenario_name": {"key": "scenarioName", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ProtectedItemModelSystemData(SystemDataModel):
    """ProtectedItemModelSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class RecoveryPointModel(_serialization.Model):
    """Recovery point model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Recovery point model properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data:
     ~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointModelSystemData
    """

    _validation = {
        "properties": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "RecoveryPointModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "RecoveryPointModelSystemData"},
    }

    def __init__(self, *, properties: "_models.RecoveryPointModelProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Recovery point model properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointModelProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class RecoveryPointModelCollection(_serialization.Model):
    """Recovery point model collection.

    :ivar value: Gets or sets the list of recovery points.
    :vartype value: list[~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RecoveryPointModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.RecoveryPointModel"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of recovery points.
        :paramtype value: list[~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RecoveryPointModelProperties(_serialization.Model):
    """Recovery point model properties.

    All required parameters must be populated in order to send to Azure.

    :ivar recovery_point_time: Gets or sets the recovery point time. Required.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar recovery_point_type: Gets or sets the recovery point type. Required. Known values are:
     "ApplicationConsistent" and "CrashConsistent".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointType
    :ivar custom_properties: Recovery point model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointModelCustomProperties
    """

    _validation = {
        "recovery_point_time": {"required": True},
        "recovery_point_type": {"required": True},
        "custom_properties": {"required": True},
    }

    _attribute_map = {
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "custom_properties": {"key": "customProperties", "type": "RecoveryPointModelCustomProperties"},
    }

    def __init__(
        self,
        *,
        recovery_point_time: datetime.datetime,
        recovery_point_type: Union[str, "_models.RecoveryPointType"],
        custom_properties: "_models.RecoveryPointModelCustomProperties",
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_time: Gets or sets the recovery point time. Required.
        :paramtype recovery_point_time: ~datetime.datetime
        :keyword recovery_point_type: Gets or sets the recovery point type. Required. Known values are:
         "ApplicationConsistent" and "CrashConsistent".
        :paramtype recovery_point_type: str or
         ~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointType
        :keyword custom_properties: Recovery point model custom properties. Required.
        :paramtype custom_properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.RecoveryPointModelCustomProperties
        """
        super().__init__(**kwargs)
        self.recovery_point_time = recovery_point_time
        self.recovery_point_type = recovery_point_type
        self.custom_properties = custom_properties


class RecoveryPointModelSystemData(SystemDataModel):
    """RecoveryPointModelSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class ReplicationExtensionModel(_serialization.Model):
    """Replication extension model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Replication extension model properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.ReplicationExtensionModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data:
     ~azure.mgmt.recoveryservicesdatareplication.models.ReplicationExtensionModelSystemData
    """

    _validation = {
        "properties": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "ReplicationExtensionModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "ReplicationExtensionModelSystemData"},
    }

    def __init__(self, *, properties: "_models.ReplicationExtensionModelProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Replication extension model properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.ReplicationExtensionModelProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ReplicationExtensionModelCollection(_serialization.Model):
    """Replication extension model collection.

    :ivar value: Gets or sets the list of replication extensions.
    :vartype value:
     list[~azure.mgmt.recoveryservicesdatareplication.models.ReplicationExtensionModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ReplicationExtensionModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ReplicationExtensionModel"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of replication extensions.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesdatareplication.models.ReplicationExtensionModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ReplicationExtensionModelProperties(_serialization.Model):
    """Replication extension model properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Gets or sets the provisioning state of the replication extension.
     Known values are: "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and
     "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar custom_properties: Replication extension model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.ReplicationExtensionModelCustomProperties
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "custom_properties": {"required": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "custom_properties": {"key": "customProperties", "type": "ReplicationExtensionModelCustomProperties"},
    }

    def __init__(
        self, *, custom_properties: "_models.ReplicationExtensionModelCustomProperties", **kwargs: Any
    ) -> None:
        """
        :keyword custom_properties: Replication extension model custom properties. Required.
        :paramtype custom_properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.ReplicationExtensionModelCustomProperties
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.custom_properties = custom_properties


class ReplicationExtensionModelSystemData(SystemDataModel):
    """ReplicationExtensionModelSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class StorageContainerProperties(_serialization.Model):
    """Storage container properties.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Gets or sets the Name. Required.
    :vartype name: str
    :ivar cluster_shared_volume_path: Gets or sets the ClusterSharedVolumePath. Required.
    :vartype cluster_shared_volume_path: str
    """

    _validation = {
        "name": {"required": True, "min_length": 1},
        "cluster_shared_volume_path": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "cluster_shared_volume_path": {"key": "clusterSharedVolumePath", "type": "str"},
    }

    def __init__(self, *, name: str, cluster_shared_volume_path: str, **kwargs: Any) -> None:
        """
        :keyword name: Gets or sets the Name. Required.
        :paramtype name: str
        :keyword cluster_shared_volume_path: Gets or sets the ClusterSharedVolumePath. Required.
        :paramtype cluster_shared_volume_path: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.cluster_shared_volume_path = cluster_shared_volume_path


class TaskModel(_serialization.Model):
    """Task model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar task_name: Gets or sets the task name.
    :vartype task_name: str
    :ivar state: Gets or sets the task state. Known values are: "Pending", "Started", "Succeeded",
     "Failed", "Cancelled", and "Skipped".
    :vartype state: str or ~azure.mgmt.recoveryservicesdatareplication.models.TaskState
    :ivar start_time: Gets or sets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets or sets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar custom_properties: Task model custom properties.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.TaskModelCustomProperties
    :ivar children_workflows: Gets or sets the list of children workflow models.
    :vartype children_workflows:
     list[~azure.mgmt.recoveryservicesdatareplication.models.WorkflowModel]
    """

    _validation = {
        "task_name": {"readonly": True},
        "state": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "custom_properties": {"key": "customProperties", "type": "TaskModelCustomProperties"},
        "children_workflows": {"key": "childrenWorkflows", "type": "[WorkflowModel]"},
    }

    def __init__(
        self,
        *,
        custom_properties: Optional["_models.TaskModelCustomProperties"] = None,
        children_workflows: Optional[List["_models.WorkflowModel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword custom_properties: Task model custom properties.
        :paramtype custom_properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.TaskModelCustomProperties
        :keyword children_workflows: Gets or sets the list of children workflow models.
        :paramtype children_workflows:
         list[~azure.mgmt.recoveryservicesdatareplication.models.WorkflowModel]
        """
        super().__init__(**kwargs)
        self.task_name = None
        self.state = None
        self.start_time = None
        self.end_time = None
        self.custom_properties = custom_properties
        self.children_workflows = children_workflows


class TaskModelCustomProperties(_serialization.Model):
    """Task model custom properties.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(self, *, instance_type: str, **kwargs: Any) -> None:
        """
        :keyword instance_type: Gets or sets the instance type. Required.
        :paramtype instance_type: str
        """
        super().__init__(**kwargs)
        self.instance_type = instance_type


class TestFailoverCleanupWorkflowModelCustomProperties(WorkflowModelCustomProperties):
    """Test failover cleanup workflow model custom properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar affected_object_details: Gets or sets any custom properties of the affected object.
    :vartype affected_object_details: dict[str, str]
    :ivar comments: Gets or sets the test failover cleanup comments.
    :vartype comments: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "affected_object_details": {"readonly": True},
        "comments": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "affected_object_details": {"key": "affectedObjectDetails", "type": "{str}"},
        "comments": {"key": "comments", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "TestFailoverCleanupWorkflowDetails"
        self.comments = None


class TestFailoverWorkflowModelCustomProperties(WorkflowModelCustomProperties):
    """Test failover workflow model custom properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar affected_object_details: Gets or sets any custom properties of the affected object.
    :vartype affected_object_details: dict[str, str]
    :ivar protected_item_details: Gets or sets the test VM details.
    :vartype protected_item_details:
     list[~azure.mgmt.recoveryservicesdatareplication.models.FailoverProtectedItemProperties]
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "affected_object_details": {"readonly": True},
        "protected_item_details": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "affected_object_details": {"key": "affectedObjectDetails", "type": "{str}"},
        "protected_item_details": {"key": "protectedItemDetails", "type": "[FailoverProtectedItemProperties]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "TestFailoverWorkflowDetails"
        self.protected_item_details = None


class VaultModel(_serialization.Model):
    """Vault model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Gets or sets the location of the vault. Required.
    :vartype location: str
    :ivar tags: Gets or sets the resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Vault properties.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.VaultModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data: ~azure.mgmt.recoveryservicesdatareplication.models.VaultModelSystemData
    """

    _validation = {
        "location": {"required": True, "min_length": 1},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "VaultModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "VaultModelSystemData"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VaultModelProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets or sets the location of the vault. Required.
        :paramtype location: str
        :keyword tags: Gets or sets the resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Vault properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesdatareplication.models.VaultModelProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class VaultModelCollection(_serialization.Model):
    """Vault model collection.

    :ivar value: Gets or sets the list of vaults.
    :vartype value: list[~azure.mgmt.recoveryservicesdatareplication.models.VaultModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VaultModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VaultModel"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of vaults.
        :paramtype value: list[~azure.mgmt.recoveryservicesdatareplication.models.VaultModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VaultModelProperties(_serialization.Model):
    """Vault properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Gets or sets the provisioning state of the vault. Known values are:
     "Canceled", "Creating", "Deleting", "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProvisioningState
    :ivar service_resource_id: Gets or sets the service resource Id.
    :vartype service_resource_id: str
    :ivar vault_type: Gets or sets the type of vault. Known values are: "DisasterRecovery" and
     "Migrate".
    :vartype vault_type: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ReplicationVaultType
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "service_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "service_resource_id": {"key": "serviceResourceId", "type": "str"},
        "vault_type": {"key": "vaultType", "type": "str"},
    }

    def __init__(
        self, *, vault_type: Optional[Union[str, "_models.ReplicationVaultType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword vault_type: Gets or sets the type of vault. Known values are: "DisasterRecovery" and
         "Migrate".
        :paramtype vault_type: str or
         ~azure.mgmt.recoveryservicesdatareplication.models.ReplicationVaultType
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.service_resource_id = None
        self.vault_type = vault_type


class VaultModelSystemData(SystemDataModel):
    """VaultModelSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class VaultModelUpdate(_serialization.Model):
    """Vault model for update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Gets or sets the resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Vault properties.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.VaultModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data:
     ~azure.mgmt.recoveryservicesdatareplication.models.VaultModelUpdateSystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "VaultModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "VaultModelUpdateSystemData"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VaultModelProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Gets or sets the resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Vault properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesdatareplication.models.VaultModelProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class VaultModelUpdateSystemData(SystemDataModel):
    """VaultModelUpdateSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )


class VMwareDraModelCustomProperties(DraModelCustomProperties):
    """VMware DRA model custom properties.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar bios_id: Gets or sets the BIOS Id of the DRA machine. Required.
    :vartype bios_id: str
    :ivar mars_authentication_identity: Identity model. Required.
    :vartype mars_authentication_identity:
     ~azure.mgmt.recoveryservicesdatareplication.models.IdentityModel
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "bios_id": {"required": True, "min_length": 1},
        "mars_authentication_identity": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "bios_id": {"key": "biosId", "type": "str"},
        "mars_authentication_identity": {"key": "marsAuthenticationIdentity", "type": "IdentityModel"},
    }

    def __init__(self, *, bios_id: str, mars_authentication_identity: "_models.IdentityModel", **kwargs: Any) -> None:
        """
        :keyword bios_id: Gets or sets the BIOS Id of the DRA machine. Required.
        :paramtype bios_id: str
        :keyword mars_authentication_identity: Identity model. Required.
        :paramtype mars_authentication_identity:
         ~azure.mgmt.recoveryservicesdatareplication.models.IdentityModel
        """
        super().__init__(**kwargs)
        self.instance_type: str = "VMware"
        self.bios_id = bios_id
        self.mars_authentication_identity = mars_authentication_identity


class VMwareMigrateFabricModelCustomProperties(FabricModelCustomProperties):
    """VMware migrate fabric model custom properties.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar vmware_site_id: Gets or sets the ARM Id of the VMware site. Required.
    :vartype vmware_site_id: str
    :ivar migration_solution_id: Gets or sets the ARM Id of the migration solution. Required.
    :vartype migration_solution_id: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "vmware_site_id": {"required": True, "min_length": 1},
        "migration_solution_id": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "vmware_site_id": {"key": "vmwareSiteId", "type": "str"},
        "migration_solution_id": {"key": "migrationSolutionId", "type": "str"},
    }

    def __init__(self, *, vmware_site_id: str, migration_solution_id: str, **kwargs: Any) -> None:
        """
        :keyword vmware_site_id: Gets or sets the ARM Id of the VMware site. Required.
        :paramtype vmware_site_id: str
        :keyword migration_solution_id: Gets or sets the ARM Id of the migration solution. Required.
        :paramtype migration_solution_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "VMwareMigrate"
        self.vmware_site_id = vmware_site_id
        self.migration_solution_id = migration_solution_id


class VMwareToAzStackHCIDiskInput(_serialization.Model):
    """VMwareToAzStack disk input.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_id: Gets or sets the disk Id. Required.
    :vartype disk_id: str
    :ivar storage_container_id: Gets or sets the target storage account ARM Id.
    :vartype storage_container_id: str
    :ivar is_dynamic: Gets or sets a value indicating whether dynamic sizing is enabled on the
     virtual hard
     disk.
    :vartype is_dynamic: bool
    :ivar disk_size_gb: Gets or sets the disk size in GB. Required.
    :vartype disk_size_gb: int
    :ivar disk_file_format: Gets or sets the type of the virtual hard disk, vhd or vhdx. Required.
    :vartype disk_file_format: str
    :ivar is_os_disk: Gets or sets a value indicating whether disk is os disk. Required.
    :vartype is_os_disk: bool
    """

    _validation = {
        "disk_id": {"required": True, "min_length": 1},
        "disk_size_gb": {"required": True},
        "disk_file_format": {"required": True, "min_length": 1},
        "is_os_disk": {"required": True},
    }

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "storage_container_id": {"key": "storageContainerId", "type": "str"},
        "is_dynamic": {"key": "isDynamic", "type": "bool"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "disk_file_format": {"key": "diskFileFormat", "type": "str"},
        "is_os_disk": {"key": "isOsDisk", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        disk_size_gb: int,
        disk_file_format: str,
        is_os_disk: bool,
        storage_container_id: Optional[str] = None,
        is_dynamic: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_id: Gets or sets the disk Id. Required.
        :paramtype disk_id: str
        :keyword storage_container_id: Gets or sets the target storage account ARM Id.
        :paramtype storage_container_id: str
        :keyword is_dynamic: Gets or sets a value indicating whether dynamic sizing is enabled on the
         virtual hard
         disk.
        :paramtype is_dynamic: bool
        :keyword disk_size_gb: Gets or sets the disk size in GB. Required.
        :paramtype disk_size_gb: int
        :keyword disk_file_format: Gets or sets the type of the virtual hard disk, vhd or vhdx.
         Required.
        :paramtype disk_file_format: str
        :keyword is_os_disk: Gets or sets a value indicating whether disk is os disk. Required.
        :paramtype is_os_disk: bool
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.storage_container_id = storage_container_id
        self.is_dynamic = is_dynamic
        self.disk_size_gb = disk_size_gb
        self.disk_file_format = disk_file_format
        self.is_os_disk = is_os_disk


class VMwareToAzStackHCINicInput(_serialization.Model):
    """VMwareToAzStackHCI NIC properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar nic_id: Gets or sets the NIC Id. Required.
    :vartype nic_id: str
    :ivar label: Gets or sets the NIC label. Required.
    :vartype label: str
    :ivar network_name: Gets or sets the network name.
    :vartype network_name: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
     Required.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
     Required.
    :vartype test_network_id: str
    :ivar selection_type_for_failover: Gets or sets the selection type of the NIC. Required. Known
     values are: "NotSelected", "SelectedByUser", "SelectedByDefault", and "SelectedByUserOverride".
    :vartype selection_type_for_failover: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.VMNicSelection
    """

    _validation = {
        "nic_id": {"required": True, "min_length": 1},
        "label": {"required": True, "min_length": 1},
        "network_name": {"readonly": True},
        "target_network_id": {"required": True, "min_length": 1},
        "test_network_id": {"required": True, "min_length": 1},
        "selection_type_for_failover": {"required": True},
    }

    _attribute_map = {
        "nic_id": {"key": "nicId", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "network_name": {"key": "networkName", "type": "str"},
        "target_network_id": {"key": "targetNetworkId", "type": "str"},
        "test_network_id": {"key": "testNetworkId", "type": "str"},
        "selection_type_for_failover": {"key": "selectionTypeForFailover", "type": "str"},
    }

    def __init__(
        self,
        *,
        nic_id: str,
        label: str,
        target_network_id: str,
        test_network_id: str,
        selection_type_for_failover: Union[str, "_models.VMNicSelection"],
        **kwargs: Any
    ) -> None:
        """
        :keyword nic_id: Gets or sets the NIC Id. Required.
        :paramtype nic_id: str
        :keyword label: Gets or sets the NIC label. Required.
        :paramtype label: str
        :keyword target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
         Required.
        :paramtype target_network_id: str
        :keyword test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
         Required.
        :paramtype test_network_id: str
        :keyword selection_type_for_failover: Gets or sets the selection type of the NIC. Required.
         Known values are: "NotSelected", "SelectedByUser", "SelectedByDefault", and
         "SelectedByUserOverride".
        :paramtype selection_type_for_failover: str or
         ~azure.mgmt.recoveryservicesdatareplication.models.VMNicSelection
        """
        super().__init__(**kwargs)
        self.nic_id = nic_id
        self.label = label
        self.network_name = None
        self.target_network_id = target_network_id
        self.test_network_id = test_network_id
        self.selection_type_for_failover = selection_type_for_failover


class VMwareToAzStackHCIPlannedFailoverModelCustomProperties(PlannedFailoverModelCustomProperties):
    """VMware to AzStackHCI planned failover model custom properties.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar shutdown_source_vm: Gets or sets a value indicating whether VM needs to be shut down.
     Required.
    :vartype shutdown_source_vm: bool
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "shutdown_source_vm": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "shutdown_source_vm": {"key": "shutdownSourceVM", "type": "bool"},
    }

    def __init__(self, *, shutdown_source_vm: bool, **kwargs: Any) -> None:
        """
        :keyword shutdown_source_vm: Gets or sets a value indicating whether VM needs to be shut down.
         Required.
        :paramtype shutdown_source_vm: bool
        """
        super().__init__(**kwargs)
        self.instance_type: str = "VMwareToAzStackHCI"
        self.shutdown_source_vm = shutdown_source_vm


class VMwareToAzStackHCIPolicyModelCustomProperties(PolicyModelCustomProperties):
    """VMware To AzStackHCI Policy model custom properties.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar recovery_point_history_in_minutes: Gets or sets the duration in minutes until which the
     recovery points need to be
     stored. Required.
    :vartype recovery_point_history_in_minutes: int
    :ivar crash_consistent_frequency_in_minutes: Gets or sets the crash consistent snapshot
     frequency (in minutes). Required.
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar app_consistent_frequency_in_minutes: Gets or sets the app consistent snapshot frequency
     (in minutes). Required.
    :vartype app_consistent_frequency_in_minutes: int
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "recovery_point_history_in_minutes": {"required": True},
        "crash_consistent_frequency_in_minutes": {"required": True},
        "app_consistent_frequency_in_minutes": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_history_in_minutes": {"key": "recoveryPointHistoryInMinutes", "type": "int"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        recovery_point_history_in_minutes: int,
        crash_consistent_frequency_in_minutes: int,
        app_consistent_frequency_in_minutes: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_history_in_minutes: Gets or sets the duration in minutes until which
         the recovery points need to be
         stored. Required.
        :paramtype recovery_point_history_in_minutes: int
        :keyword crash_consistent_frequency_in_minutes: Gets or sets the crash consistent snapshot
         frequency (in minutes). Required.
        :paramtype crash_consistent_frequency_in_minutes: int
        :keyword app_consistent_frequency_in_minutes: Gets or sets the app consistent snapshot
         frequency (in minutes). Required.
        :paramtype app_consistent_frequency_in_minutes: int
        """
        super().__init__(**kwargs)
        self.instance_type: str = "VMwareToAzStackHCI"
        self.recovery_point_history_in_minutes = recovery_point_history_in_minutes
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes


class VMwareToAzStackHCIProtectedDiskProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """VMwareToAzStackHCI protected disk properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_container_id: Gets or sets the ARM Id of the storage container.
    :vartype storage_container_id: str
    :ivar storage_container_local_path: Gets or sets the local path of the storage container.
    :vartype storage_container_local_path: str
    :ivar source_disk_id: Gets or sets the source disk Id.
    :vartype source_disk_id: str
    :ivar source_disk_name: Gets or sets the source disk Name.
    :vartype source_disk_name: str
    :ivar seed_disk_name: Gets or sets the seed disk name.
    :vartype seed_disk_name: str
    :ivar test_migrate_disk_name: Gets or sets the test failover clone disk.
    :vartype test_migrate_disk_name: str
    :ivar migrate_disk_name: Gets or sets the failover clone disk.
    :vartype migrate_disk_name: str
    :ivar is_os_disk: Gets or sets a value indicating whether the disk is the OS disk.
    :vartype is_os_disk: bool
    :ivar capacity_in_bytes: Gets or sets the disk capacity in bytes.
    :vartype capacity_in_bytes: int
    :ivar is_dynamic: Gets or sets a value indicating whether dynamic sizing is enabled on the
     virtual hard
     disk.
    :vartype is_dynamic: bool
    :ivar disk_type: Gets or sets the disk type.
    :vartype disk_type: str
    """

    _validation = {
        "storage_container_id": {"readonly": True},
        "storage_container_local_path": {"readonly": True},
        "source_disk_id": {"readonly": True},
        "source_disk_name": {"readonly": True},
        "seed_disk_name": {"readonly": True},
        "test_migrate_disk_name": {"readonly": True},
        "migrate_disk_name": {"readonly": True},
        "is_os_disk": {"readonly": True},
        "capacity_in_bytes": {"readonly": True},
        "is_dynamic": {"readonly": True},
        "disk_type": {"readonly": True},
    }

    _attribute_map = {
        "storage_container_id": {"key": "storageContainerId", "type": "str"},
        "storage_container_local_path": {"key": "storageContainerLocalPath", "type": "str"},
        "source_disk_id": {"key": "sourceDiskId", "type": "str"},
        "source_disk_name": {"key": "sourceDiskName", "type": "str"},
        "seed_disk_name": {"key": "seedDiskName", "type": "str"},
        "test_migrate_disk_name": {"key": "testMigrateDiskName", "type": "str"},
        "migrate_disk_name": {"key": "migrateDiskName", "type": "str"},
        "is_os_disk": {"key": "isOsDisk", "type": "bool"},
        "capacity_in_bytes": {"key": "capacityInBytes", "type": "int"},
        "is_dynamic": {"key": "isDynamic", "type": "bool"},
        "disk_type": {"key": "diskType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.storage_container_id = None
        self.storage_container_local_path = None
        self.source_disk_id = None
        self.source_disk_name = None
        self.seed_disk_name = None
        self.test_migrate_disk_name = None
        self.migrate_disk_name = None
        self.is_os_disk = None
        self.capacity_in_bytes = None
        self.is_dynamic = None
        self.disk_type = None


class VMwareToAzStackHCIProtectedItemModelCustomProperties(
    ProtectedItemModelCustomProperties
):  # pylint: disable=too-many-instance-attributes
    """VMware to AzStackHCI Protected item model custom properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar active_location: Gets or sets the location of the protected item. Known values are:
     "Primary" and "Recovery".
    :vartype active_location: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemActiveLocation
    :ivar target_hci_cluster_id: Gets or sets the Target HCI Cluster ARM Id. Required.
    :vartype target_hci_cluster_id: str
    :ivar target_arc_cluster_custom_location_id: Gets or sets the Target Arc Cluster Custom
     Location ARM Id. Required.
    :vartype target_arc_cluster_custom_location_id: str
    :ivar target_az_stack_hci_cluster_name: Gets or sets the Target AzStackHCI cluster name.
    :vartype target_az_stack_hci_cluster_name: str
    :ivar storage_container_id: Gets or sets the target storage container ARM Id. Required.
    :vartype storage_container_id: str
    :ivar target_resource_group_id: Gets or sets the target resource group ARM Id. Required.
    :vartype target_resource_group_id: str
    :ivar target_location: Gets or sets the target location.
    :vartype target_location: str
    :ivar custom_location_region: Gets or sets the location of Azure Arc HCI custom location
     resource. Required.
    :vartype custom_location_region: str
    :ivar disks_to_include: Gets or sets the list of disks to replicate. Required.
    :vartype disks_to_include:
     list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCIDiskInput]
    :ivar nics_to_include: Gets or sets the list of VM NIC to replicate. Required.
    :vartype nics_to_include:
     list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCINicInput]
    :ivar protected_disks: Gets or sets the list of protected disks.
    :vartype protected_disks:
     list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCIProtectedDiskProperties]
    :ivar protected_nics: Gets or sets the VM NIC details.
    :vartype protected_nics:
     list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCIProtectedNicProperties]
    :ivar target_vm_bios_id: Gets or sets the BIOS Id of the target AzStackHCI VM.
    :vartype target_vm_bios_id: str
    :ivar target_vm_name: Gets or sets the target VM display name.
    :vartype target_vm_name: str
    :ivar hyper_v_generation: Gets or sets the hypervisor generation of the virtual machine
     possible values are 1,2. Required.
    :vartype hyper_v_generation: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
    :vartype test_network_id: str
    :ivar target_cpu_cores: Gets or sets the target CPU cores.
    :vartype target_cpu_cores: int
    :ivar is_dynamic_ram: Gets or sets a value indicating whether memory is dynamical.
    :vartype is_dynamic_ram: bool
    :ivar dynamic_memory_config: Protected item dynamic memory config.
    :vartype dynamic_memory_config:
     ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemDynamicMemoryConfig
    :ivar target_memory_in_mega_bytes: Gets or sets the target memory in mega-bytes.
    :vartype target_memory_in_mega_bytes: int
    :ivar os_type: Gets or sets the type of the OS.
    :vartype os_type: str
    :ivar os_name: Gets or sets the name of the OS.
    :vartype os_name: str
    :ivar firmware_type: Gets or sets the firmware type.
    :vartype firmware_type: str
    :ivar fabric_discovery_machine_id: Gets or sets the ARM Id of the discovered machine. Required.
    :vartype fabric_discovery_machine_id: str
    :ivar source_vm_name: Gets or sets the source VM display name.
    :vartype source_vm_name: str
    :ivar source_cpu_cores: Gets or sets the source VM CPU cores.
    :vartype source_cpu_cores: int
    :ivar source_memory_in_mega_bytes: Gets or sets the source VM ram memory size in megabytes.
    :vartype source_memory_in_mega_bytes: float
    :ivar run_as_account_id: Gets or sets the run as account Id. Required.
    :vartype run_as_account_id: str
    :ivar source_dra_name: Gets or sets the source DRA name. Required.
    :vartype source_dra_name: str
    :ivar target_dra_name: Gets or sets the target DRA name. Required.
    :vartype target_dra_name: str
    :ivar source_appliance_name: Gets or sets the source appliance name.
    :vartype source_appliance_name: str
    :ivar target_appliance_name: Gets or sets the target appliance name.
    :vartype target_appliance_name: str
    :ivar failover_recovery_point_id: Gets or sets the recovery point Id to which the VM was failed
     over.
    :vartype failover_recovery_point_id: str
    :ivar last_recovery_point_received: Gets or sets the last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :ivar last_recovery_point_id: Gets or sets the last recovery point Id.
    :vartype last_recovery_point_id: str
    :ivar initial_replication_progress_percentage: Gets or sets the initial replication progress
     percentage. This is calculated based on
     total bytes processed for all disks in the source VM.
    :vartype initial_replication_progress_percentage: int
    :ivar migration_progress_percentage: Gets or sets the migration progress percentage.
    :vartype migration_progress_percentage: int
    :ivar resume_progress_percentage: Gets or sets the resume progress percentage.
    :vartype resume_progress_percentage: int
    :ivar resync_progress_percentage: Gets or sets the resync progress percentage. This is
     calculated based on total bytes
     processed for all disks in the source VM.
    :vartype resync_progress_percentage: int
    :ivar resync_retry_count: Gets or sets the resync retry count.
    :vartype resync_retry_count: int
    :ivar resync_required: Gets or sets a value indicating whether resync is required.
    :vartype resync_required: bool
    :ivar resync_state: Gets or sets the resync state. Known values are: "None",
     "PreparedForResynchronization", and "StartedResynchronization".
    :vartype resync_state: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzureMigrateResyncState
    :ivar perform_auto_resync: Gets or sets a value indicating whether auto resync is to be done.
    :vartype perform_auto_resync: bool
    :ivar resume_retry_count: Gets or sets the resume retry count.
    :vartype resume_retry_count: int
    :ivar last_replication_update_time: Gets or sets the latest timestamp that replication status
     is updated.
    :vartype last_replication_update_time: ~datetime.datetime
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "active_location": {"readonly": True},
        "target_hci_cluster_id": {"required": True, "min_length": 1},
        "target_arc_cluster_custom_location_id": {"required": True, "min_length": 1},
        "target_az_stack_hci_cluster_name": {"readonly": True},
        "storage_container_id": {"required": True, "min_length": 1},
        "target_resource_group_id": {"required": True, "min_length": 1},
        "target_location": {"readonly": True},
        "custom_location_region": {"required": True, "min_length": 1},
        "disks_to_include": {"required": True, "min_items": 1},
        "nics_to_include": {"required": True, "min_items": 1},
        "protected_disks": {"readonly": True},
        "protected_nics": {"readonly": True},
        "target_vm_bios_id": {"readonly": True},
        "hyper_v_generation": {"required": True, "min_length": 1},
        "os_type": {"readonly": True},
        "os_name": {"readonly": True},
        "firmware_type": {"readonly": True},
        "fabric_discovery_machine_id": {"required": True, "min_length": 1},
        "source_vm_name": {"readonly": True},
        "source_cpu_cores": {"readonly": True},
        "source_memory_in_mega_bytes": {"readonly": True},
        "run_as_account_id": {"required": True, "min_length": 1},
        "source_dra_name": {"required": True, "min_length": 1},
        "target_dra_name": {"required": True, "min_length": 1},
        "source_appliance_name": {"readonly": True},
        "target_appliance_name": {"readonly": True},
        "failover_recovery_point_id": {"readonly": True},
        "last_recovery_point_received": {"readonly": True},
        "last_recovery_point_id": {"readonly": True},
        "initial_replication_progress_percentage": {"readonly": True},
        "migration_progress_percentage": {"readonly": True},
        "resume_progress_percentage": {"readonly": True},
        "resync_progress_percentage": {"readonly": True},
        "resync_retry_count": {"readonly": True},
        "resync_required": {"readonly": True},
        "resync_state": {"readonly": True},
        "resume_retry_count": {"readonly": True},
        "last_replication_update_time": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "active_location": {"key": "activeLocation", "type": "str"},
        "target_hci_cluster_id": {"key": "targetHciClusterId", "type": "str"},
        "target_arc_cluster_custom_location_id": {"key": "targetArcClusterCustomLocationId", "type": "str"},
        "target_az_stack_hci_cluster_name": {"key": "targetAzStackHciClusterName", "type": "str"},
        "storage_container_id": {"key": "storageContainerId", "type": "str"},
        "target_resource_group_id": {"key": "targetResourceGroupId", "type": "str"},
        "target_location": {"key": "targetLocation", "type": "str"},
        "custom_location_region": {"key": "customLocationRegion", "type": "str"},
        "disks_to_include": {"key": "disksToInclude", "type": "[VMwareToAzStackHCIDiskInput]"},
        "nics_to_include": {"key": "nicsToInclude", "type": "[VMwareToAzStackHCINicInput]"},
        "protected_disks": {"key": "protectedDisks", "type": "[VMwareToAzStackHCIProtectedDiskProperties]"},
        "protected_nics": {"key": "protectedNics", "type": "[VMwareToAzStackHCIProtectedNicProperties]"},
        "target_vm_bios_id": {"key": "targetVmBiosId", "type": "str"},
        "target_vm_name": {"key": "targetVmName", "type": "str"},
        "hyper_v_generation": {"key": "hyperVGeneration", "type": "str"},
        "target_network_id": {"key": "targetNetworkId", "type": "str"},
        "test_network_id": {"key": "testNetworkId", "type": "str"},
        "target_cpu_cores": {"key": "targetCpuCores", "type": "int"},
        "is_dynamic_ram": {"key": "isDynamicRam", "type": "bool"},
        "dynamic_memory_config": {"key": "dynamicMemoryConfig", "type": "ProtectedItemDynamicMemoryConfig"},
        "target_memory_in_mega_bytes": {"key": "targetMemoryInMegaBytes", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "firmware_type": {"key": "firmwareType", "type": "str"},
        "fabric_discovery_machine_id": {"key": "fabricDiscoveryMachineId", "type": "str"},
        "source_vm_name": {"key": "sourceVmName", "type": "str"},
        "source_cpu_cores": {"key": "sourceCpuCores", "type": "int"},
        "source_memory_in_mega_bytes": {"key": "sourceMemoryInMegaBytes", "type": "float"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "source_dra_name": {"key": "sourceDraName", "type": "str"},
        "target_dra_name": {"key": "targetDraName", "type": "str"},
        "source_appliance_name": {"key": "sourceApplianceName", "type": "str"},
        "target_appliance_name": {"key": "targetApplianceName", "type": "str"},
        "failover_recovery_point_id": {"key": "failoverRecoveryPointId", "type": "str"},
        "last_recovery_point_received": {"key": "lastRecoveryPointReceived", "type": "iso-8601"},
        "last_recovery_point_id": {"key": "lastRecoveryPointId", "type": "str"},
        "initial_replication_progress_percentage": {"key": "initialReplicationProgressPercentage", "type": "int"},
        "migration_progress_percentage": {"key": "migrationProgressPercentage", "type": "int"},
        "resume_progress_percentage": {"key": "resumeProgressPercentage", "type": "int"},
        "resync_progress_percentage": {"key": "resyncProgressPercentage", "type": "int"},
        "resync_retry_count": {"key": "resyncRetryCount", "type": "int"},
        "resync_required": {"key": "resyncRequired", "type": "bool"},
        "resync_state": {"key": "resyncState", "type": "str"},
        "perform_auto_resync": {"key": "performAutoResync", "type": "bool"},
        "resume_retry_count": {"key": "resumeRetryCount", "type": "int"},
        "last_replication_update_time": {"key": "lastReplicationUpdateTime", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        target_hci_cluster_id: str,
        target_arc_cluster_custom_location_id: str,
        storage_container_id: str,
        target_resource_group_id: str,
        custom_location_region: str,
        disks_to_include: List["_models.VMwareToAzStackHCIDiskInput"],
        nics_to_include: List["_models.VMwareToAzStackHCINicInput"],
        hyper_v_generation: str,
        fabric_discovery_machine_id: str,
        run_as_account_id: str,
        source_dra_name: str,
        target_dra_name: str,
        target_vm_name: Optional[str] = None,
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        target_cpu_cores: Optional[int] = None,
        is_dynamic_ram: Optional[bool] = None,
        dynamic_memory_config: Optional["_models.ProtectedItemDynamicMemoryConfig"] = None,
        target_memory_in_mega_bytes: Optional[int] = None,
        perform_auto_resync: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_hci_cluster_id: Gets or sets the Target HCI Cluster ARM Id. Required.
        :paramtype target_hci_cluster_id: str
        :keyword target_arc_cluster_custom_location_id: Gets or sets the Target Arc Cluster Custom
         Location ARM Id. Required.
        :paramtype target_arc_cluster_custom_location_id: str
        :keyword storage_container_id: Gets or sets the target storage container ARM Id. Required.
        :paramtype storage_container_id: str
        :keyword target_resource_group_id: Gets or sets the target resource group ARM Id. Required.
        :paramtype target_resource_group_id: str
        :keyword custom_location_region: Gets or sets the location of Azure Arc HCI custom location
         resource. Required.
        :paramtype custom_location_region: str
        :keyword disks_to_include: Gets or sets the list of disks to replicate. Required.
        :paramtype disks_to_include:
         list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCIDiskInput]
        :keyword nics_to_include: Gets or sets the list of VM NIC to replicate. Required.
        :paramtype nics_to_include:
         list[~azure.mgmt.recoveryservicesdatareplication.models.VMwareToAzStackHCINicInput]
        :keyword target_vm_name: Gets or sets the target VM display name.
        :paramtype target_vm_name: str
        :keyword hyper_v_generation: Gets or sets the hypervisor generation of the virtual machine
         possible values are 1,2. Required.
        :paramtype hyper_v_generation: str
        :keyword target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
        :paramtype target_network_id: str
        :keyword test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
        :paramtype test_network_id: str
        :keyword target_cpu_cores: Gets or sets the target CPU cores.
        :paramtype target_cpu_cores: int
        :keyword is_dynamic_ram: Gets or sets a value indicating whether memory is dynamical.
        :paramtype is_dynamic_ram: bool
        :keyword dynamic_memory_config: Protected item dynamic memory config.
        :paramtype dynamic_memory_config:
         ~azure.mgmt.recoveryservicesdatareplication.models.ProtectedItemDynamicMemoryConfig
        :keyword target_memory_in_mega_bytes: Gets or sets the target memory in mega-bytes.
        :paramtype target_memory_in_mega_bytes: int
        :keyword fabric_discovery_machine_id: Gets or sets the ARM Id of the discovered machine.
         Required.
        :paramtype fabric_discovery_machine_id: str
        :keyword run_as_account_id: Gets or sets the run as account Id. Required.
        :paramtype run_as_account_id: str
        :keyword source_dra_name: Gets or sets the source DRA name. Required.
        :paramtype source_dra_name: str
        :keyword target_dra_name: Gets or sets the target DRA name. Required.
        :paramtype target_dra_name: str
        :keyword perform_auto_resync: Gets or sets a value indicating whether auto resync is to be
         done.
        :paramtype perform_auto_resync: bool
        """
        super().__init__(**kwargs)
        self.instance_type: str = "VMwareToAzStackHCI"
        self.active_location = None
        self.target_hci_cluster_id = target_hci_cluster_id
        self.target_arc_cluster_custom_location_id = target_arc_cluster_custom_location_id
        self.target_az_stack_hci_cluster_name = None
        self.storage_container_id = storage_container_id
        self.target_resource_group_id = target_resource_group_id
        self.target_location = None
        self.custom_location_region = custom_location_region
        self.disks_to_include = disks_to_include
        self.nics_to_include = nics_to_include
        self.protected_disks = None
        self.protected_nics = None
        self.target_vm_bios_id = None
        self.target_vm_name = target_vm_name
        self.hyper_v_generation = hyper_v_generation
        self.target_network_id = target_network_id
        self.test_network_id = test_network_id
        self.target_cpu_cores = target_cpu_cores
        self.is_dynamic_ram = is_dynamic_ram
        self.dynamic_memory_config = dynamic_memory_config
        self.target_memory_in_mega_bytes = target_memory_in_mega_bytes
        self.os_type = None
        self.os_name = None
        self.firmware_type = None
        self.fabric_discovery_machine_id = fabric_discovery_machine_id
        self.source_vm_name = None
        self.source_cpu_cores = None
        self.source_memory_in_mega_bytes = None
        self.run_as_account_id = run_as_account_id
        self.source_dra_name = source_dra_name
        self.target_dra_name = target_dra_name
        self.source_appliance_name = None
        self.target_appliance_name = None
        self.failover_recovery_point_id = None
        self.last_recovery_point_received = None
        self.last_recovery_point_id = None
        self.initial_replication_progress_percentage = None
        self.migration_progress_percentage = None
        self.resume_progress_percentage = None
        self.resync_progress_percentage = None
        self.resync_retry_count = None
        self.resync_required = None
        self.resync_state = None
        self.perform_auto_resync = perform_auto_resync
        self.resume_retry_count = None
        self.last_replication_update_time = None


class VMwareToAzStackHCIProtectedNicProperties(_serialization.Model):
    """VMwareToAzStackHCI NIC properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nic_id: Gets or sets the NIC Id.
    :vartype nic_id: str
    :ivar mac_address: Gets or sets the NIC mac address.
    :vartype mac_address: str
    :ivar label: Gets or sets the NIC label.
    :vartype label: str
    :ivar is_primary_nic: Gets or sets a value indicating whether this is the primary NIC.
    :vartype is_primary_nic: bool
    :ivar network_name: Gets or sets the network name.
    :vartype network_name: str
    :ivar target_network_id: Gets or sets the target network Id within AzStackHCI Cluster.
    :vartype target_network_id: str
    :ivar test_network_id: Gets or sets the target test network Id within AzStackHCI Cluster.
    :vartype test_network_id: str
    :ivar selection_type_for_failover: Gets or sets the selection type of the NIC. Known values
     are: "NotSelected", "SelectedByUser", "SelectedByDefault", and "SelectedByUserOverride".
    :vartype selection_type_for_failover: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.VMNicSelection
    """

    _validation = {
        "nic_id": {"readonly": True},
        "mac_address": {"readonly": True},
        "label": {"readonly": True},
        "network_name": {"readonly": True},
        "target_network_id": {"readonly": True},
        "test_network_id": {"readonly": True},
        "selection_type_for_failover": {"readonly": True},
    }

    _attribute_map = {
        "nic_id": {"key": "nicId", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "is_primary_nic": {"key": "isPrimaryNic", "type": "bool"},
        "network_name": {"key": "networkName", "type": "str"},
        "target_network_id": {"key": "targetNetworkId", "type": "str"},
        "test_network_id": {"key": "testNetworkId", "type": "str"},
        "selection_type_for_failover": {"key": "selectionTypeForFailover", "type": "str"},
    }

    def __init__(self, *, is_primary_nic: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_primary_nic: Gets or sets a value indicating whether this is the primary NIC.
        :paramtype is_primary_nic: bool
        """
        super().__init__(**kwargs)
        self.nic_id = None
        self.mac_address = None
        self.label = None
        self.is_primary_nic = is_primary_nic
        self.network_name = None
        self.target_network_id = None
        self.test_network_id = None
        self.selection_type_for_failover = None


class VMwareToAzStackHCIReplicationExtensionModelCustomProperties(
    ReplicationExtensionModelCustomProperties
):  # pylint: disable=too-many-instance-attributes
    """VMware to AzStackHCI Replication extension model custom properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets or sets the instance type. Required.
    :vartype instance_type: str
    :ivar vmware_fabric_arm_id: Gets or sets the ARM Id of the source VMware fabric. Required.
    :vartype vmware_fabric_arm_id: str
    :ivar vmware_site_id: Gets or sets the ARM Id of the VMware site.
    :vartype vmware_site_id: str
    :ivar az_stack_hci_fabric_arm_id: Gets or sets the ARM Id of the target AzStackHCI fabric.
     Required.
    :vartype az_stack_hci_fabric_arm_id: str
    :ivar az_stack_hci_site_id: Gets or sets the ARM Id of the AzStackHCI site.
    :vartype az_stack_hci_site_id: str
    :ivar storage_account_id: Gets or sets the storage account Id.
    :vartype storage_account_id: str
    :ivar storage_account_sas_secret_name: Gets or sets the Sas Secret of storage account.
    :vartype storage_account_sas_secret_name: str
    :ivar asr_service_uri: Gets or sets the Uri of ASR.
    :vartype asr_service_uri: str
    :ivar rcm_service_uri: Gets or sets the Uri of Rcm.
    :vartype rcm_service_uri: str
    :ivar gateway_service_uri: Gets or sets the Uri of Gateway.
    :vartype gateway_service_uri: str
    :ivar source_gateway_service_id: Gets or sets the gateway service Id of source.
    :vartype source_gateway_service_id: str
    :ivar target_gateway_service_id: Gets or sets the gateway service Id of target.
    :vartype target_gateway_service_id: str
    :ivar source_storage_container_name: Gets or sets the source storage container name.
    :vartype source_storage_container_name: str
    :ivar target_storage_container_name: Gets or sets the target storage container name.
    :vartype target_storage_container_name: str
    :ivar resource_location: Gets or sets the resource location.
    :vartype resource_location: str
    :ivar subscription_id: Gets or sets the subscription.
    :vartype subscription_id: str
    :ivar resource_group: Gets or sets the resource group.
    :vartype resource_group: str
    """

    _validation = {
        "instance_type": {"required": True, "min_length": 1},
        "vmware_fabric_arm_id": {"required": True, "min_length": 1},
        "vmware_site_id": {"readonly": True},
        "az_stack_hci_fabric_arm_id": {"required": True, "min_length": 1},
        "az_stack_hci_site_id": {"readonly": True},
        "asr_service_uri": {"readonly": True},
        "rcm_service_uri": {"readonly": True},
        "gateway_service_uri": {"readonly": True},
        "source_gateway_service_id": {"readonly": True},
        "target_gateway_service_id": {"readonly": True},
        "source_storage_container_name": {"readonly": True},
        "target_storage_container_name": {"readonly": True},
        "resource_location": {"readonly": True},
        "subscription_id": {"readonly": True},
        "resource_group": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "vmware_fabric_arm_id": {"key": "vmwareFabricArmId", "type": "str"},
        "vmware_site_id": {"key": "vmwareSiteId", "type": "str"},
        "az_stack_hci_fabric_arm_id": {"key": "azStackHciFabricArmId", "type": "str"},
        "az_stack_hci_site_id": {"key": "azStackHciSiteId", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "storage_account_sas_secret_name": {"key": "storageAccountSasSecretName", "type": "str"},
        "asr_service_uri": {"key": "asrServiceUri", "type": "str"},
        "rcm_service_uri": {"key": "rcmServiceUri", "type": "str"},
        "gateway_service_uri": {"key": "gatewayServiceUri", "type": "str"},
        "source_gateway_service_id": {"key": "sourceGatewayServiceId", "type": "str"},
        "target_gateway_service_id": {"key": "targetGatewayServiceId", "type": "str"},
        "source_storage_container_name": {"key": "sourceStorageContainerName", "type": "str"},
        "target_storage_container_name": {"key": "targetStorageContainerName", "type": "str"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        vmware_fabric_arm_id: str,
        az_stack_hci_fabric_arm_id: str,
        storage_account_id: Optional[str] = None,
        storage_account_sas_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vmware_fabric_arm_id: Gets or sets the ARM Id of the source VMware fabric. Required.
        :paramtype vmware_fabric_arm_id: str
        :keyword az_stack_hci_fabric_arm_id: Gets or sets the ARM Id of the target AzStackHCI fabric.
         Required.
        :paramtype az_stack_hci_fabric_arm_id: str
        :keyword storage_account_id: Gets or sets the storage account Id.
        :paramtype storage_account_id: str
        :keyword storage_account_sas_secret_name: Gets or sets the Sas Secret of storage account.
        :paramtype storage_account_sas_secret_name: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "VMwareToAzStackHCI"
        self.vmware_fabric_arm_id = vmware_fabric_arm_id
        self.vmware_site_id = None
        self.az_stack_hci_fabric_arm_id = az_stack_hci_fabric_arm_id
        self.az_stack_hci_site_id = None
        self.storage_account_id = storage_account_id
        self.storage_account_sas_secret_name = storage_account_sas_secret_name
        self.asr_service_uri = None
        self.rcm_service_uri = None
        self.gateway_service_uri = None
        self.source_gateway_service_id = None
        self.target_gateway_service_id = None
        self.source_storage_container_name = None
        self.target_storage_container_name = None
        self.resource_location = None
        self.subscription_id = None
        self.resource_group = None


class WorkflowModel(_serialization.Model):
    """Workflow model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Workflow model properties. Required.
    :vartype properties: ~azure.mgmt.recoveryservicesdatareplication.models.WorkflowModelProperties
    :ivar id: Gets or sets the Id of the resource.
    :vartype id: str
    :ivar name: Gets or sets the name of the resource.
    :vartype name: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :ivar system_data:
    :vartype system_data:
     ~azure.mgmt.recoveryservicesdatareplication.models.WorkflowModelSystemData
    """

    _validation = {
        "properties": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "WorkflowModelProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "WorkflowModelSystemData"},
    }

    def __init__(self, *, properties: "_models.WorkflowModelProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Workflow model properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.WorkflowModelProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class WorkflowModelCollection(_serialization.Model):
    """Workflow model collection.

    :ivar value: Gets or sets the list of workflows.
    :vartype value: list[~azure.mgmt.recoveryservicesdatareplication.models.WorkflowModel]
    :ivar next_link: Gets or sets the value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkflowModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.WorkflowModel"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets the list of workflows.
        :paramtype value: list[~azure.mgmt.recoveryservicesdatareplication.models.WorkflowModel]
        :keyword next_link: Gets or sets the value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowModelProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Workflow model properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: Gets or sets the friendly display name.
    :vartype display_name: str
    :ivar state: Gets or sets the workflow state. Known values are: "Pending", "Started",
     "Cancelling", "Succeeded", "Failed", "Cancelled", "CompletedWithInformation",
     "CompletedWithWarnings", and "CompletedWithErrors".
    :vartype state: str or ~azure.mgmt.recoveryservicesdatareplication.models.WorkflowState
    :ivar start_time: Gets or sets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets or sets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar object_id: Gets or sets the affected object Id.
    :vartype object_id: str
    :ivar object_name: Gets or sets the affected object name.
    :vartype object_name: str
    :ivar object_internal_id: Gets or sets the affected object internal Id.
    :vartype object_internal_id: str
    :ivar object_internal_name: Gets or sets the affected object internal name.
    :vartype object_internal_name: str
    :ivar object_type: Gets or sets the object type. Known values are: "AvsDiskPool", "Dra",
     "Fabric", "Policy", "ProtectedItem", "RecoveryPlan", "ReplicationExtension", and "Vault".
    :vartype object_type: str or
     ~azure.mgmt.recoveryservicesdatareplication.models.WorkflowObjectType
    :ivar replication_provider_id: Gets or sets the replication provider.
    :vartype replication_provider_id: str
    :ivar source_fabric_provider_id: Gets or sets the source fabric provider.
    :vartype source_fabric_provider_id: str
    :ivar target_fabric_provider_id: Gets or sets the target fabric provider.
    :vartype target_fabric_provider_id: str
    :ivar allowed_actions: Gets or sets the list of allowed actions on the workflow.
    :vartype allowed_actions: list[str]
    :ivar activity_id: Gets or sets the workflow activity id.
    :vartype activity_id: str
    :ivar tasks: Gets or sets the list of tasks.
    :vartype tasks: list[~azure.mgmt.recoveryservicesdatareplication.models.TaskModel]
    :ivar errors: Gets or sets the list of errors.
    :vartype errors: list[~azure.mgmt.recoveryservicesdatareplication.models.ErrorModel]
    :ivar custom_properties: Workflow model custom properties. Required.
    :vartype custom_properties:
     ~azure.mgmt.recoveryservicesdatareplication.models.WorkflowModelCustomProperties
    """

    _validation = {
        "display_name": {"readonly": True},
        "state": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "object_id": {"readonly": True},
        "object_name": {"readonly": True},
        "object_internal_id": {"readonly": True},
        "object_internal_name": {"readonly": True},
        "object_type": {"readonly": True},
        "replication_provider_id": {"readonly": True},
        "source_fabric_provider_id": {"readonly": True},
        "target_fabric_provider_id": {"readonly": True},
        "allowed_actions": {"readonly": True},
        "activity_id": {"readonly": True},
        "tasks": {"readonly": True},
        "errors": {"readonly": True},
        "custom_properties": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "object_id": {"key": "objectId", "type": "str"},
        "object_name": {"key": "objectName", "type": "str"},
        "object_internal_id": {"key": "objectInternalId", "type": "str"},
        "object_internal_name": {"key": "objectInternalName", "type": "str"},
        "object_type": {"key": "objectType", "type": "str"},
        "replication_provider_id": {"key": "replicationProviderId", "type": "str"},
        "source_fabric_provider_id": {"key": "sourceFabricProviderId", "type": "str"},
        "target_fabric_provider_id": {"key": "targetFabricProviderId", "type": "str"},
        "allowed_actions": {"key": "allowedActions", "type": "[str]"},
        "activity_id": {"key": "activityId", "type": "str"},
        "tasks": {"key": "tasks", "type": "[TaskModel]"},
        "errors": {"key": "errors", "type": "[ErrorModel]"},
        "custom_properties": {"key": "customProperties", "type": "WorkflowModelCustomProperties"},
    }

    def __init__(self, *, custom_properties: "_models.WorkflowModelCustomProperties", **kwargs: Any) -> None:
        """
        :keyword custom_properties: Workflow model custom properties. Required.
        :paramtype custom_properties:
         ~azure.mgmt.recoveryservicesdatareplication.models.WorkflowModelCustomProperties
        """
        super().__init__(**kwargs)
        self.display_name = None
        self.state = None
        self.start_time = None
        self.end_time = None
        self.object_id = None
        self.object_name = None
        self.object_internal_id = None
        self.object_internal_name = None
        self.object_type = None
        self.replication_provider_id = None
        self.source_fabric_provider_id = None
        self.target_fabric_provider_id = None
        self.allowed_actions = None
        self.activity_id = None
        self.tasks = None
        self.errors = None
        self.custom_properties = custom_properties


class WorkflowModelSystemData(SystemDataModel):
    """WorkflowModelSystemData.

    :ivar created_by: Gets or sets identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: Gets or sets the type of identity that created the resource: user,
     application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: Gets or sets the timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Gets or sets the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Gets or sets the type of identity that last modified the resource:
     user, application,
     managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: Gets or sets identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: Gets or sets the type of identity that created the resource: user,
         application,
         managedIdentity.
        :paramtype created_by_type: str
        :keyword created_at: Gets or sets the timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Gets or sets the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Gets or sets the type of identity that last modified the
         resource: user, application,
         managedIdentity.
        :paramtype last_modified_by_type: str
        :keyword last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_by_type=created_by_type,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_by_type=last_modified_by_type,
            last_modified_at=last_modified_at,
            **kwargs
        )
