Minutes from 11th OpenVDB TSC meeting, Mar. 21, 2019

Attendees: *Nick* A., *Dan* B. (late), *Peter* C., *Jeff* L.

Additional Attendees: Bruce Chernia (Intel), Andrew Pearce (DWA),
Thanh Ha (LF)

Agenda:

1) Confirmation of quorum
2) Selection of secretary
3) Update on CMake
4) Reno Change
5) Documentation.
6) Warnings as Errors
7) Unifying SOP Labels (postponed)
8) JIRA is not working
9) Deprecation (added)
10) Next Meeting

1) A quorum was confirmed.  Nick was selected to chair the meeting.
Ken had announced he could not attend due to pre-existing conflict,
and had approved the meeting proceeding without him.

2) Secretary - Jeff Lait

3) Update on CMake from Nick

3a) CMake

The PR is in a good place.  Required more work than expected, but mostly
tidying up and testing on Mac and Linux.   Not tested on Maya-Windows.

Blosc, ILM-Half, TBB, and a few others do not have CMake modules yet.

Houdini and GLFW modules done - using the CMake examples from SideFX.

There will be a PR add a custom module for numpy to avoid it requiring CMake
3.14.

Call for everyone to test the CMake on their own platforms.

3b) Circle CI and Travis

The TAC has enabled CircleCI so we can move forward with that and it should
work.  Dan will help with CircleCI additions to the CMake PR so it can
be merged with very basic CI support (Houdini 17 / ABI 6).  Initially
CircleCI will be turned on as an optional check and TravisCI as the
required check as we build up CircleCI support.

sesitag causes problems with .dsos not being cacheable as they keep
changing.  SideFX should provide insight on a better workflow.

4) Reno Change

Proposal is to use reno to do intra-release change files.  This involves
any change to the change file being stored as a separate yaml text
file, so avoid any conflicts on out-of-order resolution of PRs.

Concerns were raised about the doxygen and plain text requiring separate
verbage.   One idea is to generate all the doxygen text when doing final
flattening. Another is to have two headers in the yaml, one for text
and one for doxygen.

Concerns were raised that reno is too heavyweight.  Dan will provide
an example of what the contributing text will look like so we can ascertain
how heavyweight this process is.

5) Documentation.

Should published doxygen be all releases or only the current release?

ReadTheDocs may have a neat way to have multiple releases in one page;
but it may also require Sphynx and/or restructured text.  Generally
acknowledged that doxygen workflow doesn't require an extra tool, but
just requires automation of existing tool.

Agreed that CI & CMake should be processed first.  Then consider
documentation process improvements.

6) Warnings as Errors

PR for removing all warnings, allowing warnings to be treated as errors,
in target gcc platform is largely complete.  Most are from trivial
casting conversions and escaping casts.  This forces us to make
an explicit choice of where precision is gained or lost.

In some cases, like interpolation, we may have a float grid with a double
position.  Should it upcast everything to double, tri-lerp, and then
down cast to float?  Or downcast the position to float, then do all
the computation?   First will give more precision, second possibly more
speed (but this should be verified).  The current situation where we
repeatedly cast up and down is likely worst of all worlds.

Nick will cut the contentious components out of the PR so it can go
in and build a new PR that deals with the precision questions.

8) JIRA is not working

Dan is currently manually adding everyone to every ticket.  Thanh
requested a helpdesk ticket is made to resolve this.

9) Deprecation

Removal of deprecated code will wait until after the CI/CMake issues are clear.
Dan will start to add deprecation warnings according to the new deprecation
policy.  Code will not be removed until the next release.  (Note: I'm unclear
if this means minor or major)

10) Next Meeting

Our next TSC meeting is scheduled for Thursday March 28, 2019 11am-12pm PST.
