%%NAME
%%  ehtmladdtxt  -  add text to exist html file
%%
%%SYNOPSIS
%%  ehtmladdtxt(htmlFileName,text)
%%
%%PARAMETER(S)
%%  htmlFileName   name of html-file
%%  text    text or name of text-file
%%GLOBAL PARAMETER(S)
% written by stefan.mueller@fhr.fraunhofer.de (C) 2012
function [htmlFileName]=ehtmladdtxt(htmlFileName,text)
  if (nargin<1) || (nargin>2)
    eusage('ehtmladdtxt(htmlFileName,text)');
  end
  textL=length(text);
  if textL<80
    if exist(text)==2
      txtFileName=text;
      [text textL]=etxtread(txtFileName);
    end
  end
  htmlFile=fopen(htmlFileName,'r+b');
  if htmlFile<=0
    disp('error in ehtmladdtxt: file not exist');
  else
    % add text to html file
    fseek(htmlFile,-30,1);
    [data dl]=fread(htmlFile,inf,'uchar');
    htmlText=char(data).';
    pos=findstr(htmlText,'</CENTER></BODY>')-1;
    fseek(htmlFile,-30,1);
    fwrite(htmlFile,data(1:pos),'uchar');
    fprintf(htmlFile,'%s\n',text);
    fprintf(htmlFile,'</CENTER></BODY>\n<HTML>\n');
    fclose(htmlFile);
  end
