/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Stack;

public class StringStackBuffer {
    private Stack stk = new Stack();

    public StringStackBuffer add(String s) {
        if (s != null && !this.contains(s)) {
            this.stk.push(s);
        }
        return this;
    }

    public StringStackBuffer addAll(StringStackBuffer s) {
        Iterator it = ((AbstractList)s.stk).iterator();
        while (it.hasNext()) {
            this.add((String)it.next());
        }
        return this;
    }

    public void clear() {
        this.stk.clear();
    }

    public boolean contains(String s) {
        return this.stk.search(s) != -1;
    }

    public boolean empty() {
        return this.stk.empty();
    }

    public String get(int i) {
        return (String)this.stk.elementAt(i);
    }

    public int size() {
        return this.stk.size();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String separator) {
        String s;
        if (this.size() > 0) {
            if (separator == null) {
                separator = "";
            }
            int totalSize = 0;
            int i = 0;
            while (i < this.stk.size()) {
                totalSize += this.get(i).length();
                ++i;
            }
            StringBuffer sb = new StringBuffer(totalSize += (this.stk.size() - 1) * separator.length()).append(this.get(0));
            int i2 = 1;
            while (i2 < this.stk.size()) {
                sb.append(separator).append(this.get(i2));
                ++i2;
            }
            String string = sb.toString();
        } else {
            s = "";
        }
        return s;
    }

    public boolean equals(Object ssbuf) {
        boolean isEquiv = false;
        if (ssbuf == null || !(ssbuf instanceof StringStackBuffer)) {
            isEquiv = false;
        } else if (ssbuf == this) {
            isEquiv = true;
        } else if (this.toString().equals(ssbuf.toString())) {
            isEquiv = true;
        }
        return isEquiv;
    }

    public String[] toStringArray() {
        String[] ss = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            ss[i] = this.get(i);
            ++i;
        }
        return ss;
    }
}

