// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/actions/sdk/v2/data_file.proto

package sdk

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Wrapper for repeated data file. Repeated fields cannot exist in a oneof.
type DataFiles struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Multiple data files.
	DataFiles []*DataFile `protobuf:"bytes,1,rep,name=data_files,json=dataFiles,proto3" json:"data_files,omitempty"`
}

func (x *DataFiles) Reset() {
	*x = DataFiles{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_data_file_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataFiles) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataFiles) ProtoMessage() {}

func (x *DataFiles) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_data_file_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataFiles.ProtoReflect.Descriptor instead.
func (*DataFiles) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_data_file_proto_rawDescGZIP(), []int{0}
}

func (x *DataFiles) GetDataFiles() []*DataFile {
	if x != nil {
		return x.DataFiles
	}
	return nil
}

// Represents a single file which contains unstructured data. Examples include
// image files, audio files, and cloud function source code.
type DataFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Relative path of the data file from the project root in the SDK file
	// structure.
	// Allowed file paths:
	//     - Images: `resources/images/{multiple
	//     directories}?/{ImageName}.{extension}`
	//     - Audio: `resources/audio/{multiple
	//     directories}?/{AudioFileName}.{extension}`
	//     - Inline Cloud Function Code: `webhooks/{WebhookName}.zip`
	// Allowed extensions:
	//     - Images: `png`, `jpg`, `jpeg`
	//     - Audio: `mp3`, `mpeg`
	//     - Inline Cloud Functions: `zip`
	FilePath string `protobuf:"bytes,1,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
	// Required. The content type of this asset. Example: `text/html`. The content
	// type must comply with the specification
	// (http://www.w3.org/Protocols/rfc1341/4_Content-Type.html).
	// Cloud functions must be in zip format and the content type should
	// be `application/zip;zip_type=cloud_function`. The zip_type parameter
	// indicates that the zip is for a cloud function.
	ContentType string `protobuf:"bytes,2,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Content of the data file. Examples would be raw bytes of images, audio
	// files, or cloud function zip format.
	// There is 10 MB strict limit on the payload size.
	Payload []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *DataFile) Reset() {
	*x = DataFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_data_file_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataFile) ProtoMessage() {}

func (x *DataFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_data_file_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataFile.ProtoReflect.Descriptor instead.
func (*DataFile) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_data_file_proto_rawDescGZIP(), []int{1}
}

func (x *DataFile) GetFilePath() string {
	if x != nil {
		return x.FilePath
	}
	return ""
}

func (x *DataFile) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

func (x *DataFile) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

var File_google_actions_sdk_v2_data_file_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_data_file_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x22, 0x4b,
	0x0a, 0x09, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65,
	0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x22, 0x64, 0x0a, 0x08, 0x44,
	0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65,
	0x50, 0x61, 0x74, 0x68, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x42, 0x66, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x42, 0x0d,
	0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73,
	0x64, 0x6b, 0x2f, 0x76, 0x32, 0x3b, 0x73, 0x64, 0x6b, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_actions_sdk_v2_data_file_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_data_file_proto_rawDescData = file_google_actions_sdk_v2_data_file_proto_rawDesc
)

func file_google_actions_sdk_v2_data_file_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_data_file_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_data_file_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_data_file_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_data_file_proto_rawDescData
}

var file_google_actions_sdk_v2_data_file_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_actions_sdk_v2_data_file_proto_goTypes = []interface{}{
	(*DataFiles)(nil), // 0: google.actions.sdk.v2.DataFiles
	(*DataFile)(nil),  // 1: google.actions.sdk.v2.DataFile
}
var file_google_actions_sdk_v2_data_file_proto_depIdxs = []int32{
	1, // 0: google.actions.sdk.v2.DataFiles.data_files:type_name -> google.actions.sdk.v2.DataFile
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_data_file_proto_init() }
func file_google_actions_sdk_v2_data_file_proto_init() {
	if File_google_actions_sdk_v2_data_file_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_data_file_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataFiles); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_data_file_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_data_file_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_data_file_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_data_file_proto_depIdxs,
		MessageInfos:      file_google_actions_sdk_v2_data_file_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_data_file_proto = out.File
	file_google_actions_sdk_v2_data_file_proto_rawDesc = nil
	file_google_actions_sdk_v2_data_file_proto_goTypes = nil
	file_google_actions_sdk_v2_data_file_proto_depIdxs = nil
}
