//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertFilter.
func (a *AlertFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appearedOnTime":
			err = unpopulateTimeRFC3339(val, "AppearedOnTime", &a.AppearedOnTime)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &a.Severity)
			delete(rawMsg, key)
		case "sourceName":
			err = unpopulate(val, "SourceName", &a.SourceName)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &a.SourceType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertNotificationProperties.
func (a AlertNotificationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalRecipientEmailList", a.AdditionalRecipientEmailList)
	populate(objectMap, "alertNotificationCulture", a.AlertNotificationCulture)
	populate(objectMap, "emailNotification", a.EmailNotification)
	populate(objectMap, "notificationToServiceOwners", a.NotificationToServiceOwners)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AlertProperties.
func (a AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertType", a.AlertType)
	populateTimeRFC3339(objectMap, "appearedAtSourceTime", a.AppearedAtSourceTime)
	populateTimeRFC3339(objectMap, "appearedAtTime", a.AppearedAtTime)
	populateTimeRFC3339(objectMap, "clearedAtSourceTime", a.ClearedAtSourceTime)
	populateTimeRFC3339(objectMap, "clearedAtTime", a.ClearedAtTime)
	populate(objectMap, "detailedInformation", a.DetailedInformation)
	populate(objectMap, "errorDetails", a.ErrorDetails)
	populate(objectMap, "recommendation", a.Recommendation)
	populate(objectMap, "resolutionReason", a.ResolutionReason)
	populate(objectMap, "scope", a.Scope)
	populate(objectMap, "severity", a.Severity)
	populate(objectMap, "source", a.Source)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertProperties.
func (a *AlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertType":
			err = unpopulate(val, "AlertType", &a.AlertType)
			delete(rawMsg, key)
		case "appearedAtSourceTime":
			err = unpopulateTimeRFC3339(val, "AppearedAtSourceTime", &a.AppearedAtSourceTime)
			delete(rawMsg, key)
		case "appearedAtTime":
			err = unpopulateTimeRFC3339(val, "AppearedAtTime", &a.AppearedAtTime)
			delete(rawMsg, key)
		case "clearedAtSourceTime":
			err = unpopulateTimeRFC3339(val, "ClearedAtSourceTime", &a.ClearedAtSourceTime)
			delete(rawMsg, key)
		case "clearedAtTime":
			err = unpopulateTimeRFC3339(val, "ClearedAtTime", &a.ClearedAtTime)
			delete(rawMsg, key)
		case "detailedInformation":
			err = unpopulate(val, "DetailedInformation", &a.DetailedInformation)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &a.ErrorDetails)
			delete(rawMsg, key)
		case "recommendation":
			err = unpopulate(val, "Recommendation", &a.Recommendation)
			delete(rawMsg, key)
		case "resolutionReason":
			err = unpopulate(val, "ResolutionReason", &a.ResolutionReason)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &a.Scope)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &a.Severity)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &a.Source)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupFilter.
func (b *BackupFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupPolicyId":
			err = unpopulate(val, "BackupPolicyID", &b.BackupPolicyID)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &b.CreatedTime)
			delete(rawMsg, key)
		case "volumeId":
			err = unpopulate(val, "VolumeID", &b.VolumeID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupPolicyProperties.
func (b BackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupPolicyCreationType", b.BackupPolicyCreationType)
	populateTimeRFC3339(objectMap, "lastBackupTime", b.LastBackupTime)
	populateTimeRFC3339(objectMap, "nextBackupTime", b.NextBackupTime)
	populate(objectMap, "scheduledBackupStatus", b.ScheduledBackupStatus)
	populate(objectMap, "schedulesCount", b.SchedulesCount)
	populate(objectMap, "ssmHostName", b.SsmHostName)
	populate(objectMap, "volumeIds", b.VolumeIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupPolicyProperties.
func (b *BackupPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupPolicyCreationType":
			err = unpopulate(val, "BackupPolicyCreationType", &b.BackupPolicyCreationType)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateTimeRFC3339(val, "LastBackupTime", &b.LastBackupTime)
			delete(rawMsg, key)
		case "nextBackupTime":
			err = unpopulateTimeRFC3339(val, "NextBackupTime", &b.NextBackupTime)
			delete(rawMsg, key)
		case "scheduledBackupStatus":
			err = unpopulate(val, "ScheduledBackupStatus", &b.ScheduledBackupStatus)
			delete(rawMsg, key)
		case "schedulesCount":
			err = unpopulate(val, "SchedulesCount", &b.SchedulesCount)
			delete(rawMsg, key)
		case "ssmHostName":
			err = unpopulate(val, "SsmHostName", &b.SsmHostName)
			delete(rawMsg, key)
		case "volumeIds":
			err = unpopulate(val, "VolumeIDs", &b.VolumeIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupProperties.
func (b BackupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupJobCreationType", b.BackupJobCreationType)
	populate(objectMap, "backupPolicyId", b.BackupPolicyID)
	populate(objectMap, "backupType", b.BackupType)
	populateTimeRFC3339(objectMap, "createdOn", b.CreatedOn)
	populate(objectMap, "elements", b.Elements)
	populate(objectMap, "sizeInBytes", b.SizeInBytes)
	populate(objectMap, "ssmHostName", b.SsmHostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupProperties.
func (b *BackupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupJobCreationType":
			err = unpopulate(val, "BackupJobCreationType", &b.BackupJobCreationType)
			delete(rawMsg, key)
		case "backupPolicyId":
			err = unpopulate(val, "BackupPolicyID", &b.BackupPolicyID)
			delete(rawMsg, key)
		case "backupType":
			err = unpopulate(val, "BackupType", &b.BackupType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &b.CreatedOn)
			delete(rawMsg, key)
		case "elements":
			err = unpopulate(val, "Elements", &b.Elements)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &b.SizeInBytes)
			delete(rawMsg, key)
		case "ssmHostName":
			err = unpopulate(val, "SsmHostName", &b.SsmHostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupScheduleProperties.
func (b BackupScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupType", b.BackupType)
	populateTimeRFC3339(objectMap, "lastSuccessfulRun", b.LastSuccessfulRun)
	populate(objectMap, "retentionCount", b.RetentionCount)
	populate(objectMap, "scheduleRecurrence", b.ScheduleRecurrence)
	populate(objectMap, "scheduleStatus", b.ScheduleStatus)
	populateTimeRFC3339(objectMap, "startTime", b.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupScheduleProperties.
func (b *BackupScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupType":
			err = unpopulate(val, "BackupType", &b.BackupType)
			delete(rawMsg, key)
		case "lastSuccessfulRun":
			err = unpopulateTimeRFC3339(val, "LastSuccessfulRun", &b.LastSuccessfulRun)
			delete(rawMsg, key)
		case "retentionCount":
			err = unpopulate(val, "RetentionCount", &b.RetentionCount)
			delete(rawMsg, key)
		case "scheduleRecurrence":
			err = unpopulate(val, "ScheduleRecurrence", &b.ScheduleRecurrence)
			delete(rawMsg, key)
		case "scheduleStatus":
			err = unpopulate(val, "ScheduleStatus", &b.ScheduleStatus)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &b.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BandwidthRateSettingProperties.
func (b BandwidthRateSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "schedules", b.Schedules)
	populate(objectMap, "volumeCount", b.VolumeCount)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BandwidthSchedule.
func (b BandwidthSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "days", b.Days)
	populate(objectMap, "rateInMbps", b.RateInMbps)
	populate(objectMap, "start", b.Start)
	populate(objectMap, "stop", b.Stop)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ClearAlertRequest.
func (c ClearAlertRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alerts", c.Alerts)
	populate(objectMap, "resolutionMessage", c.ResolutionMessage)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloneRequest.
func (c CloneRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupElement", c.BackupElement)
	populate(objectMap, "targetAccessControlRecordIds", c.TargetAccessControlRecordIDs)
	populate(objectMap, "targetDeviceId", c.TargetDeviceID)
	populate(objectMap, "targetVolumeName", c.TargetVolumeName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudApplianceConfigurationProperties.
func (c CloudApplianceConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "acsConfiguration", c.AcsConfiguration)
	populate(objectMap, "cloudPlatform", c.CloudPlatform)
	populate(objectMap, "modelNumber", c.ModelNumber)
	populate(objectMap, "supportedRegions", c.SupportedRegions)
	populate(objectMap, "supportedStorageAccountTypes", c.SupportedStorageAccountTypes)
	populate(objectMap, "supportedVmImages", c.SupportedVMImages)
	populate(objectMap, "supportedVmTypes", c.SupportedVMTypes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DNSSettings.
func (d DNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "primaryDnsServer", d.PrimaryDNSServer)
	populate(objectMap, "primaryIpv6DnsServer", d.PrimaryIPv6DNSServer)
	populate(objectMap, "secondaryDnsServers", d.SecondaryDNSServers)
	populate(objectMap, "secondaryIpv6DnsServers", d.SecondaryIPv6DNSServers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DevicePatch.
func (d DevicePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DeviceProperties.
func (d DeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "activationTime", d.ActivationTime)
	populate(objectMap, "activeController", d.ActiveController)
	populate(objectMap, "agentGroupVersion", d.AgentGroupVersion)
	populate(objectMap, "availableLocalStorageInBytes", d.AvailableLocalStorageInBytes)
	populate(objectMap, "availableTieredStorageInBytes", d.AvailableTieredStorageInBytes)
	populate(objectMap, "culture", d.Culture)
	populate(objectMap, "details", d.Details)
	populate(objectMap, "deviceConfigurationStatus", d.DeviceConfigurationStatus)
	populate(objectMap, "deviceDescription", d.DeviceDescription)
	populate(objectMap, "deviceLocation", d.DeviceLocation)
	populate(objectMap, "deviceSoftwareVersion", d.DeviceSoftwareVersion)
	populate(objectMap, "deviceType", d.DeviceType)
	populate(objectMap, "friendlyName", d.FriendlyName)
	populate(objectMap, "friendlySoftwareName", d.FriendlySoftwareName)
	populate(objectMap, "friendlySoftwareVersion", d.FriendlySoftwareVersion)
	populate(objectMap, "modelDescription", d.ModelDescription)
	populate(objectMap, "networkInterfaceCardCount", d.NetworkInterfaceCardCount)
	populate(objectMap, "provisionedLocalStorageInBytes", d.ProvisionedLocalStorageInBytes)
	populate(objectMap, "provisionedTieredStorageInBytes", d.ProvisionedTieredStorageInBytes)
	populate(objectMap, "provisionedVolumeSizeInBytes", d.ProvisionedVolumeSizeInBytes)
	populate(objectMap, "rolloverDetails", d.RolloverDetails)
	populate(objectMap, "serialNumber", d.SerialNumber)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "targetIqn", d.TargetIqn)
	populate(objectMap, "totalTieredStorageInBytes", d.TotalTieredStorageInBytes)
	populate(objectMap, "usingStorageInBytes", d.UsingStorageInBytes)
	populate(objectMap, "virtualMachineApiType", d.VirtualMachineAPIType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceProperties.
func (d *DeviceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activationTime":
			err = unpopulateTimeRFC3339(val, "ActivationTime", &d.ActivationTime)
			delete(rawMsg, key)
		case "activeController":
			err = unpopulate(val, "ActiveController", &d.ActiveController)
			delete(rawMsg, key)
		case "agentGroupVersion":
			err = unpopulate(val, "AgentGroupVersion", &d.AgentGroupVersion)
			delete(rawMsg, key)
		case "availableLocalStorageInBytes":
			err = unpopulate(val, "AvailableLocalStorageInBytes", &d.AvailableLocalStorageInBytes)
			delete(rawMsg, key)
		case "availableTieredStorageInBytes":
			err = unpopulate(val, "AvailableTieredStorageInBytes", &d.AvailableTieredStorageInBytes)
			delete(rawMsg, key)
		case "culture":
			err = unpopulate(val, "Culture", &d.Culture)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &d.Details)
			delete(rawMsg, key)
		case "deviceConfigurationStatus":
			err = unpopulate(val, "DeviceConfigurationStatus", &d.DeviceConfigurationStatus)
			delete(rawMsg, key)
		case "deviceDescription":
			err = unpopulate(val, "DeviceDescription", &d.DeviceDescription)
			delete(rawMsg, key)
		case "deviceLocation":
			err = unpopulate(val, "DeviceLocation", &d.DeviceLocation)
			delete(rawMsg, key)
		case "deviceSoftwareVersion":
			err = unpopulate(val, "DeviceSoftwareVersion", &d.DeviceSoftwareVersion)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &d.DeviceType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &d.FriendlyName)
			delete(rawMsg, key)
		case "friendlySoftwareName":
			err = unpopulate(val, "FriendlySoftwareName", &d.FriendlySoftwareName)
			delete(rawMsg, key)
		case "friendlySoftwareVersion":
			err = unpopulate(val, "FriendlySoftwareVersion", &d.FriendlySoftwareVersion)
			delete(rawMsg, key)
		case "modelDescription":
			err = unpopulate(val, "ModelDescription", &d.ModelDescription)
			delete(rawMsg, key)
		case "networkInterfaceCardCount":
			err = unpopulate(val, "NetworkInterfaceCardCount", &d.NetworkInterfaceCardCount)
			delete(rawMsg, key)
		case "provisionedLocalStorageInBytes":
			err = unpopulate(val, "ProvisionedLocalStorageInBytes", &d.ProvisionedLocalStorageInBytes)
			delete(rawMsg, key)
		case "provisionedTieredStorageInBytes":
			err = unpopulate(val, "ProvisionedTieredStorageInBytes", &d.ProvisionedTieredStorageInBytes)
			delete(rawMsg, key)
		case "provisionedVolumeSizeInBytes":
			err = unpopulate(val, "ProvisionedVolumeSizeInBytes", &d.ProvisionedVolumeSizeInBytes)
			delete(rawMsg, key)
		case "rolloverDetails":
			err = unpopulate(val, "RolloverDetails", &d.RolloverDetails)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &d.SerialNumber)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "targetIqn":
			err = unpopulate(val, "TargetIqn", &d.TargetIqn)
			delete(rawMsg, key)
		case "totalTieredStorageInBytes":
			err = unpopulate(val, "TotalTieredStorageInBytes", &d.TotalTieredStorageInBytes)
			delete(rawMsg, key)
		case "usingStorageInBytes":
			err = unpopulate(val, "UsingStorageInBytes", &d.UsingStorageInBytes)
			delete(rawMsg, key)
		case "virtualMachineApiType":
			err = unpopulate(val, "VirtualMachineAPIType", &d.VirtualMachineAPIType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverRequest.
func (f FailoverRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "targetDeviceId", f.TargetDeviceID)
	populate(objectMap, "volumeContainers", f.VolumeContainers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type HardwareComponentGroupProperties.
func (h HardwareComponentGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "components", h.Components)
	populate(objectMap, "displayName", h.DisplayName)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", h.LastUpdatedTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareComponentGroupProperties.
func (h *HardwareComponentGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "components":
			err = unpopulate(val, "Components", &h.Components)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &h.DisplayName)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTime", &h.LastUpdatedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "error", j.Error)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "kind", j.Kind)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "percentComplete", j.PercentComplete)
	populate(objectMap, "properties", j.Properties)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Job.
func (j *Job) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &j.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &j.PercentComplete)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobErrorDetails.
func (j JobErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", j.Code)
	populate(objectMap, "errorDetails", j.ErrorDetails)
	populate(objectMap, "message", j.Message)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JobErrorItem.
func (j JobErrorItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", j.Code)
	populate(objectMap, "message", j.Message)
	populate(objectMap, "recommendations", j.Recommendations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobFilter.
func (j *JobFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobType":
			err = unpopulate(val, "JobType", &j.JobType)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "backupPointInTime", j.BackupPointInTime)
	populate(objectMap, "backupType", j.BackupType)
	populate(objectMap, "dataStats", j.DataStats)
	populate(objectMap, "deviceId", j.DeviceID)
	populate(objectMap, "entityLabel", j.EntityLabel)
	populate(objectMap, "entityType", j.EntityType)
	populate(objectMap, "isCancellable", j.IsCancellable)
	populate(objectMap, "jobStages", j.JobStages)
	populate(objectMap, "jobType", j.JobType)
	populate(objectMap, "sourceDeviceId", j.SourceDeviceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupPointInTime":
			err = unpopulateTimeRFC3339(val, "BackupPointInTime", &j.BackupPointInTime)
			delete(rawMsg, key)
		case "backupType":
			err = unpopulate(val, "BackupType", &j.BackupType)
			delete(rawMsg, key)
		case "dataStats":
			err = unpopulate(val, "DataStats", &j.DataStats)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &j.DeviceID)
			delete(rawMsg, key)
		case "entityLabel":
			err = unpopulate(val, "EntityLabel", &j.EntityLabel)
			delete(rawMsg, key)
		case "entityType":
			err = unpopulate(val, "EntityType", &j.EntityType)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &j.IsCancellable)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &j.JobStages)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &j.JobType)
			delete(rawMsg, key)
		case "sourceDeviceId":
			err = unpopulate(val, "SourceDeviceID", &j.SourceDeviceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListFailoverTargetsRequest.
func (l ListFailoverTargetsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "volumeContainers", l.VolumeContainers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Manager.
func (m Manager) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagerExtendedInfo.
func (m ManagerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagerPatch.
func (m ManagerPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricData.
func (m *MetricData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "average":
			err = unpopulate(val, "Average", &m.Average)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &m.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &m.Minimum)
			delete(rawMsg, key)
		case "sum":
			err = unpopulate(val, "Sum", &m.Sum)
			delete(rawMsg, key)
		case "timeStamp":
			err = unpopulateTimeRFC3339(val, "TimeStamp", &m.TimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricFilter.
func (m *MetricFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Metrics.
func (m *Metrics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "primaryAggregation":
			err = unpopulate(val, "PrimaryAggregation", &m.PrimaryAggregation)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &m.ResourceID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &m.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkAdapterList.
func (n NetworkAdapterList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkSettingsPatch.
func (n NetworkSettingsPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", n.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleRecurrence.
func (s ScheduleRecurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "recurrenceType", s.RecurrenceType)
	populate(objectMap, "recurrenceValue", s.RecurrenceValue)
	populate(objectMap, "weeklyDaysList", s.WeeklyDaysList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecondaryDNSSettings.
func (s SecondaryDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "secondaryDnsServers", s.SecondaryDNSServers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecuritySettingsPatch.
func (s SecuritySettingsPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SendTestAlertEmailRequest.
func (s SendTestAlertEmailRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "emailList", s.EmailList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TimeSettingsProperties.
func (t TimeSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "primaryTimeServer", t.PrimaryTimeServer)
	populate(objectMap, "secondaryTimeServer", t.SecondaryTimeServer)
	populate(objectMap, "timeZone", t.TimeZone)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdatesProperties.
func (u UpdatesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isUpdateInProgress", u.IsUpdateInProgress)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", u.LastUpdatedTime)
	populate(objectMap, "maintenanceModeUpdatesAvailable", u.MaintenanceModeUpdatesAvailable)
	populate(objectMap, "regularUpdatesAvailable", u.RegularUpdatesAvailable)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdatesProperties.
func (u *UpdatesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isUpdateInProgress":
			err = unpopulate(val, "IsUpdateInProgress", &u.IsUpdateInProgress)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTime", &u.LastUpdatedTime)
			delete(rawMsg, key)
		case "maintenanceModeUpdatesAvailable":
			err = unpopulate(val, "MaintenanceModeUpdatesAvailable", &u.MaintenanceModeUpdatesAvailable)
			delete(rawMsg, key)
		case "regularUpdatesAvailable":
			err = unpopulate(val, "RegularUpdatesAvailable", &u.RegularUpdatesAvailable)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeFailoverMetadata.
func (v *VolumeFailoverMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupCreatedDate":
			err = unpopulateTimeRFC3339(val, "BackupCreatedDate", &v.BackupCreatedDate)
			delete(rawMsg, key)
		case "backupElementId":
			err = unpopulate(val, "BackupElementID", &v.BackupElementID)
			delete(rawMsg, key)
		case "backupId":
			err = unpopulate(val, "BackupID", &v.BackupID)
			delete(rawMsg, key)
		case "backupPolicyId":
			err = unpopulate(val, "BackupPolicyID", &v.BackupPolicyID)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &v.SizeInBytes)
			delete(rawMsg, key)
		case "volumeId":
			err = unpopulate(val, "VolumeID", &v.VolumeID)
			delete(rawMsg, key)
		case "volumeType":
			err = unpopulate(val, "VolumeType", &v.VolumeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeProperties.
func (v VolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessControlRecordIds", v.AccessControlRecordIDs)
	populate(objectMap, "backupPolicyIds", v.BackupPolicyIDs)
	populate(objectMap, "backupStatus", v.BackupStatus)
	populate(objectMap, "monitoringStatus", v.MonitoringStatus)
	populate(objectMap, "operationStatus", v.OperationStatus)
	populate(objectMap, "sizeInBytes", v.SizeInBytes)
	populate(objectMap, "volumeContainerId", v.VolumeContainerID)
	populate(objectMap, "volumeStatus", v.VolumeStatus)
	populate(objectMap, "volumeType", v.VolumeType)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
