//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armchanges

// ChangeAttributes - Details about the change resource
type ChangeAttributes struct {
	// READ-ONLY; The number of changes this resource captures
	ChangesCount *int64 `json:"changesCount,omitempty" azure:"ro"`

	// READ-ONLY; The ARM correlation ID of the change resource
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; The GUID of the new snapshot
	NewResourceSnapshotID *string `json:"newResourceSnapshotId,omitempty" azure:"ro"`

	// READ-ONLY; The GUID of the previous snapshot
	PreviousResourceSnapshotID *string `json:"previousResourceSnapshotId,omitempty" azure:"ro"`

	// READ-ONLY; The time the change(s) on the target resource ocurred
	Timestamp *string `json:"timestamp,omitempty" azure:"ro"`
}

// ChangeBase - An individual change on the target resource
type ChangeBase struct {
	// READ-ONLY; The entity that made the change
	ChangeCategory *ChangeCategory `json:"changeCategory,omitempty" azure:"ro"`

	// READ-ONLY; The target resource property value after the change
	NewValue *string `json:"newValue,omitempty" azure:"ro"`

	// READ-ONLY; The target resource property value before the change
	PreviousValue *string `json:"previousValue,omitempty" azure:"ro"`

	// READ-ONLY; The type of change that occurred
	PropertyChangeType *PropertyChangeType `json:"propertyChangeType,omitempty" azure:"ro"`
}

// ChangeProperties - The properties of a change
type ChangeProperties struct {
	// Details about the change resource
	ChangeAttributes *ChangeAttributes `json:"changeAttributes,omitempty"`

	// A dictionary with changed property name as a key and the change details as the value
	Changes map[string]*ChangeBase `json:"changes,omitempty"`

	// READ-ONLY; The type of change that was captured in the resource
	ChangeType *ChangeType `json:"changeType,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified ID of the target resource that was changed
	TargetResourceID *string `json:"targetResourceId,omitempty" azure:"ro"`

	// READ-ONLY; The namespace and type of the resource
	TargetResourceType *string `json:"targetResourceType,omitempty" azure:"ro"`
}

// ChangeResourceListResult - The list of resources
type ChangeResourceListResult struct {
	// The link used to get the next page of Change Resources
	NextLink *string `json:"nextLink,omitempty"`

	// The list of resources
	Value []*ChangeResourceResult `json:"value,omitempty"`
}

// ChangeResourceResult - Change Resource
type ChangeResourceResult struct {
	// The properties of a change
	Properties *ChangeProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClientGetOptions contains the optional parameters for the Client.Get method.
type ClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClientListOptions contains the optional parameters for the Client.List method.
type ClientListOptions struct {
	// (Optional) The page-continuation token
	SkipToken *string
	// (Optional) Set the maximum number of results per response.
	Top *int64
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}
