# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""debusine list view paginators."""

from debusine.db.models import CollectionItem, WorkRequest, Worker
from debusine.db.models.auth import GroupAuditLog, GroupMembership
from debusine.web.views.table import Ordering, Table


class GroupMembershipTable(Table[GroupMembership]):
    """Table set up for Group."""

    template_name = "web/_group_membership-list.html"
    default_column = "role"

    def init(self) -> None:
        """Set up the table."""
        super().init()
        self.add_column(
            "name",
            "Name",
            Ordering(
                asc=["user__username", "role"], desc=["-user__username", "role"]
            ),
        )
        self.add_column("display_name", "Display name")
        self.add_column(
            "role",
            "Role",
            Ordering(
                asc=["role", "user__username"], desc=["-role", "user__username"]
            ),
        )


class GroupAuditLogTable(Table[GroupAuditLog]):
    """Table set up for GroupAuditLog."""

    template_name = "web/_group_audit_log-list.html"
    default_column = "-date"

    def init(self) -> None:
        """Set up the table."""
        super().init()
        self.add_column("date", "Date", Ordering("created_at"))
        self.add_column(
            "actor",
            "User",
            Ordering(
                asc=["actor__username", "-created_at"],
                desc=["-actor__username", "-created_at"],
            ),
        )
        self.add_column("message", "Message")


class WorkerTable(Table[Worker]):
    """Table set up for Worker."""

    template_name = "web/_worker-list.html"
    default_column = "name"

    def init(self) -> None:
        """Set up the table."""
        super().init()
        self.add_column("type", "Type", Ordering("worker_type"))
        self.add_column("name", "Name", Ordering("name"))
        self.add_column("pool", "Pool", Ordering("worker_pool"))
        self.add_column(
            "last_seen", "Last seen", Ordering("token__last_seen_at")
        )
        self.add_column("status", "Status")


class WorkRequestTable(Table[WorkRequest]):
    """Table set up for WorkRequest."""

    template_name = "web/_work_request-list.html"
    default_column = "-created_at"

    def init(self) -> None:
        """Set up the table."""
        super().init()
        self.add_column("id", "ID", Ordering("pk"))
        self.add_column("created_at", "Created", Ordering("created_at"))
        self.add_column("task_type", "Task type", Ordering("task_type"))
        self.add_column("task_name", "Task", Ordering("task_name"))
        self.add_column("status", "Status", Ordering("status"))
        self.add_column("result", "Result", Ordering("result"))


class CollectionItemTable(Table[CollectionItem]):
    """Table set up for CollectionItem."""

    template_name = "web/_collection_item-list.html"
    default_column = "category"

    def init(self) -> None:
        """Set up the paginator."""
        super().init()
        self.add_column("category", "Category", Ordering("category"))
        self.add_column("name", "Name", Ordering("name"))
        self.add_column("created_at", "Created at", Ordering("created_at"))
