// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_TEST_BASE_SAVE_DESKTOP_SNAPSHOT_WIN_H_
#define CHROME_TEST_BASE_SAVE_DESKTOP_SNAPSHOT_WIN_H_

#include "base/files/file_path.h"

// Saves a snapshot of the desktop to a file in |output_dir|, returning the path
// to the file if created. An empty path is returned if no new snapshot is
// created.
base::FilePath SaveDesktopSnapshot(const base::FilePath& output_dir);

#endif  // CHROME_TEST_BASE_SAVE_DESKTOP_SNAPSHOT_WIN_H_
