#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

if {[info commands kanji] == {} && [info globals myScript] == {}} {
    set f [open $argv0]
    fconfigure $f -encoding iso2022-jp
    set myScript [read $f]
    close $f
    eval $myScript
    exit 0
}

proc convertAndCopy {src dstDir conv} {
    if {$conv && [info commands kanji] == {}} {
	set fin [open $src]
	fconfigure $fin -encoding iso2022-jp
	set fout [open [file join $dstDir [file tail $src]] w]
	puts -nonewline $fout [read $fin]
	close $fin
	close $fout
    } else {
	file copy -force -- $src $dstDir
    }
}

proc directoryExists {dir} {
    if {[file exists $dir]} {
	if {[file isdirectory $dir]} {
	    return 1
	}
    }
    return 0
}

proc installAllFiles {srcDir dstDir {conv false}} {
    set stat ""
    if {[directoryExists $dstDir] == 0} {
	if {[catch {file delete -force -- $dstDir} stat] == 1} {
	    Error "$B%U%!%$%k$N>C5n$K<:GT$7$^$7$?!#(B\n$B860x(B:\n\"$stat\""
	    exit 1
	}
	set stat ""
	if {[catch {file mkdir $dstDir} stat] == 1} {
	    Error "$B%G%#%l%/%H%j$N:n@.$K<:GT$7$^$7$?!#(B\n$B860x(B:\n\"$stat\""
	    exit 1
	}
	set stat ""
    }
    foreach i [glob [file join $srcDir *]] {
	if {[file isfile $i] == 0} {
	    continue
	}
	set file [file tail $i]
	set dstFile [file join $dstDir $file]
	set srcFile $i
	if {[file exists $dstFile]} {
	    showStat "$dstFile $B$r>C5nCf(B ..."
	    set stat ""
	    if {[catch {file delete -force -- $dstFile} stat] == 1} {
		Error "$B%U%!%$%k$N>C5n$K<:GT$7$^$7$?!#(B\n$B860x(B:\n\"$stat\""
		exit 1
	    }
	}
	showStat "$dstDir $B$K(B $file $B$r%3%T!<Cf(B ..."
	set stat ""
	if {[catch {convertAndCopy $srcFile $dstDir $conv} stat] == 1} {
	    Error "$B%U%!%$%k$N%3%T!<$K<:GT$7$^$7$?!#(B\n$B860x(B:\n\"$stat\""
	    exit 1
	}
    }
}

proc Error {str} {
    tk_messageBox -icon error -message $str
}

set tBg blue
set tFg white
if {[info commands kanji] != {}} {
    font create @tFont -copy defaultgui -size 24 -slant italic
    font create @dFont -copy defaultgui -size 11
} else {
    font create @tFont -family {MS Sans Serif} -size 24 -slant italic
    font create @dFont -family {MS Sans Serif} -size 11
}
option add *font @dFont 

set Title "Widget Tour $BF|K\8lHG(B $B%;%C%H%"%C%W(B"
set myHomePage "http://www.sra.co.jp/people/m-hirano/tcltkjp"

set __Debug 0
proc DebugPuts {str} {
    global __Debug
    if {$__Debug == 1} {
	if {![winfo exists .dtop]} {
	    toplevel .dtop -bo 0
	    text .dtop.t
	    pack .dtop.t
	}
	.dtop.t insert end "$str\n"
    }
}

proc forceMapIt {} {
    wm deiconify .
    update
    raise .
    update
}

bindtags . .

wm title . $Title
. conf -bg $tBg
set rootX [winfo screenwidth .]
set rootY [winfo screenheight .]
wm geom . [expr ${rootX} - 10]x[expr ${rootY} - 20]+0+0
bind . <Unmap> forceMapIt
bind . <FocusIn> forceMapIt
bind . <Destroy> {exit 1}
bind . <1> forceMapIt
bind . <2> forceMapIt
bind . <3> forceMapIt
bind . <Any-KeyPress> forceMapIt

label .l -text "${Title}" -font @tFont -bg $tBg -fg $tFg -justify left -padx 10 -pady 10
label .hl -text "Tcl/Tk 8.0 $BF|K\8l%Q%C%A$N%[!<%`%Z!<%8(B:\n\t$myHomePage" -font @tFont -bg $tBg -fg $tFg -justify left -padx 10 -pady 10
pack .l .hl -anchor nw
update
raise .
update

proc WaitCursor {path} {
    catch {$path conf -cursor watch}
    foreach i [winfo child $path] {
	WaitCursor $i
    }
}


proc RestoreCursor {path} {
    catch {$path conf -cursor ""}
    foreach i [winfo child $path] {
	RestoreCursor $i
    }
}


proc showStat {str} {
    if {![winfo exists .st]} {
	toplevel .st
	wm geom .st +0+0
	pack [text .st.l]
    }
    wm title .st $str
    .st.l insert end "${str}\n"
    .st.l see end
    raise .st
    update
}

if {[tk_messageBox -type okcancel -default ok -title $Title -message "[file join $tk_library demos.jp] $B$K%$%s%9%H!<%k$r3+;O$7$^$9!#(B"] != "ok"} {
    exit 0
}

showStat "$B%$%s%9%H!<%k$r3+;O$7$^$7$?!#(B"
WaitCursor .

installAllFiles demos.jp [file join $tk_library demos.jp] true
installAllFiles [file join $tk_library demos images] [file join $tk_library demos.jp images]

if {$tcl_platform(platform) == "windows"} {
    if {[catch {file delete -force -- [file join $tk_library demos.jp widget.tcl]} stat] ==1 } {
	Error "$B%U%!%$%k$N>C5n$K<:GT$7$^$7$?!#(B\n$B860x(B:\n\"$stat\""
	exit 1
    }
    if {[catch {file rename -force -- [file join $tk_library demos.jp widget] [file join $tk_library demos.jp widget.tcl]} stat] == 1} {
	Error "$B%U%!%$%k$NL>A0JQ99$K<:GT$7$^$7$?!#(B\n$B860x(B:\n\"$stat\""
	exit 1
    }
}

RestoreCursor .

tk_messageBox -type ok -icon info -message "$B%;%C%H%"%C%W$OL5;v$K=*N;$7$^$7$?!#(B\n$B%"%s%$%s%9%H!<%k$9$k>l9g$O!"(B\"[file join $tk_library demos.jp]\" $B%G%#%l%/%H%jA4BN$r:o=|$7$F2<$5$$!#(B"
exit 0
