# states.tcl --
#
# This demonstration script creates a listbox widget that displays
# the names of the 50 states in the United States of America.
#
# RCS: @(#) $Id: states.tcl,v 1.1 1999/03/31 15:08:41 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .states
catch {destroy $w}
toplevel $w
wm title $w "Listbox Demonstration (50 states)"
wm iconname $w "states"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"A listbox containing the 50 states is displayed below, along with a scrollbar.  You can scan the list either using the scrollbar or by scanning.  To scan, press button 2 in the widget and drag up or down." \
"$B2<$K$"$k$N$OETF;I\8)L>$,F~$C$?%9%/%m!<%k%P!<IU$N%j%9%H%\%C%/%9$G$9!#%j%9%H$r%9%/%m!<%k$5$;$k$N$O%9%/%m!<%k%P!<$G$b$G$-$^$9$7!"%j%9%H%\%C%/%9$NCf$G%^%&%9$N%\%?%s(B2 ($BCf%\%?%s(B) $B$r2!$7$?$^$^%I%i%C%0$7$F$b$G$-$^$9!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

frame $w.frame -borderwidth .5c
pack $w.frame -side top -expand yes -fill y

scrollbar $w.frame.scroll -command "$w.frame.list yview"
listbox $w.frame.list -yscroll "$w.frame.scroll set" -setgrid 1 -height 12
pack $w.frame.scroll -side right -fill y
pack $w.frame.list -side left -expand 1 -fill both

langSwitch {
$w.frame.list insert 0 Alabama Alaska Arizona Arkansas California \
    Colorado Connecticut Delaware Florida Georgia Hawaii Idaho Illinois \
    Indiana Iowa Kansas Kentucky Louisiana Maine Maryland \
    Massachusetts Michigan Minnesota Mississippi Missouri \
    Montana Nebraska Nevada "New Hampshire" "New Jersey" "New Mexico" \
    "New York" "North Carolina" "North Dakota" \
    Ohio Oklahoma Oregon Pennsylvania "Rhode Island" \
    "South Carolina" "South Dakota" \
    Tennessee Texas Utah Vermont Virginia Washington \
    "West Virginia" Wisconsin Wyoming
} {
$w.frame.list insert 0 \
	$B0&CN(B $B@D?9(B $B=)ED(B $B@P@n(B $B0q>k(B \
	$B4d<j(B $B0&I2(B $BBgJ,(B $BBg:e(B $B2,;3(B \
	$B2-Fl(B $B9a@n(B $B</;yEg(B $B?@F`@n(B $B4tIl(B \
	$B5~ET(B $B7'K\(B $B72GO(B $B9bCN(B $B:k6L(B \
	$B:42l(B $B<"2l(B $B@E2,(B $BEg:,(B $B@iMU(B \
	$BEl5~(B $BFAEg(B $BFJLZ(B $BD;<h(B $BIY;3(B \
	$BD9:j(B $BD9Ln(B $BF`NI(B $B?73c(B $BJ<8K(B \
	$B9-Eg(B $BJ!0f(B $BJ!2,(B $BJ!Eg(B $BKL3$F;(B \
	$B;0=E(B $B5\>k(B $B5\:j(B $B;37A(B $B;38}(B \
	$B;3M|(B $BOB2N;3(B
}
