# msgbox.tcl --
#
# This demonstration script creates message boxes of various type
#
# RCS: @(#) $Id: msgbox.tcl,v 1.1 1999/03/31 15:08:37 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .msgbox
catch {destroy $w}
toplevel $w
wm title $w "Message Box Demonstration"
wm iconname $w "messagebox"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"Choose the icon and type option of the message box. Then press the \"Message Box\" button to see the message box." \
"$B%a%C%;!<%8%\%C%/%9$N%"%$%3%s$H<oN`$rA*$s$G(B \"$B%a%C%;!<%8%\%C%/%9(B\" $B%\%?%s$r2!$9$H$=$N%a%C%;!<%8%\%C%/%9$,I=<($5$l$^$9!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
button $w.buttons.vars -text [langSel "Message Box" "$B%a%C%;!<%8%\%C%/%9(B"]  \
    -command "showMessageBox $w"
pack $w.buttons.dismiss $w.buttons.code $w.buttons.vars -side left -expand 1

frame $w.left 
frame $w.right
pack $w.left $w.right -side left -expand yes -fill y  -pady .5c -padx .5c

label $w.left.label -text [langSel "Icon" "$B%"%$%3%s(B"]
frame $w.left.sep -relief ridge -bd 1 -height 2
pack $w.left.label -side top
pack $w.left.sep -side top -fill x -expand no

set msgboxIcon info
foreach i {error info question warning} {
    radiobutton $w.left.b$i -text $i -variable msgboxIcon \
	-relief flat -value $i -width 16 -anchor w
    pack $w.left.b$i  -side top -pady 2 -anchor w -fill x
}

label $w.right.label -text [langSel "Type" "$B<oN`(B"]
frame $w.right.sep -relief ridge -bd 1 -height 2
pack $w.right.label -side top
pack $w.right.sep -side top -fill x -expand no

set msgboxType ok
foreach t {abortretryignore ok okcancel retrycancel yesno yesnocancel} {
    radiobutton $w.right.$t -text $t -variable msgboxType \
	-relief flat -value $t -width 16 -anchor w
    pack $w.right.$t -side top -pady 2 -anchor w -fill x
}

proc showMessageBox {w} {
    global msgboxIcon msgboxType
    set button [tk_messageBox -icon $msgboxIcon -type $msgboxType \
	-title Message -parent $w\
	-message [langSel \
	"This is a \"$msgboxType\" type messagebox with the \"$msgboxIcon\" icon" \
	"$B$3$l$O(B \"$msgboxIcon\" $B%"%$%3%s$G(B \"$msgboxType\" $B%?%$%W$N%a%C%;!<%8%\%C%/%9$G$9!#(B"]]
    
    tk_messageBox -icon info -message [langSel \
	"You have selected \"$button\"" \
	"\"$button\" $B$rA*$S$^$7$?(B"] -type ok\
	-parent $w
}
