# filebox.tcl --
#
# This demonstration script prompts the user to select a file.
#
# RCS: @(#) $Id: filebox.tcl,v 1.1 1999/03/31 15:08:30 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .filebox
catch {destroy $w}
toplevel $w
wm title $w "File Selection Dialogs"
wm iconname $w "filebox"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"Enter a file name in the entry box or click on the \"Browse\" buttons to select a file name using the file selection dialog." \
"$B%(%s%H%j$K%U%!%$%kL>$rF~NO$9$k$+!"(B\"$BA*Br(B\"$B%\%?%s$r2!$7$F%U%!%$%kA*Br%@%$%"%m%0$G%U%!%$%kL>$rA*Br$7$F$/$@$5$$!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

foreach i {open save} {
    set f [frame $w.$i]
    label $f.lab -text [langSel \
	    "Select a file to $i: " \
	    [if {$i == "open"} {concat "$B3+$/%U%!%$%k(B: "} else {concat "$BJ]B8$9$k%U%!%$%k(B: "}]] \
	    -anchor e
    entry $f.ent -width 20
    button $f.but -text [langSel "Browse ..." "$BA*Br(B ..."] -command "fileDialog $w $f.ent $i"
    pack $f.lab -side left
    pack $f.ent -side left -expand yes -fill x
    pack $f.but -side left
    pack $f -fill x -padx 1c -pady 3
}

if ![string compare $tcl_platform(platform) unix] {
    checkbutton $w.strict -text [langSel "Use Motif Style Dialog" "Motif $BIw%@%$%"%m%0$r;HMQ(B"] \
	-variable tk_strictMotif -onvalue 1 -offvalue 0
    pack $w.strict -anchor c
}

proc fileDialog {w ent operation} {
    #   Type names		Extension(s)	Mac File Type(s)
    #
    #---------------------------------------------------------
    set types [langSel {
	{"Text files"		{.txt .doc}	}
	{"Text files"		{}		TEXT}
	{"Tcl Scripts"		{.tcl}		TEXT}
	{"C Source Files"	{.c .h}		}
	{"All Source Files"	{.tcl .c .h}	}
	{"Image Files"		{.gif}		}
	{"Image Files"		{.jpeg .jpg}	}
	{"Image Files"		""		{GIFF JPEG}}
	{"All files"		*}
    } {
	{"$B%F%-%9%H%U%!%$%k(B"	{.txt .doc}	}
	{"$B%F%-%9%H%U%!%$%k(B"	{}		TEXT}
	{"Tcl $B%9%/%j%W%H(B"	{.tcl}		TEXT}
	{"C $B%=!<%9%U%!%$%k(B"	{.c .h}		}
	{"$BA4$F$N%=!<%9%U%!%$%k(B"	{.tcl .c .h}	}
	{"$B2hA|%U%!%$%k(B"		{.gif}		}
	{"$B2hA|%U%!%$%k(B"		{.jpeg .jpg}	}
	{"$B2hA|%U%!%$%k(B"		""		{GIFF JPEG}}
	{"$BA4$F$N%U%!%$%k(B"	*}
    }]
    if {$operation == "open"} {
	set file [tk_getOpenFile -filetypes $types -parent $w]
    } else {
	set file [tk_getSaveFile -filetypes $types -parent $w \
	    -initialfile Untitled -defaultextension .txt]
    }
    if [string compare $file ""] {
	$ent delete 0 end
	$ent insert 0 $file
	$ent xview end
    }
}
