# entry2.tcl --
#
# This demonstration script is the same as the entry1.tcl script
# except that it creates scrollbars for the entries.
#
# RCS: @(#) $Id: entry2.tcl,v 1.1 1999/03/31 15:08:30 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .entry2
catch {destroy $w}
toplevel $w
wm title $w "Entry Demonstration (with scrollbars)"
wm iconname $w "entry2"
positionWindow $w

label $w.msg -font $font -wraplength 5i -justify left -text [langSel \
"Three different entries are displayed below, with a scrollbar for each entry.  You can add characters by pointing, clicking and typing.  The normal Motif editing characters are supported, along with many Emacs bindings.  For example, Backspace and Control-h delete the character to the left of the insertion cursor and Delete and Control-d delete the chararacter to the right of the insertion cursor.  For entries that are too large to fit in the window all at once, you can scan through the entries with the scrollbars, or by dragging with mouse button2 pressed." \
[concat "3$B<oN`$N0[$J$k%(%s%H%j$,3F!9%9%/%m!<%k%P!<IU$GI=<($5$l$F$$$^$9!#J8;z$rF~NO$9$k$K$O%]%$%s%?$r;}$C$F9T$-!"%/%j%C%/$7$F$+$i%?%$%W$7$F$/$@$5$$!#I8=`E*$J(B Motif $B$NJT=85!G=$,!"(B Emacs $B$N%-!<%P%$%s%I$H$H$b$K%5%]!<%H$5$l$F$$$^$9!#Nc$($P!"%P%C%/%9%Z!<%9$H%3%s%H%m!<%k(B-H $B$O%+!<%=%k$N:8$NJ8;z$r:o=|$7!"%G%j!<%H%-!<$H%3%s%H%m!<%k(B-D $B$O%+!<%=%k$N1&B&$NJ8;z$r:o=|$7$^$9!#D92a$.$F%&%#%s%I%&$KF~$j@Z$i$J$$$b$N$O!"%^%&%9$N%\%?%s(B2 $B$r2!$7$?$^$^%I%i%C%0$9$k$3$H$G%9%/%m!<%k$5$;$k$3$H$,$G$-$^$9!#(B" \
[jp&orig "UNIX $BHG$G$O(B kinput $B%W%m%H%3%k!"$^$?$O(B XIM $B%W%m%H%3%k$r%5%]!<%H$7$?2>L>4A;zJQ49%U%m%s%H%(%s%I%W%m%;%C%5$rMQ$$$FF|K\8l$rF~NO$9$k$3$H$,$G$-$^$9!#JQ49%-!<$O(B X $B%j%=!<%9%G!<%?%Y!<%9$G;XDj$7$^$9!#(BWindows$BHG$G$O(B IME $B$r;H$C$F$=$N>lJQ49$GF|K\8l$rF~NO$9$k$3$H$,$G$-$^$9!#(B" ""]]]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

frame $w.frame -borderwidth 10
pack $w.frame -side top -fill x -expand 1

entry $w.frame.e1 -xscrollcommand "$w.frame.s1 set"
scrollbar $w.frame.s1 -relief sunken -orient horiz -command \
	"$w.frame.e1 xview"
frame $w.frame.spacer1 -width 20 -height 10
entry $w.frame.e2 -xscrollcommand "$w.frame.s2 set"
scrollbar $w.frame.s2 -relief sunken -orient horiz -command \
	"$w.frame.e2 xview"
frame $w.frame.spacer2 -width 20 -height 10
entry $w.frame.e3 -xscrollcommand "$w.frame.s3 set"
scrollbar $w.frame.s3 -relief sunken -orient horiz -command \
	"$w.frame.e3 xview"
pack $w.frame.e1 $w.frame.s1 $w.frame.spacer1 $w.frame.e2 $w.frame.s2 \
	$w.frame.spacer2 $w.frame.e3 $w.frame.s3 -side top -fill x

langSwitch {
$w.frame.e1 insert 0 "Initial value"
$w.frame.e2 insert end "This entry contains a long value, much too long "
$w.frame.e2 insert end "to fit in the window at one time, so long in fact "
$w.frame.e2 insert end "that you'll have to scan or scroll to see the end."
} {
$w.frame.e1 insert 0 "$B=i4|CM(B"
$w.frame.e2 insert end "$B$3$N%(%s%H%j$K$OD9$$J8;zNs$,F~$C$F$$$F!"(B"
$w.frame.e2 insert end "$BD9$9$.$F%&%#%s%I%&$K$OF~$j@Z$i$J$$$N$G!"(B"
$w.frame.e2 insert end "$B<B:]$N=j=*$j$^$G8+$k$K$O%9%/%m!<%k$5$;$J$1$l$P(B"
$w.frame.e2 insert end "$B$J$i$J$$$G$7$g$&!#(B"
}
