# clrpick.tcl --
#
# This demonstration script prompts the user to select a color.
#
# RCS: @(#) $Id: clrpick.tcl,v 1.1 1999/03/31 15:08:27 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .clrpick
catch {destroy $w}
toplevel $w
wm title $w "Color Selection Dialog"
wm iconname $w "colors"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"Press the buttons below to choose the foreground and background colors for the widgets in this window." \
"$B2<$N%\%?%s$r2!$7$F!"$3$N%&%#%s%I%&$N%&%#%8%'%C%H$NA07J?'$*$h$SGX7J?'$rA*$s$G$/$@$5$$!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

button $w.back -text [langSel "Set background color ..." "$BGX7J?'$r@_Dj(B ..."] \
    -command \
    "setColor $w $w.back background {-background -highlightbackground}"
button $w.fore -text [langSel "Set foreground color ..." "$BA07J?'$r@_Dj(B ..."] \
    -command \
    "setColor $w $w.back foreground -foreground"

pack $w.back $w.fore -side top -anchor c -pady 2m

proc setColor {w button name options} {
    grab $w
    set initialColor [$button cget -$name]
    set color [tk_chooseColor -title "Choose a $name color" -parent $w \
	-initialcolor $initialColor]
    if [string compare $color ""] {
	setColor_helper $w $options $color
    }
    grab release $w
}

proc setColor_helper {w options color} {
    foreach option $options {
	catch {
	    $w config $option $color
	}
    }
    foreach child [winfo children $w] {
	setColor_helper $child $options $color
    }
}
