/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.List;
import java.util.Set;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service7ServiceVsSuperInterface;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceSuperInterface3;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@RunWith(value=MockitoJUnitRunner.class)
public class MockBundleContextServiceVsSuperinterfaceTest {
    private BundleContext bundleContext;
    @Mock
    private ServiceInterface3 service1;
    @Mock
    private ServiceInterface3 service2;
    @Mock
    private ServiceSuperInterface3 superInterface1;
    @Mock
    private ServiceSuperInterface3 superInterface2;

    @Before
    public void setUp() {
        this.bundleContext = MockOsgi.newBundleContext();
    }

    @Test
    public void testServiceRegistration() {
        ServiceRegistration regService1 = this.bundleContext.registerService(ServiceInterface3.class, (Object)this.service1, null);
        ServiceRegistration regSuperInterface1 = this.bundleContext.registerService(ServiceSuperInterface3.class, (Object)this.superInterface1, null);
        Service7ServiceVsSuperInterface service = new Service7ServiceVsSuperInterface();
        MockOsgi.injectServices((Object)service, (BundleContext)this.bundleContext);
        MockOsgi.activate((Object)service, (BundleContext)this.bundleContext);
        this.bundleContext.registerService(Service7ServiceVsSuperInterface.class, (Object)service, null);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getInterfaceDirectList(), this.service1);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getInterfaceBindList(), this.service1);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getSuperInterfaceDirectList(), this.superInterface1);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getSuperInterfaceBindList(), this.superInterface1);
        this.bundleContext.registerService(ServiceInterface3.class, (Object)this.service2, null);
        this.bundleContext.registerService(ServiceSuperInterface3.class, (Object)this.superInterface2, null);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getInterfaceDirectList(), this.service1, this.service2);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getInterfaceBindList(), this.service1, this.service2);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getSuperInterfaceDirectList(), this.superInterface1, this.superInterface2);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getSuperInterfaceBindList(), this.superInterface1, this.superInterface2);
        regService1.unregister();
        regSuperInterface1.unregister();
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getInterfaceDirectList(), this.service2);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getInterfaceBindList(), this.service2);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getSuperInterfaceDirectList(), this.superInterface2);
        MockBundleContextServiceVsSuperinterfaceTest.assertDeps(service.getSuperInterfaceBindList(), this.superInterface2);
    }

    @SafeVarargs
    private static void assertDeps(List<?> actual, Object ... expected) {
        Assert.assertEquals(Set.of(expected), Set.copyOf(actual));
    }
}

