/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers.stateful;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.runtime.dto.AuthType;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.helper.AbstractIterator;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverControl;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.stateful.AuthenticatedResourceProvider;
import org.apache.sling.resourceresolver.impl.providers.stateful.BasicResolveContext;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderManager {
    private static final Logger logger = LoggerFactory.getLogger(ProviderManager.class);
    private final ResourceResolver resolver;
    private final Map<ResourceProviderHandler, AuthenticatedResourceProvider> contextMap;
    private final List<AuthenticatedResourceProvider> authenticated = new ArrayList<AuthenticatedResourceProvider>();
    private final List<AuthenticatedResourceProvider> modifiable = new ArrayList<AuthenticatedResourceProvider>();
    private final List<AuthenticatedResourceProvider> refreshable = new ArrayList<AuthenticatedResourceProvider>();
    private final ResourceAccessSecurityTracker tracker;

    public ProviderManager(@NotNull ResourceResolver resolver, @NotNull ResourceAccessSecurityTracker tracker) {
        this.contextMap = new IdentityHashMap<ResourceProviderHandler, AuthenticatedResourceProvider>();
        this.resolver = resolver;
        this.tracker = tracker;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public AuthenticatedResourceProvider getOrCreateProvider(@NotNull ResourceProviderHandler handler, @NotNull ResourceResolverControl control) throws LoginException {
        provider = this.contextMap.get(handler);
        if (provider == null) {
            resourceProvider = handler.useResourceProvider();
            if (resourceProvider != null) {
                try {
                    provider = this.authenticate(handler, resourceProvider, control);
                    this.contextMap.put(handler, provider);
                    if (handler.getInfo().getAuthType() != AuthType.lazy && handler.getInfo().getAuthType() != AuthType.required) ** GOTO lbl19
                    control.registerAuthenticatedProvider(handler, provider.getResolveContext().getProviderState());
                }
                catch (LoginException le) {
                    ProviderManager.logger.debug("Authentication to resource provider " + resourceProvider + " failed: " + le.getMessage(), (Throwable)le);
                    this.contextMap.put(handler, AuthenticatedResourceProvider.UNAUTHENTICATED_PROVIDER);
                    throw le;
                }
            } else {
                this.contextMap.put(handler, AuthenticatedResourceProvider.UNAUTHENTICATED_PROVIDER);
            }
        }
lbl19:
        // 5 sources

        return provider == AuthenticatedResourceProvider.UNAUTHENTICATED_PROVIDER ? null : provider;
    }

    @Nullable
    public ResolveContext<Object> getOrCreateResolveContext(@NotNull ResourceProviderHandler handler, @NotNull ResourceResolverControl control) throws LoginException {
        AuthenticatedResourceProvider provider = this.getOrCreateProvider(handler, control);
        return provider == null ? null : provider.getResolveContext();
    }

    public void authenticateAll(@NotNull List<ResourceProviderHandler> handlers, @NotNull ResourceResolverControl control) throws LoginException {
        for (ResourceProviderHandler h : handlers) {
            try {
                this.getOrCreateProvider(h, control);
            }
            catch (LoginException le) {
                for (Map.Entry<ResourceProviderHandler, AuthenticatedResourceProvider> entry : this.contextMap.entrySet()) {
                    ResourceProvider<Object> provider;
                    if (entry.getValue() == AuthenticatedResourceProvider.UNAUTHENTICATED_PROVIDER || (provider = entry.getKey().getResourceProvider()) == null) continue;
                    provider.logout(entry.getValue().getResolveContext().getProviderState());
                }
                this.contextMap.clear();
                control.clearAuthenticatedProviders();
                throw le;
            }
        }
    }

    @NotNull
    private AuthenticatedResourceProvider authenticate(@NotNull ResourceProviderHandler handler, @NotNull ResourceProvider<Object> provider, @NotNull ResourceResolverControl control) throws LoginException {
        boolean isAuthenticated = false;
        Object contextData = null;
        if (handler.getInfo().getAuthType() == AuthType.required || handler.getInfo().getAuthType() == AuthType.lazy) {
            try {
                contextData = provider.authenticate(control.getAuthenticationInfo());
                isAuthenticated = true;
            }
            catch (LoginException le) {
                logger.debug("Unable to login into resource provider " + provider, (Throwable)le);
                throw le;
            }
        }
        BasicResolveContext<Object> context = new BasicResolveContext<Object>(this.resolver, this, control, contextData, ResourceUtil.getParent((String)handler.getInfo().getPath()));
        AuthenticatedResourceProvider rp = new AuthenticatedResourceProvider(handler, handler.getInfo().getUseResourceAccessSecurity(), context, this.tracker);
        if (isAuthenticated) {
            this.authenticated.add(rp);
        }
        if (handler.getInfo().isModifiable()) {
            this.modifiable.add(rp);
        }
        if (handler.getInfo().isRefreshable()) {
            this.refreshable.add(rp);
        }
        return rp;
    }

    public Collection<AuthenticatedResourceProvider> getAllAuthenticated() {
        return new ArrayList<AuthenticatedResourceProvider>(this.authenticated);
    }

    public Collection<AuthenticatedResourceProvider> getAllUsedModifiable() {
        return new ArrayList<AuthenticatedResourceProvider>(this.modifiable);
    }

    public Collection<AuthenticatedResourceProvider> getAllUsedRefreshable() {
        return new ArrayList<AuthenticatedResourceProvider>(this.refreshable);
    }

    public Iterable<AuthenticatedResourceProvider> getAllBestEffort(@NotNull List<ResourceProviderHandler> handlers, final @NotNull ResourceResolverControl control) {
        final Iterator<ResourceProviderHandler> handlerIter = handlers.iterator();
        return new Iterable<AuthenticatedResourceProvider>(){

            @Override
            public Iterator<AuthenticatedResourceProvider> iterator() {
                return new AbstractIterator<AuthenticatedResourceProvider>(){

                    @Override
                    protected AuthenticatedResourceProvider seek() {
                        AuthenticatedResourceProvider result = null;
                        while (result == null && handlerIter.hasNext()) {
                            ResourceProviderHandler h = (ResourceProviderHandler)handlerIter.next();
                            try {
                                result = ProviderManager.this.getOrCreateProvider(h, control);
                            }
                            catch (LoginException loginException) {}
                        }
                        return result;
                    }
                };
            }
        };
    }
}

