/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers;

import org.apache.sling.api.resource.runtime.dto.AuthType;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.ServiceReference;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceProviderInfo
implements Comparable<ResourceProviderInfo> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceProviderInfo.class);
    private final ServiceReference<ResourceProvider> ref;
    private final String path;
    private final String name;
    private final boolean useResourceAccessSecurity;
    private final AuthType authType;
    private final boolean modifiable;
    private final boolean adaptable;
    private final boolean refreshable;
    private final boolean attributable;
    private final Mode mode;

    public ResourceProviderInfo(ServiceReference<ResourceProvider> ref) {
        Converter c = Converters.standardConverter();
        this.ref = ref;
        this.path = (String)((Converting)c.convert(ref.getProperty("provider.root")).defaultValue((Object)"")).to(String.class);
        this.name = (String)c.convert(ref.getProperty("provider.name")).to(String.class);
        this.useResourceAccessSecurity = (Boolean)c.convert(ref.getProperty("provider.useResourceAccessSecurity")).to(Boolean.TYPE);
        String authType = (String)((Converting)c.convert(ref.getProperty("provider.authenticate")).defaultValue((Object)AuthType.no.name())).to(String.class);
        AuthType aType = null;
        try {
            aType = AuthType.valueOf((String)authType);
        }
        catch (IllegalArgumentException iae) {
            logger.error("Illegal auth type {} for resource provider {} ({})", new Object[]{authType, this.name, ref});
        }
        this.authType = aType;
        this.modifiable = (Boolean)c.convert(ref.getProperty("provider.modifiable")).to(Boolean.TYPE);
        this.adaptable = (Boolean)c.convert(ref.getProperty("provider.adaptable")).to(Boolean.TYPE);
        this.refreshable = (Boolean)c.convert(ref.getProperty("provider.refreshable")).to(Boolean.TYPE);
        this.attributable = (Boolean)c.convert(ref.getProperty("provider.attributable")).to(Boolean.TYPE);
        String modeValue = ((String)((Converting)c.convert(ref.getProperty("provider.mode")).defaultValue((Object)"overlay")).to(String.class)).toUpperCase();
        Mode mode = null;
        try {
            mode = Mode.valueOf(modeValue);
        }
        catch (IllegalArgumentException iae) {
            logger.error("Illegal mode {} for resource provider {} ({})", new Object[]{modeValue, this.name, ref});
        }
        this.mode = mode;
        if (!this.path.startsWith("/")) {
            logger.error("Path {} does not start with / for resource provider {} ({})", new Object[]{this.path, this.name, ref});
        }
    }

    public boolean isValid() {
        if (!this.path.startsWith("/")) {
            logger.debug("ResourceProvider path does not start with /, invalid: {}", (Object)this.path);
            return false;
        }
        if (this.authType == null) {
            logger.debug("ResourceProvider has null authType, invalid");
            return false;
        }
        if (this.mode == null) {
            logger.debug("ResourceProvider has null mode, invalid");
            return false;
        }
        return true;
    }

    public ServiceReference<ResourceProvider> getServiceReference() {
        return this.ref;
    }

    public String getPath() {
        return this.path;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public int compareTo(ResourceProviderInfo o) {
        int result = this.path.compareTo(o.path);
        if (result == 0) {
            result = o.ref.compareTo(this.ref);
        }
        return result;
    }

    public String toString() {
        return "ResourceProviderInfo [ref=" + this.ref + ", path=" + this.path + ", useResourceAccessSecurity=" + this.useResourceAccessSecurity + ", authType=" + this.authType + ", modifiable=" + this.modifiable + "]";
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isAdaptable() {
        return this.adaptable;
    }

    public boolean isRefreshable() {
        return this.refreshable;
    }

    public boolean isAttributable() {
        return this.attributable;
    }

    public String getName() {
        return this.name;
    }

    public boolean getUseResourceAccessSecurity() {
        return this.useResourceAccessSecurity;
    }

    public static enum Mode {
        OVERLAY,
        PASSTHROUGH;

    }
}

