/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers;

import org.apache.sling.resourceresolver.impl.providers.ProviderContextImpl;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderInfo;
import org.apache.sling.resourceresolver.impl.providers.tree.Pathable;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;

public class ResourceProviderHandler
implements Comparable<ResourceProviderHandler>,
Pathable {
    private final ProviderContextImpl context = new ProviderContextImpl();
    private final ResourceProviderInfo info;
    private final ResourceProvider<Object> provider;
    private volatile boolean isUsed = false;

    public ResourceProviderHandler(ResourceProviderInfo info, ResourceProvider<Object> provider) {
        this.info = info;
        this.provider = provider;
    }

    public ResourceProviderInfo getInfo() {
        return this.info;
    }

    public void activate() {
        this.provider.start((ProviderContext)this.context);
        this.isUsed = false;
    }

    public void deactivate() {
        this.provider.stop();
        this.context.update(null, null);
        this.isUsed = false;
    }

    public ResourceProvider<Object> getResourceProvider() {
        return this.provider;
    }

    public ResourceProvider<Object> useResourceProvider() {
        this.isUsed = true;
        return this.provider;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    @Override
    public int compareTo(ResourceProviderHandler o) {
        ResourceProviderInfo localInfo = this.info;
        ResourceProviderInfo otherInfo = o.info;
        if (localInfo == null) {
            if (otherInfo == null) {
                return 0;
            }
            return 1;
        }
        if (otherInfo == null) {
            return -1;
        }
        return localInfo.compareTo(otherInfo);
    }

    @Override
    public String getPath() {
        return this.getInfo().getPath();
    }

    public void update() {
        this.provider.update(3L);
    }

    public ProviderContextImpl getProviderContext() {
        return this.context;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "# provider: " + this.provider + " ]";
    }
}

