/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.jacksonexporter.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.jacksonexporter.impl.JacksonExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public interface WarningResourceResolverMixin
extends ResourceResolver {
    public static final String MESSAGE = "A ResourceResolver is serialized with all its private fields containing implementation details you should not disclose. Please review your Sling Model implementation(s) and remove all public accessors to a ResourceResolver.";
    public static final Logger LOG = LoggerFactory.getLogger(JacksonExporter.class);

    @JsonSerialize(using=WarningBooleanSerializer.class)
    public boolean isLive();

    public static class WarningBooleanSerializer
    extends JsonSerializer<Boolean> {
        public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            LOG.warn(WarningResourceResolverMixin.MESSAGE);
            jgen.writeObject((Object)value);
        }
    }
}

