/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.junit.TestObjectProcessor;
import org.apache.sling.junit.annotations.TestReference;
import org.apache.sling.junit.impl.ServiceGetter;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AnnotationsProcessor
implements TestObjectProcessor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private BundleContext bundleContext;
    private Map<Object, List<ServiceGetter<?>>> map;

    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        this.map = new IdentityHashMap();
        if (this.bundleContext == null) {
            throw new IllegalArgumentException("Null BundleContext in activate()");
        }
        this.log.debug("{} activated, BundleContext={}", (Object)this, (Object)this.bundleContext);
    }

    protected void deactivate(ComponentContext ctx) {
        this.bundleContext = null;
        this.log.debug("{} deactivated", (Object)this);
        for (Map.Entry<Object, List<ServiceGetter<?>>> entry : this.map.entrySet()) {
            this.cleanupTest(entry.getKey());
        }
        this.map.clear();
    }

    @Override
    public Object process(Object testObject) throws Exception {
        this.log.debug("processing {}", testObject);
        this.map.put(testObject, new ArrayList());
        for (Field f : testObject.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(TestReference.class)) continue;
            this.processTestReference(testObject, f);
        }
        return testObject;
    }

    public void cleanupTest(Object test) {
        List<ServiceGetter<?>> serviceGetters = this.map.remove(test);
        for (int i = 0; i < serviceGetters.size(); ++i) {
            serviceGetters.get(i).close();
        }
    }

    private void processTestReference(Object testObject, Field f) throws Exception {
        if (this.bundleContext == null) {
            String msg = "Null BundleContext in processTestReference(), not activated?";
            this.log.error("Null BundleContext in processTestReference(), not activated?");
            throw new IllegalArgumentException("Null BundleContext in processTestReference(), not activated?");
        }
        Class<?> serviceType = f.getType();
        Annotation[] testReferences = f.getDeclaredAnnotations();
        if (Objects.nonNull(testReferences) && testReferences.length != 0) {
            TestReference testReference = (TestReference)testReferences[0];
            Object service = this.getService(serviceType, testReference.target(), testObject);
            if (service != null) {
                f.setAccessible(true);
                f.set(testObject, service);
                this.log.debug("Injected service {} into field {}", (Object)serviceType.getName(), (Object)f.getName());
            } else {
                this.log.warn("Service {} not found for field {}", (Object)serviceType.getName(), (Object)f.getName());
            }
        }
    }

    private Object getService(Class<?> c, String target, Object testObj) {
        Object result = null;
        ServiceGetter<?> serviceGetter = ServiceGetter.create(this.bundleContext, c, target);
        result = serviceGetter.getService();
        this.map.get(testObj).add(serviceGetter);
        return result;
    }
}

